/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.ir.backend.js

import ksp.org.jetbrains.kotlin.backend.common.PreSerializationLoweringContext
import ksp.org.jetbrains.kotlin.backend.common.ir.KlibSharedVariablesManager
import ksp.org.jetbrains.kotlin.backend.common.ir.PreSerializationJsSymbols
import ksp.org.jetbrains.kotlin.config.CompilerConfiguration
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter
import ksp.org.jetbrains.kotlin.ir.IrBuiltIns

class JsPreSerializationLoweringContext(
    irBuiltIns: IrBuiltIns,
    configuration: CompilerConfiguration,
    diagnosticReporter: DiagnosticReporter,
) : PreSerializationLoweringContext(irBuiltIns, configuration, diagnosticReporter) {
    override val symbols: PreSerializationJsSymbols by lazy {
        PreSerializationJsSymbols.Impl(irBuiltIns)
    }

    override val sharedVariablesManager by lazy { KlibSharedVariablesManager(symbols) }
}
