/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.psi.stubs.elements;

import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.psi.stubs.StubInputStream;
import ksp.com.intellij.psi.stubs.StubOutputStream;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.psi.KtElementImplStub;
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import ksp.org.jetbrains.kotlin.psi.stubs.impl.KotlinPlaceHolderStubImpl;

import java.io.IOException;

public class KtPlaceHolderStubElementType<T extends KtElementImplStub<? extends StubElement<?>>> extends
                                                                                                 KtStubElementType<KotlinPlaceHolderStubImpl<T>, T> {
    public KtPlaceHolderStubElementType(@NotNull @NonNls String debugName, @NotNull Class<T> psiClass) {
        super(debugName, psiClass, KotlinPlaceHolderStub.class);
    }

    @NotNull
    @Override
    public KotlinPlaceHolderStubImpl<T> createStub(@NotNull T psi, StubElement<?> parentStub) {
        return new KotlinPlaceHolderStubImpl<>(parentStub, this);
    }

    @Override
    public void serialize(@NotNull KotlinPlaceHolderStubImpl<T> stub, @NotNull StubOutputStream dataStream) throws IOException {
        //do nothing
    }

    @NotNull
    @Override
    public KotlinPlaceHolderStubImpl<T> deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        return new KotlinPlaceHolderStubImpl<>(parentStub, this);
    }
}
