/*
 * Copyright 2010-2020 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.resolve.calls.checkers

import ksp.com.intellij.psi.PsiElement
import ksp.org.jetbrains.kotlin.descriptors.ConstructorDescriptor
import ksp.org.jetbrains.kotlin.descriptors.Modality
import ksp.org.jetbrains.kotlin.diagnostics.Errors.CREATING_AN_INSTANCE_OF_ABSTRACT_CLASS
import ksp.org.jetbrains.kotlin.diagnostics.reportDiagnosticOnce
import ksp.org.jetbrains.kotlin.resolve.calls.util.isSuperOrDelegatingConstructorCall
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall

object AbstractClassInstantiationChecker : CallChecker {
    override fun check(resolvedCall: ResolvedCall<*>, reportOn: PsiElement, context: CallCheckerContext) {
        val candidateDescriptor = resolvedCall.candidateDescriptor
        val call = resolvedCall.call

        if (candidateDescriptor is ConstructorDescriptor &&
            !isSuperOrDelegatingConstructorCall(call)
        ) {
            if (candidateDescriptor.constructedClass.modality == Modality.ABSTRACT) {
                context.trace.reportDiagnosticOnce(CREATING_AN_INSTANCE_OF_ABSTRACT_CLASS.on(call.callElement))
            }
        }
    }
}