package com.google.devtools.ksp.processing

fun kspJsArgParser(args: Array<String>): Pair<KSPJsConfig, List<String>> {
  val processorClasspath = mutableListOf<String>()
  return Pair(KSPJsConfig.Builder().apply {
    var i = 0
    while (i < args.size) {
      val arg = args[i++]
      when {
        arg == "-backend" -> backend = parseString(getArg(args, i++))
        arg.startsWith("-backend=") -> backend = parseString(arg.substring(9))
        arg == "-module-name" -> moduleName = parseString(getArg(args, i++))
        arg.startsWith("-module-name=") -> moduleName = parseString(arg.substring(13))
        arg == "-source-roots" -> sourceRoots = parseList(getArg(args, i++), ::parseFile)
        arg.startsWith("-source-roots=") -> sourceRoots = parseList(arg.substring(14), ::parseFile)
        arg == "-common-source-roots" -> commonSourceRoots = parseList(getArg(args, i++), ::parseFile)
        arg.startsWith("-common-source-roots=") -> commonSourceRoots = parseList(arg.substring(21), ::parseFile)
        arg == "-libraries" -> libraries = parseList(getArg(args, i++), ::parseFile)
        arg.startsWith("-libraries=") -> libraries = parseList(arg.substring(11), ::parseFile)
        arg == "-friends" -> friends = parseList(getArg(args, i++), ::parseFile)
        arg.startsWith("-friends=") -> friends = parseList(arg.substring(9), ::parseFile)
        arg == "-processor-options" -> processorOptions = parseMap(getArg(args, i++), ::parseString)
        arg.startsWith("-processor-options=") -> processorOptions = parseMap(arg.substring(19), ::parseString)
        arg == "-project-base-dir" -> projectBaseDir = parseFile(getArg(args, i++))
        arg.startsWith("-project-base-dir=") -> projectBaseDir = parseFile(arg.substring(18))
        arg == "-output-base-dir" -> outputBaseDir = parseFile(getArg(args, i++))
        arg.startsWith("-output-base-dir=") -> outputBaseDir = parseFile(arg.substring(17))
        arg == "-caches-dir" -> cachesDir = parseFile(getArg(args, i++))
        arg.startsWith("-caches-dir=") -> cachesDir = parseFile(arg.substring(12))
        arg == "-class-output-dir" -> classOutputDir = parseFile(getArg(args, i++))
        arg.startsWith("-class-output-dir=") -> classOutputDir = parseFile(arg.substring(18))
        arg == "-kotlin-output-dir" -> kotlinOutputDir = parseFile(getArg(args, i++))
        arg.startsWith("-kotlin-output-dir=") -> kotlinOutputDir = parseFile(arg.substring(19))
        arg == "-resource-output-dir" -> resourceOutputDir = parseFile(getArg(args, i++))
        arg.startsWith("-resource-output-dir=") -> resourceOutputDir = parseFile(arg.substring(21))
        arg == "-incremental" -> incremental = parseBoolean(getArg(args, i++))
        arg.startsWith("-incremental=") -> incremental = parseBoolean(arg.substring(13))
        arg == "-incremental-log" -> incrementalLog = parseBoolean(getArg(args, i++))
        arg.startsWith("-incremental-log=") -> incrementalLog = parseBoolean(arg.substring(17))
        arg == "-modified-sources" -> modifiedSources = parseList(getArg(args, i++), ::parseFile)
        arg.startsWith("-modified-sources=") -> modifiedSources = parseList(arg.substring(18), ::parseFile)
        arg == "-removed-sources" -> removedSources = parseList(getArg(args, i++), ::parseFile)
        arg.startsWith("-removed-sources=") -> removedSources = parseList(arg.substring(17), ::parseFile)
        arg == "-changed-classes" -> changedClasses = parseList(getArg(args, i++), ::parseString)
        arg.startsWith("-changed-classes=") -> changedClasses = parseList(arg.substring(17), ::parseString)
        arg == "-language-version" -> languageVersion = parseString(getArg(args, i++))
        arg.startsWith("-language-version=") -> languageVersion = parseString(arg.substring(18))
        arg == "-api-version" -> apiVersion = parseString(getArg(args, i++))
        arg.startsWith("-api-version=") -> apiVersion = parseString(arg.substring(13))
        arg == "-all-warnings-as-errors" -> allWarningsAsErrors = parseBoolean(getArg(args, i++))
        arg.startsWith("-all-warnings-as-errors=") -> allWarningsAsErrors = parseBoolean(arg.substring(24))
        arg == "-map-annotation-arguments-in-java" -> mapAnnotationArgumentsInJava = parseBoolean(getArg(args, i++))
        arg.startsWith("-map-annotation-arguments-in-java=") -> mapAnnotationArgumentsInJava = parseBoolean(arg.substring(34))
        else -> {
          processorClasspath.addAll(parseList(arg, ::parseString))
        }
      }
    }
  }.build(), processorClasspath)
}
