/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.internal.zzacx;
import com.google.android.gms.internal.zzaso;
import com.google.android.gms.internal.zzasp;
import com.google.android.gms.internal.zzasq;
import com.google.android.gms.internal.zzass;
import com.google.android.gms.internal.zzast;
import com.google.android.gms.internal.zzasu;
import com.google.android.gms.internal.zzasw;
import com.google.android.gms.internal.zzasx;
import com.google.android.gms.internal.zzasy;
import com.google.android.gms.internal.zzasz;
import com.google.android.gms.internal.zzatb;
import com.google.android.gms.internal.zzatf;
import com.google.android.gms.internal.zzatg;
import com.google.android.gms.internal.zzati;
import com.google.android.gms.internal.zzatj;
import com.google.android.gms.internal.zzatk;
import com.google.android.gms.internal.zzatl;
import com.google.android.gms.internal.zzatm;
import com.google.android.gms.internal.zzatn;
import com.google.android.gms.internal.zzato;
import com.google.android.gms.internal.zzatr;
import com.google.android.gms.internal.zzats;
import com.google.android.gms.internal.zzatt;
import com.google.android.gms.internal.zzatu;
import com.google.android.gms.internal.zzatv;
import com.google.android.gms.internal.zzatw;
import com.google.android.gms.internal.zzatx;
import com.google.android.gms.internal.zzaty;
import com.google.android.gms.internal.zzaua;
import com.google.android.gms.internal.zzaub;
import com.google.android.gms.internal.zzaud;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzaug;
import com.google.android.gms.internal.zzauh;
import com.google.android.gms.internal.zzbum;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzatp {
    private static volatile zzatp zzbtc;
    private final Context mContext;
    private final zzast zzbtd;
    private final zzatl zzbte;
    private final zzati zzbtf;
    private final zzato zzbtg;
    private final zzaty zzbth;
    private final zzatn zzbti;
    private final AppMeasurement zzbtj;
    private final FirebaseAnalytics zzbtk;
    private final zzaue zzbtl;
    private final zzasu zzbtm;
    private final zzatg zzbtn;
    private final zzatj zzbto;
    private final zze zzuI;
    private final zzatv zzbtp;
    private final zzatw zzbtq;
    private final zzasw zzbtr;
    private final zzatu zzbts;
    private final zzatf zzbtt;
    private final zzatk zzbtu;
    private final zzaua zzbtv;
    private final zzass zzbtw;
    private final zzaso zzbtx;
    private final boolean zzacO;
    private boolean zzbty;
    private Boolean zzbtz;
    private long zzbtA;
    private FileLock zzbtB;
    private FileChannel zzbtC;
    private List<Long> zzbtD;
    private int zzbtE;
    private int zzbtF;
    private long zzbtG;

    zzatp(zzatt zzatt2) {
        zzaso zzaso2;
        zzac.zzw((Object)zzatt2);
        this.mContext = zzatt2.mContext;
        this.zzbtG = -1L;
        this.zzuI = zzatt2.zzn(this);
        this.zzbtd = zzatt2.zza(this);
        zzatl zzatl2 = zzatt2.zzb(this);
        zzatl2.initialize();
        this.zzbte = zzatl2;
        zzati zzati2 = zzatt2.zzc(this);
        zzati2.initialize();
        this.zzbtf = zzati2;
        this.zzJt().zzLe().zzj("App measurement is starting up, version", this.zzJv().zzJD());
        this.zzJt().zzLe().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        this.zzJt().zzLf().log("Debug-level message logging enabled");
        this.zzJt().zzLf().zzj("AppMeasurement singleton hash", System.identityHashCode(this));
        zzaue zzaue2 = zzatt2.zzj(this);
        zzaue2.initialize();
        this.zzbtl = zzaue2;
        zzasw zzasw2 = zzatt2.zzq(this);
        zzasw2.initialize();
        this.zzbtr = zzasw2;
        zzatf zzatf2 = zzatt2.zzr(this);
        zzatf2.initialize();
        this.zzbtt = zzatf2;
        this.zzJv().zzKk();
        Object object = zzatf2.zzjI();
        if (this.zzJp().zzgh((String)object)) {
            this.zzJt().zzLe().log("Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.");
        } else {
            String string = String.valueOf(object);
            this.zzJt().zzLe().log(string.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app "));
        }
        object = zzatt2.zzk(this);
        ((zzats)object).initialize();
        this.zzbtm = object;
        zzatg zzatg2 = zzatt2.zzl(this);
        zzatg2.initialize();
        this.zzbtn = zzatg2;
        zzass zzass2 = zzatt2.zzu(this);
        zzass2.initialize();
        this.zzbtw = zzass2;
        this.zzbtx = zzaso2 = zzatt2.zzv(this);
        zzatj zzatj2 = zzatt2.zzm(this);
        zzatj2.initialize();
        this.zzbto = zzatj2;
        zzatv zzatv2 = zzatt2.zzo(this);
        zzatv2.initialize();
        this.zzbtp = zzatv2;
        zzatw zzatw2 = zzatt2.zzp(this);
        zzatw2.initialize();
        this.zzbtq = zzatw2;
        zzatu zzatu2 = zzatt2.zzi(this);
        zzatu2.initialize();
        this.zzbts = zzatu2;
        zzaua zzaua2 = zzatt2.zzt(this);
        zzaua2.initialize();
        this.zzbtv = zzaua2;
        this.zzbtu = zzatt2.zzs(this);
        this.zzbtj = zzatt2.zzh(this);
        this.zzbtk = zzatt2.zzg(this);
        zzaty zzaty2 = zzatt2.zze(this);
        zzaty2.initialize();
        this.zzbth = zzaty2;
        zzatn zzatn2 = zzatt2.zzf(this);
        zzatn2.initialize();
        this.zzbti = zzatn2;
        zzato zzato2 = zzatt2.zzd(this);
        zzato2.initialize();
        this.zzbtg = zzato2;
        if (this.zzbtE != this.zzbtF) {
            this.zzJt().zzLa().zze("Not all components initialized", this.zzbtE, this.zzbtF);
        }
        this.zzacO = true;
        this.zzbtd.zzKk();
        if (this.mContext.getApplicationContext() instanceof Application) {
            if (Build.VERSION.SDK_INT >= 14) {
                this.zzJi().zzLQ();
            } else {
                this.zzJt().zzLf().log("Not tracking deep linking pre-ICS");
            }
        } else {
            this.zzJt().zzLc().log("Application context is not an Application");
        }
        this.zzbtg.zzm(new Runnable(){

            @Override
            public void run() {
                zzatp.this.start();
            }
        });
    }

    void zznA() {
        if (!this.zzacO) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    protected boolean zzLt() {
        block3: {
            this.zznA();
            this.zzmq();
            if (this.zzbtz != null && this.zzbtA != 0L && (this.zzbtz == null || this.zzbtz.booleanValue() || Math.abs(this.zznq().elapsedRealtime() - this.zzbtA) <= 1000L)) break block3;
            this.zzbtA = this.zznq().elapsedRealtime();
            this.zzJv().zzKk();
            if (!this.zzJp().zzbV("android.permission.INTERNET") || !this.zzJp().zzbV("android.permission.ACCESS_NETWORK_STATE")) ** GOTO lbl-1000
            zzacx.zzaQ((Context)this.getContext());
            if (zzatm.zzi(this.getContext(), false) && zzatx.zzj(this.getContext(), false)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            this.zzbtz = v0;
            if (this.zzbtz.booleanValue()) {
                this.zzbtz = this.zzJp().zzgd(this.zzJj().getGmpAppId());
            }
        }
        return this.zzbtz;
    }

    @WorkerThread
    protected void start() {
        this.zzmq();
        this.zzJo().zzKI();
        if (this.zzJu().zzbsg.get() == 0L) {
            this.zzJu().zzbsg.set(this.zznq().currentTimeMillis());
        }
        if (!this.zzLt()) {
            if (this.isEnabled()) {
                if (!this.zzJp().zzbV("android.permission.INTERNET")) {
                    this.zzJt().zzLa().log("App is missing INTERNET permission");
                }
                if (!this.zzJp().zzbV("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzJt().zzLa().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                this.zzJv().zzKk();
                zzacx.zzaQ((Context)this.getContext());
                if (!zzatm.zzi(this.getContext(), false)) {
                    this.zzJt().zzLa().log("AppMeasurementReceiver not registered/enabled");
                }
                if (!zzatx.zzj(this.getContext(), false)) {
                    this.zzJt().zzLa().log("AppMeasurementService not registered/enabled");
                }
                this.zzJt().zzLa().log("Uploading is not possible. App measurement disabled");
            }
        } else {
            this.zzJv().zzKk();
            if (!TextUtils.isEmpty((CharSequence)this.zzJj().getGmpAppId())) {
                String string = this.zzJu().zzLm();
                if (string == null) {
                    this.zzJu().zzfM(this.zzJj().getGmpAppId());
                } else if (!string.equals(this.zzJj().getGmpAppId())) {
                    this.zzJt().zzLe().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzJu().zzLo();
                    this.zzbtq.disconnect();
                    this.zzbtq.zzoc();
                    this.zzJu().zzfM(this.zzJj().getGmpAppId());
                }
            }
            this.zzJv().zzKk();
            if (!TextUtils.isEmpty((CharSequence)this.zzJj().getGmpAppId())) {
                this.zzJi().zzLR();
            }
        }
        this.zzLI();
    }

    public zzast zzJv() {
        return this.zzbtd;
    }

    public zzatl zzJu() {
        this.zza((zzatr)this.zzbte);
        return this.zzbte;
    }

    public zzati zzJt() {
        this.zza(this.zzbtf);
        return this.zzbtf;
    }

    public zzati zzLu() {
        return this.zzbtf != null && this.zzbtf.isInitialized() ? this.zzbtf : null;
    }

    public zzato zzJs() {
        this.zza(this.zzbtg);
        return this.zzbtg;
    }

    public zzaty zzJr() {
        this.zza(this.zzbth);
        return this.zzbth;
    }

    public zzatn zzJq() {
        this.zza(this.zzbti);
        return this.zzbti;
    }

    zzato zzLv() {
        return this.zzbtg;
    }

    public zzatu zzJi() {
        this.zza(this.zzbts);
        return this.zzbts;
    }

    public AppMeasurement zzLw() {
        return this.zzbtj;
    }

    public FirebaseAnalytics zzLx() {
        return this.zzbtk;
    }

    public zzaue zzJp() {
        this.zza((zzatr)this.zzbtl);
        return this.zzbtl;
    }

    public zzasu zzJo() {
        this.zza(this.zzbtm);
        return this.zzbtm;
    }

    public zzatg zzJn() {
        this.zza(this.zzbtn);
        return this.zzbtn;
    }

    public zzatj zzLy() {
        this.zza(this.zzbto);
        return this.zzbto;
    }

    public Context getContext() {
        return this.mContext;
    }

    public zze zznq() {
        return this.zzuI;
    }

    public zzatv zzJm() {
        this.zza(this.zzbtp);
        return this.zzbtp;
    }

    public zzatw zzJl() {
        this.zza(this.zzbtq);
        return this.zzbtq;
    }

    public zzasw zzJk() {
        this.zza(this.zzbtr);
        return this.zzbtr;
    }

    public zzatf zzJj() {
        this.zza(this.zzbtt);
        return this.zzbtt;
    }

    public zzatk zzLz() {
        if (this.zzbtu == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzbtu;
    }

    public zzaua zzLA() {
        this.zza(this.zzbtv);
        return this.zzbtv;
    }

    public zzass zzJh() {
        this.zza(this.zzbtw);
        return this.zzbtw;
    }

    public zzaso zzJg() {
        this.zza(this.zzbtx);
        return this.zzbtx;
    }

    @WorkerThread
    public void zzmq() {
        this.zzJs().zzmq();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzatp zzbu(Context context) {
        zzac.zzw((Object)context);
        zzac.zzw((Object)context.getApplicationContext());
        if (zzbtc != null) return zzbtc;
        Class<zzatp> clazz = zzatp.class;
        synchronized (zzatp.class) {
            if (zzbtc != null) return zzbtc;
            zzatt zzatt2 = new zzatt(context);
            zzbtc = zzatt2.zzLP();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzbtc;
        }
    }

    FileChannel zzLB() {
        return this.zzbtC;
    }

    private void zza(zzats zzats2) {
        if (zzats2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzats2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private void zza(zzatr zzatr2) {
        if (zzatr2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    void zzLC() {
        this.zzmq();
        this.zznA();
        if (this.zzLM() && this.zzLD()) {
            int n = this.zza(this.zzLB());
            int n2 = this.zzJj().zzKZ();
            this.zzv(n, n2);
        }
    }

    @WorkerThread
    boolean zzLD() {
        this.zzmq();
        String string = this.zzbtm.zznV();
        File file = this.getContext().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzbtC = new RandomAccessFile(file2, "rw").getChannel();
            this.zzbtB = this.zzbtC.tryLock();
            if (this.zzbtB != null) {
                this.zzJt().zzLg().log("Storage concurrent access okay");
                return true;
            }
            this.zzJt().zzLa().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzJt().zzLa().zzj("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzJt().zzLa().zzj("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    boolean zzv(int n, int n2) {
        this.zzmq();
        if (n > n2) {
            this.zzJt().zzLa().zze("Panic: can't downgrade version. Previous, current version", n, n2);
            return false;
        }
        if (n < n2) {
            if (this.zza(n2, this.zzLB())) {
                this.zzJt().zzLg().zze("Storage version upgraded. Previous, current version", n, n2);
            } else {
                this.zzJt().zzLa().zze("Storage version upgrade failed. Previous, current version", n, n2);
                return false;
            }
        }
        return true;
    }

    @WorkerThread
    int zza(FileChannel fileChannel) {
        this.zzmq();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzJt().zzLa().log("Bad chanel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzJt().zzLc().zzj("Unexpected data length. Bytes read", n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzJt().zzLa().zzj("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    boolean zza(int n, FileChannel fileChannel) {
        this.zzmq();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzJt().zzLa().log("Bad chanel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzJt().zzLa().zzj("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzJt().zzLa().zzj("Failed to write to channel", iOException);
            return false;
        }
    }

    @WorkerThread
    public boolean isEnabled() {
        this.zzmq();
        this.zznA();
        if (this.zzJv().zzKl()) {
            return false;
        }
        Boolean bl = this.zzJv().zzKm();
        boolean bl2 = bl != null ? bl : !this.zzJv().zzwk();
        return this.zzJu().zzaG(bl2);
    }

    void zzd(zzasq zzasq2) {
        this.zzmq();
        this.zznA();
        zzac.zzdv((String)zzasq2.packageName);
        this.zzf(zzasq2);
    }

    @WorkerThread
    void zzb(zzatb zzatb2, String string) {
        Object object;
        zzasp zzasp2;
        block4: {
            zzasp2 = this.zzJo().zzfy(string);
            if (zzasp2 == null || TextUtils.isEmpty((CharSequence)zzasp2.zzmy())) {
                this.zzJt().zzLf().zzj("No app data available; dropping event", string);
                return;
            }
            try {
                object = zzacx.zzaQ((Context)this.getContext()).getPackageInfo((String)string, (int)0).versionName;
                if (zzasp2.zzmy() != null && !zzasp2.zzmy().equals(object)) {
                    this.zzJt().zzLc().zzj("App version does not match; dropping event. appId", zzati.zzfI(string));
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if ("_ui".equals(zzatb2.name)) break block4;
                this.zzJt().zzLc().zzj("Could not find package. appId", zzati.zzfI(string));
            }
        }
        object = new zzasq(string, zzasp2.getGmpAppId(), zzasp2.zzmy(), zzasp2.zzJB(), zzasp2.zzJC(), zzasp2.zzJD(), zzasp2.zzJE(), null, zzasp2.zzJF(), false, zzasp2.zzJy());
        this.zzb(zzatb2, (zzasq)((Object)object));
    }

    long zzLE() {
        long l = this.zznq().currentTimeMillis() + this.zzJu().zzLk();
        return l / 1000L / 60L / 60L / 24L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(zzatb zzatb2, zzasq zzasq2) {
        long l = System.nanoTime();
        this.zzmq();
        this.zznA();
        String string = zzasq2.packageName;
        zzac.zzdv((String)string);
        if (!zzaue.zzc(zzatb2, zzasq2)) {
            return;
        }
        if (!zzasq2.zzbqk && !"_in".equals(zzatb2.name)) {
            this.zzf(zzasq2);
            return;
        }
        if (this.zzJq().zzX(string, zzatb2.name)) {
            zzasp zzasp2;
            boolean bl;
            this.zzJt().zzLc().zze("Dropping blacklisted event. appId", zzati.zzfI(string), zzatb2.name);
            boolean bl2 = bl = this.zzJp().zzgj(string) || this.zzJp().zzgk(string);
            if (!bl && !"_err".equals(zzatb2.name)) {
                this.zzJp().zza(11, "_ev", zzatb2.name, 0);
            }
            if (bl && (zzasp2 = this.zzJo().zzfy(string)) != null) {
                long l2 = Math.max(zzasp2.zzJI(), zzasp2.zzJH());
                long l3 = this.zznq().currentTimeMillis();
                if (Math.abs(l3 - l2) > this.zzJv().zzKp()) {
                    this.zzJt().zzLf().log("Fetching config for blacklisted app");
                    this.zzb(zzasp2);
                }
            }
            return;
        }
        if (this.zzJt().zzai(2)) {
            this.zzJt().zzLg().zzj("Logging event", (Object)zzatb2);
        }
        this.zzJo().beginTransaction();
        try {
            zzasy zzasy2;
            long l4;
            Bundle bundle = zzatb2.zzbqP.zzKY();
            this.zzf(zzasq2);
            if ("_iap".equals(zzatb2.name) || "ecommerce_purchase".equals(zzatb2.name)) {
                long l5;
                String string2 = bundle.getString("currency");
                if ("ecommerce_purchase".equals(zzatb2.name)) {
                    double d = bundle.getDouble("value") * 1000000.0;
                    if (d == 0.0) {
                        d = (double)bundle.getLong("value") * 1000000.0;
                    }
                    if (!(d <= 9.223372036854776E18) || !(d >= -9.223372036854776E18)) {
                        this.zzJt().zzLc().zze("Data lost. Currency value is too big. appId", zzati.zzfI(string), d);
                        this.zzJo().setTransactionSuccessful();
                        return;
                    }
                    l5 = Math.round(d);
                } else {
                    l5 = bundle.getLong("value");
                }
                if (!TextUtils.isEmpty((CharSequence)string2) && (string2 = string2.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                    String string3 = String.valueOf("_ltv_");
                    String string4 = String.valueOf(string2);
                    String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
                    zzaud zzaud2 = this.zzJo().zzR(string, string5);
                    if (zzaud2 == null || !(zzaud2.zzYe instanceof Long)) {
                        this.zzJo().zzz(string, this.zzJv().zzfr(string) - 1);
                        zzaud2 = new zzaud(string, string5, this.zznq().currentTimeMillis(), l5);
                    } else {
                        l4 = (Long)zzaud2.zzYe;
                        zzaud2 = new zzaud(string, string5, this.zznq().currentTimeMillis(), l4 + l5);
                    }
                    if (!this.zzJo().zza(zzaud2)) {
                        this.zzJt().zzLa().zzd("Too many unique user properties are set. Ignoring user property. appId", zzati.zzfI(string), zzaud2.mName, zzaud2.zzYe);
                        this.zzJp().zza(9, null, null, 0);
                    }
                }
            }
            boolean bl = zzaue.zzfW(zzatb2.name);
            boolean bl3 = "_err".equals(zzatb2.name);
            zzasu.zza zza2 = this.zzJo().zza(this.zzLE(), string, true, bl, false, bl3, false);
            long l6 = zza2.zzbqw - this.zzJv().zzKc();
            if (l6 > 0L) {
                if (l6 % 1000L == 1L) {
                    this.zzJt().zzLa().zze("Data loss. Too many events logged. appId, count", zzati.zzfI(string), zza2.zzbqw);
                }
                this.zzJp().zza(16, "_ev", zzatb2.name, 0);
                this.zzJo().setTransactionSuccessful();
                return;
            }
            if (bl && (l6 = zza2.zzbqv - this.zzJv().zzKd()) > 0L) {
                if (l6 % 1000L == 1L) {
                    this.zzJt().zzLa().zze("Data loss. Too many public events logged. appId, count", zzati.zzfI(string), zza2.zzbqv);
                }
                this.zzJp().zza(16, "_ev", zzatb2.name, 0);
                this.zzJo().setTransactionSuccessful();
                return;
            }
            if (bl3 && (l6 = zza2.zzbqy - (long)this.zzJv().zzfn(zzasq2.packageName)) > 0L) {
                if (l6 == 1L) {
                    this.zzJt().zzLa().zze("Too many error events logged. appId, count", zzati.zzfI(string), zza2.zzbqy);
                }
                this.zzJo().setTransactionSuccessful();
                return;
            }
            this.zzJp().zza(bundle, "_o", zzatb2.zzbqQ);
            if (this.zzJp().zzgh(string)) {
                this.zzJp().zza(bundle, "_dbg", 1L);
                this.zzJp().zza(bundle, "_r", 1L);
            }
            if ((l4 = this.zzJo().zzfz(string)) > 0L) {
                this.zzJt().zzLc().zze("Data lost. Too many events stored on disk, deleted. appId", zzati.zzfI(string), l4);
            }
            zzasx zzasx2 = new zzasx(this, zzatb2.zzbqQ, string, zzatb2.name, zzatb2.zzbqR, 0L, bundle);
            zzasy zzasy3 = this.zzJo().zzP(string, zzasx2.mName);
            if (zzasy3 == null) {
                long l7 = this.zzJo().zzfG(string);
                this.zzJv().zzKb();
                if (l7 >= 500L) {
                    this.zzJt().zzLa().zzd("Too many event names used, ignoring event. appId, name, supported count", zzati.zzfI(string), zzasx2.mName, this.zzJv().zzKb());
                    this.zzJp().zza(8, null, null, 0);
                    return;
                }
                zzasy2 = new zzasy(string, zzasx2.mName, 0L, 0L, zzasx2.zzavX);
            } else {
                zzasx2 = zzasx2.zza(this, zzasy3.zzbqL);
                zzasy2 = zzasy3.zzan(zzasx2.zzavX);
            }
            this.zzJo().zza(zzasy2);
            this.zza(zzasx2, zzasq2);
            this.zzJo().setTransactionSuccessful();
            if (this.zzJt().zzai(2)) {
                this.zzJt().zzLg().zzj("Event recorded", zzasx2);
            }
        }
        finally {
            this.zzJo().endTransaction();
        }
        this.zzLI();
        this.zzJt().zzLg().zzj("Background event processing time, ms", (System.nanoTime() - l + 500000L) / 1000000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public byte[] zza(@NonNull zzatb zzatb2, @Size(min=1L) String string) {
        Object object;
        zzbum zzbum2;
        Object object2;
        this.zznA();
        this.zzmq();
        this.zzJd();
        zzac.zzw((Object)((Object)zzatb2));
        zzac.zzdv((String)string);
        zzauh.zzd zzd2 = new zzauh.zzd();
        this.zzJo().beginTransaction();
        try {
            zzasy zzasy2;
            long l;
            Object object3;
            zzasp zzasp2 = this.zzJo().zzfy(string);
            if (zzasp2 == null) {
                this.zzJt().zzLf().zzj("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzasp2.zzJF()) {
                this.zzJt().zzLf().zzj("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            object2 = new zzauh.zze();
            zzd2.zzbwa = new zzauh.zze[]{object2};
            object2.zzbwc = 1;
            object2.zzbwk = "android";
            object2.zzaR = zzasp2.zzjI();
            object2.zzbqg = zzasp2.zzJC();
            object2.zzbhg = zzasp2.zzmy();
            object2.zzbwx = (int)zzasp2.zzJB();
            object2.zzbwo = zzasp2.zzJD();
            object2.zzbqf = zzasp2.getGmpAppId();
            object2.zzbwt = zzasp2.zzJE();
            zzbum2 = this.zzJu().zzfK(zzasp2.zzjI());
            if (!TextUtils.isEmpty((CharSequence)((CharSequence)zzbum2.first))) {
                object2.zzbwq = (String)zzbum2.first;
                object2.zzbwr = (Boolean)zzbum2.second;
            }
            object2.zzbwl = this.zzJk().zzkm();
            object2.zzba = this.zzJk().zzKU();
            object2.zzbwn = (int)this.zzJk().zzKV();
            object2.zzbwm = this.zzJk().zzKW();
            object2.zzbws = zzasp2.getAppInstanceId();
            object2.zzbqn = zzasp2.zzJy();
            object = this.zzJo().zzfx(zzasp2.zzjI());
            object2.zzbwe = new zzauh.zzg[object.size()];
            for (int i = 0; i < object.size(); ++i) {
                object3 = new zzauh.zzg();
                object2.zzbwe[i] = object3;
                ((zzauh.zzg)((Object)object3)).name = object.get((int)i).mName;
                ((zzauh.zzg)((Object)object3)).zzbwF = object.get((int)i).zzbvd;
                this.zzJp().zza((zzauh.zzg)((Object)object3), object.get((int)i).zzYe);
            }
            Bundle bundle = zzatb2.zzbqP.zzKY();
            if ("_iap".equals(zzatb2.name)) {
                bundle.putLong("_c", 1L);
                this.zzJt().zzLf().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzatb2.zzbqQ);
            if (this.zzJp().zzgh(object2.zzaR)) {
                this.zzJp().zza(bundle, "_dbg", 1L);
                this.zzJp().zza(bundle, "_r", 1L);
            }
            if ((object3 = this.zzJo().zzP(string, zzatb2.name)) == null) {
                l = 0L;
                zzasy2 = new zzasy(string, zzatb2.name, 1L, 0L, zzatb2.zzbqR);
                this.zzJo().zza(zzasy2);
            } else {
                l = ((zzasy)object3).zzbqL;
                zzasy2 = ((zzasy)object3).zzan(zzatb2.zzbqR);
                zzasy2 = zzasy2.zzKX();
                this.zzJo().zza(zzasy2);
            }
            zzasx zzasx2 = new zzasx(this, zzatb2.zzbqQ, string, zzatb2.name, zzatb2.zzbqR, l, bundle);
            zzauh.zzb zzb2 = new zzauh.zzb();
            object2.zzbwd = new zzauh.zzb[]{zzb2};
            zzb2.zzbvW = zzasx2.zzavX;
            zzb2.name = zzasx2.mName;
            zzb2.zzbvX = zzasx2.zzbqH;
            zzb2.zzbvV = new zzauh.zzc[zzasx2.zzbqI.size()];
            int n = 0;
            for (String string2 : zzasx2.zzbqI) {
                zzauh.zzc zzc2 = new zzauh.zzc();
                zzb2.zzbvV[n++] = zzc2;
                zzc2.name = string2;
                Object object4 = zzasx2.zzbqI.get(string2);
                this.zzJp().zza(zzc2, object4);
            }
            object2.zzbww = this.zza(zzasp2.zzjI(), object2.zzbwe, object2.zzbwd);
            object2.zzbwg = zzb2.zzbvW;
            object2.zzbwh = zzb2.zzbvW;
            long l2 = zzasp2.zzJA();
            object2.zzbwj = l2 != 0L ? Long.valueOf(l2) : null;
            long l3 = zzasp2.zzJz();
            if (l3 == 0L) {
                l3 = l2;
            }
            object2.zzbwi = l3 != 0L ? Long.valueOf(l3) : null;
            zzasp2.zzJJ();
            object2.zzbwu = (int)zzasp2.zzJG();
            object2.zzbwp = this.zzJv().zzJD();
            object2.zzbwf = this.zznq().currentTimeMillis();
            object2.zzbwv = Boolean.TRUE;
            zzasp2.zzX(object2.zzbwg);
            zzasp2.zzY(object2.zzbwh);
            this.zzJo().zza(zzasp2);
            this.zzJo().setTransactionSuccessful();
        }
        finally {
            this.zzJo().endTransaction();
        }
        try {
            int n = zzd2.zzacZ();
            object2 = new byte[n];
            zzbum2 = zzbum.zzae((byte[])object2);
            zzd2.zza(zzbum2);
            zzbum2.zzacM();
            object = this.zzJp().zzk((byte[])object2);
            return object;
        }
        catch (IOException iOException) {
            this.zzJt().zzLa().zze("Data loss. Failed to bundle and serialize. appId", zzati.zzfI(string), iOException);
            return null;
        }
    }

    void zza(zzasx zzasx2, zzasq zzasq2) {
        long l;
        Object object;
        this.zzmq();
        this.zznA();
        zzac.zzw((Object)zzasx2);
        zzac.zzw((Object)((Object)zzasq2));
        zzac.zzdv((String)zzasx2.zzVQ);
        zzac.zzas((boolean)zzasx2.zzVQ.equals(zzasq2.packageName));
        zzauh.zze zze2 = new zzauh.zze();
        zze2.zzbwc = 1;
        zze2.zzbwk = "android";
        zze2.zzaR = zzasq2.packageName;
        zze2.zzbqg = zzasq2.zzbqg;
        zze2.zzbhg = zzasq2.zzbhg;
        zze2.zzbwx = (int)zzasq2.zzbqm;
        zze2.zzbwo = zzasq2.zzbqh;
        zze2.zzbqf = zzasq2.zzbqf;
        zze2.zzbwt = zzasq2.zzbqi == 0L ? null : Long.valueOf(zzasq2.zzbqi);
        Pair<String, Boolean> pair = this.zzJu().zzfK(zzasq2.packageName);
        if (!TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            zze2.zzbwq = (String)pair.first;
            zze2.zzbwr = (Boolean)pair.second;
        } else if (!this.zzJk().zzbt(this.mContext)) {
            object = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
            if (object == null) {
                this.zzJt().zzLc().zzj("null secure ID. appId", zzati.zzfI(zze2.zzaR));
                object = "null";
            } else if (((String)object).isEmpty()) {
                this.zzJt().zzLc().zzj("empty secure ID. appId", zzati.zzfI(zze2.zzaR));
            }
            zze2.zzbwA = object;
        }
        zze2.zzbwl = this.zzJk().zzkm();
        zze2.zzba = this.zzJk().zzKU();
        zze2.zzbwn = (int)this.zzJk().zzKV();
        zze2.zzbwm = this.zzJk().zzKW();
        zze2.zzbwp = null;
        zze2.zzbwf = null;
        zze2.zzbwg = null;
        zze2.zzbwh = null;
        object = this.zzJo().zzfy(zzasq2.packageName);
        if (object == null) {
            object = new zzasp(this, zzasq2.packageName);
            ((zzasp)object).zzfh(this.zzJu().zzLj());
            ((zzasp)object).zzfk(zzasq2.zzbqn);
            ((zzasp)object).zzfi(zzasq2.zzbqf);
            ((zzasp)object).zzfj(this.zzJu().zzfL(zzasq2.packageName));
            ((zzasp)object).zzac(0L);
            ((zzasp)object).zzX(0L);
            ((zzasp)object).zzY(0L);
            ((zzasp)object).setAppVersion(zzasq2.zzbhg);
            ((zzasp)object).zzZ(zzasq2.zzbqm);
            ((zzasp)object).zzfl(zzasq2.zzbqg);
            ((zzasp)object).zzaa(zzasq2.zzbqh);
            ((zzasp)object).zzab(zzasq2.zzbqi);
            ((zzasp)object).setMeasurementEnabled(zzasq2.zzbqk);
            this.zzJo().zza((zzasp)object);
        }
        zze2.zzbws = ((zzasp)object).getAppInstanceId();
        zze2.zzbqn = ((zzasp)object).zzJy();
        List<zzaud> list = this.zzJo().zzfx(zzasq2.packageName);
        zze2.zzbwe = new zzauh.zzg[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            zzauh.zzg zzg2;
            zze2.zzbwe[i] = zzg2 = new zzauh.zzg();
            zzg2.name = list.get((int)i).mName;
            zzg2.zzbwF = list.get((int)i).zzbvd;
            this.zzJp().zza(zzg2, list.get((int)i).zzYe);
        }
        try {
            l = this.zzJo().zza(zze2);
        }
        catch (IOException iOException) {
            this.zzJt().zzLa().zze("Data loss. Failed to insert raw event metadata. appId", zzati.zzfI(zze2.zzaR), iOException);
            return;
        }
        this.zzJo().zza(zzasx2, l, this.zza(zzasx2));
    }

    public String zzfR(final String string) {
        Future<String> future = this.zzJs().zzd(new Callable<String>(){

            public String zzou() throws Exception {
                zzasp zzasp2 = zzatp.this.zzJo().zzfy(string);
                if (zzasp2 == null) {
                    return null;
                }
                return zzasp2.getAppInstanceId();
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzou();
            }
        });
        try {
            return future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzJt().zzLa().zze("Failed to get app instance id. appId", zzati.zzfI(string), exception);
            return null;
        }
    }

    public String getGmpAppIdOnPackageSide(final String string) {
        this.zzJd();
        Future<String> future = this.zzJs().zze(new Callable<String>(){

            public String zzou() throws Exception {
                zzasp zzasp2 = zzatp.this.zzJo().zzfy(string);
                if (zzasp2 == null) {
                    return null;
                }
                return zzasp2.getGmpAppId();
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzou();
            }
        });
        try {
            return future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzJt().zzLa().zze("Failed to get gmp app id. appId", zzati.zzfI(string), exception);
            return null;
        }
    }

    private boolean zza(zzasx zzasx2) {
        Object object2;
        if (zzasx2.zzbqI == null) {
            return false;
        }
        for (Object object2 : zzasx2.zzbqI) {
            if (!"_r".equals(object2)) continue;
            return true;
        }
        boolean bl = this.zzJq().zzY(zzasx2.zzVQ, zzasx2.mName);
        object2 = this.zzJo().zza(this.zzLE(), zzasx2.zzVQ, false, false, false, false, false);
        return bl && ((zzasu.zza)object2).zzbqz < (long)this.zzJv().zzfp(zzasx2.zzVQ);
    }

    void zzJe() {
        this.zzJv().zzKk();
    }

    void zzJd() {
        this.zzJv().zzKk();
        throw new IllegalStateException("Unexpected call on client side");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(zzaub zzaub2, zzasq zzasq2) {
        this.zzmq();
        this.zznA();
        if (TextUtils.isEmpty((CharSequence)zzasq2.zzbqf)) {
            return;
        }
        if (!zzasq2.zzbqk) {
            this.zzf(zzasq2);
            return;
        }
        int n = this.zzJp().zzga(zzaub2.name);
        if (n != 0) {
            String string = this.zzJp().zza(zzaub2.name, this.zzJv().zzJV(), true);
            int n2 = zzaub2.name != null ? zzaub2.name.length() : 0;
            this.zzJp().zza(n, "_ev", string, n2);
            return;
        }
        n = this.zzJp().zzm(zzaub2.name, zzaub2.getValue());
        if (n != 0) {
            String string = this.zzJp().zza(zzaub2.name, this.zzJv().zzJV(), true);
            Object object = zzaub2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                String string2 = String.valueOf(object);
                n3 = string2.length();
            }
            this.zzJp().zza(n, "_ev", string, n3);
            return;
        }
        Object object = this.zzJp().zzn(zzaub2.name, zzaub2.getValue());
        if (object == null) {
            return;
        }
        zzaud zzaud2 = new zzaud(zzasq2.packageName, zzaub2.name, zzaub2.zzbuZ, object);
        this.zzJt().zzLf().zze("Setting user property", zzaud2.mName, object);
        this.zzJo().beginTransaction();
        try {
            this.zzf(zzasq2);
            boolean bl = this.zzJo().zza(zzaud2);
            this.zzJo().setTransactionSuccessful();
            if (bl) {
                this.zzJt().zzLf().zze("User property set", zzaud2.mName, zzaud2.zzYe);
            } else {
                this.zzJt().zzLa().zze("Too many unique user properties are set. Ignoring user property", zzaud2.mName, zzaud2.zzYe);
                this.zzJp().zza(9, null, null, 0);
            }
        }
        finally {
            this.zzJo().endTransaction();
        }
    }

    @WorkerThread
    void zzc(zzaub zzaub2, zzasq zzasq2) {
        this.zzmq();
        this.zznA();
        if (TextUtils.isEmpty((CharSequence)zzasq2.zzbqf)) {
            return;
        }
        if (!zzasq2.zzbqk) {
            this.zzf(zzasq2);
            return;
        }
        this.zzJt().zzLf().zzj("Removing user property", zzaub2.name);
        this.zzJo().beginTransaction();
        try {
            this.zzf(zzasq2);
            this.zzJo().zzQ(zzasq2.packageName, zzaub2.name);
            this.zzJo().setTransactionSuccessful();
            this.zzJt().zzLf().zzj("User property removed", zzaub2.name);
        }
        finally {
            this.zzJo().endTransaction();
        }
    }

    @WorkerThread
    protected boolean zzLF() {
        this.zzmq();
        return this.zzbtD != null;
    }

    protected void zzH(List<Long> list) {
        zzac.zzas((!list.isEmpty() ? 1 : 0) != 0);
        if (this.zzbtD != null) {
            this.zzJt().zzLa().log("Set uploading progress before finishing the previous upload");
        } else {
            this.zzbtD = new ArrayList<Long>(list);
        }
    }

    @WorkerThread
    public void zzLG() {
        String string;
        this.zzmq();
        this.zznA();
        this.zzJv().zzKk();
        Boolean bl = this.zzJu().zzLn();
        if (bl == null) {
            this.zzJt().zzLc().log("Upload data called on the client side before use of service was decided");
            return;
        }
        if (bl.booleanValue()) {
            this.zzJt().zzLa().log("Upload called in the client side when service should be used");
            return;
        }
        if (this.zzLF()) {
            this.zzJt().zzLc().log("Uploading requested multiple times");
            return;
        }
        if (!this.zzLy().zzpA()) {
            this.zzJt().zzLc().log("Network not connected, ignoring upload request");
            this.zzLI();
            return;
        }
        long l = this.zznq().currentTimeMillis();
        this.zzao(l - this.zzJv().zzKv());
        long l2 = this.zzJu().zzbsg.get();
        if (l2 != 0L) {
            this.zzJt().zzLf().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l2));
        }
        if (!TextUtils.isEmpty((CharSequence)(string = this.zzJo().zzKG()))) {
            if (this.zzbtG == -1L) {
                this.zzbtG = this.zzJo().zzKO();
            }
            int n = this.zzJv().zzfu(string);
            int n2 = this.zzJv().zzfv(string);
            List<Pair<zzauh.zze, Long>> list = this.zzJo().zzn(string, n, n2);
            if (!list.isEmpty()) {
                String string2 = null;
                for (Pair<zzauh.zze, Long> object2 : list) {
                    zzauh.zze zze2 = (zzauh.zze)((Object)object2.first);
                    if (TextUtils.isEmpty((CharSequence)zze2.zzbwq)) continue;
                    string2 = zze2.zzbwq;
                    break;
                }
                if (string2 != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        zzauh.zze zze3 = (zzauh.zze)((Object)list.get((int)i).first);
                        if (TextUtils.isEmpty((CharSequence)zze3.zzbwq) || zze3.zzbwq.equals(string2)) continue;
                        list = list.subList(0, i);
                        break;
                    }
                }
                Object object3 = new zzauh.zzd();
                ((zzauh.zzd)((Object)object3)).zzbwa = new zzauh.zze[list.size()];
                ArrayList<Long> arrayList = new ArrayList<Long>(list.size());
                for (int i = 0; i < ((zzauh.zzd)((Object)object3)).zzbwa.length; ++i) {
                    ((zzauh.zzd)((Object)object3)).zzbwa[i] = (zzauh.zze)((Object)list.get((int)i).first);
                    arrayList.add((Long)list.get((int)i).second);
                    ((zzauh.zzd)((Object)object3)).zzbwa[i].zzbwp = this.zzJv().zzJD();
                    ((zzauh.zzd)((Object)object3)).zzbwa[i].zzbwf = l;
                    ((zzauh.zzd)((Object)object3)).zzbwa[i].zzbwv = this.zzJv().zzKk();
                }
                String string3 = null;
                if (this.zzJt().zzai(2)) {
                    string3 = zzaue.zzb(object3);
                }
                byte[] byArray = this.zzJp().zza((zzauh.zzd)((Object)object3));
                String string4 = this.zzJv().zzKu();
                try {
                    URL uRL = new URL(string4);
                    this.zzH(arrayList);
                    this.zzJu().zzbsh.set(l);
                    String string5 = "?";
                    if (((zzauh.zzd)((Object)object3)).zzbwa.length > 0) {
                        string5 = ((zzauh.zzd)((Object)object3)).zzbwa[0].zzaR;
                    }
                    this.zzJt().zzLg().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                    this.zzLy().zza(string, uRL, byArray, null, new zzatj.zza(){

                        @Override
                        public void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
                            zzatp.this.zza(n, throwable, byArray);
                        }
                    });
                }
                catch (MalformedURLException malformedURLException) {
                    this.zzJt().zzLa().zze("Failed to parse upload URL. Not uploading. appId", zzati.zzfI(string), string4);
                }
            }
        } else {
            zzasp zzasp2;
            this.zzbtG = -1L;
            String string6 = this.zzJo().zzam(l - this.zzJv().zzKv());
            if (!TextUtils.isEmpty((CharSequence)string6) && (zzasp2 = this.zzJo().zzfy(string6)) != null) {
                this.zzb(zzasp2);
            }
        }
    }

    void zzb(zzasp zzasp2) {
        String string = this.zzJv().zzO(zzasp2.getGmpAppId(), zzasp2.getAppInstanceId());
        try {
            URL uRL = new URL(string);
            this.zzJt().zzLg().zzj("Fetching remote configuration", zzasp2.zzjI());
            zzaug.zzb zzb2 = this.zzJq().zzfO(zzasp2.zzjI());
            ArrayMap arrayMap = null;
            String string2 = this.zzJq().zzfP(zzasp2.zzjI());
            if (zzb2 != null && !TextUtils.isEmpty((CharSequence)string2)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string2);
            }
            this.zzLy().zza(zzasp2.zzjI(), uRL, (Map<String, String>)arrayMap, new zzatj.zza(){

                @Override
                public void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
                    zzatp.this.zzb(string, n, throwable, byArray, map);
                }
            });
        }
        catch (MalformedURLException malformedURLException) {
            this.zzJt().zzLa().zze("Failed to parse config URL. Not fetching. appId", zzati.zzfI(zzasp2.zzjI()), string);
        }
    }

    boolean zzao(long l) {
        return this.zzj(null, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzj(String string, long l) {
        this.zzJo().beginTransaction();
        try {
            zza zza2 = new zza();
            this.zzJo().zza(string, l, this.zzbtG, zza2);
            if (!zza2.isEmpty()) {
                int n;
                boolean bl = false;
                zzauh.zze zze2 = zza2.zzbtI;
                zze2.zzbwd = new zzauh.zzb[zza2.zztf.size()];
                int n2 = 0;
                for (n = 0; n < zza2.zztf.size(); ++n) {
                    boolean bl2;
                    boolean bl3 = bl;
                    if (this.zzJq().zzX(zza2.zzbtI.zzaR, zza2.zztf.get((int)n).name)) {
                        this.zzJt().zzLc().zze("Dropping blacklisted raw event. appId", zzati.zzfI(string), zza2.zztf.get((int)n).name);
                        boolean bl4 = bl2 = this.zzJp().zzgj(zza2.zzbtI.zzaR) || this.zzJp().zzgk(zza2.zzbtI.zzaR);
                        if (bl2 || "_err".equals(zza2.zztf.get((int)n).name)) continue;
                        this.zzJp().zza(11, "_ev", zza2.zztf.get((int)n).name, 0);
                        continue;
                    }
                    if (this.zzJq().zzY(zza2.zzbtI.zzaR, zza2.zztf.get((int)n).name)) {
                        Object object;
                        zzauh.zzc[] zzcArray;
                        bl2 = false;
                        boolean bl5 = false;
                        if (zza2.zztf.get((int)n).zzbvV == null) {
                            zza2.zztf.get((int)n).zzbvV = new zzauh.zzc[0];
                        }
                        for (zzauh.zzc zzc2 : zza2.zztf.get((int)n).zzbvV) {
                            if ("_c".equals(zzc2.name)) {
                                zzc2.zzbvZ = 1L;
                                bl2 = true;
                                continue;
                            }
                            if (!"_r".equals(zzc2.name)) continue;
                            zzc2.zzbvZ = 1L;
                            bl5 = true;
                        }
                        if (!bl2) {
                            this.zzJt().zzLg().zzj("Marking event as conversion", zza2.zztf.get((int)n).name);
                            zzcArray = Arrays.copyOf(zza2.zztf.get((int)n).zzbvV, zza2.zztf.get((int)n).zzbvV.length + 1);
                            zzauh.zzc zzc3 = new zzauh.zzc();
                            zzc3.name = "_c";
                            zzc3.zzbvZ = 1L;
                            zzcArray[zzcArray.length - 1] = zzc3;
                            zza2.zztf.get((int)n).zzbvV = zzcArray;
                        }
                        if (!bl5) {
                            this.zzJt().zzLg().zzj("Marking event as real-time", zza2.zztf.get((int)n).name);
                            zzcArray = Arrays.copyOf(zza2.zztf.get((int)n).zzbvV, zza2.zztf.get((int)n).zzbvV.length + 1);
                            zzauh.zzc zzc4 = new zzauh.zzc();
                            zzc4.name = "_r";
                            zzc4.zzbvZ = 1L;
                            zzcArray[zzcArray.length - 1] = zzc4;
                            zza2.zztf.get((int)n).zzbvV = zzcArray;
                        }
                        bl = true;
                        boolean bl6 = zzaue.zzfW(zza2.zztf.get((int)n).name);
                        zzasu.zza zza3 = this.zzJo().zza(this.zzLE(), zza2.zzbtI.zzaR, false, false, false, false, true);
                        if (zza3.zzbqz > (long)this.zzJv().zzfp(zza2.zzbtI.zzaR)) {
                            zzauh.zzb zzb2 = zza2.zztf.get(n);
                            for (int i = 0; i < zzb2.zzbvV.length; ++i) {
                                if (!"_r".equals(zzb2.zzbvV[i].name)) continue;
                                object = new zzauh.zzc[zzb2.zzbvV.length - 1];
                                if (i > 0) {
                                    System.arraycopy(zzb2.zzbvV, 0, object, 0, i);
                                }
                                if (i < ((zzauh.zzc[])object).length) {
                                    System.arraycopy(zzb2.zzbvV, i + 1, object, i, ((zzauh.zzc[])object).length - i);
                                }
                                zzb2.zzbvV = object;
                                break;
                            }
                            bl = bl3;
                        }
                        if (bl6) {
                            zza3 = this.zzJo().zza(this.zzLE(), zza2.zzbtI.zzaR, false, false, true, false, false);
                            if (zza3.zzbqx > (long)this.zzJv().zzfo(zza2.zzbtI.zzaR)) {
                                this.zzJt().zzLc().zzj("Too many conversions. Not logging as conversion. appId", zzati.zzfI(string));
                                zzauh.zzb zzb3 = zza2.zztf.get(n);
                                boolean bl7 = false;
                                object = null;
                                for (zzauh.zzc zzc5 : zzb3.zzbvV) {
                                    if ("_c".equals(zzc5.name)) {
                                        object = zzc5;
                                        continue;
                                    }
                                    if (!"_err".equals(zzc5.name)) continue;
                                    bl7 = true;
                                }
                                if (bl7 && object != null) {
                                    zzauh.zzc[] zzcArray2 = new zzauh.zzc[zzb3.zzbvV.length - 1];
                                    int n3 = 0;
                                    for (zzauh.zzc zzc6 : zzb3.zzbvV) {
                                        if (zzc6 == object) continue;
                                        zzcArray2[n3++] = zzc6;
                                    }
                                    zzb3.zzbvV = zzcArray2;
                                } else if (object != null) {
                                    object.name = "_err";
                                    object.zzbvZ = 10L;
                                } else {
                                    this.zzJt().zzLa().zzj("Did not find conversion parameter. appId", zzati.zzfI(string));
                                }
                            }
                        }
                    }
                    zze2.zzbwd[n2++] = zza2.zztf.get(n);
                }
                if (n2 < zza2.zztf.size()) {
                    zze2.zzbwd = Arrays.copyOf(zze2.zzbwd, n2);
                }
                zze2.zzbww = this.zza(zza2.zzbtI.zzaR, zza2.zzbtI.zzbwe, zze2.zzbwd);
                zze2.zzbwg = Long.MAX_VALUE;
                zze2.zzbwh = Long.MIN_VALUE;
                for (n = 0; n < zze2.zzbwd.length; ++n) {
                    zzauh.zzb zzb4 = zze2.zzbwd[n];
                    if (zzb4.zzbvW < zze2.zzbwg) {
                        zze2.zzbwg = zzb4.zzbvW;
                    }
                    if (zzb4.zzbvW <= zze2.zzbwh) continue;
                    zze2.zzbwh = zzb4.zzbvW;
                }
                String string2 = zza2.zzbtI.zzaR;
                zzasp zzasp2 = this.zzJo().zzfy(string2);
                if (zzasp2 == null) {
                    this.zzJt().zzLa().zzj("Bundling raw events w/o app info. appId", zzati.zzfI(string));
                } else if (zze2.zzbwd.length > 0) {
                    long l2 = zzasp2.zzJA();
                    zze2.zzbwj = l2 != 0L ? Long.valueOf(l2) : null;
                    long l3 = zzasp2.zzJz();
                    if (l3 == 0L) {
                        l3 = l2;
                    }
                    zze2.zzbwi = l3 != 0L ? Long.valueOf(l3) : null;
                    zzasp2.zzJJ();
                    zze2.zzbwu = (int)zzasp2.zzJG();
                    zzasp2.zzX(zze2.zzbwg);
                    zzasp2.zzY(zze2.zzbwh);
                    zze2.zzbqj = zzasp2.zzJR();
                    this.zzJo().zza(zzasp2);
                }
                if (zze2.zzbwd.length > 0) {
                    this.zzJv().zzKk();
                    zzaug.zzb zzb5 = this.zzJq().zzfO(zza2.zzbtI.zzaR);
                    if (zzb5 == null || zzb5.zzbvK == null) {
                        this.zzJt().zzLc().zzj("Did not find measurement config or missing version info. appId", zzati.zzfI(string));
                    } else {
                        zze2.zzbwB = zzb5.zzbvK;
                    }
                    this.zzJo().zza(zze2, bl);
                }
                this.zzJo().zzG(zza2.zzbtJ);
                this.zzJo().zzfF(string2);
                this.zzJo().setTransactionSuccessful();
                boolean bl8 = zze2.zzbwd.length > 0;
                return bl8;
            }
            this.zzJo().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzJo().endTransaction();
        }
    }

    private zzauh.zza[] zza(String string, zzauh.zzg[] zzgArray, zzauh.zzb[] zzbArray) {
        zzac.zzdv((String)string);
        return this.zzJh().zza(string, zzbArray, zzgArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzmq();
        this.zznA();
        zzac.zzdv((String)string);
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.zzJo().beginTransaction();
        try {
            boolean bl;
            zzasp zzasp2 = this.zzJo().zzfy(string);
            boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
            if (zzasp2 == null) {
                this.zzJt().zzLc().zzj("App does not exist in onConfigFetched. appId", zzati.zzfI(string));
            } else if (bl || n == 404) {
                String string2;
                List<String> list = map != null ? map.get("Last-Modified") : null;
                String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                if (n == 404 || n == 304 ? this.zzJq().zzfO(string) == null && !this.zzJq().zzb(string, null, null) : !this.zzJq().zzb(string, byArray, string2)) {
                    return;
                }
                zzasp2.zzad(this.zznq().currentTimeMillis());
                this.zzJo().zza(zzasp2);
                if (n == 404) {
                    this.zzJt().zzLc().zzj("Config not found. Using empty config. appId", zzati.zzfI(string));
                } else {
                    this.zzJt().zzLg().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                }
                if (this.zzLy().zzpA() && this.zzLH()) {
                    this.zzLG();
                } else {
                    this.zzLI();
                }
            } else {
                boolean bl3;
                zzasp2.zzae(this.zznq().currentTimeMillis());
                this.zzJo().zza(zzasp2);
                this.zzJt().zzLg().zze("Fetching config failed. code, error", n, throwable);
                this.zzJq().zzfQ(string);
                this.zzJu().zzbsh.set(this.zznq().currentTimeMillis());
                boolean bl4 = bl3 = n == 503 || n == 429;
                if (bl3) {
                    this.zzJu().zzbsi.set(this.zznq().currentTimeMillis());
                }
                this.zzLI();
            }
            this.zzJo().setTransactionSuccessful();
        }
        finally {
            this.zzJo().endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    protected void zza(int n, Throwable throwable, byte[] byArray) {
        this.zzmq();
        this.zznA();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        List<Long> list = this.zzbtD;
        this.zzbtD = null;
        if ((n == 200 || n == 204) && throwable == null) {
            this.zzJu().zzbsg.set(this.zznq().currentTimeMillis());
            this.zzJu().zzbsh.set(0L);
            this.zzLI();
            this.zzJt().zzLg().zze("Successful upload. Got network response. code, size", n, byArray.length);
            this.zzJo().beginTransaction();
            try {
                for (Long l : list) {
                    this.zzJo().zzal(l);
                }
                this.zzJo().setTransactionSuccessful();
            }
            finally {
                this.zzJo().endTransaction();
            }
            if (this.zzLy().zzpA() && this.zzLH()) {
                this.zzLG();
            } else {
                this.zzbtG = -1L;
                this.zzLI();
            }
        } else {
            boolean bl;
            this.zzJt().zzLg().zze("Network upload failed. Will retry later. code, error", n, throwable);
            this.zzJu().zzbsh.set(this.zznq().currentTimeMillis());
            boolean bl2 = bl = n == 503 || n == 429;
            if (bl) {
                this.zzJu().zzbsi.set(this.zznq().currentTimeMillis());
            }
            this.zzLI();
        }
    }

    private boolean zzLH() {
        this.zzmq();
        this.zznA();
        boolean bl = this.zzJo().zzKM();
        return bl || !TextUtils.isEmpty((CharSequence)this.zzJo().zzKG());
    }

    @WorkerThread
    private void zzLI() {
        this.zzmq();
        this.zznA();
        if (!this.zzLM()) {
            return;
        }
        if (!this.zzLt() || !this.zzLH()) {
            this.zzLz().unregister();
            this.zzLA().cancel();
            return;
        }
        long l = this.zzLJ();
        if (l == 0L) {
            this.zzLz().unregister();
            this.zzLA().cancel();
            return;
        }
        if (!this.zzLy().zzpA()) {
            this.zzLz().zzpx();
            this.zzLA().cancel();
            return;
        }
        long l2 = this.zzJu().zzbsi.get();
        long l3 = this.zzJv().zzKw();
        if (!this.zzJp().zzf(l2, l3)) {
            l = Math.max(l, l2 + l3);
        }
        this.zzLz().unregister();
        long l4 = l - this.zznq().currentTimeMillis();
        if (l4 <= 0L) {
            l4 = this.zzJv().zzKz();
            this.zzJu().zzbsg.set(this.zznq().currentTimeMillis());
        }
        this.zzJt().zzLg().zzj("Upload scheduled in approximately ms", l4);
        this.zzLA().zzx(l4);
    }

    private long zzLJ() {
        long l;
        long l2 = this.zznq().currentTimeMillis();
        long l3 = this.zzJv().zzKC();
        boolean bl = this.zzJo().zzKN() || this.zzJo().zzKH();
        long l4 = bl ? this.zzJv().zzKy() : this.zzJv().zzKx();
        long l5 = this.zzJu().zzbsg.get();
        long l6 = this.zzJu().zzbsh.get();
        long l7 = this.zzJo().zzKK();
        long l8 = Math.max(l7, l = this.zzJo().zzKL());
        if (l8 == 0L) {
            return 0L;
        }
        l8 = l2 - Math.abs(l8 - l2);
        l5 = l2 - Math.abs(l5 - l2);
        l6 = l2 - Math.abs(l6 - l2);
        long l9 = Math.max(l5, l6);
        long l10 = l8 + l3;
        if (bl && l9 > 0L) {
            l10 = Math.min(l8, l9) + l4;
        }
        if (!this.zzJp().zzf(l9, l4)) {
            l10 = l9 + l4;
        }
        if (l6 != 0L && l6 >= l8) {
            long l11 = l10;
            for (int i = 0; i < this.zzJv().zzKE(); ++i) {
                long l12 = 1 << i;
                if ((l11 += this.zzJv().zzKD() * l12) <= l6) continue;
                return l11;
            }
            return 0L;
        }
        return l10;
    }

    public void zzV(boolean bl) {
        this.zzLI();
    }

    void zzb(zzats zzats2) {
        ++this.zzbtE;
    }

    void zzLK() {
        ++this.zzbtF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zze(zzasq zzasq2) {
        this.zzmq();
        this.zznA();
        zzac.zzw((Object)((Object)zzasq2));
        zzac.zzdv((String)zzasq2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzasq2.zzbqf)) {
            return;
        }
        if (!zzasq2.zzbqk) {
            this.zzf(zzasq2);
            return;
        }
        long l = this.zznq().currentTimeMillis();
        this.zzJo().beginTransaction();
        try {
            this.zza(zzasq2, l);
            this.zzf(zzasq2);
            zzasy zzasy2 = this.zzJo().zzP(zzasq2.packageName, "_f");
            if (zzasy2 == null) {
                long l2 = (1L + l / 3600000L) * 3600000L;
                zzaub zzaub2 = new zzaub("_fot", l, l2, "auto");
                this.zzb(zzaub2, zzasq2);
                this.zzb(zzasq2, l);
                this.zzc(zzasq2, l);
            } else if (zzasq2.zzbql) {
                this.zzd(zzasq2, l);
            }
            this.zzJo().setTransactionSuccessful();
        }
        finally {
            this.zzJo().endTransaction();
        }
    }

    @WorkerThread
    void zza(zzasq zzasq2, long l) {
        zzasp zzasp2 = this.zzJo().zzfy(zzasq2.packageName);
        if (zzasp2 != null && zzasp2.getGmpAppId() != null && !zzasp2.getGmpAppId().equals(zzasq2.zzbqf)) {
            this.zzJt().zzLc().zzj("New GMP App Id passed in. Removing cached database data. appId", zzati.zzfI(zzasp2.zzjI()));
            this.zzJo().zzfD(zzasp2.zzjI());
            zzasp2 = null;
        }
        if (zzasp2 != null && zzasp2.zzmy() != null && !zzasp2.zzmy().equals(zzasq2.zzbhg)) {
            Bundle bundle = new Bundle();
            bundle.putString("_pv", zzasp2.zzmy());
            zzatb zzatb2 = new zzatb("_au", new zzasz(bundle), "auto", l);
            this.zzb(zzatb2, zzasq2);
        }
    }

    @WorkerThread
    void zzb(zzasq zzasq2, long l) {
        this.zzmq();
        this.zznA();
        Bundle bundle = new Bundle();
        bundle.putLong("_c", 1L);
        bundle.putLong("_r", 1L);
        bundle.putLong("_uwa", 0L);
        bundle.putLong("_pfo", 0L);
        bundle.putLong("_sys", 0L);
        bundle.putLong("_sysu", 0L);
        PackageManager packageManager = this.getContext().getPackageManager();
        if (packageManager == null) {
            this.zzJt().zzLa().zzj("PackageManager is null, first open report might be inaccurate. appId", zzati.zzfI(zzasq2.packageName));
        } else {
            PackageInfo packageInfo = null;
            try {
                packageInfo = zzacx.zzaQ((Context)this.getContext()).getPackageInfo(zzasq2.packageName, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzJt().zzLa().zze("Package info is null, first open report might be inaccurate. appId", zzati.zzfI(zzasq2.packageName), (Object)nameNotFoundException);
            }
            if (packageInfo != null && packageInfo.firstInstallTime != 0L && packageInfo.firstInstallTime != packageInfo.lastUpdateTime) {
                bundle.putLong("_uwa", 1L);
            }
            ApplicationInfo applicationInfo = null;
            try {
                applicationInfo = zzacx.zzaQ((Context)this.getContext()).getApplicationInfo(zzasq2.packageName, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzJt().zzLa().zze("Application info is null, first open report might be inaccurate. appId", zzati.zzfI(zzasq2.packageName), (Object)nameNotFoundException);
            }
            if (applicationInfo != null) {
                if ((applicationInfo.flags & 1) != 0) {
                    bundle.putLong("_sys", 1L);
                }
                if ((applicationInfo.flags & 0x80) != 0) {
                    bundle.putLong("_sysu", 1L);
                }
            }
        }
        long l2 = this.zzJo().zzfE(zzasq2.packageName);
        if (l2 >= 0L) {
            bundle.putLong("_pfo", l2);
        }
        zzatb zzatb2 = new zzatb("_f", new zzasz(bundle), "auto", l);
        this.zzb(zzatb2, zzasq2);
    }

    @WorkerThread
    void zzc(zzasq zzasq2, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("_et", 1L);
        zzatb zzatb2 = new zzatb("_e", new zzasz(bundle), "auto", l);
        this.zzb(zzatb2, zzasq2);
    }

    @WorkerThread
    void zzd(zzasq zzasq2, long l) {
        Bundle bundle = new Bundle();
        zzatb zzatb2 = new zzatb("_cd", new zzasz(bundle), "auto", l);
        this.zzb(zzatb2, zzasq2);
    }

    @WorkerThread
    private void zzf(zzasq zzasq2) {
        this.zzmq();
        this.zznA();
        zzac.zzw((Object)((Object)zzasq2));
        zzac.zzdv((String)zzasq2.packageName);
        zzasp zzasp2 = this.zzJo().zzfy(zzasq2.packageName);
        String string = this.zzJu().zzfL(zzasq2.packageName);
        boolean bl = false;
        if (zzasp2 == null) {
            zzasp2 = new zzasp(this, zzasq2.packageName);
            zzasp2.zzfh(this.zzJu().zzLj());
            zzasp2.zzfj(string);
            bl = true;
        } else if (!string.equals(zzasp2.zzJx())) {
            zzasp2.zzfj(string);
            zzasp2.zzfh(this.zzJu().zzLj());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzasq2.zzbqf) && !zzasq2.zzbqf.equals(zzasp2.getGmpAppId())) {
            zzasp2.zzfi(zzasq2.zzbqf);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzasq2.zzbqn) && !zzasq2.zzbqn.equals(zzasp2.zzJy())) {
            zzasp2.zzfk(zzasq2.zzbqn);
            bl = true;
        }
        if (zzasq2.zzbqh != 0L && zzasq2.zzbqh != zzasp2.zzJD()) {
            zzasp2.zzaa(zzasq2.zzbqh);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzasq2.zzbhg) && !zzasq2.zzbhg.equals(zzasp2.zzmy())) {
            zzasp2.setAppVersion(zzasq2.zzbhg);
            bl = true;
        }
        if (zzasq2.zzbqm != zzasp2.zzJB()) {
            zzasp2.zzZ(zzasq2.zzbqm);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzasq2.zzbqg) && !zzasq2.zzbqg.equals(zzasp2.zzJC())) {
            zzasp2.zzfl(zzasq2.zzbqg);
            bl = true;
        }
        if (zzasq2.zzbqi != zzasp2.zzJE()) {
            zzasp2.zzab(zzasq2.zzbqi);
            bl = true;
        }
        if (zzasq2.zzbqk != zzasp2.zzJF()) {
            zzasp2.setMeasurementEnabled(zzasq2.zzbqk);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzasq2.zzbqj) && !zzasq2.zzbqj.equals(zzasp2.zzJQ())) {
            zzasp2.zzfm(zzasq2.zzbqj);
            bl = true;
        }
        if (bl) {
            this.zzJo().zza(zzasp2);
        }
    }

    @WorkerThread
    void zzLL() {
        this.zzmq();
        this.zznA();
        if (!this.zzbty) {
            this.zzJt().zzLe().log("This instance being marked as an uploader");
            this.zzLC();
        }
        this.zzbty = true;
    }

    @WorkerThread
    boolean zzLM() {
        this.zzmq();
        this.zznA();
        return this.zzbty;
    }

    private class zza
    implements zzasu.zzb {
        zzauh.zze zzbtI;
        List<Long> zzbtJ;
        List<zzauh.zzb> zztf;
        long zzbtK;

        private zza() {
        }

        @Override
        public void zzb(zzauh.zze zze2) {
            zzac.zzw((Object)((Object)zze2));
            this.zzbtI = zze2;
        }

        @Override
        public boolean zza(long l, zzauh.zzb zzb2) {
            zzac.zzw((Object)((Object)zzb2));
            if (this.zztf == null) {
                this.zztf = new ArrayList<zzauh.zzb>();
            }
            if (this.zzbtJ == null) {
                this.zzbtJ = new ArrayList<Long>();
            }
            if (this.zztf.size() > 0 && this.zza(this.zztf.get(0)) != this.zza(zzb2)) {
                return false;
            }
            long l2 = this.zzbtK + (long)zzb2.zzacZ();
            if (l2 >= (long)zzatp.this.zzJv().zzKr()) {
                return false;
            }
            this.zzbtK = l2;
            this.zztf.add(zzb2);
            this.zzbtJ.add(l);
            return this.zztf.size() < zzatp.this.zzJv().zzKs();
        }

        private long zza(zzauh.zzb zzb2) {
            return zzb2.zzbvW / 1000L / 60L / 60L;
        }

        boolean isEmpty() {
            return this.zztf == null || this.zztf.isEmpty();
        }
    }
}

