/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzasv;
import com.google.android.gms.internal.zzatb;
import com.google.android.gms.internal.zzate;
import com.google.android.gms.internal.zzath;
import com.google.android.gms.internal.zzati;
import com.google.android.gms.internal.zzatp;
import com.google.android.gms.internal.zzats;
import com.google.android.gms.internal.zzatz;
import com.google.android.gms.internal.zzaub;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class zzatw
extends zzats {
    private final zza zzbuz;
    private zzate zzbuA;
    private Boolean zzbuB;
    private final zzasv zzbuC;
    private final zzatz zzbuD;
    private final List<Runnable> zzbuE = new ArrayList<Runnable>();
    private final zzasv zzbuF;

    protected zzatw(zzatp zzatp2) {
        super(zzatp2);
        this.zzbuD = new zzatz(zzatp2.zznq());
        this.zzbuz = new zza();
        this.zzbuC = new zzasv(zzatp2){

            @Override
            public void run() {
                zzatw.this.zznO();
            }
        };
        this.zzbuF = new zzasv(zzatp2){

            @Override
            public void run() {
                zzatw.this.zzJt().zzLc().log("Tasks have been queued for a long time");
            }
        };
    }

    @Override
    protected void zzmr() {
    }

    @WorkerThread
    public boolean isConnected() {
        this.zzmq();
        this.zznA();
        return this.zzbuA != null;
    }

    @WorkerThread
    protected void zzLW() {
        this.zzmq();
        this.zznA();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzate zzate2 = zzatw.this.zzbuA;
                if (zzate2 == null) {
                    zzatw.this.zzJt().zzLa().log("Failed to send measurementEnabled to service");
                    return;
                }
                try {
                    zzate2.zzb(zzatw.this.zzJj().zzfH(zzatw.this.zzJt().zzLh()));
                    zzatw.this.zznN();
                }
                catch (RemoteException remoteException) {
                    zzatw.this.zzJt().zzLa().zzj("Failed to send measurementEnabled to the service", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    void zza(zzate zzate2, com.google.android.gms.common.internal.safeparcel.zza zza2) {
        boolean bl;
        this.zzmq();
        this.zzJe();
        this.zznA();
        if (Build.VERSION.SDK_INT >= 11) {
            this.zzJv().zzKk();
            bl = true;
        } else {
            bl = false;
        }
        boolean bl2 = bl;
        ArrayList<com.google.android.gms.common.internal.safeparcel.zza> arrayList = new ArrayList<com.google.android.gms.common.internal.safeparcel.zza>();
        int n = 100;
        this.zzJv().zzKt();
        for (int i = 0; i < 1001 && n == 100; ++i) {
            Object object;
            n = 0;
            if (bl2 && (object = this.zzJn().zzls(100)) != null) {
                arrayList.addAll((Collection<com.google.android.gms.common.internal.safeparcel.zza>)object);
                n = object.size();
            }
            if (zza2 != null && n < 100) {
                arrayList.add(zza2);
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                com.google.android.gms.common.internal.safeparcel.zza zza3 = (com.google.android.gms.common.internal.safeparcel.zza)object.next();
                if (zza3 instanceof zzatb) {
                    try {
                        zzate2.zza((zzatb)zza3, this.zzJj().zzfH(this.zzJt().zzLh()));
                    }
                    catch (RemoteException remoteException) {
                        this.zzJt().zzLa().zzj("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zza3 instanceof zzaub) {
                    try {
                        zzate2.zza((zzaub)zza3, this.zzJj().zzfH(this.zzJt().zzLh()));
                    }
                    catch (RemoteException remoteException) {
                        this.zzJt().zzLa().zzj("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                this.zzJt().zzLa().log("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected void zzc(final zzatb zzatb2, final String string) {
        boolean bl;
        zzac.zzw((Object)((Object)zzatb2));
        this.zzmq();
        this.zznA();
        if (Build.VERSION.SDK_INT >= 11) {
            this.zzJv().zzKk();
            bl = true;
        } else {
            bl = false;
        }
        final boolean bl2 = bl;
        final boolean bl3 = bl2 && this.zzJn().zza(zzatb2);
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzate zzate2 = zzatw.this.zzbuA;
                if (zzate2 == null) {
                    zzatw.this.zzJt().zzLa().log("Discarding data. Failed to send event to service");
                    return;
                }
                if (bl2) {
                    zzatw.this.zza(zzate2, bl3 ? null : zzatb2);
                } else {
                    try {
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            zzate2.zza(zzatb2, zzatw.this.zzJj().zzfH(zzatw.this.zzJt().zzLh()));
                        } else {
                            zzate2.zza(zzatb2, string, zzatw.this.zzJt().zzLh());
                        }
                    }
                    catch (RemoteException remoteException) {
                        zzatw.this.zzJt().zzLa().zzj("Failed to send event to the service", (Object)remoteException);
                    }
                }
                zzatw.this.zznN();
            }
        });
    }

    @WorkerThread
    protected void zzb(final zzaub zzaub2) {
        boolean bl;
        this.zzmq();
        this.zznA();
        if (Build.VERSION.SDK_INT >= 11) {
            this.zzJv().zzKk();
            bl = true;
        } else {
            bl = false;
        }
        boolean bl2 = bl;
        final boolean bl3 = bl2 && this.zzJn().zza(zzaub2);
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzate zzate2 = zzatw.this.zzbuA;
                if (zzate2 == null) {
                    zzatw.this.zzJt().zzLa().log("Discarding data. Failed to set user attribute");
                    return;
                }
                zzatw.this.zza(zzate2, bl3 ? null : zzaub2);
                zzatw.this.zznN();
            }
        });
    }

    @WorkerThread
    protected void zza(final AtomicReference<List<zzaub>> atomicReference, final boolean bl) {
        this.zzmq();
        this.zznA();
        this.zzo(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicReference atomicReference2 = atomicReference;
                synchronized (atomicReference2) {
                    try {
                        zzate zzate2 = zzatw.this.zzbuA;
                        if (zzate2 == null) {
                            zzatw.this.zzJt().zzLa().log("Failed to get user properties");
                            return;
                        }
                        atomicReference.set(zzate2.zza(zzatw.this.zzJj().zzfH(null), bl));
                        zzatw.this.zznN();
                    }
                    catch (RemoteException remoteException) {
                        zzatw.this.zzJt().zzLa().zzj("Failed to get user properties", (Object)remoteException);
                    }
                    finally {
                        atomicReference.notify();
                    }
                }
            }
        });
    }

    @WorkerThread
    public void zza(final AtomicReference<String> atomicReference) {
        this.zzmq();
        this.zznA();
        this.zzo(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicReference atomicReference2 = atomicReference;
                synchronized (atomicReference2) {
                    try {
                        zzate zzate2 = zzatw.this.zzbuA;
                        if (zzate2 == null) {
                            zzatw.this.zzJt().zzLa().log("Failed to get app instance id");
                            return;
                        }
                        atomicReference.set(zzate2.zzc(zzatw.this.zzJj().zzfH(null)));
                        zzatw.this.zznN();
                    }
                    catch (RemoteException remoteException) {
                        zzatw.this.zzJt().zzLa().zzj("Failed to get app instance id", (Object)remoteException);
                    }
                    finally {
                        atomicReference.notify();
                    }
                }
            }
        });
    }

    @WorkerThread
    protected void zzLR() {
        this.zzmq();
        this.zznA();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzate zzate2 = zzatw.this.zzbuA;
                if (zzate2 == null) {
                    zzatw.this.zzJt().zzLa().log("Discarding data. Failed to send app launch");
                    return;
                }
                try {
                    zzatw.this.zza(zzate2, null);
                    zzate2.zza(zzatw.this.zzJj().zzfH(zzatw.this.zzJt().zzLh()));
                    zzatw.this.zznN();
                }
                catch (RemoteException remoteException) {
                    zzatw.this.zzJt().zzLa().zzj("Failed to send app launch to the service", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    protected void zza(final AppMeasurement.zzf zzf2) {
        this.zzmq();
        this.zznA();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzate zzate2 = zzatw.this.zzbuA;
                if (zzate2 == null) {
                    zzatw.this.zzJt().zzLa().log("Failed to send current screen to service");
                    return;
                }
                try {
                    if (zzf2 == null) {
                        zzate2.zza(0L, null, null, zzatw.this.getContext().getPackageName());
                    } else {
                        zzate2.zza(zzf2.zzbpB, zzf2.zzbpz, zzf2.zzbpA, zzatw.this.getContext().getPackageName());
                    }
                    zzatw.this.zznN();
                }
                catch (RemoteException remoteException) {
                    zzatw.this.zzJt().zzLa().zzj("Failed to send current screen to the service", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    private void zznN() {
        this.zzmq();
        this.zzbuD.start();
        this.zzbuC.zzx(this.zzJv().zzoQ());
    }

    @WorkerThread
    void zzoc() {
        this.zzmq();
        this.zznA();
        if (this.isConnected()) {
            return;
        }
        if (this.zzbuB == null) {
            this.zzbuB = this.zzJu().zzLn();
            if (this.zzbuB == null) {
                this.zzJt().zzLg().log("State of service unknown");
                this.zzbuB = this.zzLY();
                this.zzJu().zzaF(this.zzbuB);
            }
        }
        if (this.zzbuB.booleanValue()) {
            this.zzJt().zzLg().log("Using measurement service");
            this.zzbuz.zzMb();
        } else {
            if (this.zzLX()) {
                this.zzJt().zzLg().log("Using local app measurement service");
                Intent intent = new Intent("com.google.android.gms.measurement.START");
                Context context = this.getContext();
                this.zzJv().zzKk();
                intent.setComponent(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementService"));
                this.zzbuz.zzC(intent);
                return;
            }
            this.zzJt().zzLa().log("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    private boolean zzLX() {
        this.zzJv().zzKk();
        PackageManager packageManager = this.getContext().getPackageManager();
        Intent intent = new Intent().setClassName(this.getContext(), "com.google.android.gms.measurement.AppMeasurementService");
        List list = packageManager.queryIntentServices(intent, 65536);
        return list != null && list.size() > 0;
    }

    @WorkerThread
    protected boolean zzLY() {
        this.zzmq();
        this.zznA();
        this.zzJv().zzKk();
        this.zzJt().zzLg().log("Checking service availability");
        int n = zzc.zzuz().isGooglePlayServicesAvailable(this.getContext());
        switch (n) {
            case 0: {
                this.zzJt().zzLg().log("Service available");
                return true;
            }
            case 1: {
                this.zzJt().zzLg().log("Service missing");
                return false;
            }
            case 18: {
                this.zzJt().zzLc().log("Service updating");
                return true;
            }
            case 2: {
                this.zzJt().zzLf().log("Service container out of date");
                return true;
            }
            case 3: {
                this.zzJt().zzLc().log("Service disabled");
                return false;
            }
            case 9: {
                this.zzJt().zzLc().log("Service invalid");
                return false;
            }
        }
        return false;
    }

    @WorkerThread
    private void zza(zzate zzate2) {
        this.zzmq();
        zzac.zzw((Object)zzate2);
        this.zzbuA = zzate2;
        this.zznN();
        this.zzMa();
    }

    @WorkerThread
    public void disconnect() {
        this.zzmq();
        this.zznA();
        try {
            com.google.android.gms.common.stats.zza zza2 = com.google.android.gms.common.stats.zza.zzyc();
            zza2.zza(this.getContext(), (ServiceConnection)this.zzbuz);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzbuA = null;
    }

    @WorkerThread
    private void onServiceDisconnected(ComponentName componentName) {
        this.zzmq();
        if (this.zzbuA != null) {
            this.zzbuA = null;
            this.zzJt().zzLg().zzj("Disconnected from device MeasurementService", componentName);
            this.zzLZ();
        }
    }

    @WorkerThread
    private void zznO() {
        this.zzmq();
        if (!this.isConnected()) {
            return;
        }
        this.zzJt().zzLg().log("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private void zzLZ() {
        this.zzmq();
        this.zzoc();
    }

    @WorkerThread
    private void zzo(Runnable runnable) throws IllegalStateException {
        this.zzmq();
        if (this.isConnected()) {
            runnable.run();
        } else {
            if ((long)this.zzbuE.size() >= this.zzJv().zzKq()) {
                this.zzJt().zzLa().log("Discarding data. Max runnable queue size reached");
                return;
            }
            this.zzbuE.add(runnable);
            this.zzbuF.zzx(60000L);
            this.zzoc();
        }
    }

    @WorkerThread
    private void zzMa() {
        this.zzmq();
        this.zzJt().zzLg().zzj("Processing queued up service tasks", this.zzbuE.size());
        for (Runnable runnable : this.zzbuE) {
            this.zzJs().zzm(runnable);
        }
        this.zzbuE.clear();
        this.zzbuF.cancel();
    }

    protected class zza
    implements ServiceConnection,
    zzf.zzb,
    zzf.zzc {
        private volatile boolean zzbuL;
        private volatile zzath zzbuM;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzC(Intent intent) {
            zzatw.this.zzmq();
            Context context = zzatw.this.getContext();
            com.google.android.gms.common.stats.zza zza2 = com.google.android.gms.common.stats.zza.zzyc();
            zza zza3 = this;
            synchronized (zza3) {
                if (this.zzbuL) {
                    zzatw.this.zzJt().zzLg().log("Connection attempt already in progress");
                    return;
                }
                this.zzbuL = true;
                zza2.zza(context, intent, (ServiceConnection)zzatw.this.zzbuz, 129);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            zzac.zzdn((String)"MeasurementServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                Object object;
                if (iBinder == null) {
                    this.zzbuL = false;
                    zzatw.this.zzJt().zzLa().log("Service connected with null binder");
                    return;
                }
                zzate zzate2 = null;
                try {
                    object = iBinder.getInterfaceDescriptor();
                    if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(object)) {
                        zzate2 = zzate.zza.zzer(iBinder);
                        zzatw.this.zzJt().zzLg().log("Bound to IMeasurementService interface");
                    } else {
                        zzatw.this.zzJt().zzLa().zzj("Got binder with a wrong descriptor", object);
                    }
                }
                catch (RemoteException remoteException) {
                    zzatw.this.zzJt().zzLa().log("Service connect failed to get IMeasurementService");
                }
                if (zzate2 == null) {
                    this.zzbuL = false;
                    try {
                        com.google.android.gms.common.stats.zza.zzyc().zza(zzatw.this.getContext(), (ServiceConnection)zzatw.this.zzbuz);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else {
                    object = zzate2;
                    zzatw.this.zzJs().zzm(new Runnable((zzate)object){
                        final /* synthetic */ zzate zzbuN;
                        {
                            this.zzbuN = zzate2;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            zza zza2 = zza.this;
                            synchronized (zza2) {
                                zza.this.zzbuL = false;
                                if (!zzatw.this.isConnected()) {
                                    zzatw.this.zzJt().zzLg().log("Connected to service");
                                    zzatw.this.zza(this.zzbuN);
                                }
                            }
                        }
                    });
                }
            }
        }

        @MainThread
        public void onServiceDisconnected(final ComponentName componentName) {
            zzac.zzdn((String)"MeasurementServiceConnection.onServiceDisconnected");
            zzatw.this.zzJt().zzLf().log("Service disconnected");
            zzatw.this.zzJs().zzm(new Runnable(){

                @Override
                public void run() {
                    zzatw.this.onServiceDisconnected(componentName);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzMb() {
            zzatw.this.zzmq();
            Context context = zzatw.this.getContext();
            zza zza2 = this;
            synchronized (zza2) {
                if (this.zzbuL) {
                    zzatw.this.zzJt().zzLg().log("Connection attempt already in progress");
                    return;
                }
                if (this.zzbuM != null) {
                    zzatw.this.zzJt().zzLg().log("Already awaiting connection attempt");
                    return;
                }
                this.zzbuM = new zzath(context, Looper.getMainLooper(), this, this);
                zzatw.this.zzJt().zzLg().log("Connecting to remote service");
                this.zzbuL = true;
                this.zzbuM.zzwT();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onConnected(@Nullable Bundle bundle) {
            zzac.zzdn((String)"MeasurementServiceConnection.onConnected");
            zza zza2 = this;
            synchronized (zza2) {
                try {
                    final zzate zzate2 = (zzate)this.zzbuM.zzwW();
                    this.zzbuM = null;
                    zzatw.this.zzJs().zzm(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            zza zza2 = zza.this;
                            synchronized (zza2) {
                                zza.this.zzbuL = false;
                                if (!zzatw.this.isConnected()) {
                                    zzatw.this.zzJt().zzLf().log("Connected to remote service");
                                    zzatw.this.zza(zzate2);
                                }
                            }
                        }
                    });
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    this.zzbuM = null;
                    this.zzbuL = false;
                }
            }
        }

        @MainThread
        public void onConnectionSuspended(int n) {
            zzac.zzdn((String)"MeasurementServiceConnection.onConnectionSuspended");
            zzatw.this.zzJt().zzLf().log("Service connection suspended");
            zzatw.this.zzJs().zzm(new Runnable(){

                @Override
                public void run() {
                    zzatw zzatw2 = zzatw.this;
                    Context context = zzatw.this.getContext();
                    zzatw.this.zzJv().zzKk();
                    zzatw2.onServiceDisconnected(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementService"));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzac.zzdn((String)"MeasurementServiceConnection.onConnectionFailed");
            zzati zzati2 = zzatw.this.zzbpw.zzLu();
            if (zzati2 != null) {
                zzati2.zzLc().zzj("Service connection failed", connectionResult);
            }
            zza zza2 = this;
            synchronized (zza2) {
                this.zzbuL = false;
                this.zzbuM = null;
            }
        }
    }
}

