/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Build;
import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzatp;
import com.google.android.gms.internal.zzatr;
import com.google.android.gms.internal.zzatv;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;

public class zzaso
extends zzatr {
    private final Map<String, Long> zzbpF;
    private final Map<String, Integer> zzbpG = new ArrayMap();
    private long zzbpH;

    public zzaso(zzatp zzatp2) {
        super(zzatp2);
        this.zzbpF = new ArrayMap();
    }

    public void beginAdUnitExposure(final String string) {
        if (Build.VERSION.SDK_INT < 14) {
            return;
        }
        if (string == null || string.length() == 0) {
            this.zzJt().zzLa().log("Ad unit id must be a non-empty string");
            return;
        }
        final long l = this.zznq().elapsedRealtime();
        this.zzJs().zzm(new Runnable(){

            @Override
            public void run() {
                zzaso.this.zzf(string, l);
            }
        });
    }

    @WorkerThread
    private void zzf(String string, long l) {
        Integer n;
        this.zzJe();
        this.zzmq();
        zzac.zzdv((String)string);
        if (this.zzbpG.isEmpty()) {
            this.zzbpH = l;
        }
        if ((n = this.zzbpG.get(string)) != null) {
            this.zzbpG.put(string, n + 1);
        } else {
            if (this.zzbpG.size() >= 100) {
                this.zzJt().zzLc().log("Too many ads visible");
                return;
            }
            this.zzbpG.put(string, 1);
            this.zzbpF.put(string, l);
        }
    }

    public void endAdUnitExposure(final String string) {
        if (Build.VERSION.SDK_INT < 14) {
            return;
        }
        if (string == null || string.length() == 0) {
            this.zzJt().zzLa().log("Ad unit id must be a non-empty string");
            return;
        }
        final long l = this.zznq().elapsedRealtime();
        this.zzJs().zzm(new Runnable(){

            @Override
            public void run() {
                zzaso.this.zzg(string, l);
            }
        });
    }

    @WorkerThread
    private void zzg(String string, long l) {
        this.zzJe();
        this.zzmq();
        zzac.zzdv((String)string);
        Integer n = this.zzbpG.get(string);
        if (n != null) {
            zzatv.zza zza2 = this.zzJm().zzLU();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zzbpG.remove(string);
                Long l2 = this.zzbpF.get(string);
                if (l2 == null) {
                    this.zzJt().zzLa().log("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zzbpF.remove(string);
                    this.zza(string, l3, zza2);
                }
                if (this.zzbpG.isEmpty()) {
                    if (this.zzbpH == 0L) {
                        this.zzJt().zzLa().log("First ad exposure time was never set");
                    } else {
                        this.zza(l - this.zzbpH, zza2);
                        this.zzbpH = 0L;
                    }
                }
            } else {
                this.zzbpG.put(string, n2);
            }
        } else {
            this.zzJt().zzLa().zzj("Call to endAdUnitExposure for unknown ad unit id", string);
        }
    }

    @WorkerThread
    private void zza(long l, AppMeasurement.zzf zzf2) {
        if (zzf2 == null) {
            this.zzJt().zzLg().log("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzJt().zzLg().zzj("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzatv.zza(zzf2, bundle);
        this.zzJi().zze("am", "_xa", bundle);
    }

    @WorkerThread
    private void zza(String string, long l, AppMeasurement.zzf zzf2) {
        if (zzf2 == null) {
            this.zzJt().zzLg().log("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzJt().zzLg().zzj("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzatv.zza(zzf2, bundle);
        this.zzJi().zze("am", "_xu", bundle);
    }

    @WorkerThread
    public void zzV(long l) {
        zzatv.zza zza2 = this.zzJm().zzLU();
        for (String string : this.zzbpF.keySet()) {
            long l2 = this.zzbpF.get(string);
            this.zza(string, l - l2, zza2);
        }
        if (!this.zzbpF.isEmpty()) {
            this.zza(l - this.zzbpH, zza2);
        }
        this.zzW(l);
    }

    public void zzJc() {
        final long l = this.zznq().elapsedRealtime();
        this.zzJs().zzm(new Runnable(){

            @Override
            public void run() {
                zzaso.this.zzW(l);
            }
        });
    }

    @WorkerThread
    private void zzW(long l) {
        for (String string : this.zzbpF.keySet()) {
            this.zzbpF.put(string, l);
        }
        if (!this.zzbpF.isEmpty()) {
            this.zzbpH = l;
        }
    }
}

