/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzatp;
import com.google.android.gms.internal.zzats;
import com.google.android.gms.internal.zzaue;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Locale;

class zzatl
extends zzats {
    static final Pair<String, Long> zzbse = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzafC;
    public final zzc zzbsf = new zzc("health_monitor", this.zzJv().zzoZ());
    public final zzb zzbsg = new zzb("last_upload", 0L);
    public final zzb zzbsh = new zzb("last_upload_attempt", 0L);
    public final zzb zzbsi = new zzb("backoff", 0L);
    public final zzb zzbsj = new zzb("last_delete_stale", 0L);
    public final zzb zzbsk;
    private String zzbsl;
    private boolean zzbsm;
    private long zzbsn;
    private SecureRandom zzbso;
    public final zzb zzbsp = new zzb("time_before_start", 10000L);
    public final zzb zzbsq = new zzb("session_timeout", 1800000L);
    public final zza zzbsr = new zza("start_new_session", true);
    public final zzb zzbss = new zzb("last_pause_time", 0L);
    public final zzb zzbst = new zzb("time_active", 0L);
    public boolean zzbsu;

    @WorkerThread
    private SecureRandom zzLi() {
        this.zzmq();
        if (this.zzbso == null) {
            this.zzbso = new SecureRandom();
        }
        return this.zzbso;
    }

    @WorkerThread
    @NonNull
    Pair<String, Boolean> zzfK(String string) {
        this.zzmq();
        long l = this.zznq().elapsedRealtime();
        if (this.zzbsl != null && l < this.zzbsn) {
            return new Pair((Object)this.zzbsl, (Object)this.zzbsm);
        }
        this.zzbsn = l + this.zzJv().zzfq(string);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            this.zzbsl = info.getId();
            if (this.zzbsl == null) {
                this.zzbsl = "";
            }
            this.zzbsm = info.isLimitAdTrackingEnabled();
        }
        catch (Throwable throwable) {
            this.zzJt().zzLf().zzj("Unable to get advertising id", throwable);
            this.zzbsl = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzbsl, (Object)this.zzbsm);
    }

    @WorkerThread
    String zzfL(String string) {
        this.zzmq();
        String string2 = (String)this.zzfK((String)string).first;
        MessageDigest messageDigest = zzaue.zzcg("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    @WorkerThread
    String zzLj() {
        byte[] byArray = new byte[16];
        this.zzLi().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    String zzJy() {
        this.zzmq();
        try {
            return com.google.firebase.iid.zzc.zzaab().getId();
        }
        catch (IllegalStateException illegalStateException) {
            this.zzJt().zzLc().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    @WorkerThread
    long zzLk() {
        this.zznA();
        this.zzmq();
        long l = this.zzbsk.get();
        if (l == 0L) {
            l = 1 + this.zzLi().nextInt(86400000);
            this.zzbsk.set(l);
        }
        return l;
    }

    zzatl(zzatp zzatp2) {
        super(zzatp2);
        this.zzbsk = new zzb("midnight_offset", 0L);
    }

    @Override
    protected void zzmr() {
        this.zzafC = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzbsu = this.zzafC.getBoolean("has_been_opened", false);
        if (!this.zzbsu) {
            SharedPreferences.Editor editor = this.zzafC.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
    }

    @WorkerThread
    private SharedPreferences zzLl() {
        this.zzmq();
        this.zznA();
        return this.zzafC;
    }

    @WorkerThread
    void zzfM(String string) {
        this.zzmq();
        SharedPreferences.Editor editor = this.zzLl().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    String zzLm() {
        this.zzmq();
        return this.zzLl().getString("gmp_app_id", null);
    }

    @WorkerThread
    Boolean zzLn() {
        this.zzmq();
        if (!this.zzLl().contains("use_service")) {
            return null;
        }
        return this.zzLl().getBoolean("use_service", false);
    }

    @WorkerThread
    void zzaF(boolean bl) {
        this.zzmq();
        this.zzJt().zzLg().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzLl().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    void zzLo() {
        this.zzmq();
        this.zzJt().zzLg().log("Clearing collection preferences.");
        boolean bl = this.zzLl().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzaG(true);
        }
        SharedPreferences.Editor editor = this.zzLl().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    void setMeasurementEnabled(boolean bl) {
        this.zzmq();
        this.zzJt().zzLg().zzj("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzLl().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    boolean zzaG(boolean bl) {
        this.zzmq();
        return this.zzLl().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected String zzLp() {
        this.zzmq();
        String string = this.zzLl().getString("previous_os_version", null);
        String string2 = this.zzJk().zzKU();
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzLl().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    public final class zza {
        private final String zzAH;
        private final boolean zzbsv;
        private boolean zzbsw;
        private boolean zzaxF;

        public zza(String string, boolean bl) {
            zzac.zzdv((String)string);
            this.zzAH = string;
            this.zzbsv = bl;
        }

        @WorkerThread
        private void zzLq() {
            if (this.zzbsw) {
                return;
            }
            this.zzbsw = true;
            this.zzaxF = zzatl.this.zzafC.getBoolean(this.zzAH, this.zzbsv);
        }

        @WorkerThread
        public boolean get() {
            this.zzLq();
            return this.zzaxF;
        }

        @WorkerThread
        public void set(boolean bl) {
            SharedPreferences.Editor editor = zzatl.this.zzafC.edit();
            editor.putBoolean(this.zzAH, bl);
            editor.apply();
            this.zzaxF = bl;
        }
    }

    public final class zzb {
        private final String zzAH;
        private final long zzbsy;
        private boolean zzbsw;
        private long zzacc;

        public zzb(String string, long l) {
            zzac.zzdv((String)string);
            this.zzAH = string;
            this.zzbsy = l;
        }

        @WorkerThread
        private void zzLq() {
            if (this.zzbsw) {
                return;
            }
            this.zzbsw = true;
            this.zzacc = zzatl.this.zzafC.getLong(this.zzAH, this.zzbsy);
        }

        @WorkerThread
        public long get() {
            this.zzLq();
            return this.zzacc;
        }

        @WorkerThread
        public void set(long l) {
            SharedPreferences.Editor editor = zzatl.this.zzafC.edit();
            editor.putLong(this.zzAH, l);
            editor.apply();
            this.zzacc = l;
        }
    }

    public final class zzc {
        final String zzbsz;
        private final String zzbsA;
        private final String zzbsB;
        private final long zzafG;

        private zzc(String string, long l) {
            zzac.zzdv((String)string);
            zzac.zzas((l > 0L ? 1 : 0) != 0);
            this.zzbsz = String.valueOf(string).concat(":start");
            this.zzbsA = String.valueOf(string).concat(":count");
            this.zzbsB = String.valueOf(string).concat(":value");
            this.zzafG = l;
        }

        @WorkerThread
        private void zzpK() {
            zzatl.this.zzmq();
            long l = zzatl.this.zznq().currentTimeMillis();
            SharedPreferences.Editor editor = zzatl.this.zzafC.edit();
            editor.remove(this.zzbsA);
            editor.remove(this.zzbsB);
            editor.putLong(this.zzbsz, l);
            editor.apply();
        }

        @WorkerThread
        private long zzpL() {
            zzatl.this.zzmq();
            long l = this.zzpN();
            if (l == 0L) {
                this.zzpK();
                return 0L;
            }
            return Math.abs(l - zzatl.this.zznq().currentTimeMillis());
        }

        @WorkerThread
        public void zzcb(String string) {
            this.zzi(string, 1L);
        }

        @WorkerThread
        public void zzi(String string, long l) {
            long l2;
            zzatl.this.zzmq();
            long l3 = this.zzpN();
            if (l3 == 0L) {
                this.zzpK();
            }
            if (string == null) {
                string = "";
            }
            if ((l2 = zzatl.this.zzafC.getLong(this.zzbsA, 0L)) <= 0L) {
                SharedPreferences.Editor editor = zzatl.this.zzafC.edit();
                editor.putString(this.zzbsB, string);
                editor.putLong(this.zzbsA, l);
                editor.apply();
                return;
            }
            long l4 = zzatl.this.zzLi().nextLong() & Long.MAX_VALUE;
            boolean bl = l4 < Long.MAX_VALUE / (l2 + l) * l;
            SharedPreferences.Editor editor = zzatl.this.zzafC.edit();
            if (bl) {
                editor.putString(this.zzbsB, string);
            }
            editor.putLong(this.zzbsA, l2 + l);
            editor.apply();
        }

        @WorkerThread
        public Pair<String, Long> zzpM() {
            zzatl.this.zzmq();
            long l = this.zzpL();
            if (l < this.zzafG) {
                return null;
            }
            if (l > this.zzafG * 2L) {
                this.zzpK();
                return null;
            }
            String string = zzatl.this.zzLl().getString(this.zzbsB, null);
            long l2 = zzatl.this.zzLl().getLong(this.zzbsA, 0L);
            this.zzpK();
            if (string == null || l2 <= 0L) {
                return zzbse;
            }
            return new Pair((Object)string, (Object)l2);
        }

        @WorkerThread
        private long zzpN() {
            return zzatl.this.zzLl().getLong(this.zzbsz, 0L);
        }
    }
}

