/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzatp;
import com.google.android.gms.internal.zzats;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;

public class zzato
extends zzats {
    private zzd zzbsM;
    private zzd zzbsN;
    private final PriorityBlockingQueue<FutureTask<?>> zzbsO;
    private final BlockingQueue<FutureTask<?>> zzbsP;
    private final Thread.UncaughtExceptionHandler zzbsQ;
    private final Thread.UncaughtExceptionHandler zzbsR;
    private final Object zzbsS = new Object();
    private final Semaphore zzbsT = new Semaphore(2);
    private volatile boolean zzbsU;
    private static final AtomicLong zzbsV = new AtomicLong(Long.MIN_VALUE);

    zzato(zzatp zzatp2) {
        super(zzatp2);
        this.zzbsO = new PriorityBlockingQueue();
        this.zzbsP = new LinkedBlockingQueue();
        this.zzbsQ = new zzb("Thread death: Uncaught exception on worker thread");
        this.zzbsR = new zzb("Thread death: Uncaught exception on network thread");
    }

    @Override
    protected void zzmr() {
    }

    @Override
    public void zzmq() {
        if (Thread.currentThread() != this.zzbsM) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public void zzJf() {
        if (Thread.currentThread() != this.zzbsN) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public boolean zzbd() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public boolean zzLr() {
        return Thread.currentThread() == this.zzbsM;
    }

    public <V> Future<V> zzd(Callable<V> callable) throws IllegalStateException {
        this.zznA();
        zzac.zzw(callable);
        zzc<V> zzc2 = new zzc<V>(callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzbsM) {
            zzc2.run();
        } else {
            this.zza(zzc2);
        }
        return zzc2;
    }

    public <V> Future<V> zze(Callable<V> callable) throws IllegalStateException {
        this.zznA();
        zzac.zzw(callable);
        zzc<V> zzc2 = new zzc<V>(callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzbsM) {
            zzc2.run();
        } else {
            this.zza(zzc2);
        }
        return zzc2;
    }

    public void zzm(Runnable runnable) throws IllegalStateException {
        this.zznA();
        zzac.zzw((Object)runnable);
        this.zza(new zzc(runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(zzc<?> zzc2) {
        Object object = this.zzbsS;
        synchronized (object) {
            this.zzbsO.add(zzc2);
            if (this.zzbsM == null) {
                this.zzbsM = new zzd("Measurement Worker", this.zzbsO);
                this.zzbsM.setUncaughtExceptionHandler(this.zzbsQ);
                this.zzbsM.start();
            } else {
                this.zzbsM.zzhf();
            }
        }
    }

    public void zzn(Runnable runnable) throws IllegalStateException {
        this.zznA();
        zzac.zzw((Object)runnable);
        this.zza(new zzc(runnable, false, "Task exception on network thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(FutureTask<?> futureTask) {
        Object object = this.zzbsS;
        synchronized (object) {
            this.zzbsP.add(futureTask);
            if (this.zzbsN == null) {
                this.zzbsN = new zzd("Measurement Network", this.zzbsP);
                this.zzbsN.setUncaughtExceptionHandler(this.zzbsR);
                this.zzbsN.start();
            } else {
                this.zzbsN.zzhf();
            }
        }
    }

    static class zza
    extends RuntimeException {
    }

    private final class zzb
    implements Thread.UncaughtExceptionHandler {
        private final String zzbsW;

        public zzb(String string) {
            zzac.zzw((Object)string);
            this.zzbsW = string;
        }

        @Override
        public synchronized void uncaughtException(Thread thread, Throwable throwable) {
            zzato.this.zzJt().zzLa().zzj(this.zzbsW, throwable);
        }
    }

    private final class zzc<V>
    extends FutureTask<V>
    implements Comparable<zzc> {
        private final long zzbsY;
        private final boolean zzbsZ;
        private final String zzbsW;

        zzc(Callable<V> callable, boolean bl, String string) {
            super(callable);
            zzac.zzw((Object)string);
            this.zzbsY = zzbsV.getAndIncrement();
            this.zzbsW = string;
            this.zzbsZ = bl;
            if (this.zzbsY == Long.MAX_VALUE) {
                zzato.this.zzJt().zzLa().log("Tasks index overflow");
            }
        }

        zzc(Runnable runnable, boolean bl, String string) {
            super(runnable, null);
            zzac.zzw((Object)string);
            this.zzbsY = zzbsV.getAndIncrement();
            this.zzbsW = string;
            this.zzbsZ = bl;
            if (this.zzbsY == Long.MAX_VALUE) {
                zzato.this.zzJt().zzLa().log("Tasks index overflow");
            }
        }

        @Override
        protected void setException(Throwable throwable) {
            zzato.this.zzJt().zzLa().zzj(this.zzbsW, throwable);
            if (throwable instanceof zza) {
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), throwable);
            }
            super.setException(throwable);
        }

        public int zzb(@NonNull zzc zzc2) {
            if (this.zzbsZ != zzc2.zzbsZ) {
                return this.zzbsZ ? -1 : 1;
            }
            if (this.zzbsY < zzc2.zzbsY) {
                return -1;
            }
            if (this.zzbsY > zzc2.zzbsY) {
                return 1;
            }
            zzato.this.zzJt().zzLb().zzj("Two tasks share the same index. index", this.zzbsY);
            return 0;
        }

        @Override
        public /* synthetic */ int compareTo(@NonNull Object object) {
            return this.zzb((zzc)object);
        }
    }

    private final class zzd
    extends Thread {
        private final Object zzbta;
        private final BlockingQueue<FutureTask<?>> zzbtb;

        public zzd(String string, BlockingQueue<FutureTask<?>> blockingQueue) {
            zzac.zzw((Object)string);
            zzac.zzw(blockingQueue);
            this.zzbta = new Object();
            this.zzbtb = blockingQueue;
            this.setName(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean bl = false;
            while (!bl) {
                try {
                    zzato.this.zzbsT.acquire();
                    bl = true;
                }
                catch (InterruptedException interruptedException) {
                    this.zza(interruptedException);
                }
            }
            try {
                while (true) {
                    FutureTask futureTask;
                    if ((futureTask = (FutureTask)this.zzbtb.poll()) != null) {
                        futureTask.run();
                        continue;
                    }
                    Object object = this.zzbta;
                    synchronized (object) {
                        if (this.zzbtb.peek() == null && !zzato.this.zzbsU) {
                            try {
                                this.zzbta.wait(30000L);
                            }
                            catch (InterruptedException interruptedException) {
                                this.zza(interruptedException);
                            }
                        }
                    }
                    object = zzato.this.zzbsS;
                    synchronized (object) {
                        if (this.zzbtb.peek() == null) {
                            return;
                        }
                    }
                }
            }
            finally {
                Object object = zzato.this.zzbsS;
                synchronized (object) {
                    zzato.this.zzbsT.release();
                    zzato.this.zzbsS.notifyAll();
                    if (this == zzato.this.zzbsM) {
                        zzato.this.zzbsM = null;
                    } else if (this == zzato.this.zzbsN) {
                        zzato.this.zzbsN = null;
                    } else {
                        zzato.this.zzJt().zzLa().log("Current scheduler thread is neither worker nor network");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzhf() {
            Object object = this.zzbta;
            synchronized (object) {
                this.zzbta.notifyAll();
            }
        }

        private void zza(InterruptedException interruptedException) {
            zzato.this.zzJt().zzLc().zzj(String.valueOf(this.getName()).concat(" was interrupted"), interruptedException);
        }
    }
}

