/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzx;
import com.google.android.gms.common.zze;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzasq;
import com.google.android.gms.internal.zzatb;
import com.google.android.gms.internal.zzate;
import com.google.android.gms.internal.zzati;
import com.google.android.gms.internal.zzatp;
import com.google.android.gms.internal.zzaub;
import com.google.android.gms.internal.zzaud;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class zzatq
extends zzate.zza {
    private final zzatp zzbpw;
    private Boolean zzbtL;
    @Nullable
    private String zzbtM;

    public zzatq(zzatp zzatp2) {
        this(zzatp2, null);
    }

    public zzatq(zzatp zzatp2, @Nullable String string) {
        zzac.zzw((Object)zzatp2);
        this.zzbpw = zzatp2;
        this.zzbtM = string;
    }

    @Override
    @BinderThread
    public void zzb(final zzasq zzasq2) {
        this.zzb(zzasq2, false);
        this.zzbpw.zzJs().zzm(new Runnable(){

            @Override
            public void run() {
                zzatq.this.zzbpw.zzLL();
                zzatq.this.zzbpw.zzd(zzasq2);
            }
        });
    }

    @Override
    @BinderThread
    public void zza(final zzatb zzatb2, final zzasq zzasq2) {
        zzac.zzw((Object)((Object)zzatb2));
        this.zzb(zzasq2, false);
        this.zzbpw.zzJs().zzm(new Runnable(){

            @Override
            public void run() {
                zzatq.this.zzbpw.zzLL();
                zzatq.this.zzbpw.zzb(zzatb2, zzasq2);
            }
        });
    }

    @Override
    @BinderThread
    public void zza(final zzatb zzatb2, final String string, String string2) {
        zzac.zzw((Object)((Object)zzatb2));
        zzac.zzdv((String)string);
        this.zzm(string, true);
        this.zzbpw.zzJs().zzm(new Runnable(){

            @Override
            public void run() {
                zzatq.this.zzbpw.zzLL();
                zzatq.this.zzbpw.zzb(zzatb2, string);
            }
        });
    }

    @Override
    @BinderThread
    public byte[] zza(final zzatb zzatb2, final String string) {
        zzac.zzdv((String)string);
        zzac.zzw((Object)((Object)zzatb2));
        this.zzm(string, true);
        this.zzbpw.zzJt().zzLf().zzj("Log and bundle. event", zzatb2.name);
        long l = this.zzbpw.zznq().nanoTime() / 1000000L;
        Future<byte[]> future = this.zzbpw.zzJs().zze(new Callable<byte[]>(){

            public byte[] zzLN() throws Exception {
                zzatq.this.zzbpw.zzLL();
                return zzatq.this.zzbpw.zza(zzatb2, string);
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzLN();
            }
        });
        try {
            byte[] byArray = future.get();
            if (byArray == null) {
                this.zzbpw.zzJt().zzLa().zzj("Log and bundle returned null. appId", zzati.zzfI(string));
                byArray = new byte[]{};
            }
            long l2 = this.zzbpw.zznq().nanoTime() / 1000000L;
            this.zzbpw.zzJt().zzLf().zzd("Log and bundle processed. event, size, time_ms", zzatb2.name, byArray.length, l2 - l);
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzbpw.zzJt().zzLa().zzd("Failed to log and bundle. appId, event, error", zzati.zzfI(string), zzatb2.name, exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public void zza(final zzaub zzaub2, final zzasq zzasq2) {
        zzac.zzw((Object)((Object)zzaub2));
        this.zzb(zzasq2, false);
        if (zzaub2.getValue() == null) {
            this.zzbpw.zzJs().zzm(new Runnable(){

                @Override
                public void run() {
                    zzatq.this.zzbpw.zzLL();
                    zzatq.this.zzbpw.zzc(zzaub2, zzasq2);
                }
            });
        } else {
            this.zzbpw.zzJs().zzm(new Runnable(){

                @Override
                public void run() {
                    zzatq.this.zzbpw.zzLL();
                    zzatq.this.zzbpw.zzb(zzaub2, zzasq2);
                }
            });
        }
    }

    @Override
    @BinderThread
    public List<zzaub> zza(final zzasq zzasq2, boolean bl) {
        this.zzb(zzasq2, false);
        Future<List<zzaud>> future = this.zzbpw.zzJs().zzd(new Callable<List<zzaud>>(){

            public List<zzaud> zzLO() throws Exception {
                zzatq.this.zzbpw.zzLL();
                return zzatq.this.zzbpw.zzJo().zzfx(zzasq2.packageName);
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzLO();
            }
        });
        try {
            List<zzaud> list = future.get();
            ArrayList<zzaub> arrayList = new ArrayList<zzaub>(list.size());
            for (zzaud zzaud2 : list) {
                if (!bl && zzaue.zzgg(zzaud2.mName)) continue;
                arrayList.add(new zzaub(zzaud2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzbpw.zzJt().zzLa().zze("Failed to get user attributes. appId", zzati.zzfI(zzasq2.packageName), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public void zza(final zzasq zzasq2) {
        this.zzb(zzasq2, false);
        this.zzbpw.zzJs().zzm(new Runnable(){

            @Override
            public void run() {
                zzatq.this.zzbpw.zzLL();
                zzatq.this.zzbpw.zze(zzasq2);
            }
        });
    }

    @BinderThread
    private void zzb(zzasq zzasq2, boolean bl) {
        zzac.zzw((Object)((Object)zzasq2));
        this.zzm(zzasq2.packageName, bl);
        this.zzbpw.zzJp().zzgd(zzasq2.zzbqf);
    }

    @BinderThread
    private void zzm(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzbpw.zzJt().zzLa().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            this.zzn(string, bl);
        }
        catch (SecurityException securityException) {
            this.zzbpw.zzJt().zzLa().zzj("Measurement Service called with invalid calling package. appId", zzati.zzfI(string));
            throw securityException;
        }
    }

    @Override
    @BinderThread
    public void zza(final long l, final String string, final String string2, final String string3) {
        this.zzbpw.zzJs().zzm(new Runnable(){

            @Override
            public void run() {
                if (string2 == null) {
                    zzatq.this.zzbpw.zzJm().zza(string3, null);
                    return;
                }
                AppMeasurement.zzf zzf2 = new AppMeasurement.zzf();
                zzf2.zzbpz = string;
                zzf2.zzbpA = string2;
                zzf2.zzbpB = l;
                zzatq.this.zzbpw.zzJm().zza(string3, zzf2);
            }
        });
    }

    @Override
    @BinderThread
    public String zzc(zzasq zzasq2) {
        this.zzb(zzasq2, false);
        return this.zzbpw.zzfR(zzasq2.packageName);
    }

    protected void zzn(String string, boolean bl) throws SecurityException {
        if (bl) {
            if (this.zzbtL == null) {
                this.zzbtL = "com.google.android.gms".equals(this.zzbtM) || zzx.zzf((Context)this.zzbpw.getContext(), (int)Binder.getCallingUid()) || zzf.zzav((Context)this.zzbpw.getContext()).zza(this.zzbpw.getContext().getPackageManager(), Binder.getCallingUid());
            }
            if (this.zzbtL.booleanValue()) {
                return;
            }
        }
        if (this.zzbtM == null && zze.zzc((Context)this.zzbpw.getContext(), (int)Binder.getCallingUid(), (String)string)) {
            this.zzbtM = string;
        }
        if (string.equals(this.zzbtM)) {
            return;
        }
        throw new SecurityException(String.format("Unknown calling package name '%s'.", string));
    }
}

