/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.internal.zzasz;
import com.google.android.gms.internal.zzatb;
import com.google.android.gms.internal.zzatp;
import com.google.android.gms.internal.zzats;
import com.google.android.gms.internal.zzatv;
import com.google.android.gms.internal.zzaub;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.measurement.AppMeasurement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;

public class zzatu
extends zzats {
    protected zza zzbtU;
    private AppMeasurement.zzb zzbtV;
    private final Set<AppMeasurement.zzc> zzbtW = new CopyOnWriteArraySet<AppMeasurement.zzc>();
    private boolean zzbtX;
    private String zzbtY = null;
    private String zzbtZ = null;

    protected zzatu(zzatp zzatp2) {
        super(zzatp2);
    }

    @Override
    protected void zzmr() {
    }

    @TargetApi(value=14)
    public void zzLQ() {
        if (this.getContext().getApplicationContext() instanceof Application) {
            Application application = (Application)this.getContext().getApplicationContext();
            if (this.zzbtU == null) {
                this.zzbtU = new zza();
            }
            application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzbtU);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzbtU);
            this.zzJt().zzLg().log("Registered activity lifecycle callback");
        }
    }

    public void setMeasurementEnabled(final boolean bl) {
        this.zznA();
        this.zzJe();
        this.zzJs().zzm(new Runnable(){

            @Override
            public void run() {
                zzatu.this.zzaH(bl);
            }
        });
    }

    @WorkerThread
    private void zzaH(boolean bl) {
        this.zzmq();
        this.zzJe();
        this.zznA();
        this.zzJt().zzLf().zzj("Setting app measurement enabled (FE)", bl);
        this.zzJu().setMeasurementEnabled(bl);
        this.zzJl().zzLW();
    }

    public void setMinimumSessionDuration(final long l) {
        this.zzJe();
        this.zzJs().zzm(new Runnable(){

            @Override
            public void run() {
                zzatu.this.zzJu().zzbsp.set(l);
                zzatu.this.zzJt().zzLf().zzj("Minimum session duration set", l);
            }
        });
    }

    public void setSessionTimeoutDuration(final long l) {
        this.zzJe();
        this.zzJs().zzm(new Runnable(){

            @Override
            public void run() {
                zzatu.this.zzJu().zzbsq.set(l);
                zzatu.this.zzJt().zzLf().zzj("Session timeout duration set", l);
            }
        });
    }

    public void zza(String string, String string2, Bundle bundle, boolean bl) {
        this.zzJe();
        boolean bl2 = this.zzbtV == null || zzaue.zzgg(string2);
        this.zza(string, string2, bundle, true, bl2, bl, null);
    }

    public void zze(String string, String string2, Bundle bundle) {
        this.zzJe();
        boolean bl = this.zzbtV == null || zzaue.zzgg(string2);
        this.zza(string, string2, bundle, true, bl, false, null);
    }

    public void zzd(String string, String string2, Bundle bundle, long l) {
        this.zzJe();
        this.zza(string, string2, l, bundle, false, true, true, null);
    }

    private void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.zza(string, string2, this.zznq().currentTimeMillis(), bundle, bl, bl2, bl3, string3);
    }

    Bundle zzN(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string : bundle.keySet()) {
                Object object = this.zzJp().zzl(string, bundle.get(string));
                if (object == null) {
                    this.zzJt().zzLc().zzj("Param value can't be null", string);
                    continue;
                }
                this.zzJp().zza(bundle2, string, object);
            }
        }
        return bundle2;
    }

    protected void zza(final String string, final String string2, final long l, Bundle bundle, final boolean bl, final boolean bl2, final boolean bl3, final String string3) {
        final Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
        this.zzJs().zzm(new Runnable(){

            @Override
            public void run() {
                zzatu.this.zzb(string, string2, l, bundle2, bl, bl2, bl3, string3);
            }
        });
    }

    @WorkerThread
    private void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzac.zzdv((String)string);
        zzac.zzdv((String)string2);
        zzac.zzw((Object)bundle);
        this.zzmq();
        this.zznA();
        if (!this.zzbpw.isEnabled()) {
            this.zzJt().zzLf().log("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zzbtX) {
            this.zzbtX = true;
            this.zzLS();
        }
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzaue.zzgg(string2);
        if (bl && this.zzbtV != null && !bl5 && !bl4) {
            this.zzJt().zzLf().zze("Passing event to registered event handler (FE)", string2, bundle);
            this.zzbtV.zzb(string, string2, bundle, l);
        } else {
            Object object;
            Object object2;
            if (!this.zzbpw.zzLt()) {
                return;
            }
            int n = this.zzJp().zzfY(string2);
            if (n != 0) {
                String string4 = this.zzJp().zza(string2, this.zzJv().zzJU(), true);
                int n2 = string2 != null ? string2.length() : 0;
                this.zzbpw.zzJp().zza(n, "_ev", string4, n2);
                return;
            }
            bundle.putString("_o", string);
            List list = zzf.zzx((Object)"_o");
            Bundle bundle2 = this.zzJp().zza(string2, bundle, list, bl3);
            if (!bundle.containsKey("_sc")) {
                this.zzJv().zzKk();
                object2 = this.zzJm().zzLU();
                if (object2 != null) {
                    object2.zzbuy = true;
                }
                object = object2;
                zzatv.zza((AppMeasurement.zzf)object, bundle2);
            }
            object = bl2 ? this.zzN(bundle2) : bundle2;
            this.zzJt().zzLf().zze("Logging event (FE)", string2, object);
            object2 = new zzatb(string2, new zzasz((Bundle)object), string, l);
            this.zzJl().zzc((zzatb)((Object)object2), string3);
            if (!bl4) {
                for (AppMeasurement.zzc zzc2 : this.zzbtW) {
                    Bundle bundle3 = new Bundle(object);
                    zzc2.zzc(string, string2, bundle3, l);
                }
            }
        }
    }

    public void zzd(String string, String string2, Object object) {
        zzac.zzdv((String)string);
        long l = this.zznq().currentTimeMillis();
        int n = this.zzJp().zzga(string2);
        if (n != 0) {
            String string3 = this.zzJp().zza(string2, this.zzJv().zzJV(), true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zzbpw.zzJp().zza(n, "_ev", string3, n2);
            return;
        }
        if (object != null) {
            n = this.zzJp().zzm(string2, object);
            if (n != 0) {
                String string4 = this.zzJp().zza(string2, this.zzJv().zzJV(), true);
                int n3 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    String string5 = String.valueOf(object);
                    n3 = string5.length();
                }
                this.zzbpw.zzJp().zza(n, "_ev", string4, n3);
                return;
            }
            Object object2 = this.zzJp().zzn(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
        } else {
            this.zza(string, string2, l, null);
        }
    }

    void zza(final String string, final String string2, final long l, final Object object) {
        this.zzJs().zzm(new Runnable(){

            @Override
            public void run() {
                zzatu.this.zza(string, string2, object, l);
            }
        });
    }

    @WorkerThread
    private void zza(String string, String string2, Object object, long l) {
        zzac.zzdv((String)string);
        zzac.zzdv((String)string2);
        this.zzmq();
        this.zzJe();
        this.zznA();
        if (!this.zzbpw.isEnabled()) {
            this.zzJt().zzLf().log("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzbpw.zzLt()) {
            return;
        }
        this.zzJt().zzLf().zze("Setting user property (FE)", string2, object);
        zzaub zzaub2 = new zzaub(string2, l, object, string);
        this.zzJl().zzb(zzaub2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<zzaub> zzaI(final boolean bl) {
        this.zzJe();
        this.zznA();
        this.zzJt().zzLf().log("Fetching user attributes (FE)");
        final AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (object) {
            this.zzbpw.zzJs().zzm(new Runnable(){

                @Override
                public void run() {
                    zzatu.this.zzJl().zza(atomicReference, bl);
                }
            });
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                this.zzJt().zzLc().zzj("Interrupted waiting for get user properties", interruptedException);
            }
        }
        object = (List)atomicReference.get();
        if (object == null) {
            this.zzJt().zzLc().log("Timed out waiting for get user properties");
            return Collections.emptyList();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @WorkerThread
    public synchronized String zzfS(String string) {
        AtomicReference atomicReference;
        this.zznA();
        this.zzJe();
        if (this.zzJs().zzLr()) {
            this.zzJt().zzLa().log("Cannot retrieve app instance id from analytics worker thread");
            return null;
        }
        if (this.zzJs().zzbd()) {
            this.zzJt().zzLa().log("Cannot retrieve app instance id from main thread");
            return null;
        }
        if (string != null && string.equals(this.zzbtZ)) {
            return this.zzbtY;
        }
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference2) {
            this.zzbpw.zzJs().zzm(new Runnable(){

                @Override
                public void run() {
                    zzatu.this.zzJl().zza(atomicReference);
                }
            });
            try {
                atomicReference.wait(30000L);
            }
            catch (InterruptedException interruptedException) {
                this.zzJt().zzLc().log("Interrupted waiting for app instance id");
                return null;
            }
        }
        this.zzbtZ = string;
        this.zzbtY = (String)atomicReference.get();
        return this.zzbtY;
    }

    @Nullable
    public String getAppInstanceIdOnPackageSide(String string) {
        this.zzJd();
        return this.zzbpw.zzfR(string);
    }

    @Nullable
    public String getGmpAppIdOnPackageSide(String string) {
        this.zzJd();
        return this.zzbpw.getGmpAppIdOnPackageSide(string);
    }

    @WorkerThread
    public void zzLR() {
        this.zzmq();
        this.zzJe();
        this.zznA();
        if (!this.zzbpw.zzLt()) {
            return;
        }
        this.zzJl().zzLR();
        String string = this.zzJu().zzLp();
        if (!TextUtils.isEmpty((CharSequence)string) && !string.equals(this.zzJk().zzKU())) {
            Bundle bundle = new Bundle();
            bundle.putString("_po", string);
            this.zze("auto", "_ou", bundle);
        }
    }

    @WorkerThread
    public void zza(AppMeasurement.zzb zzb2) {
        this.zzmq();
        this.zzJe();
        this.zznA();
        if (zzb2 != null && zzb2 != this.zzbtV) {
            zzac.zza((this.zzbtV == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzbtV = zzb2;
    }

    public void zza(AppMeasurement.zzc zzc2) {
        this.zzJe();
        this.zznA();
        zzac.zzw((Object)zzc2);
        if (!this.zzbtW.add(zzc2)) {
            this.zzJt().zzLc().log("OnEventListener already registered");
        }
    }

    @WorkerThread
    private void zzLS() {
        try {
            Class<?> clazz = Class.forName(this.zzLT());
            this.zzf(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.zzJt().zzLe().log("Tag Manager is not found and thus will not be used");
        }
    }

    private String zzLT() {
        return "com.google.android.gms.tagmanager.TagManagerService";
    }

    @WorkerThread
    public void zzf(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("initialize", Context.class);
            method.invoke(null, this.getContext());
        }
        catch (Exception exception) {
            this.zzJt().zzLc().zzj("Failed to invoke Tag Manager's initialize() method", exception);
        }
    }

    @MainThread
    @TargetApi(value=14)
    private class zza
    implements Application.ActivityLifecycleCallbacks {
        private zza() {
        }

        private boolean zzfT(String string) {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                zzatu.this.zzd("auto", "_ldl", string);
                return true;
            }
            return false;
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
            try {
                Uri uri;
                zzatu.this.zzJt().zzLg().log("onActivityCreated");
                Intent intent = activity.getIntent();
                if (intent != null && (uri = intent.getData()) != null && uri.isHierarchical()) {
                    boolean bl;
                    String string;
                    if (bundle == null) {
                        String string2;
                        string = zzatu.this.zzJp().zzu(uri);
                        String string3 = string2 = zzatu.this.zzJp().zzD(intent) ? "gs" : "auto";
                        if (string != null) {
                            zzatu.this.zze(string2, "_cmp", (Bundle)string);
                        }
                    }
                    if (TextUtils.isEmpty((CharSequence)(string = uri.getQueryParameter("referrer")))) {
                        return;
                    }
                    boolean bl2 = bl = string.contains("gclid") && (string.contains("utm_campaign") || string.contains("utm_source") || string.contains("utm_medium") || string.contains("utm_term") || string.contains("utm_content"));
                    if (!bl) {
                        zzatu.this.zzJt().zzLf().log("Activity created with data 'referrer' param without gclid and at least one utm field");
                        return;
                    }
                    zzatu.this.zzJt().zzLf().zzj("Activity created with referrer", string);
                    this.zzfT(string);
                }
            }
            catch (Throwable throwable) {
                zzatu.this.zzJt().zzLa().zzj("Throwable caught in onActivityCreated", throwable);
            }
            zzatu.this.zzJm().onActivityCreated(activity, bundle);
        }

        public void onActivityDestroyed(Activity activity) {
            zzatu.this.zzJm().onActivityDestroyed(activity);
        }

        @MainThread
        public void onActivityPaused(Activity activity) {
            zzatu.this.zzJm().onActivityPaused(activity);
            zzatu.this.zzJr().zzMe();
        }

        @MainThread
        public void onActivityResumed(Activity activity) {
            zzatu.this.zzJm().onActivityResumed(activity);
            zzatu.this.zzJr().zzMc();
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            zzatu.this.zzJm().onActivitySaveInstanceState(activity, bundle);
        }
    }
}

