/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzati;
import com.google.android.gms.internal.zzatp;
import com.google.android.gms.internal.zzatq;
import com.google.android.gms.internal.zzaue;

public final class zzatx {
    private final Handler mHandler;
    private final Context mContext;
    private final zza zzbuQ;

    public zzatx(zza zza2) {
        this.mContext = zza2.getContext();
        zzac.zzw((Object)this.mContext);
        this.zzbuQ = zza2;
        this.mHandler = new Handler();
    }

    public static boolean zzj(Context context, boolean bl) {
        zzac.zzw((Object)context);
        return zzaue.zzr(context, bl ? "com.google.android.gms.measurement.PackageMeasurementService" : "com.google.android.gms.measurement.AppMeasurementService");
    }

    @MainThread
    public void onCreate() {
        zzatp zzatp2 = zzatp.zzbu(this.mContext);
        zzati zzati2 = zzatp2.zzJt();
        zzatp2.zzJv().zzKk();
        zzati2.zzLg().log("Local AppMeasurementService is starting up");
    }

    @MainThread
    public void onDestroy() {
        zzatp zzatp2 = zzatp.zzbu(this.mContext);
        zzati zzati2 = zzatp2.zzJt();
        zzatp2.zzJv().zzKk();
        zzati2.zzLg().log("Local AppMeasurementService is shutting down");
    }

    @MainThread
    public int onStartCommand(Intent intent, int n, final int n2) {
        final zzatp zzatp2 = zzatp.zzbu(this.mContext);
        final zzati zzati2 = zzatp2.zzJt();
        if (intent == null) {
            zzati2.zzLc().log("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzatp2.zzJv().zzKk();
        zzati2.zzLg().zze("Local AppMeasurementService called. startId, action", n2, string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            zzatp2.zzJs().zzm(new Runnable(){

                @Override
                public void run() {
                    zzatp2.zzLL();
                    zzatp2.zzLG();
                    zzatx.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            boolean bl = zzatx.this.zzbuQ.callServiceStopSelfResult(n2);
                            if (bl) {
                                zzatp2.zzJv().zzKk();
                                zzati2.zzLg().log("Local AppMeasurementService processed last upload request");
                            }
                        }
                    });
                }
            });
        }
        return 2;
    }

    @MainThread
    public IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzJt().zzLa().log("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzatq(zzatp.zzbu(this.mContext));
        }
        this.zzJt().zzLc().zzj("onBind received unknown action", string);
        return null;
    }

    @MainThread
    public boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzJt().zzLa().log("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzJt().zzLg().zzj("onUnbind called for intent. action", string);
        return true;
    }

    @MainThread
    public void onRebind(Intent intent) {
        if (intent == null) {
            this.zzJt().zzLa().log("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzJt().zzLg().zzj("onRebind called. action", string);
    }

    private zzati zzJt() {
        return zzatp.zzbu(this.mContext).zzJt();
    }

    public static interface zza {
        public boolean callServiceStopSelfResult(int var1);

        public Context getContext();
    }
}

