/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzacx;
import com.google.android.gms.internal.zzasq;
import com.google.android.gms.internal.zzatb;
import com.google.android.gms.internal.zzatp;
import com.google.android.gms.internal.zzats;
import com.google.android.gms.internal.zzauf;
import com.google.android.gms.internal.zzauh;
import com.google.android.gms.internal.zzbum;
import com.google.android.gms.measurement.AppMeasurement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.security.auth.x500.X500Principal;

public class zzaue
extends zzats {
    private final AtomicLong zzbve = new AtomicLong(0L);
    private int zzbvf;

    zzaue(zzatp zzatp2) {
        super(zzatp2);
    }

    @Override
    protected void zzmr() {
        SecureRandom secureRandom = new SecureRandom();
        long l = secureRandom.nextLong();
        if (l == 0L && (l = secureRandom.nextLong()) == 0L) {
            this.zzJt().zzLc().log("Utils falling back to Random for random id");
        }
        this.zzbve.set(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zzMi() {
        long l = this.zzbve.get();
        if (l == 0L) {
            AtomicLong atomicLong = this.zzbve;
            synchronized (atomicLong) {
                return new Random(System.nanoTime() ^ this.zznq().currentTimeMillis()).nextLong() + (long)(++this.zzbvf);
            }
        }
        AtomicLong atomicLong = this.zzbve;
        synchronized (atomicLong) {
            this.zzbve.compareAndSet(-1L, 1L);
            l = this.zzbve.getAndIncrement();
            return l;
        }
    }

    static boolean zzfW(String string) {
        zzac.zzdv((String)string);
        return string.charAt(0) != '_';
    }

    public Bundle zzu(@NonNull Uri uri) {
        if (uri == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            if (uri.isHierarchical()) {
                string = uri.getQueryParameter("utm_campaign");
                string2 = uri.getQueryParameter("utm_source");
                string3 = uri.getQueryParameter("utm_medium");
                string4 = uri.getQueryParameter("gclid");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.zzJt().zzLc().zzj("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
            return null;
        }
        if (!(TextUtils.isEmpty(string) && TextUtils.isEmpty(string2) && TextUtils.isEmpty(string3) && TextUtils.isEmpty(string4))) {
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                bundle.putString("campaign", string);
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                bundle.putString("source", string2);
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                bundle.putString("medium", string3);
            }
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                bundle.putString("gclid", string4);
            }
            if (!TextUtils.isEmpty((CharSequence)(string9 = uri.getQueryParameter("utm_term")))) {
                bundle.putString("term", string9);
            }
            if (!TextUtils.isEmpty((CharSequence)(string8 = uri.getQueryParameter("utm_content")))) {
                bundle.putString("content", string8);
            }
            if (!TextUtils.isEmpty((CharSequence)(string7 = uri.getQueryParameter("aclid")))) {
                bundle.putString("aclid", string7);
            }
            if (!TextUtils.isEmpty((CharSequence)(string6 = uri.getQueryParameter("cp1")))) {
                bundle.putString("cp1", string6);
            }
            if (!TextUtils.isEmpty((CharSequence)(string5 = uri.getQueryParameter("anid")))) {
                bundle.putString("anid", string5);
            }
            return bundle;
        }
        return null;
    }

    public boolean zzD(Intent intent) {
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        return "android-app://com.google.android.googlequicksearchbox/https/www.google.com".equals(string) || "https://www.google.com".equals(string) || "android-app://com.google.appcrawler".equals(string);
    }

    boolean zzZ(String string, String string2) {
        int n;
        if (string2 == null) {
            this.zzJt().zzLa().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            this.zzJt().zzLa().zzj("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2)) {
            this.zzJt().zzLa().zze("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            this.zzJt().zzLa().zze("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    boolean zzaa(String string, String string2) {
        int n;
        if (string2 == null) {
            this.zzJt().zzLa().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            this.zzJt().zzLa().zzj("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2) && n2 != 95) {
            this.zzJt().zzLa().zze("Name must start with a letter or _ (underscore). Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            this.zzJt().zzLa().zze("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    boolean zzc(String string, Map<String, String> map, String string2) {
        if (string2 == null) {
            this.zzJt().zzLa().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.startsWith("firebase_")) {
            this.zzJt().zzLa().zze("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (map != null && map.containsKey(string2)) {
            this.zzJt().zzLa().zze("Name is reserved. Type, name", string, string2);
            return false;
        }
        return true;
    }

    boolean zzc(String string, int n, String string2) {
        if (string2 == null) {
            this.zzJt().zzLa().zzj("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() > n) {
            this.zzJt().zzLa().zzd("Name is too long. Type, maximum supported length, name", string, n, string2);
            return false;
        }
        return true;
    }

    public int zzfX(String string) {
        if (!this.zzZ("event", string)) {
            return 2;
        }
        if (!this.zzc("event", AppMeasurement.zza.zzbpx, string)) {
            return 13;
        }
        if (!this.zzc("event", this.zzJv().zzJU(), string)) {
            return 2;
        }
        return 0;
    }

    public int zzfY(String string) {
        if (!this.zzaa("event", string)) {
            return 2;
        }
        if (!this.zzc("event", AppMeasurement.zza.zzbpx, string)) {
            return 13;
        }
        if (!this.zzc("event", this.zzJv().zzJU(), string)) {
            return 2;
        }
        return 0;
    }

    public int zzfZ(String string) {
        if (!this.zzZ("user property", string)) {
            return 6;
        }
        if (!this.zzc("user property", AppMeasurement.zzg.zzbpC, string)) {
            return 15;
        }
        if (!this.zzc("user property", this.zzJv().zzJV(), string)) {
            return 6;
        }
        return 0;
    }

    public int zzga(String string) {
        if (!this.zzaa("user property", string)) {
            return 6;
        }
        if (!this.zzc("user property", AppMeasurement.zzg.zzbpC, string)) {
            return 15;
        }
        if (!this.zzc("user property", this.zzJv().zzJV(), string)) {
            return 6;
        }
        return 0;
    }

    public int zzgb(String string) {
        if (!this.zzZ("event param", string)) {
            return 3;
        }
        if (!this.zzc("event param", null, string)) {
            return 14;
        }
        if (!this.zzc("event param", this.zzJv().zzJW(), string)) {
            return 3;
        }
        return 0;
    }

    public int zzgc(String string) {
        if (!this.zzaa("event param", string)) {
            return 3;
        }
        if (!this.zzc("event param", null, string)) {
            return 14;
        }
        if (!this.zzc("event param", this.zzJv().zzJW(), string)) {
            return 3;
        }
        return 0;
    }

    boolean zza(String string, String string2, int n, Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string3 = String.valueOf(object);
            if (string3.length() > n) {
                this.zzJt().zzLc().zzd("Value is too long; discarded. Value kind, name, value length", string, string2, string3.length());
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean zzgd(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzJt().zzLa().log("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
            return false;
        }
        if (!this.zzge(string)) {
            this.zzJt().zzLa().zzj("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", string);
            return false;
        }
        return true;
    }

    boolean zzge(String string) {
        zzac.zzw((Object)string);
        String string2 = "^1:\\d+:android:[a-f0-9]+$";
        return string.matches(string2);
    }

    private Object zza(int n, Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long || object instanceof Double) {
            return object;
        }
        if (object instanceof Integer) {
            return (long)((Integer)object).intValue();
        }
        if (object instanceof Byte) {
            return (long)((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return (long)((Short)object).shortValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string = String.valueOf(object);
            return this.zza(string, n, bl);
        }
        return null;
    }

    public String zza(String string, int n, boolean bl) {
        if (string.length() > n) {
            if (bl) {
                return String.valueOf(string.substring(0, n)).concat("...");
            }
            return null;
        }
        return string;
    }

    public boolean zzk(String string, Object object) {
        return zzaue.zzgg(string) ? this.zza("param", string, this.zzJv().zzJY(), object) : this.zza("param", string, this.zzJv().zzJX(), object);
    }

    public Object zzl(String string, Object object) {
        if ("_ev".equals(string)) {
            Object object2 = this.zza(this.zzJv().zzJY(), object, true);
            return object2;
        }
        Object object3 = this.zza(zzaue.zzgg(string) ? this.zzJv().zzJY() : this.zzJv().zzJX(), object, false);
        return object3;
    }

    public Bundle zza(String string, Bundle bundle, @Nullable List<String> list, boolean bl) {
        Bundle bundle2 = null;
        if (bundle != null) {
            bundle2 = new Bundle(bundle);
            int n = 0;
            this.zzJv().zzJT();
            for (String string2 : bundle.keySet()) {
                String string3;
                int n2 = 0;
                if (list == null || !list.contains(string2)) {
                    if (bl) {
                        n2 = this.zzgb(string2);
                    }
                    if (n2 == 0) {
                        n2 = this.zzgc(string2);
                    }
                }
                if (n2 != 0) {
                    if (this.zzd(bundle2, n2)) {
                        string3 = this.zza(string2, this.zzJv().zzJW(), true);
                        bundle2.putString("_ev", string3);
                        if (n2 == 3) {
                            this.zzb(bundle2, string2);
                        }
                    }
                    bundle2.remove(string2);
                    continue;
                }
                if (!this.zzk(string2, bundle.get(string2)) && !"_ev".equals(string2)) {
                    if (this.zzd(bundle2, 4)) {
                        string3 = this.zza(string2, this.zzJv().zzJW(), true);
                        bundle2.putString("_ev", string3);
                        this.zzb(bundle2, bundle.get(string2));
                    }
                    bundle2.remove(string2);
                    continue;
                }
                if (!zzaue.zzfW(string2) || ++n <= 25) continue;
                string3 = new StringBuilder(48).append("Event can't contain more then ").append(25).append(" params").toString();
                this.zzJt().zzLa().zze(string3, string, bundle);
                this.zzd(bundle2, 5);
                bundle2.remove(string2);
            }
        }
        return bundle2;
    }

    public boolean zzd(Bundle bundle, int n) {
        if (bundle == null) {
            return false;
        }
        long l = bundle.getLong("_err");
        if (l == 0L) {
            bundle.putLong("_err", (long)n);
            return true;
        }
        return false;
    }

    public void zzb(Bundle bundle, Object object) {
        zzac.zzw((Object)bundle);
        if (object != null && (object instanceof String || object instanceof CharSequence)) {
            String string = String.valueOf(object);
            bundle.putLong("_el", (long)string.length());
        }
    }

    private int zzgf(String string) {
        if ("_ldl".equals(string)) {
            return this.zzJv().zzKa();
        }
        return this.zzJv().zzJZ();
    }

    public int zzm(String string, Object object) {
        boolean bl = "_ldl".equals(string) ? this.zza("user property referrer", string, this.zzgf(string), object) : this.zza("user property", string, this.zzgf(string), object);
        return bl ? 0 : 7;
    }

    public Object zzn(String string, Object object) {
        if ("_ldl".equals(string)) {
            return this.zza(this.zzgf(string), object, true);
        }
        return this.zza(this.zzgf(string), object, false);
    }

    public void zza(zzauh.zzg zzg2, Object object) {
        zzac.zzw((Object)object);
        zzg2.zzaFy = null;
        zzg2.zzbvZ = null;
        zzg2.zzbvc = null;
        if (object instanceof String) {
            zzg2.zzaFy = (String)object;
        } else if (object instanceof Long) {
            zzg2.zzbvZ = (Long)object;
        } else if (object instanceof Double) {
            zzg2.zzbvc = (Double)object;
        } else {
            this.zzJt().zzLa().zzj("Ignoring invalid (type) user attribute value", object);
        }
    }

    public void zza(zzauh.zzc zzc2, Object object) {
        zzac.zzw((Object)object);
        zzc2.zzaFy = null;
        zzc2.zzbvZ = null;
        zzc2.zzbvc = null;
        if (object instanceof String) {
            zzc2.zzaFy = (String)object;
        } else if (object instanceof Long) {
            zzc2.zzbvZ = (Long)object;
        } else if (object instanceof Double) {
            zzc2.zzbvc = (Double)object;
        } else {
            this.zzJt().zzLa().zzj("Ignoring invalid (type) event param value", object);
        }
    }

    public void zza(Bundle bundle, String string, Object object) {
        if (bundle == null) {
            return;
        }
        if (object instanceof Long) {
            bundle.putLong(string, ((Long)object).longValue());
            return;
        }
        if (object instanceof String) {
            String string2 = String.valueOf(object);
            bundle.putString(string, string2);
            return;
        }
        if (object instanceof Double) {
            bundle.putDouble(string, ((Double)object).doubleValue());
            return;
        }
        if (string != null) {
            String string3 = object != null ? object.getClass().getSimpleName() : null;
            this.zzJt().zzLd().zze("Not putting event parameter. Invalid value type. name, type", string, string3);
        }
    }

    public void zza(int n, String string, String string2, int n2) {
        this.zza(null, n, string, string2, n2);
    }

    public void zza(String string, int n, String string2, String string3, int n2) {
        Bundle bundle = new Bundle();
        this.zzd(bundle, n);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            bundle.putString(string2, string3);
        }
        if (n == 6 || n == 7 || n == 2) {
            bundle.putLong("_el", (long)n2);
        }
        this.zzbpw.zzJv().zzKk();
        this.zzbpw.zzJi().zze("auto", "_err", bundle);
    }

    public byte[] zzk(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzJt().zzLa().zzj("Failed to gzip content", iOException);
            throw iOException;
        }
    }

    public byte[] zzx(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzJt().zzLa().zzj("Failed to ungzip content", iOException);
            throw iOException;
        }
    }

    static MessageDigest zzcg(String string) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string);
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return null;
    }

    static long zzy(byte[] byArray) {
        zzac.zzw((Object)byArray);
        zzac.zzar((byArray.length > 0 ? 1 : 0) != 0);
        long l = 0L;
        int n = 0;
        for (int i = byArray.length - 1; i >= 0 && i >= byArray.length - 8; --i) {
            l += ((long)byArray[i] & 0xFFL) << n;
            n += 8;
        }
        return l;
    }

    @WorkerThread
    public long zzz(byte[] byArray) {
        zzac.zzw((Object)byArray);
        this.zzmq();
        MessageDigest messageDigest = zzaue.zzcg("MD5");
        if (messageDigest == null) {
            this.zzJt().zzLa().log("Failed to get MD5");
            return 0L;
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        return zzaue.zzy(byArray2);
    }

    public byte[] zza(zzauh.zzd zzd2) {
        try {
            int n = zzd2.zzacZ();
            byte[] byArray = new byte[n];
            zzbum zzbum2 = zzbum.zzae((byte[])byArray);
            zzd2.zza(zzbum2);
            zzbum2.zzacM();
            return byArray;
        }
        catch (IOException iOException) {
            this.zzJt().zzLa().zzj("Data loss. Failed to serialize batch", iOException);
            return null;
        }
    }

    public boolean zzf(long l, long l2) {
        if (l == 0L || l2 <= 0L) {
            return true;
        }
        return Math.abs(this.zznq().currentTimeMillis() - l) > l2;
    }

    public static boolean zza(Context context, String string, boolean bl) {
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, string), 2);
            if (activityInfo != null && activityInfo.enabled && (!bl || activityInfo.exported)) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    public static boolean zzr(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ServiceInfo serviceInfo = packageManager.getServiceInfo(new ComponentName(context, string), 4);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @WorkerThread
    public boolean zzbV(String string) {
        this.zzmq();
        int n = zzacx.zzaQ((Context)this.getContext()).checkCallingOrSelfPermission(string);
        if (n == 0) {
            return true;
        }
        this.zzJt().zzLf().zzj("Permission not granted", string);
        return false;
    }

    public static boolean zzgg(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    public static boolean zzab(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static long[] zza(BitSet bitSet) {
        int n = (bitSet.length() + 63) / 64;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = 0L;
            for (int j = 0; j < 64 && 64 * i + j < bitSet.length(); ++j) {
                if (!bitSet.get(64 * i + j)) continue;
                int n2 = i;
                lArray[n2] = lArray[n2] | 1L << j;
            }
        }
        return lArray;
    }

    public static boolean zza(long[] lArray, int n) {
        if (n >= lArray.length * 64) {
            return false;
        }
        return (lArray[n / 64] & 1L << n % 64) != 0L;
    }

    private static void zza(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, Object object) {
        if (object == null) {
            return;
        }
        zzaue.zza(stringBuilder, n + 1);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }

    private static void zza(StringBuilder stringBuilder, int n, zzauh.zze zze2) {
        if (zze2 == null) {
            return;
        }
        zzaue.zza(stringBuilder, n);
        stringBuilder.append("bundle {\n");
        zzaue.zza(stringBuilder, n, "protocol_version", zze2.zzbwc);
        zzaue.zza(stringBuilder, n, "platform", zze2.zzbwk);
        zzaue.zza(stringBuilder, n, "gmp_version", zze2.zzbwo);
        zzaue.zza(stringBuilder, n, "uploading_gmp_version", zze2.zzbwp);
        zzaue.zza(stringBuilder, n, "config_version", zze2.zzbwB);
        zzaue.zza(stringBuilder, n, "gmp_app_id", zze2.zzbqf);
        zzaue.zza(stringBuilder, n, "app_id", zze2.zzaR);
        zzaue.zza(stringBuilder, n, "app_version", zze2.zzbhg);
        zzaue.zza(stringBuilder, n, "app_version_major", zze2.zzbwx);
        zzaue.zza(stringBuilder, n, "firebase_instance_id", zze2.zzbqn);
        zzaue.zza(stringBuilder, n, "dev_cert_hash", zze2.zzbwt);
        zzaue.zza(stringBuilder, n, "app_store", zze2.zzbqg);
        zzaue.zza(stringBuilder, n, "upload_timestamp_millis", zze2.zzbwf);
        zzaue.zza(stringBuilder, n, "start_timestamp_millis", zze2.zzbwg);
        zzaue.zza(stringBuilder, n, "end_timestamp_millis", zze2.zzbwh);
        zzaue.zza(stringBuilder, n, "previous_bundle_start_timestamp_millis", zze2.zzbwi);
        zzaue.zza(stringBuilder, n, "previous_bundle_end_timestamp_millis", zze2.zzbwj);
        zzaue.zza(stringBuilder, n, "app_instance_id", zze2.zzbws);
        zzaue.zza(stringBuilder, n, "resettable_device_id", zze2.zzbwq);
        zzaue.zza(stringBuilder, n, "device_id", zze2.zzbwA);
        zzaue.zza(stringBuilder, n, "limited_ad_tracking", zze2.zzbwr);
        zzaue.zza(stringBuilder, n, "os_version", zze2.zzba);
        zzaue.zza(stringBuilder, n, "device_model", zze2.zzbwl);
        zzaue.zza(stringBuilder, n, "user_default_language", zze2.zzbwm);
        zzaue.zza(stringBuilder, n, "time_zone_offset_minutes", zze2.zzbwn);
        zzaue.zza(stringBuilder, n, "bundle_sequential_index", zze2.zzbwu);
        zzaue.zza(stringBuilder, n, "service_upload", zze2.zzbwv);
        zzaue.zza(stringBuilder, n, "health_monitor", zze2.zzbqj);
        zzaue.zza(stringBuilder, n, zze2.zzbwe);
        zzaue.zza(stringBuilder, n, zze2.zzbww);
        zzaue.zza(stringBuilder, n, zze2.zzbwd);
        zzaue.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n, zzauh.zzg[] zzgArray) {
        if (zzgArray == null) {
            return;
        }
        ++n;
        for (zzauh.zzg zzg2 : zzgArray) {
            if (zzg2 == null) continue;
            zzaue.zza(stringBuilder, n);
            stringBuilder.append("user_property {\n");
            zzaue.zza(stringBuilder, n, "set_timestamp_millis", zzg2.zzbwF);
            zzaue.zza(stringBuilder, n, "name", zzg2.name);
            zzaue.zza(stringBuilder, n, "string_value", zzg2.zzaFy);
            zzaue.zza(stringBuilder, n, "int_value", zzg2.zzbvZ);
            zzaue.zza(stringBuilder, n, "double_value", zzg2.zzbvc);
            zzaue.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, zzauh.zzc[] zzcArray) {
        if (zzcArray == null) {
            return;
        }
        ++n;
        for (zzauh.zzc zzc2 : zzcArray) {
            if (zzc2 == null) continue;
            zzaue.zza(stringBuilder, n);
            stringBuilder.append("param {\n");
            zzaue.zza(stringBuilder, n, "name", zzc2.name);
            zzaue.zza(stringBuilder, n, "string_value", zzc2.zzaFy);
            zzaue.zza(stringBuilder, n, "int_value", zzc2.zzbvZ);
            zzaue.zza(stringBuilder, n, "double_value", zzc2.zzbvc);
            zzaue.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, zzauh.zzb[] zzbArray) {
        if (zzbArray == null) {
            return;
        }
        ++n;
        for (zzauh.zzb zzb2 : zzbArray) {
            if (zzb2 == null) continue;
            zzaue.zza(stringBuilder, n);
            stringBuilder.append("event {\n");
            zzaue.zza(stringBuilder, n, "name", zzb2.name);
            zzaue.zza(stringBuilder, n, "timestamp_millis", zzb2.zzbvW);
            zzaue.zza(stringBuilder, n, "previous_timestamp_millis", zzb2.zzbvX);
            zzaue.zza(stringBuilder, n, "count", zzb2.count);
            zzaue.zza(stringBuilder, n, zzb2.zzbvV);
            zzaue.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, zzauh.zza[] zzaArray) {
        if (zzaArray == null) {
            return;
        }
        ++n;
        for (zzauh.zza zza2 : zzaArray) {
            if (zza2 == null) continue;
            zzaue.zza(stringBuilder, n);
            stringBuilder.append("audience_membership {\n");
            zzaue.zza(stringBuilder, n, "audience_id", zza2.zzbvh);
            zzaue.zza(stringBuilder, n, "new_audience", zza2.zzbvT);
            zzaue.zza(stringBuilder, n, "current_data", zza2.zzbvR);
            zzaue.zza(stringBuilder, n, "previous_data", zza2.zzbvS);
            zzaue.zza(stringBuilder, n);
            stringBuilder.append("}\n");
        }
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzauh.zzf zzf2) {
        Long l;
        int n2;
        int n3;
        long[] lArray;
        int n4;
        if (zzf2 == null) {
            return;
        }
        zzaue.zza(stringBuilder, ++n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzf2.zzbwD != null) {
            zzaue.zza(stringBuilder, n + 1);
            stringBuilder.append("results: ");
            n4 = 0;
            lArray = zzf2.zzbwD;
            n3 = lArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                l = lArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        if (zzf2.zzbwC != null) {
            zzaue.zza(stringBuilder, n + 1);
            stringBuilder.append("status: ");
            n4 = 0;
            lArray = zzf2.zzbwC;
            n3 = lArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                l = lArray[n2];
                if (n4++ != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(l);
            }
            stringBuilder.append('\n');
        }
        zzaue.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzauf.zzd zzd2) {
        if (zzd2 == null) {
            return;
        }
        zzaue.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzd2.zzbvv != null) {
            String string2 = "UNKNOWN_COMPARISON_TYPE";
            switch (zzd2.zzbvv) {
                case 1: {
                    string2 = "LESS_THAN";
                    break;
                }
                case 2: {
                    string2 = "GREATER_THAN";
                    break;
                }
                case 3: {
                    string2 = "EQUAL";
                    break;
                }
                case 4: {
                    string2 = "BETWEEN";
                }
            }
            zzaue.zza(stringBuilder, n, "comparison_type", string2);
        }
        zzaue.zza(stringBuilder, n, "match_as_float", zzd2.zzbvw);
        zzaue.zza(stringBuilder, n, "comparison_value", zzd2.zzbvx);
        zzaue.zza(stringBuilder, n, "min_comparison_value", zzd2.zzbvy);
        zzaue.zza(stringBuilder, n, "max_comparison_value", zzd2.zzbvz);
        zzaue.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n, String string, zzauf.zzf zzf2) {
        if (zzf2 == null) {
            return;
        }
        zzaue.zza(stringBuilder, n);
        stringBuilder.append(string);
        stringBuilder.append(" {\n");
        if (zzf2.zzbvD != null) {
            String[] stringArray = "UNKNOWN_MATCH_TYPE";
            switch (zzf2.zzbvD) {
                case 1: {
                    stringArray = "REGEXP";
                    break;
                }
                case 2: {
                    stringArray = "BEGINS_WITH";
                    break;
                }
                case 3: {
                    stringArray = "ENDS_WITH";
                    break;
                }
                case 4: {
                    stringArray = "PARTIAL";
                    break;
                }
                case 5: {
                    stringArray = "EXACT";
                    break;
                }
                case 6: {
                    stringArray = "IN_LIST";
                }
            }
            zzaue.zza(stringBuilder, n, "match_type", stringArray);
        }
        zzaue.zza(stringBuilder, n, "expression", zzf2.zzbvE);
        zzaue.zza(stringBuilder, n, "case_sensitive", zzf2.zzbvF);
        if (zzf2.zzbvG.length > 0) {
            zzaue.zza(stringBuilder, n + 1);
            stringBuilder.append("expression_list {\n");
            for (String string2 : zzf2.zzbvG) {
                zzaue.zza(stringBuilder, n + 2);
                stringBuilder.append(string2);
                stringBuilder.append("\n");
            }
            stringBuilder.append("}\n");
        }
        zzaue.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    private static void zza(StringBuilder stringBuilder, int n, zzauf.zzc zzc2) {
        if (zzc2 == null) {
            return;
        }
        zzaue.zza(stringBuilder, n);
        stringBuilder.append("filter {\n");
        zzaue.zza(stringBuilder, n, "complement", zzc2.zzbvt);
        zzaue.zza(stringBuilder, n, "param_name", zzc2.zzbvu);
        zzaue.zza(stringBuilder, n + 1, "string_filter", zzc2.zzbvr);
        zzaue.zza(stringBuilder, n + 1, "number_filter", zzc2.zzbvs);
        zzaue.zza(stringBuilder, n);
        stringBuilder.append("}\n");
    }

    public static String zzb(zzauh.zzd zzd2) {
        if (zzd2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nbatch {\n");
        if (zzd2.zzbwa != null) {
            for (zzauh.zze zze2 : zzd2.zzbwa) {
                if (zze2 == null) continue;
                zzaue.zza(stringBuilder, 1, zze2);
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    public static String zza(zzauf.zzb zzb2) {
        if (zzb2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nevent_filter {\n");
        zzaue.zza(stringBuilder, 0, "filter_id", zzb2.zzbvl);
        zzaue.zza(stringBuilder, 0, "event_name", zzb2.zzbvm);
        zzaue.zza(stringBuilder, 1, "event_count_filter", zzb2.zzbvp);
        stringBuilder.append("  filters {\n");
        for (zzauf.zzc zzc2 : zzb2.zzbvn) {
            zzaue.zza(stringBuilder, 2, zzc2);
        }
        zzaue.zza(stringBuilder, 1);
        stringBuilder.append("}\n}\n");
        return stringBuilder.toString();
    }

    public static String zza(zzauf.zze zze2) {
        if (zze2 == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nproperty_filter {\n");
        zzaue.zza(stringBuilder, 0, "filter_id", zze2.zzbvl);
        zzaue.zza(stringBuilder, 0, "property_name", zze2.zzbvB);
        zzaue.zza(stringBuilder, 1, zze2.zzbvC);
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    public boolean zzgh(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        String string2 = this.zzJv().zzKF();
        this.zzJv().zzKk();
        return string2.equals(string);
    }

    static boolean zzgi(String string) {
        return string != null && string.matches("(\\+|-)?([0-9]+\\.?[0-9]*|[0-9]*\\.?[0-9]+)") && string.length() <= 310;
    }

    boolean zzgj(String string) {
        return "1".equals(this.zzJq().zzW(string, "measurement.upload.blacklist_internal"));
    }

    boolean zzgk(String string) {
        return "1".equals(this.zzJq().zzW(string, "measurement.upload.blacklist_public"));
    }

    @WorkerThread
    long zzE(Context context, String string) {
        this.zzmq();
        zzac.zzw((Object)context);
        zzac.zzdv((String)string);
        long l = 0L;
        PackageManager packageManager = context.getPackageManager();
        MessageDigest messageDigest = zzaue.zzcg("MD5");
        if (messageDigest == null) {
            this.zzJt().zzLa().log("Could not get MD5 instance");
            l = -1L;
        } else if (packageManager != null) {
            try {
                if (!this.zzF(context, string)) {
                    PackageInfo packageInfo = zzacx.zzaQ((Context)context).getPackageInfo(this.getContext().getPackageName(), 64);
                    if (packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                        byte[] byArray = messageDigest.digest(packageInfo.signatures[0].toByteArray());
                        l = zzaue.zzy(byArray);
                    } else {
                        this.zzJt().zzLc().log("Could not get signatures");
                        l = -1L;
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzJt().zzLa().zzj("Package name not found", (Object)nameNotFoundException);
            }
        }
        return l;
    }

    boolean zzF(Context context, String string) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        try {
            PackageInfo packageInfo = zzacx.zzaQ((Context)context).getPackageInfo(string, 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                Signature signature = packageInfo.signatures[0];
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(signature.toByteArray()));
                return x509Certificate.getSubjectX500Principal().equals(x500Principal);
            }
        }
        catch (CertificateException certificateException) {
            this.zzJt().zzLa().zzj("Error obtaining certificate", certificateException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzJt().zzLa().zzj("Package name not found", (Object)nameNotFoundException);
        }
        return true;
    }

    @WorkerThread
    static boolean zzc(zzatb zzatb2, zzasq zzasq2) {
        zzac.zzw((Object)((Object)zzatb2));
        zzac.zzw((Object)((Object)zzasq2));
        return !TextUtils.isEmpty((CharSequence)zzasq2.zzbqf) || "_in".equals(zzatb2.name);
    }
}

