/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzu;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzaba;
import com.google.android.gms.internal.zzadg;
import com.google.android.gms.internal.zzats;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzaug;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class zzati
extends zzaug {
    static final String zzbrj = String.valueOf(zze.GOOGLE_PLAY_SERVICES_VERSION_CODE / 1000).replaceAll("(\\d+)(\\d)(\\d\\d)", "$1.$2.$3");
    private Boolean zzaeZ;

    zzati(zzaue zzaue2) {
        super(zzaue2);
    }

    String zzKJ() {
        return zzats.zzbrS.get();
    }

    public int zzKK() {
        return 25;
    }

    public int zzKL() {
        return 40;
    }

    public int zzKM() {
        return 24;
    }

    int zzKN() {
        return 40;
    }

    int zzKO() {
        return 100;
    }

    int zzKP() {
        return 256;
    }

    public int zzKQ() {
        return 36;
    }

    public int zzKR() {
        return 2048;
    }

    int zzKS() {
        return 500;
    }

    public long zzKT() {
        return zzats.zzbsc.get().intValue();
    }

    public long zzKU() {
        return zzats.zzbse.get().intValue();
    }

    public int zzfj(@Size(min=1L) String string) {
        int n = this.zzb(string, zzats.zzbsd);
        n = Math.min(1000000, n);
        n = Math.max(0, n);
        return n;
    }

    public int zzfk(@Size(min=1L) String string) {
        return this.zzb(string, zzats.zzbsf);
    }

    public int zzfl(@Size(min=1L) String string) {
        return this.zzb(string, zzats.zzbsg);
    }

    int zzKV() {
        return 25;
    }

    int zzKW() {
        return 1000;
    }

    int zzKX() {
        return 25;
    }

    int zzKY() {
        return 1000;
    }

    long zzKZ() {
        return 15552000000L;
    }

    long zzLa() {
        return 15552000000L;
    }

    long zzLb() {
        return 3600000L;
    }

    long zzLc() {
        return 60000L;
    }

    long zzLd() {
        return 61000L;
    }

    long zzfm(String string) {
        return this.zza(string, zzats.zzbrT);
    }

    int zzfn(String string) {
        return this.zzb(string, zzats.zzbsw);
    }

    int zzfo(String string) {
        int n = this.zzb(string, zzats.zzbsx);
        n = Math.min(2000, n);
        n = Math.max(0, n);
        return n;
    }

    long zzpq() {
        return zzats.zzbsy.get();
    }

    public String zzpv() {
        return "google_app_measurement.db";
    }

    String zzLe() {
        return "google_app_measurement_local.db";
    }

    public long zzKu() {
        return 10298L;
    }

    public boolean zzLf() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzoW() {
        if (this.zzaeZ == null) {
            zzati zzati2 = this;
            synchronized (zzati2) {
                if (this.zzaeZ == null) {
                    ApplicationInfo applicationInfo = this.getContext().getApplicationInfo();
                    String string = zzu.zzzq();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzaeZ = string2 != null && string2.equals(string);
                    }
                    if (this.zzaeZ == null) {
                        this.zzaeZ = Boolean.TRUE;
                        this.zzKk().zzLX().log("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzaeZ;
    }

    public long zza(String string, zzats.zza<Long> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzKh().zzZ(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            long l = Long.valueOf(string2);
            return zza2.get(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    public int zzb(String string, zzats.zza<Integer> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzKh().zzZ(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            int n = Integer.valueOf(string2);
            return zza2.get(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @Nullable
    Boolean zzfp(@Size(min=1L) String string) {
        zzac.zzdr((String)string);
        try {
            PackageManager packageManager = this.getContext().getPackageManager();
            if (packageManager == null) {
                this.zzKk().zzLX().log("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = zzadg.zzbi((Context)this.getContext()).getApplicationInfo(this.getContext().getPackageName(), 128);
            if (applicationInfo == null) {
                this.zzKk().zzLX().log("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            if (applicationInfo.metaData == null) {
                this.zzKk().zzLX().log("Failed to load metadata: Metadata bundle is null");
                return null;
            }
            if (!applicationInfo.metaData.containsKey(string)) {
                return null;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzKk().zzLX().zzj("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public boolean zzLg() {
        Boolean bl = this.zzfp("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public Boolean zzLh() {
        return this.zzfp("firebase_analytics_collection_enabled");
    }

    public boolean zzwR() {
        return zzaba.zzwR();
    }

    public long zzLi() {
        return zzats.zzbsv.get();
    }

    public long zzLj() {
        return zzats.zzbsq.get();
    }

    public long zzLk() {
        return zzats.zzbsr.get();
    }

    public long zzLl() {
        return 1000L;
    }

    public long zzpz() {
        return Math.max(0L, zzats.zzbrU.get());
    }

    public int zzfq(String string) {
        return this.zzb(string, zzats.zzbrY);
    }

    public int zzfr(String string) {
        return Math.max(0, this.zzb(string, zzats.zzbrZ));
    }

    public int zzfs(String string) {
        int n = this.zzb(string, zzats.zzbsh);
        n = Math.min(1000000, n);
        n = Math.max(0, n);
        return n;
    }

    public int zzLm() {
        return Math.max(0, zzats.zzbsa.get());
    }

    public int zzLn() {
        return Math.max(1, zzats.zzbsb.get());
    }

    public int zzLo() {
        return 100000;
    }

    public String zzLp() {
        return zzats.zzbsi.get();
    }

    public String zzP(String string, String string2) {
        Uri.Builder builder = new Uri.Builder();
        String string3 = String.valueOf(string);
        builder.scheme(zzats.zzbrW.get()).encodedAuthority(zzats.zzbrX.get()).path(string3.length() != 0 ? "config/app/".concat(string3) : new String("config/app/")).appendQueryParameter("app_instance_id", string2).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", String.valueOf(10298L));
        return builder.build().toString();
    }

    public long zzLq() {
        return zzats.zzbrV.get();
    }

    public long zzLr() {
        return Math.max(0L, zzats.zzbsj.get());
    }

    public long zzLs() {
        return Math.max(0L, zzats.zzbsl.get());
    }

    public long zzLt() {
        return Math.max(0L, zzats.zzbsm.get());
    }

    public long zzLu() {
        return Math.max(0L, zzats.zzbsn.get());
    }

    public long zzLv() {
        return Math.max(0L, zzats.zzbso.get());
    }

    public long zzLw() {
        return Math.max(0L, zzats.zzbsp.get());
    }

    public long zzLx() {
        return zzats.zzbsk.get();
    }

    public long zzLy() {
        return Math.max(0L, zzats.zzbss.get());
    }

    public long zzLz() {
        return Math.max(0L, zzats.zzbst.get());
    }

    public int zzLA() {
        return Math.min(20, Math.max(0, zzats.zzbsu.get()));
    }

    public String zzLB() {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method method = clazz.getMethod("get", String.class, String.class);
            return (String)method.invoke(null, "debug.firebase.analytics.app", "");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.zzKk().zzLX().zzj("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.zzKk().zzLX().zzj("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.zzKk().zzLX().zzj("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.zzKk().zzLX().zzj("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return "";
    }
}

