/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzauh;
import com.google.android.gms.internal.zzaut;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Locale;

class zzaua
extends zzauh {
    static final Pair<String, Long> zzbtb = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzagD;
    public final zzc zzbtc = new zzc("health_monitor", this.zzKm().zzpz());
    public final zzb zzbtd = new zzb("last_upload", 0L);
    public final zzb zzbte = new zzb("last_upload_attempt", 0L);
    public final zzb zzbtf = new zzb("backoff", 0L);
    public final zzb zzbtg = new zzb("last_delete_stale", 0L);
    public final zzb zzbth;
    private String zzbti;
    private boolean zzbtj;
    private long zzbtk;
    private String zzbtl;
    private long zzbtm;
    private final Object zzbtn;
    private SecureRandom zzbto;
    public final zzb zzbtp = new zzb("time_before_start", 10000L);
    public final zzb zzbtq = new zzb("session_timeout", 1800000L);
    public final zza zzbtr = new zza("start_new_session", true);
    public final zzb zzbts = new zzb("last_pause_time", 0L);
    public final zzb zzbtt = new zzb("time_active", 0L);
    public boolean zzbtu;

    @WorkerThread
    private SecureRandom zzMf() {
        this.zzmR();
        if (this.zzbto == null) {
            this.zzbto = new SecureRandom();
        }
        return this.zzbto;
    }

    @WorkerThread
    @NonNull
    Pair<String, Boolean> zzfG(String string) {
        this.zzmR();
        long l = this.zznR().elapsedRealtime();
        if (this.zzbti != null && l < this.zzbtk) {
            return new Pair((Object)this.zzbti, (Object)this.zzbtj);
        }
        this.zzbtk = l + this.zzKm().zzfm(string);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            this.zzbti = info.getId();
            if (this.zzbti == null) {
                this.zzbti = "";
            }
            this.zzbtj = info.isLimitAdTrackingEnabled();
        }
        catch (Throwable throwable) {
            this.zzKk().zzMc().zzj("Unable to get advertising id", throwable);
            this.zzbti = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzbti, (Object)this.zzbtj);
    }

    @WorkerThread
    String zzfH(String string) {
        this.zzmR();
        String string2 = (String)this.zzfG((String)string).first;
        MessageDigest messageDigest = zzaut.zzch("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    @WorkerThread
    String zzMg() {
        byte[] byArray = new byte[16];
        this.zzMf().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    String zzKp() {
        this.zzmR();
        try {
            return com.google.firebase.iid.zzc.zzabK().getId();
        }
        catch (IllegalStateException illegalStateException) {
            this.zzKk().zzLZ().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    @WorkerThread
    long zzMh() {
        this.zzob();
        this.zzmR();
        long l = this.zzbth.get();
        if (l == 0L) {
            l = 1 + this.zzMf().nextInt(86400000);
            this.zzbth.set(l);
        }
        return l;
    }

    zzaua(zzaue zzaue2) {
        super(zzaue2);
        this.zzbth = new zzb("midnight_offset", 0L);
        this.zzbtn = new Object();
    }

    @Override
    protected void zzmS() {
        this.zzagD = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzbtu = this.zzagD.getBoolean("has_been_opened", false);
        if (!this.zzbtu) {
            SharedPreferences.Editor editor = this.zzagD.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
    }

    @WorkerThread
    private SharedPreferences zzMi() {
        this.zzmR();
        this.zzob();
        return this.zzagD;
    }

    @WorkerThread
    void zzfI(String string) {
        this.zzmR();
        SharedPreferences.Editor editor = this.zzMi().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    String zzMj() {
        this.zzmR();
        return this.zzMi().getString("gmp_app_id", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzfJ(String string) {
        Object object = this.zzbtn;
        synchronized (object) {
            this.zzbtl = string;
            this.zzbtm = this.zznR().elapsedRealtime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String zzMk() {
        Object object = this.zzbtn;
        synchronized (object) {
            if (Math.abs(this.zznR().elapsedRealtime() - this.zzbtm) < 1000L) {
                return this.zzbtl;
            }
            return null;
        }
    }

    @WorkerThread
    Boolean zzMl() {
        this.zzmR();
        if (!this.zzMi().contains("use_service")) {
            return null;
        }
        return this.zzMi().getBoolean("use_service", false);
    }

    @WorkerThread
    void zzaK(boolean bl) {
        this.zzmR();
        this.zzKk().zzMd().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzMi().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    void zzMm() {
        this.zzmR();
        this.zzKk().zzMd().log("Clearing collection preferences.");
        boolean bl = this.zzMi().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzaL(true);
        }
        SharedPreferences.Editor editor = this.zzMi().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    void setMeasurementEnabled(boolean bl) {
        this.zzmR();
        this.zzKk().zzMd().zzj("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzMi().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    boolean zzaL(boolean bl) {
        this.zzmR();
        return this.zzMi().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected String zzMn() {
        this.zzmR();
        String string = this.zzMi().getString("previous_os_version", null);
        String string2 = this.zzKb().zzLR();
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzMi().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    public final class zza {
        private final String zzAX;
        private final boolean zzbtv;
        private boolean zzbtw;
        private boolean zzayS;

        public zza(String string, boolean bl) {
            zzac.zzdr((String)string);
            this.zzAX = string;
            this.zzbtv = bl;
        }

        @WorkerThread
        private void zzMo() {
            if (this.zzbtw) {
                return;
            }
            this.zzbtw = true;
            this.zzayS = zzaua.this.zzagD.getBoolean(this.zzAX, this.zzbtv);
        }

        @WorkerThread
        public boolean get() {
            this.zzMo();
            return this.zzayS;
        }

        @WorkerThread
        public void set(boolean bl) {
            SharedPreferences.Editor editor = zzaua.this.zzagD.edit();
            editor.putBoolean(this.zzAX, bl);
            editor.apply();
            this.zzayS = bl;
        }
    }

    public final class zzb {
        private final String zzAX;
        private final long zzbty;
        private boolean zzbtw;
        private long zzadd;

        public zzb(String string, long l) {
            zzac.zzdr((String)string);
            this.zzAX = string;
            this.zzbty = l;
        }

        @WorkerThread
        private void zzMo() {
            if (this.zzbtw) {
                return;
            }
            this.zzbtw = true;
            this.zzadd = zzaua.this.zzagD.getLong(this.zzAX, this.zzbty);
        }

        @WorkerThread
        public long get() {
            this.zzMo();
            return this.zzadd;
        }

        @WorkerThread
        public void set(long l) {
            SharedPreferences.Editor editor = zzaua.this.zzagD.edit();
            editor.putLong(this.zzAX, l);
            editor.apply();
            this.zzadd = l;
        }
    }

    public final class zzc {
        final String zzbtz;
        private final String zzbtA;
        private final String zzbtB;
        private final long zzagH;

        private zzc(String string, long l) {
            zzac.zzdr((String)string);
            zzac.zzax((l > 0L ? 1 : 0) != 0);
            this.zzbtz = String.valueOf(string).concat(":start");
            this.zzbtA = String.valueOf(string).concat(":count");
            this.zzbtB = String.valueOf(string).concat(":value");
            this.zzagH = l;
        }

        @WorkerThread
        private void zzqk() {
            zzaua.this.zzmR();
            long l = zzaua.this.zznR().currentTimeMillis();
            SharedPreferences.Editor editor = zzaua.this.zzagD.edit();
            editor.remove(this.zzbtA);
            editor.remove(this.zzbtB);
            editor.putLong(this.zzbtz, l);
            editor.apply();
        }

        @WorkerThread
        private long zzql() {
            zzaua.this.zzmR();
            long l = this.zzqn();
            if (l == 0L) {
                this.zzqk();
                return 0L;
            }
            return Math.abs(l - zzaua.this.zznR().currentTimeMillis());
        }

        @WorkerThread
        public void zzcc(String string) {
            this.zzk(string, 1L);
        }

        @WorkerThread
        public void zzk(String string, long l) {
            long l2;
            zzaua.this.zzmR();
            long l3 = this.zzqn();
            if (l3 == 0L) {
                this.zzqk();
            }
            if (string == null) {
                string = "";
            }
            if ((l2 = zzaua.this.zzagD.getLong(this.zzbtA, 0L)) <= 0L) {
                SharedPreferences.Editor editor = zzaua.this.zzagD.edit();
                editor.putString(this.zzbtB, string);
                editor.putLong(this.zzbtA, l);
                editor.apply();
                return;
            }
            long l4 = zzaua.this.zzMf().nextLong() & Long.MAX_VALUE;
            boolean bl = l4 < Long.MAX_VALUE / (l2 + l) * l;
            SharedPreferences.Editor editor = zzaua.this.zzagD.edit();
            if (bl) {
                editor.putString(this.zzbtB, string);
            }
            editor.putLong(this.zzbtA, l2 + l);
            editor.apply();
        }

        @WorkerThread
        public Pair<String, Long> zzqm() {
            zzaua.this.zzmR();
            long l = this.zzql();
            if (l < this.zzagH) {
                return null;
            }
            if (l > this.zzagH * 2L) {
                this.zzqk();
                return null;
            }
            String string = zzaua.this.zzMi().getString(this.zzbtB, null);
            long l2 = zzaua.this.zzMi().getLong(this.zzbtA, 0L);
            this.zzqk();
            if (string == null || l2 <= 0L) {
                return zzbtb;
            }
            return new Pair((Object)string, (Object)l2);
        }

        @WorkerThread
        private long zzqn() {
            return zzaua.this.zzMi().getLong(this.zzbtz, 0L);
        }
    }
}

