/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.internal.zzatg;
import com.google.android.gms.internal.zzato;
import com.google.android.gms.internal.zzatq;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzauh;
import com.google.android.gms.internal.zzauk;
import com.google.android.gms.internal.zzauq;
import com.google.android.gms.internal.zzaut;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class zzauj
extends zzauh {
    protected zza zzbuZ;
    private AppMeasurement.zzb zzbva;
    private final Set<AppMeasurement.zzc> zzbvb = new CopyOnWriteArraySet<AppMeasurement.zzc>();
    private boolean zzbvc;
    private String zzbvd = null;
    private String zzbve = null;

    protected zzauj(zzaue zzaue2) {
        super(zzaue2);
    }

    @Override
    protected void zzmS() {
    }

    @TargetApi(value=14)
    public void zzMP() {
        if (this.getContext().getApplicationContext() instanceof Application) {
            Application application = (Application)this.getContext().getApplicationContext();
            if (this.zzbuZ == null) {
                this.zzbuZ = new zza();
            }
            application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzbuZ);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzbuZ);
            this.zzKk().zzMd().log("Registered activity lifecycle callback");
        }
    }

    public void setMeasurementEnabled(final boolean bl) {
        this.zzob();
        this.zzJV();
        this.zzKj().zzm(new Runnable(){

            @Override
            public void run() {
                zzauj.this.zzaM(bl);
            }
        });
    }

    @WorkerThread
    private void zzaM(boolean bl) {
        this.zzmR();
        this.zzJV();
        this.zzob();
        this.zzKk().zzMc().zzj("Setting app measurement enabled (FE)", bl);
        this.zzKl().setMeasurementEnabled(bl);
        this.zzKc().zzMV();
    }

    public void setMinimumSessionDuration(final long l) {
        this.zzJV();
        this.zzKj().zzm(new Runnable(){

            @Override
            public void run() {
                zzauj.this.zzKl().zzbtp.set(l);
                zzauj.this.zzKk().zzMc().zzj("Minimum session duration set", l);
            }
        });
    }

    public void setSessionTimeoutDuration(final long l) {
        this.zzJV();
        this.zzKj().zzm(new Runnable(){

            @Override
            public void run() {
                zzauj.this.zzKl().zzbtq.set(l);
                zzauj.this.zzKk().zzMc().zzj("Session timeout duration set", l);
            }
        });
    }

    public void zza(String string, String string2, Bundle bundle, boolean bl) {
        this.zzJV();
        boolean bl2 = this.zzbva == null || zzaut.zzgd(string2);
        this.zza(string, string2, bundle, true, bl2, bl, null);
    }

    public void zze(String string, String string2, Bundle bundle) {
        this.zzJV();
        boolean bl = this.zzbva == null || zzaut.zzgd(string2);
        this.zza(string, string2, bundle, true, bl, false, null);
    }

    public void zzd(String string, String string2, Bundle bundle, long l) {
        this.zzJV();
        this.zza(string, string2, l, bundle, false, true, true, null);
    }

    private void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.zza(string, string2, this.zznR().currentTimeMillis(), bundle, bl, bl2, bl3, string3);
    }

    protected void zza(final String string, final String string2, final long l, Bundle bundle, final boolean bl, final boolean bl2, final boolean bl3, final String string3) {
        final Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
        this.zzKj().zzm(new Runnable(){

            @Override
            public void run() {
                zzauj.this.zzb(string, string2, l, bundle2, bl, bl2, bl3, string3);
            }
        });
    }

    @WorkerThread
    private void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzac.zzdr((String)string);
        zzac.zzdr((String)string2);
        zzac.zzw((Object)bundle);
        this.zzmR();
        this.zzob();
        if (!this.zzbqg.isEnabled()) {
            this.zzKk().zzMc().log("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zzbvc) {
            this.zzbvc = true;
            this.zzMR();
        }
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzaut.zzgd(string2);
        if (bl && this.zzbva != null && !bl5 && !bl4) {
            this.zzKk().zzMc().zze("Passing event to registered event handler (FE)", string2, bundle);
            this.zzbva.zzb(string, string2, bundle, l);
        } else {
            Object object;
            Object object2;
            if (!this.zzbqg.zzMs()) {
                return;
            }
            int n = this.zzKg().zzfV(string2);
            if (n != 0) {
                String string4 = this.zzKg().zza(string2, this.zzKm().zzKL(), true);
                int n2 = string2 != null ? string2.length() : 0;
                this.zzbqg.zzKg().zza(n, "_ev", string4, n2);
                return;
            }
            bundle.putString("_o", string);
            List list = zzf.zzx((Object)"_o");
            Bundle bundle2 = this.zzKg().zza(string2, bundle, list, bl3);
            if (!bundle.containsKey("_sc")) {
                this.zzKm().zzLf();
                object2 = this.zzKd().zzMT();
                if (object2 != null) {
                    object2.zzbvD = true;
                }
                object = object2;
                zzauk.zza((AppMeasurement.zzf)object, bundle2);
            }
            object = bl2 ? this.zzKg().zzN(bundle2) : bundle2;
            this.zzKk().zzMc().zze("Logging event (FE)", string2, object);
            object2 = new zzatq(string2, new zzato((Bundle)object), string, l);
            this.zzKc().zzc((zzatq)((Object)object2), string3);
            if (!bl4) {
                for (AppMeasurement.zzc zzc2 : this.zzbvb) {
                    Bundle bundle3 = new Bundle(object);
                    zzc2.zzc(string, string2, bundle3, l);
                }
            }
        }
    }

    public void zzd(String string, String string2, Object object) {
        zzac.zzdr((String)string);
        long l = this.zznR().currentTimeMillis();
        int n = this.zzKg().zzfX(string2);
        if (n != 0) {
            String string3 = this.zzKg().zza(string2, this.zzKm().zzKM(), true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zzbqg.zzKg().zza(n, "_ev", string3, n2);
            return;
        }
        if (object != null) {
            n = this.zzKg().zzm(string2, object);
            if (n != 0) {
                String string4 = this.zzKg().zza(string2, this.zzKm().zzKM(), true);
                int n3 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    String string5 = String.valueOf(object);
                    n3 = string5.length();
                }
                this.zzbqg.zzKg().zza(n, "_ev", string4, n3);
                return;
            }
            Object object2 = this.zzKg().zzn(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
        } else {
            this.zza(string, string2, l, null);
        }
    }

    void zza(final String string, final String string2, final long l, final Object object) {
        this.zzKj().zzm(new Runnable(){

            @Override
            public void run() {
                zzauj.this.zza(string, string2, object, l);
            }
        });
    }

    @WorkerThread
    private void zza(String string, String string2, Object object, long l) {
        zzac.zzdr((String)string);
        zzac.zzdr((String)string2);
        this.zzmR();
        this.zzJV();
        this.zzob();
        if (!this.zzbqg.isEnabled()) {
            this.zzKk().zzMc().log("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzbqg.zzMs()) {
            return;
        }
        this.zzKk().zzMc().zze("Setting user property (FE)", string2, object);
        zzauq zzauq2 = new zzauq(string2, l, object, string);
        this.zzKc().zzb(zzauq2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<zzauq> zzaN(final boolean bl) {
        this.zzJV();
        this.zzob();
        this.zzKk().zzMc().log("Fetching user attributes (FE)");
        final AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (object) {
            this.zzbqg.zzKj().zzm(new Runnable(){

                @Override
                public void run() {
                    zzauj.this.zzKc().zza(atomicReference, bl);
                }
            });
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                this.zzKk().zzLZ().zzj("Interrupted waiting for get user properties", interruptedException);
            }
        }
        object = (List)atomicReference.get();
        if (object == null) {
            this.zzKk().zzLZ().log("Timed out waiting for get user properties");
            return Collections.emptyList();
        }
        return object;
    }

    public Task<String> getAppInstanceId() {
        try {
            String string = this.zzKl().zzMk();
            if (string != null) {
                return Tasks.forResult((Object)string);
            }
            Task task = Tasks.call((Executor)this.zzKj().zzMq(), (Callable)new Callable<String>(){

                public String zzbY() throws Exception {
                    String string = zzauj.this.zzKl().zzMk();
                    if (string != null) {
                        return string;
                    }
                    string = zzauj.this.zzJZ().zzar(120000L);
                    if (string == null) {
                        throw new TimeoutException();
                    }
                    zzauj.this.zzKl().zzfJ(string);
                    return string;
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.zzbY();
                }
            });
            return task;
        }
        catch (Exception exception) {
            this.zzKk().zzLZ().log("Failed to schedule task for getAppInstanceId");
            return Tasks.forException((Exception)exception);
        }
    }

    @Nullable
    @WorkerThread
    public synchronized String zzfQ(String string) {
        this.zzob();
        this.zzJV();
        if (string != null && string.equals(this.zzbve)) {
            return this.zzbvd;
        }
        String string2 = this.zzar(30000L);
        if (string2 == null) {
            return null;
        }
        this.zzbve = string;
        this.zzbvd = string2;
        return this.zzbvd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String zzar(long l) {
        AtomicReference atomicReference;
        if (this.zzKj().zzMp()) {
            this.zzKk().zzLX().log("Cannot retrieve app instance id from analytics worker thread");
            return null;
        }
        if (this.zzKj().zzbc()) {
            this.zzKk().zzLX().log("Cannot retrieve app instance id from main thread");
            return null;
        }
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference2) {
            this.zzKj().zzm(new Runnable(){

                @Override
                public void run() {
                    zzauj.this.zzKc().zza(atomicReference);
                }
            });
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                this.zzKk().zzLZ().log("Interrupted waiting for app instance id");
                return null;
            }
        }
        return (String)atomicReference.get();
    }

    @WorkerThread
    public void zzMQ() {
        this.zzmR();
        this.zzJV();
        this.zzob();
        if (!this.zzbqg.zzMs()) {
            return;
        }
        this.zzKc().zzMQ();
        String string = this.zzKl().zzMn();
        if (!TextUtils.isEmpty((CharSequence)string) && !string.equals(this.zzKb().zzLR())) {
            Bundle bundle = new Bundle();
            bundle.putString("_po", string);
            this.zze("auto", "_ou", bundle);
        }
    }

    @WorkerThread
    public void zza(AppMeasurement.zzb zzb2) {
        this.zzmR();
        this.zzJV();
        this.zzob();
        if (zzb2 != null && zzb2 != this.zzbva) {
            zzac.zza((this.zzbva == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzbva = zzb2;
    }

    public void zza(AppMeasurement.zzc zzc2) {
        this.zzJV();
        this.zzob();
        zzac.zzw((Object)zzc2);
        if (!this.zzbvb.add(zzc2)) {
            this.zzKk().zzLZ().log("OnEventListener already registered");
        }
    }

    @WorkerThread
    private void zzMR() {
        try {
            Class<?> clazz = Class.forName(this.zzMS());
            this.zzf(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.zzKk().zzMb().log("Tag Manager is not found and thus will not be used");
        }
    }

    private String zzMS() {
        return "com.google.android.gms.tagmanager.TagManagerService";
    }

    @WorkerThread
    public void zzf(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("initialize", Context.class);
            method.invoke(null, this.getContext());
        }
        catch (Exception exception) {
            this.zzKk().zzLZ().zzj("Failed to invoke Tag Manager's initialize() method", exception);
        }
    }

    public int getMaxUserProperties(String string) {
        zzac.zzdr((String)string);
        return this.zzKm().zzKX();
    }

    public void setConditionalUserProperty(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzac.zzw((Object)conditionalUserProperty);
        this.zzJV();
        AppMeasurement.ConditionalUserProperty conditionalUserProperty2 = new AppMeasurement.ConditionalUserProperty(conditionalUserProperty);
        if (!TextUtils.isEmpty((CharSequence)conditionalUserProperty2.mAppId)) {
            this.zzKk().zzLZ().log("Package name should be null when calling setConditionalUserProperty");
        }
        conditionalUserProperty2.mAppId = null;
        this.zza(conditionalUserProperty2);
    }

    public void setConditionalUserPropertyAs(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzac.zzw((Object)conditionalUserProperty);
        zzac.zzdr((String)conditionalUserProperty.mAppId);
        this.zzJU();
        this.zza(new AppMeasurement.ConditionalUserProperty(conditionalUserProperty));
    }

    private void zza(final AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        long l = this.zznR().currentTimeMillis();
        zzac.zzw((Object)conditionalUserProperty);
        zzac.zzdr((String)conditionalUserProperty.mName);
        zzac.zzdr((String)conditionalUserProperty.mOrigin);
        zzac.zzw((Object)conditionalUserProperty.mValue);
        conditionalUserProperty.mCreationTimestamp = l;
        String string = conditionalUserProperty.mName;
        Object object = conditionalUserProperty.mValue;
        int n = this.zzKg().zzfX(string);
        if (n != 0) {
            this.zzKk().zzLX().zzj("Invalid conditional user property name", string);
            return;
        }
        n = this.zzKg().zzm(string, object);
        if (n != 0) {
            this.zzKk().zzLX().zze("Invalid conditional user property value", string, object);
            return;
        }
        Object object2 = this.zzKg().zzn(string, object);
        if (object2 == null) {
            this.zzKk().zzLX().zze("Unable to normalize conditional user property value", string, object);
            return;
        }
        conditionalUserProperty.mValue = object2;
        long l2 = conditionalUserProperty.mTriggerTimeout;
        if (l2 > this.zzKm().zzKZ() || l2 < 1L) {
            this.zzKk().zzLX().zze("Invalid conditional user property timeout", string, l2);
            return;
        }
        long l3 = conditionalUserProperty.mTimeToLive;
        if (l3 > this.zzKm().zzLa() || l3 < 1L) {
            this.zzKk().zzLX().zze("Invalid conditional user property time to live", string, l3);
            return;
        }
        this.zzKj().zzm(new Runnable(){

            @Override
            public void run() {
                zzauj.this.zzb(conditionalUserProperty);
            }
        });
    }

    public void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        this.zzJV();
        this.zza(null, string, string2, bundle);
    }

    public void clearConditionalUserPropertyAs(String string, String string2, String string3, Bundle bundle) {
        zzac.zzdr((String)string);
        this.zzJU();
        this.zza(string, string2, string3, bundle);
    }

    private void zza(String string, String string2, String string3, Bundle bundle) {
        long l = this.zznR().currentTimeMillis();
        zzac.zzdr((String)string2);
        final AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
        conditionalUserProperty.mAppId = string;
        conditionalUserProperty.mName = string2;
        conditionalUserProperty.mCreationTimestamp = l;
        if (string3 != null) {
            conditionalUserProperty.mExpiredEventName = string3;
            conditionalUserProperty.mExpiredEventParams = bundle;
        }
        this.zzKj().zzm(new Runnable(){

            @Override
            public void run() {
                zzauj.this.zzc(conditionalUserProperty);
            }
        });
    }

    @WorkerThread
    private void zzb(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzatq zzatq2;
        zzatq zzatq3;
        zzatq zzatq4;
        this.zzmR();
        this.zzob();
        zzac.zzw((Object)conditionalUserProperty);
        zzac.zzdr((String)conditionalUserProperty.mName);
        zzac.zzdr((String)conditionalUserProperty.mOrigin);
        zzac.zzw((Object)conditionalUserProperty.mValue);
        if (!this.zzbqg.isEnabled()) {
            this.zzKk().zzMc().log("Conditional property not sent since Firebase Analytics is disabled");
            return;
        }
        zzauq zzauq2 = new zzauq(conditionalUserProperty.mName, conditionalUserProperty.mTriggeredTimestamp, conditionalUserProperty.mValue, conditionalUserProperty.mOrigin);
        try {
            zzatq4 = this.zzKg().zza(conditionalUserProperty.mTriggeredEventName, conditionalUserProperty.mTriggeredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzatq3 = this.zzKg().zza(conditionalUserProperty.mTimedOutEventName, conditionalUserProperty.mTimedOutEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzatq2 = this.zzKg().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzatg zzatg2 = new zzatg(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzauq2, conditionalUserProperty.mCreationTimestamp, false, conditionalUserProperty.mTriggerEventName, zzatq3, conditionalUserProperty.mTriggerTimeout, zzatq4, conditionalUserProperty.mTimeToLive, zzatq2);
        this.zzKc().zzf(zzatg2);
    }

    @WorkerThread
    private void zzc(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzatq zzatq2;
        this.zzmR();
        this.zzob();
        zzac.zzw((Object)conditionalUserProperty);
        zzac.zzdr((String)conditionalUserProperty.mName);
        if (!this.zzbqg.isEnabled()) {
            this.zzKk().zzMc().log("Conditional property not cleared since Firebase Analytics is disabled");
            return;
        }
        zzauq zzauq2 = new zzauq(conditionalUserProperty.mName, 0L, null, null);
        try {
            zzatq2 = this.zzKg().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, conditionalUserProperty.mCreationTimestamp, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzatg zzatg2 = new zzatg(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzauq2, conditionalUserProperty.mCreationTimestamp, conditionalUserProperty.mActive, conditionalUserProperty.mTriggerEventName, null, conditionalUserProperty.mTriggerTimeout, null, conditionalUserProperty.mTimeToLive, zzatq2);
        this.zzKc().zzf(zzatg2);
    }

    public List<AppMeasurement.ConditionalUserProperty> getConditionalUserProperties(String string, String string2) {
        this.zzJV();
        return this.zzo(null, string, string2);
    }

    public List<AppMeasurement.ConditionalUserProperty> getConditionalUserPropertiesAs(String string, String string2, String string3) {
        zzac.zzdr((String)string);
        this.zzJU();
        return this.zzo(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AppMeasurement.ConditionalUserProperty> zzo(final String string, final String string2, final String string3) {
        final AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (object) {
            this.zzbqg.zzKj().zzm(new Runnable(){

                @Override
                public void run() {
                    zzauj.this.zzbqg.zzKc().zza(atomicReference, string, string2, string3);
                }
            });
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                this.zzKk().zzLZ().zze("Interrupted waiting for get conditional user properties", string, interruptedException);
            }
        }
        object = (List)atomicReference.get();
        if (object == null) {
            this.zzKk().zzLZ().zzj("Timed out waiting for get conditional user properties", string);
            return Collections.emptyList();
        }
        ArrayList<AppMeasurement.ConditionalUserProperty> arrayList = new ArrayList<AppMeasurement.ConditionalUserProperty>(object.size());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            zzatg zzatg2 = (zzatg)((Object)iterator.next());
            AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
            conditionalUserProperty.mAppId = string;
            conditionalUserProperty.mOrigin = string2;
            conditionalUserProperty.mCreationTimestamp = zzatg2.zzbrb;
            conditionalUserProperty.mName = zzatg2.zzbra.name;
            conditionalUserProperty.mValue = zzatg2.zzbra.getValue();
            conditionalUserProperty.mActive = zzatg2.zzbrc;
            conditionalUserProperty.mTriggerEventName = zzatg2.zzbrd;
            if (zzatg2.zzbre != null) {
                conditionalUserProperty.mTimedOutEventName = zzatg2.zzbre.name;
                if (zzatg2.zzbre.zzbrK != null) {
                    conditionalUserProperty.mTimedOutEventParams = zzatg2.zzbre.zzbrK.zzLV();
                }
            }
            conditionalUserProperty.mTriggerTimeout = zzatg2.zzbrf;
            if (zzatg2.zzbrg != null) {
                conditionalUserProperty.mTriggeredEventName = zzatg2.zzbrg.name;
                if (zzatg2.zzbrg.zzbrK != null) {
                    conditionalUserProperty.mTriggeredEventParams = zzatg2.zzbrg.zzbrK.zzLV();
                }
            }
            conditionalUserProperty.mTriggeredTimestamp = zzatg2.zzbra.zzbwg;
            conditionalUserProperty.mTimeToLive = zzatg2.zzbrh;
            if (zzatg2.zzbri != null) {
                conditionalUserProperty.mExpiredEventName = zzatg2.zzbri.name;
                if (zzatg2.zzbri.zzbrK != null) {
                    conditionalUserProperty.mExpiredEventParams = zzatg2.zzbri.zzbrK.zzLV();
                }
            }
            arrayList.add(conditionalUserProperty);
        }
        return arrayList;
    }

    public Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        this.zzJV();
        return this.zzb(null, string, string2, bl);
    }

    public Map<String, Object> getUserPropertiesAs(String string, String string2, String string3, boolean bl) {
        zzac.zzdr((String)string);
        this.zzJU();
        return this.zzb(string, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> zzb(final String string, final String string2, final String string3, final boolean bl) {
        final AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (object) {
            this.zzbqg.zzKj().zzm(new Runnable(){

                @Override
                public void run() {
                    zzauj.this.zzbqg.zzKc().zza(atomicReference, string, string2, string3, bl);
                }
            });
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                this.zzKk().zzLZ().zzj("Interrupted waiting for get user properties", interruptedException);
            }
        }
        object = (List)atomicReference.get();
        if (object == null) {
            this.zzKk().zzLZ().log("Timed out waiting for get user properties");
            return Collections.emptyMap();
        }
        ArrayMap arrayMap = new ArrayMap(object.size());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            zzauq zzauq2 = (zzauq)((Object)iterator.next());
            arrayMap.put(zzauq2.name, zzauq2.getValue());
        }
        return arrayMap;
    }

    @MainThread
    @TargetApi(value=14)
    private class zza
    implements Application.ActivityLifecycleCallbacks {
        private zza() {
        }

        private boolean zzfR(String string) {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                zzauj.this.zzd("auto", "_ldl", string);
                return true;
            }
            return false;
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
            try {
                Uri uri;
                zzauj.this.zzKk().zzMd().log("onActivityCreated");
                Intent intent = activity.getIntent();
                if (intent != null && (uri = intent.getData()) != null && uri.isHierarchical()) {
                    boolean bl;
                    String string;
                    if (bundle == null) {
                        String string2;
                        string = zzauj.this.zzKg().zzu(uri);
                        String string3 = string2 = zzauj.this.zzKg().zzD(intent) ? "gs" : "auto";
                        if (string != null) {
                            zzauj.this.zze(string2, "_cmp", (Bundle)string);
                        }
                    }
                    if (TextUtils.isEmpty((CharSequence)(string = uri.getQueryParameter("referrer")))) {
                        return;
                    }
                    boolean bl2 = bl = string.contains("gclid") && (string.contains("utm_campaign") || string.contains("utm_source") || string.contains("utm_medium") || string.contains("utm_term") || string.contains("utm_content"));
                    if (!bl) {
                        zzauj.this.zzKk().zzMc().log("Activity created with data 'referrer' param without gclid and at least one utm field");
                        return;
                    }
                    zzauj.this.zzKk().zzMc().zzj("Activity created with referrer", string);
                    this.zzfR(string);
                }
            }
            catch (Throwable throwable) {
                zzauj.this.zzKk().zzLX().zzj("Throwable caught in onActivityCreated", throwable);
            }
            zzauj.this.zzKd().onActivityCreated(activity, bundle);
        }

        public void onActivityDestroyed(Activity activity) {
            zzauj.this.zzKd().onActivityDestroyed(activity);
        }

        @MainThread
        public void onActivityPaused(Activity activity) {
            zzauj.this.zzKd().onActivityPaused(activity);
            zzauj.this.zzKi().zzNd();
        }

        @MainThread
        public void onActivityResumed(Activity activity) {
            zzauj.this.zzKd().onActivityResumed(activity);
            zzauj.this.zzKi().zzNb();
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            zzauj.this.zzKd().onActivitySaveInstanceState(activity, bundle);
        }
    }
}

