/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzatx;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzauf;
import com.google.android.gms.internal.zzaut;

public final class zzaum {
    private final Handler mHandler;
    private final Context mContext;
    private final zza zzbvX;

    public zzaum(zza zza2) {
        this.mContext = zza2.getContext();
        zzac.zzw((Object)this.mContext);
        this.zzbvX = zza2;
        this.mHandler = new Handler();
    }

    public static boolean zzj(Context context, boolean bl) {
        zzac.zzw((Object)context);
        return zzaut.zzy(context, bl ? "com.google.android.gms.measurement.PackageMeasurementService" : "com.google.android.gms.measurement.AppMeasurementService");
    }

    @MainThread
    public void onCreate() {
        zzaue zzaue2 = zzaue.zzbM(this.mContext);
        zzatx zzatx2 = zzaue2.zzKk();
        zzaue2.zzKm().zzLf();
        zzatx2.zzMd().log("Local AppMeasurementService is starting up");
    }

    @MainThread
    public void onDestroy() {
        zzaue zzaue2 = zzaue.zzbM(this.mContext);
        zzatx zzatx2 = zzaue2.zzKk();
        zzaue2.zzKm().zzLf();
        zzatx2.zzMd().log("Local AppMeasurementService is shutting down");
    }

    @MainThread
    public int onStartCommand(Intent intent, int n, final int n2) {
        final zzaue zzaue2 = zzaue.zzbM(this.mContext);
        final zzatx zzatx2 = zzaue2.zzKk();
        if (intent == null) {
            zzatx2.zzLZ().log("AppMeasurementService started with null intent");
            return 2;
        }
        String string = intent.getAction();
        zzaue2.zzKm().zzLf();
        zzatx2.zzMd().zze("Local AppMeasurementService called. startId, action", n2, string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            zzaue2.zzKj().zzm(new Runnable(){

                @Override
                public void run() {
                    zzaue2.zzMK();
                    zzaue2.zzMF();
                    zzaum.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            boolean bl = zzaum.this.zzbvX.callServiceStopSelfResult(n2);
                            if (bl) {
                                zzaue2.zzKm().zzLf();
                                zzatx2.zzMd().log("Local AppMeasurementService processed last upload request");
                            }
                        }
                    });
                }
            });
        }
        return 2;
    }

    @MainThread
    public IBinder onBind(Intent intent) {
        if (intent == null) {
            this.zzKk().zzLX().log("onBind called with null intent");
            return null;
        }
        String string = intent.getAction();
        if ("com.google.android.gms.measurement.START".equals(string)) {
            return new zzauf(zzaue.zzbM(this.mContext));
        }
        this.zzKk().zzLZ().zzj("onBind received unknown action", string);
        return null;
    }

    @MainThread
    public boolean onUnbind(Intent intent) {
        if (intent == null) {
            this.zzKk().zzLX().log("onUnbind called with null intent");
            return true;
        }
        String string = intent.getAction();
        this.zzKk().zzMd().zzj("onUnbind called for intent. action", string);
        return true;
    }

    @MainThread
    public void onRebind(Intent intent) {
        if (intent == null) {
            this.zzKk().zzLX().log("onRebind called with null intent");
            return;
        }
        String string = intent.getAction();
        this.zzKk().zzMd().zzj("onRebind called. action", string);
    }

    private zzatx zzKk() {
        return zzaue.zzbM(this.mContext).zzKk();
    }

    public static interface zza {
        public boolean callServiceStopSelfResult(int var1);

        public Context getContext();
    }
}

