/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzu;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzaba;
import com.google.android.gms.internal.zzadg;
import com.google.android.gms.internal.zzats;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzaug;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class zzati
extends zzaug {
    static final String zzbrf = String.valueOf(zze.GOOGLE_PLAY_SERVICES_VERSION_CODE / 1000).replaceAll("(\\d+)(\\d)(\\d\\d)", "$1.$2.$3");
    private Boolean zzaeZ;

    zzati(zzaue zzaue2) {
        super(zzaue2);
    }

    String zzKK() {
        return zzats.zzbrO.get();
    }

    public int zzKL() {
        return 25;
    }

    public int zzKM() {
        return 40;
    }

    public int zzKN() {
        return 24;
    }

    int zzKO() {
        return 40;
    }

    int zzKP() {
        return 100;
    }

    int zzKQ() {
        return 256;
    }

    public int zzKR() {
        return 36;
    }

    public int zzKS() {
        return 2048;
    }

    int zzKT() {
        return 500;
    }

    public long zzKU() {
        return zzats.zzbrY.get().intValue();
    }

    public long zzKV() {
        return zzats.zzbsa.get().intValue();
    }

    public int zzfj(@Size(min=1L) String string) {
        int n = this.zzb(string, zzats.zzbrZ);
        n = Math.min(1000000, n);
        n = Math.max(0, n);
        return n;
    }

    public int zzfk(@Size(min=1L) String string) {
        return this.zzb(string, zzats.zzbsb);
    }

    public int zzfl(@Size(min=1L) String string) {
        return this.zzb(string, zzats.zzbsc);
    }

    int zzKW() {
        return 25;
    }

    int zzKX() {
        return 1000;
    }

    int zzKY() {
        return 25;
    }

    int zzKZ() {
        return 1000;
    }

    long zzLa() {
        return 15552000000L;
    }

    long zzLb() {
        return 15552000000L;
    }

    long zzLc() {
        return 3600000L;
    }

    long zzLd() {
        return 60000L;
    }

    long zzLe() {
        return 61000L;
    }

    long zzfm(String string) {
        return this.zza(string, zzats.zzbrP);
    }

    int zzfn(String string) {
        return this.zzb(string, zzats.zzbss);
    }

    int zzfo(String string) {
        int n = this.zzb(string, zzats.zzbst);
        n = Math.min(2000, n);
        n = Math.max(0, n);
        return n;
    }

    long zzpq() {
        return zzats.zzbsu.get();
    }

    public String zzpv() {
        return "google_app_measurement.db";
    }

    String zzLf() {
        return "google_app_measurement_local.db";
    }

    public long zzKv() {
        return 10240L;
    }

    public boolean zzLg() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzoW() {
        if (this.zzaeZ == null) {
            zzati zzati2 = this;
            synchronized (zzati2) {
                if (this.zzaeZ == null) {
                    ApplicationInfo applicationInfo = this.getContext().getApplicationInfo();
                    String string = zzu.zzzr();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzaeZ = string2 != null && string2.equals(string);
                    }
                    if (this.zzaeZ == null) {
                        this.zzaeZ = Boolean.TRUE;
                        this.zzKl().zzLY().log("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzaeZ;
    }

    public long zza(String string, zzats.zza<Long> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzKi().zzZ(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            long l = Long.valueOf(string2);
            return zza2.get(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    public int zzb(String string, zzats.zza<Integer> zza2) {
        if (string == null) {
            return zza2.get();
        }
        String string2 = this.zzKi().zzZ(string, zza2.getKey());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zza2.get();
        }
        try {
            int n = Integer.valueOf(string2);
            return zza2.get(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zza2.get();
        }
    }

    @Nullable
    Boolean zzfp(@Size(min=1L) String string) {
        zzac.zzdr((String)string);
        try {
            PackageManager packageManager = this.getContext().getPackageManager();
            if (packageManager == null) {
                this.zzKl().zzLY().log("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = zzadg.zzbi((Context)this.getContext()).getApplicationInfo(this.getContext().getPackageName(), 128);
            if (applicationInfo == null) {
                this.zzKl().zzLY().log("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            if (applicationInfo.metaData == null) {
                this.zzKl().zzLY().log("Failed to load metadata: Metadata bundle is null");
                return null;
            }
            if (!applicationInfo.metaData.containsKey(string)) {
                return null;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzKl().zzLY().zzj("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public boolean zzLh() {
        Boolean bl = this.zzfp("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public Boolean zzLi() {
        return this.zzfp("firebase_analytics_collection_enabled");
    }

    public boolean zzwR() {
        return zzaba.zzwR();
    }

    public long zzLj() {
        return zzats.zzbsr.get();
    }

    public long zzLk() {
        return zzats.zzbsm.get();
    }

    public long zzLl() {
        return zzats.zzbsn.get();
    }

    public long zzLm() {
        return 1000L;
    }

    public long zzpz() {
        return Math.max(0L, zzats.zzbrQ.get());
    }

    public int zzfq(String string) {
        return this.zzb(string, zzats.zzbrU);
    }

    public int zzfr(String string) {
        return Math.max(0, this.zzb(string, zzats.zzbrV));
    }

    public int zzfs(String string) {
        int n = this.zzb(string, zzats.zzbsd);
        n = Math.min(1000000, n);
        n = Math.max(0, n);
        return n;
    }

    public int zzLn() {
        return Math.max(0, zzats.zzbrW.get());
    }

    public int zzLo() {
        return Math.max(1, zzats.zzbrX.get());
    }

    public int zzLp() {
        return 100000;
    }

    public String zzLq() {
        return zzats.zzbse.get();
    }

    public String zzP(String string, String string2) {
        Uri.Builder builder = new Uri.Builder();
        String string3 = String.valueOf(string);
        builder.scheme(zzats.zzbrS.get()).encodedAuthority(zzats.zzbrT.get()).path(string3.length() != 0 ? "config/app/".concat(string3) : new String("config/app/")).appendQueryParameter("app_instance_id", string2).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", String.valueOf(10240L));
        return builder.build().toString();
    }

    public long zzLr() {
        return zzats.zzbrR.get();
    }

    public long zzLs() {
        return Math.max(0L, zzats.zzbsf.get());
    }

    public long zzLt() {
        return Math.max(0L, zzats.zzbsh.get());
    }

    public long zzLu() {
        return Math.max(0L, zzats.zzbsi.get());
    }

    public long zzLv() {
        return Math.max(0L, zzats.zzbsj.get());
    }

    public long zzLw() {
        return Math.max(0L, zzats.zzbsk.get());
    }

    public long zzLx() {
        return Math.max(0L, zzats.zzbsl.get());
    }

    public long zzLy() {
        return zzats.zzbsg.get();
    }

    public long zzLz() {
        return Math.max(0L, zzats.zzbso.get());
    }

    public long zzLA() {
        return Math.max(0L, zzats.zzbsp.get());
    }

    public int zzLB() {
        return Math.min(20, Math.max(0, zzats.zzbsq.get()));
    }

    public String zzLC() {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method method = clazz.getMethod("get", String.class, String.class);
            return (String)method.invoke(null, "debug.firebase.analytics.app", "");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.zzKl().zzLY().zzj("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.zzKl().zzLY().zzj("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.zzKl().zzLY().zzj("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.zzKl().zzLY().zzj("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return "";
    }
}

