/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzauh;
import com.google.android.gms.internal.zzaut;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Locale;

class zzaua
extends zzauh {
    static final Pair<String, Long> zzbsX = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzagD;
    public final zzc zzbsY = new zzc("health_monitor", this.zzKn().zzpz());
    public final zzb zzbsZ = new zzb("last_upload", 0L);
    public final zzb zzbta = new zzb("last_upload_attempt", 0L);
    public final zzb zzbtb = new zzb("backoff", 0L);
    public final zzb zzbtc = new zzb("last_delete_stale", 0L);
    public final zzb zzbtd;
    private String zzbte;
    private boolean zzbtf;
    private long zzbtg;
    private String zzbth;
    private long zzbti;
    private final Object zzbtj;
    private SecureRandom zzbtk;
    public final zzb zzbtl = new zzb("time_before_start", 10000L);
    public final zzb zzbtm = new zzb("session_timeout", 1800000L);
    public final zza zzbtn = new zza("start_new_session", true);
    public final zzb zzbto = new zzb("last_pause_time", 0L);
    public final zzb zzbtp = new zzb("time_active", 0L);
    public boolean zzbtq;

    @WorkerThread
    private SecureRandom zzMg() {
        this.zzmR();
        if (this.zzbtk == null) {
            this.zzbtk = new SecureRandom();
        }
        return this.zzbtk;
    }

    @WorkerThread
    @NonNull
    Pair<String, Boolean> zzfG(String string) {
        this.zzmR();
        long l = this.zznR().elapsedRealtime();
        if (this.zzbte != null && l < this.zzbtg) {
            return new Pair((Object)this.zzbte, (Object)this.zzbtf);
        }
        this.zzbtg = l + this.zzKn().zzfm(string);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            this.zzbte = info.getId();
            if (this.zzbte == null) {
                this.zzbte = "";
            }
            this.zzbtf = info.isLimitAdTrackingEnabled();
        }
        catch (Throwable throwable) {
            this.zzKl().zzMd().zzj("Unable to get advertising id", throwable);
            this.zzbte = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzbte, (Object)this.zzbtf);
    }

    @WorkerThread
    String zzfH(String string) {
        this.zzmR();
        String string2 = (String)this.zzfG((String)string).first;
        MessageDigest messageDigest = zzaut.zzch("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    @WorkerThread
    String zzMh() {
        byte[] byArray = new byte[16];
        this.zzMg().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    String zzKq() {
        this.zzmR();
        try {
            return com.google.firebase.iid.zzc.zzabL().getId();
        }
        catch (IllegalStateException illegalStateException) {
            this.zzKl().zzMa().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    @WorkerThread
    long zzMi() {
        this.zzob();
        this.zzmR();
        long l = this.zzbtd.get();
        if (l == 0L) {
            l = 1 + this.zzMg().nextInt(86400000);
            this.zzbtd.set(l);
        }
        return l;
    }

    zzaua(zzaue zzaue2) {
        super(zzaue2);
        this.zzbtd = new zzb("midnight_offset", 0L);
        this.zzbtj = new Object();
    }

    @Override
    protected void zzmS() {
        this.zzagD = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzbtq = this.zzagD.getBoolean("has_been_opened", false);
        if (!this.zzbtq) {
            SharedPreferences.Editor editor = this.zzagD.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
    }

    @WorkerThread
    private SharedPreferences zzMj() {
        this.zzmR();
        this.zzob();
        return this.zzagD;
    }

    @WorkerThread
    void zzfI(String string) {
        this.zzmR();
        SharedPreferences.Editor editor = this.zzMj().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    String zzMk() {
        this.zzmR();
        return this.zzMj().getString("gmp_app_id", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzfJ(String string) {
        Object object = this.zzbtj;
        synchronized (object) {
            this.zzbth = string;
            this.zzbti = this.zznR().elapsedRealtime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String zzMl() {
        Object object = this.zzbtj;
        synchronized (object) {
            if (Math.abs(this.zznR().elapsedRealtime() - this.zzbti) < 1000L) {
                return this.zzbth;
            }
            return null;
        }
    }

    @WorkerThread
    Boolean zzMm() {
        this.zzmR();
        if (!this.zzMj().contains("use_service")) {
            return null;
        }
        return this.zzMj().getBoolean("use_service", false);
    }

    @WorkerThread
    void zzaK(boolean bl) {
        this.zzmR();
        this.zzKl().zzMe().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzMj().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    void zzMn() {
        this.zzmR();
        this.zzKl().zzMe().log("Clearing collection preferences.");
        boolean bl = this.zzMj().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzaL(true);
        }
        SharedPreferences.Editor editor = this.zzMj().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    void setMeasurementEnabled(boolean bl) {
        this.zzmR();
        this.zzKl().zzMe().zzj("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzMj().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    boolean zzaL(boolean bl) {
        this.zzmR();
        return this.zzMj().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected String zzMo() {
        this.zzmR();
        String string = this.zzMj().getString("previous_os_version", null);
        String string2 = this.zzKc().zzLS();
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzMj().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    public final class zza {
        private final String zzAX;
        private final boolean zzbtr;
        private boolean zzbts;
        private boolean zzayS;

        public zza(String string, boolean bl) {
            zzac.zzdr((String)string);
            this.zzAX = string;
            this.zzbtr = bl;
        }

        @WorkerThread
        private void zzMp() {
            if (this.zzbts) {
                return;
            }
            this.zzbts = true;
            this.zzayS = zzaua.this.zzagD.getBoolean(this.zzAX, this.zzbtr);
        }

        @WorkerThread
        public boolean get() {
            this.zzMp();
            return this.zzayS;
        }

        @WorkerThread
        public void set(boolean bl) {
            SharedPreferences.Editor editor = zzaua.this.zzagD.edit();
            editor.putBoolean(this.zzAX, bl);
            editor.apply();
            this.zzayS = bl;
        }
    }

    public final class zzb {
        private final String zzAX;
        private final long zzbtu;
        private boolean zzbts;
        private long zzadd;

        public zzb(String string, long l) {
            zzac.zzdr((String)string);
            this.zzAX = string;
            this.zzbtu = l;
        }

        @WorkerThread
        private void zzMp() {
            if (this.zzbts) {
                return;
            }
            this.zzbts = true;
            this.zzadd = zzaua.this.zzagD.getLong(this.zzAX, this.zzbtu);
        }

        @WorkerThread
        public long get() {
            this.zzMp();
            return this.zzadd;
        }

        @WorkerThread
        public void set(long l) {
            SharedPreferences.Editor editor = zzaua.this.zzagD.edit();
            editor.putLong(this.zzAX, l);
            editor.apply();
            this.zzadd = l;
        }
    }

    public final class zzc {
        final String zzbtv;
        private final String zzbtw;
        private final String zzbtx;
        private final long zzagH;

        private zzc(String string, long l) {
            zzac.zzdr((String)string);
            zzac.zzax((l > 0L ? 1 : 0) != 0);
            this.zzbtv = String.valueOf(string).concat(":start");
            this.zzbtw = String.valueOf(string).concat(":count");
            this.zzbtx = String.valueOf(string).concat(":value");
            this.zzagH = l;
        }

        @WorkerThread
        private void zzqk() {
            zzaua.this.zzmR();
            long l = zzaua.this.zznR().currentTimeMillis();
            SharedPreferences.Editor editor = zzaua.this.zzagD.edit();
            editor.remove(this.zzbtw);
            editor.remove(this.zzbtx);
            editor.putLong(this.zzbtv, l);
            editor.apply();
        }

        @WorkerThread
        private long zzql() {
            zzaua.this.zzmR();
            long l = this.zzqn();
            if (l == 0L) {
                this.zzqk();
                return 0L;
            }
            return Math.abs(l - zzaua.this.zznR().currentTimeMillis());
        }

        @WorkerThread
        public void zzcc(String string) {
            this.zzk(string, 1L);
        }

        @WorkerThread
        public void zzk(String string, long l) {
            long l2;
            zzaua.this.zzmR();
            long l3 = this.zzqn();
            if (l3 == 0L) {
                this.zzqk();
            }
            if (string == null) {
                string = "";
            }
            if ((l2 = zzaua.this.zzagD.getLong(this.zzbtw, 0L)) <= 0L) {
                SharedPreferences.Editor editor = zzaua.this.zzagD.edit();
                editor.putString(this.zzbtx, string);
                editor.putLong(this.zzbtw, l);
                editor.apply();
                return;
            }
            long l4 = zzaua.this.zzMg().nextLong() & Long.MAX_VALUE;
            boolean bl = l4 < Long.MAX_VALUE / (l2 + l) * l;
            SharedPreferences.Editor editor = zzaua.this.zzagD.edit();
            if (bl) {
                editor.putString(this.zzbtx, string);
            }
            editor.putLong(this.zzbtw, l2 + l);
            editor.apply();
        }

        @WorkerThread
        public Pair<String, Long> zzqm() {
            zzaua.this.zzmR();
            long l = this.zzql();
            if (l < this.zzagH) {
                return null;
            }
            if (l > this.zzagH * 2L) {
                this.zzqk();
                return null;
            }
            String string = zzaua.this.zzMj().getString(this.zzbtx, null);
            long l2 = zzaua.this.zzMj().getLong(this.zzbtw, 0L);
            this.zzqk();
            if (string == null || l2 <= 0L) {
                return zzbsX;
            }
            return new Pair((Object)string, (Object)l2);
        }

        @WorkerThread
        private long zzqn() {
            return zzaua.this.zzMj().getLong(this.zzbtv, 0L);
        }
    }
}

