/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzauh;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class zzaud
extends zzauh {
    private ExecutorService zzbtI;
    private zzd zzbtJ;
    private zzd zzbtK;
    private final PriorityBlockingQueue<FutureTask<?>> zzbtL;
    private final BlockingQueue<FutureTask<?>> zzbtM;
    private final Thread.UncaughtExceptionHandler zzbtN;
    private final Thread.UncaughtExceptionHandler zzbtO;
    private final Object zzbtP = new Object();
    private final Semaphore zzbtQ = new Semaphore(2);
    private volatile boolean zzbtR;
    private static final AtomicLong zzbtS = new AtomicLong(Long.MIN_VALUE);

    zzaud(zzaue zzaue2) {
        super(zzaue2);
        this.zzbtL = new PriorityBlockingQueue();
        this.zzbtM = new LinkedBlockingQueue();
        this.zzbtN = new zzb("Thread death: Uncaught exception on worker thread");
        this.zzbtO = new zzb("Thread death: Uncaught exception on network thread");
    }

    @Override
    protected void zzmS() {
    }

    @Override
    public void zzmR() {
        if (Thread.currentThread() != this.zzbtJ) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public void zzJX() {
        if (Thread.currentThread() != this.zzbtK) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public boolean zzbc() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public boolean zzMq() {
        return Thread.currentThread() == this.zzbtJ;
    }

    public <V> Future<V> zzd(Callable<V> callable) throws IllegalStateException {
        this.zzob();
        zzac.zzw(callable);
        zzc<V> zzc2 = new zzc<V>(callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzbtJ) {
            zzc2.run();
        } else {
            this.zza(zzc2);
        }
        return zzc2;
    }

    public <V> Future<V> zze(Callable<V> callable) throws IllegalStateException {
        this.zzob();
        zzac.zzw(callable);
        zzc<V> zzc2 = new zzc<V>(callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzbtJ) {
            zzc2.run();
        } else {
            this.zza(zzc2);
        }
        return zzc2;
    }

    public void zzm(Runnable runnable) throws IllegalStateException {
        this.zzob();
        zzac.zzw((Object)runnable);
        this.zza(new zzc(runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(zzc<?> zzc2) {
        Object object = this.zzbtP;
        synchronized (object) {
            this.zzbtL.add(zzc2);
            if (this.zzbtJ == null) {
                this.zzbtJ = new zzd("Measurement Worker", this.zzbtL);
                this.zzbtJ.setUncaughtExceptionHandler(this.zzbtN);
                this.zzbtJ.start();
            } else {
                this.zzbtJ.zzhA();
            }
        }
    }

    public void zzn(Runnable runnable) throws IllegalStateException {
        this.zzob();
        zzac.zzw((Object)runnable);
        this.zza(new zzc(runnable, false, "Task exception on network thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(FutureTask<?> futureTask) {
        Object object = this.zzbtP;
        synchronized (object) {
            this.zzbtM.add(futureTask);
            if (this.zzbtK == null) {
                this.zzbtK = new zzd("Measurement Network", this.zzbtM);
                this.zzbtK.setUncaughtExceptionHandler(this.zzbtO);
                this.zzbtK.start();
            } else {
                this.zzbtK.zzhA();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorService zzMr() {
        Object object = this.zzbtP;
        synchronized (object) {
            if (this.zzbtI == null) {
                this.zzbtI = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzbtI;
        }
    }

    static class zza
    extends RuntimeException {
    }

    private final class zzb
    implements Thread.UncaughtExceptionHandler {
        private final String zzbtT;

        public zzb(String string) {
            zzac.zzw((Object)string);
            this.zzbtT = string;
        }

        @Override
        public synchronized void uncaughtException(Thread thread, Throwable throwable) {
            zzaud.this.zzKl().zzLY().zzj(this.zzbtT, throwable);
        }
    }

    private final class zzc<V>
    extends FutureTask<V>
    implements Comparable<zzc> {
        private final long zzbtV;
        private final boolean zzbtW;
        private final String zzbtT;

        zzc(Callable<V> callable, boolean bl, String string) {
            super(callable);
            zzac.zzw((Object)string);
            this.zzbtV = zzbtS.getAndIncrement();
            this.zzbtT = string;
            this.zzbtW = bl;
            if (this.zzbtV == Long.MAX_VALUE) {
                zzaud.this.zzKl().zzLY().log("Tasks index overflow");
            }
        }

        zzc(Runnable runnable, boolean bl, String string) {
            super(runnable, null);
            zzac.zzw((Object)string);
            this.zzbtV = zzbtS.getAndIncrement();
            this.zzbtT = string;
            this.zzbtW = bl;
            if (this.zzbtV == Long.MAX_VALUE) {
                zzaud.this.zzKl().zzLY().log("Tasks index overflow");
            }
        }

        @Override
        protected void setException(Throwable throwable) {
            zzaud.this.zzKl().zzLY().zzj(this.zzbtT, throwable);
            if (throwable instanceof zza) {
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), throwable);
            }
            super.setException(throwable);
        }

        public int zzb(@NonNull zzc zzc2) {
            if (this.zzbtW != zzc2.zzbtW) {
                return this.zzbtW ? -1 : 1;
            }
            if (this.zzbtV < zzc2.zzbtV) {
                return -1;
            }
            if (this.zzbtV > zzc2.zzbtV) {
                return 1;
            }
            zzaud.this.zzKl().zzLZ().zzj("Two tasks share the same index. index", this.zzbtV);
            return 0;
        }

        @Override
        public /* synthetic */ int compareTo(@NonNull Object object) {
            return this.zzb((zzc)object);
        }
    }

    private final class zzd
    extends Thread {
        private final Object zzbtX;
        private final BlockingQueue<FutureTask<?>> zzbtY;

        public zzd(String string, BlockingQueue<FutureTask<?>> blockingQueue) {
            zzac.zzw((Object)string);
            zzac.zzw(blockingQueue);
            this.zzbtX = new Object();
            this.zzbtY = blockingQueue;
            this.setName(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean bl = false;
            while (!bl) {
                try {
                    zzaud.this.zzbtQ.acquire();
                    bl = true;
                }
                catch (InterruptedException interruptedException) {
                    this.zza(interruptedException);
                }
            }
            try {
                while (true) {
                    FutureTask futureTask;
                    if ((futureTask = (FutureTask)this.zzbtY.poll()) != null) {
                        futureTask.run();
                        continue;
                    }
                    Object object = this.zzbtX;
                    synchronized (object) {
                        if (this.zzbtY.peek() == null && !zzaud.this.zzbtR) {
                            try {
                                this.zzbtX.wait(30000L);
                            }
                            catch (InterruptedException interruptedException) {
                                this.zza(interruptedException);
                            }
                        }
                    }
                    object = zzaud.this.zzbtP;
                    synchronized (object) {
                        if (this.zzbtY.peek() == null) {
                            return;
                        }
                    }
                }
            }
            finally {
                Object object = zzaud.this.zzbtP;
                synchronized (object) {
                    zzaud.this.zzbtQ.release();
                    zzaud.this.zzbtP.notifyAll();
                    if (this == zzaud.this.zzbtJ) {
                        zzaud.this.zzbtJ = null;
                    } else if (this == zzaud.this.zzbtK) {
                        zzaud.this.zzbtK = null;
                    } else {
                        zzaud.this.zzKl().zzLY().log("Current scheduler thread is neither worker nor network");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzhA() {
            Object object = this.zzbtX;
            synchronized (object) {
                this.zzbtX.notifyAll();
            }
        }

        private void zza(InterruptedException interruptedException) {
            zzaud.this.zzKl().zzMa().zzj(String.valueOf(this.getName()).concat(" was interrupted"), interruptedException);
        }
    }
}

