/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzatg;
import com.google.android.gms.internal.zzatk;
import com.google.android.gms.internal.zzatq;
import com.google.android.gms.internal.zzatt;
import com.google.android.gms.internal.zzatw;
import com.google.android.gms.internal.zzatx;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzauh;
import com.google.android.gms.internal.zzauo;
import com.google.android.gms.internal.zzauq;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class zzaul
extends zzauh {
    private final zza zzbvA;
    private zzatt zzbvB;
    private Boolean zzbvC;
    private final zzatk zzbvD;
    private final zzauo zzbvE;
    private final List<Runnable> zzbvF = new ArrayList<Runnable>();
    private final zzatk zzbvG;

    protected zzaul(zzaue zzaue2) {
        super(zzaue2);
        this.zzbvE = new zzauo(zzaue2.zznR());
        this.zzbvA = new zza();
        this.zzbvD = new zzatk(zzaue2){

            @Override
            public void run() {
                zzaul.this.zzop();
            }
        };
        this.zzbvG = new zzatk(zzaue2){

            @Override
            public void run() {
                zzaul.this.zzKl().zzMa().log("Tasks have been queued for a long time");
            }
        };
    }

    @Override
    protected void zzmS() {
    }

    @WorkerThread
    public boolean isConnected() {
        this.zzmR();
        this.zzob();
        return this.zzbvB != null;
    }

    @WorkerThread
    protected void zzMW() {
        this.zzmR();
        this.zzob();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzatt zzatt2 = zzaul.this.zzbvB;
                if (zzatt2 == null) {
                    zzaul.this.zzKl().zzLY().log("Failed to send measurementEnabled to service");
                    return;
                }
                try {
                    zzatt2.zzb(zzaul.this.zzKb().zzfD(zzaul.this.zzKl().zzMf()));
                    zzaul.this.zzoo();
                }
                catch (RemoteException remoteException) {
                    zzaul.this.zzKl().zzLY().zzj("Failed to send measurementEnabled to the service", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    void zza(zzatt zzatt2, com.google.android.gms.common.internal.safeparcel.zza zza2) {
        this.zzmR();
        this.zzJW();
        this.zzob();
        this.zzKn().zzLg();
        ArrayList<com.google.android.gms.common.internal.safeparcel.zza> arrayList = new ArrayList<com.google.android.gms.common.internal.safeparcel.zza>();
        int n = 100;
        this.zzKn().zzLp();
        for (int i = 0; i < 1001 && n == 100; ++i) {
            n = 0;
            List<com.google.android.gms.common.internal.safeparcel.zza> list = this.zzKf().zzlD(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (zza2 != null && n < 100) {
                arrayList.add(zza2);
            }
            for (com.google.android.gms.common.internal.safeparcel.zza zza3 : arrayList) {
                if (zza3 instanceof zzatq) {
                    try {
                        zzatt2.zza((zzatq)zza3, this.zzKb().zzfD(this.zzKl().zzMf()));
                    }
                    catch (RemoteException remoteException) {
                        this.zzKl().zzLY().zzj("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zza3 instanceof zzauq) {
                    try {
                        zzatt2.zza((zzauq)zza3, this.zzKb().zzfD(this.zzKl().zzMf()));
                    }
                    catch (RemoteException remoteException) {
                        this.zzKl().zzLY().zzj("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zza3 instanceof zzatg) {
                    try {
                        zzatt2.zza((zzatg)zza3, this.zzKb().zzfD(this.zzKl().zzMf()));
                    }
                    catch (RemoteException remoteException) {
                        this.zzKl().zzLY().zzj("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                this.zzKl().zzLY().log("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected void zzc(zzatq zzatq2, String string) {
        zzac.zzw((Object)((Object)zzatq2));
        this.zzmR();
        this.zzob();
        this.zzKn().zzLg();
        boolean bl = this.zzKf().zza(zzatq2);
        this.zzo(new Runnable(true, bl, zzatq2, string){
            final /* synthetic */ boolean zzbvK;
            final /* synthetic */ boolean zzbvL;
            final /* synthetic */ zzatq zzbuQ;
            final /* synthetic */ String zzbkW;
            {
                this.zzbvK = bl;
                this.zzbvL = bl2;
                this.zzbuQ = zzatq2;
                this.zzbkW = string;
            }

            @Override
            public void run() {
                zzatt zzatt2 = zzaul.this.zzbvB;
                if (zzatt2 == null) {
                    zzaul.this.zzKl().zzLY().log("Discarding data. Failed to send event to service");
                    return;
                }
                if (this.zzbvK) {
                    zzaul.this.zza(zzatt2, this.zzbvL ? null : this.zzbuQ);
                } else {
                    try {
                        if (TextUtils.isEmpty((CharSequence)this.zzbkW)) {
                            zzatt2.zza(this.zzbuQ, zzaul.this.zzKb().zzfD(zzaul.this.zzKl().zzMf()));
                        } else {
                            zzatt2.zza(this.zzbuQ, this.zzbkW, zzaul.this.zzKl().zzMf());
                        }
                    }
                    catch (RemoteException remoteException) {
                        zzaul.this.zzKl().zzLY().zzj("Failed to send event to the service", (Object)remoteException);
                    }
                }
                zzaul.this.zzoo();
            }
        });
    }

    @WorkerThread
    protected void zzf(zzatg zzatg2) {
        zzac.zzw((Object)((Object)zzatg2));
        this.zzmR();
        this.zzob();
        this.zzKn().zzLg();
        boolean bl = this.zzKf().zzc(zzatg2);
        zzatg zzatg3 = new zzatg(zzatg2);
        this.zzo(new Runnable(true, bl, zzatg3, zzatg2){
            final /* synthetic */ boolean zzbvK;
            final /* synthetic */ boolean zzbvL;
            final /* synthetic */ zzatg zzbvM;
            final /* synthetic */ zzatg zzbvN;
            {
                this.zzbvK = bl;
                this.zzbvL = bl2;
                this.zzbvM = zzatg2;
                this.zzbvN = zzatg3;
            }

            @Override
            public void run() {
                zzatt zzatt2 = zzaul.this.zzbvB;
                if (zzatt2 == null) {
                    zzaul.this.zzKl().zzLY().log("Discarding data. Failed to send conditional user property to service");
                    return;
                }
                if (this.zzbvK) {
                    zzaul.this.zza(zzatt2, this.zzbvL ? null : this.zzbvM);
                } else {
                    try {
                        if (TextUtils.isEmpty((CharSequence)this.zzbvN.packageName)) {
                            zzatt2.zza(this.zzbvM, zzaul.this.zzKb().zzfD(zzaul.this.zzKl().zzMf()));
                        } else {
                            zzatt2.zzb(this.zzbvM);
                        }
                    }
                    catch (RemoteException remoteException) {
                        zzaul.this.zzKl().zzLY().zzj("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                }
                zzaul.this.zzoo();
            }
        });
    }

    @WorkerThread
    protected void zza(final AtomicReference<List<zzatg>> atomicReference, final String string, final String string2, final String string3) {
        this.zzmR();
        this.zzob();
        this.zzo(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicReference atomicReference2 = atomicReference;
                synchronized (atomicReference2) {
                    try {
                        zzatt zzatt2 = zzaul.this.zzbvB;
                        if (zzatt2 == null) {
                            zzaul.this.zzKl().zzLY().zzd("Failed to get conditional properties", zzatx.zzfE(string), string2, string3);
                            atomicReference.set(Collections.emptyList());
                            return;
                        }
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            atomicReference.set(zzatt2.zza(string2, string3, zzaul.this.zzKb().zzfD(zzaul.this.zzKl().zzMf())));
                        } else {
                            atomicReference.set(zzatt2.zzn(string, string2, string3));
                        }
                        zzaul.this.zzoo();
                    }
                    catch (RemoteException remoteException) {
                        zzaul.this.zzKl().zzLY().zzd("Failed to get conditional properties", zzatx.zzfE(string), string2, (Object)remoteException);
                        atomicReference.set(Collections.emptyList());
                    }
                    finally {
                        atomicReference.notify();
                    }
                }
            }
        });
    }

    @WorkerThread
    protected void zza(final AtomicReference<List<zzauq>> atomicReference, final String string, final String string2, final String string3, final boolean bl) {
        this.zzmR();
        this.zzob();
        this.zzo(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicReference atomicReference2 = atomicReference;
                synchronized (atomicReference2) {
                    try {
                        zzatt zzatt2 = zzaul.this.zzbvB;
                        if (zzatt2 == null) {
                            zzaul.this.zzKl().zzLY().zzd("Failed to get user properties", zzatx.zzfE(string), string2, string3);
                            atomicReference.set(Collections.emptyList());
                            return;
                        }
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            atomicReference.set(zzatt2.zza(string2, string3, bl, zzaul.this.zzKb().zzfD(zzaul.this.zzKl().zzMf())));
                        } else {
                            atomicReference.set(zzatt2.zza(string, string2, string3, bl));
                        }
                        zzaul.this.zzoo();
                    }
                    catch (RemoteException remoteException) {
                        zzaul.this.zzKl().zzLY().zzd("Failed to get user properties", zzatx.zzfE(string), string2, (Object)remoteException);
                        atomicReference.set(Collections.emptyList());
                    }
                    finally {
                        atomicReference.notify();
                    }
                }
            }
        });
    }

    @WorkerThread
    protected void zzb(final zzauq zzauq2) {
        this.zzmR();
        this.zzob();
        this.zzKn().zzLg();
        final boolean bl = this.zzKf().zza(zzauq2);
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzatt zzatt2 = zzaul.this.zzbvB;
                if (zzatt2 == null) {
                    zzaul.this.zzKl().zzLY().log("Discarding data. Failed to set user attribute");
                    return;
                }
                zzaul.this.zza(zzatt2, bl ? null : zzauq2);
                zzaul.this.zzoo();
            }
        });
    }

    @WorkerThread
    protected void zza(final AtomicReference<List<zzauq>> atomicReference, final boolean bl) {
        this.zzmR();
        this.zzob();
        this.zzo(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicReference atomicReference2 = atomicReference;
                synchronized (atomicReference2) {
                    try {
                        zzatt zzatt2 = zzaul.this.zzbvB;
                        if (zzatt2 == null) {
                            zzaul.this.zzKl().zzLY().log("Failed to get user properties");
                            return;
                        }
                        atomicReference.set(zzatt2.zza(zzaul.this.zzKb().zzfD(null), bl));
                        zzaul.this.zzoo();
                    }
                    catch (RemoteException remoteException) {
                        zzaul.this.zzKl().zzLY().zzj("Failed to get user properties", (Object)remoteException);
                    }
                    finally {
                        atomicReference.notify();
                    }
                }
            }
        });
    }

    @WorkerThread
    public void zza(final AtomicReference<String> atomicReference) {
        this.zzmR();
        this.zzob();
        this.zzo(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicReference atomicReference2 = atomicReference;
                synchronized (atomicReference2) {
                    try {
                        zzatt zzatt2 = zzaul.this.zzbvB;
                        if (zzatt2 == null) {
                            zzaul.this.zzKl().zzLY().log("Failed to get app instance id");
                            return;
                        }
                        atomicReference.set(zzatt2.zzc(zzaul.this.zzKb().zzfD(null)));
                        zzaul.this.zzoo();
                    }
                    catch (RemoteException remoteException) {
                        zzaul.this.zzKl().zzLY().zzj("Failed to get app instance id", (Object)remoteException);
                    }
                    finally {
                        atomicReference.notify();
                    }
                }
            }
        });
    }

    @WorkerThread
    protected void zzMR() {
        this.zzmR();
        this.zzob();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzatt zzatt2 = zzaul.this.zzbvB;
                if (zzatt2 == null) {
                    zzaul.this.zzKl().zzLY().log("Discarding data. Failed to send app launch");
                    return;
                }
                try {
                    zzatt2.zza(zzaul.this.zzKb().zzfD(zzaul.this.zzKl().zzMf()));
                    zzaul.this.zza(zzatt2, null);
                    zzaul.this.zzoo();
                }
                catch (RemoteException remoteException) {
                    zzaul.this.zzKl().zzLY().zzj("Failed to send app launch to the service", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    protected void zza(final AppMeasurement.zzf zzf2) {
        this.zzmR();
        this.zzob();
        this.zzo(new Runnable(){

            @Override
            public void run() {
                zzatt zzatt2 = zzaul.this.zzbvB;
                if (zzatt2 == null) {
                    zzaul.this.zzKl().zzLY().log("Failed to send current screen to service");
                    return;
                }
                try {
                    if (zzf2 == null) {
                        zzatt2.zza(0L, null, null, zzaul.this.getContext().getPackageName());
                    } else {
                        zzatt2.zza(zzf2.zzbqh, zzf2.zzbqf, zzf2.zzbqg, zzaul.this.getContext().getPackageName());
                    }
                    zzaul.this.zzoo();
                }
                catch (RemoteException remoteException) {
                    zzaul.this.zzKl().zzLY().zzj("Failed to send current screen to the service", (Object)remoteException);
                }
            }
        });
    }

    @WorkerThread
    private void zzoo() {
        this.zzmR();
        this.zzbvE.start();
        this.zzbvD.zzy(this.zzKn().zzpq());
    }

    @WorkerThread
    void zzoD() {
        this.zzmR();
        this.zzob();
        if (this.isConnected()) {
            return;
        }
        if (this.zzbvC == null) {
            this.zzbvC = this.zzKm().zzMm();
            if (this.zzbvC == null) {
                this.zzKl().zzMe().log("State of service unknown");
                this.zzbvC = this.zzMY();
                this.zzKm().zzaK(this.zzbvC);
            }
        }
        if (this.zzbvC.booleanValue()) {
            this.zzKl().zzMe().log("Using measurement service");
            this.zzbvA.zzNb();
        } else {
            if (this.zzMX()) {
                this.zzKl().zzMe().log("Using local app measurement service");
                Intent intent = new Intent("com.google.android.gms.measurement.START");
                Context context = this.getContext();
                this.zzKn().zzLg();
                intent.setComponent(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementService"));
                this.zzbvA.zzz(intent);
                return;
            }
            this.zzKl().zzLY().log("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    private boolean zzMX() {
        this.zzKn().zzLg();
        PackageManager packageManager = this.getContext().getPackageManager();
        Intent intent = new Intent().setClassName(this.getContext(), "com.google.android.gms.measurement.AppMeasurementService");
        List list = packageManager.queryIntentServices(intent, 65536);
        return list != null && list.size() > 0;
    }

    @WorkerThread
    protected boolean zzMY() {
        this.zzmR();
        this.zzob();
        this.zzKn().zzLg();
        this.zzKl().zzMe().log("Checking service availability");
        int n = zze.zzuY().isGooglePlayServicesAvailable(this.getContext());
        switch (n) {
            case 0: {
                this.zzKl().zzMe().log("Service available");
                return true;
            }
            case 1: {
                this.zzKl().zzMe().log("Service missing");
                return false;
            }
            case 18: {
                this.zzKl().zzMa().log("Service updating");
                return true;
            }
            case 2: {
                this.zzKl().zzMd().log("Service container out of date");
                return true;
            }
            case 3: {
                this.zzKl().zzMa().log("Service disabled");
                return false;
            }
            case 9: {
                this.zzKl().zzMa().log("Service invalid");
                return false;
            }
        }
        return false;
    }

    @WorkerThread
    protected void zza(zzatt zzatt2) {
        this.zzmR();
        zzac.zzw((Object)zzatt2);
        this.zzbvB = zzatt2;
        this.zzoo();
        this.zzNa();
    }

    @WorkerThread
    public void disconnect() {
        this.zzmR();
        this.zzob();
        try {
            com.google.android.gms.common.stats.zza zza2 = com.google.android.gms.common.stats.zza.zzyJ();
            zza2.zza(this.getContext(), (ServiceConnection)this.zzbvA);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzbvB = null;
    }

    @WorkerThread
    private void onServiceDisconnected(ComponentName componentName) {
        this.zzmR();
        if (this.zzbvB != null) {
            this.zzbvB = null;
            this.zzKl().zzMe().zzj("Disconnected from device MeasurementService", componentName);
            this.zzMZ();
        }
    }

    @WorkerThread
    private void zzop() {
        this.zzmR();
        if (!this.isConnected()) {
            return;
        }
        this.zzKl().zzMe().log("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private void zzMZ() {
        this.zzmR();
        this.zzoD();
    }

    @WorkerThread
    private void zzo(Runnable runnable) throws IllegalStateException {
        this.zzmR();
        if (this.isConnected()) {
            runnable.run();
        } else {
            if ((long)this.zzbvF.size() >= this.zzKn().zzLm()) {
                this.zzKl().zzLY().log("Discarding data. Max runnable queue size reached");
                return;
            }
            this.zzbvF.add(runnable);
            this.zzbvG.zzy(60000L);
            this.zzoD();
        }
    }

    @WorkerThread
    private void zzNa() {
        this.zzmR();
        this.zzKl().zzMe().zzj("Processing queued up service tasks", this.zzbvF.size());
        for (Runnable runnable : this.zzbvF) {
            this.zzKk().zzm(runnable);
        }
        this.zzbvF.clear();
        this.zzbvG.cancel();
    }

    protected class zza
    implements ServiceConnection,
    zzf.zzb,
    zzf.zzc {
        private volatile boolean zzbvO;
        private volatile zzatw zzbvP;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzz(Intent intent) {
            zzaul.this.zzmR();
            Context context = zzaul.this.getContext();
            com.google.android.gms.common.stats.zza zza2 = com.google.android.gms.common.stats.zza.zzyJ();
            zza zza3 = this;
            synchronized (zza3) {
                if (this.zzbvO) {
                    zzaul.this.zzKl().zzMe().log("Connection attempt already in progress");
                    return;
                }
                this.zzbvO = true;
                zza2.zza(context, intent, (ServiceConnection)zzaul.this.zzbvA, 129);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            zzac.zzdj((String)"MeasurementServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                Object object;
                if (iBinder == null) {
                    this.zzbvO = false;
                    zzaul.this.zzKl().zzLY().log("Service connected with null binder");
                    return;
                }
                zzatt zzatt2 = null;
                try {
                    object = iBinder.getInterfaceDescriptor();
                    if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(object)) {
                        zzatt2 = zzatt.zza.zzes(iBinder);
                        zzaul.this.zzKl().zzMe().log("Bound to IMeasurementService interface");
                    } else {
                        zzaul.this.zzKl().zzLY().zzj("Got binder with a wrong descriptor", object);
                    }
                }
                catch (RemoteException remoteException) {
                    zzaul.this.zzKl().zzLY().log("Service connect failed to get IMeasurementService");
                }
                if (zzatt2 == null) {
                    this.zzbvO = false;
                    try {
                        com.google.android.gms.common.stats.zza.zzyJ().zza(zzaul.this.getContext(), (ServiceConnection)zzaul.this.zzbvA);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else {
                    object = zzatt2;
                    zzaul.this.zzKk().zzm(new Runnable((zzatt)object){
                        final /* synthetic */ zzatt zzbvQ;
                        {
                            this.zzbvQ = zzatt2;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            zza zza2 = zza.this;
                            synchronized (zza2) {
                                zza.this.zzbvO = false;
                                if (!zzaul.this.isConnected()) {
                                    zzaul.this.zzKl().zzMe().log("Connected to service");
                                    zzaul.this.zza(this.zzbvQ);
                                }
                            }
                        }
                    });
                }
            }
        }

        @MainThread
        public void onServiceDisconnected(final ComponentName componentName) {
            zzac.zzdj((String)"MeasurementServiceConnection.onServiceDisconnected");
            zzaul.this.zzKl().zzMd().log("Service disconnected");
            zzaul.this.zzKk().zzm(new Runnable(){

                @Override
                public void run() {
                    zzaul.this.onServiceDisconnected(componentName);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        public void zzNb() {
            zzaul.this.zzmR();
            Context context = zzaul.this.getContext();
            zza zza2 = this;
            synchronized (zza2) {
                if (this.zzbvO) {
                    zzaul.this.zzKl().zzMe().log("Connection attempt already in progress");
                    return;
                }
                if (this.zzbvP != null) {
                    zzaul.this.zzKl().zzMe().log("Already awaiting connection attempt");
                    return;
                }
                this.zzbvP = new zzatw(context, Looper.getMainLooper(), this, this);
                zzaul.this.zzKl().zzMe().log("Connecting to remote service");
                this.zzbvO = true;
                this.zzbvP.zzxz();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onConnected(@Nullable Bundle bundle) {
            zzac.zzdj((String)"MeasurementServiceConnection.onConnected");
            zza zza2 = this;
            synchronized (zza2) {
                try {
                    final zzatt zzatt2 = (zzatt)this.zzbvP.zzxD();
                    this.zzbvP = null;
                    zzaul.this.zzKk().zzm(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            zza zza2 = zza.this;
                            synchronized (zza2) {
                                zza.this.zzbvO = false;
                                if (!zzaul.this.isConnected()) {
                                    zzaul.this.zzKl().zzMd().log("Connected to remote service");
                                    zzaul.this.zza(zzatt2);
                                }
                            }
                        }
                    });
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    this.zzbvP = null;
                    this.zzbvO = false;
                }
            }
        }

        @MainThread
        public void onConnectionSuspended(int n) {
            zzac.zzdj((String)"MeasurementServiceConnection.onConnectionSuspended");
            zzaul.this.zzKl().zzMd().log("Service connection suspended");
            zzaul.this.zzKk().zzm(new Runnable(){

                @Override
                public void run() {
                    zzaul zzaul2 = zzaul.this;
                    Context context = zzaul.this.getContext();
                    zzaul.this.zzKn().zzLg();
                    zzaul2.onServiceDisconnected(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementService"));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzac.zzdj((String)"MeasurementServiceConnection.onConnectionFailed");
            zzatx zzatx2 = zzaul.this.zzbqc.zzMu();
            if (zzatx2 != null) {
                zzatx2.zzMa().zzj("Service connection failed", connectionResult);
            }
            zza zza2 = this;
            synchronized (zza2) {
                this.zzbvO = false;
                this.zzbvP = null;
            }
        }
    }
}

