/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Bundle;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzaug;
import com.google.android.gms.internal.zzauk;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;

public class zzatb
extends zzaug {
    private final Map<String, Long> zzbqk;
    private final Map<String, Integer> zzbql = new ArrayMap();
    private long zzbqm;

    public zzatb(zzaue zzaue2) {
        super(zzaue2);
        this.zzbqk = new ArrayMap();
    }

    public void beginAdUnitExposure(final String string) {
        if (string == null || string.length() == 0) {
            this.zzKl().zzLZ().log("Ad unit id must be a non-empty string");
            return;
        }
        final long l = this.zznR().elapsedRealtime();
        this.zzKk().zzm(new Runnable(){

            @Override
            public void run() {
                zzatb.this.zzf(string, l);
            }
        });
    }

    @WorkerThread
    private void zzf(String string, long l) {
        Integer n;
        this.zzJW();
        this.zzmR();
        zzac.zzdr((String)string);
        if (this.zzbql.isEmpty()) {
            this.zzbqm = l;
        }
        if ((n = this.zzbql.get(string)) != null) {
            this.zzbql.put(string, n + 1);
        } else {
            if (this.zzbql.size() >= 100) {
                this.zzKl().zzMb().log("Too many ads visible");
                return;
            }
            this.zzbql.put(string, 1);
            this.zzbqk.put(string, l);
        }
    }

    public void endAdUnitExposure(final String string) {
        if (string == null || string.length() == 0) {
            this.zzKl().zzLZ().log("Ad unit id must be a non-empty string");
            return;
        }
        final long l = this.zznR().elapsedRealtime();
        this.zzKk().zzm(new Runnable(){

            @Override
            public void run() {
                zzatb.this.zzg(string, l);
            }
        });
    }

    @WorkerThread
    private void zzg(String string, long l) {
        this.zzJW();
        this.zzmR();
        zzac.zzdr((String)string);
        Integer n = this.zzbql.get(string);
        if (n != null) {
            zzauk.zza zza2 = this.zzKe().zzMW();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zzbql.remove(string);
                Long l2 = this.zzbqk.get(string);
                if (l2 == null) {
                    this.zzKl().zzLZ().log("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zzbqk.remove(string);
                    this.zza(string, l3, zza2);
                }
                if (this.zzbql.isEmpty()) {
                    if (this.zzbqm == 0L) {
                        this.zzKl().zzLZ().log("First ad exposure time was never set");
                    } else {
                        this.zza(l - this.zzbqm, zza2);
                        this.zzbqm = 0L;
                    }
                }
            } else {
                this.zzbql.put(string, n2);
            }
        } else {
            this.zzKl().zzLZ().zzj("Call to endAdUnitExposure for unknown ad unit id", string);
        }
    }

    @WorkerThread
    private void zza(long l, AppMeasurement.zzf zzf2) {
        if (zzf2 == null) {
            this.zzKl().zzMf().log("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzKl().zzMf().zzj("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzauk.zza(zzf2, bundle);
        this.zzKa().zze("am", "_xa", bundle);
    }

    @WorkerThread
    private void zza(String string, long l, AppMeasurement.zzf zzf2) {
        if (zzf2 == null) {
            this.zzKl().zzMf().log("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzKl().zzMf().zzj("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzauk.zza(zzf2, bundle);
        this.zzKa().zze("am", "_xu", bundle);
    }

    @WorkerThread
    public void zzW(long l) {
        zzauk.zza zza2 = this.zzKe().zzMW();
        for (String string : this.zzbqk.keySet()) {
            long l2 = this.zzbqk.get(string);
            this.zza(string, l - l2, zza2);
        }
        if (!this.zzbqk.isEmpty()) {
            this.zza(l - this.zzbqm, zza2);
        }
        this.zzX(l);
    }

    public void zzJU() {
        final long l = this.zznR().elapsedRealtime();
        this.zzKk().zzm(new Runnable(){

            @Override
            public void run() {
                zzatb.this.zzX(l);
            }
        });
    }

    @WorkerThread
    private void zzX(long l) {
        for (String string : this.zzbqk.keySet()) {
            this.zzbqk.put(string, l);
        }
        if (!this.zzbqk.isEmpty()) {
            this.zzbqm = l;
        }
    }
}

