/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.sqlite.SQLiteException;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.internal.zzadg;
import com.google.android.gms.internal.zzatb;
import com.google.android.gms.internal.zzatc;
import com.google.android.gms.internal.zzatd;
import com.google.android.gms.internal.zzatf;
import com.google.android.gms.internal.zzatg;
import com.google.android.gms.internal.zzati;
import com.google.android.gms.internal.zzatj;
import com.google.android.gms.internal.zzatl;
import com.google.android.gms.internal.zzatm;
import com.google.android.gms.internal.zzatn;
import com.google.android.gms.internal.zzato;
import com.google.android.gms.internal.zzatq;
import com.google.android.gms.internal.zzatu;
import com.google.android.gms.internal.zzatv;
import com.google.android.gms.internal.zzatx;
import com.google.android.gms.internal.zzaty;
import com.google.android.gms.internal.zzatz;
import com.google.android.gms.internal.zzaua;
import com.google.android.gms.internal.zzaub;
import com.google.android.gms.internal.zzauc;
import com.google.android.gms.internal.zzaud;
import com.google.android.gms.internal.zzaug;
import com.google.android.gms.internal.zzauh;
import com.google.android.gms.internal.zzaui;
import com.google.android.gms.internal.zzauj;
import com.google.android.gms.internal.zzauk;
import com.google.android.gms.internal.zzaul;
import com.google.android.gms.internal.zzaum;
import com.google.android.gms.internal.zzaun;
import com.google.android.gms.internal.zzaup;
import com.google.android.gms.internal.zzauq;
import com.google.android.gms.internal.zzaus;
import com.google.android.gms.internal.zzaut;
import com.google.android.gms.internal.zzauv;
import com.google.android.gms.internal.zzauw;
import com.google.android.gms.internal.zzbyc;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzaue {
    private static volatile zzaue zzbub;
    private final Context mContext;
    private final zzati zzbuc;
    private final zzaua zzbud;
    private final zzatx zzbue;
    private final zzaud zzbuf;
    private final zzaun zzbug;
    private final zzauc zzbuh;
    private final AppMeasurement zzbui;
    private final FirebaseAnalytics zzbuj;
    private final zzaut zzbuk;
    private final zzatj zzbul;
    private final zzatv zzbum;
    private final zzaty zzbun;
    private final zze zzuP;
    private final zzauk zzbuo;
    private final zzaul zzbup;
    private final zzatl zzbuq;
    private final zzauj zzbur;
    private final zzatu zzbus;
    private final zzatz zzbut;
    private final zzaup zzbuu;
    private final zzatf zzbuv;
    private final zzatb zzbuw;
    private final boolean zzadP;
    private boolean zzbux;
    private Boolean zzbuy;
    private long zzbuz;
    private FileLock zzbuA;
    private FileChannel zzbuB;
    private List<Long> zzbuC;
    private int zzbuD;
    private int zzbuE;
    private long zzbuF;
    protected long zzbuG;
    private final long zzbuH;

    zzaue(zzaui zzaui2) {
        zzatb zzatb2;
        zzac.zzw((Object)zzaui2);
        this.mContext = zzaui2.mContext;
        this.zzbuF = -1L;
        this.zzuP = zzaui2.zzn(this);
        this.zzbuH = this.zzuP.currentTimeMillis();
        this.zzbuc = zzaui2.zza(this);
        zzaua zzaua2 = zzaui2.zzb(this);
        zzaua2.initialize();
        this.zzbud = zzaua2;
        zzatx zzatx2 = zzaui2.zzc(this);
        zzatx2.initialize();
        this.zzbue = zzatx2;
        this.zzKl().zzMd().zzj("App measurement is starting up, version", this.zzKn().zzKv());
        this.zzKn().zzLh();
        this.zzKl().zzMd().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzaut zzaut2 = zzaui2.zzj(this);
        zzaut2.initialize();
        this.zzbuk = zzaut2;
        zzatl zzatl2 = zzaui2.zzq(this);
        zzatl2.initialize();
        this.zzbuq = zzatl2;
        zzatu zzatu2 = zzaui2.zzr(this);
        zzatu2.initialize();
        this.zzbus = zzatu2;
        this.zzKn().zzLh();
        Object object = zzatu2.zzke();
        if (this.zzKh().zzge((String)object)) {
            this.zzKl().zzMd().log("Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.");
        } else {
            String string = String.valueOf(object);
            this.zzKl().zzMd().log(string.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app "));
        }
        this.zzKl().zzMe().log("Debug-level message logging enabled");
        object = zzaui2.zzk(this);
        ((zzauh)object).initialize();
        this.zzbul = object;
        zzatv zzatv2 = zzaui2.zzl(this);
        zzatv2.initialize();
        this.zzbum = zzatv2;
        zzatf zzatf2 = zzaui2.zzu(this);
        zzatf2.initialize();
        this.zzbuv = zzatf2;
        this.zzbuw = zzatb2 = zzaui2.zzv(this);
        zzaty zzaty2 = zzaui2.zzm(this);
        zzaty2.initialize();
        this.zzbun = zzaty2;
        zzauk zzauk2 = zzaui2.zzo(this);
        zzauk2.initialize();
        this.zzbuo = zzauk2;
        zzaul zzaul2 = zzaui2.zzp(this);
        zzaul2.initialize();
        this.zzbup = zzaul2;
        zzauj zzauj2 = zzaui2.zzi(this);
        zzauj2.initialize();
        this.zzbur = zzauj2;
        zzaup zzaup2 = zzaui2.zzt(this);
        zzaup2.initialize();
        this.zzbuu = zzaup2;
        this.zzbut = zzaui2.zzs(this);
        this.zzbui = zzaui2.zzh(this);
        this.zzbuj = zzaui2.zzg(this);
        zzaun zzaun2 = zzaui2.zze(this);
        zzaun2.initialize();
        this.zzbug = zzaun2;
        zzauc zzauc2 = zzaui2.zzf(this);
        zzauc2.initialize();
        this.zzbuh = zzauc2;
        zzaud zzaud2 = zzaui2.zzd(this);
        zzaud2.initialize();
        this.zzbuf = zzaud2;
        if (this.zzbuD != this.zzbuE) {
            this.zzKl().zzLZ().zze("Not all components initialized", this.zzbuD, this.zzbuE);
        }
        this.zzadP = true;
        this.zzbuc.zzLh();
        if (this.mContext.getApplicationContext() instanceof Application) {
            this.zzKa().zzMS();
        } else {
            this.zzKl().zzMb().log("Application context is not an Application");
        }
        this.zzbuf.zzm(new Runnable(){

            @Override
            public void run() {
                zzaue.this.start();
            }
        });
    }

    void zzob() {
        if (!this.zzadP) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected boolean zzMu() {
        this.zzob();
        this.zzmR();
        if (this.zzbuy == null || this.zzbuz == 0L || this.zzbuy != null && !this.zzbuy.booleanValue() && Math.abs(this.zznR().elapsedRealtime() - this.zzbuz) > 1000L) {
            this.zzbuz = this.zznR().elapsedRealtime();
            this.zzKn().zzLh();
            this.zzbuy = this.zzKh().zzbW("android.permission.INTERNET") && this.zzKh().zzbW("android.permission.ACCESS_NETWORK_STATE") && (zzadg.zzbi((Context)this.getContext()).zzzx() || zzaub.zzi(this.getContext(), false) && zzaum.zzj(this.getContext(), false));
            if (this.zzbuy.booleanValue()) {
                this.zzbuy = this.zzKh().zzga(this.zzKb().getGmpAppId());
            }
        }
        return this.zzbuy;
    }

    @WorkerThread
    protected void start() {
        this.zzmR();
        this.zzKg().zzLG();
        if (this.zzKm().zzbtb.get() == 0L) {
            this.zzKm().zzbtb.set(this.zznR().currentTimeMillis());
        }
        if (!this.zzMu()) {
            if (this.isEnabled()) {
                if (!this.zzKh().zzbW("android.permission.INTERNET")) {
                    this.zzKl().zzLZ().log("App is missing INTERNET permission");
                }
                if (!this.zzKh().zzbW("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzKl().zzLZ().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                this.zzKn().zzLh();
                if (!zzadg.zzbi((Context)this.getContext()).zzzx()) {
                    if (!zzaub.zzi(this.getContext(), false)) {
                        this.zzKl().zzLZ().log("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzaum.zzj(this.getContext(), false)) {
                        this.zzKl().zzLZ().log("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzKl().zzLZ().log("Uploading is not possible. App measurement disabled");
            }
        } else {
            this.zzKn().zzLh();
            if (!TextUtils.isEmpty((CharSequence)this.zzKb().getGmpAppId())) {
                String string = this.zzKm().zzMl();
                if (string == null) {
                    this.zzKm().zzfI(this.zzKb().getGmpAppId());
                } else if (!string.equals(this.zzKb().getGmpAppId())) {
                    this.zzKl().zzMd().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzKm().zzMo();
                    this.zzbup.disconnect();
                    this.zzbup.zzoD();
                    this.zzKm().zzfI(this.zzKb().getGmpAppId());
                }
            }
            this.zzKn().zzLh();
            if (!TextUtils.isEmpty((CharSequence)this.zzKb().getGmpAppId())) {
                this.zzKa().zzMT();
            }
        }
        this.zzMK();
    }

    public zzati zzKn() {
        return this.zzbuc;
    }

    public zzaua zzKm() {
        this.zza((zzaug)this.zzbud);
        return this.zzbud;
    }

    public zzatx zzKl() {
        this.zza(this.zzbue);
        return this.zzbue;
    }

    public zzatx zzMv() {
        return this.zzbue != null && this.zzbue.isInitialized() ? this.zzbue : null;
    }

    public zzaud zzKk() {
        this.zza(this.zzbuf);
        return this.zzbuf;
    }

    public zzaun zzKj() {
        this.zza(this.zzbug);
        return this.zzbug;
    }

    public zzauc zzKi() {
        this.zza(this.zzbuh);
        return this.zzbuh;
    }

    zzaud zzMw() {
        return this.zzbuf;
    }

    public zzauj zzKa() {
        this.zza(this.zzbur);
        return this.zzbur;
    }

    public AppMeasurement zzMx() {
        return this.zzbui;
    }

    public FirebaseAnalytics zzMy() {
        return this.zzbuj;
    }

    public zzaut zzKh() {
        this.zza((zzaug)this.zzbuk);
        return this.zzbuk;
    }

    public zzatj zzKg() {
        this.zza(this.zzbul);
        return this.zzbul;
    }

    public zzatv zzKf() {
        this.zza(this.zzbum);
        return this.zzbum;
    }

    public zzaty zzMz() {
        this.zza(this.zzbun);
        return this.zzbun;
    }

    public Context getContext() {
        return this.mContext;
    }

    public zze zznR() {
        return this.zzuP;
    }

    public zzauk zzKe() {
        this.zza(this.zzbuo);
        return this.zzbuo;
    }

    public zzaul zzKd() {
        this.zza(this.zzbup);
        return this.zzbup;
    }

    public zzatl zzKc() {
        this.zza(this.zzbuq);
        return this.zzbuq;
    }

    public zzatu zzKb() {
        this.zza(this.zzbus);
        return this.zzbus;
    }

    public zzatz zzMA() {
        if (this.zzbut == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzbut;
    }

    public zzaup zzMB() {
        this.zza(this.zzbuu);
        return this.zzbuu;
    }

    public zzatf zzJZ() {
        this.zza(this.zzbuv);
        return this.zzbuv;
    }

    public zzatb zzJY() {
        this.zza(this.zzbuw);
        return this.zzbuw;
    }

    @WorkerThread
    public void zzmR() {
        this.zzKk().zzmR();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzaue zzbM(Context context) {
        zzac.zzw((Object)context);
        zzac.zzw((Object)context.getApplicationContext());
        if (zzbub != null) return zzbub;
        Class<zzaue> clazz = zzaue.class;
        synchronized (zzaue.class) {
            if (zzbub != null) return zzbub;
            zzaui zzaui2 = new zzaui(context);
            zzbub = zzaui2.zzMR();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzbub;
        }
    }

    FileChannel zzMC() {
        return this.zzbuB;
    }

    private void zza(zzauh zzauh2) {
        if (zzauh2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzauh2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private void zza(zzaug zzaug2) {
        if (zzaug2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    void zzMD() {
        this.zzmR();
        this.zzob();
        if (this.zzMO() && this.zzME()) {
            int n = this.zza(this.zzMC());
            int n2 = this.zzKb().zzLX();
            this.zzy(n, n2);
        }
    }

    @WorkerThread
    boolean zzME() {
        this.zzmR();
        String string = this.zzbul.zzow();
        File file = this.getContext().getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzbuB = new RandomAccessFile(file2, "rw").getChannel();
            this.zzbuA = this.zzbuB.tryLock();
            if (this.zzbuA != null) {
                this.zzKl().zzMf().log("Storage concurrent access okay");
                return true;
            }
            this.zzKl().zzLZ().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzKl().zzLZ().zzj("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzKl().zzLZ().zzj("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    boolean zzy(int n, int n2) {
        this.zzmR();
        if (n > n2) {
            this.zzKl().zzLZ().zze("Panic: can't downgrade version. Previous, current version", n, n2);
            return false;
        }
        if (n < n2) {
            if (this.zza(n2, this.zzMC())) {
                this.zzKl().zzMf().zze("Storage version upgraded. Previous, current version", n, n2);
            } else {
                this.zzKl().zzLZ().zze("Storage version upgrade failed. Previous, current version", n, n2);
                return false;
            }
        }
        return true;
    }

    @WorkerThread
    int zza(FileChannel fileChannel) {
        this.zzmR();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzKl().zzLZ().log("Bad chanel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzKl().zzMb().zzj("Unexpected data length. Bytes read", n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzKl().zzLZ().zzj("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    boolean zza(int n, FileChannel fileChannel) {
        this.zzmR();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzKl().zzLZ().log("Bad chanel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzKl().zzLZ().zzj("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzKl().zzLZ().zzj("Failed to write to channel", iOException);
            return false;
        }
    }

    @WorkerThread
    public boolean isEnabled() {
        this.zzmR();
        this.zzob();
        if (this.zzKn().zzLi()) {
            return false;
        }
        Boolean bl = this.zzKn().zzLj();
        boolean bl2 = bl != null ? bl : !this.zzKn().zzwR();
        return this.zzKm().zzaK(bl2);
    }

    void zzd(zzatd zzatd2) {
        this.zzmR();
        this.zzob();
        zzac.zzdr((String)zzatd2.packageName);
        this.zzf(zzatd2);
    }

    long zzMF() {
        return this.zzbuH;
    }

    long zzMG() {
        long l = this.zznR().currentTimeMillis() + this.zzKm().zzMj();
        return l / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    zzatd zzfO(String string) {
        Object object;
        zzatc zzatc2 = this.zzKg().zzfu(string);
        if (zzatc2 == null || TextUtils.isEmpty((CharSequence)zzatc2.zzmZ())) {
            this.zzKl().zzMe().zzj("No app data available; dropping", string);
            return null;
        }
        try {
            object = zzadg.zzbi((Context)this.getContext()).getPackageInfo((String)string, (int)0).versionName;
            if (zzatc2.zzmZ() != null && !zzatc2.zzmZ().equals(object)) {
                this.zzKl().zzMb().zzj("App version does not match; dropping. appId", zzatx.zzfE(string));
                return null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        object = new zzatd(string, zzatc2.getGmpAppId(), zzatc2.zzmZ(), zzatc2.zzKt(), zzatc2.zzKu(), zzatc2.zzKv(), zzatc2.zzKw(), null, zzatc2.zzKx(), false, zzatc2.zzKq(), zzatc2.zzuW(), 0L, 0);
        return object;
    }

    @WorkerThread
    void zzb(zzatq zzatq2, String string) {
        Object object;
        zzatc zzatc2;
        block4: {
            zzatc2 = this.zzKg().zzfu(string);
            if (zzatc2 == null || TextUtils.isEmpty((CharSequence)zzatc2.zzmZ())) {
                this.zzKl().zzMe().zzj("No app data available; dropping event", string);
                return;
            }
            try {
                object = zzadg.zzbi((Context)this.getContext()).getPackageInfo((String)string, (int)0).versionName;
                if (zzatc2.zzmZ() != null && !zzatc2.zzmZ().equals(object)) {
                    this.zzKl().zzMb().zzj("App version does not match; dropping event. appId", zzatx.zzfE(string));
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if ("_ui".equals(zzatq2.name)) break block4;
                this.zzKl().zzMb().zzj("Could not find package. appId", zzatx.zzfE(string));
            }
        }
        object = new zzatd(string, zzatc2.getGmpAppId(), zzatc2.zzmZ(), zzatc2.zzKt(), zzatc2.zzKu(), zzatc2.zzKv(), zzatc2.zzKw(), null, zzatc2.zzKx(), false, zzatc2.zzKq(), zzatc2.zzuW(), 0L, 0);
        this.zzb(zzatq2, (zzatd)((Object)object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(zzatq zzatq2, zzatd zzatd2) {
        zzac.zzw((Object)((Object)zzatd2));
        zzac.zzdr((String)zzatd2.packageName);
        this.zzmR();
        this.zzob();
        String string = zzatd2.packageName;
        long l = zzatq2.zzbrI;
        if (!this.zzKh().zzd(zzatq2, zzatd2)) {
            return;
        }
        if (!zzatd2.zzbqP) {
            this.zzf(zzatd2);
            return;
        }
        this.zzKg().beginTransaction();
        try {
            Object object;
            Object object22;
            List<zzatg> list = this.zzKg().zzh(string, l);
            for (Object object22 : list) {
                if (object22 == null) continue;
                this.zzKl().zzMe().zzd("User property timed out", object22.packageName, object22.zzbqX.name, object22.zzbqX.getValue());
                if (object22.zzbrb != null) {
                    this.zzc(new zzatq(object22.zzbrb, l), zzatd2);
                }
                this.zzKg().zzU(string, object22.zzbqX.name);
            }
            List<zzatg> list2 = this.zzKg().zzi(string, l);
            object22 = new ArrayList(list2.size());
            Object object3 = list2.iterator();
            while (object3.hasNext()) {
                object = (zzatg)((Object)object3.next());
                if (object == null) continue;
                this.zzKl().zzMe().zzd("User property expired", object.packageName, object.zzbqX.name, object.zzbqX.getValue());
                this.zzKg().zzR(string, object.zzbqX.name);
                if (object.zzbrf != null) {
                    object22.add(object.zzbrf);
                }
                this.zzKg().zzU(string, object.zzbqX.name);
            }
            object3 = object22.iterator();
            while (object3.hasNext()) {
                object = (zzatq)((Object)object3.next());
                this.zzc(new zzatq((zzatq)((Object)object), l), zzatd2);
            }
            object3 = this.zzKg().zzc(string, zzatq2.name, l);
            object = new ArrayList(object3.size());
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                com.google.android.gms.common.internal.safeparcel.zza zza2 = (zzatg)((Object)iterator.next());
                if (zza2 == null) continue;
                zzauq zzauq2 = zza2.zzbqX;
                zzaus zzaus2 = new zzaus(zza2.packageName, zza2.zzbqW, zzauq2.name, l, zzauq2.getValue());
                boolean bl = this.zzKg().zza(zzaus2);
                if (bl) {
                    this.zzKl().zzMe().zzd("User property triggered", zza2.packageName, zzaus2.mName, zzaus2.mValue);
                } else {
                    this.zzKl().zzLZ().zzd("Too many active user properties, ignoring", zzatx.zzfE(zza2.packageName), zzaus2.mName, zzaus2.mValue);
                }
                if (zza2.zzbrd != null) {
                    object.add(zza2.zzbrd);
                }
                zza2.zzbqX = new zzauq(zzaus2);
                zza2.zzbqZ = true;
                this.zzKg().zza((zzatg)zza2);
            }
            this.zzc(zzatq2, zzatd2);
            for (com.google.android.gms.common.internal.safeparcel.zza zza2 : object) {
                this.zzc(new zzatq((zzatq)zza2, l), zzatd2);
            }
            this.zzKg().setTransactionSuccessful();
        }
        finally {
            this.zzKg().endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzc(zzatq zzatq2, zzatd zzatd2) {
        zzac.zzw((Object)((Object)zzatd2));
        zzac.zzdr((String)zzatd2.packageName);
        long l = System.nanoTime();
        this.zzmR();
        this.zzob();
        String string = zzatd2.packageName;
        if (!this.zzKh().zzd(zzatq2, zzatd2)) {
            return;
        }
        if (!zzatd2.zzbqP) {
            this.zzf(zzatd2);
            return;
        }
        if (this.zzKi().zzaa(string, zzatq2.name)) {
            zzatc zzatc2;
            boolean bl;
            this.zzKl().zzMb().zze("Dropping blacklisted event. appId", zzatx.zzfE(string), zzatq2.name);
            boolean bl2 = bl = this.zzKh().zzgg(string) || this.zzKh().zzgh(string);
            if (!bl && !"_err".equals(zzatq2.name)) {
                this.zzKh().zza(11, "_ev", zzatq2.name, 0);
            }
            if (bl && (zzatc2 = this.zzKg().zzfu(string)) != null) {
                long l2 = Math.max(zzatc2.zzKA(), zzatc2.zzKz());
                long l3 = this.zznR().currentTimeMillis();
                if (Math.abs(l3 - l2) > this.zzKn().zzLm()) {
                    this.zzKl().zzMe().log("Fetching config for blacklisted app");
                    this.zzb(zzatc2);
                }
            }
            return;
        }
        if (this.zzKl().zzak(2)) {
            this.zzKl().zzMf().zzj("Logging event", (Object)zzatq2);
        }
        this.zzKg().beginTransaction();
        try {
            zzatn zzatn2;
            long l4;
            Bundle bundle = zzatq2.zzbrH.zzLW();
            this.zzf(zzatd2);
            if ("_iap".equals(zzatq2.name) || "ecommerce_purchase".equals(zzatq2.name)) {
                long l5;
                String string2 = bundle.getString("currency");
                if ("ecommerce_purchase".equals(zzatq2.name)) {
                    double d = bundle.getDouble("value") * 1000000.0;
                    if (d == 0.0) {
                        d = (double)bundle.getLong("value") * 1000000.0;
                    }
                    if (!(d <= 9.223372036854776E18) || !(d >= -9.223372036854776E18)) {
                        this.zzKl().zzMb().zze("Data lost. Currency value is too big. appId", zzatx.zzfE(string), d);
                        this.zzKg().setTransactionSuccessful();
                        return;
                    }
                    l5 = Math.round(d);
                } else {
                    l5 = bundle.getLong("value");
                }
                if (!TextUtils.isEmpty((CharSequence)string2) && (string2 = string2.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                    String string3 = String.valueOf("_ltv_");
                    String string4 = String.valueOf(string2);
                    String string5 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
                    zzaus zzaus2 = this.zzKg().zzS(string, string5);
                    if (zzaus2 == null || !(zzaus2.mValue instanceof Long)) {
                        this.zzKg().zzz(string, this.zzKn().zzfn(string) - 1);
                        zzaus2 = new zzaus(string, zzatq2.zzbqW, string5, this.zznR().currentTimeMillis(), l5);
                    } else {
                        l4 = (Long)zzaus2.mValue;
                        zzaus2 = new zzaus(string, zzatq2.zzbqW, string5, this.zznR().currentTimeMillis(), l4 + l5);
                    }
                    if (!this.zzKg().zza(zzaus2)) {
                        this.zzKl().zzLZ().zzd("Too many unique user properties are set. Ignoring user property. appId", zzatx.zzfE(string), zzaus2.mName, zzaus2.mValue);
                        this.zzKh().zza(9, null, null, 0);
                    }
                }
            }
            boolean bl = zzaut.zzfT(zzatq2.name);
            boolean bl3 = "_err".equals(zzatq2.name);
            zzatj.zza zza2 = this.zzKg().zza(this.zzMG(), string, true, bl, false, bl3, false);
            long l6 = zza2.zzbrp - this.zzKn().zzKV();
            if (l6 > 0L) {
                if (l6 % 1000L == 1L) {
                    this.zzKl().zzLZ().zze("Data loss. Too many events logged. appId, count", zzatx.zzfE(string), zza2.zzbrp);
                }
                this.zzKh().zza(16, "_ev", zzatq2.name, 0);
                this.zzKg().setTransactionSuccessful();
                return;
            }
            if (bl && (l6 = zza2.zzbro - this.zzKn().zzKW()) > 0L) {
                if (l6 % 1000L == 1L) {
                    this.zzKl().zzLZ().zze("Data loss. Too many public events logged. appId, count", zzatx.zzfE(string), zza2.zzbro);
                }
                this.zzKh().zza(16, "_ev", zzatq2.name, 0);
                this.zzKg().setTransactionSuccessful();
                return;
            }
            if (bl3 && (l6 = zza2.zzbrr - (long)this.zzKn().zzfj(zzatd2.packageName)) > 0L) {
                if (l6 == 1L) {
                    this.zzKl().zzLZ().zze("Too many error events logged. appId, count", zzatx.zzfE(string), zza2.zzbrr);
                }
                this.zzKg().setTransactionSuccessful();
                return;
            }
            this.zzKh().zza(bundle, "_o", zzatq2.zzbqW);
            if (this.zzKh().zzge(string)) {
                this.zzKh().zza(bundle, "_dbg", 1L);
                this.zzKh().zza(bundle, "_r", 1L);
            }
            if ((l4 = this.zzKg().zzfv(string)) > 0L) {
                this.zzKl().zzMb().zze("Data lost. Too many events stored on disk, deleted. appId", zzatx.zzfE(string), l4);
            }
            zzatm zzatm2 = new zzatm(this, zzatq2.zzbqW, string, zzatq2.name, zzatq2.zzbrI, 0L, bundle);
            zzatn zzatn3 = this.zzKg().zzQ(string, zzatm2.mName);
            if (zzatn3 == null) {
                long l7 = this.zzKg().zzfC(string);
                this.zzKn().zzKU();
                if (l7 >= 500L) {
                    this.zzKl().zzLZ().zzd("Too many event names used, ignoring event. appId, name, supported count", zzatx.zzfE(string), zzatm2.mName, this.zzKn().zzKU());
                    this.zzKh().zza(8, null, null, 0);
                    return;
                }
                zzatn2 = new zzatn(string, zzatm2.mName, 0L, 0L, zzatm2.zzaxb);
            } else {
                zzatm2 = zzatm2.zza(this, zzatn3.zzbrD);
                zzatn2 = zzatn3.zzap(zzatm2.zzaxb);
            }
            this.zzKg().zza(zzatn2);
            this.zza(zzatm2, zzatd2);
            this.zzKg().setTransactionSuccessful();
            if (this.zzKl().zzak(2)) {
                this.zzKl().zzMf().zzj("Event recorded", zzatm2);
            }
        }
        finally {
            this.zzKg().endTransaction();
        }
        this.zzMK();
        this.zzKl().zzMf().zzj("Background event processing time, ms", (System.nanoTime() - l + 500000L) / 1000000L);
    }

    @WorkerThread
    void zzd(zzatg zzatg2) {
        zzatd zzatd2 = this.zzfO(zzatg2.packageName);
        if (zzatd2 != null) {
            this.zzb(zzatg2, zzatd2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(zzatg zzatg2, zzatd zzatd2) {
        zzac.zzw((Object)((Object)zzatg2));
        zzac.zzdr((String)zzatg2.packageName);
        zzac.zzw((Object)zzatg2.zzbqW);
        zzac.zzw((Object)((Object)zzatg2.zzbqX));
        zzac.zzdr((String)zzatg2.zzbqX.name);
        this.zzmR();
        this.zzob();
        if (TextUtils.isEmpty((CharSequence)zzatd2.zzbqK)) {
            return;
        }
        if (!zzatd2.zzbqP) {
            this.zzf(zzatd2);
            return;
        }
        zzatg zzatg3 = new zzatg(zzatg2);
        this.zzKg().beginTransaction();
        try {
            boolean bl;
            zzauq zzauq2;
            boolean bl2 = false;
            zzatg zzatg4 = this.zzKg().zzT(zzatg3.packageName, zzatg3.zzbqX.name);
            if (zzatg4 != null && zzatg4.zzbqZ) {
                zzatg3.zzbqW = zzatg4.zzbqW;
                zzatg3.zzbqY = zzatg4.zzbqY;
                zzatg3.zzbra = zzatg4.zzbra;
                zzatg3.zzbrd = zzatg4.zzbrd;
            } else if (TextUtils.isEmpty((CharSequence)zzatg3.zzbra)) {
                zzauq2 = zzatg3.zzbqX;
                zzatg3.zzbqX = new zzauq(zzauq2.name, zzatg3.zzbqY, zzauq2.getValue(), zzauq2.zzbqW);
                zzatg3.zzbqZ = true;
                bl2 = true;
            }
            if (zzatg3.zzbqZ) {
                zzauq2 = zzatg3.zzbqX;
                zzaus zzaus2 = new zzaus(zzatg3.packageName, zzatg3.zzbqW, zzauq2.name, zzauq2.zzbwf, zzauq2.getValue());
                boolean bl3 = this.zzKg().zza(zzaus2);
                if (bl3) {
                    this.zzKl().zzMe().zzd("User property updated immediately", zzatg3.packageName, zzaus2.mName, zzaus2.mValue);
                } else {
                    this.zzKl().zzLZ().zzd("(2)Too many active user properties, ignoring", zzatx.zzfE(zzatg3.packageName), zzaus2.mName, zzaus2.mValue);
                }
                if (bl2 && zzatg3.zzbrd != null) {
                    zzatq zzatq2 = new zzatq(zzatg3.zzbrd, zzatg3.zzbqY);
                    this.zzc(zzatq2, zzatd2);
                }
            }
            if (bl = this.zzKg().zza(zzatg3)) {
                this.zzKl().zzMe().zzd("Conditional property added", zzatg3.packageName, zzatg3.zzbqX.name, zzatg3.zzbqX.getValue());
            } else {
                this.zzKl().zzLZ().zzd("Too many conditional properties, ignoring", zzatx.zzfE(zzatg3.packageName), zzatg3.zzbqX.name, zzatg3.zzbqX.getValue());
            }
            this.zzKg().setTransactionSuccessful();
        }
        finally {
            this.zzKg().endTransaction();
        }
    }

    @WorkerThread
    void zze(zzatg zzatg2) {
        zzatd zzatd2 = this.zzfO(zzatg2.packageName);
        if (zzatd2 != null) {
            this.zzc(zzatg2, zzatd2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzc(zzatg zzatg2, zzatd zzatd2) {
        zzac.zzw((Object)((Object)zzatg2));
        zzac.zzdr((String)zzatg2.packageName);
        zzac.zzw((Object)((Object)zzatg2.zzbqX));
        zzac.zzdr((String)zzatg2.zzbqX.name);
        this.zzmR();
        this.zzob();
        if (TextUtils.isEmpty((CharSequence)zzatd2.zzbqK)) {
            return;
        }
        if (!zzatd2.zzbqP) {
            this.zzf(zzatd2);
            return;
        }
        this.zzKg().beginTransaction();
        try {
            this.zzf(zzatd2);
            zzatg zzatg3 = this.zzKg().zzT(zzatg2.packageName, zzatg2.zzbqX.name);
            if (zzatg3 != null) {
                this.zzKl().zzMe().zze("Removing conditional user property", zzatg2.packageName, zzatg2.zzbqX.name);
                this.zzKg().zzU(zzatg2.packageName, zzatg2.zzbqX.name);
                if (zzatg3.zzbqZ) {
                    this.zzKg().zzR(zzatg2.packageName, zzatg2.zzbqX.name);
                }
                if (zzatg2.zzbrf != null) {
                    Bundle bundle = null;
                    if (zzatg2.zzbrf.zzbrH != null) {
                        bundle = zzatg2.zzbrf.zzbrH.zzLW();
                    }
                    zzatq zzatq2 = this.zzKh().zza(zzatg2.zzbrf.name, bundle, zzatg3.zzbqW, zzatg2.zzbrf.zzbrI, true, false);
                    this.zzc(zzatq2, zzatd2);
                }
            } else {
                this.zzKl().zzMb().zze("Conditional user property doesn't exist", zzatx.zzfE(zzatg2.packageName), zzatg2.zzbqX.name);
            }
            this.zzKg().setTransactionSuccessful();
        }
        finally {
            this.zzKg().endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public byte[] zza(@NonNull zzatq zzatq2, @Size(min=1L) String string) {
        Object object;
        zzbyc zzbyc2;
        Object object2;
        this.zzob();
        this.zzmR();
        this.zzJV();
        zzac.zzw((Object)((Object)zzatq2));
        zzac.zzdr((String)string);
        zzauw.zzd zzd2 = new zzauw.zzd();
        this.zzKg().beginTransaction();
        try {
            zzatn zzatn2;
            long l;
            Object object3;
            zzatc zzatc2 = this.zzKg().zzfu(string);
            if (zzatc2 == null) {
                this.zzKl().zzMe().zzj("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzatc2.zzKx()) {
                this.zzKl().zzMe().zzj("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            object2 = new zzauw.zze();
            zzd2.zzbxg = new zzauw.zze[]{object2};
            object2.zzbxi = 1;
            object2.zzbxq = "android";
            object2.zzaS = zzatc2.zzke();
            object2.zzbqL = zzatc2.zzKu();
            object2.zzbhN = zzatc2.zzmZ();
            object2.zzbxD = (int)zzatc2.zzKt();
            object2.zzbxu = zzatc2.zzKv();
            object2.zzbqK = zzatc2.getGmpAppId();
            object2.zzbxz = zzatc2.zzKw();
            zzbyc2 = this.zzKm().zzfG(zzatc2.zzke());
            if (!TextUtils.isEmpty((CharSequence)((CharSequence)zzbyc2.first))) {
                object2.zzbxw = (String)zzbyc2.first;
                object2.zzbxx = (Boolean)zzbyc2.second;
            }
            object2.zzbxr = this.zzKc().zzkN();
            object2.zzbb = this.zzKc().zzLS();
            object2.zzbxt = (int)this.zzKc().zzLT();
            object2.zzbxs = this.zzKc().zzLU();
            object2.zzbxy = zzatc2.getAppInstanceId();
            object2.zzbqS = zzatc2.zzKq();
            object = this.zzKg().zzft(zzatc2.zzke());
            object2.zzbxk = new zzauw.zzg[object.size()];
            for (int i = 0; i < object.size(); ++i) {
                object3 = new zzauw.zzg();
                object2.zzbxk[i] = object3;
                ((zzauw.zzg)((Object)object3)).name = object.get((int)i).mName;
                ((zzauw.zzg)((Object)object3)).zzbxM = object.get((int)i).zzbwj;
                this.zzKh().zza((zzauw.zzg)((Object)object3), object.get((int)i).mValue);
            }
            Bundle bundle = zzatq2.zzbrH.zzLW();
            if ("_iap".equals(zzatq2.name)) {
                bundle.putLong("_c", 1L);
                this.zzKl().zzMe().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzatq2.zzbqW);
            if (this.zzKh().zzge(object2.zzaS)) {
                this.zzKh().zza(bundle, "_dbg", 1L);
                this.zzKh().zza(bundle, "_r", 1L);
            }
            if ((object3 = this.zzKg().zzQ(string, zzatq2.name)) == null) {
                l = 0L;
                zzatn2 = new zzatn(string, zzatq2.name, 1L, 0L, zzatq2.zzbrI);
                this.zzKg().zza(zzatn2);
            } else {
                l = ((zzatn)object3).zzbrD;
                zzatn2 = ((zzatn)object3).zzap(zzatq2.zzbrI);
                zzatn2 = zzatn2.zzLV();
                this.zzKg().zza(zzatn2);
            }
            zzatm zzatm2 = new zzatm(this, zzatq2.zzbqW, string, zzatq2.name, zzatq2.zzbrI, l, bundle);
            zzauw.zzb zzb2 = new zzauw.zzb();
            object2.zzbxj = new zzauw.zzb[]{zzb2};
            zzb2.zzbxc = zzatm2.zzaxb;
            zzb2.name = zzatm2.mName;
            zzb2.zzbxd = zzatm2.zzbrz;
            zzb2.zzbxb = new zzauw.zzc[zzatm2.zzbrA.size()];
            int n = 0;
            for (String string2 : zzatm2.zzbrA) {
                zzauw.zzc zzc2 = new zzauw.zzc();
                zzb2.zzbxb[n++] = zzc2;
                zzc2.name = string2;
                Object object4 = zzatm2.zzbrA.get(string2);
                this.zzKh().zza(zzc2, object4);
            }
            object2.zzbxC = this.zza(zzatc2.zzke(), object2.zzbxk, object2.zzbxj);
            object2.zzbxm = zzb2.zzbxc;
            object2.zzbxn = zzb2.zzbxc;
            long l2 = zzatc2.zzKs();
            object2.zzbxp = l2 != 0L ? Long.valueOf(l2) : null;
            long l3 = zzatc2.zzKr();
            if (l3 == 0L) {
                l3 = l2;
            }
            object2.zzbxo = l3 != 0L ? Long.valueOf(l3) : null;
            zzatc2.zzKB();
            object2.zzbxA = (int)zzatc2.zzKy();
            object2.zzbxv = this.zzKn().zzKv();
            object2.zzbxl = this.zznR().currentTimeMillis();
            object2.zzbxB = Boolean.TRUE;
            zzatc2.zzY(object2.zzbxm);
            zzatc2.zzZ(object2.zzbxn);
            this.zzKg().zza(zzatc2);
            this.zzKg().setTransactionSuccessful();
        }
        finally {
            this.zzKg().endTransaction();
        }
        try {
            int n = zzd2.zzafB();
            object2 = new byte[n];
            zzbyc2 = zzbyc.zzah((byte[])object2);
            zzd2.zza(zzbyc2);
            zzbyc2.zzafo();
            object = this.zzKh().zzk((byte[])object2);
            return object;
        }
        catch (IOException iOException) {
            this.zzKl().zzLZ().zze("Data loss. Failed to bundle and serialize. appId", zzatx.zzfE(string), iOException);
            return null;
        }
    }

    void zza(zzatm zzatm2, zzatd zzatd2) {
        long l;
        Object object;
        this.zzmR();
        this.zzob();
        zzac.zzw((Object)zzatm2);
        zzac.zzw((Object)((Object)zzatd2));
        zzac.zzdr((String)zzatm2.mAppId);
        zzac.zzaw((boolean)zzatm2.mAppId.equals(zzatd2.packageName));
        zzauw.zze zze2 = new zzauw.zze();
        zze2.zzbxi = 1;
        zze2.zzbxq = "android";
        zze2.zzaS = zzatd2.packageName;
        zze2.zzbqL = zzatd2.zzbqL;
        zze2.zzbhN = zzatd2.zzbhN;
        zze2.zzbxD = (int)zzatd2.zzbqR;
        zze2.zzbxu = zzatd2.zzbqM;
        zze2.zzbqK = zzatd2.zzbqK;
        zze2.zzbxz = zzatd2.zzbqN == 0L ? null : Long.valueOf(zzatd2.zzbqN);
        Pair<String, Boolean> pair = this.zzKm().zzfG(zzatd2.packageName);
        if (!TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            zze2.zzbxw = (String)pair.first;
            zze2.zzbxx = (Boolean)pair.second;
        } else if (!this.zzKc().zzbL(this.mContext)) {
            object = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
            if (object == null) {
                this.zzKl().zzMb().zzj("null secure ID. appId", zzatx.zzfE(zze2.zzaS));
                object = "null";
            } else if (((String)object).isEmpty()) {
                this.zzKl().zzMb().zzj("empty secure ID. appId", zzatx.zzfE(zze2.zzaS));
            }
            zze2.zzbxG = object;
        }
        zze2.zzbxr = this.zzKc().zzkN();
        zze2.zzbb = this.zzKc().zzLS();
        zze2.zzbxt = (int)this.zzKc().zzLT();
        zze2.zzbxs = this.zzKc().zzLU();
        zze2.zzbxv = null;
        zze2.zzbxl = null;
        zze2.zzbxm = null;
        zze2.zzbxn = null;
        zze2.zzbxI = zzatd2.zzbqT;
        object = this.zzKg().zzfu(zzatd2.packageName);
        if (object == null) {
            object = new zzatc(this, zzatd2.packageName);
            ((zzatc)object).zzfd(this.zzKm().zzMi());
            ((zzatc)object).zzfg(zzatd2.zzbqS);
            ((zzatc)object).zzfe(zzatd2.zzbqK);
            ((zzatc)object).zzff(this.zzKm().zzfH(zzatd2.packageName));
            ((zzatc)object).zzad(0L);
            ((zzatc)object).zzY(0L);
            ((zzatc)object).zzZ(0L);
            ((zzatc)object).setAppVersion(zzatd2.zzbhN);
            ((zzatc)object).zzaa(zzatd2.zzbqR);
            ((zzatc)object).zzfh(zzatd2.zzbqL);
            ((zzatc)object).zzab(zzatd2.zzbqM);
            ((zzatc)object).zzac(zzatd2.zzbqN);
            ((zzatc)object).setMeasurementEnabled(zzatd2.zzbqP);
            ((zzatc)object).zzam(zzatd2.zzbqT);
            this.zzKg().zza((zzatc)object);
        }
        zze2.zzbxy = ((zzatc)object).getAppInstanceId();
        zze2.zzbqS = ((zzatc)object).zzKq();
        List<zzaus> list = this.zzKg().zzft(zzatd2.packageName);
        zze2.zzbxk = new zzauw.zzg[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            zzauw.zzg zzg2;
            zze2.zzbxk[i] = zzg2 = new zzauw.zzg();
            zzg2.name = list.get((int)i).mName;
            zzg2.zzbxM = list.get((int)i).zzbwj;
            this.zzKh().zza(zzg2, list.get((int)i).mValue);
        }
        try {
            l = this.zzKg().zza(zze2);
        }
        catch (IOException iOException) {
            this.zzKl().zzLZ().zze("Data loss. Failed to insert raw event metadata. appId", zzatx.zzfE(zze2.zzaS), iOException);
            return;
        }
        if (this.zzKg().zza(zzatm2, l, this.zza(zzatm2))) {
            this.zzbuG = 0L;
        }
    }

    public String zzfP(final String string) {
        Future<String> future = this.zzKk().zzd(new Callable<String>(){

            public String zzbY() throws Exception {
                zzatc zzatc2 = zzaue.this.zzKg().zzfu(string);
                if (zzatc2 == null) {
                    zzaue.this.zzKl().zzMb().log("App info was null when attempting to get app instance id");
                    return null;
                }
                return zzatc2.getAppInstanceId();
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzbY();
            }
        });
        try {
            return future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzKl().zzLZ().zze("Failed to get app instance id. appId", zzatx.zzfE(string), exception);
            return null;
        }
    }

    private boolean zza(zzatm zzatm2) {
        Object object2;
        if (zzatm2.zzbrA == null) {
            return false;
        }
        for (Object object2 : zzatm2.zzbrA) {
            if (!"_r".equals(object2)) continue;
            return true;
        }
        boolean bl = this.zzKi().zzab(zzatm2.mAppId, zzatm2.mName);
        object2 = this.zzKg().zza(this.zzMG(), zzatm2.mAppId, false, false, false, false, false);
        return bl && ((zzatj.zza)object2).zzbrs < (long)this.zzKn().zzfl(zzatm2.mAppId);
    }

    void zzJW() {
        this.zzKn().zzLh();
    }

    void zzJV() {
        this.zzKn().zzLh();
        throw new IllegalStateException("Unexpected call on client side");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(zzauq zzauq2, zzatd zzatd2) {
        this.zzmR();
        this.zzob();
        if (TextUtils.isEmpty((CharSequence)zzatd2.zzbqK)) {
            return;
        }
        if (!zzatd2.zzbqP) {
            this.zzf(zzatd2);
            return;
        }
        int n = this.zzKh().zzfX(zzauq2.name);
        if (n != 0) {
            String string = this.zzKh().zza(zzauq2.name, this.zzKn().zzKN(), true);
            int n2 = zzauq2.name != null ? zzauq2.name.length() : 0;
            this.zzKh().zza(n, "_ev", string, n2);
            return;
        }
        n = this.zzKh().zzl(zzauq2.name, zzauq2.getValue());
        if (n != 0) {
            String string = this.zzKh().zza(zzauq2.name, this.zzKn().zzKN(), true);
            Object object = zzauq2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                String string2 = String.valueOf(object);
                n3 = string2.length();
            }
            this.zzKh().zza(n, "_ev", string, n3);
            return;
        }
        Object object = this.zzKh().zzm(zzauq2.name, zzauq2.getValue());
        if (object == null) {
            return;
        }
        zzaus zzaus2 = new zzaus(zzatd2.packageName, zzauq2.zzbqW, zzauq2.name, zzauq2.zzbwf, object);
        this.zzKl().zzMe().zze("Setting user property", zzaus2.mName, object);
        this.zzKg().beginTransaction();
        try {
            this.zzf(zzatd2);
            boolean bl = this.zzKg().zza(zzaus2);
            this.zzKg().setTransactionSuccessful();
            if (bl) {
                this.zzKl().zzMe().zze("User property set", zzaus2.mName, zzaus2.mValue);
            } else {
                this.zzKl().zzLZ().zze("Too many unique user properties are set. Ignoring user property", zzaus2.mName, zzaus2.mValue);
                this.zzKh().zza(9, null, null, 0);
            }
        }
        finally {
            this.zzKg().endTransaction();
        }
    }

    @WorkerThread
    void zzc(zzauq zzauq2, zzatd zzatd2) {
        this.zzmR();
        this.zzob();
        if (TextUtils.isEmpty((CharSequence)zzatd2.zzbqK)) {
            return;
        }
        if (!zzatd2.zzbqP) {
            this.zzf(zzatd2);
            return;
        }
        this.zzKl().zzMe().zzj("Removing user property", zzauq2.name);
        this.zzKg().beginTransaction();
        try {
            this.zzf(zzatd2);
            this.zzKg().zzR(zzatd2.packageName, zzauq2.name);
            this.zzKg().setTransactionSuccessful();
            this.zzKl().zzMe().zzj("User property removed", zzauq2.name);
        }
        finally {
            this.zzKg().endTransaction();
        }
    }

    @WorkerThread
    protected boolean zzMH() {
        this.zzmR();
        return this.zzbuC != null;
    }

    protected void zzK(List<Long> list) {
        zzac.zzaw((!list.isEmpty() ? 1 : 0) != 0);
        if (this.zzbuC != null) {
            this.zzKl().zzLZ().log("Set uploading progress before finishing the previous upload");
        } else {
            this.zzbuC = new ArrayList<Long>(list);
        }
    }

    @WorkerThread
    public void zzMI() {
        String string;
        this.zzmR();
        this.zzob();
        this.zzKn().zzLh();
        Boolean bl = this.zzKm().zzMn();
        if (bl == null) {
            this.zzKl().zzMb().log("Upload data called on the client side before use of service was decided");
            return;
        }
        if (bl.booleanValue()) {
            this.zzKl().zzLZ().log("Upload called in the client side when service should be used");
            return;
        }
        if (this.zzbuG > 0L) {
            this.zzMK();
            return;
        }
        if (this.zzMH()) {
            this.zzKl().zzMb().log("Uploading requested multiple times");
            return;
        }
        if (!this.zzMz().zzqa()) {
            this.zzKl().zzMb().log("Network not connected, ignoring upload request");
            this.zzMK();
            return;
        }
        long l = this.zznR().currentTimeMillis();
        this.zzaq(l - this.zzKn().zzLs());
        long l2 = this.zzKm().zzbtb.get();
        if (l2 != 0L) {
            this.zzKl().zzMe().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l2));
        }
        if (!TextUtils.isEmpty((CharSequence)(string = this.zzKg().zzLE()))) {
            if (this.zzbuF == -1L) {
                this.zzbuF = this.zzKg().zzLM();
            }
            int n = this.zzKn().zzfq(string);
            int n2 = this.zzKn().zzfr(string);
            List<Pair<zzauw.zze, Long>> list = this.zzKg().zzn(string, n, n2);
            if (!list.isEmpty()) {
                String string2 = null;
                for (Pair<zzauw.zze, Long> object2 : list) {
                    zzauw.zze zze2 = (zzauw.zze)((Object)object2.first);
                    if (TextUtils.isEmpty((CharSequence)zze2.zzbxw)) continue;
                    string2 = zze2.zzbxw;
                    break;
                }
                if (string2 != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        zzauw.zze zze3 = (zzauw.zze)((Object)list.get((int)i).first);
                        if (TextUtils.isEmpty((CharSequence)zze3.zzbxw) || zze3.zzbxw.equals(string2)) continue;
                        list = list.subList(0, i);
                        break;
                    }
                }
                Object object3 = new zzauw.zzd();
                ((zzauw.zzd)((Object)object3)).zzbxg = new zzauw.zze[list.size()];
                ArrayList<Long> arrayList = new ArrayList<Long>(list.size());
                for (int i = 0; i < ((zzauw.zzd)((Object)object3)).zzbxg.length; ++i) {
                    ((zzauw.zzd)((Object)object3)).zzbxg[i] = (zzauw.zze)((Object)list.get((int)i).first);
                    arrayList.add((Long)list.get((int)i).second);
                    ((zzauw.zzd)((Object)object3)).zzbxg[i].zzbxv = this.zzKn().zzKv();
                    ((zzauw.zzd)((Object)object3)).zzbxg[i].zzbxl = l;
                    ((zzauw.zzd)((Object)object3)).zzbxg[i].zzbxB = this.zzKn().zzLh();
                }
                String string3 = null;
                if (this.zzKl().zzak(2)) {
                    string3 = zzaut.zzb(object3);
                }
                byte[] byArray = this.zzKh().zza((zzauw.zzd)((Object)object3));
                String string4 = this.zzKn().zzLr();
                try {
                    URL uRL = new URL(string4);
                    this.zzK(arrayList);
                    this.zzKm().zzbtc.set(l);
                    String string5 = "?";
                    if (((zzauw.zzd)((Object)object3)).zzbxg.length > 0) {
                        string5 = ((zzauw.zzd)((Object)object3)).zzbxg[0].zzaS;
                    }
                    this.zzKl().zzMf().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                    this.zzMz().zza(string, uRL, byArray, null, new zzaty.zza(){

                        @Override
                        public void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
                            zzaue.this.zza(n, throwable, byArray);
                        }
                    });
                }
                catch (MalformedURLException malformedURLException) {
                    this.zzKl().zzLZ().zze("Failed to parse upload URL. Not uploading. appId", zzatx.zzfE(string), string4);
                }
            }
        } else {
            zzatc zzatc2;
            this.zzbuF = -1L;
            String string6 = this.zzKg().zzao(l - this.zzKn().zzLs());
            if (!TextUtils.isEmpty((CharSequence)string6) && (zzatc2 = this.zzKg().zzfu(string6)) != null) {
                this.zzb(zzatc2);
            }
        }
    }

    void zzb(zzatc zzatc2) {
        if (TextUtils.isEmpty((CharSequence)zzatc2.getGmpAppId())) {
            this.zzb(zzatc2.zzke(), 204, null, null, null);
            return;
        }
        String string = this.zzKn().zzP(zzatc2.getGmpAppId(), zzatc2.getAppInstanceId());
        try {
            URL uRL = new URL(string);
            this.zzKl().zzMf().zzj("Fetching remote configuration", zzatc2.zzke());
            zzauv.zzb zzb2 = this.zzKi().zzfL(zzatc2.zzke());
            ArrayMap arrayMap = null;
            String string2 = this.zzKi().zzfM(zzatc2.zzke());
            if (zzb2 != null && !TextUtils.isEmpty((CharSequence)string2)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string2);
            }
            this.zzMz().zza(zzatc2.zzke(), uRL, (Map<String, String>)arrayMap, new zzaty.zza(){

                @Override
                public void zza(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
                    zzaue.this.zzb(string, n, throwable, byArray, map);
                }
            });
        }
        catch (MalformedURLException malformedURLException) {
            this.zzKl().zzLZ().zze("Failed to parse config URL. Not fetching. appId", zzatx.zzfE(zzatc2.zzke()), string);
        }
    }

    boolean zzaq(long l) {
        return this.zzl(null, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    private boolean zzl(String string, long l) {
        this.zzKg().beginTransaction();
        try {
            zza zza2 = new zza();
            this.zzKg().zza(string, l, this.zzbuF, zza2);
            if (!zza2.isEmpty()) {
                int n;
                boolean bl = false;
                zzauw.zze zze2 = zza2.zzbuJ;
                zze2.zzbxj = new zzauw.zzb[zza2.zzth.size()];
                int n2 = 0;
                for (n = 0; n < zza2.zzth.size(); ++n) {
                    boolean bl2;
                    boolean bl3 = bl;
                    if (this.zzKi().zzaa(zza2.zzbuJ.zzaS, zza2.zzth.get((int)n).name)) {
                        this.zzKl().zzMb().zze("Dropping blacklisted raw event. appId", zzatx.zzfE(zza2.zzbuJ.zzaS), zza2.zzth.get((int)n).name);
                        boolean bl4 = bl2 = this.zzKh().zzgg(zza2.zzbuJ.zzaS) || this.zzKh().zzgh(zza2.zzbuJ.zzaS);
                        if (bl2 || "_err".equals(zza2.zzth.get((int)n).name)) continue;
                        this.zzKh().zza(11, "_ev", zza2.zzth.get((int)n).name, 0);
                        continue;
                    }
                    bl2 = this.zzKi().zzab(zza2.zzbuJ.zzaS, zza2.zzth.get((int)n).name);
                    if (bl2 || this.zzKh().zzgi(zza2.zzth.get((int)n).name)) {
                        int n3;
                        Object object;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        if (zza2.zzth.get((int)n).zzbxb == null) {
                            zza2.zzth.get((int)n).zzbxb = new zzauw.zzc[0];
                        }
                        for (zzauw.zzc[] zzcArray : zza2.zzth.get((int)n).zzbxb) {
                            if ("_c".equals(zzcArray.name)) {
                                zzcArray.zzbxf = 1L;
                                bl5 = true;
                                continue;
                            }
                            if (!"_r".equals(zzcArray.name)) continue;
                            zzcArray.zzbxf = 1L;
                            bl6 = true;
                        }
                        if (!bl5 && bl2) {
                            this.zzKl().zzMf().zzj("Marking event as conversion", zza2.zzth.get((int)n).name);
                            object = Arrays.copyOf(zza2.zzth.get((int)n).zzbxb, zza2.zzth.get((int)n).zzbxb.length + 1);
                            zzauw.zzc zzc2 = new zzauw.zzc();
                            zzc2.name = "_c";
                            zzc2.zzbxf = 1L;
                            object[((zzauw.zzc[])object).length - 1] = zzc2;
                            zza2.zzth.get((int)n).zzbxb = object;
                        }
                        if (!bl6) {
                            this.zzKl().zzMf().zzj("Marking event as real-time", zza2.zzth.get((int)n).name);
                            object = Arrays.copyOf(zza2.zzth.get((int)n).zzbxb, zza2.zzth.get((int)n).zzbxb.length + 1);
                            zzauw.zzc zzc3 = new zzauw.zzc();
                            zzc3.name = "_r";
                            zzc3.zzbxf = 1L;
                            object[((zzauw.zzc[])object).length - 1] = zzc3;
                            zza2.zzth.get((int)n).zzbxb = object;
                        }
                        bl = true;
                        object = this.zzKg().zza(this.zzMG(), zza2.zzbuJ.zzaS, false, false, false, false, true);
                        if (object.zzbrs > (long)this.zzKn().zzfl(zza2.zzbuJ.zzaS)) {
                            zzauw.zzb zzb2 = zza2.zzth.get(n);
                            for (int i = 0; i < zzb2.zzbxb.length; ++i) {
                                zzauw.zzc[] zzcArray;
                                if (!"_r".equals(zzb2.zzbxb[i].name)) continue;
                                zzcArray = new zzauw.zzc[zzb2.zzbxb.length - 1];
                                if (i > 0) {
                                    System.arraycopy(zzb2.zzbxb, 0, zzcArray, 0, i);
                                }
                                if (i < zzcArray.length) {
                                    System.arraycopy(zzb2.zzbxb, i + 1, zzcArray, i, zzcArray.length - i);
                                }
                                zzb2.zzbxb = zzcArray;
                                break;
                            }
                            bl = bl3;
                        }
                        if ((n3 = (int)(zzaut.zzfT(zza2.zzth.get((int)n).name) ? 1 : 0)) != 0 && bl2) {
                            object = this.zzKg().zza(this.zzMG(), zza2.zzbuJ.zzaS, false, false, true, false, false);
                            if (object.zzbrq > (long)this.zzKn().zzfk(zza2.zzbuJ.zzaS)) {
                                this.zzKl().zzMb().zzj("Too many conversions. Not logging as conversion. appId", zzatx.zzfE(zza2.zzbuJ.zzaS));
                                zzauw.zzb zzb3 = zza2.zzth.get(n);
                                boolean bl7 = false;
                                zzauw.zzc zzc4 = null;
                                for (zzauw.zzc zzc5 : zzb3.zzbxb) {
                                    if ("_c".equals(zzc5.name)) {
                                        zzc4 = zzc5;
                                        continue;
                                    }
                                    if (!"_err".equals(zzc5.name)) continue;
                                    bl7 = true;
                                }
                                if (bl7 && zzc4 != null) {
                                    zzauw.zzc[] zzcArray = new zzauw.zzc[zzb3.zzbxb.length - 1];
                                    int n4 = 0;
                                    for (zzauw.zzc zzc6 : zzb3.zzbxb) {
                                        if (zzc6 == zzc4) continue;
                                        zzcArray[n4++] = zzc6;
                                    }
                                    zzb3.zzbxb = zzcArray;
                                } else if (zzc4 != null) {
                                    zzc4.name = "_err";
                                    zzc4.zzbxf = 10L;
                                } else {
                                    this.zzKl().zzLZ().zzj("Did not find conversion parameter. appId", zzatx.zzfE(zza2.zzbuJ.zzaS));
                                }
                            }
                        }
                    }
                    zze2.zzbxj[n2++] = zza2.zzth.get(n);
                }
                if (n2 < zza2.zzth.size()) {
                    zze2.zzbxj = Arrays.copyOf(zze2.zzbxj, n2);
                }
                zze2.zzbxC = this.zza(zza2.zzbuJ.zzaS, zza2.zzbuJ.zzbxk, zze2.zzbxj);
                zze2.zzbxm = Long.MAX_VALUE;
                zze2.zzbxn = Long.MIN_VALUE;
                for (n = 0; n < zze2.zzbxj.length; ++n) {
                    zzauw.zzb zzb4 = zze2.zzbxj[n];
                    if (zzb4.zzbxc < zze2.zzbxm) {
                        zze2.zzbxm = zzb4.zzbxc;
                    }
                    if (zzb4.zzbxc <= zze2.zzbxn) continue;
                    zze2.zzbxn = zzb4.zzbxc;
                }
                String string2 = zza2.zzbuJ.zzaS;
                zzatc zzatc2 = this.zzKg().zzfu(string2);
                if (zzatc2 == null) {
                    this.zzKl().zzLZ().zzj("Bundling raw events w/o app info. appId", zzatx.zzfE(zza2.zzbuJ.zzaS));
                } else if (zze2.zzbxj.length > 0) {
                    long l2 = zzatc2.zzKs();
                    zze2.zzbxp = l2 != 0L ? Long.valueOf(l2) : null;
                    long l3 = zzatc2.zzKr();
                    if (l3 == 0L) {
                        l3 = l2;
                    }
                    zze2.zzbxo = l3 != 0L ? Long.valueOf(l3) : null;
                    zzatc2.zzKB();
                    zze2.zzbxA = (int)zzatc2.zzKy();
                    zzatc2.zzY(zze2.zzbxm);
                    zzatc2.zzZ(zze2.zzbxn);
                    zze2.zzbqO = zzatc2.zzKJ();
                    this.zzKg().zza(zzatc2);
                }
                if (zze2.zzbxj.length > 0) {
                    this.zzKn().zzLh();
                    zzauv.zzb zzb5 = this.zzKi().zzfL(zza2.zzbuJ.zzaS);
                    if (zzb5 == null || zzb5.zzbwQ == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zzbuJ.zzbqK)) {
                            zze2.zzbxH = -1L;
                        } else {
                            this.zzKl().zzMb().zzj("Did not find measurement config or missing version info. appId", zzatx.zzfE(zza2.zzbuJ.zzaS));
                        }
                    } else {
                        zze2.zzbxH = zzb5.zzbwQ;
                    }
                    this.zzKg().zza(zze2, bl);
                }
                this.zzKg().zzJ(zza2.zzbuK);
                this.zzKg().zzfB(string2);
                this.zzKg().setTransactionSuccessful();
                boolean bl8 = zze2.zzbxj.length > 0;
                return bl8;
            }
            this.zzKg().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzKg().endTransaction();
        }
    }

    private zzauw.zza[] zza(String string, zzauw.zzg[] zzgArray, zzauw.zzb[] zzbArray) {
        zzac.zzdr((String)string);
        return this.zzJZ().zza(string, zzbArray, zzgArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzmR();
        this.zzob();
        zzac.zzdr((String)string);
        if (byArray == null) {
            byArray = new byte[]{};
        }
        this.zzKg().beginTransaction();
        try {
            boolean bl;
            zzatc zzatc2 = this.zzKg().zzfu(string);
            boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
            if (zzatc2 == null) {
                this.zzKl().zzMb().zzj("App does not exist in onConfigFetched. appId", zzatx.zzfE(string));
            } else if (bl || n == 404) {
                String string2;
                List<String> list = map != null ? map.get("Last-Modified") : null;
                String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                if (n == 404 || n == 304 ? this.zzKi().zzfL(string) == null && !this.zzKi().zzb(string, null, null) : !this.zzKi().zzb(string, byArray, string2)) {
                    return;
                }
                zzatc2.zzae(this.zznR().currentTimeMillis());
                this.zzKg().zza(zzatc2);
                if (n == 404) {
                    this.zzKl().zzMc().zzj("Config not found. Using empty config. appId", string);
                } else {
                    this.zzKl().zzMf().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                }
                if (this.zzMz().zzqa() && this.zzMJ()) {
                    this.zzMI();
                } else {
                    this.zzMK();
                }
            } else {
                boolean bl3;
                zzatc2.zzaf(this.zznR().currentTimeMillis());
                this.zzKg().zza(zzatc2);
                this.zzKl().zzMf().zze("Fetching config failed. code, error", n, throwable);
                this.zzKi().zzfN(string);
                this.zzKm().zzbtc.set(this.zznR().currentTimeMillis());
                boolean bl4 = bl3 = n == 503 || n == 429;
                if (bl3) {
                    this.zzKm().zzbtd.set(this.zznR().currentTimeMillis());
                }
                this.zzMK();
            }
            this.zzKg().setTransactionSuccessful();
        }
        finally {
            this.zzKg().endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    protected void zza(int n, Throwable throwable, byte[] byArray) {
        this.zzmR();
        this.zzob();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        List<Long> list = this.zzbuC;
        this.zzbuC = null;
        if ((n == 200 || n == 204) && throwable == null) {
            try {
                this.zzKm().zzbtb.set(this.zznR().currentTimeMillis());
                this.zzKm().zzbtc.set(0L);
                this.zzMK();
                this.zzKl().zzMf().zze("Successful upload. Got network response. code, size", n, byArray.length);
                this.zzKg().beginTransaction();
                try {
                    for (Long l : list) {
                        this.zzKg().zzan(l);
                    }
                    this.zzKg().setTransactionSuccessful();
                }
                finally {
                    this.zzKg().endTransaction();
                }
                if (this.zzMz().zzqa() && this.zzMJ()) {
                    this.zzMI();
                } else {
                    this.zzbuF = -1L;
                    this.zzMK();
                }
                this.zzbuG = 0L;
            }
            catch (SQLiteException sQLiteException) {
                this.zzKl().zzLZ().zzj("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                this.zzbuG = this.zznR().elapsedRealtime();
                this.zzKl().zzMf().zzj("Disable upload, time", this.zzbuG);
            }
        } else {
            boolean bl;
            this.zzKl().zzMf().zze("Network upload failed. Will retry later. code, error", n, throwable);
            this.zzKm().zzbtc.set(this.zznR().currentTimeMillis());
            boolean bl2 = bl = n == 503 || n == 429;
            if (bl) {
                this.zzKm().zzbtd.set(this.zznR().currentTimeMillis());
            }
            this.zzMK();
        }
    }

    private boolean zzMJ() {
        this.zzmR();
        this.zzob();
        boolean bl = this.zzKg().zzLK();
        return bl || !TextUtils.isEmpty((CharSequence)this.zzKg().zzLE());
    }

    @WorkerThread
    private void zzMK() {
        long l;
        long l2;
        this.zzmR();
        this.zzob();
        if (!this.zzMO()) {
            return;
        }
        if (this.zzbuG > 0L) {
            l2 = this.zznR().elapsedRealtime();
            l = 3600000L - Math.abs(l2 - this.zzbuG);
            if (l > 0L) {
                this.zzKl().zzMf().zzj("Upload has been suspended. Will update scheduling later in approximately ms", l);
                this.zzMA().unregister();
                this.zzMB().cancel();
                return;
            }
            this.zzbuG = 0L;
        }
        if (!this.zzMu() || !this.zzMJ()) {
            this.zzMA().unregister();
            this.zzMB().cancel();
            return;
        }
        l2 = this.zzML();
        if (l2 == 0L) {
            this.zzMA().unregister();
            this.zzMB().cancel();
            return;
        }
        if (!this.zzMz().zzqa()) {
            this.zzMA().zzpX();
            this.zzMB().cancel();
            return;
        }
        l = this.zzKm().zzbtd.get();
        long l3 = this.zzKn().zzLt();
        if (!this.zzKh().zzh(l, l3)) {
            l2 = Math.max(l2, l + l3);
        }
        this.zzMA().unregister();
        long l4 = l2 - this.zznR().currentTimeMillis();
        if (l4 <= 0L) {
            l4 = this.zzKn().zzLx();
            this.zzKm().zzbtb.set(this.zznR().currentTimeMillis());
        }
        this.zzKl().zzMf().zzj("Upload scheduled in approximately ms", l4);
        this.zzMB().zzy(l4);
    }

    private long zzML() {
        String string;
        boolean bl;
        long l = this.zznR().currentTimeMillis();
        long l2 = this.zzKn().zzLA();
        boolean bl2 = bl = this.zzKg().zzLL() || this.zzKg().zzLF();
        long l3 = bl ? (!TextUtils.isEmpty((CharSequence)(string = this.zzKn().zzLD())) && !".none.".equals(string) ? this.zzKn().zzLw() : this.zzKn().zzLv()) : this.zzKn().zzLu();
        long l4 = this.zzKm().zzbtb.get();
        long l5 = this.zzKm().zzbtc.get();
        long l6 = this.zzKg().zzLI();
        long l7 = this.zzKg().zzLJ();
        long l8 = Math.max(l6, l7);
        if (l8 == 0L) {
            return 0L;
        }
        l8 = l - Math.abs(l8 - l);
        l4 = l - Math.abs(l4 - l);
        l5 = l - Math.abs(l5 - l);
        long l9 = Math.max(l4, l5);
        long l10 = l8 + l2;
        if (bl && l9 > 0L) {
            l10 = Math.min(l8, l9) + l3;
        }
        if (!this.zzKh().zzh(l9, l3)) {
            l10 = l9 + l3;
        }
        if (l5 != 0L && l5 >= l8) {
            long l11 = l10;
            for (int i = 0; i < this.zzKn().zzLC(); ++i) {
                long l12 = 1 << i;
                if ((l11 += this.zzKn().zzLB() * l12) <= l5) continue;
                return l11;
            }
            return 0L;
        }
        return l10;
    }

    public void zzV(boolean bl) {
        this.zzMK();
    }

    void zzb(zzauh zzauh2) {
        ++this.zzbuD;
    }

    void zzMM() {
        ++this.zzbuE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zze(zzatd zzatd2) {
        int n;
        this.zzmR();
        this.zzob();
        zzac.zzw((Object)((Object)zzatd2));
        zzac.zzdr((String)zzatd2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzatd2.zzbqK)) {
            return;
        }
        if (!zzatd2.zzbqP) {
            this.zzf(zzatd2);
            return;
        }
        long l = zzatd2.zzbqU;
        if (l == 0L) {
            l = this.zznR().currentTimeMillis();
        }
        if ((n = zzatd2.zzbqV) != 0 && n != 1) {
            this.zzKl().zzMb().zze("Incorrect app type, assuming installed app. appId, appType", zzatx.zzfE(zzatd2.packageName), n);
            n = 0;
        }
        this.zzKg().beginTransaction();
        try {
            this.zza(zzatd2, l);
            this.zzf(zzatd2);
            zzatn zzatn2 = null;
            if (n == 0) {
                zzatn2 = this.zzKg().zzQ(zzatd2.packageName, "_f");
            } else if (n == 1) {
                zzatn2 = this.zzKg().zzQ(zzatd2.packageName, "_v");
            }
            if (zzatn2 == null) {
                long l2 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzauq zzauq2 = new zzauq("_fot", l, l2, "auto");
                    this.zzb(zzauq2, zzatd2);
                    this.zzc(zzatd2, l);
                } else if (n == 1) {
                    zzauq zzauq3 = new zzauq("_fvt", l, l2, "auto");
                    this.zzb(zzauq3, zzatd2);
                    this.zzb(zzatd2, l);
                }
                this.zzd(zzatd2, l);
            } else if (zzatd2.zzbqQ) {
                this.zze(zzatd2, l);
            }
            this.zzKg().setTransactionSuccessful();
        }
        finally {
            this.zzKg().endTransaction();
        }
    }

    @WorkerThread
    void zza(zzatd zzatd2, long l) {
        zzatc zzatc2 = this.zzKg().zzfu(zzatd2.packageName);
        if (zzatc2 != null && zzatc2.getGmpAppId() != null && !zzatc2.getGmpAppId().equals(zzatd2.zzbqK)) {
            this.zzKl().zzMb().zzj("New GMP App Id passed in. Removing cached database data. appId", zzatx.zzfE(zzatc2.zzke()));
            this.zzKg().zzfz(zzatc2.zzke());
            zzatc2 = null;
        }
        if (zzatc2 != null && zzatc2.zzmZ() != null && !zzatc2.zzmZ().equals(zzatd2.zzbhN)) {
            Bundle bundle = new Bundle();
            bundle.putString("_pv", zzatc2.zzmZ());
            zzatq zzatq2 = new zzatq("_au", new zzato(bundle), "auto", l);
            this.zzb(zzatq2, zzatd2);
        }
    }

    @WorkerThread
    void zzb(zzatd zzatd2, long l) {
        this.zzmR();
        this.zzob();
        Bundle bundle = new Bundle();
        bundle.putLong("_c", 1L);
        bundle.putLong("_r", 1L);
        zzatq zzatq2 = new zzatq("_v", new zzato(bundle), "auto", l);
        this.zzb(zzatq2, zzatd2);
    }

    @WorkerThread
    void zzc(zzatd zzatd2, long l) {
        this.zzmR();
        this.zzob();
        zzatc zzatc2 = this.zzKg().zzfu(zzatd2.packageName);
        if (zzatc2 != null && TextUtils.isEmpty((CharSequence)zzatc2.getGmpAppId()) && zzatd2 != null && !TextUtils.isEmpty((CharSequence)zzatd2.zzbqK)) {
            zzatc2.zzae(0L);
            this.zzKg().zza(zzatc2);
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_c", 1L);
        bundle.putLong("_r", 1L);
        bundle.putLong("_uwa", 0L);
        bundle.putLong("_pfo", 0L);
        bundle.putLong("_sys", 0L);
        bundle.putLong("_sysu", 0L);
        PackageManager packageManager = this.getContext().getPackageManager();
        if (packageManager == null) {
            this.zzKl().zzLZ().zzj("PackageManager is null, first open report might be inaccurate. appId", zzatx.zzfE(zzatd2.packageName));
        } else {
            PackageInfo packageInfo = null;
            try {
                packageInfo = zzadg.zzbi((Context)this.getContext()).getPackageInfo(zzatd2.packageName, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzKl().zzLZ().zze("Package info is null, first open report might be inaccurate. appId", zzatx.zzfE(zzatd2.packageName), (Object)nameNotFoundException);
            }
            if (packageInfo != null && packageInfo.firstInstallTime != 0L && packageInfo.firstInstallTime != packageInfo.lastUpdateTime) {
                bundle.putLong("_uwa", 1L);
            }
            ApplicationInfo applicationInfo = null;
            try {
                applicationInfo = zzadg.zzbi((Context)this.getContext()).getApplicationInfo(zzatd2.packageName, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.zzKl().zzLZ().zze("Application info is null, first open report might be inaccurate. appId", zzatx.zzfE(zzatd2.packageName), (Object)nameNotFoundException);
            }
            if (applicationInfo != null) {
                if ((applicationInfo.flags & 1) != 0) {
                    bundle.putLong("_sys", 1L);
                }
                if ((applicationInfo.flags & 0x80) != 0) {
                    bundle.putLong("_sysu", 1L);
                }
            }
        }
        long l2 = this.zzKg().zzfA(zzatd2.packageName);
        if (l2 >= 0L) {
            bundle.putLong("_pfo", l2);
        }
        zzatq zzatq2 = new zzatq("_f", new zzato(bundle), "auto", l);
        this.zzb(zzatq2, zzatd2);
    }

    @WorkerThread
    void zzd(zzatd zzatd2, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("_et", 1L);
        zzatq zzatq2 = new zzatq("_e", new zzato(bundle), "auto", l);
        this.zzb(zzatq2, zzatd2);
    }

    @WorkerThread
    void zze(zzatd zzatd2, long l) {
        Bundle bundle = new Bundle();
        zzatq zzatq2 = new zzatq("_cd", new zzato(bundle), "auto", l);
        this.zzb(zzatq2, zzatd2);
    }

    @WorkerThread
    private void zzf(zzatd zzatd2) {
        this.zzmR();
        this.zzob();
        zzac.zzw((Object)((Object)zzatd2));
        zzac.zzdr((String)zzatd2.packageName);
        zzatc zzatc2 = this.zzKg().zzfu(zzatd2.packageName);
        String string = this.zzKm().zzfH(zzatd2.packageName);
        boolean bl = false;
        if (zzatc2 == null) {
            zzatc2 = new zzatc(this, zzatd2.packageName);
            zzatc2.zzfd(this.zzKm().zzMi());
            zzatc2.zzff(string);
            bl = true;
        } else if (!string.equals(zzatc2.zzKp())) {
            zzatc2.zzff(string);
            zzatc2.zzfd(this.zzKm().zzMi());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzatd2.zzbqK) && !zzatd2.zzbqK.equals(zzatc2.getGmpAppId())) {
            zzatc2.zzfe(zzatd2.zzbqK);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzatd2.zzbqS) && !zzatd2.zzbqS.equals(zzatc2.zzKq())) {
            zzatc2.zzfg(zzatd2.zzbqS);
            bl = true;
        }
        if (zzatd2.zzbqM != 0L && zzatd2.zzbqM != zzatc2.zzKv()) {
            zzatc2.zzab(zzatd2.zzbqM);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzatd2.zzbhN) && !zzatd2.zzbhN.equals(zzatc2.zzmZ())) {
            zzatc2.setAppVersion(zzatd2.zzbhN);
            bl = true;
        }
        if (zzatd2.zzbqR != zzatc2.zzKt()) {
            zzatc2.zzaa(zzatd2.zzbqR);
            bl = true;
        }
        if (zzatd2.zzbqL != null && !zzatd2.zzbqL.equals(zzatc2.zzKu())) {
            zzatc2.zzfh(zzatd2.zzbqL);
            bl = true;
        }
        if (zzatd2.zzbqN != zzatc2.zzKw()) {
            zzatc2.zzac(zzatd2.zzbqN);
            bl = true;
        }
        if (zzatd2.zzbqP != zzatc2.zzKx()) {
            zzatc2.setMeasurementEnabled(zzatd2.zzbqP);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzatd2.zzbqO) && !zzatd2.zzbqO.equals(zzatc2.zzKI())) {
            zzatc2.zzfi(zzatd2.zzbqO);
            bl = true;
        }
        if (zzatd2.zzbqT != zzatc2.zzuW()) {
            zzatc2.zzam(zzatd2.zzbqT);
            bl = true;
        }
        if (bl) {
            this.zzKg().zza(zzatc2);
        }
    }

    @WorkerThread
    void zzMN() {
        this.zzmR();
        this.zzob();
        if (!this.zzbux) {
            this.zzKl().zzMd().log("This instance being marked as an uploader");
            this.zzMD();
        }
        this.zzbux = true;
    }

    @WorkerThread
    boolean zzMO() {
        this.zzmR();
        this.zzob();
        return this.zzbux;
    }

    private class zza
    implements zzatj.zzb {
        zzauw.zze zzbuJ;
        List<Long> zzbuK;
        List<zzauw.zzb> zzth;
        long zzbuL;

        private zza() {
        }

        @Override
        public void zzb(zzauw.zze zze2) {
            zzac.zzw((Object)((Object)zze2));
            this.zzbuJ = zze2;
        }

        @Override
        public boolean zza(long l, zzauw.zzb zzb2) {
            zzac.zzw((Object)((Object)zzb2));
            if (this.zzth == null) {
                this.zzth = new ArrayList<zzauw.zzb>();
            }
            if (this.zzbuK == null) {
                this.zzbuK = new ArrayList<Long>();
            }
            if (this.zzth.size() > 0 && this.zza(this.zzth.get(0)) != this.zza(zzb2)) {
                return false;
            }
            long l2 = this.zzbuL + (long)zzb2.zzafB();
            if (l2 >= (long)zzaue.this.zzKn().zzLo()) {
                return false;
            }
            this.zzbuL = l2;
            this.zzth.add(zzb2);
            this.zzbuK.add(l);
            return this.zzth.size() < zzaue.this.zzKn().zzLp();
        }

        private long zza(zzauw.zzb zzb2) {
            return zzb2.zzbxc / 1000L / 60L / 60L;
        }

        boolean isEmpty() {
            return this.zzth == null || this.zzth.isEmpty();
        }
    }
}

