/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzaue;
import com.google.android.gms.internal.zzauh;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class zzauk
extends zzauh {
    protected zza zzbvp;
    private volatile AppMeasurement.zzf zzbvq;
    private AppMeasurement.zzf zzbvr;
    private long zzbvs;
    private final Map<Activity, zza> zzbvt = new ArrayMap();
    private final CopyOnWriteArrayList<AppMeasurement.zzd> zzbvu = new CopyOnWriteArrayList();
    private boolean zzbvv;
    private AppMeasurement.zzf zzbvw;
    private String zzbvx;

    public zzauk(zzaue zzaue2) {
        super(zzaue2);
    }

    @Override
    protected void zzmS() {
    }

    @WorkerThread
    public zza zzMW() {
        this.zzob();
        this.zzmR();
        return this.zzbvp;
    }

    @MainThread
    public void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        boolean bl;
        if (activity == null) {
            this.zzKl().zzMb().log("setCurrentScreen must be called with a non-null activity");
            return;
        }
        if (!this.zzKk().zzbc()) {
            this.zzKl().zzMb().log("setCurrentScreen must be called from the main thread");
            return;
        }
        if (this.zzbvv) {
            this.zzKl().zzMb().log("Cannot call setCurrentScreen from onScreenChangeCallback");
            return;
        }
        if (this.zzbvq == null) {
            this.zzKl().zzMb().log("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzbvt.get(activity) == null) {
            this.zzKl().zzMb().log("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzauk.zzfS(activity.getClass().getCanonicalName());
        }
        boolean bl2 = this.zzbvq.zzbqf.equals(string2);
        boolean bl3 = bl = this.zzbvq.zzbqe == null && string == null || this.zzbvq.zzbqe != null && this.zzbvq.zzbqe.equals(string);
        if (bl2 && bl) {
            this.zzKl().zzMc().log("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() < 1 || string.length() > this.zzKn().zzKP())) {
            this.zzKl().zzMb().zzj("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() < 1 || string2.length() > this.zzKn().zzKP())) {
            this.zzKl().zzMb().zzj("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        this.zzKl().zzMf().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zza zza2 = new zza(string, string2, this.zzKh().zzNk());
        this.zzbvt.put(activity, zza2);
        this.zza(activity, zza2, true);
    }

    public AppMeasurement.zzf zzMX() {
        this.zzJW();
        AppMeasurement.zzf zzf2 = this.zzbvq;
        if (zzf2 == null) {
            return null;
        }
        return new AppMeasurement.zzf(zzf2);
    }

    @MainThread
    public void registerOnScreenChangeCallback(@NonNull AppMeasurement.zzd zzd2) {
        this.zzJW();
        if (zzd2 == null) {
            this.zzKl().zzMb().log("Attempting to register null OnScreenChangeCallback");
            return;
        }
        this.zzbvu.remove(zzd2);
        this.zzbvu.add(zzd2);
    }

    @MainThread
    public void unregisterOnScreenChangeCallback(@NonNull AppMeasurement.zzd zzd2) {
        this.zzJW();
        this.zzbvu.remove(zzd2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    private void zza(Activity activity, zza zza2, final boolean bl) {
        AppMeasurement.zzf zzf2 = null;
        if (this.zzbvq != null) {
            zzf2 = this.zzbvq;
        } else if (this.zzbvr != null && Math.abs(this.zznR().elapsedRealtime() - this.zzbvs) < 1000L) {
            zzf2 = this.zzbvr;
        }
        AppMeasurement.zzf zzf3 = null;
        if (zzf2 != null) {
            zzf3 = new AppMeasurement.zzf(zzf2);
        }
        boolean bl2 = true;
        this.zzbvv = true;
        try {
            for (AppMeasurement.zzd zzd2 : this.zzbvu) {
                try {
                    bl2 &= zzd2.zza(zzf3, zza2);
                }
                catch (Exception exception) {
                    this.zzKl().zzLZ().zzj("onScreenChangeCallback threw exception", exception);
                }
            }
        }
        catch (Exception exception) {
            this.zzKl().zzLZ().zzj("onScreenChangeCallback loop threw exception", exception);
        }
        finally {
            this.zzbvv = false;
        }
        if (bl2) {
            if (zza2.zzbqf == null) {
                zza2.zzbqf = zzauk.zzfS(activity.getClass().getCanonicalName());
            }
            final zza zza3 = new zza(zza2);
            this.zzbvr = this.zzbvq;
            this.zzbvs = this.zznR().elapsedRealtime();
            this.zzbvq = zza3;
            this.zzKk().zzm(new Runnable(){

                @Override
                public void run() {
                    if (bl && zzauk.this.zzbvp != null) {
                        zzauk.this.zza(zzauk.this.zzbvp);
                    }
                    zzauk.this.zzbvp = zza3;
                    zzauk.this.zzKd().zza(zza3);
                }
            });
        }
    }

    @WorkerThread
    private void zza(@NonNull zza zza2) {
        this.zzJY().zzW(this.zznR().elapsedRealtime());
        if (this.zzKj().zzaN(zza2.zzbvC)) {
            zza2.zzbvC = false;
        }
    }

    public static void zza(AppMeasurement.zzf zzf2, Bundle bundle) {
        if (bundle != null && zzf2 != null && !bundle.containsKey("_sc")) {
            if (zzf2.zzbqe != null) {
                bundle.putString("_sn", zzf2.zzbqe);
            }
            bundle.putString("_sc", zzf2.zzbqf);
            bundle.putLong("_si", zzf2.zzbqg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zza(String string, AppMeasurement.zzf zzf2) {
        this.zzmR();
        zzauk zzauk2 = this;
        synchronized (zzauk2) {
            if (this.zzbvx == null || this.zzbvx.equals(string) || zzf2 != null) {
                this.zzbvx = string;
                this.zzbvw = zzf2;
            }
        }
    }

    static String zzfS(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 0) {
            return string.substring(0, 36);
        }
        String string2 = stringArray[stringArray.length - 1];
        if (string2.length() > 36) {
            return string2.substring(0, 36);
        }
        return string2;
    }

    @MainThread
    zza zzv(@NonNull Activity activity) {
        zzac.zzw((Object)activity);
        zza zza2 = this.zzbvt.get(activity);
        if (zza2 == null) {
            String string = zzauk.zzfS(activity.getClass().getCanonicalName());
            zza2 = new zza(null, string, this.zzKh().zzNk());
            this.zzbvt.put(activity, zza2);
        }
        return zza2;
    }

    @MainThread
    public void onActivityCreated(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.firebase.analytics.screen_service");
        if (bundle2 == null) {
            return;
        }
        zza zza2 = this.zzv(activity);
        zza2.zzbqg = bundle2.getLong("id");
        zza2.zzbqe = bundle2.getString("name");
        zza2.zzbqf = bundle2.getString("referrer_name");
    }

    @MainThread
    public void onActivityResumed(Activity activity) {
        zza zza2 = this.zzv(activity);
        this.zza(activity, zza2, false);
        this.zzJY().zzJU();
    }

    @MainThread
    public void onActivityPaused(Activity activity) {
        final zza zza2 = this.zzv(activity);
        this.zzbvr = this.zzbvq;
        this.zzbvs = this.zznR().elapsedRealtime();
        this.zzbvq = null;
        this.zzKk().zzm(new Runnable(){

            @Override
            public void run() {
                zzauk.this.zza(zza2);
                zzauk.this.zzbvp = null;
                zzauk.this.zzKd().zza((AppMeasurement.zzf)null);
            }
        });
    }

    @MainThread
    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zza zza2 = this.zzbvt.get(activity);
        if (zza2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zza2.zzbqg);
        bundle2.putString("name", zza2.zzbqe);
        bundle2.putString("referrer_name", zza2.zzbqf);
        bundle.putBundle("com.google.firebase.analytics.screen_service", bundle2);
    }

    @MainThread
    public void onActivityDestroyed(Activity activity) {
        this.zzbvt.remove(activity);
    }

    static class zza
    extends AppMeasurement.zzf {
        public boolean zzbvC;

        public zza(String string, String string2, long l) {
            this.zzbqe = string;
            this.zzbqf = string2;
            this.zzbqg = l;
            this.zzbvC = false;
        }

        public zza(zza zza2) {
            this.zzbqe = zza2.zzbqe;
            this.zzbqf = zza2.zzbqf;
            this.zzbqg = zza2.zzbqg;
            this.zzbvC = zza2.zzbvC;
        }
    }
}

