/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.internal.acx;
import com.google.android.gms.internal.acy;
import com.google.android.gms.internal.ada;
import com.google.android.gms.internal.zzcef;
import com.google.android.gms.internal.zzcej;
import com.google.android.gms.internal.zzcel;
import com.google.android.gms.internal.zzcen;
import com.google.android.gms.internal.zzcep;
import com.google.android.gms.internal.zzcet;
import com.google.android.gms.internal.zzceu;
import com.google.android.gms.internal.zzcey;
import com.google.android.gms.internal.zzcfa;
import com.google.android.gms.internal.zzcfk;
import com.google.android.gms.internal.zzcgk;
import com.google.android.gms.internal.zzchi;
import com.google.android.gms.internal.zzcje;
import com.google.android.gms.internal.zzcjh;
import com.google.android.gms.internal.zzcjj;
import com.google.android.gms.internal.zzcjk;
import com.google.android.gms.internal.zzcjl;
import com.google.android.gms.internal.zzcjm;
import com.google.android.gms.internal.zzcjp;
import com.google.android.gms.internal.zzcjv;
import com.google.android.gms.internal.zzcjw;
import com.google.android.gms.internal.zzcjy;
import com.google.android.gms.internal.zzcjz;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class zzcem
extends zzchi {
    private static final Map<String, String> zzbpn = new ArrayMap(1);
    private static final Map<String, String> zzbpo;
    private static final Map<String, String> zzbpp;
    private static final Map<String, String> zzbpq;
    private static final Map<String, String> zzbpr;
    private final zzcep zzbps;
    private final zzcje zzbpt = new zzcje(this.zzkq());

    zzcem(zzcgk zzcgk2) {
        super(zzcgk2);
        String string = zzcel.zzxC();
        this.zzbps = new zzcep(this, this.getContext(), string);
    }

    @Override
    protected final void zzjD() {
    }

    @WorkerThread
    public final void beginTransaction() {
        this.zzkD();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public final void setTransactionSuccessful() {
        this.zzkD();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public final void endTransaction() {
        this.zzkD();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private final long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzwF().zzyx().zze("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @WorkerThread
    final SQLiteDatabase getWritableDatabase() {
        this.zzjC();
        try {
            return this.zzbps.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyz().zzj("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzceu zzE(String string, String string2) {
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        this.zzjC();
        this.zzkD();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            zzceu zzceu2 = new zzceu(string, string2, l, l2, l3);
            if (cursor.moveToNext()) {
                this.zzwF().zzyx().zzj("Got multiple records for event aggregates, expected one. appId", zzcfk.zzdZ(string));
            }
            zzceu zzceu3 = zzceu2;
            return zzceu3;
        }
    }

    @WorkerThread
    public final void zza(zzceu zzceu2) {
        zzbo.zzu((Object)zzceu2);
        this.zzjC();
        this.zzkD();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzceu2.mAppId);
        contentValues.put("name", zzceu2.mName);
        contentValues.put("lifetime_count", Long.valueOf(zzceu2.zzbpG));
        contentValues.put("current_bundle_count", Long.valueOf(zzceu2.zzbpH));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzceu2.zzbpI));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzwF().zzyx().zzj("Failed to insert/update event aggregates (got -1). appId", zzcfk.zzdZ(zzceu2.mAppId));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error storing event aggregates. appId", zzcfk.zzdZ(zzceu2.mAppId), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzF(String string, String string2) {
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        this.zzjC();
        this.zzkD();
        try {
            int n = this.getWritableDatabase().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzwF().zzyD().zzj("Deleted user attribute rows", n);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zzd("Error deleting user attribute. appId", zzcfk.zzdZ(string), this.zzwA().zzdY(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzcjj zzcjj2) {
        zzbo.zzu((Object)zzcjj2);
        this.zzjC();
        this.zzkD();
        if (this.zzG(zzcjj2.mAppId, zzcjj2.mName) == null) {
            if (zzcjk.zzeo(zzcjj2.mName)) {
                long l = this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzcjj2.mAppId});
                zzcel.zzxs();
                if (l >= 25L) {
                    return false;
                }
            } else {
                long l = this.zzb("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzcjj2.mAppId, zzcjj2.mOrigin});
                zzcel.zzxu();
                if (l >= 25L) {
                    return false;
                }
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcjj2.mAppId);
        contentValues.put("origin", zzcjj2.mOrigin);
        contentValues.put("name", zzcjj2.mName);
        contentValues.put("set_timestamp", Long.valueOf(zzcjj2.zzbuC));
        zzcem.zza(contentValues, "value", zzcjj2.mValue);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzwF().zzyx().zzj("Failed to insert/update user property (got -1). appId", zzcfk.zzdZ(zzcjj2.mAppId));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error storing user property. appId", zzcfk.zzdZ(zzcjj2.mAppId), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzcjj zzG(String string, String string2) {
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        this.zzjC();
        this.zzkD();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzcjj zzcjj2 = new zzcjj(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzwF().zzyx().zzj("Got multiple records for user property, expected one. appId", zzcfk.zzdZ(string));
            }
            zzcjj zzcjj3 = zzcjj2;
            return zzcjj3;
        }
    }

    @WorkerThread
    public final List<zzcjj> zzdP(String string) {
        zzbo.zzcF((String)string);
        this.zzjC();
        this.zzkD();
        ArrayList<zzcjj> arrayList = new ArrayList<zzcjj>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(zzcel.zzxt()));
            if (!cursor.moveToFirst()) {
                ArrayList<zzcjj> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzwF().zzyx().zzj("Read invalid user property value, ignoring it. appId", zzcfk.zzdZ(string));
                    continue;
                }
                zzcjj zzcjj2 = new zzcjj(string, string2, (String)object, l, object2);
                arrayList.add(zzcjj2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzcjj> zzh(String string, String string2, String string3) {
        zzbo.zzcF((String)string);
        this.zzjC();
        this.zzkD();
        ArrayList<zzcjj> arrayList = new ArrayList<zzcjj>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String[] stringArray2 = new String[]{"name", "set_timestamp", "value", "origin"};
            String string4 = stringBuilder.toString();
            zzcel.zzxt();
            cursor = sQLiteDatabase.query("user_attributes", stringArray2, string4, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzcjj> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= zzcel.zzxt()) {
                    this.zzwF().zzyx().zzj("Read more than the max allowed user properties, ignoring excess", zzcel.zzxt());
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzwF().zzyx().zzd("(2)Read invalid user property value, ignoring it", zzcfk.zzdZ(string), string2, string3);
                    continue;
                }
                zzcjj zzcjj2 = new zzcjj(string, string2, (String)object, l, object2);
                arrayList.add(zzcjj2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzcej zzcej2) {
        zzbo.zzu((Object)((Object)zzcej2));
        this.zzjC();
        this.zzkD();
        if (this.zzG(zzcej2.packageName, zzcej2.zzbpd.name) == null) {
            long l = this.zzb("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzcej2.packageName});
            zzcel.zzxv();
            if (l >= 1000L) {
                return false;
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcej2.packageName);
        contentValues.put("origin", zzcej2.zzbpc);
        contentValues.put("name", zzcej2.zzbpd.name);
        zzcem.zza(contentValues, "value", zzcej2.zzbpd.getValue());
        contentValues.put("active", Boolean.valueOf(zzcej2.zzbpf));
        contentValues.put("trigger_event_name", zzcej2.zzbpg);
        contentValues.put("trigger_timeout", Long.valueOf(zzcej2.zzbpi));
        this.zzwB();
        contentValues.put("timed_out_event", zzcjk.zza((Parcelable)zzcej2.zzbph));
        contentValues.put("creation_timestamp", Long.valueOf(zzcej2.zzbpe));
        this.zzwB();
        contentValues.put("triggered_event", zzcjk.zza((Parcelable)zzcej2.zzbpj));
        contentValues.put("triggered_timestamp", Long.valueOf(zzcej2.zzbpd.zzbuy));
        contentValues.put("time_to_live", Long.valueOf(zzcej2.zzbpk));
        this.zzwB();
        contentValues.put("expired_event", zzcjk.zza((Parcelable)zzcej2.zzbpl));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzwF().zzyx().zzj("Failed to insert/update conditional user property (got -1)", zzcfk.zzdZ(zzcej2.packageName));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error storing conditional user property", zzcfk.zzdZ(zzcej2.packageName), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzcej zzH(String string, String string2) {
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        this.zzjC();
        this.zzkD();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzcey zzcey2 = this.zzwB().zzb(cursor.getBlob(5), zzcey.CREATOR);
            long l2 = cursor.getLong(6);
            zzcey zzcey3 = this.zzwB().zzb(cursor.getBlob(7), zzcey.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzcey zzcey4 = this.zzwB().zzb(cursor.getBlob(10), zzcey.CREATOR);
            zzcjh zzcjh2 = new zzcjh(string2, l3, object, string3);
            zzcej zzcej2 = new zzcej(string, string3, zzcjh2, l2, bl, string4, zzcey2, l, zzcey3, l4, zzcey4);
            if (cursor.moveToNext()) {
                this.zzwF().zzyx().zze("Got multiple records for conditional property, expected one", zzcfk.zzdZ(string), this.zzwA().zzdY(string2));
            }
            zzcej zzcej3 = zzcej2;
            return zzcej3;
        }
    }

    @WorkerThread
    public final int zzI(String string, String string2) {
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        this.zzjC();
        this.zzkD();
        try {
            return this.getWritableDatabase().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zzd("Error deleting conditional property", zzcfk.zzdZ(string), this.zzwA().zzdY(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzcej> zzi(String string, String string2, String string3) {
        zzbo.zzcF((String)string);
        this.zzjC();
        this.zzkD();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zzc(stringBuilder.toString(), stringArray);
    }

    public final List<zzcej> zzc(String string, String[] stringArray) {
        this.zzjC();
        this.zzkD();
        ArrayList<zzcej> arrayList = new ArrayList<zzcej>();
        try (Cursor cursor = null;){
            Object object;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String[] stringArray2 = new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"};
            zzcel.zzxv();
            cursor = sQLiteDatabase.query("conditional_properties", stringArray2, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzcej> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= zzcel.zzxv()) {
                    this.zzwF().zzyx().zzj("Read more than the max allowed conditional properties, ignoring extra", zzcel.zzxv());
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzcey zzcey2 = this.zzwB().zzb(cursor.getBlob(7), zzcey.CREATOR);
                long l2 = cursor.getLong(8);
                zzcey zzcey3 = this.zzwB().zzb(cursor.getBlob(9), zzcey.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzcey zzcey4 = this.zzwB().zzb(cursor.getBlob(12), zzcey.CREATOR);
                zzcjh zzcjh2 = new zzcjh(string3, l3, object2, string2);
                zzcej zzcej2 = new zzcej((String)object, string2, zzcjh2, l2, bl, string4, zzcey2, l, zzcey3, l4, zzcey4);
                arrayList.add(zzcej2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzcef zzdQ(String string) {
        zzbo.zzcF((String)string);
        this.zzjC();
        this.zzkD();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzcef zzcef2 = new zzcef(this.zzboe, string);
            zzcef2.zzdG(cursor.getString(0));
            zzcef2.zzdH(cursor.getString(1));
            zzcef2.zzdI(cursor.getString(2));
            zzcef2.zzQ(cursor.getLong(3));
            zzcef2.zzL(cursor.getLong(4));
            zzcef2.zzM(cursor.getLong(5));
            zzcef2.setAppVersion(cursor.getString(6));
            zzcef2.zzdK(cursor.getString(7));
            zzcef2.zzO(cursor.getLong(8));
            zzcef2.zzP(cursor.getLong(9));
            zzcef2.setMeasurementEnabled((cursor.isNull(10) ? 1 : cursor.getInt(10)) != 0);
            zzcef2.zzT(cursor.getLong(11));
            zzcef2.zzU(cursor.getLong(12));
            zzcef2.zzV(cursor.getLong(13));
            zzcef2.zzW(cursor.getLong(14));
            zzcef2.zzR(cursor.getLong(15));
            zzcef2.zzS(cursor.getLong(16));
            zzcef2.zzN(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzcef2.zzdJ(cursor.getString(18));
            zzcef2.zzY(cursor.getLong(19));
            zzcef2.zzX(cursor.getLong(20));
            zzcef2.zzdL(cursor.getString(21));
            zzcef2.zzZ(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzcef2.zzwI();
            if (cursor.moveToNext()) {
                this.zzwF().zzyx().zzj("Got multiple records for app, expected one. appId", zzcfk.zzdZ(string));
            }
            zzcef zzcef3 = zzcef2;
            return zzcef3;
        }
    }

    @WorkerThread
    public final void zza(zzcef zzcef2) {
        zzbo.zzu((Object)zzcef2);
        this.zzjC();
        this.zzkD();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcef2.zzhl());
        contentValues.put("app_instance_id", zzcef2.getAppInstanceId());
        contentValues.put("gmp_app_id", zzcef2.getGmpAppId());
        contentValues.put("resettable_device_id_hash", zzcef2.zzwJ());
        contentValues.put("last_bundle_index", Long.valueOf(zzcef2.zzwS()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzcef2.zzwL()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzcef2.zzwM()));
        contentValues.put("app_version", zzcef2.zzjH());
        contentValues.put("app_store", zzcef2.zzwO());
        contentValues.put("gmp_version", Long.valueOf(zzcef2.zzwP()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzcef2.zzwQ()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzcef2.zzwR()));
        contentValues.put("day", Long.valueOf(zzcef2.zzwW()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzcef2.zzwX()));
        contentValues.put("daily_events_count", Long.valueOf(zzcef2.zzwY()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzcef2.zzwZ()));
        contentValues.put("config_fetched_time", Long.valueOf(zzcef2.zzwT()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzcef2.zzwU()));
        contentValues.put("app_version_int", Long.valueOf(zzcef2.zzwN()));
        contentValues.put("firebase_instance_id", zzcef2.zzwK());
        contentValues.put("daily_error_events_count", Long.valueOf(zzcef2.zzxb()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzcef2.zzxa()));
        contentValues.put("health_monitor_sample", zzcef2.zzxc());
        contentValues.put("android_id", Long.valueOf(zzcef2.zzxe()));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzcef2.zzhl()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzwF().zzyx().zzj("Failed to insert/update app (got -1). appId", zzcfk.zzdZ(zzcef2.zzhl()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error storing app. appId", zzcfk.zzdZ(zzcef2.zzhl()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzdR(String string) {
        zzbo.zzcF((String)string);
        this.zzjC();
        this.zzkD();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = string;
            int n = this.zzwH().zzb(string2, zzcfa.zzbqk);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error deleting over the limit events. appId", zzcfk.zzdZ(string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzcen zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        zzbo.zzcF((String)string);
        this.zzjC();
        this.zzkD();
        String[] stringArray = new String[]{string};
        zzcen zzcen2 = new zzcen();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzwF().zzyz().zzj("Not updating daily counts, app is not known. appId", zzcfk.zzdZ(string));
                zzcen zzcen3 = zzcen2;
                return zzcen3;
            }
            if (cursor.getLong(0) == l) {
                zzcen2.zzbpv = cursor.getLong(1);
                zzcen2.zzbpu = cursor.getLong(2);
                zzcen2.zzbpw = cursor.getLong(3);
                zzcen2.zzbpx = cursor.getLong(4);
                zzcen2.zzbpy = cursor.getLong(5);
            }
            if (bl) {
                ++zzcen2.zzbpv;
            }
            if (bl2) {
                ++zzcen2.zzbpu;
            }
            if (bl3) {
                ++zzcen2.zzbpw;
            }
            if (bl4) {
                ++zzcen2.zzbpx;
            }
            if (bl5) {
                ++zzcen2.zzbpy;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzcen2.zzbpu));
            contentValues.put("daily_events_count", Long.valueOf(zzcen2.zzbpv));
            contentValues.put("daily_conversions_count", Long.valueOf(zzcen2.zzbpw));
            contentValues.put("daily_error_events_count", Long.valueOf(zzcen2.zzbpx));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzcen2.zzbpy));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzcen zzcen4 = zzcen2;
            return zzcen4;
        }
    }

    @WorkerThread
    public final byte[] zzdS(String string) {
        zzbo.zzcF((String)string);
        this.zzjC();
        this.zzkD();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzwF().zzyx().zzj("Got multiple records for app config, expected one. appId", zzcfk.zzdZ(string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(zzcjy zzcjy2, boolean bl) {
        byte[] byArray;
        this.zzjC();
        this.zzkD();
        zzbo.zzu((Object)((Object)zzcjy2));
        zzbo.zzcF((String)zzcjy2.zzaJ);
        zzbo.zzu((Object)zzcjy2.zzbvI);
        this.zzye();
        long l = this.zzkq().currentTimeMillis();
        if (zzcjy2.zzbvI < l - zzcel.zzxG() || zzcjy2.zzbvI > l + zzcel.zzxG()) {
            this.zzwF().zzyz().zzd("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzcfk.zzdZ(zzcjy2.zzaJ), l, zzcjy2.zzbvI);
        }
        try {
            byte[] byArray2;
            byte[] byArray3 = byArray2 = new byte[zzcjy2.zzLT()];
            acy acy2 = acy.zzc((byte[])byArray2, (int)0, (int)byArray3.length);
            zzcjy2.zza(acy2);
            acy2.zzLK();
            byArray = this.zzwB().zzl(byArray2);
        }
        catch (IOException iOException) {
            this.zzwF().zzyx().zze("Data loss. Failed to serialize bundle. appId", zzcfk.zzdZ(zzcjy2.zzaJ), iOException);
            return false;
        }
        this.zzwF().zzyD().zzj("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcjy2.zzaJ);
        contentValues.put("bundle_end_timestamp", zzcjy2.zzbvI);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("queue", null, contentValues) == -1L) {
                this.zzwF().zzyx().zzj("Failed to insert bundle (got -1). appId", zzcfk.zzdZ(zzcjy2.zzaJ));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error storing bundle. appId", zzcfk.zzdZ(zzcjy2.zzaJ), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final String zzyc() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            return null;
        }
    }

    public final boolean zzyd() {
        return this.zzb("select count(1) > 0 from queue where has_realtime = 1", null) != 0L;
    }

    @WorkerThread
    public final List<Pair<zzcjy, Long>> zzl(String string, int n, int n2) {
        this.zzjC();
        this.zzkD();
        zzbo.zzaf((n > 0 ? 1 : 0) != 0);
        zzbo.zzaf((n2 > 0 ? 1 : 0) != 0);
        zzbo.zzcF((String)string);
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("queue", new String[]{"rowid", "data"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzcjy, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzcjy, Long>> arrayList = new ArrayList<Pair<zzcjy, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzwB().zzm((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzwF().zzyx().zze("Failed to unzip queued bundle. appId", zzcfk.zzdZ(string), iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                byte[] byArray2 = byArray;
                object = acx.zzb((byte[])byArray, (int)0, (int)byArray2.length);
                zzcjy zzcjy2 = new zzcjy();
                try {
                    zzcjy2.zza((acx)object);
                }
                catch (IOException iOException) {
                    this.zzwF().zzyx().zze("Failed to merge queued bundle. appId", zzcfk.zzdZ(string), iOException);
                    continue;
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzcjy, Long>)Pair.create((Object)((Object)zzcjy2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzcjy, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzye() {
        this.zzjC();
        this.zzkD();
        if (!this.zzyk()) {
            return;
        }
        long l = this.zzwG().zzbrn.get();
        long l2 = this.zzkq().elapsedRealtime();
        if (Math.abs(l2 - l) > zzcel.zzxH()) {
            this.zzwG().zzbrn.set(l2);
            zzcem zzcem2 = this;
            zzcem2.zzjC();
            zzcem2.zzkD();
            if (zzcem2.zzyk()) {
                SQLiteDatabase sQLiteDatabase = zzcem2.getWritableDatabase();
                String[] stringArray = new String[]{String.valueOf(zzcem2.zzkq().currentTimeMillis()), String.valueOf(zzcel.zzxG())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzcem2.zzwF().zzyD().zzj("Deleted stale rows. rowsDeleted", n);
                }
            }
        }
    }

    @WorkerThread
    final void zza(String string, zzcjl[] zzcjlArray) {
        this.zzkD();
        this.zzjC();
        zzbo.zzcF((String)string);
        zzbo.zzu((Object)zzcjlArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            int n;
            String string2 = string;
            zzcem zzcem2 = this;
            zzcem2.zzkD();
            zzcem2.zzjC();
            zzbo.zzcF((String)string2);
            Object object = zzcem2.getWritableDatabase();
            object.delete("property_filters", "app_id=?", new String[]{string2});
            object.delete("event_filters", "app_id=?", new String[]{string2});
            Object object2 = zzcjlArray;
            int n2 = zzcjlArray.length;
            block3: for (n = 0; n < n2; ++n) {
                zzcjm zzcjm2;
                int n3;
                int n4;
                zzcjl zzcjl2 = object2[n];
                object = zzcjl2;
                string2 = string;
                zzcem2 = this;
                zzcem2.zzkD();
                zzcem2.zzjC();
                zzbo.zzcF((String)string2);
                zzbo.zzu((Object)object);
                zzbo.zzu((Object)object.zzbuK);
                zzbo.zzu((Object)object.zzbuJ);
                if (object.zzbuI == null) {
                    zzcem2.zzwF().zzyz().zzj("Audience with no ID. appId", zzcfk.zzdZ(string2));
                    continue;
                }
                int n5 = object.zzbuI;
                ada[] adaArray = object.zzbuK;
                int n6 = object.zzbuK.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (adaArray[n4].zzbuM != null) continue;
                    zzcem2.zzwF().zzyz().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", zzcfk.zzdZ(string2), object.zzbuI);
                    continue block3;
                }
                adaArray = object.zzbuJ;
                n6 = object.zzbuJ.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (adaArray[n4].zzbuM != null) continue;
                    zzcem2.zzwF().zzyz().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", zzcfk.zzdZ(string2), object.zzbuI);
                    continue block3;
                }
                boolean bl = true;
                ada[] adaArray2 = object.zzbuK;
                n4 = object.zzbuK.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    zzcjm2 = adaArray2[n3];
                    if (zzcem2.zza(string2, n5, zzcjm2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    adaArray2 = object.zzbuJ;
                    n4 = object.zzbuJ.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        zzcjm2 = adaArray2[n3];
                        if (zzcem2.zza(string2, n5, (zzcjp)((Object)zzcjm2))) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n7 = n5;
                String string3 = string2;
                zzcem zzcem3 = zzcem2;
                zzcem3.zzkD();
                zzcem3.zzjC();
                zzbo.zzcF((String)string3);
                SQLiteDatabase sQLiteDatabase2 = zzcem3.getWritableDatabase();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
            }
            object2 = new ArrayList();
            zzcjl[] zzcjlArray2 = zzcjlArray;
            n = zzcjlArray.length;
            for (int i = 0; i < n; ++i) {
                zzcjl zzcjl3 = zzcjlArray2[i];
                object2.add(zzcjl3.zzbuI);
            }
            this.zzc(string, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzcjm zzcjm2) {
        byte[] byArray;
        this.zzkD();
        this.zzjC();
        zzbo.zzcF((String)string);
        zzbo.zzu((Object)((Object)zzcjm2));
        if (TextUtils.isEmpty((CharSequence)zzcjm2.zzbuN)) {
            this.zzwF().zzyz().zzd("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzcfk.zzdZ(string), n, String.valueOf(zzcjm2.zzbuM));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzcjm2.zzLT()];
            acy acy2 = acy.zzc((byte[])byArray, (int)0, (int)byArray2.length);
            zzcjm2.zza(acy2);
            acy2.zzLK();
        }
        catch (IOException iOException) {
            this.zzwF().zzyx().zze("Configuration loss. Failed to serialize event filter. appId", zzcfk.zzdZ(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzcjm2.zzbuM);
        contentValues.put("event_name", zzcjm2.zzbuN);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzwF().zzyx().zzj("Failed to insert event filter (got -1). appId", zzcfk.zzdZ(string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error storing event filter. appId", zzcfk.zzdZ(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzcjp zzcjp2) {
        byte[] byArray;
        this.zzkD();
        this.zzjC();
        zzbo.zzcF((String)string);
        zzbo.zzu((Object)((Object)zzcjp2));
        if (TextUtils.isEmpty((CharSequence)zzcjp2.zzbvc)) {
            this.zzwF().zzyz().zzd("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzcfk.zzdZ(string), n, String.valueOf(zzcjp2.zzbuM));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzcjp2.zzLT()];
            acy acy2 = acy.zzc((byte[])byArray, (int)0, (int)byArray2.length);
            zzcjp2.zza(acy2);
            acy2.zzLK();
        }
        catch (IOException iOException) {
            this.zzwF().zzyx().zze("Configuration loss. Failed to serialize property filter. appId", zzcfk.zzdZ(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzcjp2.zzbuM);
        contentValues.put("property_name", zzcjp2.zzbvc);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzwF().zzyx().zzj("Failed to insert property filter (got -1). appId", zzcfk.zzdZ(string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error storing property filter. appId", zzcfk.zzdZ(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzcjm>> zzJ(String string, String string2) {
        this.zzkD();
        this.zzjC();
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzcjm>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                acx acx2 = acx.zzb((byte[])byArray, (int)0, (int)byArray.length);
                zzcjm zzcjm2 = new zzcjm();
                try {
                    zzcjm2.zza(acx2);
                }
                catch (IOException iOException) {
                    this.zzwF().zzyx().zze("Failed to merge filter. appId", zzcfk.zzdZ(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzcjm> arrayList = (ArrayList<zzcjm>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzcjm>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzcjm2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzcjp>> zzK(String string, String string2) {
        this.zzkD();
        this.zzjC();
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzcjp>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                acx acx2 = acx.zzb((byte[])byArray, (int)0, (int)byArray.length);
                zzcjp zzcjp2 = new zzcjp();
                try {
                    zzcjp2.zza(acx2);
                }
                catch (IOException iOException) {
                    this.zzwF().zzyx().zze("Failed to merge filter", zzcfk.zzdZ(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzcjp> arrayList = (ArrayList<zzcjp>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzcjp>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzcjp2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zzc(String string, List<Integer> list) {
        Object object;
        long l;
        zzbo.zzcF((String)string);
        this.zzkD();
        this.zzjC();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zzb("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Database error querying filters. appId", zzcfk.zzdZ(string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzwH().zzb(string2, zzcfa.zzbqA);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = String.valueOf(TextUtils.join((CharSequence)",", arrayList));
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, zzcjz> zzdT(String string) {
        this.zzkD();
        this.zzjC();
        zzbo.zzcF((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                acx acx2 = acx.zzb((byte[])byArray, (int)0, (int)byArray.length);
                zzcjz zzcjz2 = new zzcjz();
                try {
                    zzcjz2.zza(acx2);
                }
                catch (IOException iOException) {
                    this.zzwF().zzyx().zzd("Failed to merge filter results. appId, audienceId, error", zzcfk.zzdZ(string), n, iOException);
                    continue;
                }
                arrayMap.put(n, zzcjz2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        zzbo.zzcF((String)string);
        zzbo.zzu((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzwF().zzyx().log("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzwF().zzyx().log("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzwF().zzyx().zzj("Loaded invalid unknown value type, ignoring it", n3);
        return null;
    }

    @WorkerThread
    public final long zzyf() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    protected final long zzL(String string, String string2) {
        zzbo.zzcF((String)string);
        zzbo.zzcF((String)string2);
        this.zzjC();
        this.zzkD();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzwF().zzyx().zze("Failed to insert column (got -1). appId", zzcfk.zzdZ(string), string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzwF().zzyx().zze("Failed to update column (got 0). appId", zzcfk.zzdZ(string), string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zzd("Error inserting column. appId", zzcfk.zzdZ(string), string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzyg() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(zzcjy zzcjy2) throws IOException {
        long l;
        Object object;
        byte[] byArray;
        this.zzjC();
        this.zzkD();
        zzbo.zzu((Object)((Object)zzcjy2));
        zzbo.zzcF((String)zzcjy2.zzaJ);
        try {
            byArray = new byte[zzcjy2.zzLT()];
            object = byArray;
            acy acy2 = acy.zzc((byte[])byArray, (int)0, (int)((byte[])object).length);
            zzcjy2.zza(acy2);
            acy2.zzLK();
        }
        catch (IOException iOException) {
            this.zzwF().zzyx().zze("Data loss. Failed to serialize event metadata. appId", zzcfk.zzdZ(zzcjy2.zzaJ), iOException);
            throw iOException;
        }
        byte[] byArray2 = byArray;
        object = this.zzwB();
        zzbo.zzu((Object)byArray2);
        ((zzcjk)object).zzjC();
        MessageDigest messageDigest = zzcjk.zzbE("MD5");
        if (messageDigest == null) {
            ((zzcjk)object).zzwF().zzyx().log("Failed to get MD5");
            l = 0L;
        } else {
            l = zzcjk.zzn(messageDigest.digest(byArray2));
        }
        long l2 = l;
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcjy2.zzaJ);
        contentValues.put("metadata_fingerprint", Long.valueOf(l2));
        contentValues.put("metadata", byArray);
        try {
            this.getWritableDatabase().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error storing raw event metadata. appId", zzcfk.zzdZ(zzcjy2.zzaJ), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l2;
    }

    public final boolean zzyh() {
        return this.zzb("select count(1) > 0 from raw_events", null) != 0L;
    }

    public final boolean zzyi() {
        return this.zzb("select count(1) > 0 from raw_events where realtime = 1", null) != 0L;
    }

    public final void zzG(List<Long> list) {
        zzbo.zzu(list);
        this.zzjC();
        this.zzkD();
        StringBuilder stringBuilder = new StringBuilder("rowid in (");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get(i));
        }
        stringBuilder.append(")");
        int n = this.getWritableDatabase().delete("raw_events", stringBuilder.toString(), null);
        if (n != list.size()) {
            this.zzwF().zzyx().zze("Deleted fewer rows from raw events table than expected", n, list.size());
        }
    }

    public final long zzdU(String string) {
        zzbo.zzcF((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zzaa(long l) {
        this.zzjC();
        this.zzkD();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzwF().zzyD().log("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzyj() {
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final boolean zza(zzcet zzcet2, long l, boolean bl) {
        Object object;
        zzcjw zzcjw2;
        String string2;
        this.zzjC();
        this.zzkD();
        zzbo.zzu((Object)zzcet2);
        zzbo.zzcF((String)zzcet2.mAppId);
        zzcjv zzcjv2 = new zzcjv();
        new zzcjv().zzbvy = zzcet2.zzbpE;
        zzcjv2.zzbvw = new zzcjw[zzcet2.zzbpF.size()];
        int n = 0;
        for (String string2 : zzcet2.zzbpF) {
            zzcjw2 = new zzcjw();
            zzcjv2.zzbvw[n++] = zzcjw2;
            zzcjw2.name = string2;
            Object object2 = zzcet2.zzbpF.get(string2);
            this.zzwB().zza(zzcjw2, object2);
        }
        try {
            byte[] byArray = new byte[zzcjv2.zzLT()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzcjw2 = acy.zzc((byte[])byArray, (int)0, (int)byArray2.length);
            zzcjv2.zza((acy)zzcjw2);
            zzcjw2.zzLK();
        }
        catch (IOException iOException) {
            this.zzwF().zzyx().zze("Data loss. Failed to serialize event params/data. appId", zzcfk.zzdZ(zzcet2.mAppId), iOException);
            return false;
        }
        this.zzwF().zzyD().zze("Saving event, name, data size", this.zzwA().zzdW(zzcet2.mName), ((Object)object).length);
        string2 = new ContentValues();
        string2.put("app_id", zzcet2.mAppId);
        string2.put("name", zzcet2.mName);
        string2.put("timestamp", Long.valueOf(zzcet2.zzayS));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzwF().zzyx().zzj("Failed to insert raw event (got -1). appId", zzcfk.zzdZ(zzcet2.mAppId));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzwF().zzyx().zze("Error storing raw event. appId", zzcfk.zzdZ(zzcet2.mAppId), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zzyk() {
        return this.getContext().getDatabasePath(zzcel.zzxC()).exists();
    }

    @WorkerThread
    private static boolean zza(zzcfk zzcfk2, SQLiteDatabase sQLiteDatabase, String string) {
        if (zzcfk2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
            boolean bl = cursor.moveToFirst();
            return bl;
        }
    }

    @WorkerThread
    private static Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
        try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
            Collections.addAll(hashSet, cursor.getColumnNames());
        }
        return hashSet;
    }

    @WorkerThread
    private static void zza(zzcfk zzcfk2, SQLiteDatabase sQLiteDatabase, String string, String string2, Map<String, String> map) throws SQLiteException {
        if (zzcfk2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        Set<String> set = zzcem.zzb(sQLiteDatabase, string);
        for (String string3 : string2.split(",")) {
            if (set.remove(string3)) continue;
            throw new SQLiteException(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Table ").append(string).append(" is missing required column: ").append(string3).toString());
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (set.remove(entry.getKey())) continue;
                sQLiteDatabase.execSQL((String)entry.getValue());
            }
        }
        if (!set.isEmpty()) {
            zzcfk2.zzyz().zze("Table has extra columns. table, columns", string, TextUtils.join((CharSequence)", ", set));
        }
    }

    @WorkerThread
    static void zza(zzcfk zzcfk2, SQLiteDatabase sQLiteDatabase, String string, String string2, String string3, Map<String, String> map) throws SQLiteException {
        if (zzcfk2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        if (!zzcem.zza(zzcfk2, sQLiteDatabase, string)) {
            sQLiteDatabase.execSQL(string2);
        }
        try {
            zzcem.zza(zzcfk2, sQLiteDatabase, string, string3, map);
            return;
        }
        catch (SQLiteException sQLiteException) {
            zzcfk2.zzyx().zzj("Failed to verify columns on table that was just created", string);
            throw sQLiteException;
        }
    }

    static void zza(zzcfk zzcfk2, SQLiteDatabase sQLiteDatabase) {
        if (zzcfk2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        File file = new File(sQLiteDatabase.getPath());
        if (!file.setReadable(false, false)) {
            zzcfk2.zzyz().log("Failed to turn off database read permission");
        }
        if (!file.setWritable(false, false)) {
            zzcfk2.zzyz().log("Failed to turn off database write permission");
        }
        if (!file.setReadable(true, true)) {
            zzcfk2.zzyz().log("Failed to turn on database read permission for owner");
        }
        if (!file.setWritable(true, true)) {
            zzcfk2.zzyz().log("Failed to turn on database write permission for owner");
        }
    }

    static /* synthetic */ zzcje zza(zzcem zzcem2) {
        return zzcem2.zzbpt;
    }

    static /* synthetic */ Map zzyl() {
        return zzbpn;
    }

    static /* synthetic */ Map zzym() {
        return zzbpo;
    }

    static /* synthetic */ Map zzyn() {
        return zzbpq;
    }

    static /* synthetic */ Map zzyo() {
        return zzbpp;
    }

    static /* synthetic */ Map zzyp() {
        return zzbpr;
    }

    static {
        zzbpn.put("origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;");
        zzbpo = new ArrayMap(18);
        zzbpo.put("app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;");
        zzbpo.put("app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;");
        zzbpo.put("gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;");
        zzbpo.put("dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;");
        zzbpo.put("measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;");
        zzbpo.put("last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;");
        zzbpo.put("day", "ALTER TABLE apps ADD COLUMN day INTEGER;");
        zzbpo.put("daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;");
        zzbpo.put("daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;");
        zzbpo.put("daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;");
        zzbpo.put("remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;");
        zzbpo.put("config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;");
        zzbpo.put("failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;");
        zzbpo.put("app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;");
        zzbpo.put("firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;");
        zzbpo.put("daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;");
        zzbpo.put("daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;");
        zzbpo.put("health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;");
        zzbpo.put("android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;");
        zzbpp = new ArrayMap(1);
        zzbpp.put("realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;");
        zzbpq = new ArrayMap(1);
        zzbpq.put("has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;");
        zzbpr = new ArrayMap(1);
        zzbpr.put("previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;");
    }
}

