/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.zzcel;
import com.google.android.gms.internal.zzcfa;
import com.google.android.gms.internal.zzcfx;
import com.google.android.gms.internal.zzcfy;
import com.google.android.gms.internal.zzcfz;
import com.google.android.gms.internal.zzcga;
import com.google.android.gms.internal.zzcgk;
import com.google.android.gms.internal.zzchi;
import com.google.android.gms.internal.zzcjk;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzcfv
extends zzchi {
    static final Pair<String, Long> zzbri = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzaix;
    public final zzcfz zzbrj = new zzcfz(this, "health_monitor", zzcel.zzxK(), null);
    public final zzcfy zzbrk = new zzcfy(this, "last_upload", 0L);
    public final zzcfy zzbrl = new zzcfy(this, "last_upload_attempt", 0L);
    public final zzcfy zzbrm = new zzcfy(this, "backoff", 0L);
    public final zzcfy zzbrn = new zzcfy(this, "last_delete_stale", 0L);
    public final zzcfy zzbro;
    public final zzcfy zzbrp;
    public final zzcga zzbrq;
    private String zzbrr;
    private boolean zzbrs;
    private long zzbrt;
    private String zzbru;
    private long zzbrv;
    private final Object zzbrw;
    public final zzcfy zzbrx = new zzcfy(this, "time_before_start", 10000L);
    public final zzcfy zzbry = new zzcfy(this, "session_timeout", 1800000L);
    public final zzcfx zzbrz = new zzcfx(this, "start_new_session", true);
    public final zzcfy zzbrA = new zzcfy(this, "last_pause_time", 0L);
    public final zzcfy zzbrB = new zzcfy(this, "time_active", 0L);
    public boolean zzbrC;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zzeb(String string) {
        this.zzjC();
        long l = this.zzkq().elapsedRealtime();
        if (this.zzbrr != null && l < this.zzbrt) {
            return new Pair((Object)this.zzbrr, (Object)this.zzbrs);
        }
        String string2 = string;
        this.zzbrt = l + this.zzwH().zza(string2, zzcfa.zzbpW);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            if (info != null) {
                this.zzbrr = info.getId();
                this.zzbrs = info.isLimitAdTrackingEnabled();
            }
            if (this.zzbrr == null) {
                this.zzbrr = "";
            }
        }
        catch (Throwable throwable) {
            this.zzwF().zzyC().zzj("Unable to get advertising id", throwable);
            this.zzbrr = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzbrr, (Object)this.zzbrs);
    }

    @WorkerThread
    final String zzec(String string) {
        this.zzjC();
        String string2 = (String)this.zzeb((String)string).first;
        MessageDigest messageDigest = zzcjk.zzbE("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzcfv(zzcgk zzcgk2) {
        super(zzcgk2);
        this.zzbro = new zzcfy(this, "midnight_offset", 0L);
        this.zzbrp = new zzcfy(this, "first_open_time", 0L);
        this.zzbrq = new zzcga(this, "app_instance_id", null);
        this.zzbrw = new Object();
    }

    @Override
    protected final void zzjD() {
        this.zzaix = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzbrC = this.zzaix.getBoolean("has_been_opened", false);
        if (!this.zzbrC) {
            SharedPreferences.Editor editor = this.zzaix.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
    }

    @WorkerThread
    private final SharedPreferences zzyF() {
        this.zzjC();
        this.zzkD();
        return this.zzaix;
    }

    @WorkerThread
    final void zzed(String string) {
        this.zzjC();
        SharedPreferences.Editor editor = this.zzyF().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzyG() {
        this.zzjC();
        return this.zzyF().getString("gmp_app_id", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzee(String string) {
        Object object = this.zzbrw;
        synchronized (object) {
            this.zzbru = string;
            this.zzbrv = this.zzkq().elapsedRealtime();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzyH() {
        Object object = this.zzbrw;
        synchronized (object) {
            if (Math.abs(this.zzkq().elapsedRealtime() - this.zzbrv) < 1000L) {
                return this.zzbru;
            }
            return null;
        }
    }

    @WorkerThread
    final Boolean zzyI() {
        this.zzjC();
        if (!this.zzyF().contains("use_service")) {
            return null;
        }
        return this.zzyF().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zzak(boolean bl) {
        this.zzjC();
        this.zzwF().zzyD().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzyF().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzyJ() {
        this.zzjC();
        this.zzwF().zzyD().log("Clearing collection preferences.");
        boolean bl = this.zzyF().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzal(true);
        }
        SharedPreferences.Editor editor = this.zzyF().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    final void setMeasurementEnabled(boolean bl) {
        this.zzjC();
        this.zzwF().zzyD().zzj("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzyF().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzal(boolean bl) {
        this.zzjC();
        return this.zzyF().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected final String zzyK() {
        this.zzjC();
        String string = this.zzyF().getString("previous_os_version", null);
        this.zzwv().zzkD();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzyF().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    static /* synthetic */ SharedPreferences zza(zzcfv zzcfv2) {
        return zzcfv2.zzaix;
    }

    static /* synthetic */ SharedPreferences zzb(zzcfv zzcfv2) {
        return zzcfv2.zzyF();
    }
}

