/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.util.zzw;
import com.google.android.gms.common.zzo;
import com.google.android.gms.common.zzp;
import com.google.android.gms.internal.zzceg;
import com.google.android.gms.internal.zzcej;
import com.google.android.gms.internal.zzcey;
import com.google.android.gms.internal.zzcfd;
import com.google.android.gms.internal.zzcfk;
import com.google.android.gms.internal.zzcgk;
import com.google.android.gms.internal.zzcgq;
import com.google.android.gms.internal.zzcgr;
import com.google.android.gms.internal.zzcgs;
import com.google.android.gms.internal.zzcgt;
import com.google.android.gms.internal.zzcgu;
import com.google.android.gms.internal.zzcgv;
import com.google.android.gms.internal.zzcgw;
import com.google.android.gms.internal.zzcgx;
import com.google.android.gms.internal.zzcgy;
import com.google.android.gms.internal.zzcgz;
import com.google.android.gms.internal.zzcha;
import com.google.android.gms.internal.zzchb;
import com.google.android.gms.internal.zzchc;
import com.google.android.gms.internal.zzchd;
import com.google.android.gms.internal.zzche;
import com.google.android.gms.internal.zzchf;
import com.google.android.gms.internal.zzchg;
import com.google.android.gms.internal.zzcjh;
import com.google.android.gms.internal.zzcjj;
import com.google.android.gms.internal.zzcjk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzcgp
extends zzcfd {
    private final zzcgk zzboe;
    private Boolean zzbtc;
    @Nullable
    private String zzbtd;

    public zzcgp(zzcgk zzcgk2) {
        this(zzcgk2, null);
    }

    private zzcgp(zzcgk zzcgk2, @Nullable String string) {
        zzbo.zzu((Object)zzcgk2);
        this.zzboe = zzcgk2;
        this.zzbtd = null;
    }

    @Override
    @BinderThread
    public final void zzb(zzceg zzceg2) {
        this.zzb(zzceg2, false);
        this.zzboe.zzwE().zzj(new zzcgq(this, zzceg2));
    }

    @Override
    @BinderThread
    public final void zza(zzcey zzcey2, zzceg zzceg2) {
        zzbo.zzu((Object)((Object)zzcey2));
        this.zzb(zzceg2, false);
        this.zzboe.zzwE().zzj(new zzcgz(this, zzcey2, zzceg2));
    }

    @Override
    @BinderThread
    public final void zza(zzcey zzcey2, String string, String string2) {
        zzbo.zzu((Object)((Object)zzcey2));
        zzbo.zzcF((String)string);
        this.zzh(string, true);
        this.zzboe.zzwE().zzj(new zzcha(this, zzcey2, string));
    }

    @Override
    @BinderThread
    public final byte[] zza(zzcey zzcey2, String string) {
        zzbo.zzcF((String)string);
        zzbo.zzu((Object)((Object)zzcey2));
        this.zzh(string, true);
        this.zzboe.zzwF().zzyC().zzj("Log and bundle. event", this.zzboe.zzwA().zzdW(zzcey2.name));
        long l = this.zzboe.zzkq().nanoTime() / 1000000L;
        Future<byte[]> future = this.zzboe.zzwE().zzf(new zzchb(this, zzcey2, string));
        try {
            byte[] byArray = future.get();
            if (byArray == null) {
                this.zzboe.zzwF().zzyx().zzj("Log and bundle returned null. appId", zzcfk.zzdZ(string));
                byArray = new byte[]{};
            }
            long l2 = this.zzboe.zzkq().nanoTime() / 1000000L;
            this.zzboe.zzwF().zzyC().zzd("Log and bundle processed. event, size, time_ms", this.zzboe.zzwA().zzdW(zzcey2.name), byArray.length, l2 - l);
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzboe.zzwF().zzyx().zzd("Failed to log and bundle. appId, event, error", zzcfk.zzdZ(string), this.zzboe.zzwA().zzdW(zzcey2.name), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzcjh zzcjh2, zzceg zzceg2) {
        zzbo.zzu((Object)((Object)zzcjh2));
        this.zzb(zzceg2, false);
        if (zzcjh2.getValue() == null) {
            this.zzboe.zzwE().zzj(new zzchc(this, zzcjh2, zzceg2));
            return;
        }
        this.zzboe.zzwE().zzj(new zzchd(this, zzcjh2, zzceg2));
    }

    @Override
    @BinderThread
    public final List<zzcjh> zza(zzceg zzceg2, boolean bl) {
        this.zzb(zzceg2, false);
        Future<List<zzcjj>> future = this.zzboe.zzwE().zze(new zzche(this, zzceg2));
        try {
            List<zzcjj> list = future.get();
            ArrayList<zzcjh> arrayList = new ArrayList<zzcjh>(list.size());
            for (zzcjj zzcjj2 : list) {
                if (!bl && zzcjk.zzex(zzcjj2.mName)) continue;
                arrayList.add(new zzcjh(zzcjj2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzboe.zzwF().zzyx().zze("Failed to get user attributes. appId", zzcfk.zzdZ(zzceg2.packageName), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzceg zzceg2) {
        this.zzb(zzceg2, false);
        zzchf zzchf2 = new zzchf(this, zzceg2);
        if (this.zzboe.zzwE().zzyM()) {
            zzchf2.run();
            return;
        }
        this.zzboe.zzwE().zzj(zzchf2);
    }

    @BinderThread
    private final void zzb(zzceg zzceg2, boolean bl) {
        zzbo.zzu((Object)((Object)zzceg2));
        this.zzh(zzceg2.packageName, false);
        this.zzboe.zzwB().zzev(zzceg2.zzboQ);
    }

    @BinderThread
    private final void zzh(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzboe.zzwF().zzyx().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzcgp zzcgp2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzcgp2 = this;
                    if (!bl2) break block9;
                    if (zzcgp2.zzbtc == null) {
                        zzcgp2.zzbtc = "com.google.android.gms".equals(zzcgp2.zzbtd) || zzw.zzf((Context)zzcgp2.zzboe.getContext(), (int)Binder.getCallingUid()) || zzp.zzax((Context)zzcgp2.zzboe.getContext()).zza(zzcgp2.zzboe.getContext().getPackageManager(), Binder.getCallingUid());
                    }
                    if (zzcgp2.zzbtc.booleanValue()) break block10;
                }
                if (zzcgp2.zzbtd == null && zzo.zzb((Context)zzcgp2.zzboe.getContext(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzcgp2.zzbtd = string2;
                }
                if (!string2.equals(zzcgp2.zzbtd)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zzboe.zzwF().zzyx().zzj("Measurement Service called with invalid calling package. appId", zzcfk.zzdZ(string));
            throw securityException;
        }
    }

    @Override
    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zzboe.zzwE().zzj(new zzchg(this, string2, string3, string, l));
    }

    @Override
    @BinderThread
    public final String zzc(zzceg zzceg2) {
        this.zzb(zzceg2, false);
        return this.zzboe.zzem(zzceg2.packageName);
    }

    @Override
    @BinderThread
    public final void zza(zzcej zzcej2, zzceg zzceg2) {
        zzbo.zzu((Object)((Object)zzcej2));
        zzbo.zzu((Object)((Object)zzcej2.zzbpd));
        this.zzb(zzceg2, false);
        zzcej zzcej3 = new zzcej(zzcej2);
        new zzcej(zzcej2).packageName = zzceg2.packageName;
        if (zzcej2.zzbpd.getValue() == null) {
            this.zzboe.zzwE().zzj(new zzcgr(this, zzcej3, zzceg2));
            return;
        }
        this.zzboe.zzwE().zzj(new zzcgs(this, zzcej3, zzceg2));
    }

    @Override
    @BinderThread
    public final void zzb(zzcej zzcej2) {
        zzbo.zzu((Object)((Object)zzcej2));
        zzbo.zzu((Object)((Object)zzcej2.zzbpd));
        this.zzh(zzcej2.packageName, true);
        zzcej zzcej3 = new zzcej(zzcej2);
        if (zzcej2.zzbpd.getValue() == null) {
            this.zzboe.zzwE().zzj(new zzcgt(this, zzcej3));
            return;
        }
        this.zzboe.zzwE().zzj(new zzcgu(this, zzcej3));
    }

    @Override
    @BinderThread
    public final List<zzcjh> zza(String string, String string2, boolean bl, zzceg zzceg2) {
        this.zzb(zzceg2, false);
        Future<List<zzcjj>> future = this.zzboe.zzwE().zze(new zzcgv(this, zzceg2, string, string2));
        try {
            List<zzcjj> list = future.get();
            ArrayList<zzcjh> arrayList = new ArrayList<zzcjh>(list.size());
            for (zzcjj zzcjj2 : list) {
                if (!bl && zzcjk.zzex(zzcjj2.mName)) continue;
                arrayList.add(new zzcjh(zzcjj2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzboe.zzwF().zzyx().zze("Failed to get user attributes. appId", zzcfk.zzdZ(zzceg2.packageName), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcjh> zza(String string, String string2, String string3, boolean bl) {
        this.zzh(string, true);
        Future<List<zzcjj>> future = this.zzboe.zzwE().zze(new zzcgw(this, string, string2, string3));
        try {
            List<zzcjj> list = future.get();
            ArrayList<zzcjh> arrayList = new ArrayList<zzcjh>(list.size());
            for (zzcjj zzcjj2 : list) {
                if (!bl && zzcjk.zzex(zzcjj2.mName)) continue;
                arrayList.add(new zzcjh(zzcjj2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzboe.zzwF().zzyx().zze("Failed to get user attributes. appId", zzcfk.zzdZ(string), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcej> zza(String string, String string2, zzceg zzceg2) {
        this.zzb(zzceg2, false);
        Future<List<zzcej>> future = this.zzboe.zzwE().zze(new zzcgx(this, zzceg2, string, string2));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzboe.zzwF().zzyx().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcej> zzk(String string, String string2, String string3) {
        this.zzh(string, true);
        Future<List<zzcej>> future = this.zzboe.zzwE().zze(new zzcgy(this, string, string2, string3));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzboe.zzwF().zzyx().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    static /* synthetic */ zzcgk zza(zzcgp zzcgp2) {
        return zzcgp2.zzboe;
    }
}

