/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzcej;
import com.google.android.gms.internal.zzcel;
import com.google.android.gms.internal.zzceq;
import com.google.android.gms.internal.zzcey;
import com.google.android.gms.internal.zzcfc;
import com.google.android.gms.internal.zzcgk;
import com.google.android.gms.internal.zzchi;
import com.google.android.gms.internal.zzcid;
import com.google.android.gms.internal.zzcie;
import com.google.android.gms.internal.zzcif;
import com.google.android.gms.internal.zzcig;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzcij;
import com.google.android.gms.internal.zzcik;
import com.google.android.gms.internal.zzcil;
import com.google.android.gms.internal.zzcim;
import com.google.android.gms.internal.zzcin;
import com.google.android.gms.internal.zzcio;
import com.google.android.gms.internal.zzcip;
import com.google.android.gms.internal.zzcje;
import com.google.android.gms.internal.zzcjh;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class zzcic
extends zzchi {
    private final zzcip zzbtT;
    private zzcfc zzbtU;
    private Boolean zzbtV;
    private final zzceq zzbtW;
    private final zzcje zzbtX;
    private final List<Runnable> zzbtY = new ArrayList<Runnable>();
    private final zzceq zzbtZ;

    protected zzcic(zzcgk zzcgk2) {
        super(zzcgk2);
        this.zzbtX = new zzcje(zzcgk2.zzkq());
        this.zzbtT = new zzcip(this);
        this.zzbtW = new zzcid(this, zzcgk2);
        this.zzbtZ = new zzcih(this, zzcgk2);
    }

    @Override
    protected final void zzjD() {
    }

    @WorkerThread
    public final boolean isConnected() {
        super.zzjC();
        this.zzkD();
        return this.zzbtU != null;
    }

    @WorkerThread
    protected final void zzzj() {
        super.zzjC();
        this.zzkD();
        this.zzm(new zzcii(this));
    }

    @WorkerThread
    final void zza(zzcfc zzcfc2, com.google.android.gms.common.internal.safeparcel.zza zza2) {
        super.zzjC();
        super.zzwp();
        this.zzkD();
        zzcel.zzxE();
        ArrayList<com.google.android.gms.common.internal.safeparcel.zza> arrayList = new ArrayList<com.google.android.gms.common.internal.safeparcel.zza>();
        int n = 100;
        zzcel.zzxN();
        for (int i = 0; i < 1001 && n == 100; ++i) {
            n = 0;
            List<com.google.android.gms.common.internal.safeparcel.zza> list = super.zzwy().zzbp(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (zza2 != null && n < 100) {
                arrayList.add(zza2);
            }
            ArrayList<com.google.android.gms.common.internal.safeparcel.zza> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                com.google.android.gms.common.internal.safeparcel.zza zza3 = (com.google.android.gms.common.internal.safeparcel.zza)e;
                if (zza3 instanceof zzcey) {
                    try {
                        zzcfc2.zza((zzcey)zza3, super.zzwu().zzdV(super.zzwF().zzyE()));
                    }
                    catch (RemoteException remoteException) {
                        super.zzwF().zzyx().zzj("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zza3 instanceof zzcjh) {
                    try {
                        zzcfc2.zza((zzcjh)zza3, super.zzwu().zzdV(super.zzwF().zzyE()));
                    }
                    catch (RemoteException remoteException) {
                        super.zzwF().zzyx().zzj("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zza3 instanceof zzcej) {
                    try {
                        zzcfc2.zza((zzcej)zza3, super.zzwu().zzdV(super.zzwF().zzyE()));
                    }
                    catch (RemoteException remoteException) {
                        super.zzwF().zzyx().zzj("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                super.zzwF().zzyx().log("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zzc(zzcey zzcey2, String string) {
        zzbo.zzu((Object)((Object)zzcey2));
        super.zzjC();
        this.zzkD();
        zzcel.zzxE();
        boolean bl = super.zzwy().zza(zzcey2);
        this.zzm(new zzcij(this, true, bl, zzcey2, string));
    }

    @WorkerThread
    protected final void zzf(zzcej zzcej2) {
        zzbo.zzu((Object)((Object)zzcej2));
        super.zzjC();
        this.zzkD();
        zzcel.zzxE();
        boolean bl = super.zzwy().zzc(zzcej2);
        zzcej zzcej3 = new zzcej(zzcej2);
        this.zzm(new zzcik(this, true, bl, zzcej3, zzcej2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcej>> atomicReference, String string, String string2, String string3) {
        super.zzjC();
        this.zzkD();
        this.zzm(new zzcil(this, atomicReference, string, string2, string3));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcjh>> atomicReference, String string, String string2, String string3, boolean bl) {
        super.zzjC();
        this.zzkD();
        this.zzm(new zzcim(this, atomicReference, string, string2, string3, bl));
    }

    @WorkerThread
    protected final void zzb(zzcjh zzcjh2) {
        super.zzjC();
        this.zzkD();
        zzcel.zzxE();
        boolean bl = super.zzwy().zza(zzcjh2);
        this.zzm(new zzcin(this, bl, zzcjh2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcjh>> atomicReference, boolean bl) {
        super.zzjC();
        this.zzkD();
        this.zzm(new zzcio(this, atomicReference, bl));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        super.zzjC();
        this.zzkD();
        this.zzm(new zzcie(this, atomicReference));
    }

    @WorkerThread
    protected final void zzzk() {
        super.zzjC();
        this.zzkD();
        this.zzm(new zzcif(this));
    }

    @WorkerThread
    protected final void zza(AppMeasurement.zzb zzb2) {
        super.zzjC();
        this.zzkD();
        this.zzm(new zzcig(this, zzb2));
    }

    @WorkerThread
    private final void zzkP() {
        super.zzjC();
        this.zzbtX.start();
        this.zzbtW.zzs(zzcel.zzxB());
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzla() {
        zzcic zzcic2;
        block11: {
            boolean bl;
            block12: {
                super.zzjC();
                this.zzkD();
                if (this.isConnected()) {
                    return;
                }
                if (this.zzbtV != null) break block11;
                this.zzbtV = super.zzwG().zzyI();
                if (this.zzbtV != null) break block11;
                super.zzwF().zzyD().log("State of service unknown");
                zzcic2 = this;
                super.zzjC();
                zzcic2.zzkD();
                zzcel.zzxE();
                super.zzwF().zzyD().log("Checking service availability");
                switch (zze.zzoW().isGooglePlayServicesAvailable(super.getContext())) {
                    case 0: {
                        super.zzwF().zzyD().log("Service available");
                        bl = true;
                        break block12;
                    }
                    case 1: {
                        super.zzwF().zzyD().log("Service missing");
                        break;
                    }
                    case 18: {
                        super.zzwF().zzyz().log("Service updating");
                        bl = true;
                        break block12;
                    }
                    case 2: {
                        super.zzwF().zzyC().log("Service container out of date");
                        bl = true;
                        break block12;
                    }
                    case 3: {
                        super.zzwF().zzyz().log("Service disabled");
                        break;
                    }
                    case 9: {
                        super.zzwF().zzyz().log("Service invalid");
                    }
                }
                bl = false;
            }
            this.zzbtV = bl;
            super.zzwG().zzak(this.zzbtV);
        }
        if (this.zzbtV.booleanValue()) {
            super.zzwF().zzyD().log("Using measurement service");
            this.zzbtT.zzzm();
            return;
        }
        zzcic2 = this;
        zzcel.zzxE();
        PackageManager packageManager = super.getContext().getPackageManager();
        Intent intent = new Intent().setClassName(super.getContext(), "com.google.android.gms.measurement.AppMeasurementService");
        List list = packageManager.queryIntentServices(intent, 65536);
        if (list != null && list.size() > 0) {
            super.zzwF().zzyD().log("Using local app measurement service");
            Intent intent2 = new Intent("com.google.android.gms.measurement.START");
            Context context = super.getContext();
            zzcel.zzxE();
            intent2.setComponent(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementService"));
            this.zzbtT.zzk(intent2);
            return;
        }
        super.zzwF().zzyx().log("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
    }

    @WorkerThread
    protected final void zza(zzcfc zzcfc2) {
        super.zzjC();
        zzbo.zzu((Object)zzcfc2);
        this.zzbtU = zzcfc2;
        this.zzkP();
        this.zzzl();
    }

    @WorkerThread
    public final void disconnect() {
        super.zzjC();
        this.zzkD();
        try {
            zza.zzrU();
            zzcip zzcip2 = this.zzbtT;
            Context context = super.getContext();
            context.unbindService((ServiceConnection)zzcip2);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzbtU = null;
    }

    @WorkerThread
    private final void onServiceDisconnected(ComponentName componentName) {
        super.zzjC();
        if (this.zzbtU != null) {
            this.zzbtU = null;
            super.zzwF().zzyD().zzj("Disconnected from device MeasurementService", componentName);
            zzcic zzcic2 = this;
            super.zzjC();
            zzcic2.zzla();
        }
    }

    @WorkerThread
    private final void zzkQ() {
        super.zzjC();
        if (!this.isConnected()) {
            return;
        }
        super.zzwF().zzyD().log("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private final void zzm(Runnable runnable) throws IllegalStateException {
        super.zzjC();
        if (this.isConnected()) {
            runnable.run();
            return;
        }
        if ((long)this.zzbtY.size() >= zzcel.zzxJ()) {
            super.zzwF().zzyx().log("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzbtY.add(runnable);
        this.zzbtZ.zzs(60000L);
        this.zzla();
    }

    @WorkerThread
    private final void zzzl() {
        super.zzjC();
        super.zzwF().zzyD().zzj("Processing queued up service tasks", this.zzbtY.size());
        for (Runnable runnable : this.zzbtY) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                super.zzwF().zzyx().zzj("Task exception while flushing queue", throwable);
            }
        }
        this.zzbtY.clear();
        this.zzbtZ.cancel();
    }

    static /* synthetic */ zzcip zza(zzcic zzcic2) {
        return zzcic2.zzbtT;
    }

    static /* synthetic */ void zza(zzcic zzcic2, ComponentName componentName) {
        zzcic2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ zzcfc zza(zzcic zzcic2, zzcfc zzcfc2) {
        zzcic2.zzbtU = null;
        return null;
    }

    static /* synthetic */ void zzb(zzcic zzcic2) {
        zzcic2.zzzl();
    }

    static /* synthetic */ void zzc(zzcic zzcic2) {
        zzcic2.zzkQ();
    }

    static /* synthetic */ zzcfc zzd(zzcic zzcic2) {
        return zzcic2.zzbtU;
    }

    static /* synthetic */ void zze(zzcic zzcic2) {
        zzcic2.zzkP();
    }
}

