/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.internal.zzbdm;
import com.google.android.gms.internal.zzbgy;
import com.google.android.gms.internal.zzceh;
import com.google.android.gms.internal.zzcem;
import com.google.android.gms.internal.zzcfl;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzchj;
import com.google.firebase.iid.FirebaseInstanceId;
import java.math.BigInteger;
import java.util.Locale;

public final class zzcfg
extends zzchj {
    private String mAppId;
    private String zzaeI;
    private int zzbqC;
    private String zzboB;
    private String zzaeH;
    private long zzbqD;
    private long zzboF;
    private int zzbqE;
    private String zzXB;

    zzcfg(zzcgl zzcgl2) {
        super(zzcgl2);
    }

    @Override
    protected final void zzjD() {
        Object object;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = super.getContext().getPackageName();
        PackageManager packageManager = super.getContext().getPackageManager();
        if (packageManager == null) {
            super.zzwF().zzyx().zzj("PackageManager is null, app identity information might be inaccurate. appId", zzcfl.zzdZ(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                super.zzwF().zzyx().zzj("Error retrieving app installer package name. appId", zzcfl.zzdZ(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(super.getContext().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                super.zzwF().zzyx().zze("Error retrieving package info. appId, appName", zzcfl.zzdZ(string4), string3);
            }
        }
        this.mAppId = string4;
        this.zzboB = string;
        this.zzaeI = string2;
        this.zzbqC = n;
        this.zzaeH = string3;
        this.zzbqD = 0L;
        zzcem.zzxE();
        packageInfo = zzbdm.zzaz((Context)super.getContext());
        boolean bl = packageInfo != null && packageInfo.isSuccess();
        if (!bl) {
            PackageInfo packageInfo2 = packageInfo;
            zzcfg zzcfg2 = this;
            if (packageInfo2 == null) {
                super.zzwF().zzyx().log("GoogleService failed to initialize (no status)");
            } else {
                super.zzwF().zzyx().zze("GoogleService failed to initialize, status", packageInfo2.getStatusCode(), packageInfo2.getStatusMessage());
            }
        }
        boolean bl2 = false;
        if (bl) {
            object = super.zzwH().zzdN("firebase_analytics_collection_enabled");
            if (super.zzwH().zzxF()) {
                super.zzwF().zzyB().log("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                super.zzwF().zzyB().log("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && zzcem.zzqB()) {
                super.zzwF().zzyB().log("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl2 = true;
                super.zzwF().zzyD().log("Collection enabled");
            }
        }
        this.zzXB = "";
        this.zzboF = 0L;
        zzcem.zzxE();
        try {
            object = zzbdm.zzqA();
            Object object2 = this.zzXB = TextUtils.isEmpty((CharSequence)object) ? "" : object;
            if (bl2) {
                super.zzwF().zzyD().zze("App package, google app id", this.mAppId, this.zzXB);
            }
        }
        catch (IllegalStateException illegalStateException) {
            super.zzwF().zzyx().zze("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzcfl.zzdZ(string4), illegalStateException);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzbqE = zzbgy.zzaN((Context)super.getContext()) ? 1 : 0;
            return;
        }
        this.zzbqE = 0;
    }

    @WorkerThread
    final zzceh zzdV(String string) {
        super.zzjC();
        String string2 = this.zzhl();
        String string3 = this.getGmpAppId();
        zzcfg zzcfg2 = this;
        zzcfg2.zzkD();
        String string4 = zzcfg2.zzaeI;
        long l = this.zzyv();
        zzcfg2 = this;
        zzcfg2.zzkD();
        String string5 = zzcfg2.zzboB;
        long l2 = zzcem.zzwP();
        zzcfg2 = this;
        zzcfg2.zzkD();
        super.zzjC();
        if (zzcfg2.zzbqD == 0L) {
            zzcfg2.zzbqD = zzcfg2.zzboe.zzwB().zzI(super.getContext(), super.getContext().getPackageName());
        }
        long l3 = zzcfg2.zzbqD;
        boolean bl = this.zzboe.isEnabled();
        boolean bl2 = !super.zzwG().zzbrC;
        String string6 = this.zzwK();
        this.zzkD();
        long l4 = this.zzboe.zzyY();
        zzcfg2 = this;
        zzcfg2.zzkD();
        return new zzceh(string2, string3, string4, l, string5, l2, l3, string, bl, bl2, string6, 0L, l4, zzcfg2.zzbqE);
    }

    @WorkerThread
    final String zzyu() {
        byte[] byArray = new byte[16];
        super.zzwB().zzzt().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    private final String zzwK() {
        super.zzjC();
        try {
            return FirebaseInstanceId.getInstance().getId();
        }
        catch (IllegalStateException illegalStateException) {
            super.zzwF().zzyz().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String zzhl() {
        this.zzkD();
        return this.mAppId;
    }

    final String getGmpAppId() {
        this.zzkD();
        return this.zzXB;
    }

    final int zzyv() {
        this.zzkD();
        return this.zzbqC;
    }
}

