/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.internal.adg;
import com.google.android.gms.internal.adh;
import com.google.android.gms.internal.zzbha;
import com.google.android.gms.internal.zzcec;
import com.google.android.gms.internal.zzceg;
import com.google.android.gms.internal.zzceh;
import com.google.android.gms.internal.zzcej;
import com.google.android.gms.internal.zzcek;
import com.google.android.gms.internal.zzcem;
import com.google.android.gms.internal.zzcen;
import com.google.android.gms.internal.zzceo;
import com.google.android.gms.internal.zzcep;
import com.google.android.gms.internal.zzcet;
import com.google.android.gms.internal.zzceu;
import com.google.android.gms.internal.zzcev;
import com.google.android.gms.internal.zzcew;
import com.google.android.gms.internal.zzcez;
import com.google.android.gms.internal.zzcfb;
import com.google.android.gms.internal.zzcfg;
import com.google.android.gms.internal.zzcfh;
import com.google.android.gms.internal.zzcfj;
import com.google.android.gms.internal.zzcfl;
import com.google.android.gms.internal.zzcfn;
import com.google.android.gms.internal.zzcfp;
import com.google.android.gms.internal.zzcfu;
import com.google.android.gms.internal.zzcfw;
import com.google.android.gms.internal.zzcgc;
import com.google.android.gms.internal.zzcgf;
import com.google.android.gms.internal.zzcgg;
import com.google.android.gms.internal.zzcgm;
import com.google.android.gms.internal.zzcgn;
import com.google.android.gms.internal.zzcgo;
import com.google.android.gms.internal.zzcgp;
import com.google.android.gms.internal.zzchi;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzchk;
import com.google.android.gms.internal.zzchl;
import com.google.android.gms.internal.zzchy;
import com.google.android.gms.internal.zzchz;
import com.google.android.gms.internal.zzcid;
import com.google.android.gms.internal.zzciw;
import com.google.android.gms.internal.zzcja;
import com.google.android.gms.internal.zzcjg;
import com.google.android.gms.internal.zzcji;
import com.google.android.gms.internal.zzcjk;
import com.google.android.gms.internal.zzcjl;
import com.google.android.gms.internal.zzcjt;
import com.google.android.gms.internal.zzcjv;
import com.google.android.gms.internal.zzcjw;
import com.google.android.gms.internal.zzcjx;
import com.google.android.gms.internal.zzcjy;
import com.google.android.gms.internal.zzcjz;
import com.google.android.gms.internal.zzckb;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class zzcgl {
    private static volatile zzcgl zzbsm;
    private final Context mContext;
    private final zzcem zzbsn;
    private final zzcfw zzbso;
    private final zzcfl zzbsp;
    private final zzcgg zzbsq;
    private final zzcja zzbsr;
    private final zzcgf zzbss;
    private final AppMeasurement zzbst;
    private final FirebaseAnalytics zzbsu;
    private final zzcjl zzbsv;
    private final zzcfj zzbsw;
    private final zzcen zzbsx;
    private final zzcfh zzbsy;
    private final zzcfp zzbsz;
    private final zze zzvw;
    private final zzchz zzbsA;
    private final zzcid zzbsB;
    private final zzcet zzbsC;
    private final zzchl zzbsD;
    private final zzcfg zzbsE;
    private final zzcfu zzbsF;
    private final zzcjg zzbsG;
    private final zzcej zzbsH;
    private final zzcec zzbsI;
    private final boolean zzafK;
    private boolean zzbsJ;
    private Boolean zzbsK;
    private long zzbsL;
    private FileLock zzbsM;
    private FileChannel zzbsN;
    private List<Long> zzbsO;
    private List<Runnable> zzbsP;
    private int zzbsQ;
    private int zzbsR;
    private long zzbsS;
    private long zzbsT;
    private boolean zzbsU;
    private boolean zzbsV;
    private boolean zzbsW;
    private final long zzbsX;

    private zzcgl(zzchk zzchk2) {
        zzcec zzcec2;
        String string;
        zzcfn zzcfn2;
        zzbo.zzu((Object)zzchk2);
        this.mContext = zzchk2.mContext;
        this.zzbsS = -1L;
        this.zzvw = zzi.zzrY();
        this.zzbsX = this.zzvw.currentTimeMillis();
        Object object = this;
        this.zzbsn = new zzcem((zzcgl)object);
        object = this;
        zzcfw zzcfw2 = new zzcfw((zzcgl)object);
        zzcfw2.initialize();
        this.zzbso = zzcfw2;
        object = this;
        zzcfl zzcfl2 = new zzcfl((zzcgl)object);
        zzcfl2.initialize();
        this.zzbsp = zzcfl2;
        this.zzwF().zzyB().zzj("App measurement is starting up, version", zzcem.zzwP());
        zzcem.zzxE();
        this.zzwF().zzyB().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        object = this;
        zzcjl zzcjl2 = new zzcjl((zzcgl)object);
        zzcjl2.initialize();
        this.zzbsv = zzcjl2;
        object = this;
        zzcfj zzcfj2 = new zzcfj((zzcgl)object);
        zzcfj2.initialize();
        this.zzbsw = zzcfj2;
        object = this;
        zzcet zzcet2 = new zzcet((zzcgl)object);
        zzcet2.initialize();
        this.zzbsC = zzcet2;
        object = this;
        zzcfg zzcfg2 = new zzcfg((zzcgl)object);
        zzcfg2.initialize();
        this.zzbsE = zzcfg2;
        zzcem.zzxE();
        Object object2 = zzcfg2.zzhl();
        if (this.zzwB().zzey((String)object2)) {
            zzcfn2 = this.zzwF().zzyB();
            string = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
        } else {
            zzcfn2 = this.zzwF().zzyB();
            String string2 = String.valueOf(object2);
            string = string2.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string2) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
        }
        zzcfn2.log(string);
        this.zzwF().zzyC().log("Debug-level message logging enabled");
        object = this;
        object2 = new zzcen((zzcgl)object);
        ((zzchj)object2).initialize();
        this.zzbsx = object2;
        object = this;
        zzcfh zzcfh2 = new zzcfh((zzcgl)object);
        zzcfh2.initialize();
        this.zzbsy = zzcfh2;
        object = this;
        zzcej zzcej2 = new zzcej((zzcgl)object);
        zzcej2.initialize();
        this.zzbsH = zzcej2;
        object = this;
        this.zzbsI = zzcec2 = new zzcec((zzcgl)object);
        object = this;
        zzcfp zzcfp2 = new zzcfp((zzcgl)object);
        zzcfp2.initialize();
        this.zzbsz = zzcfp2;
        object = this;
        zzchz zzchz2 = new zzchz((zzcgl)object);
        zzchz2.initialize();
        this.zzbsA = zzchz2;
        object = this;
        zzcid zzcid2 = new zzcid((zzcgl)object);
        zzcid2.initialize();
        this.zzbsB = zzcid2;
        object = this;
        zzchl zzchl2 = new zzchl((zzcgl)object);
        zzchl2.initialize();
        this.zzbsD = zzchl2;
        object = this;
        zzcjg zzcjg2 = new zzcjg((zzcgl)object);
        zzcjg2.initialize();
        this.zzbsG = zzcjg2;
        object = this;
        this.zzbsF = new zzcfu((zzcgl)object);
        object = this;
        this.zzbst = new AppMeasurement((zzcgl)object);
        object = this;
        this.zzbsu = new FirebaseAnalytics((zzcgl)object);
        object = this;
        zzcja zzcja2 = new zzcja((zzcgl)object);
        zzcja2.initialize();
        this.zzbsr = zzcja2;
        object = this;
        zzcgf zzcgf2 = new zzcgf((zzcgl)object);
        zzcgf2.initialize();
        this.zzbss = zzcgf2;
        object = this;
        zzcgg zzcgg2 = new zzcgg((zzcgl)object);
        zzcgg2.initialize();
        this.zzbsq = zzcgg2;
        if (this.zzbsQ != this.zzbsR) {
            this.zzwF().zzyx().zze("Not all components initialized", this.zzbsQ, this.zzbsR);
        }
        this.zzafK = true;
        zzcem.zzxE();
        if (this.mContext.getApplicationContext() instanceof Application) {
            object = this.zzwt();
            if (((zzchl)object).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzchl)object).getContext().getApplicationContext();
                if (((zzchl)object).zzbto == null) {
                    ((zzchl)object).zzbto = new zzchy((zzchl)object, null);
                }
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzchl)object).zzbto);
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzchl)object).zzbto);
                ((zzchl)object).zzwF().zzyD().log("Registered activity lifecycle callback");
            }
        } else {
            this.zzwF().zzyz().log("Application context is not an Application");
        }
        this.zzbsq.zzj(new zzcgm(this));
    }

    final void zzkD() {
        if (!this.zzafK) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected final boolean zzyP() {
        this.zzkD();
        this.zzwE().zzjC();
        if (this.zzbsK == null || this.zzbsL == 0L || this.zzbsK != null && !this.zzbsK.booleanValue() && Math.abs(this.zzvw.elapsedRealtime() - this.zzbsL) > 1000L) {
            this.zzbsL = this.zzvw.elapsedRealtime();
            zzcem.zzxE();
            this.zzbsK = this.zzwB().zzbv("android.permission.INTERNET") && this.zzwB().zzbv("android.permission.ACCESS_NETWORK_STATE") && (zzbha.zzaP((Context)this.mContext).zzsl() || zzcgc.zzj(this.mContext, false) && zzciw.zzk(this.mContext, false));
            if (this.zzbsK.booleanValue()) {
                this.zzbsK = this.zzwB().zzev(this.zzwu().getGmpAppId());
            }
        }
        return this.zzbsK;
    }

    @WorkerThread
    protected final void start() {
        this.zzwE().zzjC();
        this.zzwz().zzye();
        if (this.zzwG().zzbrk.get() == 0L) {
            this.zzwG().zzbrk.set(this.zzvw.currentTimeMillis());
        }
        if (Long.valueOf(this.zzwG().zzbrp.get()) == 0L) {
            this.zzwF().zzyD().zzj("Persisting first open", this.zzbsX);
            this.zzwG().zzbrp.set(this.zzbsX);
        }
        if (!this.zzyP()) {
            if (this.isEnabled()) {
                if (!this.zzwB().zzbv("android.permission.INTERNET")) {
                    this.zzwF().zzyx().log("App is missing INTERNET permission");
                }
                if (!this.zzwB().zzbv("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzwF().zzyx().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzcem.zzxE();
                if (!zzbha.zzaP((Context)this.mContext).zzsl()) {
                    if (!zzcgc.zzj(this.mContext, false)) {
                        this.zzwF().zzyx().log("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzciw.zzk(this.mContext, false)) {
                        this.zzwF().zzyx().log("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzwF().zzyx().log("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzcem.zzxE();
            if (!TextUtils.isEmpty((CharSequence)this.zzwu().getGmpAppId())) {
                String string = this.zzwG().zzyG();
                if (string == null) {
                    this.zzwG().zzed(this.zzwu().getGmpAppId());
                } else if (!string.equals(this.zzwu().getGmpAppId())) {
                    this.zzwF().zzyB().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzwG().zzyJ();
                    this.zzbsB.disconnect();
                    this.zzbsB.zzla();
                    this.zzwG().zzed(this.zzwu().getGmpAppId());
                    this.zzwG().zzbrp.set(this.zzbsX);
                    this.zzwG().zzbrq.zzef(null);
                }
            }
            this.zzwt().zzee(this.zzwG().zzbrq.zzyL());
            zzcem.zzxE();
            if (!TextUtils.isEmpty((CharSequence)this.zzwu().getGmpAppId())) {
                zzchl zzchl2 = this.zzwt();
                zzchl2.zzjC();
                zzchl2.zzwp();
                zzchl2.zzkD();
                if (zzchl2.zzboe.zzyP()) {
                    zzchl2.zzww().zzzk();
                    String string = zzchl2.zzwG().zzyK();
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        zzchl2.zzwv().zzkD();
                        if (!string.equals(Build.VERSION.RELEASE)) {
                            Bundle bundle = new Bundle();
                            bundle.putString("_po", string);
                            zzchl2.zzd("auto", "_ou", bundle);
                        }
                    }
                }
                this.zzww().zza(new AtomicReference<String>());
            }
        }
        this.zzzc();
    }

    public final zzcem zzwH() {
        return this.zzbsn;
    }

    public final zzcfw zzwG() {
        zzcgl.zza((zzchi)this.zzbso);
        return this.zzbso;
    }

    public final zzcfl zzwF() {
        zzcgl.zza(this.zzbsp);
        return this.zzbsp;
    }

    public final zzcfl zzyQ() {
        if (this.zzbsp != null && this.zzbsp.isInitialized()) {
            return this.zzbsp;
        }
        return null;
    }

    public final zzcgg zzwE() {
        zzcgl.zza(this.zzbsq);
        return this.zzbsq;
    }

    public final zzcja zzwD() {
        zzcgl.zza(this.zzbsr);
        return this.zzbsr;
    }

    public final zzcgf zzwC() {
        zzcgl.zza(this.zzbss);
        return this.zzbss;
    }

    final zzcgg zzyR() {
        return this.zzbsq;
    }

    public final zzchl zzwt() {
        zzcgl.zza(this.zzbsD);
        return this.zzbsD;
    }

    public final AppMeasurement zzyS() {
        return this.zzbst;
    }

    public final FirebaseAnalytics zzyT() {
        return this.zzbsu;
    }

    public final zzcjl zzwB() {
        zzcgl.zza((zzchi)this.zzbsv);
        return this.zzbsv;
    }

    public final zzcfj zzwA() {
        zzcgl.zza((zzchi)this.zzbsw);
        return this.zzbsw;
    }

    public final zzcen zzwz() {
        zzcgl.zza(this.zzbsx);
        return this.zzbsx;
    }

    public final zzcfh zzwy() {
        zzcgl.zza(this.zzbsy);
        return this.zzbsy;
    }

    public final zzcfp zzyU() {
        zzcgl.zza(this.zzbsz);
        return this.zzbsz;
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final zze zzkq() {
        return this.zzvw;
    }

    public final zzchz zzwx() {
        zzcgl.zza(this.zzbsA);
        return this.zzbsA;
    }

    public final zzcid zzww() {
        zzcgl.zza(this.zzbsB);
        return this.zzbsB;
    }

    public final zzcet zzwv() {
        zzcgl.zza(this.zzbsC);
        return this.zzbsC;
    }

    public final zzcfg zzwu() {
        zzcgl.zza(this.zzbsE);
        return this.zzbsE;
    }

    private final zzcfu zzyV() {
        if (this.zzbsF == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzbsF;
    }

    private final zzcjg zzyW() {
        zzcgl.zza(this.zzbsG);
        return this.zzbsG;
    }

    public final zzcej zzws() {
        zzcgl.zza(this.zzbsH);
        return this.zzbsH;
    }

    public final zzcec zzwr() {
        zzcgl.zza(this.zzbsI);
        return this.zzbsI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzcgl zzbj(Context context) {
        zzbo.zzu((Object)context);
        zzbo.zzu((Object)context.getApplicationContext());
        if (zzbsm != null) return zzbsm;
        Class<zzcgl> clazz = zzcgl.class;
        synchronized (zzcgl.class) {
            if (zzbsm != null) return zzbsm;
            zzchk zzchk2 = new zzchk(context);
            zzbsm = new zzcgl(zzchk2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzbsm;
        }
    }

    private static void zza(zzchj zzchj2) {
        if (zzchj2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzchj2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private static void zza(zzchi zzchi2) {
        if (zzchi2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    private final boolean zzyX() {
        this.zzwE().zzjC();
        String string = zzcem.zzxC();
        File file = this.mContext.getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzbsN = new RandomAccessFile(file2, "rw").getChannel();
            this.zzbsM = this.zzbsN.tryLock();
            if (this.zzbsM != null) {
                this.zzwF().zzyD().log("Storage concurrent access okay");
                return true;
            }
            this.zzwF().zzyx().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzwF().zzyx().zzj("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzwF().zzyx().zzj("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        this.zzwE().zzjC();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzwF().zzyx().log("Bad chanel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzwF().zzyz().zzj("Unexpected data length. Bytes read", n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzwF().zzyx().zzj("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        this.zzwE().zzjC();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzwF().zzyx().log("Bad chanel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzwF().zzyx().zzj("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzwF().zzyx().zzj("Failed to write to channel", iOException);
            return false;
        }
    }

    @WorkerThread
    public final boolean isEnabled() {
        this.zzwE().zzjC();
        this.zzkD();
        if (this.zzbsn.zzxF()) {
            return false;
        }
        Boolean bl = this.zzbsn.zzdN("firebase_analytics_collection_enabled");
        boolean bl2 = bl != null ? bl : !zzcem.zzqB();
        return this.zzwG().zzal(bl2);
    }

    final void zzd(zzceh zzceh2) {
        this.zzwE().zzjC();
        this.zzkD();
        zzbo.zzcF((String)zzceh2.packageName);
        this.zzf(zzceh2);
    }

    final long zzyY() {
        Long l = this.zzwG().zzbrp.get();
        if (l == 0L) {
            return this.zzbsX;
        }
        return Math.min(this.zzbsX, l);
    }

    private final long zzyZ() {
        long l = this.zzvw.currentTimeMillis();
        zzcfw zzcfw2 = this.zzwG();
        zzcfw2.zzkD();
        zzcfw2.zzjC();
        long l2 = zzcfw2.zzbro.get();
        if (l2 == 0L) {
            l2 = 1 + zzcfw2.zzwB().zzzt().nextInt(86400000);
            zzcfw2.zzbro.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    private final zzceh zzel(String string) {
        zzceg zzceg2 = this.zzwz().zzdQ(string);
        if (zzceg2 == null || TextUtils.isEmpty((CharSequence)zzceg2.zzjH())) {
            this.zzwF().zzyC().zzj("No app data available; dropping", string);
            return null;
        }
        try {
            String string2 = zzbha.zzaP((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
            if (zzceg2.zzjH() != null && !zzceg2.zzjH().equals(string2)) {
                this.zzwF().zzyz().zzj("App version does not match; dropping. appId", zzcfl.zzdZ(string));
                return null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return new zzceh(string, zzceg2.getGmpAppId(), zzceg2.zzjH(), zzceg2.zzwN(), zzceg2.zzwO(), zzceg2.zzwP(), zzceg2.zzwQ(), null, zzceg2.zzwR(), false, zzceg2.zzwK(), zzceg2.zzxe(), 0L, 0);
    }

    @WorkerThread
    final void zzb(zzcez zzcez2, String string) {
        Object object;
        zzceg zzceg2;
        block4: {
            zzceg2 = this.zzwz().zzdQ(string);
            if (zzceg2 == null || TextUtils.isEmpty((CharSequence)zzceg2.zzjH())) {
                this.zzwF().zzyC().zzj("No app data available; dropping event", string);
                return;
            }
            try {
                object = zzbha.zzaP((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
                if (zzceg2.zzjH() != null && !zzceg2.zzjH().equals(object)) {
                    this.zzwF().zzyz().zzj("App version does not match; dropping event. appId", zzcfl.zzdZ(string));
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if ("_ui".equals(zzcez2.name)) break block4;
                this.zzwF().zzyz().zzj("Could not find package. appId", zzcfl.zzdZ(string));
            }
        }
        object = new zzceh(string, zzceg2.getGmpAppId(), zzceg2.zzjH(), zzceg2.zzwN(), zzceg2.zzwO(), zzceg2.zzwP(), zzceg2.zzwQ(), null, zzceg2.zzwR(), false, zzceg2.zzwK(), zzceg2.zzxe(), 0L, 0);
        this.zzb(zzcez2, (zzceh)((Object)object));
    }

    @WorkerThread
    final void zzb(zzcez zzcez2, zzceh zzceh2) {
        zzbo.zzu((Object)((Object)zzceh2));
        zzbo.zzcF((String)zzceh2.packageName);
        this.zzwE().zzjC();
        this.zzkD();
        String string = zzceh2.packageName;
        long l = zzcez2.zzbpN;
        this.zzwB();
        if (!zzcjl.zzd(zzcez2, zzceh2)) {
            return;
        }
        if (!zzceh2.zzboV) {
            this.zzf(zzceh2);
            return;
        }
        this.zzwz().beginTransaction();
        try {
            com.google.android.gms.common.internal.safeparcel.zza zza2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzcen zzcen2 = this.zzwz();
            zzbo.zzcF((String)string3);
            zzcen2.zzjC();
            zzcen2.zzkD();
            if (l2 < 0L) {
                zzcen2.zzwF().zzyz().zze("Invalid time querying timed out conditional properties", zzcfl.zzdZ(string3), l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzcen2.zzc(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzwF().zzyC().zzd("User property timed out", object22.packageName, this.zzwA().zzdY(object22.zzbpd.name), object22.zzbpd.getValue());
                if (object22.zzbph != null) {
                    this.zzc(new zzcez(object22.zzbph, l), zzceh2);
                }
                this.zzwz().zzI(string, object22.zzbpd.name);
            }
            l2 = l;
            string3 = string;
            zzcen2 = this.zzwz();
            zzbo.zzcF((String)string3);
            zzcen2.zzjC();
            zzcen2.zzkD();
            if (l2 < 0L) {
                zzcen2.zzwF().zzyz().zze("Invalid time querying expired conditional properties", zzcfl.zzdZ(string3), l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzcen2.zzc(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzcek)((Object)object4.next());
                if (object == null) continue;
                this.zzwF().zzyC().zzd("User property expired", object.packageName, this.zzwA().zzdY(object.zzbpd.name), object.zzbpd.getValue());
                this.zzwz().zzF(string, object.zzbpd.name);
                if (object.zzbpl != null) {
                    object22.add(object.zzbpl);
                }
                this.zzwz().zzI(string, object.zzbpd.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzcez)((Object)e);
                this.zzc(new zzcez((zzcez)((Object)object), l), zzceh2);
            }
            long l3 = l;
            String string4 = zzcez2.name;
            string3 = string;
            zzcen2 = this.zzwz();
            zzbo.zzcF((String)string3);
            zzbo.zzcF((String)string4);
            zzcen2.zzjC();
            zzcen2.zzkD();
            if (l3 < 0L) {
                zzcen2.zzwF().zzyz().zzd("Invalid time querying triggered conditional properties", zzcfl.zzdZ(string3), zzcen2.zzwA().zzdW(string4), l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzcen2.zzc((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zza2 = (zzcek)((Object)iterator.next());
                if (zza2 == null) continue;
                zzcji zzcji2 = zza2.zzbpd;
                zzcjk zzcjk2 = new zzcjk(zza2.packageName, zza2.zzbpc, zzcji2.name, l, zzcji2.getValue());
                if (this.zzwz().zza(zzcjk2)) {
                    this.zzwF().zzyC().zzd("User property triggered", zza2.packageName, this.zzwA().zzdY(zzcjk2.mName), zzcjk2.mValue);
                } else {
                    this.zzwF().zzyx().zzd("Too many active user properties, ignoring", zzcfl.zzdZ(zza2.packageName), this.zzwA().zzdY(zzcjk2.mName), zzcjk2.mValue);
                }
                if (zza2.zzbpj != null) {
                    object.add(zza2.zzbpj);
                }
                zza2.zzbpd = new zzcji(zzcjk2);
                zza2.zzbpf = true;
                this.zzwz().zza((zzcek)zza2);
            }
            this.zzc(zzcez2, zzceh2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zza2 = (zzcez)((Object)e);
                this.zzc(new zzcez((zzcez)zza2, l), zzceh2);
            }
            this.zzwz().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzwz().endTransaction();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final void zzc(zzcez zzcez2, zzceh zzceh2) {
        zzbo.zzu((Object)((Object)zzceh2));
        zzbo.zzcF((String)zzceh2.packageName);
        long l = System.nanoTime();
        this.zzwE().zzjC();
        this.zzkD();
        String string = zzceh2.packageName;
        this.zzwB();
        if (!zzcjl.zzd(zzcez2, zzceh2)) {
            return;
        }
        if (!zzceh2.zzboV) {
            this.zzf(zzceh2);
            return;
        }
        if (this.zzwC().zzN(string, zzcez2.name)) {
            this.zzwF().zzyz().zze("Dropping blacklisted event. appId", zzcfl.zzdZ(string), this.zzwA().zzdW(zzcez2.name));
            boolean bl = this.zzwB().zzeA(string) || this.zzwB().zzeB(string);
            if (!bl && !"_err".equals(zzcez2.name)) {
                this.zzwB().zza(string, 11, "_ev", zzcez2.name, 0);
            }
            if (!bl) return;
            zzceg zzceg2 = this.zzwz().zzdQ(string);
            if (zzceg2 == null) return;
            long l2 = Math.max(zzceg2.zzwU(), zzceg2.zzwT());
            if (Math.abs(this.zzvw.currentTimeMillis() - l2) <= zzcem.zzxI()) return;
            this.zzwF().zzyC().log("Fetching config for blacklisted app");
            this.zzb(zzceg2);
            return;
        }
        if (this.zzwF().zzz(2)) {
            this.zzwF().zzyD().zzj("Logging event", this.zzwA().zzb(zzcez2));
        }
        this.zzwz().beginTransaction();
        try {
            zzcev zzcev2;
            long l3;
            int n;
            String string2;
            Bundle bundle = zzcez2.zzbpM.zzyt();
            this.zzf(zzceh2);
            if ("_iap".equals(zzcez2.name) || "ecommerce_purchase".equals(zzcez2.name)) {
                long l4;
                String string3;
                block37: {
                    string3 = bundle.getString("currency");
                    if ("ecommerce_purchase".equals(zzcez2.name)) {
                        double d = bundle.getDouble("value") * 1000000.0;
                        if (d == 0.0) {
                            d = (double)bundle.getLong("value") * 1000000.0;
                        }
                        if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                            l4 = Math.round(d);
                            break block37;
                        } else {
                            this.zzwF().zzyz().zze("Data lost. Currency value is too big. appId", zzcfl.zzdZ(string), d);
                            this.zzwz().setTransactionSuccessful();
                            return;
                        }
                    }
                    l4 = bundle.getLong("value");
                }
                if (!TextUtils.isEmpty((CharSequence)string3) && (string3 = string3.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                    String string4 = String.valueOf("_ltv_");
                    String string5 = String.valueOf(string3);
                    String string6 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
                    zzcjk zzcjk2 = this.zzwz().zzG(string, string6);
                    if (zzcjk2 == null || !(zzcjk2.mValue instanceof Long)) {
                        string2 = string;
                        n = this.zzbsn.zzb(string2, zzcfb.zzbqz) - 1;
                        string2 = string;
                        zzcen zzcen2 = this.zzwz();
                        zzbo.zzcF((String)string2);
                        zzcen2.zzjC();
                        zzcen2.zzkD();
                        try {
                            zzcen2.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string2, string2, String.valueOf(n)});
                        }
                        catch (SQLiteException sQLiteException) {
                            zzcen2.zzwF().zzyx().zze("Error pruning currencies. appId", zzcfl.zzdZ(string2), (Object)sQLiteException);
                        }
                        zzcjk2 = new zzcjk(string, zzcez2.zzbpc, string6, this.zzvw.currentTimeMillis(), l4);
                    } else {
                        l3 = (Long)zzcjk2.mValue;
                        zzcjk2 = new zzcjk(string, zzcez2.zzbpc, string6, this.zzvw.currentTimeMillis(), l3 + l4);
                    }
                    if (!this.zzwz().zza(zzcjk2)) {
                        this.zzwF().zzyx().zzd("Too many unique user properties are set. Ignoring user property. appId", zzcfl.zzdZ(string), this.zzwA().zzdY(zzcjk2.mName), zzcjk2.mValue);
                        this.zzwB().zza(string, 9, null, null, 0);
                    }
                }
            }
            boolean bl = zzcjl.zzeo(zzcez2.name);
            boolean bl2 = "_err".equals(zzcez2.name);
            zzceo zzceo2 = this.zzwz().zza(this.zzyZ(), string, true, bl, false, bl2, false);
            long l5 = zzceo2.zzbpv - zzcem.zzxq();
            if (l5 > 0L) {
                if (l5 % 1000L == 1L) {
                    this.zzwF().zzyx().zze("Data loss. Too many events logged. appId, count", zzcfl.zzdZ(string), zzceo2.zzbpv);
                }
                this.zzwz().setTransactionSuccessful();
                return;
            }
            if (bl && (l5 = zzceo2.zzbpu - zzcem.zzxr()) > 0L) {
                if (l5 % 1000L == 1L) {
                    this.zzwF().zzyx().zze("Data loss. Too many public events logged. appId, count", zzcfl.zzdZ(string), zzceo2.zzbpu);
                }
                this.zzwB().zza(string, 16, "_ev", zzcez2.name, 0);
                this.zzwz().setTransactionSuccessful();
                return;
            }
            if (bl2) {
                string2 = zzceh2.packageName;
                n = this.zzbsn.zzb(string2, zzcfb.zzbqg);
                l5 = zzceo2.zzbpx - (long)Math.max(0, n = Math.min(1000000, n));
                if (l5 > 0L) {
                    if (l5 == 1L) {
                        this.zzwF().zzyx().zze("Too many error events logged. appId, count", zzcfl.zzdZ(string), zzceo2.zzbpx);
                    }
                    this.zzwz().setTransactionSuccessful();
                    return;
                }
            }
            this.zzwB().zza(bundle, "_o", (Object)zzcez2.zzbpc);
            if (this.zzwB().zzey(string)) {
                this.zzwB().zza(bundle, "_dbg", 1L);
                this.zzwB().zza(bundle, "_r", 1L);
            }
            if ((l3 = this.zzwz().zzdR(string)) > 0L) {
                this.zzwF().zzyz().zze("Data lost. Too many events stored on disk, deleted. appId", zzcfl.zzdZ(string), l3);
            }
            zzceu zzceu2 = new zzceu(this, zzcez2.zzbpc, string, zzcez2.name, zzcez2.zzbpN, 0L, bundle);
            zzcev zzcev3 = this.zzwz().zzE(string, zzceu2.mName);
            if (zzcev3 == null) {
                long l6 = this.zzwz().zzdU(string);
                zzcem.zzxp();
                if (l6 >= 500L) {
                    this.zzwF().zzyx().zzd("Too many event names used, ignoring event. appId, name, supported count", zzcfl.zzdZ(string), this.zzwA().zzdW(zzceu2.mName), zzcem.zzxp());
                    this.zzwB().zza(string, 8, null, null, 0);
                    return;
                }
                zzcev2 = new zzcev(string, zzceu2.mName, 0L, 0L, zzceu2.zzayS);
            } else {
                zzceu2 = zzceu2.zza(this, zzcev3.zzbpI);
                zzcev2 = zzcev3.zzab(zzceu2.zzayS);
            }
            this.zzwz().zza(zzcev2);
            this.zza(zzceu2, zzceh2);
            this.zzwz().setTransactionSuccessful();
            if (this.zzwF().zzz(2)) {
                this.zzwF().zzyD().zzj("Event recorded", this.zzwA().zza(zzceu2));
            }
        }
        finally {
            this.zzwz().endTransaction();
        }
        this.zzzc();
        this.zzwF().zzyD().zzj("Background event processing time, ms", (System.nanoTime() - l + 500000L) / 1000000L);
    }

    @WorkerThread
    final void zzd(zzcek zzcek2) {
        zzceh zzceh2 = this.zzel(zzcek2.packageName);
        if (zzceh2 != null) {
            this.zzb(zzcek2, zzceh2);
        }
    }

    @WorkerThread
    final void zzb(zzcek zzcek2, zzceh zzceh2) {
        zzbo.zzu((Object)((Object)zzcek2));
        zzbo.zzcF((String)zzcek2.packageName);
        zzbo.zzu((Object)zzcek2.zzbpc);
        zzbo.zzu((Object)((Object)zzcek2.zzbpd));
        zzbo.zzcF((String)zzcek2.zzbpd.name);
        this.zzwE().zzjC();
        this.zzkD();
        if (TextUtils.isEmpty((CharSequence)zzceh2.zzboQ)) {
            return;
        }
        if (!zzceh2.zzboV) {
            this.zzf(zzceh2);
            return;
        }
        zzcek zzcek3 = new zzcek(zzcek2);
        new zzcek(zzcek2).zzbpf = false;
        this.zzwz().beginTransaction();
        try {
            boolean bl = false;
            zzcek zzcek4 = this.zzwz().zzH(zzcek3.packageName, zzcek3.zzbpd.name);
            if (zzcek4 != null && !zzcek4.zzbpc.equals(zzcek3.zzbpc)) {
                this.zzwF().zzyz().zzd("Updating a conditional user property with different origin. name, origin, origin (from DB)", this.zzwA().zzdY(zzcek3.zzbpd.name), zzcek3.zzbpc, zzcek4.zzbpc);
            }
            if (zzcek4 != null && zzcek4.zzbpf) {
                zzcek3.zzbpc = zzcek4.zzbpc;
                zzcek3.zzbpe = zzcek4.zzbpe;
                zzcek3.zzbpi = zzcek4.zzbpi;
                zzcek3.zzbpg = zzcek4.zzbpg;
                zzcek3.zzbpj = zzcek4.zzbpj;
                zzcek3.zzbpf = zzcek4.zzbpf;
                zzcek3.zzbpd = new zzcji(zzcek3.zzbpd.name, zzcek4.zzbpd.zzbuy, zzcek3.zzbpd.getValue(), zzcek4.zzbpd.zzbpc);
            } else if (TextUtils.isEmpty((CharSequence)zzcek3.zzbpg)) {
                zzcek3.zzbpd = new zzcji(zzcek3.zzbpd.name, zzcek3.zzbpe, zzcek3.zzbpd.getValue(), zzcek3.zzbpd.zzbpc);
                zzcek3.zzbpf = true;
                bl = true;
            }
            if (zzcek3.zzbpf) {
                zzcji zzcji2 = zzcek3.zzbpd;
                zzcjk zzcjk2 = new zzcjk(zzcek3.packageName, zzcek3.zzbpc, zzcji2.name, zzcji2.zzbuy, zzcji2.getValue());
                if (this.zzwz().zza(zzcjk2)) {
                    this.zzwF().zzyC().zzd("User property updated immediately", zzcek3.packageName, this.zzwA().zzdY(zzcjk2.mName), zzcjk2.mValue);
                } else {
                    this.zzwF().zzyx().zzd("(2)Too many active user properties, ignoring", zzcfl.zzdZ(zzcek3.packageName), this.zzwA().zzdY(zzcjk2.mName), zzcjk2.mValue);
                }
                if (bl && zzcek3.zzbpj != null) {
                    zzcez zzcez2 = new zzcez(zzcek3.zzbpj, zzcek3.zzbpe);
                    this.zzc(zzcez2, zzceh2);
                }
            }
            if (this.zzwz().zza(zzcek3)) {
                this.zzwF().zzyC().zzd("Conditional property added", zzcek3.packageName, this.zzwA().zzdY(zzcek3.zzbpd.name), zzcek3.zzbpd.getValue());
            } else {
                this.zzwF().zzyx().zzd("Too many conditional properties, ignoring", zzcfl.zzdZ(zzcek3.packageName), this.zzwA().zzdY(zzcek3.zzbpd.name), zzcek3.zzbpd.getValue());
            }
            this.zzwz().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzwz().endTransaction();
        }
    }

    @WorkerThread
    final void zze(zzcek zzcek2) {
        zzceh zzceh2 = this.zzel(zzcek2.packageName);
        if (zzceh2 != null) {
            this.zzc(zzcek2, zzceh2);
        }
    }

    @WorkerThread
    final void zzc(zzcek zzcek2, zzceh zzceh2) {
        zzbo.zzu((Object)((Object)zzcek2));
        zzbo.zzcF((String)zzcek2.packageName);
        zzbo.zzu((Object)((Object)zzcek2.zzbpd));
        zzbo.zzcF((String)zzcek2.zzbpd.name);
        this.zzwE().zzjC();
        this.zzkD();
        if (TextUtils.isEmpty((CharSequence)zzceh2.zzboQ)) {
            return;
        }
        if (!zzceh2.zzboV) {
            this.zzf(zzceh2);
            return;
        }
        this.zzwz().beginTransaction();
        try {
            this.zzf(zzceh2);
            zzcek zzcek3 = this.zzwz().zzH(zzcek2.packageName, zzcek2.zzbpd.name);
            if (zzcek3 != null) {
                this.zzwF().zzyC().zze("Removing conditional user property", zzcek2.packageName, this.zzwA().zzdY(zzcek2.zzbpd.name));
                this.zzwz().zzI(zzcek2.packageName, zzcek2.zzbpd.name);
                if (zzcek3.zzbpf) {
                    this.zzwz().zzF(zzcek2.packageName, zzcek2.zzbpd.name);
                }
                if (zzcek2.zzbpl != null) {
                    Bundle bundle = null;
                    if (zzcek2.zzbpl.zzbpM != null) {
                        bundle = zzcek2.zzbpl.zzbpM.zzyt();
                    }
                    zzcez zzcez2 = this.zzwB().zza(zzcek2.zzbpl.name, bundle, zzcek3.zzbpc, zzcek2.zzbpl.zzbpN, true, false);
                    this.zzc(zzcez2, zzceh2);
                }
            } else {
                this.zzwF().zzyz().zze("Conditional user property doesn't exist", zzcfl.zzdZ(zzcek2.packageName), this.zzwA().zzdY(zzcek2.zzbpd.name));
            }
            this.zzwz().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzwz().endTransaction();
        }
    }

    @WorkerThread
    public final byte[] zza(@NonNull zzcez zzcez2, @Size(min=1L) String string) {
        Object object;
        this.zzkD();
        this.zzwE().zzjC();
        zzcgl.zzwo();
        zzbo.zzu((Object)((Object)zzcez2));
        zzbo.zzcF((String)string);
        zzcjy zzcjy2 = new zzcjy();
        this.zzwz().beginTransaction();
        try {
            zzcev zzcev2;
            long l;
            Object object2;
            Pair<String, Boolean> pair;
            zzceg zzceg2 = this.zzwz().zzdQ(string);
            if (zzceg2 == null) {
                this.zzwF().zzyC().zzj("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzceg2.zzwR()) {
                this.zzwF().zzyC().zzj("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            object = new zzcjz();
            zzcjy2.zzbvB = new zzcjz[]{object};
            object.zzbvD = 1;
            object.zzbvL = "android";
            object.zzaH = zzceg2.zzhl();
            object.zzboR = zzceg2.zzwO();
            object.zzbgW = zzceg2.zzjH();
            long l2 = zzceg2.zzwN();
            object.zzbvY = l2 == Integer.MIN_VALUE ? null : Integer.valueOf((int)l2);
            object.zzbvP = zzceg2.zzwP();
            object.zzboQ = zzceg2.getGmpAppId();
            object.zzbvU = zzceg2.zzwQ();
            if (this.isEnabled() && zzcem.zzyb() && this.zzbsn.zzdO(object.zzaH)) {
                this.zzwu();
                object.zzbwd = null;
            }
            if ((pair = this.zzwG().zzeb(zzceg2.zzhl())) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                object.zzbvR = (String)pair.first;
                object.zzbvS = (Boolean)pair.second;
            }
            this.zzwv().zzkD();
            object.zzbvM = Build.MODEL;
            this.zzwv().zzkD();
            object.zzaY = Build.VERSION.RELEASE;
            object.zzbvO = (int)this.zzwv().zzyq();
            object.zzbvN = this.zzwv().zzyr();
            object.zzbvT = zzceg2.getAppInstanceId();
            object.zzboY = zzceg2.zzwK();
            List<zzcjk> list = this.zzwz().zzdP(zzceg2.zzhl());
            object.zzbvF = new zzckb[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                object2 = new zzckb();
                object.zzbvF[i] = object2;
                ((zzckb)((Object)object2)).name = list.get((int)i).mName;
                ((zzckb)((Object)object2)).zzbwh = list.get((int)i).zzbuC;
                this.zzwB().zza((zzckb)((Object)object2), list.get((int)i).mValue);
            }
            Bundle bundle = zzcez2.zzbpM.zzyt();
            if ("_iap".equals(zzcez2.name)) {
                bundle.putLong("_c", 1L);
                this.zzwF().zzyC().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzcez2.zzbpc);
            if (this.zzwB().zzey(object.zzaH)) {
                this.zzwB().zza(bundle, "_dbg", 1L);
                this.zzwB().zza(bundle, "_r", 1L);
            }
            if ((object2 = this.zzwz().zzE(string, zzcez2.name)) == null) {
                l = 0L;
                zzcev2 = new zzcev(string, zzcez2.name, 1L, 0L, zzcez2.zzbpN);
                this.zzwz().zza(zzcev2);
            } else {
                l = ((zzcev)object2).zzbpI;
                zzcev2 = ((zzcev)object2).zzab(zzcez2.zzbpN).zzys();
                this.zzwz().zza(zzcev2);
            }
            zzceu zzceu2 = new zzceu(this, zzcez2.zzbpc, string, zzcez2.name, zzcez2.zzbpN, l, bundle);
            zzcjw zzcjw2 = new zzcjw();
            object.zzbvE = new zzcjw[]{zzcjw2};
            zzcjw2.zzbvx = zzceu2.zzayS;
            zzcjw2.name = zzceu2.mName;
            zzcjw2.zzbvy = zzceu2.zzbpE;
            zzcjw2.zzbvw = new zzcjx[zzceu2.zzbpF.size()];
            int n = 0;
            for (String string2 : zzceu2.zzbpF) {
                zzcjx zzcjx2 = new zzcjx();
                zzcjw2.zzbvw[n++] = zzcjx2;
                zzcjx2.name = string2;
                Object object3 = zzceu2.zzbpF.get(string2);
                this.zzwB().zza(zzcjx2, object3);
            }
            object.zzbvX = this.zza(zzceg2.zzhl(), object.zzbvF, object.zzbvE);
            object.zzbvH = zzcjw2.zzbvx;
            object.zzbvI = zzcjw2.zzbvx;
            long l3 = zzceg2.zzwM();
            object.zzbvK = l3 != 0L ? Long.valueOf(l3) : null;
            long l4 = zzceg2.zzwL();
            if (l4 == 0L) {
                l4 = l3;
            }
            object.zzbvJ = l4 != 0L ? Long.valueOf(l4) : null;
            zzceg2.zzwV();
            object.zzbvV = (int)zzceg2.zzwS();
            object.zzbvQ = zzcem.zzwP();
            object.zzbvG = this.zzvw.currentTimeMillis();
            object.zzbvW = Boolean.TRUE;
            zzceg2.zzL(object.zzbvH);
            zzceg2.zzM(object.zzbvI);
            this.zzwz().zza(zzceg2);
            this.zzwz().setTransactionSuccessful();
        }
        finally {
            this.zzwz().endTransaction();
        }
        try {
            byte[] byArray = new byte[zzcjy2.zzLW()];
            object = byArray;
            byte[] byArray2 = byArray;
            adh adh2 = adh.zzc((byte[])byArray, (int)0, (int)byArray2.length);
            zzcjy2.zza(adh2);
            adh2.zzLN();
            return this.zzwB().zzl((byte[])object);
        }
        catch (IOException iOException) {
            this.zzwF().zzyx().zze("Data loss. Failed to bundle and serialize. appId", zzcfl.zzdZ(string), iOException);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void zza(zzceu var1_1, zzceh var2_2) {
        block10: {
            this.zzwE().zzjC();
            this.zzkD();
            zzbo.zzu((Object)var1_1);
            zzbo.zzu((Object)var2_2);
            zzbo.zzcF((String)var1_1.mAppId);
            zzbo.zzaf((boolean)var1_1.mAppId.equals(var2_2.packageName));
            var3_3 = new zzcjz();
            new zzcjz().zzbvD = 1;
            var3_3.zzbvL = "android";
            var3_3.zzaH = var2_2.packageName;
            var3_3.zzboR = var2_2.zzboR;
            var3_3.zzbgW = var2_2.zzbgW;
            var3_3.zzbvY = var2_2.zzboX == -2147483648L ? null : Integer.valueOf((int)var2_2.zzboX);
            var3_3.zzbvP = var2_2.zzboS;
            var3_3.zzboQ = var2_2.zzboQ;
            var3_3.zzbvU = var2_2.zzboT == 0L ? null : Long.valueOf(var2_2.zzboT);
            var4_4 = this.zzwG().zzeb(var2_2.packageName);
            if (var4_4 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var4_4.first))) {
                var3_3.zzbvR = (String)var4_4.first;
                var3_3.zzbvS = (Boolean)var4_4.second;
            }
            this.zzwv().zzkD();
            var3_3.zzbvM = Build.MODEL;
            this.zzwv().zzkD();
            var3_3.zzaY = Build.VERSION.RELEASE;
            var3_3.zzbvO = (int)this.zzwv().zzyq();
            var3_3.zzbvN = this.zzwv().zzyr();
            var3_3.zzbvQ = null;
            var3_3.zzbvG = null;
            var3_3.zzbvH = null;
            var3_3.zzbvI = null;
            var3_3.zzbwc = var2_2.zzboZ;
            if (this.isEnabled() && zzcem.zzyb()) {
                this.zzwu();
                var3_3.zzbwd = null;
            }
            if ((var5_5 = this.zzwz().zzdQ(var2_2.packageName)) == null) {
                var5_5 = new zzceg(this, var2_2.packageName);
                var5_5.zzdG(this.zzwu().zzyu());
                var5_5.zzdJ(var2_2.zzboY);
                var5_5.zzdH(var2_2.zzboQ);
                var5_5.zzdI(this.zzwG().zzec(var2_2.packageName));
                var5_5.zzQ(0L);
                var5_5.zzL(0L);
                var5_5.zzM(0L);
                var5_5.setAppVersion(var2_2.zzbgW);
                var5_5.zzN(var2_2.zzboX);
                var5_5.zzdK(var2_2.zzboR);
                var5_5.zzO(var2_2.zzboS);
                var5_5.zzP(var2_2.zzboT);
                var5_5.setMeasurementEnabled(var2_2.zzboV);
                var5_5.zzZ(var2_2.zzboZ);
                this.zzwz().zza(var5_5);
            }
            var3_3.zzbvT = var5_5.getAppInstanceId();
            var3_3.zzboY = var5_5.zzwK();
            var6_6 = this.zzwz().zzdP(var2_2.packageName);
            var3_3.zzbvF = new zzckb[var6_6.size()];
            for (var7_7 = 0; var7_7 < var6_6.size(); ++var7_7) {
                var3_3.zzbvF[var7_7] = var8_9 = new zzckb();
                var8_9.name = var6_6.get((int)var7_7).mName;
                var8_9.zzbwh = var6_6.get((int)var7_7).zzbuC;
                this.zzwB().zza(var8_9, var6_6.get((int)var7_7).mValue);
            }
            try {
                var7_8 = this.zzwz().zza(var3_3);
            }
            catch (IOException var9_10) {
                this.zzwF().zzyx().zze("Data loss. Failed to insert raw event metadata. appId", zzcfl.zzdZ(var3_3.zzaH), var9_10);
                return;
            }
            v0 = this.zzwz();
            var11_11 = var1_1;
            var10_12 = this;
            if (var11_11.zzbpF == null) ** GOTO lbl-1000
            for (Object var13_15 : var11_11.zzbpF) {
                if (!"_r".equals(var13_15)) continue;
                v1 = true;
                break block10;
            }
            var12_14 = var10_12.zzwC().zzO(var11_11.mAppId, var11_11.mName);
            var13_15 = var10_12.zzwz().zza(var10_12.zzyZ(), var11_11.mAppId, false, false, false, false, false);
            if (var12_14 && var13_15.zzbpy < (long)var10_12.zzbsn.zzdM(var11_11.mAppId)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
        }
        if (v0.zza(var1_1, var7_8, v1)) {
            this.zzbsT = 0L;
        }
    }

    public final String zzem(String string) {
        Future<String> future = this.zzwE().zze(new zzcgn(this, string));
        try {
            return future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzwF().zzyx().zze("Failed to get app instance id. appId", zzcfl.zzdZ(string), exception);
            return null;
        }
    }

    static void zzwo() {
        zzcem.zzxE();
        throw new IllegalStateException("Unexpected call on client side");
    }

    @WorkerThread
    final void zzb(zzcji zzcji2, zzceh zzceh2) {
        this.zzwE().zzjC();
        this.zzkD();
        if (TextUtils.isEmpty((CharSequence)zzceh2.zzboQ)) {
            return;
        }
        if (!zzceh2.zzboV) {
            this.zzf(zzceh2);
            return;
        }
        int n = this.zzwB().zzes(zzcji2.name);
        if (n != 0) {
            this.zzwB();
            String string = zzcjl.zza(zzcji2.name, zzcem.zzxi(), true);
            int n2 = zzcji2.name != null ? zzcji2.name.length() : 0;
            this.zzwB().zza(zzceh2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzwB().zzl(zzcji2.name, zzcji2.getValue());
        if (n != 0) {
            this.zzwB();
            String string = zzcjl.zza(zzcji2.name, zzcem.zzxi(), true);
            Object object = zzcji2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzwB().zza(zzceh2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzwB().zzm(zzcji2.name, zzcji2.getValue());
        if (object == null) {
            return;
        }
        zzcjk zzcjk2 = new zzcjk(zzceh2.packageName, zzcji2.zzbpc, zzcji2.name, zzcji2.zzbuy, object);
        this.zzwF().zzyC().zze("Setting user property", this.zzwA().zzdY(zzcjk2.mName), object);
        this.zzwz().beginTransaction();
        try {
            this.zzf(zzceh2);
            boolean bl = this.zzwz().zza(zzcjk2);
            this.zzwz().setTransactionSuccessful();
            if (bl) {
                this.zzwF().zzyC().zze("User property set", this.zzwA().zzdY(zzcjk2.mName), zzcjk2.mValue);
            } else {
                this.zzwF().zzyx().zze("Too many unique user properties are set. Ignoring user property", this.zzwA().zzdY(zzcjk2.mName), zzcjk2.mValue);
                this.zzwB().zza(zzceh2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzwz().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzcji zzcji2, zzceh zzceh2) {
        this.zzwE().zzjC();
        this.zzkD();
        if (TextUtils.isEmpty((CharSequence)zzceh2.zzboQ)) {
            return;
        }
        if (!zzceh2.zzboV) {
            this.zzf(zzceh2);
            return;
        }
        this.zzwF().zzyC().zzj("Removing user property", this.zzwA().zzdY(zzcji2.name));
        this.zzwz().beginTransaction();
        try {
            this.zzf(zzceh2);
            this.zzwz().zzF(zzceh2.packageName, zzcji2.name);
            this.zzwz().setTransactionSuccessful();
            this.zzwF().zzyC().zzj("User property removed", this.zzwA().zzdY(zzcji2.name));
            return;
        }
        finally {
            this.zzwz().endTransaction();
        }
    }

    @WorkerThread
    public final void zzza() {
        this.zzwE().zzjC();
        this.zzkD();
        this.zzbsW = true;
        try {
            String string;
            zzcem.zzxE();
            Boolean bl = this.zzwG().zzyI();
            if (bl == null) {
                this.zzwF().zzyz().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzwF().zzyx().log("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzbsT > 0L) {
                this.zzzc();
                return;
            }
            Object object = this;
            ((zzcgl)object).zzwE().zzjC();
            if (((zzcgl)object).zzbsO != null) {
                this.zzwF().zzyD().log("Uploading requested multiple times");
                return;
            }
            if (!this.zzyU().zzlQ()) {
                this.zzwF().zzyD().log("Network not connected, ignoring upload request");
                this.zzzc();
                return;
            }
            long l = this.zzvw.currentTimeMillis();
            long l2 = l - zzcem.zzxP();
            this.zzg(null, l2);
            long l3 = this.zzwG().zzbrk.get();
            if (l3 != 0L) {
                this.zzwF().zzyC().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzwz().zzyc()))) {
                if (this.zzbsS == -1L) {
                    this.zzbsS = this.zzwz().zzyj();
                }
                Object object2 = string;
                int n = this.zzbsn.zzb((String)object2, zzcfb.zzbqb);
                object2 = string;
                object = this.zzbsn;
                int n2 = Math.max(0, ((zzcem)object).zzb((String)object2, zzcfb.zzbqc));
                List<Pair<zzcjz, Long>> list = this.zzwz().zzl(string, n, n2);
                if (!list.isEmpty()) {
                    Object object3;
                    String string2 = null;
                    Object object4 = list.iterator();
                    while (object4.hasNext()) {
                        zzcjz zzcjz2 = (zzcjz)((Object)object4.next().first);
                        if (TextUtils.isEmpty((CharSequence)zzcjz2.zzbvR)) continue;
                        string2 = zzcjz2.zzbvR;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object3 = (zzcjz)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)((zzcjz)((Object)object3)).zzbvR) || ((zzcjz)((Object)object3)).zzbvR.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object4 = new zzcjy();
                    new zzcjy().zzbvB = new zzcjz[list.size()];
                    object3 = new ArrayList(list.size());
                    boolean bl2 = zzcem.zzyb() && this.zzbsn.zzdO(string);
                    for (int i = 0; i < ((zzcjy)((Object)object4)).zzbvB.length; ++i) {
                        ((zzcjy)((Object)object4)).zzbvB[i] = (zzcjz)((Object)list.get((int)i).first);
                        object3.add((Long)list.get((int)i).second);
                        ((zzcjy)((Object)object4)).zzbvB[i].zzbvQ = zzcem.zzwP();
                        ((zzcjy)((Object)object4)).zzbvB[i].zzbvG = l;
                        ((zzcjy)((Object)object4)).zzbvB[i].zzbvW = zzcem.zzxE();
                        if (bl2) continue;
                        ((zzcjy)((Object)object4)).zzbvB[i].zzbwd = null;
                    }
                    String string3 = null;
                    if (this.zzwF().zzz(2)) {
                        string3 = this.zzwA().zza((zzcjy)((Object)object4));
                    }
                    byte[] byArray = this.zzwB().zzb((zzcjy)((Object)object4));
                    String string4 = zzcem.zzxO();
                    try {
                        URL uRL = new URL(string4);
                        object2 = object3;
                        object = this;
                        zzbo.zzaf((!object2.isEmpty() ? 1 : 0) != 0);
                        if (((zzcgl)object).zzbsO != null) {
                            ((zzcgl)object).zzwF().zzyx().log("Set uploading progress before finishing the previous upload");
                        } else {
                            ((zzcgl)object).zzbsO = new ArrayList<Long>((Collection<Long>)object2);
                        }
                        this.zzwG().zzbrl.set(l);
                        String string5 = "?";
                        if (((zzcjy)((Object)object4)).zzbvB.length > 0) {
                            string5 = ((zzcjy)((Object)object4)).zzbvB[0].zzaH;
                        }
                        this.zzwF().zzyD().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                        this.zzbsV = true;
                        this.zzyU().zza(string, uRL, byArray, null, new zzcgo(this));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzwF().zzyx().zze("Failed to parse upload URL. Not uploading. appId", zzcfl.zzdZ(string), string4);
                    }
                }
            } else {
                zzceg zzceg2;
                this.zzbsS = -1L;
                String string6 = this.zzwz().zzaa(l - zzcem.zzxP());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzceg2 = this.zzwz().zzdQ(string6)) != null) {
                    this.zzb(zzceg2);
                }
            }
            return;
        }
        finally {
            this.zzbsW = false;
            this.zzzg();
        }
    }

    @WorkerThread
    private final void zzb(zzceg zzceg2) {
        this.zzwE().zzjC();
        if (TextUtils.isEmpty((CharSequence)zzceg2.getGmpAppId())) {
            this.zzb(zzceg2.zzhl(), 204, null, null, null);
            return;
        }
        String string = zzceg2.getAppInstanceId();
        String string2 = zzceg2.getGmpAppId();
        Uri.Builder builder = new Uri.Builder();
        String string3 = String.valueOf(string2);
        builder.scheme(zzcfb.zzbpZ.get()).encodedAuthority(zzcfb.zzbqa.get()).path(string3.length() != 0 ? "config/app/".concat(string3) : new String("config/app/")).appendQueryParameter("app_instance_id", string).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "11020");
        String string4 = builder.build().toString();
        try {
            URL uRL = new URL(string4);
            this.zzwF().zzyD().zzj("Fetching remote configuration", zzceg2.zzhl());
            zzcjt zzcjt2 = this.zzwC().zzeh(zzceg2.zzhl());
            ArrayMap arrayMap = null;
            String string5 = this.zzwC().zzei(zzceg2.zzhl());
            if (zzcjt2 != null && !TextUtils.isEmpty((CharSequence)string5)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string5);
            }
            this.zzbsU = true;
            this.zzyU().zza(zzceg2.zzhl(), uRL, (Map<String, String>)arrayMap, new zzcgp(this));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzwF().zzyx().zze("Failed to parse config URL. Not fetching. appId", zzcfl.zzdZ(zzceg2.zzhl()), string4);
            return;
        }
    }

    private final boolean zzg(String string, long l) {
        this.zzwz().beginTransaction();
        try {
            block69: {
                int n;
                Object object;
                String string2;
                zza zza2;
                block68: {
                    zza zza3 = zza2 = new zza(this, null);
                    long l2 = this.zzbsS;
                    long l3 = l;
                    string2 = null;
                    object = this.zzwz();
                    zzbo.zzu((Object)zza3);
                    ((zzchi)object).zzjC();
                    ((zzchj)object).zzkD();
                    try (Cursor cursor = null;){
                        String[] stringArray;
                        String string3;
                        String string4;
                        String string5;
                        String[] stringArray2;
                        SQLiteDatabase sQLiteDatabase = ((zzcen)object).getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            stringArray2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string5 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string5).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string5).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block68;
                            string2 = cursor.getString(0);
                            string4 = cursor.getString(1);
                            cursor.close();
                        } else {
                            stringArray2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string5 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string5).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string5).append(" order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block68;
                            string4 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string2, string4}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            ((zzchi)object).zzwF().zzyx().zzj("Raw event metadata record is missing. appId", zzcfl.zzdZ(string2));
                            break block68;
                        }
                        byte[] byArray = cursor.getBlob(0);
                        string5 = adg.zzb((byte[])byArray, (int)0, (int)byArray.length);
                        zzcjz zzcjz2 = new zzcjz();
                        try {
                            zzcjz2.zza((adg)string5);
                        }
                        catch (IOException iOException) {
                            ((zzchi)object).zzwF().zzyx().zze("Data loss. Failed to merge raw event metadata. appId", zzcfl.zzdZ(string2), iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block68;
                        }
                        if (cursor.moveToNext()) {
                            ((zzchi)object).zzwF().zzyz().zzj("Get multiple raw event metadata records, expected one. appId", zzcfl.zzdZ(string2));
                        }
                        cursor.close();
                        zza3.zzb(zzcjz2);
                        if (l2 != -1L) {
                            string3 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{string2, string4, String.valueOf(l2)};
                        } else {
                            string3 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{string2, string4};
                        }
                        cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string3, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            ((zzchi)object).zzwF().zzyz().zzj("Raw event data disappeared while in transaction. appId", zzcfl.zzdZ(string2));
                            break block68;
                        }
                        do {
                            long l4 = cursor.getLong(0);
                            byArray = cursor.getBlob(3);
                            string5 = adg.zzb((byte[])byArray, (int)0, (int)byArray.length);
                            zzcjw zzcjw2 = new zzcjw();
                            try {
                                zzcjw2.zza((adg)string5);
                            }
                            catch (IOException iOException) {
                                ((zzchi)object).zzwF().zzyx().zze("Data loss. Failed to merge raw event. appId", zzcfl.zzdZ(string2), iOException);
                                continue;
                            }
                            zzcjw2.name = cursor.getString(1);
                            zzcjw2.zzbvx = cursor.getLong(2);
                            if (!zza3.zza(l4, zzcjw2)) break;
                        } while (cursor.moveToNext());
                    }
                }
                object = zza2;
                if (((zza)object).zztH == null || ((zza)object).zztH.isEmpty()) break block69;
                boolean bl = false;
                zzcjz zzcjz3 = zza2.zzbsZ;
                zza2.zzbsZ.zzbvE = new zzcjw[zza2.zztH.size()];
                int n2 = 0;
                for (n = 0; n < zza2.zztH.size(); ++n) {
                    block71: {
                        zzcjx[] zzcjxArray;
                        int n3;
                        boolean bl2;
                        boolean bl3;
                        block70: {
                            bl3 = bl;
                            if (this.zzwC().zzN(zza2.zzbsZ.zzaH, zza2.zztH.get((int)n).name)) {
                                this.zzwF().zzyz().zze("Dropping blacklisted raw event. appId", zzcfl.zzdZ(zza2.zzbsZ.zzaH), this.zzwA().zzdW(zza2.zztH.get((int)n).name));
                                if (this.zzwB().zzeA(zza2.zzbsZ.zzaH) || this.zzwB().zzeB(zza2.zzbsZ.zzaH) || "_err".equals(zza2.zztH.get((int)n).name)) continue;
                                this.zzwB().zza(zza2.zzbsZ.zzaH, 11, "_ev", zza2.zztH.get((int)n).name, 0);
                                continue;
                            }
                            bl2 = this.zzwC().zzO(zza2.zzbsZ.zzaH, zza2.zztH.get((int)n).name);
                            if (bl2) break block70;
                            this.zzwB();
                            if (!zzcjl.zzeC(zza2.zztH.get((int)n).name)) break block71;
                        }
                        boolean bl4 = false;
                        boolean bl5 = false;
                        if (zza2.zztH.get((int)n).zzbvw == null) {
                            zza2.zztH.get((int)n).zzbvw = new zzcjx[0];
                        }
                        zzcjx[] zzcjxArray2 = zza2.zztH.get((int)n).zzbvw;
                        int n4 = zza2.zztH.get((int)n).zzbvw.length;
                        for (n3 = 0; n3 < n4; ++n3) {
                            zzcjxArray = zzcjxArray2[n3];
                            if ("_c".equals(zzcjxArray.name)) {
                                zzcjxArray.zzbvA = 1L;
                                bl4 = true;
                                continue;
                            }
                            if (!"_r".equals(zzcjxArray.name)) continue;
                            zzcjxArray.zzbvA = 1L;
                            bl5 = true;
                        }
                        if (!bl4 && bl2) {
                            this.zzwF().zzyD().zzj("Marking event as conversion", this.zzwA().zzdW(zza2.zztH.get((int)n).name));
                            zzcjxArray2 = Arrays.copyOf(zza2.zztH.get((int)n).zzbvw, zza2.zztH.get((int)n).zzbvw.length + 1);
                            zzcjx zzcjx2 = new zzcjx();
                            new zzcjx().name = "_c";
                            zzcjx2.zzbvA = 1L;
                            zzcjxArray2[zzcjxArray2.length - 1] = zzcjx2;
                            zza2.zztH.get((int)n).zzbvw = zzcjxArray2;
                        }
                        if (!bl5) {
                            this.zzwF().zzyD().zzj("Marking event as real-time", this.zzwA().zzdW(zza2.zztH.get((int)n).name));
                            zzcjxArray2 = Arrays.copyOf(zza2.zztH.get((int)n).zzbvw, zza2.zztH.get((int)n).zzbvw.length + 1);
                            zzcjx zzcjx3 = new zzcjx();
                            new zzcjx().name = "_r";
                            zzcjx3.zzbvA = 1L;
                            zzcjxArray2[zzcjxArray2.length - 1] = zzcjx3;
                            zza2.zztH.get((int)n).zzbvw = zzcjxArray2;
                        }
                        bl = true;
                        if (this.zzwz().zza((long)this.zzyZ(), (String)zza2.zzbsZ.zzaH, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzbpy > (long)this.zzbsn.zzdM(zza2.zzbsZ.zzaH)) {
                            zzcjw zzcjw3 = zza2.zztH.get(n);
                            for (n3 = 0; n3 < zzcjw3.zzbvw.length; ++n3) {
                                if (!"_r".equals(zzcjw3.zzbvw[n3].name)) continue;
                                zzcjxArray = new zzcjx[zzcjw3.zzbvw.length - 1];
                                if (n3 > 0) {
                                    System.arraycopy(zzcjw3.zzbvw, 0, zzcjxArray, 0, n3);
                                }
                                if (n3 < zzcjxArray.length) {
                                    System.arraycopy(zzcjw3.zzbvw, n3 + 1, zzcjxArray, n3, zzcjxArray.length - n3);
                                }
                                zzcjw3.zzbvw = zzcjxArray;
                                break;
                            }
                            bl = bl3;
                        }
                        if (zzcjl.zzeo(zza2.zztH.get((int)n).name) && bl2 && this.zzwz().zza((long)this.zzyZ(), (String)zza2.zzbsZ.zzaH, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzbpw > (long)this.zzbsn.zzb(string2 = zza2.zzbsZ.zzaH, zzcfb.zzbqi)) {
                            this.zzwF().zzyz().zzj("Too many conversions. Not logging as conversion. appId", zzcfl.zzdZ(zza2.zzbsZ.zzaH));
                            zzcjw zzcjw4 = zza2.zztH.get(n);
                            boolean bl6 = false;
                            zzcjx zzcjx4 = null;
                            zzcjx[] zzcjxArray3 = zzcjw4.zzbvw;
                            int n5 = zzcjw4.zzbvw.length;
                            for (int i = 0; i < n5; ++i) {
                                zzcjx zzcjx5 = zzcjxArray3[i];
                                if ("_c".equals(zzcjx5.name)) {
                                    zzcjx4 = zzcjx5;
                                    continue;
                                }
                                if (!"_err".equals(zzcjx5.name)) continue;
                                bl6 = true;
                            }
                            if (bl6 && zzcjx4 != null) {
                                zzcjxArray3 = new zzcjx[zzcjw4.zzbvw.length - 1];
                                n5 = 0;
                                zzcjx[] zzcjxArray4 = zzcjw4.zzbvw;
                                int n6 = zzcjw4.zzbvw.length;
                                for (int i = 0; i < n6; ++i) {
                                    zzcjx zzcjx6 = zzcjxArray4[i];
                                    if (zzcjx6 == zzcjx4) continue;
                                    zzcjxArray3[n5++] = zzcjx6;
                                }
                                zzcjw4.zzbvw = zzcjxArray3;
                            } else if (zzcjx4 != null) {
                                zzcjx4.name = "_err";
                                zzcjx4.zzbvA = 10L;
                            } else {
                                this.zzwF().zzyx().zzj("Did not find conversion parameter. appId", zzcfl.zzdZ(zza2.zzbsZ.zzaH));
                            }
                        }
                    }
                    zzcjz3.zzbvE[n2++] = zza2.zztH.get(n);
                }
                if (n2 < zza2.zztH.size()) {
                    zzcjz3.zzbvE = Arrays.copyOf(zzcjz3.zzbvE, n2);
                }
                zzcjz3.zzbvX = this.zza(zza2.zzbsZ.zzaH, zza2.zzbsZ.zzbvF, zzcjz3.zzbvE);
                zzcjz3.zzbvH = Long.MAX_VALUE;
                zzcjz3.zzbvI = Long.MIN_VALUE;
                for (n = 0; n < zzcjz3.zzbvE.length; ++n) {
                    zzcjw zzcjw5 = zzcjz3.zzbvE[n];
                    if (zzcjw5.zzbvx < zzcjz3.zzbvH) {
                        zzcjz3.zzbvH = zzcjw5.zzbvx;
                    }
                    if (zzcjw5.zzbvx <= zzcjz3.zzbvI) continue;
                    zzcjz3.zzbvI = zzcjw5.zzbvx;
                }
                String string6 = zza2.zzbsZ.zzaH;
                zzceg zzceg2 = this.zzwz().zzdQ(string6);
                if (zzceg2 == null) {
                    this.zzwF().zzyx().zzj("Bundling raw events w/o app info. appId", zzcfl.zzdZ(zza2.zzbsZ.zzaH));
                } else if (zzcjz3.zzbvE.length > 0) {
                    long l5 = zzceg2.zzwM();
                    zzcjz3.zzbvK = l5 != 0L ? Long.valueOf(l5) : null;
                    long l6 = zzceg2.zzwL();
                    if (l6 == 0L) {
                        l6 = l5;
                    }
                    zzcjz3.zzbvJ = l6 != 0L ? Long.valueOf(l6) : null;
                    zzceg2.zzwV();
                    zzcjz3.zzbvV = (int)zzceg2.zzwS();
                    zzceg2.zzL(zzcjz3.zzbvH);
                    zzceg2.zzM(zzcjz3.zzbvI);
                    zzcjz3.zzboU = zzceg2.zzxd();
                    this.zzwz().zza(zzceg2);
                }
                if (zzcjz3.zzbvE.length > 0) {
                    zzcem.zzxE();
                    zzcjt zzcjt2 = this.zzwC().zzeh(zza2.zzbsZ.zzaH);
                    if (zzcjt2 == null || zzcjt2.zzbvl == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zzbsZ.zzboQ)) {
                            zzcjz3.zzbwb = -1L;
                        } else {
                            this.zzwF().zzyz().zzj("Did not find measurement config or missing version info. appId", zzcfl.zzdZ(zza2.zzbsZ.zzaH));
                        }
                    } else {
                        zzcjz3.zzbwb = zzcjt2.zzbvl;
                    }
                    this.zzwz().zza(zzcjz3, bl);
                }
                this.zzwz().zzG(zza2.zzbta);
                string2 = string6;
                object = this.zzwz();
                SQLiteDatabase sQLiteDatabase = ((zzcen)object).getWritableDatabase();
                try {
                    sQLiteDatabase.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{string2, string2});
                }
                catch (SQLiteException sQLiteException) {
                    ((zzchi)object).zzwF().zzyx().zze("Failed to remove unused event metadata. appId", zzcfl.zzdZ(string2), (Object)sQLiteException);
                }
                this.zzwz().setTransactionSuccessful();
                boolean bl7 = zzcjz3.zzbvE.length > 0;
                return bl7;
            }
            this.zzwz().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzwz().endTransaction();
        }
    }

    private final zzcjv[] zza(String string, zzckb[] zzckbArray, zzcjw[] zzcjwArray) {
        zzbo.zzcF((String)string);
        return this.zzws().zza(string, zzcjwArray, zzckbArray);
    }

    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        this.zzwE().zzjC();
        this.zzkD();
        zzbo.zzcF((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzwF().zzyD().zzj("onConfigFetched. Response size", byArray.length);
            this.zzwz().beginTransaction();
            try {
                boolean bl;
                zzceg zzceg2 = this.zzwz().zzdQ(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzceg2 == null) {
                    this.zzwF().zzyz().zzj("App does not exist in onConfigFetched. appId", zzcfl.zzdZ(string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzwC().zzeh(string) == null && !this.zzwC().zzb(string, null, null) : !this.zzwC().zzb(string, byArray, string2)) {
                        return;
                    }
                    zzceg2.zzR(this.zzvw.currentTimeMillis());
                    this.zzwz().zza(zzceg2);
                    if (n == 404) {
                        this.zzwF().zzyA().zzj("Config not found. Using empty config. appId", string);
                    } else {
                        this.zzwF().zzyD().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                    }
                    if (this.zzyU().zzlQ() && this.zzzb()) {
                        this.zzza();
                    } else {
                        this.zzzc();
                    }
                } else {
                    zzceg2.zzS(this.zzvw.currentTimeMillis());
                    this.zzwz().zza(zzceg2);
                    this.zzwF().zzyD().zze("Fetching config failed. code, error", n, throwable);
                    this.zzwC().zzej(string);
                    this.zzwG().zzbrl.set(this.zzvw.currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzwG().zzbrm.set(this.zzvw.currentTimeMillis());
                    }
                    this.zzzc();
                }
                this.zzwz().setTransactionSuccessful();
            }
            finally {
                this.zzwz().endTransaction();
            }
            return;
        }
        finally {
            this.zzbsU = false;
            this.zzzg();
        }
    }

    @WorkerThread
    protected final void zza(int n, Throwable throwable, byte[] byArray) {
        this.zzwE().zzjC();
        this.zzkD();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzbsO;
            this.zzbsO = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzwG().zzbrk.set(this.zzvw.currentTimeMillis());
                    this.zzwG().zzbrl.set(0L);
                    this.zzzc();
                    this.zzwF().zzyD().zze("Successful upload. Got network response. code, size", n, byArray.length);
                    this.zzwz().beginTransaction();
                    try {
                        for (Long l : list) {
                            long l2 = l;
                            zzcen zzcen2 = this.zzwz();
                            zzcen2.zzjC();
                            zzcen2.zzkD();
                            SQLiteDatabase sQLiteDatabase = zzcen2.getWritableDatabase();
                            String[] stringArray = new String[]{String.valueOf(l2)};
                            try {
                                if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                throw new SQLiteException("Deleted fewer rows from queue than expected");
                            }
                            catch (SQLiteException sQLiteException) {
                                zzcen2.zzwF().zzyx().zzj("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                throw sQLiteException;
                            }
                        }
                        this.zzwz().setTransactionSuccessful();
                    }
                    finally {
                        this.zzwz().endTransaction();
                    }
                    if (this.zzyU().zzlQ() && this.zzzb()) {
                        this.zzza();
                    } else {
                        this.zzbsS = -1L;
                        this.zzzc();
                    }
                    this.zzbsT = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzwF().zzyx().zzj("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzbsT = this.zzvw.elapsedRealtime();
                    this.zzwF().zzyD().zzj("Disable upload, time", this.zzbsT);
                }
            } else {
                this.zzwF().zzyD().zze("Network upload failed. Will retry later. code, error", n, throwable);
                this.zzwG().zzbrl.set(this.zzvw.currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzwG().zzbrm.set(this.zzvw.currentTimeMillis());
                }
                this.zzzc();
            }
            return;
        }
        finally {
            this.zzbsV = false;
            this.zzzg();
        }
    }

    private final boolean zzzb() {
        this.zzwE().zzjC();
        this.zzkD();
        return this.zzwz().zzyh() || !TextUtils.isEmpty((CharSequence)this.zzwz().zzyc());
    }

    @WorkerThread
    private final void zzzc() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            this.zzwE().zzjC();
            this.zzkD();
            if (!this.zzzf()) {
                return;
            }
            if (this.zzbsT > 0L) {
                l3 = this.zzvw.elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzbsT);
                if (l2 > 0L) {
                    this.zzwF().zzyD().zzj("Upload has been suspended. Will update scheduling later in approximately ms", l2);
                    this.zzyV().unregister();
                    this.zzyW().cancel();
                    return;
                }
                this.zzbsT = 0L;
            }
            if (!this.zzyP() || !this.zzzb()) {
                this.zzwF().zzyD().log("Nothing to upload or uploading impossible");
                this.zzyV().unregister();
                this.zzyW().cancel();
                return;
            }
            zzcgl zzcgl2 = this;
            long l4 = zzcgl2.zzvw.currentTimeMillis();
            long l5 = zzcem.zzxX();
            boolean bl = zzcgl2.zzwz().zzyi() || zzcgl2.zzwz().zzyd();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzcgl2.zzbsn.zzya())) && !".none.".equals(string) ? zzcem.zzxT() : zzcem.zzxS()) : zzcem.zzxR();
            long l7 = zzcgl2.zzwG().zzbrk.get();
            long l8 = zzcgl2.zzwG().zzbrl.get();
            long l9 = zzcgl2.zzwz().zzyf();
            long l10 = zzcgl2.zzwz().zzyg();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzcgl2.zzwB().zzf(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < zzcem.zzxZ(); ++i) {
                        long l15 = 1 << i;
                        if ((l14 += zzcem.zzxY() * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzwF().zzyD().log("Next upload time is 0");
            this.zzyV().unregister();
            this.zzyW().cancel();
            return;
        }
        if (!this.zzyU().zzlQ()) {
            this.zzwF().zzyD().log("No network");
            this.zzyV().zzlN();
            this.zzyW().cancel();
            return;
        }
        l2 = this.zzwG().zzbrm.get();
        long l16 = zzcem.zzxQ();
        if (!this.zzwB().zzf(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzyV().unregister();
        long l17 = l3 - this.zzvw.currentTimeMillis();
        if (l17 <= 0L) {
            l17 = zzcem.zzxU();
            this.zzwG().zzbrk.set(this.zzvw.currentTimeMillis());
        }
        this.zzwF().zzyD().zzj("Upload scheduled in approximately ms", l17);
        this.zzyW().zzs(l17);
    }

    public final void zzam(boolean bl) {
        this.zzzc();
    }

    final void zzb(zzchj zzchj2) {
        ++this.zzbsQ;
    }

    final void zzzd() {
        ++this.zzbsR;
    }

    @WorkerThread
    public final void zze(zzceh zzceh2) {
        int n;
        this.zzwE().zzjC();
        this.zzkD();
        zzbo.zzu((Object)((Object)zzceh2));
        zzbo.zzcF((String)zzceh2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzceh2.zzboQ)) {
            return;
        }
        zzceg zzceg2 = this.zzwz().zzdQ(zzceh2.packageName);
        if (zzceg2 != null && TextUtils.isEmpty((CharSequence)zzceg2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzceh2.zzboQ)) {
            zzceg2.zzR(0L);
            this.zzwz().zza(zzceg2);
            this.zzwC().zzek(zzceh2.packageName);
        }
        if (!zzceh2.zzboV) {
            this.zzf(zzceh2);
            return;
        }
        long l = zzceh2.zzbpa;
        if (l == 0L) {
            l = this.zzvw.currentTimeMillis();
        }
        if ((n = zzceh2.zzbpb) != 0 && n != 1) {
            this.zzwF().zzyz().zze("Incorrect app type, assuming installed app. appId, appType", zzcfl.zzdZ(zzceh2.packageName), n);
            n = 0;
        }
        this.zzwz().beginTransaction();
        try {
            zzcez zzcez2;
            Object object;
            long l2 = l;
            zzceh zzceh3 = zzceh2;
            zzcgl zzcgl2 = this;
            zzceg zzceg3 = zzcgl2.zzwz().zzdQ(zzceh3.packageName);
            if (zzceg3 != null && zzceg3.getGmpAppId() != null && !zzceg3.getGmpAppId().equals(zzceh3.zzboQ)) {
                zzcgl2.zzwF().zzyz().zzj("New GMP App Id passed in. Removing cached database data. appId", zzcfl.zzdZ(zzceg3.zzhl()));
                String string = zzceg3.zzhl();
                zzcen zzcen2 = zzcgl2.zzwz();
                zzcen2.zzkD();
                zzcen2.zzjC();
                zzbo.zzcF((String)string);
                try {
                    SQLiteDatabase sQLiteDatabase = zzcen2.getWritableDatabase();
                    String[] stringArray = new String[]{string};
                    int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                    if (n2 > 0) {
                        zzcen2.zzwF().zzyD().zze("Deleted application data. app, records", string, n2);
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzcen2.zzwF().zzyx().zze("Error deleting application data. appId, error", zzcfl.zzdZ(string), (Object)sQLiteException);
                }
                zzceg3 = null;
            }
            if (zzceg3 != null && zzceg3.zzjH() != null && !zzceg3.zzjH().equals(zzceh3.zzbgW)) {
                object = new Bundle();
                object.putString("_pv", zzceg3.zzjH());
                zzcez2 = new zzcez("_au", new zzcew((Bundle)object), "auto", l2);
                zzcgl2.zzb(zzcez2, zzceh3);
            }
            this.zzf(zzceh2);
            zzcev zzcev2 = null;
            if (n == 0) {
                zzcev2 = this.zzwz().zzE(zzceh2.packageName, "_f");
            } else if (n == 1) {
                zzcev2 = this.zzwz().zzE(zzceh2.packageName, "_v");
            }
            if (zzcev2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    com.google.android.gms.common.internal.safeparcel.zza zza2;
                    zzcji zzcji2 = new zzcji("_fot", l, l3, "auto");
                    this.zzb(zzcji2, zzceh2);
                    l2 = l;
                    zzceh3 = zzceh2;
                    zzcgl2 = this;
                    zzcgl2.zzwE().zzjC();
                    zzcgl2.zzkD();
                    zzceg3 = new Bundle();
                    zzceg3.putLong("_c", 1L);
                    zzceg3.putLong("_r", 1L);
                    zzceg3.putLong("_uwa", 0L);
                    zzceg3.putLong("_pfo", 0L);
                    zzceg3.putLong("_sys", 0L);
                    zzceg3.putLong("_sysu", 0L);
                    if (zzcgl2.mContext.getPackageManager() == null) {
                        zzcgl2.zzwF().zzyx().zzj("PackageManager is null, first open report might be inaccurate. appId", zzcfl.zzdZ(zzceh3.packageName));
                    } else {
                        zzcez2 = null;
                        try {
                            zzcez2 = zzbha.zzaP((Context)zzcgl2.mContext).getPackageInfo(zzceh3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzcgl2.zzwF().zzyx().zze("Package info is null, first open report might be inaccurate. appId", zzcfl.zzdZ(zzceh3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzcez2 != null && ((PackageInfo)zzcez2).firstInstallTime != 0L) {
                            boolean bl = false;
                            if (((PackageInfo)zzcez2).firstInstallTime != ((PackageInfo)zzcez2).lastUpdateTime) {
                                zzceg3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            zza2 = new zzcji("_fi", l2, bl ? 1L : 0L, "auto");
                            zzcgl2.zzb((zzcji)zza2, zzceh3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = zzbha.zzaP((Context)zzcgl2.mContext).getApplicationInfo(zzceh3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzcgl2.zzwF().zzyx().zze("Application info is null, first open report might be inaccurate. appId", zzcfl.zzdZ(zzceh3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzceg3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzceg3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzceh3.packageName;
                    zzcen zzcen3 = zzcgl2.zzwz();
                    zzbo.zzcF((String)string);
                    zzcen3.zzjC();
                    zzcen3.zzkD();
                    long l4 = zzcen3.zzL(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzceg3.putLong("_pfo", l4);
                    }
                    zza2 = new zzcez("_f", new zzcew((Bundle)zzceg3), "auto", l2);
                    zzcgl2.zzb((zzcez)zza2, zzceh3);
                } else if (n == 1) {
                    zzcji zzcji3 = new zzcji("_fvt", l, l3, "auto");
                    this.zzb(zzcji3, zzceh2);
                    l2 = l;
                    zzceh3 = zzceh2;
                    zzcgl2 = this;
                    zzcgl2.zzwE().zzjC();
                    zzcgl2.zzkD();
                    zzceg3 = new Bundle();
                    zzceg3.putLong("_c", 1L);
                    zzceg3.putLong("_r", 1L);
                    object = new zzcez("_v", new zzcew((Bundle)zzceg3), "auto", l2);
                    zzcgl2.zzb((zzcez)((Object)object), zzceh3);
                }
                l2 = l;
                zzceh3 = zzceh2;
                zzcgl2 = this;
                zzceg3 = new Bundle();
                zzceg3.putLong("_et", 1L);
                object = new zzcez("_e", new zzcew((Bundle)zzceg3), "auto", l2);
                zzcgl2.zzb((zzcez)((Object)object), zzceh3);
            } else if (zzceh2.zzboW) {
                l2 = l;
                zzceh3 = zzceh2;
                zzcgl2 = this;
                zzceg3 = new Bundle();
                object = new zzcez("_cd", new zzcew((Bundle)zzceg3), "auto", l2);
                zzcgl2.zzb((zzcez)((Object)object), zzceh3);
            }
            this.zzwz().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzwz().endTransaction();
        }
    }

    @WorkerThread
    private final void zzf(zzceh zzceh2) {
        this.zzwE().zzjC();
        this.zzkD();
        zzbo.zzu((Object)((Object)zzceh2));
        zzbo.zzcF((String)zzceh2.packageName);
        zzceg zzceg2 = this.zzwz().zzdQ(zzceh2.packageName);
        String string = this.zzwG().zzec(zzceh2.packageName);
        boolean bl = false;
        if (zzceg2 == null) {
            zzceg2 = new zzceg(this, zzceh2.packageName);
            zzceg2.zzdG(this.zzwu().zzyu());
            zzceg2.zzdI(string);
            bl = true;
        } else if (!string.equals(zzceg2.zzwJ())) {
            zzceg2.zzdI(string);
            zzceg2.zzdG(this.zzwu().zzyu());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzceh2.zzboQ) && !zzceh2.zzboQ.equals(zzceg2.getGmpAppId())) {
            zzceg2.zzdH(zzceh2.zzboQ);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzceh2.zzboY) && !zzceh2.zzboY.equals(zzceg2.zzwK())) {
            zzceg2.zzdJ(zzceh2.zzboY);
            bl = true;
        }
        if (zzceh2.zzboS != 0L && zzceh2.zzboS != zzceg2.zzwP()) {
            zzceg2.zzO(zzceh2.zzboS);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzceh2.zzbgW) && !zzceh2.zzbgW.equals(zzceg2.zzjH())) {
            zzceg2.setAppVersion(zzceh2.zzbgW);
            bl = true;
        }
        if (zzceh2.zzboX != zzceg2.zzwN()) {
            zzceg2.zzN(zzceh2.zzboX);
            bl = true;
        }
        if (zzceh2.zzboR != null && !zzceh2.zzboR.equals(zzceg2.zzwO())) {
            zzceg2.zzdK(zzceh2.zzboR);
            bl = true;
        }
        if (zzceh2.zzboT != zzceg2.zzwQ()) {
            zzceg2.zzP(zzceh2.zzboT);
            bl = true;
        }
        if (zzceh2.zzboV != zzceg2.zzwR()) {
            zzceg2.setMeasurementEnabled(zzceh2.zzboV);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzceh2.zzboU) && !zzceh2.zzboU.equals(zzceg2.zzxc())) {
            zzceg2.zzdL(zzceh2.zzboU);
            bl = true;
        }
        if (zzceh2.zzboZ != zzceg2.zzxe()) {
            zzceg2.zzZ(zzceh2.zzboZ);
            bl = true;
        }
        if (bl) {
            this.zzwz().zza(zzceg2);
        }
    }

    @WorkerThread
    final void zzze() {
        this.zzwE().zzjC();
        this.zzkD();
        if (!this.zzbsJ) {
            this.zzwF().zzyB().log("This instance being marked as an uploader");
            zzcgl zzcgl2 = this;
            zzcgl2.zzwE().zzjC();
            zzcgl2.zzkD();
            if (zzcgl2.zzzf() && zzcgl2.zzyX()) {
                int n;
                int n2 = zzcgl2.zza(zzcgl2.zzbsN);
                int n3 = n = zzcgl2.zzwu().zzyv();
                int n4 = n2;
                zzcgl zzcgl3 = zzcgl2;
                zzcgl3.zzwE().zzjC();
                if (n4 > n3) {
                    zzcgl3.zzwF().zzyx().zze("Panic: can't downgrade version. Previous, current version", n4, n3);
                } else if (n4 < n3) {
                    if (zzcgl3.zza(n3, zzcgl3.zzbsN)) {
                        zzcgl3.zzwF().zzyD().zze("Storage version upgraded. Previous, current version", n4, n3);
                    } else {
                        zzcgl3.zzwF().zzyx().zze("Storage version upgrade failed. Previous, current version", n4, n3);
                    }
                }
            }
            this.zzbsJ = true;
            this.zzzc();
        }
    }

    @WorkerThread
    private final boolean zzzf() {
        this.zzwE().zzjC();
        this.zzkD();
        return this.zzbsJ;
    }

    @WorkerThread
    final void zzl(Runnable runnable) {
        this.zzwE().zzjC();
        if (this.zzbsP == null) {
            this.zzbsP = new ArrayList<Runnable>();
        }
        this.zzbsP.add(runnable);
    }

    @WorkerThread
    private final void zzzg() {
        this.zzwE().zzjC();
        if (this.zzbsU || this.zzbsV || this.zzbsW) {
            this.zzwF().zzyD().zzd("Not stopping services. fetch, network, upload", this.zzbsU, this.zzbsV, this.zzbsW);
            return;
        }
        this.zzwF().zzyD().log("Stopping uploading service(s)");
        if (this.zzbsP == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzbsP.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzbsP.clear();
    }

    final class zza
    implements zzcep {
        zzcjz zzbsZ;
        List<Long> zzbta;
        List<zzcjw> zztH;
        private long zzbtb;
        private /* synthetic */ zzcgl zzbsY;

        private zza(zzcgl zzcgl2) {
            this.zzbsY = zzcgl2;
        }

        @Override
        public final void zzb(zzcjz zzcjz2) {
            zzbo.zzu((Object)((Object)zzcjz2));
            this.zzbsZ = zzcjz2;
        }

        @Override
        public final boolean zza(long l, zzcjw zzcjw2) {
            zzbo.zzu((Object)((Object)zzcjw2));
            if (this.zztH == null) {
                this.zztH = new ArrayList<zzcjw>();
            }
            if (this.zzbta == null) {
                this.zzbta = new ArrayList<Long>();
            }
            if (this.zztH.size() > 0 && zza.zza(this.zztH.get(0)) != zza.zza(zzcjw2)) {
                return false;
            }
            long l2 = this.zzbtb + (long)zzcjw2.zzLW();
            if (l2 >= (long)zzcem.zzxL()) {
                return false;
            }
            this.zzbtb = l2;
            this.zztH.add(zzcjw2);
            this.zzbta.add(l);
            return this.zztH.size() < zzcem.zzxM();
        }

        private static long zza(zzcjw zzcjw2) {
            return zzcjw2.zzbvx / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzcgl zzcgl2, zzcgm zzcgm2) {
            this(zzcgl2);
        }
    }
}

