/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.util.zzw;
import com.google.android.gms.common.zzo;
import com.google.android.gms.common.zzp;
import com.google.android.gms.internal.zzceh;
import com.google.android.gms.internal.zzcek;
import com.google.android.gms.internal.zzcez;
import com.google.android.gms.internal.zzcfe;
import com.google.android.gms.internal.zzcfl;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzcgr;
import com.google.android.gms.internal.zzcgs;
import com.google.android.gms.internal.zzcgt;
import com.google.android.gms.internal.zzcgu;
import com.google.android.gms.internal.zzcgv;
import com.google.android.gms.internal.zzcgw;
import com.google.android.gms.internal.zzcgx;
import com.google.android.gms.internal.zzcgy;
import com.google.android.gms.internal.zzcgz;
import com.google.android.gms.internal.zzcha;
import com.google.android.gms.internal.zzchb;
import com.google.android.gms.internal.zzchc;
import com.google.android.gms.internal.zzchd;
import com.google.android.gms.internal.zzche;
import com.google.android.gms.internal.zzchf;
import com.google.android.gms.internal.zzchg;
import com.google.android.gms.internal.zzchh;
import com.google.android.gms.internal.zzcji;
import com.google.android.gms.internal.zzcjk;
import com.google.android.gms.internal.zzcjl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzcgq
extends zzcfe {
    private final zzcgl zzboe;
    private Boolean zzbtc;
    @Nullable
    private String zzbtd;

    public zzcgq(zzcgl zzcgl2) {
        this(zzcgl2, null);
    }

    private zzcgq(zzcgl zzcgl2, @Nullable String string) {
        zzbo.zzu((Object)zzcgl2);
        this.zzboe = zzcgl2;
        this.zzbtd = null;
    }

    @Override
    @BinderThread
    public final void zzb(zzceh zzceh2) {
        this.zzb(zzceh2, false);
        this.zzboe.zzwE().zzj(new zzcgr(this, zzceh2));
    }

    @Override
    @BinderThread
    public final void zza(zzcez zzcez2, zzceh zzceh2) {
        zzbo.zzu((Object)((Object)zzcez2));
        this.zzb(zzceh2, false);
        this.zzboe.zzwE().zzj(new zzcha(this, zzcez2, zzceh2));
    }

    @Override
    @BinderThread
    public final void zza(zzcez zzcez2, String string, String string2) {
        zzbo.zzu((Object)((Object)zzcez2));
        zzbo.zzcF((String)string);
        this.zzh(string, true);
        this.zzboe.zzwE().zzj(new zzchb(this, zzcez2, string));
    }

    @Override
    @BinderThread
    public final byte[] zza(zzcez zzcez2, String string) {
        zzbo.zzcF((String)string);
        zzbo.zzu((Object)((Object)zzcez2));
        this.zzh(string, true);
        this.zzboe.zzwF().zzyC().zzj("Log and bundle. event", this.zzboe.zzwA().zzdW(zzcez2.name));
        long l = this.zzboe.zzkq().nanoTime() / 1000000L;
        Future<byte[]> future = this.zzboe.zzwE().zzf(new zzchc(this, zzcez2, string));
        try {
            byte[] byArray = future.get();
            if (byArray == null) {
                this.zzboe.zzwF().zzyx().zzj("Log and bundle returned null. appId", zzcfl.zzdZ(string));
                byArray = new byte[]{};
            }
            long l2 = this.zzboe.zzkq().nanoTime() / 1000000L;
            this.zzboe.zzwF().zzyC().zzd("Log and bundle processed. event, size, time_ms", this.zzboe.zzwA().zzdW(zzcez2.name), byArray.length, l2 - l);
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzboe.zzwF().zzyx().zzd("Failed to log and bundle. appId, event, error", zzcfl.zzdZ(string), this.zzboe.zzwA().zzdW(zzcez2.name), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzcji zzcji2, zzceh zzceh2) {
        zzbo.zzu((Object)((Object)zzcji2));
        this.zzb(zzceh2, false);
        if (zzcji2.getValue() == null) {
            this.zzboe.zzwE().zzj(new zzchd(this, zzcji2, zzceh2));
            return;
        }
        this.zzboe.zzwE().zzj(new zzche(this, zzcji2, zzceh2));
    }

    @Override
    @BinderThread
    public final List<zzcji> zza(zzceh zzceh2, boolean bl) {
        this.zzb(zzceh2, false);
        Future<List<zzcjk>> future = this.zzboe.zzwE().zze(new zzchf(this, zzceh2));
        try {
            List<zzcjk> list = future.get();
            ArrayList<zzcji> arrayList = new ArrayList<zzcji>(list.size());
            for (zzcjk zzcjk2 : list) {
                if (!bl && zzcjl.zzex(zzcjk2.mName)) continue;
                arrayList.add(new zzcji(zzcjk2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzboe.zzwF().zzyx().zze("Failed to get user attributes. appId", zzcfl.zzdZ(zzceh2.packageName), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzceh zzceh2) {
        this.zzb(zzceh2, false);
        zzchg zzchg2 = new zzchg(this, zzceh2);
        if (this.zzboe.zzwE().zzyM()) {
            zzchg2.run();
            return;
        }
        this.zzboe.zzwE().zzj(zzchg2);
    }

    @BinderThread
    private final void zzb(zzceh zzceh2, boolean bl) {
        zzbo.zzu((Object)((Object)zzceh2));
        this.zzh(zzceh2.packageName, false);
        this.zzboe.zzwB().zzev(zzceh2.zzboQ);
    }

    @BinderThread
    private final void zzh(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzboe.zzwF().zzyx().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzcgq zzcgq2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzcgq2 = this;
                    if (!bl2) break block9;
                    if (zzcgq2.zzbtc == null) {
                        zzcgq2.zzbtc = "com.google.android.gms".equals(zzcgq2.zzbtd) || zzw.zzf((Context)zzcgq2.zzboe.getContext(), (int)Binder.getCallingUid()) || zzp.zzax((Context)zzcgq2.zzboe.getContext()).zza(zzcgq2.zzboe.getContext().getPackageManager(), Binder.getCallingUid());
                    }
                    if (zzcgq2.zzbtc.booleanValue()) break block10;
                }
                if (zzcgq2.zzbtd == null && zzo.zzb((Context)zzcgq2.zzboe.getContext(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzcgq2.zzbtd = string2;
                }
                if (!string2.equals(zzcgq2.zzbtd)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zzboe.zzwF().zzyx().zzj("Measurement Service called with invalid calling package. appId", zzcfl.zzdZ(string));
            throw securityException;
        }
    }

    @Override
    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zzboe.zzwE().zzj(new zzchh(this, string2, string3, string, l));
    }

    @Override
    @BinderThread
    public final String zzc(zzceh zzceh2) {
        this.zzb(zzceh2, false);
        return this.zzboe.zzem(zzceh2.packageName);
    }

    @Override
    @BinderThread
    public final void zza(zzcek zzcek2, zzceh zzceh2) {
        zzbo.zzu((Object)((Object)zzcek2));
        zzbo.zzu((Object)((Object)zzcek2.zzbpd));
        this.zzb(zzceh2, false);
        zzcek zzcek3 = new zzcek(zzcek2);
        new zzcek(zzcek2).packageName = zzceh2.packageName;
        if (zzcek2.zzbpd.getValue() == null) {
            this.zzboe.zzwE().zzj(new zzcgs(this, zzcek3, zzceh2));
            return;
        }
        this.zzboe.zzwE().zzj(new zzcgt(this, zzcek3, zzceh2));
    }

    @Override
    @BinderThread
    public final void zzb(zzcek zzcek2) {
        zzbo.zzu((Object)((Object)zzcek2));
        zzbo.zzu((Object)((Object)zzcek2.zzbpd));
        this.zzh(zzcek2.packageName, true);
        zzcek zzcek3 = new zzcek(zzcek2);
        if (zzcek2.zzbpd.getValue() == null) {
            this.zzboe.zzwE().zzj(new zzcgu(this, zzcek3));
            return;
        }
        this.zzboe.zzwE().zzj(new zzcgv(this, zzcek3));
    }

    @Override
    @BinderThread
    public final List<zzcji> zza(String string, String string2, boolean bl, zzceh zzceh2) {
        this.zzb(zzceh2, false);
        Future<List<zzcjk>> future = this.zzboe.zzwE().zze(new zzcgw(this, zzceh2, string, string2));
        try {
            List<zzcjk> list = future.get();
            ArrayList<zzcji> arrayList = new ArrayList<zzcji>(list.size());
            for (zzcjk zzcjk2 : list) {
                if (!bl && zzcjl.zzex(zzcjk2.mName)) continue;
                arrayList.add(new zzcji(zzcjk2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzboe.zzwF().zzyx().zze("Failed to get user attributes. appId", zzcfl.zzdZ(zzceh2.packageName), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcji> zza(String string, String string2, String string3, boolean bl) {
        this.zzh(string, true);
        Future<List<zzcjk>> future = this.zzboe.zzwE().zze(new zzcgx(this, string, string2, string3));
        try {
            List<zzcjk> list = future.get();
            ArrayList<zzcji> arrayList = new ArrayList<zzcji>(list.size());
            for (zzcjk zzcjk2 : list) {
                if (!bl && zzcjl.zzex(zzcjk2.mName)) continue;
                arrayList.add(new zzcji(zzcjk2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzboe.zzwF().zzyx().zze("Failed to get user attributes. appId", zzcfl.zzdZ(string), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcek> zza(String string, String string2, zzceh zzceh2) {
        this.zzb(zzceh2, false);
        Future<List<zzcek>> future = this.zzboe.zzwE().zze(new zzcgy(this, zzceh2, string, string2));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzboe.zzwF().zzyx().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcek> zzk(String string, String string2, String string3) {
        this.zzh(string, true);
        Future<List<zzcek>> future = this.zzboe.zzwE().zze(new zzcgz(this, string, string2, string3));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzboe.zzwF().zzyx().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    static /* synthetic */ zzcgl zza(zzcgq zzcgq2) {
        return zzcgq2.zzboe;
    }
}

