/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.zzcem;
import com.google.android.gms.internal.zzcer;
import com.google.android.gms.internal.zzcgc;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzciw;
import com.google.android.gms.internal.zzcjh;

public final class zzcjg
extends zzchj {
    private final AlarmManager zzahd = (AlarmManager)super.getContext().getSystemService("alarm");
    private final zzcer zzbuv;
    private Integer zzbuw;

    protected zzcjg(zzcgl zzcgl2) {
        super(zzcgl2);
        this.zzbuv = new zzcjh(this, zzcgl2);
    }

    @Override
    protected final void zzjD() {
        this.zzahd.cancel(this.zzlD());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzzq();
        }
    }

    @TargetApi(value=24)
    private final void zzzq() {
        JobScheduler jobScheduler = (JobScheduler)super.getContext().getSystemService("jobscheduler");
        super.zzwF().zzyD().zzj("Cancelling job. JobID", this.getJobId());
        jobScheduler.cancel(this.getJobId());
    }

    public final void zzs(long l) {
        this.zzkD();
        zzcem.zzxE();
        if (!zzcgc.zzj(super.getContext(), false)) {
            super.zzwF().zzyC().log("Receiver not registered/enabled");
        }
        zzcem.zzxE();
        if (!zzciw.zzk(super.getContext(), false)) {
            super.zzwF().zzyC().log("Service not registered/enabled");
        }
        this.cancel();
        long l2 = super.zzkq().elapsedRealtime() + l;
        if (l < zzcem.zzxV() && !this.zzbuv.zzbo()) {
            super.zzwF().zzyD().log("Scheduling upload with DelayedRunnable");
            this.zzbuv.zzs(l);
        }
        zzcem.zzxE();
        if (Build.VERSION.SDK_INT >= 24) {
            super.zzwF().zzyD().log("Scheduling upload with JobScheduler");
            long l3 = l;
            zzcjg zzcjg2 = this;
            ComponentName componentName = new ComponentName(super.getContext(), "com.google.android.gms.measurement.AppMeasurementJobService");
            JobScheduler jobScheduler = (JobScheduler)super.getContext().getSystemService("jobscheduler");
            JobInfo.Builder builder = new JobInfo.Builder(zzcjg2.getJobId(), componentName);
            builder.setMinimumLatency(l3);
            builder.setOverrideDeadline(l3 << 1);
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            builder.setExtras(persistableBundle);
            JobInfo jobInfo = builder.build();
            super.zzwF().zzyD().zzj("Scheduling job. JobID", zzcjg2.getJobId());
            jobScheduler.schedule(jobInfo);
            return;
        }
        super.zzwF().zzyD().log("Scheduling upload with AlarmManager");
        this.zzahd.setInexactRepeating(2, l2, Math.max(zzcem.zzxW(), l), this.zzlD());
    }

    private final int getJobId() {
        if (this.zzbuw == null) {
            String string = String.valueOf(super.getContext().getPackageName());
            this.zzbuw = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zzbuw;
    }

    public final void cancel() {
        this.zzkD();
        this.zzahd.cancel(this.zzlD());
        this.zzbuv.cancel();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzzq();
        }
    }

    private final PendingIntent zzlD() {
        Intent intent = new Intent();
        Context context = super.getContext();
        zzcem.zzxE();
        Intent intent2 = intent.setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver");
        intent2.setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)super.getContext(), (int)0, (Intent)intent2, (int)0);
    }

    private final void zzzr() {
        Intent intent = new Intent();
        Context context = super.getContext();
        zzcem.zzxE();
        Intent intent2 = intent.setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver");
        intent2.setAction("com.google.android.gms.measurement.UPLOAD");
        super.getContext().sendBroadcast(intent2);
    }

    static /* synthetic */ void zza(zzcjg zzcjg2) {
        zzcjg2.zzzr();
    }
}

