/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzcfd;
import com.google.android.gms.internal.zzcff;
import com.google.android.gms.internal.zzcfk;
import com.google.android.gms.internal.zzcfl;
import com.google.android.gms.internal.zzcid;
import com.google.android.gms.internal.zzcir;
import com.google.android.gms.internal.zzcis;
import com.google.android.gms.internal.zzcit;
import com.google.android.gms.internal.zzciu;
import com.google.android.gms.internal.zzciv;

public final class zzciq
implements ServiceConnection,
zzf,
zzg {
    private volatile boolean zzbuh;
    private volatile zzcfk zzbui;
    final /* synthetic */ zzcid zzbua;

    protected zzciq(zzcid zzcid2) {
        this.zzbua = zzcid2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzk(Intent intent) {
        this.zzbua.zzjC();
        Context context = this.zzbua.getContext();
        zza zza2 = zza.zzrU();
        zzciq zzciq2 = this;
        synchronized (zzciq2) {
            if (this.zzbuh) {
                this.zzbua.zzwF().zzyD().log("Connection attempt already in progress");
                return;
            }
            this.zzbuh = true;
            zza2.zza(context, intent, (ServiceConnection)zzcid.zza(this.zzbua), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        zzbo.zzcz((String)"MeasurementServiceConnection.onServiceConnected");
        zzciq zzciq2 = this;
        synchronized (zzciq2) {
            IInterface iInterface;
            String string;
            if (iBinder == null) {
                this.zzbuh = false;
                this.zzbua.zzwF().zzyx().log("Service connected with null binder");
                return;
            }
            zzcfd zzcfd2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IBinder iBinder2 = iBinder;
                    zzcfd2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzcfd ? (zzcfd)iInterface : new zzcff(iBinder2));
                    this.zzbua.zzwF().zzyD().log("Bound to IMeasurementService interface");
                } else {
                    this.zzbua.zzwF().zzyx().zzj("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                this.zzbua.zzwF().zzyx().log("Service connect failed to get IMeasurementService");
            }
            if (zzcfd2 == null) {
                this.zzbuh = false;
                try {
                    zza.zzrU();
                    zzciq zzciq3 = zzcid.zza(this.zzbua);
                    iInterface = this.zzbua.getContext();
                    iInterface.unbindService((ServiceConnection)zzciq3);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzcfd2;
                this.zzbua.zzwE().zzj(new zzcir(this, (zzcfd)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        zzbo.zzcz((String)"MeasurementServiceConnection.onServiceDisconnected");
        this.zzbua.zzwF().zzyC().log("Service disconnected");
        this.zzbua.zzwE().zzj(new zzcis(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzzm() {
        this.zzbua.zzjC();
        Context context = this.zzbua.getContext();
        zzciq zzciq2 = this;
        synchronized (zzciq2) {
            if (this.zzbuh) {
                this.zzbua.zzwF().zzyD().log("Connection attempt already in progress");
                return;
            }
            if (this.zzbui != null) {
                this.zzbua.zzwF().zzyD().log("Already awaiting connection attempt");
                return;
            }
            this.zzbui = new zzcfk(context, Looper.getMainLooper(), this, this);
            this.zzbua.zzwF().zzyD().log("Connecting to remote service");
            this.zzbuh = true;
            this.zzbui.zzrb();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        zzbo.zzcz((String)"MeasurementServiceConnection.onConnected");
        zzciq zzciq2 = this;
        synchronized (zzciq2) {
            try {
                zzcfd zzcfd2 = (zzcfd)this.zzbui.zzrf();
                this.zzbui = null;
                this.zzbua.zzwE().zzj(new zzcit(this, zzcfd2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzbui = null;
                this.zzbuh = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        zzbo.zzcz((String)"MeasurementServiceConnection.onConnectionSuspended");
        this.zzbua.zzwF().zzyC().log("Service connection suspended");
        this.zzbua.zzwE().zzj(new zzciu(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        zzbo.zzcz((String)"MeasurementServiceConnection.onConnectionFailed");
        zzcfl zzcfl2 = this.zzbua.zzboe.zzyQ();
        if (zzcfl2 != null) {
            zzcfl2.zzyz().zzj("Service connection failed", connectionResult);
        }
        zzciq zzciq2 = this;
        synchronized (zzciq2) {
            this.zzbuh = false;
            this.zzbui = null;
        }
        this.zzbua.zzwE().zzj(new zzciv(this));
    }

    static /* synthetic */ boolean zza(zzciq zzciq2, boolean bl) {
        zzciq2.zzbuh = false;
        return false;
    }
}

