/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzcaf;
import com.google.android.gms.internal.zzcai;
import com.google.android.gms.internal.zzcap;
import com.google.android.gms.internal.zzccj;
import com.google.android.gms.internal.zzcco;
import com.google.android.gms.internal.zzcdl;
import com.google.android.gms.internal.zzcdm;
import com.google.android.gms.internal.zzced;
import com.google.android.gms.internal.zzcee;
import com.google.android.gms.internal.zzcef;
import com.google.android.gms.internal.zzcfo;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class zzcec
extends zzcdm {
    protected zzcef zziva;
    private volatile AppMeasurement.zzb zzivb;
    private AppMeasurement.zzb zzivc;
    private long zzivd;
    private final Map<Activity, zzcef> zzive = new ArrayMap();
    private final CopyOnWriteArrayList<AppMeasurement.zza> zzivf = new CopyOnWriteArrayList();
    private boolean zzivg;
    private AppMeasurement.zzb zzivh;
    private String zzivi;

    public zzcec(zzcco zzcco2) {
        super(zzcco2);
    }

    @Override
    protected final void zzuh() {
    }

    @WorkerThread
    public final zzcef zzazm() {
        this.zzwh();
        ((zzcdl)this).zzug();
        return this.zziva;
    }

    @MainThread
    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (activity == null) {
            ((zzcdl)this).zzauk().zzaye().log("setCurrentScreen must be called with a non-null activity");
            return;
        }
        ((zzcdl)this).zzauj();
        if (!zzccj.zzaq()) {
            ((zzcdl)this).zzauk().zzaye().log("setCurrentScreen must be called from the main thread");
            return;
        }
        if (this.zzivg) {
            ((zzcdl)this).zzauk().zzaye().log("Cannot call setCurrentScreen from onScreenChangeCallback");
            return;
        }
        if (this.zzivb == null) {
            ((zzcdl)this).zzauk().zzaye().log("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzive.get(activity) == null) {
            ((zzcdl)this).zzauk().zzaye().log("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzcec.zzjt(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzivb.zzikh.equals(string2);
        boolean bl2 = zzcfo.zzau(this.zzivb.zzikg, string);
        if (bl && bl2) {
            ((zzcdl)this).zzauk().zzayf().log("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > zzcap.zzavp())) {
            ((zzcdl)this).zzauk().zzaye().zzj("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > zzcap.zzavp())) {
            ((zzcdl)this).zzauk().zzaye().zzj("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzcdl)this).zzauk().zzayi().zze("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzcef zzcef2 = new zzcef(string, string2, ((zzcdl)this).zzaug().zzazw());
        this.zzive.put(activity, zzcef2);
        this.zza(activity, zzcef2, true);
    }

    public final AppMeasurement.zzb zzazn() {
        ((zzcdl)this).zzatu();
        AppMeasurement.zzb zzb2 = this.zzivb;
        if (zzb2 == null) {
            return null;
        }
        return new AppMeasurement.zzb(zzb2);
    }

    @MainThread
    public final void registerOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        ((zzcdl)this).zzatu();
        if (zza2 == null) {
            ((zzcdl)this).zzauk().zzaye().log("Attempting to register null OnScreenChangeCallback");
            return;
        }
        this.zzivf.remove(zza2);
        this.zzivf.add(zza2);
    }

    @MainThread
    public final void unregisterOnScreenChangeCallback(@NonNull AppMeasurement.zza zza2) {
        ((zzcdl)this).zzatu();
        this.zzivf.remove(zza2);
    }

    @MainThread
    private final void zza(Activity activity, zzcef zzcef2, boolean bl) {
        Object object;
        Object object2;
        AppMeasurement.zzb zzb2 = null;
        if (this.zzivb != null) {
            zzb2 = this.zzivb;
        } else if (this.zzivc != null && Math.abs(((zzcdl)this).zzvu().elapsedRealtime() - this.zzivd) < 1000L) {
            zzb2 = this.zzivc;
        }
        AppMeasurement.zzb zzb3 = null;
        if (zzb2 != null) {
            zzb3 = new AppMeasurement.zzb(zzb2);
        }
        boolean bl2 = true;
        this.zzivg = true;
        try {
            object2 = this.zzivf.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                try {
                    bl2 &= object.zza(zzb3, zzcef2);
                }
                catch (Exception exception) {
                    ((zzcdl)this).zzauk().zzayc().zzj("onScreenChangeCallback threw exception", exception);
                }
            }
        }
        catch (Exception exception) {
            ((zzcdl)this).zzauk().zzayc().zzj("onScreenChangeCallback loop threw exception", exception);
        }
        finally {
            this.zzivg = false;
        }
        Object object3 = object2 = this.zzivb == null ? this.zzivc : this.zzivb;
        if (bl2) {
            if (zzcef2.zzikh == null) {
                zzcef2.zzikh = zzcec.zzjt(activity.getClass().getCanonicalName());
            }
            object = new zzcef(zzcef2);
            this.zzivc = this.zzivb;
            this.zzivd = ((zzcdl)this).zzvu().elapsedRealtime();
            this.zzivb = object;
            ((zzcdl)this).zzauj().zzg(new zzced(this, bl, (AppMeasurement.zzb)object2, (zzcef)object));
        }
    }

    @WorkerThread
    private final void zza(@NonNull zzcef zzcef2) {
        ((zzcdl)this).zzatw().zzaj(((zzcdl)this).zzvu().elapsedRealtime());
        if (((zzcdl)this).zzaui().zzbr(zzcef2.zzivo)) {
            zzcef2.zzivo = false;
        }
    }

    public static void zza(AppMeasurement.zzb zzb2, Bundle bundle) {
        if (bundle != null && zzb2 != null && !bundle.containsKey("_sc")) {
            if (zzb2.zzikg != null) {
                bundle.putString("_sn", zzb2.zzikg);
            }
            bundle.putString("_sc", zzb2.zzikh);
            bundle.putLong("_si", zzb2.zziki);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, AppMeasurement.zzb zzb2) {
        ((zzcdl)this).zzug();
        zzcec zzcec2 = this;
        synchronized (zzcec2) {
            if (this.zzivi == null || this.zzivi.equals(string) || zzb2 != null) {
                this.zzivi = string;
                this.zzivh = zzb2;
            }
            return;
        }
    }

    private static String zzjt(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length == 0) {
            return string.substring(0, 36);
        }
        String string2 = stringArray[stringArray.length - 1];
        if (string2.length() > 36) {
            return string2.substring(0, 36);
        }
        return string2;
    }

    @MainThread
    final zzcef zzq(@NonNull Activity activity) {
        zzbp.zzu((Object)activity);
        zzcef zzcef2 = this.zzive.get(activity);
        if (zzcef2 == null) {
            String string = zzcec.zzjt(activity.getClass().getCanonicalName());
            zzcef2 = new zzcef(null, string, ((zzcdl)this).zzaug().zzazw());
            this.zzive.put(activity, zzcef2);
        }
        return zzcef2;
    }

    @MainThread
    public final void onActivityResumed(Activity activity) {
        zzcef zzcef2 = this.zzq(activity);
        this.zza(activity, zzcef2, false);
        zzcaf zzcaf2 = ((zzcdl)this).zzatw();
        long l = ((zzcdl)zzcaf2).zzvu().elapsedRealtime();
        ((zzcdl)zzcaf2).zzauj().zzg(new zzcai(zzcaf2, l));
    }

    @MainThread
    public final void onActivityPaused(Activity activity) {
        zzcef zzcef2 = this.zzq(activity);
        this.zzivc = this.zzivb;
        this.zzivd = ((zzcdl)this).zzvu().elapsedRealtime();
        this.zzivb = null;
        ((zzcdl)this).zzauj().zzg(new zzcee(this, zzcef2));
    }

    @MainThread
    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzcef zzcef2 = this.zzive.get(activity);
        if (zzcef2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzcef2.zziki);
        bundle2.putString("name", zzcef2.zzikg);
        bundle2.putString("referrer_name", zzcef2.zzikh);
        bundle.putBundle("com.google.firebase.analytics.screen_service", bundle2);
    }

    @MainThread
    public final void onActivityDestroyed(Activity activity) {
        this.zzive.remove(activity);
    }

    static /* synthetic */ void zza(zzcec zzcec2, zzcef zzcef2) {
        zzcec2.zza(zzcef2);
    }
}

