/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.zzcap;
import com.google.android.gms.internal.zzcau;
import com.google.android.gms.internal.zzccf;
import com.google.android.gms.internal.zzcco;
import com.google.android.gms.internal.zzcdl;
import com.google.android.gms.internal.zzcdm;
import com.google.android.gms.internal.zzcez;
import com.google.android.gms.internal.zzcfk;

public final class zzcfj
extends zzcdm {
    private final AlarmManager zzdrc = (AlarmManager)((zzcdl)this).getContext().getSystemService("alarm");
    private final zzcau zziwr;
    private Integer zziws;

    protected zzcfj(zzcco zzcco2) {
        super(zzcco2);
        this.zziwr = new zzcfk(this, zzcco2);
    }

    @Override
    protected final void zzuh() {
        this.zzdrc.cancel(this.zzyh());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzazu();
        }
    }

    @TargetApi(value=24)
    private final void zzazu() {
        JobScheduler jobScheduler = (JobScheduler)((zzcdl)this).getContext().getSystemService("jobscheduler");
        ((zzcdl)this).zzauk().zzayi().zzj("Cancelling job. JobID", this.getJobId());
        jobScheduler.cancel(this.getJobId());
    }

    public final void zzs(long l) {
        this.zzwh();
        zzcap.zzawj();
        if (!zzccf.zzj(((zzcdl)this).getContext(), false)) {
            ((zzcdl)this).zzauk().zzayh().log("Receiver not registered/enabled");
        }
        zzcap.zzawj();
        if (!zzcez.zzk(((zzcdl)this).getContext(), false)) {
            ((zzcdl)this).zzauk().zzayh().log("Service not registered/enabled");
        }
        this.cancel();
        long l2 = ((zzcdl)this).zzvu().elapsedRealtime() + l;
        if (l < zzcap.zzaxa() && !this.zziwr.zzdp()) {
            ((zzcdl)this).zzauk().zzayi().log("Scheduling upload with DelayedRunnable");
            this.zziwr.zzs(l);
        }
        zzcap.zzawj();
        if (Build.VERSION.SDK_INT >= 24) {
            ((zzcdl)this).zzauk().zzayi().log("Scheduling upload with JobScheduler");
            long l3 = l;
            zzcfj zzcfj2 = this;
            ComponentName componentName = new ComponentName(((zzcdl)zzcfj2).getContext(), "com.google.android.gms.measurement.AppMeasurementJobService");
            JobScheduler jobScheduler = (JobScheduler)((zzcdl)zzcfj2).getContext().getSystemService("jobscheduler");
            JobInfo.Builder builder = new JobInfo.Builder(zzcfj2.getJobId(), componentName);
            builder.setMinimumLatency(l3);
            builder.setOverrideDeadline(l3 << 1);
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            builder.setExtras(persistableBundle);
            JobInfo jobInfo = builder.build();
            ((zzcdl)zzcfj2).zzauk().zzayi().zzj("Scheduling job. JobID", zzcfj2.getJobId());
            jobScheduler.schedule(jobInfo);
            return;
        }
        ((zzcdl)this).zzauk().zzayi().log("Scheduling upload with AlarmManager");
        this.zzdrc.setInexactRepeating(2, l2, Math.max(zzcap.zzaxb(), l), this.zzyh());
    }

    private final int getJobId() {
        if (this.zziws == null) {
            String string = String.valueOf(((zzcdl)this).getContext().getPackageName());
            this.zziws = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zziws;
    }

    public final void cancel() {
        this.zzwh();
        this.zzdrc.cancel(this.zzyh());
        this.zziwr.cancel();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzazu();
        }
    }

    private final PendingIntent zzyh() {
        Intent intent = new Intent();
        Context context = ((zzcdl)this).getContext();
        zzcap.zzawj();
        Intent intent2 = intent.setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver");
        intent2.setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)((zzcdl)this).getContext(), (int)0, (Intent)intent2, (int)0);
    }

    private final void zzazv() {
        Intent intent = new Intent();
        Context context = ((zzcdl)this).getContext();
        zzcap.zzawj();
        Intent intent2 = intent.setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver");
        intent2.setAction("com.google.android.gms.measurement.UPLOAD");
        ((zzcdl)this).getContext().sendBroadcast(intent2);
    }

    static /* synthetic */ void zza(zzcfj zzcfj2) {
        zzcfj2.zzazv();
    }
}

