/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzcap;
import com.google.android.gms.internal.zzcat;
import com.google.android.gms.internal.zzcav;
import com.google.android.gms.internal.zzcax;
import com.google.android.gms.internal.zzcaz;
import com.google.android.gms.internal.zzcbd;
import com.google.android.gms.internal.zzcbe;
import com.google.android.gms.internal.zzcbi;
import com.google.android.gms.internal.zzcbk;
import com.google.android.gms.internal.zzcbu;
import com.google.android.gms.internal.zzccu;
import com.google.android.gms.internal.zzcdr;
import com.google.android.gms.internal.zzcds;
import com.google.android.gms.internal.zzcfo;
import com.google.android.gms.internal.zzcfr;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.internal.zzcfu;
import com.google.android.gms.internal.zzcfv;
import com.google.android.gms.internal.zzcfw;
import com.google.android.gms.internal.zzcfz;
import com.google.android.gms.internal.zzcgf;
import com.google.android.gms.internal.zzcgg;
import com.google.android.gms.internal.zzcgi;
import com.google.android.gms.internal.zzcgj;
import com.google.android.gms.internal.zzegq;
import com.google.android.gms.internal.zzegr;
import com.google.android.gms.internal.zzegt;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class zzcaw
extends zzcds {
    private static final Map<String, String> zzimk = new ArrayMap(1);
    private static final Map<String, String> zziml;
    private static final Map<String, String> zzimm;
    private static final Map<String, String> zzimn;
    private static final Map<String, String> zzimo;
    private final zzcaz zzimp;
    private final zzcfo zzimq = new zzcfo(this.zzvu());

    zzcaw(zzccu zzccu2) {
        super(zzccu2);
        String string = zzcav.zzawh();
        this.zzimp = new zzcaz(this, this.getContext(), string);
    }

    @Override
    protected final void zzuh() {
    }

    @WorkerThread
    public final void beginTransaction() {
        this.zzwh();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public final void setTransactionSuccessful() {
        this.zzwh();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public final void endTransaction() {
        this.zzwh();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private final long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzauk().zzayc().zze("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @WorkerThread
    final SQLiteDatabase getWritableDatabase() {
        this.zzug();
        try {
            return this.zzimp.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzauk().zzaye().zzj("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzcbe zzah(String string, String string2) {
        zzbp.zzgf((String)string);
        zzbp.zzgf((String)string2);
        this.zzug();
        this.zzwh();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            zzcbe zzcbe2 = new zzcbe(string, string2, l, l2, l3);
            if (cursor.moveToNext()) {
                this.zzauk().zzayc().zzj("Got multiple records for event aggregates, expected one. appId", zzcbu.zzjf(string));
            }
            zzcbe zzcbe3 = zzcbe2;
            return zzcbe3;
        }
    }

    @WorkerThread
    public final void zza(zzcbe zzcbe2) {
        zzbp.zzu((Object)zzcbe2);
        this.zzug();
        this.zzwh();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcbe2.mAppId);
        contentValues.put("name", zzcbe2.mName);
        contentValues.put("lifetime_count", Long.valueOf(zzcbe2.zzind));
        contentValues.put("current_bundle_count", Long.valueOf(zzcbe2.zzine));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzcbe2.zzinf));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzauk().zzayc().zzj("Failed to insert/update event aggregates (got -1). appId", zzcbu.zzjf(zzcbe2.mAppId));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzauk().zzayc().zze("Error storing event aggregates. appId", zzcbu.zzjf(zzcbe2.mAppId), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzai(String string, String string2) {
        zzbp.zzgf((String)string);
        zzbp.zzgf((String)string2);
        this.zzug();
        this.zzwh();
        try {
            int n = this.getWritableDatabase().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzauk().zzayi().zzj("Deleted user attribute rows", n);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzauk().zzayc().zzd("Error deleting user attribute. appId", zzcbu.zzjf(string), this.zzauf().zzje(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzcft zzcft2) {
        zzbp.zzu((Object)zzcft2);
        this.zzug();
        this.zzwh();
        if (this.zzaj(zzcft2.mAppId, zzcft2.mName) == null) {
            if (zzcfu.zzju(zzcft2.mName)) {
                long l = this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzcft2.mAppId});
                zzcav.zzavx();
                if (l >= 25L) {
                    return false;
                }
            } else {
                long l = this.zzb("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzcft2.mAppId, zzcft2.mOrigin});
                zzcav.zzavz();
                if (l >= 25L) {
                    return false;
                }
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcft2.mAppId);
        contentValues.put("origin", zzcft2.mOrigin);
        contentValues.put("name", zzcft2.mName);
        contentValues.put("set_timestamp", Long.valueOf(zzcft2.zziwy));
        zzcaw.zza(contentValues, "value", zzcft2.mValue);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzauk().zzayc().zzj("Failed to insert/update user property (got -1). appId", zzcbu.zzjf(zzcft2.mAppId));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzauk().zzayc().zze("Error storing user property. appId", zzcbu.zzjf(zzcft2.mAppId), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzcft zzaj(String string, String string2) {
        zzbp.zzgf((String)string);
        zzbp.zzgf((String)string2);
        this.zzug();
        this.zzwh();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzcft zzcft2 = new zzcft(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzauk().zzayc().zzj("Got multiple records for user property, expected one. appId", zzcbu.zzjf(string));
            }
            zzcft zzcft3 = zzcft2;
            return zzcft3;
        }
    }

    @WorkerThread
    public final List<zzcft> zziv(String string) {
        zzbp.zzgf((String)string);
        this.zzug();
        this.zzwh();
        ArrayList<zzcft> arrayList = new ArrayList<zzcft>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(zzcav.zzavy()));
            if (!cursor.moveToFirst()) {
                ArrayList<zzcft> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzauk().zzayc().zzj("Read invalid user property value, ignoring it. appId", zzcbu.zzjf(string));
                    continue;
                }
                zzcft zzcft2 = new zzcft(string, string2, (String)object, l, object2);
                arrayList.add(zzcft2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzcft> zzg(String string, String string2, String string3) {
        zzbp.zzgf((String)string);
        this.zzug();
        this.zzwh();
        ArrayList<zzcft> arrayList = new ArrayList<zzcft>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String[] stringArray2 = new String[]{"name", "set_timestamp", "value", "origin"};
            String string4 = stringBuilder.toString();
            zzcav.zzavy();
            cursor = sQLiteDatabase.query("user_attributes", stringArray2, string4, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzcft> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= zzcav.zzavy()) {
                    this.zzauk().zzayc().zzj("Read more than the max allowed user properties, ignoring excess", zzcav.zzavy());
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzauk().zzayc().zzd("(2)Read invalid user property value, ignoring it", zzcbu.zzjf(string), string2, string3);
                    continue;
                }
                zzcft zzcft2 = new zzcft(string, string2, (String)object, l, object2);
                arrayList.add(zzcft2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzcat zzcat2) {
        zzbp.zzu((Object)((Object)zzcat2));
        this.zzug();
        this.zzwh();
        if (this.zzaj(zzcat2.packageName, zzcat2.zzima.name) == null) {
            long l = this.zzb("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzcat2.packageName});
            zzcav.zzawa();
            if (l >= 1000L) {
                return false;
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcat2.packageName);
        contentValues.put("origin", zzcat2.zzilz);
        contentValues.put("name", zzcat2.zzima.name);
        zzcaw.zza(contentValues, "value", zzcat2.zzima.getValue());
        contentValues.put("active", Boolean.valueOf(zzcat2.zzimc));
        contentValues.put("trigger_event_name", zzcat2.zzimd);
        contentValues.put("trigger_timeout", Long.valueOf(zzcat2.zzimf));
        this.zzaug();
        contentValues.put("timed_out_event", zzcfu.zza((Parcelable)zzcat2.zzime));
        contentValues.put("creation_timestamp", Long.valueOf(zzcat2.zzimb));
        this.zzaug();
        contentValues.put("triggered_event", zzcfu.zza((Parcelable)zzcat2.zzimg));
        contentValues.put("triggered_timestamp", Long.valueOf(zzcat2.zzima.zziwu));
        contentValues.put("time_to_live", Long.valueOf(zzcat2.zzimh));
        this.zzaug();
        contentValues.put("expired_event", zzcfu.zza((Parcelable)zzcat2.zzimi));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzauk().zzayc().zzj("Failed to insert/update conditional user property (got -1)", zzcbu.zzjf(zzcat2.packageName));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzauk().zzayc().zze("Error storing conditional user property", zzcbu.zzjf(zzcat2.packageName), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzcat zzak(String string, String string2) {
        zzbp.zzgf((String)string);
        zzbp.zzgf((String)string2);
        this.zzug();
        this.zzwh();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzcbi zzcbi2 = this.zzaug().zzb(cursor.getBlob(5), zzcbi.CREATOR);
            long l2 = cursor.getLong(6);
            zzcbi zzcbi3 = this.zzaug().zzb(cursor.getBlob(7), zzcbi.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzcbi zzcbi4 = this.zzaug().zzb(cursor.getBlob(10), zzcbi.CREATOR);
            zzcfr zzcfr2 = new zzcfr(string2, l3, object, string3);
            zzcat zzcat2 = new zzcat(string, string3, zzcfr2, l2, bl, string4, zzcbi2, l, zzcbi3, l4, zzcbi4);
            if (cursor.moveToNext()) {
                this.zzauk().zzayc().zze("Got multiple records for conditional property, expected one", zzcbu.zzjf(string), this.zzauf().zzje(string2));
            }
            zzcat zzcat3 = zzcat2;
            return zzcat3;
        }
    }

    @WorkerThread
    public final int zzal(String string, String string2) {
        zzbp.zzgf((String)string);
        zzbp.zzgf((String)string2);
        this.zzug();
        this.zzwh();
        try {
            return this.getWritableDatabase().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzauk().zzayc().zzd("Error deleting conditional property", zzcbu.zzjf(string), this.zzauf().zzje(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzcat> zzh(String string, String string2, String string3) {
        zzbp.zzgf((String)string);
        this.zzug();
        this.zzwh();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zzc(stringBuilder.toString(), stringArray);
    }

    public final List<zzcat> zzc(String string, String[] stringArray) {
        this.zzug();
        this.zzwh();
        ArrayList<zzcat> arrayList = new ArrayList<zzcat>();
        try (Cursor cursor = null;){
            Object object;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String[] stringArray2 = new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"};
            zzcav.zzawa();
            cursor = sQLiteDatabase.query("conditional_properties", stringArray2, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzcat> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= zzcav.zzawa()) {
                    this.zzauk().zzayc().zzj("Read more than the max allowed conditional properties, ignoring extra", zzcav.zzawa());
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzcbi zzcbi2 = this.zzaug().zzb(cursor.getBlob(7), zzcbi.CREATOR);
                long l2 = cursor.getLong(8);
                zzcbi zzcbi3 = this.zzaug().zzb(cursor.getBlob(9), zzcbi.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzcbi zzcbi4 = this.zzaug().zzb(cursor.getBlob(12), zzcbi.CREATOR);
                zzcfr zzcfr2 = new zzcfr(string3, l3, object2, string2);
                zzcat zzcat2 = new zzcat((String)object, string2, zzcfr2, l2, bl, string4, zzcbi2, l, zzcbi3, l4, zzcbi4);
                arrayList.add(zzcat2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzcap zziw(String string) {
        zzbp.zzgf((String)string);
        this.zzug();
        this.zzwh();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzcap zzcap2 = new zzcap(this.zzikb, string);
            zzcap2.zzim(cursor.getString(0));
            zzcap2.zzin(cursor.getString(1));
            zzcap2.zzio(cursor.getString(2));
            zzcap2.zzaq(cursor.getLong(3));
            zzcap2.zzal(cursor.getLong(4));
            zzcap2.zzam(cursor.getLong(5));
            zzcap2.setAppVersion(cursor.getString(6));
            zzcap2.zziq(cursor.getString(7));
            zzcap2.zzao(cursor.getLong(8));
            zzcap2.zzap(cursor.getLong(9));
            zzcap2.setMeasurementEnabled((cursor.isNull(10) ? 1 : cursor.getInt(10)) != 0);
            zzcap2.zzat(cursor.getLong(11));
            zzcap2.zzau(cursor.getLong(12));
            zzcap2.zzav(cursor.getLong(13));
            zzcap2.zzaw(cursor.getLong(14));
            zzcap2.zzar(cursor.getLong(15));
            zzcap2.zzas(cursor.getLong(16));
            zzcap2.zzan(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzcap2.zzip(cursor.getString(18));
            zzcap2.zzay(cursor.getLong(19));
            zzcap2.zzax(cursor.getLong(20));
            zzcap2.zzir(cursor.getString(21));
            zzcap2.zzaz(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzcap2.zzaun();
            if (cursor.moveToNext()) {
                this.zzauk().zzayc().zzj("Got multiple records for app, expected one. appId", zzcbu.zzjf(string));
            }
            zzcap zzcap3 = zzcap2;
            return zzcap3;
        }
    }

    @WorkerThread
    public final void zza(zzcap zzcap2) {
        zzbp.zzu((Object)zzcap2);
        this.zzug();
        this.zzwh();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcap2.getAppId());
        contentValues.put("app_instance_id", zzcap2.getAppInstanceId());
        contentValues.put("gmp_app_id", zzcap2.getGmpAppId());
        contentValues.put("resettable_device_id_hash", zzcap2.zzauo());
        contentValues.put("last_bundle_index", Long.valueOf(zzcap2.zzaux()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzcap2.zzauq()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzcap2.zzaur()));
        contentValues.put("app_version", zzcap2.zzul());
        contentValues.put("app_store", zzcap2.zzaut());
        contentValues.put("gmp_version", Long.valueOf(zzcap2.zzauu()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzcap2.zzauv()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzcap2.zzauw()));
        contentValues.put("day", Long.valueOf(zzcap2.zzavb()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzcap2.zzavc()));
        contentValues.put("daily_events_count", Long.valueOf(zzcap2.zzavd()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzcap2.zzave()));
        contentValues.put("config_fetched_time", Long.valueOf(zzcap2.zzauy()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzcap2.zzauz()));
        contentValues.put("app_version_int", Long.valueOf(zzcap2.zzaus()));
        contentValues.put("firebase_instance_id", zzcap2.zzaup());
        contentValues.put("daily_error_events_count", Long.valueOf(zzcap2.zzavg()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzcap2.zzavf()));
        contentValues.put("health_monitor_sample", zzcap2.zzavh());
        contentValues.put("android_id", Long.valueOf(zzcap2.zzavj()));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzcap2.getAppId()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzauk().zzayc().zzj("Failed to insert/update app (got -1). appId", zzcbu.zzjf(zzcap2.getAppId()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzauk().zzayc().zze("Error storing app. appId", zzcbu.zzjf(zzcap2.getAppId()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzix(String string) {
        zzbp.zzgf((String)string);
        this.zzug();
        this.zzwh();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = string;
            int n = this.zzaum().zzb(string2, zzcbk.zzioh);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzauk().zzayc().zze("Error deleting over the limit events. appId", zzcbu.zzjf(string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzcax zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        zzbp.zzgf((String)string);
        this.zzug();
        this.zzwh();
        String[] stringArray = new String[]{string};
        zzcax zzcax2 = new zzcax();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzauk().zzaye().zzj("Not updating daily counts, app is not known. appId", zzcbu.zzjf(string));
                zzcax zzcax3 = zzcax2;
                return zzcax3;
            }
            if (cursor.getLong(0) == l) {
                zzcax2.zzims = cursor.getLong(1);
                zzcax2.zzimr = cursor.getLong(2);
                zzcax2.zzimt = cursor.getLong(3);
                zzcax2.zzimu = cursor.getLong(4);
                zzcax2.zzimv = cursor.getLong(5);
            }
            if (bl) {
                ++zzcax2.zzims;
            }
            if (bl2) {
                ++zzcax2.zzimr;
            }
            if (bl3) {
                ++zzcax2.zzimt;
            }
            if (bl4) {
                ++zzcax2.zzimu;
            }
            if (bl5) {
                ++zzcax2.zzimv;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzcax2.zzimr));
            contentValues.put("daily_events_count", Long.valueOf(zzcax2.zzims));
            contentValues.put("daily_conversions_count", Long.valueOf(zzcax2.zzimt));
            contentValues.put("daily_error_events_count", Long.valueOf(zzcax2.zzimu));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzcax2.zzimv));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzcax zzcax4 = zzcax2;
            return zzcax4;
        }
    }

    @WorkerThread
    public final byte[] zziy(String string) {
        zzbp.zzgf((String)string);
        this.zzug();
        this.zzwh();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzauk().zzayc().zzj("Got multiple records for app config, expected one. appId", zzcbu.zzjf(string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(zzcgi zzcgi2, boolean bl) {
        byte[] byArray;
        this.zzug();
        this.zzwh();
        zzbp.zzu((Object)((Object)zzcgi2));
        zzbp.zzgf((String)zzcgi2.zzch);
        zzbp.zzu((Object)zzcgi2.zzize);
        this.zzaxj();
        long l = this.zzvu().currentTimeMillis();
        if (zzcgi2.zzize < l - zzcav.zzawl() || zzcgi2.zzize > l + zzcav.zzawl()) {
            this.zzauk().zzaye().zzd("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzcbu.zzjf(zzcgi2.zzch), l, zzcgi2.zzize);
        }
        try {
            byte[] byArray2;
            byte[] byArray3 = byArray2 = new byte[zzcgi2.zzbjo()];
            zzegr zzegr2 = zzegr.zzi((byte[])byArray2, (int)0, (int)byArray3.length);
            zzcgi2.zza(zzegr2);
            zzegr2.zzcch();
            byArray = this.zzaug().zzo(byArray2);
        }
        catch (IOException iOException) {
            this.zzauk().zzayc().zze("Data loss. Failed to serialize bundle. appId", zzcbu.zzjf(zzcgi2.zzch), iOException);
            return false;
        }
        this.zzauk().zzayi().zzj("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcgi2.zzch);
        contentValues.put("bundle_end_timestamp", zzcgi2.zzize);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("queue", null, contentValues) == -1L) {
                this.zzauk().zzayc().zzj("Failed to insert bundle (got -1). appId", zzcbu.zzjf(zzcgi2.zzch));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzauk().zzayc().zze("Error storing bundle. appId", zzcbu.zzjf(zzcgi2.zzch), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final String zzaxh() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            return null;
        }
    }

    public final boolean zzaxi() {
        return this.zzb("select count(1) > 0 from queue where has_realtime = 1", null) != 0L;
    }

    @WorkerThread
    public final List<Pair<zzcgi, Long>> zzl(String string, int n, int n2) {
        this.zzug();
        this.zzwh();
        zzbp.zzbh((n > 0 ? 1 : 0) != 0);
        zzbp.zzbh((n2 > 0 ? 1 : 0) != 0);
        zzbp.zzgf((String)string);
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("queue", new String[]{"rowid", "data"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzcgi, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzcgi, Long>> arrayList = new ArrayList<Pair<zzcgi, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzaug().zzp((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzauk().zzayc().zze("Failed to unzip queued bundle. appId", zzcbu.zzjf(string), iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                byte[] byArray2 = byArray;
                object = zzegq.zzh((byte[])byArray, (int)0, (int)byArray2.length);
                zzcgi zzcgi2 = new zzcgi();
                try {
                    zzcgi2.zza((zzegq)object);
                }
                catch (IOException iOException) {
                    this.zzauk().zzayc().zze("Failed to merge queued bundle. appId", zzcbu.zzjf(string), iOException);
                    continue;
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzcgi, Long>)Pair.create((Object)((Object)zzcgi2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzcgi, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzaxj() {
        this.zzug();
        this.zzwh();
        if (!this.zzaxp()) {
            return;
        }
        long l = this.zzaul().zziqj.get();
        long l2 = this.zzvu().elapsedRealtime();
        if (Math.abs(l2 - l) > zzcav.zzawm()) {
            this.zzaul().zziqj.set(l2);
            zzcaw zzcaw2 = this;
            zzcaw2.zzug();
            zzcaw2.zzwh();
            if (zzcaw2.zzaxp()) {
                SQLiteDatabase sQLiteDatabase = zzcaw2.getWritableDatabase();
                String[] stringArray = new String[]{String.valueOf(zzcaw2.zzvu().currentTimeMillis()), String.valueOf(zzcav.zzawl())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzcaw2.zzauk().zzayi().zzj("Deleted stale rows. rowsDeleted", n);
                }
            }
        }
    }

    @WorkerThread
    final void zza(String string, zzcfv[] zzcfvArray) {
        this.zzwh();
        this.zzug();
        zzbp.zzgf((String)string);
        zzbp.zzu((Object)zzcfvArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            int n;
            String string2 = string;
            zzcaw zzcaw2 = this;
            zzcaw2.zzwh();
            zzcaw2.zzug();
            zzbp.zzgf((String)string2);
            Object object = zzcaw2.getWritableDatabase();
            object.delete("property_filters", "app_id=?", new String[]{string2});
            object.delete("event_filters", "app_id=?", new String[]{string2});
            Object object2 = zzcfvArray;
            int n2 = zzcfvArray.length;
            block3: for (n = 0; n < n2; ++n) {
                zzcfw zzcfw2;
                int n3;
                int n4;
                zzcfv zzcfv2 = object2[n];
                object = zzcfv2;
                string2 = string;
                zzcaw2 = this;
                zzcaw2.zzwh();
                zzcaw2.zzug();
                zzbp.zzgf((String)string2);
                zzbp.zzu((Object)object);
                zzbp.zzu((Object)object.zzixg);
                zzbp.zzu((Object)object.zzixf);
                if (object.zzixe == null) {
                    zzcaw2.zzauk().zzaye().zzj("Audience with no ID. appId", zzcbu.zzjf(string2));
                    continue;
                }
                int n5 = object.zzixe;
                zzegt[] zzegtArray = object.zzixg;
                int n6 = object.zzixg.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzegtArray[n4].zzixi != null) continue;
                    zzcaw2.zzauk().zzaye().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", zzcbu.zzjf(string2), object.zzixe);
                    continue block3;
                }
                zzegtArray = object.zzixf;
                n6 = object.zzixf.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzegtArray[n4].zzixi != null) continue;
                    zzcaw2.zzauk().zzaye().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", zzcbu.zzjf(string2), object.zzixe);
                    continue block3;
                }
                boolean bl = true;
                zzegt[] zzegtArray2 = object.zzixg;
                n4 = object.zzixg.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    zzcfw2 = zzegtArray2[n3];
                    if (zzcaw2.zza(string2, n5, zzcfw2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    zzegtArray2 = object.zzixf;
                    n4 = object.zzixf.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        zzcfw2 = zzegtArray2[n3];
                        if (zzcaw2.zza(string2, n5, (zzcfz)((Object)zzcfw2))) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n7 = n5;
                String string3 = string2;
                zzcaw zzcaw3 = zzcaw2;
                zzcaw3.zzwh();
                zzcaw3.zzug();
                zzbp.zzgf((String)string3);
                SQLiteDatabase sQLiteDatabase2 = zzcaw3.getWritableDatabase();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
            }
            object2 = new ArrayList();
            zzcfv[] zzcfvArray2 = zzcfvArray;
            n = zzcfvArray.length;
            for (int i = 0; i < n; ++i) {
                zzcfv zzcfv3 = zzcfvArray2[i];
                object2.add(zzcfv3.zzixe);
            }
            this.zzc(string, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzcfw zzcfw2) {
        byte[] byArray;
        this.zzwh();
        this.zzug();
        zzbp.zzgf((String)string);
        zzbp.zzu((Object)((Object)zzcfw2));
        if (TextUtils.isEmpty((CharSequence)zzcfw2.zzixj)) {
            this.zzauk().zzaye().zzd("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzcbu.zzjf(string), n, String.valueOf(zzcfw2.zzixi));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzcfw2.zzbjo()];
            zzegr zzegr2 = zzegr.zzi((byte[])byArray, (int)0, (int)byArray2.length);
            zzcfw2.zza(zzegr2);
            zzegr2.zzcch();
        }
        catch (IOException iOException) {
            this.zzauk().zzayc().zze("Configuration loss. Failed to serialize event filter. appId", zzcbu.zzjf(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzcfw2.zzixi);
        contentValues.put("event_name", zzcfw2.zzixj);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzauk().zzayc().zzj("Failed to insert event filter (got -1). appId", zzcbu.zzjf(string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzauk().zzayc().zze("Error storing event filter. appId", zzcbu.zzjf(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzcfz zzcfz2) {
        byte[] byArray;
        this.zzwh();
        this.zzug();
        zzbp.zzgf((String)string);
        zzbp.zzu((Object)((Object)zzcfz2));
        if (TextUtils.isEmpty((CharSequence)zzcfz2.zzixy)) {
            this.zzauk().zzaye().zzd("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzcbu.zzjf(string), n, String.valueOf(zzcfz2.zzixi));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzcfz2.zzbjo()];
            zzegr zzegr2 = zzegr.zzi((byte[])byArray, (int)0, (int)byArray2.length);
            zzcfz2.zza(zzegr2);
            zzegr2.zzcch();
        }
        catch (IOException iOException) {
            this.zzauk().zzayc().zze("Configuration loss. Failed to serialize property filter. appId", zzcbu.zzjf(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzcfz2.zzixi);
        contentValues.put("property_name", zzcfz2.zzixy);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzauk().zzayc().zzj("Failed to insert property filter (got -1). appId", zzcbu.zzjf(string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzauk().zzayc().zze("Error storing property filter. appId", zzcbu.zzjf(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzcfw>> zzam(String string, String string2) {
        this.zzwh();
        this.zzug();
        zzbp.zzgf((String)string);
        zzbp.zzgf((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzcfw>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzegq zzegq2 = zzegq.zzh((byte[])byArray, (int)0, (int)byArray.length);
                zzcfw zzcfw2 = new zzcfw();
                try {
                    zzcfw2.zza(zzegq2);
                }
                catch (IOException iOException) {
                    this.zzauk().zzayc().zze("Failed to merge filter. appId", zzcbu.zzjf(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzcfw> arrayList = (ArrayList<zzcfw>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzcfw>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzcfw2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzcfz>> zzan(String string, String string2) {
        this.zzwh();
        this.zzug();
        zzbp.zzgf((String)string);
        zzbp.zzgf((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzcfz>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzegq zzegq2 = zzegq.zzh((byte[])byArray, (int)0, (int)byArray.length);
                zzcfz zzcfz2 = new zzcfz();
                try {
                    zzcfz2.zza(zzegq2);
                }
                catch (IOException iOException) {
                    this.zzauk().zzayc().zze("Failed to merge filter", zzcbu.zzjf(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzcfz> arrayList = (ArrayList<zzcfz>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzcfz>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzcfz2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zzc(String string, List<Integer> list) {
        Object object;
        long l;
        zzbp.zzgf((String)string);
        this.zzwh();
        this.zzug();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zzb("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzauk().zzayc().zze("Database error querying filters. appId", zzcbu.zzjf(string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzaum().zzb(string2, zzcbk.zziox);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = TextUtils.join((CharSequence)",", arrayList);
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, zzcgj> zziz(String string) {
        this.zzwh();
        this.zzug();
        zzbp.zzgf((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                zzegq zzegq2 = zzegq.zzh((byte[])byArray, (int)0, (int)byArray.length);
                zzcgj zzcgj2 = new zzcgj();
                try {
                    zzcgj2.zza(zzegq2);
                }
                catch (IOException iOException) {
                    this.zzauk().zzayc().zzd("Failed to merge filter results. appId, audienceId, error", zzcbu.zzjf(string), n, iOException);
                    continue;
                }
                arrayMap.put(n, zzcgj2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        zzbp.zzgf((String)string);
        zzbp.zzu((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzauk().zzayc().log("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzauk().zzayc().log("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzauk().zzayc().zzj("Loaded invalid unknown value type, ignoring it", n3);
        return null;
    }

    @WorkerThread
    public final long zzaxk() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    protected final long zzao(String string, String string2) {
        zzbp.zzgf((String)string);
        zzbp.zzgf((String)string2);
        this.zzug();
        this.zzwh();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzauk().zzayc().zze("Failed to insert column (got -1). appId", zzcbu.zzjf(string), string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzauk().zzayc().zze("Failed to update column (got 0). appId", zzcbu.zzjf(string), string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzauk().zzayc().zzd("Error inserting column. appId", zzcbu.zzjf(string), string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzaxl() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(zzcgi zzcgi2) throws IOException {
        long l;
        Object object;
        byte[] byArray;
        this.zzug();
        this.zzwh();
        zzbp.zzu((Object)((Object)zzcgi2));
        zzbp.zzgf((String)zzcgi2.zzch);
        try {
            byArray = new byte[zzcgi2.zzbjo()];
            object = byArray;
            zzegr zzegr2 = zzegr.zzi((byte[])byArray, (int)0, (int)((byte[])object).length);
            zzcgi2.zza(zzegr2);
            zzegr2.zzcch();
        }
        catch (IOException iOException) {
            this.zzauk().zzayc().zze("Data loss. Failed to serialize event metadata. appId", zzcbu.zzjf(zzcgi2.zzch), iOException);
            throw iOException;
        }
        byte[] byArray2 = byArray;
        object = this.zzaug();
        zzbp.zzu((Object)byArray2);
        ((zzcdr)object).zzug();
        MessageDigest messageDigest = zzcfu.zzed("MD5");
        if (messageDigest == null) {
            ((zzcdr)object).zzauk().zzayc().log("Failed to get MD5");
            l = 0L;
        } else {
            l = zzcfu.zzq(messageDigest.digest(byArray2));
        }
        long l2 = l;
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcgi2.zzch);
        contentValues.put("metadata_fingerprint", Long.valueOf(l2));
        contentValues.put("metadata", byArray);
        try {
            this.getWritableDatabase().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzauk().zzayc().zze("Error storing raw event metadata. appId", zzcbu.zzjf(zzcgi2.zzch), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l2;
    }

    public final boolean zzaxm() {
        return this.zzb("select count(1) > 0 from raw_events", null) != 0L;
    }

    public final boolean zzaxn() {
        return this.zzb("select count(1) > 0 from raw_events where realtime = 1", null) != 0L;
    }

    public final void zzae(List<Long> list) {
        zzbp.zzu(list);
        this.zzug();
        this.zzwh();
        StringBuilder stringBuilder = new StringBuilder("rowid in (");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get(i));
        }
        stringBuilder.append(")");
        int n = this.getWritableDatabase().delete("raw_events", stringBuilder.toString(), null);
        if (n != list.size()) {
            this.zzauk().zzayc().zze("Deleted fewer rows from raw events table than expected", n, list.size());
        }
    }

    public final long zzja(String string) {
        zzbp.zzgf((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zzba(long l) {
        this.zzug();
        this.zzwh();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzauk().zzayi().log("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzaxo() {
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final boolean zza(zzcbd zzcbd2, long l, boolean bl) {
        Object object;
        zzcgg zzcgg2;
        String string2;
        this.zzug();
        this.zzwh();
        zzbp.zzu((Object)zzcbd2);
        zzbp.zzgf((String)zzcbd2.mAppId);
        zzcgf zzcgf2 = new zzcgf();
        new zzcgf().zziyu = zzcbd2.zzinb;
        zzcgf2.zziys = new zzcgg[zzcbd2.zzinc.size()];
        int n = 0;
        for (String string2 : zzcbd2.zzinc) {
            zzcgg2 = new zzcgg();
            zzcgf2.zziys[n++] = zzcgg2;
            zzcgg2.name = string2;
            Object object2 = zzcbd2.zzinc.get(string2);
            this.zzaug().zza(zzcgg2, object2);
        }
        try {
            byte[] byArray = new byte[zzcgf2.zzbjo()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzcgg2 = zzegr.zzi((byte[])byArray, (int)0, (int)byArray2.length);
            zzcgf2.zza((zzegr)zzcgg2);
            zzcgg2.zzcch();
        }
        catch (IOException iOException) {
            this.zzauk().zzayc().zze("Data loss. Failed to serialize event params/data. appId", zzcbu.zzjf(zzcbd2.mAppId), iOException);
            return false;
        }
        this.zzauk().zzayi().zze("Saving event, name, data size", this.zzauf().zzjc(zzcbd2.mName), ((Object)object).length);
        string2 = new ContentValues();
        string2.put("app_id", zzcbd2.mAppId);
        string2.put("name", zzcbd2.mName);
        string2.put("timestamp", Long.valueOf(zzcbd2.zzfcw));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzauk().zzayc().zzj("Failed to insert raw event (got -1). appId", zzcbu.zzjf(zzcbd2.mAppId));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzauk().zzayc().zze("Error storing raw event. appId", zzcbu.zzjf(zzcbd2.mAppId), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zzaxp() {
        return this.getContext().getDatabasePath(zzcav.zzawh()).exists();
    }

    @WorkerThread
    private static boolean zza(zzcbu zzcbu2, SQLiteDatabase sQLiteDatabase, String string) {
        if (zzcbu2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
            boolean bl = cursor.moveToFirst();
            return bl;
        }
    }

    @WorkerThread
    private static Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
        try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
            Collections.addAll(hashSet, cursor.getColumnNames());
        }
        return hashSet;
    }

    @WorkerThread
    private static void zza(zzcbu zzcbu2, SQLiteDatabase sQLiteDatabase, String string, String string2, Map<String, String> map) throws SQLiteException {
        if (zzcbu2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        Set<String> set = zzcaw.zzb(sQLiteDatabase, string);
        for (String string3 : string2.split(",")) {
            if (set.remove(string3)) continue;
            throw new SQLiteException(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Table ").append(string).append(" is missing required column: ").append(string3).toString());
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (set.remove(entry.getKey())) continue;
                sQLiteDatabase.execSQL((String)entry.getValue());
            }
        }
        if (!set.isEmpty()) {
            zzcbu2.zzaye().zze("Table has extra columns. table, columns", string, TextUtils.join((CharSequence)", ", set));
        }
    }

    @WorkerThread
    static void zza(zzcbu zzcbu2, SQLiteDatabase sQLiteDatabase, String string, String string2, String string3, Map<String, String> map) throws SQLiteException {
        if (zzcbu2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        if (!zzcaw.zza(zzcbu2, sQLiteDatabase, string)) {
            sQLiteDatabase.execSQL(string2);
        }
        try {
            zzcaw.zza(zzcbu2, sQLiteDatabase, string, string3, map);
            return;
        }
        catch (SQLiteException sQLiteException) {
            zzcbu2.zzayc().zzj("Failed to verify columns on table that was just created", string);
            throw sQLiteException;
        }
    }

    static void zza(zzcbu zzcbu2, SQLiteDatabase sQLiteDatabase) {
        if (zzcbu2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        File file = new File(sQLiteDatabase.getPath());
        if (!file.setReadable(false, false)) {
            zzcbu2.zzaye().log("Failed to turn off database read permission");
        }
        if (!file.setWritable(false, false)) {
            zzcbu2.zzaye().log("Failed to turn off database write permission");
        }
        if (!file.setReadable(true, true)) {
            zzcbu2.zzaye().log("Failed to turn on database read permission for owner");
        }
        if (!file.setWritable(true, true)) {
            zzcbu2.zzaye().log("Failed to turn on database write permission for owner");
        }
    }

    static /* synthetic */ zzcfo zza(zzcaw zzcaw2) {
        return zzcaw2.zzimq;
    }

    static /* synthetic */ Map zzaxq() {
        return zzimk;
    }

    static /* synthetic */ Map zzaxr() {
        return zziml;
    }

    static /* synthetic */ Map zzaxs() {
        return zzimn;
    }

    static /* synthetic */ Map zzaxt() {
        return zzimm;
    }

    static /* synthetic */ Map zzaxu() {
        return zzimo;
    }

    static {
        zzimk.put("origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;");
        zziml = new ArrayMap(18);
        zziml.put("app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;");
        zziml.put("app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;");
        zziml.put("gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;");
        zziml.put("dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;");
        zziml.put("measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;");
        zziml.put("last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;");
        zziml.put("day", "ALTER TABLE apps ADD COLUMN day INTEGER;");
        zziml.put("daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;");
        zziml.put("daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;");
        zziml.put("daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;");
        zziml.put("remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;");
        zziml.put("config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;");
        zziml.put("failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;");
        zziml.put("app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;");
        zziml.put("firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;");
        zziml.put("daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;");
        zziml.put("daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;");
        zziml.put("health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;");
        zziml.put("android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;");
        zzimm = new ArrayMap(1);
        zzimm.put("realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;");
        zzimn = new ArrayMap(1);
        zzimn.put("has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;");
        zzimo = new ArrayMap(1);
        zzimo.put("previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;");
    }
}

