/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.zzca;
import com.google.android.gms.internal.zzbdt;
import com.google.android.gms.internal.zzcaq;
import com.google.android.gms.internal.zzcav;
import com.google.android.gms.internal.zzcbu;
import com.google.android.gms.internal.zzccu;
import com.google.android.gms.internal.zzcdr;
import com.google.android.gms.internal.zzcds;
import com.google.firebase.iid.FirebaseInstanceId;
import java.math.BigInteger;
import java.util.Locale;

public final class zzcbp
extends zzcds {
    private String mAppId;
    private String zzdmh;
    private int zzioz;
    private String zziky;
    private String zzdmg;
    private long zzipa;
    private long zzilc;
    private int zzipb;
    private String zzcxs;

    zzcbp(zzccu zzccu2) {
        super(zzccu2);
    }

    @Override
    protected final void zzuh() {
        Object object;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = ((zzcdr)this).getContext().getPackageName();
        PackageManager packageManager = ((zzcdr)this).getContext().getPackageManager();
        if (packageManager == null) {
            ((zzcdr)this).zzauk().zzayc().zzj("PackageManager is null, app identity information might be inaccurate. appId", zzcbu.zzjf(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ((zzcdr)this).zzauk().zzayc().zzj("Error retrieving app installer package name. appId", zzcbu.zzjf(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(((zzcdr)this).getContext().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzcdr)this).zzauk().zzayc().zze("Error retrieving package info. appId, appName", zzcbu.zzjf(string4), string3);
            }
        }
        this.mAppId = string4;
        this.zziky = string;
        this.zzdmh = string2;
        this.zzioz = n;
        this.zzdmg = string3;
        this.zzipa = 0L;
        zzcav.zzawj();
        packageInfo = zzca.zzcc((Context)((zzcdr)this).getContext());
        boolean bl = packageInfo != null && packageInfo.isSuccess();
        if (!bl) {
            PackageInfo packageInfo2 = packageInfo;
            zzcbp zzcbp2 = this;
            if (packageInfo2 == null) {
                ((zzcdr)zzcbp2).zzauk().zzayc().log("GoogleService failed to initialize (no status)");
            } else {
                ((zzcdr)zzcbp2).zzauk().zzayc().zze("GoogleService failed to initialize, status", packageInfo2.getStatusCode(), packageInfo2.getStatusMessage());
            }
        }
        boolean bl2 = false;
        if (bl) {
            object = ((zzcdr)this).zzaum().zzit("firebase_analytics_collection_enabled");
            if (((zzcdr)this).zzaum().zzawk()) {
                ((zzcdr)this).zzauk().zzayg().log("Collection disabled with firebase_analytics_collection_deactivated=1");
            } else if (object != null && !((Boolean)object).booleanValue()) {
                ((zzcdr)this).zzauk().zzayg().log("Collection disabled with firebase_analytics_collection_enabled=0");
            } else if (object == null && zzcav.zzaie()) {
                ((zzcdr)this).zzauk().zzayg().log("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl2 = true;
                ((zzcdr)this).zzauk().zzayi().log("Collection enabled");
            }
        }
        this.zzcxs = "";
        this.zzilc = 0L;
        zzcav.zzawj();
        try {
            object = zzca.zzaid();
            Object object2 = this.zzcxs = TextUtils.isEmpty((CharSequence)object) ? "" : object;
            if (bl2) {
                ((zzcdr)this).zzauk().zzayi().zze("App package, google app id", this.mAppId, this.zzcxs);
            }
        }
        catch (IllegalStateException illegalStateException) {
            ((zzcdr)this).zzauk().zzayc().zze("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzcbu.zzjf(string4), illegalStateException);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzipb = zzbdt.zzcq((Context)((zzcdr)this).getContext()) ? 1 : 0;
            return;
        }
        this.zzipb = 0;
    }

    @WorkerThread
    final zzcaq zzjb(String string) {
        ((zzcdr)this).zzug();
        String string2 = this.getAppId();
        String string3 = this.getGmpAppId();
        zzcbp zzcbp2 = this;
        zzcbp2.zzwh();
        String string4 = zzcbp2.zzdmh;
        long l = this.zzaya();
        zzcbp2 = this;
        zzcbp2.zzwh();
        String string5 = zzcbp2.zziky;
        long l2 = zzcav.zzauu();
        zzcbp2 = this;
        zzcbp2.zzwh();
        ((zzcdr)zzcbp2).zzug();
        if (zzcbp2.zzipa == 0L) {
            zzcbp2.zzipa = zzcbp2.zzikb.zzaug().zzai(((zzcdr)zzcbp2).getContext(), ((zzcdr)zzcbp2).getContext().getPackageName());
        }
        long l3 = zzcbp2.zzipa;
        boolean bl = this.zzikb.isEnabled();
        boolean bl2 = !((zzcdr)this).zzaul().zziqy;
        String string6 = this.zzaup();
        this.zzwh();
        long l4 = this.zzikb.zzazd();
        zzcbp2 = this;
        zzcbp2.zzwh();
        return new zzcaq(string2, string3, string4, l, string5, l2, l3, string, bl, bl2, string6, 0L, l4, zzcbp2.zzipb);
    }

    @WorkerThread
    final String zzaxz() {
        byte[] byArray = new byte[16];
        ((zzcdr)this).zzaug().zzazx().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    private final String zzaup() {
        ((zzcdr)this).zzug();
        try {
            return FirebaseInstanceId.getInstance().getId();
        }
        catch (IllegalStateException illegalStateException) {
            ((zzcdr)this).zzauk().zzaye().log("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String getAppId() {
        this.zzwh();
        return this.mAppId;
    }

    final String getGmpAppId() {
        this.zzwh();
        return this.zzcxs;
    }

    final int zzaya() {
        this.zzwh();
        return this.zzioz;
    }
}

