/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.zzcav;
import com.google.android.gms.internal.zzcbk;
import com.google.android.gms.internal.zzcch;
import com.google.android.gms.internal.zzcci;
import com.google.android.gms.internal.zzccj;
import com.google.android.gms.internal.zzcck;
import com.google.android.gms.internal.zzccu;
import com.google.android.gms.internal.zzcds;
import com.google.android.gms.internal.zzcfu;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzccf
extends zzcds {
    static final Pair<String, Long> zziqe = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzdtw;
    public final zzccj zziqf = new zzccj(this, "health_monitor", zzcav.zzawp(), null);
    public final zzcci zziqg = new zzcci(this, "last_upload", 0L);
    public final zzcci zziqh = new zzcci(this, "last_upload_attempt", 0L);
    public final zzcci zziqi = new zzcci(this, "backoff", 0L);
    public final zzcci zziqj = new zzcci(this, "last_delete_stale", 0L);
    public final zzcci zziqk;
    public final zzcci zziql;
    public final zzcck zziqm;
    private String zziqn;
    private boolean zziqo;
    private long zziqp;
    private String zziqq;
    private long zziqr;
    private final Object zziqs;
    public final zzcci zziqt = new zzcci(this, "time_before_start", 10000L);
    public final zzcci zziqu = new zzcci(this, "session_timeout", 1800000L);
    public final zzcch zziqv = new zzcch(this, "start_new_session", true);
    public final zzcci zziqw = new zzcci(this, "last_pause_time", 0L);
    public final zzcci zziqx = new zzcci(this, "time_active", 0L);
    public boolean zziqy;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zzjh(String string) {
        this.zzug();
        long l = this.zzvu().elapsedRealtime();
        if (this.zziqn != null && l < this.zziqp) {
            return new Pair((Object)this.zziqn, (Object)this.zziqo);
        }
        String string2 = string;
        this.zziqp = l + this.zzaum().zza(string2, zzcbk.zzint);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            if (info != null) {
                this.zziqn = info.getId();
                this.zziqo = info.isLimitAdTrackingEnabled();
            }
            if (this.zziqn == null) {
                this.zziqn = "";
            }
        }
        catch (Throwable throwable) {
            this.zzauk().zzayh().zzj("Unable to get advertising id", throwable);
            this.zziqn = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zziqn, (Object)this.zziqo);
    }

    @WorkerThread
    final String zzji(String string) {
        this.zzug();
        String string2 = (String)this.zzjh((String)string).first;
        MessageDigest messageDigest = zzcfu.zzed("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzccf(zzccu zzccu2) {
        super(zzccu2);
        this.zziqk = new zzcci(this, "midnight_offset", 0L);
        this.zziql = new zzcci(this, "first_open_time", 0L);
        this.zziqm = new zzcck(this, "app_instance_id", null);
        this.zziqs = new Object();
    }

    @Override
    protected final void zzuh() {
        this.zzdtw = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zziqy = this.zzdtw.getBoolean("has_been_opened", false);
        if (!this.zziqy) {
            SharedPreferences.Editor editor = this.zzdtw.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
    }

    @WorkerThread
    private final SharedPreferences zzayk() {
        this.zzug();
        this.zzwh();
        return this.zzdtw;
    }

    @WorkerThread
    final void zzjj(String string) {
        this.zzug();
        SharedPreferences.Editor editor = this.zzayk().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzayl() {
        this.zzug();
        return this.zzayk().getString("gmp_app_id", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzjk(String string) {
        Object object = this.zziqs;
        synchronized (object) {
            this.zziqq = string;
            this.zziqr = this.zzvu().elapsedRealtime();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzaym() {
        Object object = this.zziqs;
        synchronized (object) {
            if (Math.abs(this.zzvu().elapsedRealtime() - this.zziqr) < 1000L) {
                return this.zziqq;
            }
            return null;
        }
    }

    @WorkerThread
    final Boolean zzayn() {
        this.zzug();
        if (!this.zzayk().contains("use_service")) {
            return null;
        }
        return this.zzayk().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zzbm(boolean bl) {
        this.zzug();
        this.zzauk().zzayi().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzayk().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzayo() {
        this.zzug();
        this.zzauk().zzayi().log("Clearing collection preferences.");
        boolean bl = this.zzayk().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzbn(true);
        }
        SharedPreferences.Editor editor = this.zzayk().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    final void setMeasurementEnabled(boolean bl) {
        this.zzug();
        this.zzauk().zzayi().zzj("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzayk().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzbn(boolean bl) {
        this.zzug();
        return this.zzayk().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected final String zzayp() {
        this.zzug();
        String string = this.zzayk().getString("previous_os_version", null);
        this.zzaua().zzwh();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzayk().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    static /* synthetic */ SharedPreferences zza(zzccf zzccf2) {
        return zzccf2.zzdtw;
    }

    static /* synthetic */ SharedPreferences zzb(zzccf zzccf2) {
        return zzccf2.zzayk();
    }
}

