/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzd;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzbcc;
import com.google.android.gms.internal.zzbdv;
import com.google.android.gms.internal.zzcal;
import com.google.android.gms.internal.zzcap;
import com.google.android.gms.internal.zzcaq;
import com.google.android.gms.internal.zzcas;
import com.google.android.gms.internal.zzcat;
import com.google.android.gms.internal.zzcav;
import com.google.android.gms.internal.zzcaw;
import com.google.android.gms.internal.zzcax;
import com.google.android.gms.internal.zzcay;
import com.google.android.gms.internal.zzcbc;
import com.google.android.gms.internal.zzcbd;
import com.google.android.gms.internal.zzcbe;
import com.google.android.gms.internal.zzcbf;
import com.google.android.gms.internal.zzcbi;
import com.google.android.gms.internal.zzcbk;
import com.google.android.gms.internal.zzcbp;
import com.google.android.gms.internal.zzcbq;
import com.google.android.gms.internal.zzcbs;
import com.google.android.gms.internal.zzcbu;
import com.google.android.gms.internal.zzcbw;
import com.google.android.gms.internal.zzcby;
import com.google.android.gms.internal.zzccc;
import com.google.android.gms.internal.zzccd;
import com.google.android.gms.internal.zzccf;
import com.google.android.gms.internal.zzccl;
import com.google.android.gms.internal.zzcco;
import com.google.android.gms.internal.zzccp;
import com.google.android.gms.internal.zzccv;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzccx;
import com.google.android.gms.internal.zzccy;
import com.google.android.gms.internal.zzcdr;
import com.google.android.gms.internal.zzcds;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzcdu;
import com.google.android.gms.internal.zzceh;
import com.google.android.gms.internal.zzcei;
import com.google.android.gms.internal.zzcem;
import com.google.android.gms.internal.zzcff;
import com.google.android.gms.internal.zzcfj;
import com.google.android.gms.internal.zzcfp;
import com.google.android.gms.internal.zzcfr;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.internal.zzcfu;
import com.google.android.gms.internal.zzcgc;
import com.google.android.gms.internal.zzcge;
import com.google.android.gms.internal.zzcgf;
import com.google.android.gms.internal.zzcgg;
import com.google.android.gms.internal.zzcgh;
import com.google.android.gms.internal.zzcgi;
import com.google.android.gms.internal.zzcgk;
import com.google.android.gms.internal.zzegq;
import com.google.android.gms.internal.zzegr;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class zzccu {
    private static volatile zzccu zzisi;
    private final Context mContext;
    private final zzcav zzisj;
    private final zzccf zzisk;
    private final zzcbu zzisl;
    private final zzccp zzism;
    private final zzcfj zzisn;
    private final zzcco zziso;
    private final AppMeasurement zzisp;
    private final FirebaseAnalytics zzisq;
    private final zzcfu zzisr;
    private final zzcbs zziss;
    private final zzcaw zzist;
    private final zzcbq zzisu;
    private final zzcby zzisv;
    private final zzd zzasl;
    private final zzcei zzisw;
    private final zzcem zzisx;
    private final zzcbc zzisy;
    private final zzcdu zzisz;
    private final zzcbp zzita;
    private final zzccd zzitb;
    private final zzcfp zzitc;
    private final zzcas zzitd;
    private final zzcal zzite;
    private final boolean zzdoj;
    private boolean zzitf;
    private Boolean zzitg;
    private long zzith;
    private FileLock zziti;
    private FileChannel zzitj;
    private List<Long> zzitk;
    private List<Runnable> zzitl;
    private int zzitm;
    private int zzitn;
    private long zzito;
    private long zzitp;
    private boolean zzitq;
    private boolean zzitr;
    private boolean zzits;
    private final long zzitt;

    private zzccu(zzcdt zzcdt2) {
        zzcal zzcal2;
        String string;
        zzcbw zzcbw2;
        zzbp.zzu((Object)zzcdt2);
        this.mContext = zzcdt2.mContext;
        this.zzito = -1L;
        this.zzasl = zzh.zzalc();
        this.zzitt = this.zzasl.currentTimeMillis();
        Object object = this;
        this.zzisj = new zzcav((zzccu)object);
        object = this;
        zzccf zzccf2 = new zzccf((zzccu)object);
        zzccf2.initialize();
        this.zzisk = zzccf2;
        object = this;
        zzcbu zzcbu2 = new zzcbu((zzccu)object);
        zzcbu2.initialize();
        this.zzisl = zzcbu2;
        this.zzauk().zzayg().zzj("App measurement is starting up, version", zzcav.zzauu());
        zzcav.zzawj();
        this.zzauk().zzayg().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        object = this;
        zzcfu zzcfu2 = new zzcfu((zzccu)object);
        zzcfu2.initialize();
        this.zzisr = zzcfu2;
        object = this;
        zzcbs zzcbs2 = new zzcbs((zzccu)object);
        zzcbs2.initialize();
        this.zziss = zzcbs2;
        object = this;
        zzcbc zzcbc2 = new zzcbc((zzccu)object);
        zzcbc2.initialize();
        this.zzisy = zzcbc2;
        object = this;
        zzcbp zzcbp2 = new zzcbp((zzccu)object);
        zzcbp2.initialize();
        this.zzita = zzcbp2;
        zzcav.zzawj();
        Object object2 = zzcbp2.getAppId();
        if (this.zzaug().zzke((String)object2)) {
            zzcbw2 = this.zzauk().zzayg();
            string = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
        } else {
            zzcbw2 = this.zzauk().zzayg();
            String string2 = String.valueOf(object2);
            string = string2.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string2) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
        }
        zzcbw2.log(string);
        this.zzauk().zzayh().log("Debug-level message logging enabled");
        object = this;
        object2 = new zzcaw((zzccu)object);
        ((zzcds)object2).initialize();
        this.zzist = object2;
        object = this;
        zzcbq zzcbq2 = new zzcbq((zzccu)object);
        zzcbq2.initialize();
        this.zzisu = zzcbq2;
        object = this;
        zzcas zzcas2 = new zzcas((zzccu)object);
        zzcas2.initialize();
        this.zzitd = zzcas2;
        object = this;
        this.zzite = zzcal2 = new zzcal((zzccu)object);
        object = this;
        zzcby zzcby2 = new zzcby((zzccu)object);
        zzcby2.initialize();
        this.zzisv = zzcby2;
        object = this;
        zzcei zzcei2 = new zzcei((zzccu)object);
        zzcei2.initialize();
        this.zzisw = zzcei2;
        object = this;
        zzcem zzcem2 = new zzcem((zzccu)object);
        zzcem2.initialize();
        this.zzisx = zzcem2;
        object = this;
        zzcdu zzcdu2 = new zzcdu((zzccu)object);
        zzcdu2.initialize();
        this.zzisz = zzcdu2;
        object = this;
        zzcfp zzcfp2 = new zzcfp((zzccu)object);
        zzcfp2.initialize();
        this.zzitc = zzcfp2;
        object = this;
        this.zzitb = new zzccd((zzccu)object);
        object = this;
        this.zzisp = new AppMeasurement((zzccu)object);
        object = this;
        this.zzisq = new FirebaseAnalytics((zzccu)object);
        object = this;
        zzcfj zzcfj2 = new zzcfj((zzccu)object);
        zzcfj2.initialize();
        this.zzisn = zzcfj2;
        object = this;
        zzcco zzcco2 = new zzcco((zzccu)object);
        zzcco2.initialize();
        this.zziso = zzcco2;
        object = this;
        zzccp zzccp2 = new zzccp((zzccu)object);
        zzccp2.initialize();
        this.zzism = zzccp2;
        if (this.zzitm != this.zzitn) {
            this.zzauk().zzayc().zze("Not all components initialized", this.zzitm, this.zzitn);
        }
        this.zzdoj = true;
        zzcav.zzawj();
        if (this.mContext.getApplicationContext() instanceof Application) {
            object = this.zzaty();
            if (((zzcdr)object).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzcdr)object).getContext().getApplicationContext();
                if (((zzcdu)object).zziuk == null) {
                    ((zzcdu)object).zziuk = new zzceh((zzcdu)object, null);
                }
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzcdu)object).zziuk);
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzcdu)object).zziuk);
                ((zzcdr)object).zzauk().zzayi().log("Registered activity lifecycle callback");
            }
        } else {
            this.zzauk().zzaye().log("Application context is not an Application");
        }
        this.zzism.zzg(new zzccv(this));
    }

    final void zzwh() {
        if (!this.zzdoj) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected final boolean zzayu() {
        this.zzwh();
        ((zzcdr)this.zzauj()).zzug();
        if (this.zzitg == null || this.zzith == 0L || this.zzitg != null && !this.zzitg.booleanValue() && Math.abs(this.zzasl.elapsedRealtime() - this.zzith) > 1000L) {
            this.zzith = this.zzasl.elapsedRealtime();
            zzcav.zzawj();
            this.zzitg = this.zzaug().zzdu("android.permission.INTERNET") && this.zzaug().zzdu("android.permission.ACCESS_NETWORK_STATE") && (zzbdv.zzcs((Context)this.mContext).zzalq() || zzccl.zzj(this.mContext, false) && zzcff.zzk(this.mContext, false));
            if (this.zzitg.booleanValue()) {
                this.zzitg = this.zzaug().zzkb(this.zzatz().getGmpAppId());
            }
        }
        return this.zzitg;
    }

    @WorkerThread
    protected final void start() {
        ((zzcdr)this.zzauj()).zzug();
        this.zzaue().zzaxj();
        if (this.zzaul().zziqg.get() == 0L) {
            this.zzaul().zziqg.set(this.zzasl.currentTimeMillis());
        }
        if (Long.valueOf(this.zzaul().zziql.get()) == 0L) {
            this.zzauk().zzayi().zzj("Persisting first open", this.zzitt);
            this.zzaul().zziql.set(this.zzitt);
        }
        if (!this.zzayu()) {
            if (this.isEnabled()) {
                if (!this.zzaug().zzdu("android.permission.INTERNET")) {
                    this.zzauk().zzayc().log("App is missing INTERNET permission");
                }
                if (!this.zzaug().zzdu("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzauk().zzayc().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzcav.zzawj();
                if (!zzbdv.zzcs((Context)this.mContext).zzalq()) {
                    if (!zzccl.zzj(this.mContext, false)) {
                        this.zzauk().zzayc().log("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzcff.zzk(this.mContext, false)) {
                        this.zzauk().zzayc().log("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzauk().zzayc().log("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzcav.zzawj();
            if (!TextUtils.isEmpty((CharSequence)this.zzatz().getGmpAppId())) {
                String string = this.zzaul().zzayl();
                if (string == null) {
                    this.zzaul().zzjj(this.zzatz().getGmpAppId());
                } else if (!string.equals(this.zzatz().getGmpAppId())) {
                    this.zzauk().zzayg().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzaul().zzayo();
                    this.zzisx.disconnect();
                    this.zzisx.zzxe();
                    this.zzaul().zzjj(this.zzatz().getGmpAppId());
                    this.zzaul().zziql.set(this.zzitt);
                    this.zzaul().zziqm.zzjl(null);
                }
            }
            this.zzaty().zzjk(this.zzaul().zziqm.zzayq());
            zzcav.zzawj();
            if (!TextUtils.isEmpty((CharSequence)this.zzatz().getGmpAppId())) {
                zzcdu zzcdu2 = this.zzaty();
                ((zzcdr)zzcdu2).zzug();
                ((zzcdr)zzcdu2).zzatu();
                zzcdu2.zzwh();
                if (zzcdu2.zzikb.zzayu()) {
                    ((zzcdr)zzcdu2).zzaub().zzazp();
                    String string = ((zzcdr)zzcdu2).zzaul().zzayp();
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        ((zzcdr)zzcdu2).zzaua().zzwh();
                        if (!string.equals(Build.VERSION.RELEASE)) {
                            Bundle bundle = new Bundle();
                            bundle.putString("_po", string);
                            zzcdu2.zzc("auto", "_ou", bundle);
                        }
                    }
                }
                this.zzaub().zza(new AtomicReference<String>());
            }
        }
        this.zzazh();
    }

    public final zzcav zzaum() {
        return this.zzisj;
    }

    public final zzccf zzaul() {
        zzccu.zza((zzcdr)this.zzisk);
        return this.zzisk;
    }

    public final zzcbu zzauk() {
        zzccu.zza(this.zzisl);
        return this.zzisl;
    }

    public final zzcbu zzayv() {
        if (this.zzisl != null && this.zzisl.isInitialized()) {
            return this.zzisl;
        }
        return null;
    }

    public final zzccp zzauj() {
        zzccu.zza(this.zzism);
        return this.zzism;
    }

    public final zzcfj zzaui() {
        zzccu.zza(this.zzisn);
        return this.zzisn;
    }

    public final zzcco zzauh() {
        zzccu.zza(this.zziso);
        return this.zziso;
    }

    final zzccp zzayw() {
        return this.zzism;
    }

    public final zzcdu zzaty() {
        zzccu.zza(this.zzisz);
        return this.zzisz;
    }

    public final AppMeasurement zzayx() {
        return this.zzisp;
    }

    public final FirebaseAnalytics zzayy() {
        return this.zzisq;
    }

    public final zzcfu zzaug() {
        zzccu.zza((zzcdr)this.zzisr);
        return this.zzisr;
    }

    public final zzcbs zzauf() {
        zzccu.zza((zzcdr)this.zziss);
        return this.zziss;
    }

    public final zzcaw zzaue() {
        zzccu.zza(this.zzist);
        return this.zzist;
    }

    public final zzcbq zzaud() {
        zzccu.zza(this.zzisu);
        return this.zzisu;
    }

    public final zzcby zzayz() {
        zzccu.zza(this.zzisv);
        return this.zzisv;
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final zzd zzvu() {
        return this.zzasl;
    }

    public final zzcei zzauc() {
        zzccu.zza(this.zzisw);
        return this.zzisw;
    }

    public final zzcem zzaub() {
        zzccu.zza(this.zzisx);
        return this.zzisx;
    }

    public final zzcbc zzaua() {
        zzccu.zza(this.zzisy);
        return this.zzisy;
    }

    public final zzcbp zzatz() {
        zzccu.zza(this.zzita);
        return this.zzita;
    }

    private final zzccd zzaza() {
        if (this.zzitb == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzitb;
    }

    private final zzcfp zzazb() {
        zzccu.zza(this.zzitc);
        return this.zzitc;
    }

    public final zzcas zzatx() {
        zzccu.zza(this.zzitd);
        return this.zzitd;
    }

    public final zzcal zzatw() {
        zzccu.zza(this.zzite);
        return this.zzite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzccu zzdm(Context context) {
        zzbp.zzu((Object)context);
        zzbp.zzu((Object)context.getApplicationContext());
        if (zzisi != null) return zzisi;
        Class<zzccu> clazz = zzccu.class;
        synchronized (zzccu.class) {
            if (zzisi != null) return zzisi;
            zzcdt zzcdt2 = new zzcdt(context);
            zzisi = new zzccu(zzcdt2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzisi;
        }
    }

    private static void zza(zzcds zzcds2) {
        if (zzcds2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzcds2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private static void zza(zzcdr zzcdr2) {
        if (zzcdr2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    private final boolean zzazc() {
        ((zzcdr)this.zzauj()).zzug();
        String string = zzcav.zzawh();
        File file = this.mContext.getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzitj = new RandomAccessFile(file2, "rw").getChannel();
            this.zziti = this.zzitj.tryLock();
            if (this.zziti != null) {
                this.zzauk().zzayi().log("Storage concurrent access okay");
                return true;
            }
            this.zzauk().zzayc().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzauk().zzayc().zzj("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzauk().zzayc().zzj("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        ((zzcdr)this.zzauj()).zzug();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzauk().zzayc().log("Bad chanel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzauk().zzaye().zzj("Unexpected data length. Bytes read", n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzauk().zzayc().zzj("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        ((zzcdr)this.zzauj()).zzug();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzauk().zzayc().log("Bad chanel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzauk().zzayc().zzj("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzauk().zzayc().zzj("Failed to write to channel", iOException);
            return false;
        }
    }

    @WorkerThread
    public final boolean isEnabled() {
        ((zzcdr)this.zzauj()).zzug();
        this.zzwh();
        if (this.zzisj.zzawk()) {
            return false;
        }
        Boolean bl = this.zzisj.zzit("firebase_analytics_collection_enabled");
        boolean bl2 = bl != null ? bl : !zzcav.zzaie();
        return this.zzaul().zzbn(bl2);
    }

    final void zzd(zzcaq zzcaq2) {
        ((zzcdr)this.zzauj()).zzug();
        this.zzwh();
        zzbp.zzgf((String)zzcaq2.packageName);
        this.zzf(zzcaq2);
    }

    final long zzazd() {
        Long l = this.zzaul().zziql.get();
        if (l == 0L) {
            return this.zzitt;
        }
        return Math.min(this.zzitt, l);
    }

    private final long zzaze() {
        long l = this.zzasl.currentTimeMillis();
        zzccf zzccf2 = this.zzaul();
        zzccf2.zzwh();
        zzccf2.zzug();
        long l2 = zzccf2.zziqk.get();
        if (l2 == 0L) {
            l2 = 1 + zzccf2.zzaug().zzazx().nextInt(86400000);
            zzccf2.zziqk.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    private final zzcaq zzjr(String string) {
        zzcap zzcap2 = this.zzaue().zziw(string);
        if (zzcap2 == null || TextUtils.isEmpty((CharSequence)zzcap2.zzul())) {
            this.zzauk().zzayh().zzj("No app data available; dropping", string);
            return null;
        }
        try {
            String string2 = zzbdv.zzcs((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
            if (zzcap2.zzul() != null && !zzcap2.zzul().equals(string2)) {
                this.zzauk().zzaye().zzj("App version does not match; dropping. appId", zzcbu.zzjf(string));
                return null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return new zzcaq(string, zzcap2.getGmpAppId(), zzcap2.zzul(), zzcap2.zzaus(), zzcap2.zzaut(), zzcap2.zzauu(), zzcap2.zzauv(), null, zzcap2.zzauw(), false, zzcap2.zzaup(), zzcap2.zzavj(), 0L, 0);
    }

    @WorkerThread
    final void zzb(zzcbi zzcbi2, String string) {
        Object object;
        zzcap zzcap2;
        block4: {
            zzcap2 = this.zzaue().zziw(string);
            if (zzcap2 == null || TextUtils.isEmpty((CharSequence)zzcap2.zzul())) {
                this.zzauk().zzayh().zzj("No app data available; dropping event", string);
                return;
            }
            try {
                object = zzbdv.zzcs((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
                if (zzcap2.zzul() != null && !zzcap2.zzul().equals(object)) {
                    this.zzauk().zzaye().zzj("App version does not match; dropping event. appId", zzcbu.zzjf(string));
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if ("_ui".equals(zzcbi2.name)) break block4;
                this.zzauk().zzaye().zzj("Could not find package. appId", zzcbu.zzjf(string));
            }
        }
        object = new zzcaq(string, zzcap2.getGmpAppId(), zzcap2.zzul(), zzcap2.zzaus(), zzcap2.zzaut(), zzcap2.zzauu(), zzcap2.zzauv(), null, zzcap2.zzauw(), false, zzcap2.zzaup(), zzcap2.zzavj(), 0L, 0);
        this.zzb(zzcbi2, (zzcaq)((Object)object));
    }

    @WorkerThread
    final void zzb(zzcbi zzcbi2, zzcaq zzcaq2) {
        zzbp.zzu((Object)((Object)zzcaq2));
        zzbp.zzgf((String)zzcaq2.packageName);
        ((zzcdr)this.zzauj()).zzug();
        this.zzwh();
        String string = zzcaq2.packageName;
        long l = zzcbi2.zzink;
        this.zzaug();
        if (!zzcfu.zzd(zzcbi2, zzcaq2)) {
            return;
        }
        if (!zzcaq2.zzils) {
            this.zzf(zzcaq2);
            return;
        }
        this.zzaue().beginTransaction();
        try {
            zzbcc zzbcc2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzcaw zzcaw2 = this.zzaue();
            zzbp.zzgf((String)string3);
            zzcaw2.zzug();
            zzcaw2.zzwh();
            if (l2 < 0L) {
                zzcaw2.zzauk().zzaye().zze("Invalid time querying timed out conditional properties", zzcbu.zzjf(string3), l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzcaw2.zzc(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzauk().zzayh().zzd("User property timed out", object22.packageName, this.zzauf().zzje(object22.zzima.name), object22.zzima.getValue());
                if (object22.zzime != null) {
                    this.zzc(new zzcbi(object22.zzime, l), zzcaq2);
                }
                this.zzaue().zzal(string, object22.zzima.name);
            }
            l2 = l;
            string3 = string;
            zzcaw2 = this.zzaue();
            zzbp.zzgf((String)string3);
            zzcaw2.zzug();
            zzcaw2.zzwh();
            if (l2 < 0L) {
                zzcaw2.zzauk().zzaye().zze("Invalid time querying expired conditional properties", zzcbu.zzjf(string3), l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzcaw2.zzc(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzcat)((Object)object4.next());
                if (object == null) continue;
                this.zzauk().zzayh().zzd("User property expired", object.packageName, this.zzauf().zzje(object.zzima.name), object.zzima.getValue());
                this.zzaue().zzai(string, object.zzima.name);
                if (object.zzimi != null) {
                    object22.add(object.zzimi);
                }
                this.zzaue().zzal(string, object.zzima.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzcbi)((Object)e);
                this.zzc(new zzcbi((zzcbi)((Object)object), l), zzcaq2);
            }
            long l3 = l;
            String string4 = zzcbi2.name;
            string3 = string;
            zzcaw2 = this.zzaue();
            zzbp.zzgf((String)string3);
            zzbp.zzgf((String)string4);
            zzcaw2.zzug();
            zzcaw2.zzwh();
            if (l3 < 0L) {
                zzcaw2.zzauk().zzaye().zzd("Invalid time querying triggered conditional properties", zzcbu.zzjf(string3), zzcaw2.zzauf().zzjc(string4), l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzcaw2.zzc((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzbcc2 = (zzcat)((Object)iterator.next());
                if (zzbcc2 == null) continue;
                zzcfr zzcfr2 = zzbcc2.zzima;
                zzcft zzcft2 = new zzcft(zzbcc2.packageName, zzbcc2.zzilz, zzcfr2.name, l, zzcfr2.getValue());
                if (this.zzaue().zza(zzcft2)) {
                    this.zzauk().zzayh().zzd("User property triggered", zzbcc2.packageName, this.zzauf().zzje(zzcft2.mName), zzcft2.mValue);
                } else {
                    this.zzauk().zzayc().zzd("Too many active user properties, ignoring", zzcbu.zzjf(zzbcc2.packageName), this.zzauf().zzje(zzcft2.mName), zzcft2.mValue);
                }
                if (zzbcc2.zzimg != null) {
                    object.add(zzbcc2.zzimg);
                }
                zzbcc2.zzima = new zzcfr(zzcft2);
                zzbcc2.zzimc = true;
                this.zzaue().zza((zzcat)zzbcc2);
            }
            this.zzc(zzcbi2, zzcaq2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzbcc2 = (zzcbi)((Object)e);
                this.zzc(new zzcbi((zzcbi)zzbcc2, l), zzcaq2);
            }
            this.zzaue().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzaue().endTransaction();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final void zzc(zzcbi zzcbi2, zzcaq zzcaq2) {
        zzbp.zzu((Object)((Object)zzcaq2));
        zzbp.zzgf((String)zzcaq2.packageName);
        long l = System.nanoTime();
        ((zzcdr)this.zzauj()).zzug();
        this.zzwh();
        String string = zzcaq2.packageName;
        this.zzaug();
        if (!zzcfu.zzd(zzcbi2, zzcaq2)) {
            return;
        }
        if (!zzcaq2.zzils) {
            this.zzf(zzcaq2);
            return;
        }
        if (this.zzauh().zzaq(string, zzcbi2.name)) {
            this.zzauk().zzaye().zze("Dropping blacklisted event. appId", zzcbu.zzjf(string), this.zzauf().zzjc(zzcbi2.name));
            boolean bl = this.zzaug().zzkg(string) || this.zzaug().zzkh(string);
            if (!bl && !"_err".equals(zzcbi2.name)) {
                this.zzaug().zza(string, 11, "_ev", zzcbi2.name, 0);
            }
            if (!bl) return;
            zzcap zzcap2 = this.zzaue().zziw(string);
            if (zzcap2 == null) return;
            long l2 = Math.max(zzcap2.zzauz(), zzcap2.zzauy());
            if (Math.abs(this.zzasl.currentTimeMillis() - l2) <= zzcav.zzawn()) return;
            this.zzauk().zzayh().log("Fetching config for blacklisted app");
            this.zzb(zzcap2);
            return;
        }
        if (this.zzauk().zzad(2)) {
            this.zzauk().zzayi().zzj("Logging event", this.zzauf().zzb(zzcbi2));
        }
        this.zzaue().beginTransaction();
        try {
            zzcbe zzcbe2;
            long l3;
            int n;
            String string2;
            Bundle bundle = zzcbi2.zzinj.zzaxy();
            this.zzf(zzcaq2);
            if ("_iap".equals(zzcbi2.name) || "ecommerce_purchase".equals(zzcbi2.name)) {
                long l4;
                String string3;
                block37: {
                    string3 = bundle.getString("currency");
                    if ("ecommerce_purchase".equals(zzcbi2.name)) {
                        double d = bundle.getDouble("value") * 1000000.0;
                        if (d == 0.0) {
                            d = (double)bundle.getLong("value") * 1000000.0;
                        }
                        if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                            l4 = Math.round(d);
                            break block37;
                        } else {
                            this.zzauk().zzaye().zze("Data lost. Currency value is too big. appId", zzcbu.zzjf(string), d);
                            this.zzaue().setTransactionSuccessful();
                            return;
                        }
                    }
                    l4 = bundle.getLong("value");
                }
                if (!TextUtils.isEmpty((CharSequence)string3) && (string3 = string3.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                    String string4 = String.valueOf("_ltv_");
                    String string5 = String.valueOf(string3);
                    String string6 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
                    zzcft zzcft2 = this.zzaue().zzaj(string, string6);
                    if (zzcft2 == null || !(zzcft2.mValue instanceof Long)) {
                        string2 = string;
                        n = this.zzisj.zzb(string2, zzcbk.zziow) - 1;
                        string2 = string;
                        zzcaw zzcaw2 = this.zzaue();
                        zzbp.zzgf((String)string2);
                        zzcaw2.zzug();
                        zzcaw2.zzwh();
                        try {
                            zzcaw2.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string2, string2, String.valueOf(n)});
                        }
                        catch (SQLiteException sQLiteException) {
                            zzcaw2.zzauk().zzayc().zze("Error pruning currencies. appId", zzcbu.zzjf(string2), (Object)sQLiteException);
                        }
                        zzcft2 = new zzcft(string, zzcbi2.zzilz, string6, this.zzasl.currentTimeMillis(), l4);
                    } else {
                        l3 = (Long)zzcft2.mValue;
                        zzcft2 = new zzcft(string, zzcbi2.zzilz, string6, this.zzasl.currentTimeMillis(), l3 + l4);
                    }
                    if (!this.zzaue().zza(zzcft2)) {
                        this.zzauk().zzayc().zzd("Too many unique user properties are set. Ignoring user property. appId", zzcbu.zzjf(string), this.zzauf().zzje(zzcft2.mName), zzcft2.mValue);
                        this.zzaug().zza(string, 9, null, null, 0);
                    }
                }
            }
            boolean bl = zzcfu.zzju(zzcbi2.name);
            boolean bl2 = "_err".equals(zzcbi2.name);
            zzcax zzcax2 = this.zzaue().zza(this.zzaze(), string, true, bl, false, bl2, false);
            long l5 = zzcax2.zzims - zzcav.zzavv();
            if (l5 > 0L) {
                if (l5 % 1000L == 1L) {
                    this.zzauk().zzayc().zze("Data loss. Too many events logged. appId, count", zzcbu.zzjf(string), zzcax2.zzims);
                }
                this.zzaue().setTransactionSuccessful();
                return;
            }
            if (bl && (l5 = zzcax2.zzimr - zzcav.zzavw()) > 0L) {
                if (l5 % 1000L == 1L) {
                    this.zzauk().zzayc().zze("Data loss. Too many public events logged. appId, count", zzcbu.zzjf(string), zzcax2.zzimr);
                }
                this.zzaug().zza(string, 16, "_ev", zzcbi2.name, 0);
                this.zzaue().setTransactionSuccessful();
                return;
            }
            if (bl2) {
                string2 = zzcaq2.packageName;
                n = this.zzisj.zzb(string2, zzcbk.zziod);
                l5 = zzcax2.zzimu - (long)Math.max(0, n = Math.min(1000000, n));
                if (l5 > 0L) {
                    if (l5 == 1L) {
                        this.zzauk().zzayc().zze("Too many error events logged. appId, count", zzcbu.zzjf(string), zzcax2.zzimu);
                    }
                    this.zzaue().setTransactionSuccessful();
                    return;
                }
            }
            this.zzaug().zza(bundle, "_o", (Object)zzcbi2.zzilz);
            if (this.zzaug().zzke(string)) {
                this.zzaug().zza(bundle, "_dbg", 1L);
                this.zzaug().zza(bundle, "_r", 1L);
            }
            if ((l3 = this.zzaue().zzix(string)) > 0L) {
                this.zzauk().zzaye().zze("Data lost. Too many events stored on disk, deleted. appId", zzcbu.zzjf(string), l3);
            }
            zzcbd zzcbd2 = new zzcbd(this, zzcbi2.zzilz, string, zzcbi2.name, zzcbi2.zzink, 0L, bundle);
            zzcbe zzcbe3 = this.zzaue().zzah(string, zzcbd2.mName);
            if (zzcbe3 == null) {
                long l6 = this.zzaue().zzja(string);
                zzcav.zzavu();
                if (l6 >= 500L) {
                    this.zzauk().zzayc().zzd("Too many event names used, ignoring event. appId, name, supported count", zzcbu.zzjf(string), this.zzauf().zzjc(zzcbd2.mName), zzcav.zzavu());
                    this.zzaug().zza(string, 8, null, null, 0);
                    return;
                }
                zzcbe2 = new zzcbe(string, zzcbd2.mName, 0L, 0L, zzcbd2.zzfcw);
            } else {
                zzcbd2 = zzcbd2.zza(this, zzcbe3.zzinf);
                zzcbe2 = zzcbe3.zzbb(zzcbd2.zzfcw);
            }
            this.zzaue().zza(zzcbe2);
            this.zza(zzcbd2, zzcaq2);
            this.zzaue().setTransactionSuccessful();
            if (this.zzauk().zzad(2)) {
                this.zzauk().zzayi().zzj("Event recorded", this.zzauf().zza(zzcbd2));
            }
        }
        finally {
            this.zzaue().endTransaction();
        }
        this.zzazh();
        this.zzauk().zzayi().zzj("Background event processing time, ms", (System.nanoTime() - l + 500000L) / 1000000L);
    }

    @WorkerThread
    final void zzd(zzcat zzcat2) {
        zzcaq zzcaq2 = this.zzjr(zzcat2.packageName);
        if (zzcaq2 != null) {
            this.zzb(zzcat2, zzcaq2);
        }
    }

    @WorkerThread
    final void zzb(zzcat zzcat2, zzcaq zzcaq2) {
        zzbp.zzu((Object)((Object)zzcat2));
        zzbp.zzgf((String)zzcat2.packageName);
        zzbp.zzu((Object)zzcat2.zzilz);
        zzbp.zzu((Object)((Object)zzcat2.zzima));
        zzbp.zzgf((String)zzcat2.zzima.name);
        ((zzcdr)this.zzauj()).zzug();
        this.zzwh();
        if (TextUtils.isEmpty((CharSequence)zzcaq2.zziln)) {
            return;
        }
        if (!zzcaq2.zzils) {
            this.zzf(zzcaq2);
            return;
        }
        zzcat zzcat3 = new zzcat(zzcat2);
        new zzcat(zzcat2).zzimc = false;
        this.zzaue().beginTransaction();
        try {
            boolean bl = false;
            zzcat zzcat4 = this.zzaue().zzak(zzcat3.packageName, zzcat3.zzima.name);
            if (zzcat4 != null && !zzcat4.zzilz.equals(zzcat3.zzilz)) {
                this.zzauk().zzaye().zzd("Updating a conditional user property with different origin. name, origin, origin (from DB)", this.zzauf().zzje(zzcat3.zzima.name), zzcat3.zzilz, zzcat4.zzilz);
            }
            if (zzcat4 != null && zzcat4.zzimc) {
                zzcat3.zzilz = zzcat4.zzilz;
                zzcat3.zzimb = zzcat4.zzimb;
                zzcat3.zzimf = zzcat4.zzimf;
                zzcat3.zzimd = zzcat4.zzimd;
                zzcat3.zzimg = zzcat4.zzimg;
                zzcat3.zzimc = zzcat4.zzimc;
                zzcat3.zzima = new zzcfr(zzcat3.zzima.name, zzcat4.zzima.zziwu, zzcat3.zzima.getValue(), zzcat4.zzima.zzilz);
            } else if (TextUtils.isEmpty((CharSequence)zzcat3.zzimd)) {
                zzcat3.zzima = new zzcfr(zzcat3.zzima.name, zzcat3.zzimb, zzcat3.zzima.getValue(), zzcat3.zzima.zzilz);
                zzcat3.zzimc = true;
                bl = true;
            }
            if (zzcat3.zzimc) {
                zzcfr zzcfr2 = zzcat3.zzima;
                zzcft zzcft2 = new zzcft(zzcat3.packageName, zzcat3.zzilz, zzcfr2.name, zzcfr2.zziwu, zzcfr2.getValue());
                if (this.zzaue().zza(zzcft2)) {
                    this.zzauk().zzayh().zzd("User property updated immediately", zzcat3.packageName, this.zzauf().zzje(zzcft2.mName), zzcft2.mValue);
                } else {
                    this.zzauk().zzayc().zzd("(2)Too many active user properties, ignoring", zzcbu.zzjf(zzcat3.packageName), this.zzauf().zzje(zzcft2.mName), zzcft2.mValue);
                }
                if (bl && zzcat3.zzimg != null) {
                    zzcbi zzcbi2 = new zzcbi(zzcat3.zzimg, zzcat3.zzimb);
                    this.zzc(zzcbi2, zzcaq2);
                }
            }
            if (this.zzaue().zza(zzcat3)) {
                this.zzauk().zzayh().zzd("Conditional property added", zzcat3.packageName, this.zzauf().zzje(zzcat3.zzima.name), zzcat3.zzima.getValue());
            } else {
                this.zzauk().zzayc().zzd("Too many conditional properties, ignoring", zzcbu.zzjf(zzcat3.packageName), this.zzauf().zzje(zzcat3.zzima.name), zzcat3.zzima.getValue());
            }
            this.zzaue().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzaue().endTransaction();
        }
    }

    @WorkerThread
    final void zze(zzcat zzcat2) {
        zzcaq zzcaq2 = this.zzjr(zzcat2.packageName);
        if (zzcaq2 != null) {
            this.zzc(zzcat2, zzcaq2);
        }
    }

    @WorkerThread
    final void zzc(zzcat zzcat2, zzcaq zzcaq2) {
        zzbp.zzu((Object)((Object)zzcat2));
        zzbp.zzgf((String)zzcat2.packageName);
        zzbp.zzu((Object)((Object)zzcat2.zzima));
        zzbp.zzgf((String)zzcat2.zzima.name);
        ((zzcdr)this.zzauj()).zzug();
        this.zzwh();
        if (TextUtils.isEmpty((CharSequence)zzcaq2.zziln)) {
            return;
        }
        if (!zzcaq2.zzils) {
            this.zzf(zzcaq2);
            return;
        }
        this.zzaue().beginTransaction();
        try {
            this.zzf(zzcaq2);
            zzcat zzcat3 = this.zzaue().zzak(zzcat2.packageName, zzcat2.zzima.name);
            if (zzcat3 != null) {
                this.zzauk().zzayh().zze("Removing conditional user property", zzcat2.packageName, this.zzauf().zzje(zzcat2.zzima.name));
                this.zzaue().zzal(zzcat2.packageName, zzcat2.zzima.name);
                if (zzcat3.zzimc) {
                    this.zzaue().zzai(zzcat2.packageName, zzcat2.zzima.name);
                }
                if (zzcat2.zzimi != null) {
                    Bundle bundle = null;
                    if (zzcat2.zzimi.zzinj != null) {
                        bundle = zzcat2.zzimi.zzinj.zzaxy();
                    }
                    zzcbi zzcbi2 = this.zzaug().zza(zzcat2.zzimi.name, bundle, zzcat3.zzilz, zzcat2.zzimi.zzink, true, false);
                    this.zzc(zzcbi2, zzcaq2);
                }
            } else {
                this.zzauk().zzaye().zze("Conditional user property doesn't exist", zzcbu.zzjf(zzcat2.packageName), this.zzauf().zzje(zzcat2.zzima.name));
            }
            this.zzaue().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzaue().endTransaction();
        }
    }

    @WorkerThread
    public final byte[] zza(@NonNull zzcbi zzcbi2, @Size(min=1L) String string) {
        Object object;
        this.zzwh();
        ((zzcdr)this.zzauj()).zzug();
        zzccu.zzatt();
        zzbp.zzu((Object)((Object)zzcbi2));
        zzbp.zzgf((String)string);
        zzcgh zzcgh2 = new zzcgh();
        this.zzaue().beginTransaction();
        try {
            zzcbe zzcbe2;
            long l;
            Object object2;
            Pair<String, Boolean> pair;
            zzcap zzcap2 = this.zzaue().zziw(string);
            if (zzcap2 == null) {
                this.zzauk().zzayh().zzj("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzcap2.zzauw()) {
                this.zzauk().zzayh().zzj("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            object = new zzcgi();
            zzcgh2.zziyx = new zzcgi[]{object};
            object.zziyz = 1;
            object.zzizh = "android";
            object.zzch = zzcap2.getAppId();
            object.zzilo = zzcap2.zzaut();
            object.zzhtl = zzcap2.zzul();
            long l2 = zzcap2.zzaus();
            object.zzizu = l2 == Integer.MIN_VALUE ? null : Integer.valueOf((int)l2);
            object.zzizl = zzcap2.zzauu();
            object.zziln = zzcap2.getGmpAppId();
            object.zzizq = zzcap2.zzauv();
            if (this.isEnabled() && zzcav.zzaxg() && this.zzisj.zziu(object.zzch)) {
                this.zzatz();
                object.zzizz = null;
            }
            if ((pair = this.zzaul().zzjh(zzcap2.getAppId())) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                object.zzizn = (String)pair.first;
                object.zzizo = (Boolean)pair.second;
            }
            this.zzaua().zzwh();
            object.zzizi = Build.MODEL;
            this.zzaua().zzwh();
            object.zzcy = Build.VERSION.RELEASE;
            object.zzizk = (int)this.zzaua().zzaxv();
            object.zzizj = this.zzaua().zzaxw();
            object.zzizp = zzcap2.getAppInstanceId();
            object.zzilv = zzcap2.zzaup();
            List<zzcft> list = this.zzaue().zziv(zzcap2.getAppId());
            object.zzizb = new zzcgk[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                object2 = new zzcgk();
                object.zzizb[i] = object2;
                ((zzcgk)((Object)object2)).name = list.get((int)i).mName;
                ((zzcgk)((Object)object2)).zzjad = list.get((int)i).zziwy;
                this.zzaug().zza((zzcgk)((Object)object2), list.get((int)i).mValue);
            }
            Bundle bundle = zzcbi2.zzinj.zzaxy();
            if ("_iap".equals(zzcbi2.name)) {
                bundle.putLong("_c", 1L);
                this.zzauk().zzayh().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzcbi2.zzilz);
            if (this.zzaug().zzke(object.zzch)) {
                this.zzaug().zza(bundle, "_dbg", 1L);
                this.zzaug().zza(bundle, "_r", 1L);
            }
            if ((object2 = this.zzaue().zzah(string, zzcbi2.name)) == null) {
                l = 0L;
                zzcbe2 = new zzcbe(string, zzcbi2.name, 1L, 0L, zzcbi2.zzink);
                this.zzaue().zza(zzcbe2);
            } else {
                l = ((zzcbe)object2).zzinf;
                zzcbe2 = ((zzcbe)object2).zzbb(zzcbi2.zzink).zzaxx();
                this.zzaue().zza(zzcbe2);
            }
            zzcbd zzcbd2 = new zzcbd(this, zzcbi2.zzilz, string, zzcbi2.name, zzcbi2.zzink, l, bundle);
            zzcgf zzcgf2 = new zzcgf();
            object.zziza = new zzcgf[]{zzcgf2};
            zzcgf2.zziyt = zzcbd2.zzfcw;
            zzcgf2.name = zzcbd2.mName;
            zzcgf2.zziyu = zzcbd2.zzinb;
            zzcgf2.zziys = new zzcgg[zzcbd2.zzinc.size()];
            int n = 0;
            for (String string2 : zzcbd2.zzinc) {
                zzcgg zzcgg2 = new zzcgg();
                zzcgf2.zziys[n++] = zzcgg2;
                zzcgg2.name = string2;
                Object object3 = zzcbd2.zzinc.get(string2);
                this.zzaug().zza(zzcgg2, object3);
            }
            object.zzizt = this.zza(zzcap2.getAppId(), object.zzizb, object.zziza);
            object.zzizd = zzcgf2.zziyt;
            object.zzize = zzcgf2.zziyt;
            long l3 = zzcap2.zzaur();
            object.zzizg = l3 != 0L ? Long.valueOf(l3) : null;
            long l4 = zzcap2.zzauq();
            if (l4 == 0L) {
                l4 = l3;
            }
            object.zzizf = l4 != 0L ? Long.valueOf(l4) : null;
            zzcap2.zzava();
            object.zzizr = (int)zzcap2.zzaux();
            object.zzizm = zzcav.zzauu();
            object.zzizc = this.zzasl.currentTimeMillis();
            object.zzizs = Boolean.TRUE;
            zzcap2.zzal(object.zzizd);
            zzcap2.zzam(object.zzize);
            this.zzaue().zza(zzcap2);
            this.zzaue().setTransactionSuccessful();
        }
        finally {
            this.zzaue().endTransaction();
        }
        try {
            byte[] byArray = new byte[zzcgh2.zzbjo()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzegr zzegr2 = zzegr.zzi((byte[])byArray, (int)0, (int)byArray2.length);
            zzcgh2.zza(zzegr2);
            zzegr2.zzcch();
            return this.zzaug().zzo((byte[])object);
        }
        catch (IOException iOException) {
            this.zzauk().zzayc().zze("Data loss. Failed to bundle and serialize. appId", zzcbu.zzjf(string), iOException);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void zza(zzcbd var1_1, zzcaq var2_2) {
        block10: {
            this.zzauj().zzug();
            this.zzwh();
            zzbp.zzu((Object)var1_1);
            zzbp.zzu((Object)var2_2);
            zzbp.zzgf((String)var1_1.mAppId);
            zzbp.zzbh((boolean)var1_1.mAppId.equals(var2_2.packageName));
            var3_3 = new zzcgi();
            new zzcgi().zziyz = 1;
            var3_3.zzizh = "android";
            var3_3.zzch = var2_2.packageName;
            var3_3.zzilo = var2_2.zzilo;
            var3_3.zzhtl = var2_2.zzhtl;
            var3_3.zzizu = var2_2.zzilu == -2147483648L ? null : Integer.valueOf((int)var2_2.zzilu);
            var3_3.zzizl = var2_2.zzilp;
            var3_3.zziln = var2_2.zziln;
            var3_3.zzizq = var2_2.zzilq == 0L ? null : Long.valueOf(var2_2.zzilq);
            var4_4 = this.zzaul().zzjh(var2_2.packageName);
            if (var4_4 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var4_4.first))) {
                var3_3.zzizn = (String)var4_4.first;
                var3_3.zzizo = (Boolean)var4_4.second;
            }
            this.zzaua().zzwh();
            var3_3.zzizi = Build.MODEL;
            this.zzaua().zzwh();
            var3_3.zzcy = Build.VERSION.RELEASE;
            var3_3.zzizk = (int)this.zzaua().zzaxv();
            var3_3.zzizj = this.zzaua().zzaxw();
            var3_3.zzizm = null;
            var3_3.zzizc = null;
            var3_3.zzizd = null;
            var3_3.zzize = null;
            var3_3.zzizy = var2_2.zzilw;
            if (this.isEnabled() && zzcav.zzaxg()) {
                this.zzatz();
                var3_3.zzizz = null;
            }
            if ((var5_5 = this.zzaue().zziw(var2_2.packageName)) == null) {
                var5_5 = new zzcap(this, var2_2.packageName);
                var5_5.zzim(this.zzatz().zzaxz());
                var5_5.zzip(var2_2.zzilv);
                var5_5.zzin(var2_2.zziln);
                var5_5.zzio(this.zzaul().zzji(var2_2.packageName));
                var5_5.zzaq(0L);
                var5_5.zzal(0L);
                var5_5.zzam(0L);
                var5_5.setAppVersion(var2_2.zzhtl);
                var5_5.zzan(var2_2.zzilu);
                var5_5.zziq(var2_2.zzilo);
                var5_5.zzao(var2_2.zzilp);
                var5_5.zzap(var2_2.zzilq);
                var5_5.setMeasurementEnabled(var2_2.zzils);
                var5_5.zzaz(var2_2.zzilw);
                this.zzaue().zza(var5_5);
            }
            var3_3.zzizp = var5_5.getAppInstanceId();
            var3_3.zzilv = var5_5.zzaup();
            var6_6 = this.zzaue().zziv(var2_2.packageName);
            var3_3.zzizb = new zzcgk[var6_6.size()];
            for (var7_7 = 0; var7_7 < var6_6.size(); ++var7_7) {
                var3_3.zzizb[var7_7] = var8_9 = new zzcgk();
                var8_9.name = var6_6.get((int)var7_7).mName;
                var8_9.zzjad = var6_6.get((int)var7_7).zziwy;
                this.zzaug().zza(var8_9, var6_6.get((int)var7_7).mValue);
            }
            try {
                var7_8 = this.zzaue().zza(var3_3);
            }
            catch (IOException var9_10) {
                this.zzauk().zzayc().zze("Data loss. Failed to insert raw event metadata. appId", zzcbu.zzjf(var3_3.zzch), var9_10);
                return;
            }
            v0 = this.zzaue();
            var11_11 = var1_1;
            var10_12 = this;
            if (var11_11.zzinc == null) ** GOTO lbl-1000
            for (Object var13_15 : var11_11.zzinc) {
                if (!"_r".equals(var13_15)) continue;
                v1 = true;
                break block10;
            }
            var12_14 = var10_12.zzauh().zzar(var11_11.mAppId, var11_11.mName);
            var13_15 = var10_12.zzaue().zza(var10_12.zzaze(), var11_11.mAppId, false, false, false, false, false);
            if (var12_14 && var13_15.zzimv < (long)var10_12.zzisj.zzis(var11_11.mAppId)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
        }
        if (v0.zza(var1_1, var7_8, v1)) {
            this.zzitp = 0L;
        }
    }

    public final String zzjs(String string) {
        Future<String> future = this.zzauj().zzd(new zzccw(this, string));
        try {
            return future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzauk().zzayc().zze("Failed to get app instance id. appId", zzcbu.zzjf(string), exception);
            return null;
        }
    }

    static void zzatt() {
        zzcav.zzawj();
        throw new IllegalStateException("Unexpected call on client side");
    }

    @WorkerThread
    final void zzb(zzcfr zzcfr2, zzcaq zzcaq2) {
        ((zzcdr)this.zzauj()).zzug();
        this.zzwh();
        if (TextUtils.isEmpty((CharSequence)zzcaq2.zziln)) {
            return;
        }
        if (!zzcaq2.zzils) {
            this.zzf(zzcaq2);
            return;
        }
        int n = this.zzaug().zzjy(zzcfr2.name);
        if (n != 0) {
            this.zzaug();
            String string = zzcfu.zza(zzcfr2.name, zzcav.zzavn(), true);
            int n2 = zzcfr2.name != null ? zzcfr2.name.length() : 0;
            this.zzaug().zza(zzcaq2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzaug().zzl(zzcfr2.name, zzcfr2.getValue());
        if (n != 0) {
            this.zzaug();
            String string = zzcfu.zza(zzcfr2.name, zzcav.zzavn(), true);
            Object object = zzcfr2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzaug().zza(zzcaq2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzaug().zzm(zzcfr2.name, zzcfr2.getValue());
        if (object == null) {
            return;
        }
        zzcft zzcft2 = new zzcft(zzcaq2.packageName, zzcfr2.zzilz, zzcfr2.name, zzcfr2.zziwu, object);
        this.zzauk().zzayh().zze("Setting user property", this.zzauf().zzje(zzcft2.mName), object);
        this.zzaue().beginTransaction();
        try {
            this.zzf(zzcaq2);
            boolean bl = this.zzaue().zza(zzcft2);
            this.zzaue().setTransactionSuccessful();
            if (bl) {
                this.zzauk().zzayh().zze("User property set", this.zzauf().zzje(zzcft2.mName), zzcft2.mValue);
            } else {
                this.zzauk().zzayc().zze("Too many unique user properties are set. Ignoring user property", this.zzauf().zzje(zzcft2.mName), zzcft2.mValue);
                this.zzaug().zza(zzcaq2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzaue().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzcfr zzcfr2, zzcaq zzcaq2) {
        ((zzcdr)this.zzauj()).zzug();
        this.zzwh();
        if (TextUtils.isEmpty((CharSequence)zzcaq2.zziln)) {
            return;
        }
        if (!zzcaq2.zzils) {
            this.zzf(zzcaq2);
            return;
        }
        this.zzauk().zzayh().zzj("Removing user property", this.zzauf().zzje(zzcfr2.name));
        this.zzaue().beginTransaction();
        try {
            this.zzf(zzcaq2);
            this.zzaue().zzai(zzcaq2.packageName, zzcfr2.name);
            this.zzaue().setTransactionSuccessful();
            this.zzauk().zzayh().zzj("User property removed", this.zzauf().zzje(zzcfr2.name));
            return;
        }
        finally {
            this.zzaue().endTransaction();
        }
    }

    @WorkerThread
    public final void zzazf() {
        ((zzcdr)this.zzauj()).zzug();
        this.zzwh();
        this.zzits = true;
        try {
            String string;
            zzcav.zzawj();
            Boolean bl = this.zzaul().zzayn();
            if (bl == null) {
                this.zzauk().zzaye().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzauk().zzayc().log("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzitp > 0L) {
                this.zzazh();
                return;
            }
            Object object = this;
            ((zzcdr)((zzccu)object).zzauj()).zzug();
            if (((zzccu)object).zzitk != null) {
                this.zzauk().zzayi().log("Uploading requested multiple times");
                return;
            }
            if (!this.zzayz().zzyu()) {
                this.zzauk().zzayi().log("Network not connected, ignoring upload request");
                this.zzazh();
                return;
            }
            long l = this.zzasl.currentTimeMillis();
            long l2 = l - zzcav.zzawu();
            this.zzg(null, l2);
            long l3 = this.zzaul().zziqg.get();
            if (l3 != 0L) {
                this.zzauk().zzayh().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzaue().zzaxh()))) {
                if (this.zzito == -1L) {
                    this.zzito = this.zzaue().zzaxo();
                }
                Object object2 = string;
                int n = this.zzisj.zzb((String)object2, zzcbk.zziny);
                object2 = string;
                object = this.zzisj;
                int n2 = Math.max(0, ((zzcav)object).zzb((String)object2, zzcbk.zzinz));
                List<Pair<zzcgi, Long>> list = this.zzaue().zzl(string, n, n2);
                if (!list.isEmpty()) {
                    Object object3;
                    String string2 = null;
                    Object object4 = list.iterator();
                    while (object4.hasNext()) {
                        zzcgi zzcgi2 = (zzcgi)((Object)object4.next().first);
                        if (TextUtils.isEmpty((CharSequence)zzcgi2.zzizn)) continue;
                        string2 = zzcgi2.zzizn;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object3 = (zzcgi)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)((zzcgi)((Object)object3)).zzizn) || ((zzcgi)((Object)object3)).zzizn.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object4 = new zzcgh();
                    new zzcgh().zziyx = new zzcgi[list.size()];
                    object3 = new ArrayList(list.size());
                    boolean bl2 = zzcav.zzaxg() && this.zzisj.zziu(string);
                    for (int i = 0; i < ((zzcgh)((Object)object4)).zziyx.length; ++i) {
                        ((zzcgh)((Object)object4)).zziyx[i] = (zzcgi)((Object)list.get((int)i).first);
                        object3.add((Long)list.get((int)i).second);
                        ((zzcgh)((Object)object4)).zziyx[i].zzizm = zzcav.zzauu();
                        ((zzcgh)((Object)object4)).zziyx[i].zzizc = l;
                        ((zzcgh)((Object)object4)).zziyx[i].zzizs = zzcav.zzawj();
                        if (bl2) continue;
                        ((zzcgh)((Object)object4)).zziyx[i].zzizz = null;
                    }
                    String string3 = null;
                    if (this.zzauk().zzad(2)) {
                        string3 = this.zzauf().zza((zzcgh)((Object)object4));
                    }
                    byte[] byArray = this.zzaug().zzb((zzcgh)((Object)object4));
                    String string4 = zzcav.zzawt();
                    try {
                        URL uRL = new URL(string4);
                        object2 = object3;
                        object = this;
                        zzbp.zzbh((!object2.isEmpty() ? 1 : 0) != 0);
                        if (((zzccu)object).zzitk != null) {
                            ((zzccu)object).zzauk().zzayc().log("Set uploading progress before finishing the previous upload");
                        } else {
                            ((zzccu)object).zzitk = new ArrayList<Long>((Collection<Long>)object2);
                        }
                        this.zzaul().zziqh.set(l);
                        String string5 = "?";
                        if (((zzcgh)((Object)object4)).zziyx.length > 0) {
                            string5 = ((zzcgh)((Object)object4)).zziyx[0].zzch;
                        }
                        this.zzauk().zzayi().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                        this.zzitr = true;
                        zzccx zzccx2 = new zzccx(this);
                        byte[] byArray2 = byArray;
                        URL uRL2 = uRL;
                        object2 = string;
                        object = this.zzayz();
                        ((zzcdr)object).zzug();
                        ((zzcds)object).zzwh();
                        zzbp.zzu((Object)uRL2);
                        zzbp.zzu((Object)byArray2);
                        zzbp.zzu((Object)zzccx2);
                        ((zzcdr)object).zzauj().zzh(new zzccc((zzcby)object, (String)object2, uRL2, byArray2, null, zzccx2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzauk().zzayc().zze("Failed to parse upload URL. Not uploading. appId", zzcbu.zzjf(string), string4);
                    }
                }
            } else {
                zzcap zzcap2;
                this.zzito = -1L;
                String string6 = this.zzaue().zzba(l - zzcav.zzawu());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzcap2 = this.zzaue().zziw(string6)) != null) {
                    this.zzb(zzcap2);
                }
            }
            return;
        }
        finally {
            this.zzits = false;
            this.zzazl();
        }
    }

    @WorkerThread
    private final void zzb(zzcap zzcap2) {
        ((zzcdr)this.zzauj()).zzug();
        if (TextUtils.isEmpty((CharSequence)zzcap2.getGmpAppId())) {
            this.zzb(zzcap2.getAppId(), 204, null, null, null);
            return;
        }
        Object object = zzcap2.getAppInstanceId();
        String string = zzcap2.getGmpAppId();
        Uri.Builder builder = new Uri.Builder();
        String string2 = String.valueOf(string);
        builder.scheme(zzcbk.zzinw.get()).encodedAuthority(zzcbk.zzinx.get()).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", (String)object).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "11220");
        String string3 = builder.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzauk().zzayi().zzj("Fetching remote configuration", zzcap2.getAppId());
            zzcgc zzcgc2 = this.zzauh().zzjn(zzcap2.getAppId());
            ArrayMap arrayMap = null;
            String string4 = this.zzauh().zzjo(zzcap2.getAppId());
            if (zzcgc2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zzitq = true;
            zzccy zzccy2 = new zzccy(this);
            builder = arrayMap;
            object = uRL;
            string = zzcap2.getAppId();
            zzcby zzcby2 = this.zzayz();
            ((zzcdr)zzcby2).zzug();
            zzcby2.zzwh();
            zzbp.zzu((Object)object);
            zzbp.zzu((Object)zzccy2);
            ((zzcdr)zzcby2).zzauj().zzh(new zzccc(zzcby2, string, (URL)object, null, (Map)builder, zzccy2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzauk().zzayc().zze("Failed to parse config URL. Not fetching. appId", zzcbu.zzjf(zzcap2.getAppId()), string3);
            return;
        }
    }

    private final boolean zzg(String string, long l) {
        this.zzaue().beginTransaction();
        try {
            block69: {
                int n;
                Object object;
                String string2;
                zza zza2;
                block68: {
                    zza zza3 = zza2 = new zza(this, null);
                    long l2 = this.zzito;
                    long l3 = l;
                    string2 = null;
                    object = this.zzaue();
                    zzbp.zzu((Object)zza3);
                    ((zzcdr)object).zzug();
                    ((zzcds)object).zzwh();
                    try (Cursor cursor = null;){
                        String[] stringArray;
                        String string3;
                        String string4;
                        String string5;
                        String[] stringArray2;
                        SQLiteDatabase sQLiteDatabase = ((zzcaw)object).getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            stringArray2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string5 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string5).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string5).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block68;
                            string2 = cursor.getString(0);
                            string4 = cursor.getString(1);
                            cursor.close();
                        } else {
                            stringArray2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string5 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string5).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string5).append(" order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block68;
                            string4 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string2, string4}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            ((zzcdr)object).zzauk().zzayc().zzj("Raw event metadata record is missing. appId", zzcbu.zzjf(string2));
                            break block68;
                        }
                        byte[] byArray = cursor.getBlob(0);
                        string5 = zzegq.zzh((byte[])byArray, (int)0, (int)byArray.length);
                        zzcgi zzcgi2 = new zzcgi();
                        try {
                            zzcgi2.zza((zzegq)string5);
                        }
                        catch (IOException iOException) {
                            ((zzcdr)object).zzauk().zzayc().zze("Data loss. Failed to merge raw event metadata. appId", zzcbu.zzjf(string2), iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block68;
                        }
                        if (cursor.moveToNext()) {
                            ((zzcdr)object).zzauk().zzaye().zzj("Get multiple raw event metadata records, expected one. appId", zzcbu.zzjf(string2));
                        }
                        cursor.close();
                        zza3.zzb(zzcgi2);
                        if (l2 != -1L) {
                            string3 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{string2, string4, String.valueOf(l2)};
                        } else {
                            string3 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{string2, string4};
                        }
                        cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string3, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            ((zzcdr)object).zzauk().zzaye().zzj("Raw event data disappeared while in transaction. appId", zzcbu.zzjf(string2));
                            break block68;
                        }
                        do {
                            long l4 = cursor.getLong(0);
                            byArray = cursor.getBlob(3);
                            string5 = zzegq.zzh((byte[])byArray, (int)0, (int)byArray.length);
                            zzcgf zzcgf2 = new zzcgf();
                            try {
                                zzcgf2.zza((zzegq)string5);
                            }
                            catch (IOException iOException) {
                                ((zzcdr)object).zzauk().zzayc().zze("Data loss. Failed to merge raw event. appId", zzcbu.zzjf(string2), iOException);
                                continue;
                            }
                            zzcgf2.name = cursor.getString(1);
                            zzcgf2.zziyt = cursor.getLong(2);
                            if (!zza3.zza(l4, zzcgf2)) break;
                        } while (cursor.moveToNext());
                    }
                }
                object = zza2;
                if (((zza)object).zzaom == null || ((zza)object).zzaom.isEmpty()) break block69;
                boolean bl = false;
                zzcgi zzcgi3 = zza2.zzitv;
                zza2.zzitv.zziza = new zzcgf[zza2.zzaom.size()];
                int n2 = 0;
                for (n = 0; n < zza2.zzaom.size(); ++n) {
                    block71: {
                        zzcgg[] zzcggArray;
                        int n3;
                        boolean bl2;
                        boolean bl3;
                        block70: {
                            bl3 = bl;
                            if (this.zzauh().zzaq(zza2.zzitv.zzch, zza2.zzaom.get((int)n).name)) {
                                this.zzauk().zzaye().zze("Dropping blacklisted raw event. appId", zzcbu.zzjf(zza2.zzitv.zzch), this.zzauf().zzjc(zza2.zzaom.get((int)n).name));
                                if (this.zzaug().zzkg(zza2.zzitv.zzch) || this.zzaug().zzkh(zza2.zzitv.zzch) || "_err".equals(zza2.zzaom.get((int)n).name)) continue;
                                this.zzaug().zza(zza2.zzitv.zzch, 11, "_ev", zza2.zzaom.get((int)n).name, 0);
                                continue;
                            }
                            bl2 = this.zzauh().zzar(zza2.zzitv.zzch, zza2.zzaom.get((int)n).name);
                            if (bl2) break block70;
                            this.zzaug();
                            if (!zzcfu.zzki(zza2.zzaom.get((int)n).name)) break block71;
                        }
                        boolean bl4 = false;
                        boolean bl5 = false;
                        if (zza2.zzaom.get((int)n).zziys == null) {
                            zza2.zzaom.get((int)n).zziys = new zzcgg[0];
                        }
                        zzcgg[] zzcggArray2 = zza2.zzaom.get((int)n).zziys;
                        int n4 = zza2.zzaom.get((int)n).zziys.length;
                        for (n3 = 0; n3 < n4; ++n3) {
                            zzcggArray = zzcggArray2[n3];
                            if ("_c".equals(zzcggArray.name)) {
                                zzcggArray.zziyw = 1L;
                                bl4 = true;
                                continue;
                            }
                            if (!"_r".equals(zzcggArray.name)) continue;
                            zzcggArray.zziyw = 1L;
                            bl5 = true;
                        }
                        if (!bl4 && bl2) {
                            this.zzauk().zzayi().zzj("Marking event as conversion", this.zzauf().zzjc(zza2.zzaom.get((int)n).name));
                            zzcggArray2 = Arrays.copyOf(zza2.zzaom.get((int)n).zziys, zza2.zzaom.get((int)n).zziys.length + 1);
                            zzcgg zzcgg2 = new zzcgg();
                            new zzcgg().name = "_c";
                            zzcgg2.zziyw = 1L;
                            zzcggArray2[zzcggArray2.length - 1] = zzcgg2;
                            zza2.zzaom.get((int)n).zziys = zzcggArray2;
                        }
                        if (!bl5) {
                            this.zzauk().zzayi().zzj("Marking event as real-time", this.zzauf().zzjc(zza2.zzaom.get((int)n).name));
                            zzcggArray2 = Arrays.copyOf(zza2.zzaom.get((int)n).zziys, zza2.zzaom.get((int)n).zziys.length + 1);
                            zzcgg zzcgg3 = new zzcgg();
                            new zzcgg().name = "_r";
                            zzcgg3.zziyw = 1L;
                            zzcggArray2[zzcggArray2.length - 1] = zzcgg3;
                            zza2.zzaom.get((int)n).zziys = zzcggArray2;
                        }
                        bl = true;
                        if (this.zzaue().zza((long)this.zzaze(), (String)zza2.zzitv.zzch, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzimv > (long)this.zzisj.zzis(zza2.zzitv.zzch)) {
                            zzcgf zzcgf3 = zza2.zzaom.get(n);
                            for (n3 = 0; n3 < zzcgf3.zziys.length; ++n3) {
                                if (!"_r".equals(zzcgf3.zziys[n3].name)) continue;
                                zzcggArray = new zzcgg[zzcgf3.zziys.length - 1];
                                if (n3 > 0) {
                                    System.arraycopy(zzcgf3.zziys, 0, zzcggArray, 0, n3);
                                }
                                if (n3 < zzcggArray.length) {
                                    System.arraycopy(zzcgf3.zziys, n3 + 1, zzcggArray, n3, zzcggArray.length - n3);
                                }
                                zzcgf3.zziys = zzcggArray;
                                break;
                            }
                            bl = bl3;
                        }
                        if (zzcfu.zzju(zza2.zzaom.get((int)n).name) && bl2 && this.zzaue().zza((long)this.zzaze(), (String)zza2.zzitv.zzch, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzimt > (long)this.zzisj.zzb(string2 = zza2.zzitv.zzch, zzcbk.zziof)) {
                            this.zzauk().zzaye().zzj("Too many conversions. Not logging as conversion. appId", zzcbu.zzjf(zza2.zzitv.zzch));
                            zzcgf zzcgf4 = zza2.zzaom.get(n);
                            boolean bl6 = false;
                            zzcgg zzcgg4 = null;
                            zzcgg[] zzcggArray3 = zzcgf4.zziys;
                            int n5 = zzcgf4.zziys.length;
                            for (int i = 0; i < n5; ++i) {
                                zzcgg zzcgg5 = zzcggArray3[i];
                                if ("_c".equals(zzcgg5.name)) {
                                    zzcgg4 = zzcgg5;
                                    continue;
                                }
                                if (!"_err".equals(zzcgg5.name)) continue;
                                bl6 = true;
                            }
                            if (bl6 && zzcgg4 != null) {
                                zzcggArray3 = new zzcgg[zzcgf4.zziys.length - 1];
                                n5 = 0;
                                zzcgg[] zzcggArray4 = zzcgf4.zziys;
                                int n6 = zzcgf4.zziys.length;
                                for (int i = 0; i < n6; ++i) {
                                    zzcgg zzcgg6 = zzcggArray4[i];
                                    if (zzcgg6 == zzcgg4) continue;
                                    zzcggArray3[n5++] = zzcgg6;
                                }
                                zzcgf4.zziys = zzcggArray3;
                            } else if (zzcgg4 != null) {
                                zzcgg4.name = "_err";
                                zzcgg4.zziyw = 10L;
                            } else {
                                this.zzauk().zzayc().zzj("Did not find conversion parameter. appId", zzcbu.zzjf(zza2.zzitv.zzch));
                            }
                        }
                    }
                    zzcgi3.zziza[n2++] = zza2.zzaom.get(n);
                }
                if (n2 < zza2.zzaom.size()) {
                    zzcgi3.zziza = Arrays.copyOf(zzcgi3.zziza, n2);
                }
                zzcgi3.zzizt = this.zza(zza2.zzitv.zzch, zza2.zzitv.zzizb, zzcgi3.zziza);
                zzcgi3.zzizd = Long.MAX_VALUE;
                zzcgi3.zzize = Long.MIN_VALUE;
                for (n = 0; n < zzcgi3.zziza.length; ++n) {
                    zzcgf zzcgf5 = zzcgi3.zziza[n];
                    if (zzcgf5.zziyt < zzcgi3.zzizd) {
                        zzcgi3.zzizd = zzcgf5.zziyt;
                    }
                    if (zzcgf5.zziyt <= zzcgi3.zzize) continue;
                    zzcgi3.zzize = zzcgf5.zziyt;
                }
                String string6 = zza2.zzitv.zzch;
                zzcap zzcap2 = this.zzaue().zziw(string6);
                if (zzcap2 == null) {
                    this.zzauk().zzayc().zzj("Bundling raw events w/o app info. appId", zzcbu.zzjf(zza2.zzitv.zzch));
                } else if (zzcgi3.zziza.length > 0) {
                    long l5 = zzcap2.zzaur();
                    zzcgi3.zzizg = l5 != 0L ? Long.valueOf(l5) : null;
                    long l6 = zzcap2.zzauq();
                    if (l6 == 0L) {
                        l6 = l5;
                    }
                    zzcgi3.zzizf = l6 != 0L ? Long.valueOf(l6) : null;
                    zzcap2.zzava();
                    zzcgi3.zzizr = (int)zzcap2.zzaux();
                    zzcap2.zzal(zzcgi3.zzizd);
                    zzcap2.zzam(zzcgi3.zzize);
                    zzcgi3.zzilr = zzcap2.zzavi();
                    this.zzaue().zza(zzcap2);
                }
                if (zzcgi3.zziza.length > 0) {
                    zzcav.zzawj();
                    zzcgc zzcgc2 = this.zzauh().zzjn(zza2.zzitv.zzch);
                    if (zzcgc2 == null || zzcgc2.zziyh == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zzitv.zziln)) {
                            zzcgi3.zzizx = -1L;
                        } else {
                            this.zzauk().zzaye().zzj("Did not find measurement config or missing version info. appId", zzcbu.zzjf(zza2.zzitv.zzch));
                        }
                    } else {
                        zzcgi3.zzizx = zzcgc2.zziyh;
                    }
                    this.zzaue().zza(zzcgi3, bl);
                }
                this.zzaue().zzae(zza2.zzitw);
                string2 = string6;
                object = this.zzaue();
                SQLiteDatabase sQLiteDatabase = ((zzcaw)object).getWritableDatabase();
                try {
                    sQLiteDatabase.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{string2, string2});
                }
                catch (SQLiteException sQLiteException) {
                    ((zzcdr)object).zzauk().zzayc().zze("Failed to remove unused event metadata. appId", zzcbu.zzjf(string2), (Object)sQLiteException);
                }
                this.zzaue().setTransactionSuccessful();
                boolean bl7 = zzcgi3.zziza.length > 0;
                return bl7;
            }
            this.zzaue().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzaue().endTransaction();
        }
    }

    private final zzcge[] zza(String string, zzcgk[] zzcgkArray, zzcgf[] zzcgfArray) {
        zzbp.zzgf((String)string);
        return this.zzatx().zza(string, zzcgfArray, zzcgkArray);
    }

    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        ((zzcdr)this.zzauj()).zzug();
        this.zzwh();
        zzbp.zzgf((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzauk().zzayi().zzj("onConfigFetched. Response size", byArray.length);
            this.zzaue().beginTransaction();
            try {
                boolean bl;
                zzcap zzcap2 = this.zzaue().zziw(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzcap2 == null) {
                    this.zzauk().zzaye().zzj("App does not exist in onConfigFetched. appId", zzcbu.zzjf(string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzauh().zzjn(string) == null && !this.zzauh().zzb(string, null, null) : !this.zzauh().zzb(string, byArray, string2)) {
                        return;
                    }
                    zzcap2.zzar(this.zzasl.currentTimeMillis());
                    this.zzaue().zza(zzcap2);
                    if (n == 404) {
                        this.zzauk().zzayf().zzj("Config not found. Using empty config. appId", string);
                    } else {
                        this.zzauk().zzayi().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                    }
                    if (this.zzayz().zzyu() && this.zzazg()) {
                        this.zzazf();
                    } else {
                        this.zzazh();
                    }
                } else {
                    zzcap2.zzas(this.zzasl.currentTimeMillis());
                    this.zzaue().zza(zzcap2);
                    this.zzauk().zzayi().zze("Fetching config failed. code, error", n, throwable);
                    this.zzauh().zzjp(string);
                    this.zzaul().zziqh.set(this.zzasl.currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzaul().zziqi.set(this.zzasl.currentTimeMillis());
                    }
                    this.zzazh();
                }
                this.zzaue().setTransactionSuccessful();
            }
            finally {
                this.zzaue().endTransaction();
            }
            return;
        }
        finally {
            this.zzitq = false;
            this.zzazl();
        }
    }

    @WorkerThread
    protected final void zza(int n, Throwable throwable, byte[] byArray) {
        ((zzcdr)this.zzauj()).zzug();
        this.zzwh();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzitk;
            this.zzitk = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzaul().zziqg.set(this.zzasl.currentTimeMillis());
                    this.zzaul().zziqh.set(0L);
                    this.zzazh();
                    this.zzauk().zzayi().zze("Successful upload. Got network response. code, size", n, byArray.length);
                    this.zzaue().beginTransaction();
                    try {
                        for (Long l : list) {
                            long l2 = l;
                            zzcaw zzcaw2 = this.zzaue();
                            zzcaw2.zzug();
                            zzcaw2.zzwh();
                            SQLiteDatabase sQLiteDatabase = zzcaw2.getWritableDatabase();
                            String[] stringArray = new String[]{String.valueOf(l2)};
                            try {
                                if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                throw new SQLiteException("Deleted fewer rows from queue than expected");
                            }
                            catch (SQLiteException sQLiteException) {
                                zzcaw2.zzauk().zzayc().zzj("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                throw sQLiteException;
                            }
                        }
                        this.zzaue().setTransactionSuccessful();
                    }
                    finally {
                        this.zzaue().endTransaction();
                    }
                    if (this.zzayz().zzyu() && this.zzazg()) {
                        this.zzazf();
                    } else {
                        this.zzito = -1L;
                        this.zzazh();
                    }
                    this.zzitp = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzauk().zzayc().zzj("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzitp = this.zzasl.elapsedRealtime();
                    this.zzauk().zzayi().zzj("Disable upload, time", this.zzitp);
                }
            } else {
                this.zzauk().zzayi().zze("Network upload failed. Will retry later. code, error", n, throwable);
                this.zzaul().zziqh.set(this.zzasl.currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzaul().zziqi.set(this.zzasl.currentTimeMillis());
                }
                this.zzazh();
            }
            return;
        }
        finally {
            this.zzitr = false;
            this.zzazl();
        }
    }

    private final boolean zzazg() {
        ((zzcdr)this.zzauj()).zzug();
        this.zzwh();
        return this.zzaue().zzaxm() || !TextUtils.isEmpty((CharSequence)this.zzaue().zzaxh());
    }

    @WorkerThread
    private final void zzazh() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            ((zzcdr)this.zzauj()).zzug();
            this.zzwh();
            if (!this.zzazk()) {
                return;
            }
            if (this.zzitp > 0L) {
                l3 = this.zzasl.elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzitp);
                if (l2 > 0L) {
                    this.zzauk().zzayi().zzj("Upload has been suspended. Will update scheduling later in approximately ms", l2);
                    this.zzaza().unregister();
                    this.zzazb().cancel();
                    return;
                }
                this.zzitp = 0L;
            }
            if (!this.zzayu() || !this.zzazg()) {
                this.zzauk().zzayi().log("Nothing to upload or uploading impossible");
                this.zzaza().unregister();
                this.zzazb().cancel();
                return;
            }
            zzccu zzccu2 = this;
            long l4 = zzccu2.zzasl.currentTimeMillis();
            long l5 = zzcav.zzaxc();
            boolean bl = zzccu2.zzaue().zzaxn() || zzccu2.zzaue().zzaxi();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzccu2.zzisj.zzaxf())) && !".none.".equals(string) ? zzcav.zzawy() : zzcav.zzawx()) : zzcav.zzaww();
            long l7 = zzccu2.zzaul().zziqg.get();
            long l8 = zzccu2.zzaul().zziqh.get();
            long l9 = zzccu2.zzaue().zzaxk();
            long l10 = zzccu2.zzaue().zzaxl();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzccu2.zzaug().zzf(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < zzcav.zzaxe(); ++i) {
                        long l15 = 1 << i;
                        if ((l14 += zzcav.zzaxd() * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzauk().zzayi().log("Next upload time is 0");
            this.zzaza().unregister();
            this.zzazb().cancel();
            return;
        }
        if (!this.zzayz().zzyu()) {
            this.zzauk().zzayi().log("No network");
            this.zzaza().zzyr();
            this.zzazb().cancel();
            return;
        }
        l2 = this.zzaul().zziqi.get();
        long l16 = zzcav.zzawv();
        if (!this.zzaug().zzf(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzaza().unregister();
        long l17 = l3 - this.zzasl.currentTimeMillis();
        if (l17 <= 0L) {
            l17 = zzcav.zzawz();
            this.zzaul().zziqg.set(this.zzasl.currentTimeMillis());
        }
        this.zzauk().zzayi().zzj("Upload scheduled in approximately ms", l17);
        this.zzazb().zzs(l17);
    }

    public final void zzbo(boolean bl) {
        this.zzazh();
    }

    final void zzb(zzcds zzcds2) {
        ++this.zzitm;
    }

    final void zzazi() {
        ++this.zzitn;
    }

    @WorkerThread
    public final void zze(zzcaq zzcaq2) {
        int n;
        ((zzcdr)this.zzauj()).zzug();
        this.zzwh();
        zzbp.zzu((Object)((Object)zzcaq2));
        zzbp.zzgf((String)zzcaq2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzcaq2.zziln)) {
            return;
        }
        zzcap zzcap2 = this.zzaue().zziw(zzcaq2.packageName);
        if (zzcap2 != null && TextUtils.isEmpty((CharSequence)zzcap2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzcaq2.zziln)) {
            zzcap2.zzar(0L);
            this.zzaue().zza(zzcap2);
            this.zzauh().zzjq(zzcaq2.packageName);
        }
        if (!zzcaq2.zzils) {
            this.zzf(zzcaq2);
            return;
        }
        long l = zzcaq2.zzilx;
        if (l == 0L) {
            l = this.zzasl.currentTimeMillis();
        }
        if ((n = zzcaq2.zzily) != 0 && n != 1) {
            this.zzauk().zzaye().zze("Incorrect app type, assuming installed app. appId, appType", zzcbu.zzjf(zzcaq2.packageName), n);
            n = 0;
        }
        this.zzaue().beginTransaction();
        try {
            zzcbi zzcbi2;
            Object object;
            long l2 = l;
            zzcaq zzcaq3 = zzcaq2;
            zzccu zzccu2 = this;
            zzcap zzcap3 = zzccu2.zzaue().zziw(zzcaq3.packageName);
            if (zzcap3 != null && zzcap3.getGmpAppId() != null && !zzcap3.getGmpAppId().equals(zzcaq3.zziln)) {
                zzccu2.zzauk().zzaye().zzj("New GMP App Id passed in. Removing cached database data. appId", zzcbu.zzjf(zzcap3.getAppId()));
                String string = zzcap3.getAppId();
                zzcaw zzcaw2 = zzccu2.zzaue();
                zzcaw2.zzwh();
                zzcaw2.zzug();
                zzbp.zzgf((String)string);
                try {
                    SQLiteDatabase sQLiteDatabase = zzcaw2.getWritableDatabase();
                    String[] stringArray = new String[]{string};
                    int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                    if (n2 > 0) {
                        zzcaw2.zzauk().zzayi().zze("Deleted application data. app, records", string, n2);
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzcaw2.zzauk().zzayc().zze("Error deleting application data. appId, error", zzcbu.zzjf(string), (Object)sQLiteException);
                }
                zzcap3 = null;
            }
            if (zzcap3 != null && zzcap3.zzul() != null && !zzcap3.zzul().equals(zzcaq3.zzhtl)) {
                object = new Bundle();
                object.putString("_pv", zzcap3.zzul());
                zzcbi2 = new zzcbi("_au", new zzcbf((Bundle)object), "auto", l2);
                zzccu2.zzb(zzcbi2, zzcaq3);
            }
            this.zzf(zzcaq2);
            zzcbe zzcbe2 = null;
            if (n == 0) {
                zzcbe2 = this.zzaue().zzah(zzcaq2.packageName, "_f");
            } else if (n == 1) {
                zzcbe2 = this.zzaue().zzah(zzcaq2.packageName, "_v");
            }
            if (zzcbe2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzbcc zzbcc2;
                    zzcfr zzcfr2 = new zzcfr("_fot", l, l3, "auto");
                    this.zzb(zzcfr2, zzcaq2);
                    l2 = l;
                    zzcaq3 = zzcaq2;
                    zzccu2 = this;
                    ((zzcdr)zzccu2.zzauj()).zzug();
                    zzccu2.zzwh();
                    zzcap3 = new Bundle();
                    zzcap3.putLong("_c", 1L);
                    zzcap3.putLong("_r", 1L);
                    zzcap3.putLong("_uwa", 0L);
                    zzcap3.putLong("_pfo", 0L);
                    zzcap3.putLong("_sys", 0L);
                    zzcap3.putLong("_sysu", 0L);
                    if (zzccu2.mContext.getPackageManager() == null) {
                        zzccu2.zzauk().zzayc().zzj("PackageManager is null, first open report might be inaccurate. appId", zzcbu.zzjf(zzcaq3.packageName));
                    } else {
                        zzcbi2 = null;
                        try {
                            zzcbi2 = zzbdv.zzcs((Context)zzccu2.mContext).getPackageInfo(zzcaq3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzccu2.zzauk().zzayc().zze("Package info is null, first open report might be inaccurate. appId", zzcbu.zzjf(zzcaq3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzcbi2 != null && ((PackageInfo)zzcbi2).firstInstallTime != 0L) {
                            boolean bl = false;
                            if (((PackageInfo)zzcbi2).firstInstallTime != ((PackageInfo)zzcbi2).lastUpdateTime) {
                                zzcap3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            zzbcc2 = new zzcfr("_fi", l2, bl ? 1L : 0L, "auto");
                            zzccu2.zzb((zzcfr)zzbcc2, zzcaq3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = zzbdv.zzcs((Context)zzccu2.mContext).getApplicationInfo(zzcaq3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzccu2.zzauk().zzayc().zze("Application info is null, first open report might be inaccurate. appId", zzcbu.zzjf(zzcaq3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzcap3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzcap3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzcaq3.packageName;
                    zzcaw zzcaw3 = zzccu2.zzaue();
                    zzbp.zzgf((String)string);
                    zzcaw3.zzug();
                    zzcaw3.zzwh();
                    long l4 = zzcaw3.zzao(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzcap3.putLong("_pfo", l4);
                    }
                    zzbcc2 = new zzcbi("_f", new zzcbf((Bundle)zzcap3), "auto", l2);
                    zzccu2.zzb((zzcbi)zzbcc2, zzcaq3);
                } else if (n == 1) {
                    zzcfr zzcfr3 = new zzcfr("_fvt", l, l3, "auto");
                    this.zzb(zzcfr3, zzcaq2);
                    l2 = l;
                    zzcaq3 = zzcaq2;
                    zzccu2 = this;
                    ((zzcdr)zzccu2.zzauj()).zzug();
                    zzccu2.zzwh();
                    zzcap3 = new Bundle();
                    zzcap3.putLong("_c", 1L);
                    zzcap3.putLong("_r", 1L);
                    object = new zzcbi("_v", new zzcbf((Bundle)zzcap3), "auto", l2);
                    zzccu2.zzb((zzcbi)((Object)object), zzcaq3);
                }
                l2 = l;
                zzcaq3 = zzcaq2;
                zzccu2 = this;
                zzcap3 = new Bundle();
                zzcap3.putLong("_et", 1L);
                object = new zzcbi("_e", new zzcbf((Bundle)zzcap3), "auto", l2);
                zzccu2.zzb((zzcbi)((Object)object), zzcaq3);
            } else if (zzcaq2.zzilt) {
                l2 = l;
                zzcaq3 = zzcaq2;
                zzccu2 = this;
                zzcap3 = new Bundle();
                object = new zzcbi("_cd", new zzcbf((Bundle)zzcap3), "auto", l2);
                zzccu2.zzb((zzcbi)((Object)object), zzcaq3);
            }
            this.zzaue().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzaue().endTransaction();
        }
    }

    @WorkerThread
    private final void zzf(zzcaq zzcaq2) {
        ((zzcdr)this.zzauj()).zzug();
        this.zzwh();
        zzbp.zzu((Object)((Object)zzcaq2));
        zzbp.zzgf((String)zzcaq2.packageName);
        zzcap zzcap2 = this.zzaue().zziw(zzcaq2.packageName);
        String string = this.zzaul().zzji(zzcaq2.packageName);
        boolean bl = false;
        if (zzcap2 == null) {
            zzcap2 = new zzcap(this, zzcaq2.packageName);
            zzcap2.zzim(this.zzatz().zzaxz());
            zzcap2.zzio(string);
            bl = true;
        } else if (!string.equals(zzcap2.zzauo())) {
            zzcap2.zzio(string);
            zzcap2.zzim(this.zzatz().zzaxz());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcaq2.zziln) && !zzcaq2.zziln.equals(zzcap2.getGmpAppId())) {
            zzcap2.zzin(zzcaq2.zziln);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcaq2.zzilv) && !zzcaq2.zzilv.equals(zzcap2.zzaup())) {
            zzcap2.zzip(zzcaq2.zzilv);
            bl = true;
        }
        if (zzcaq2.zzilp != 0L && zzcaq2.zzilp != zzcap2.zzauu()) {
            zzcap2.zzao(zzcaq2.zzilp);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcaq2.zzhtl) && !zzcaq2.zzhtl.equals(zzcap2.zzul())) {
            zzcap2.setAppVersion(zzcaq2.zzhtl);
            bl = true;
        }
        if (zzcaq2.zzilu != zzcap2.zzaus()) {
            zzcap2.zzan(zzcaq2.zzilu);
            bl = true;
        }
        if (zzcaq2.zzilo != null && !zzcaq2.zzilo.equals(zzcap2.zzaut())) {
            zzcap2.zziq(zzcaq2.zzilo);
            bl = true;
        }
        if (zzcaq2.zzilq != zzcap2.zzauv()) {
            zzcap2.zzap(zzcaq2.zzilq);
            bl = true;
        }
        if (zzcaq2.zzils != zzcap2.zzauw()) {
            zzcap2.setMeasurementEnabled(zzcaq2.zzils);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcaq2.zzilr) && !zzcaq2.zzilr.equals(zzcap2.zzavh())) {
            zzcap2.zzir(zzcaq2.zzilr);
            bl = true;
        }
        if (zzcaq2.zzilw != zzcap2.zzavj()) {
            zzcap2.zzaz(zzcaq2.zzilw);
            bl = true;
        }
        if (bl) {
            this.zzaue().zza(zzcap2);
        }
    }

    @WorkerThread
    final void zzazj() {
        ((zzcdr)this.zzauj()).zzug();
        this.zzwh();
        if (!this.zzitf) {
            this.zzauk().zzayg().log("This instance being marked as an uploader");
            zzccu zzccu2 = this;
            ((zzcdr)zzccu2.zzauj()).zzug();
            zzccu2.zzwh();
            if (zzccu2.zzazk() && zzccu2.zzazc()) {
                int n;
                int n2 = zzccu2.zza(zzccu2.zzitj);
                int n3 = n = zzccu2.zzatz().zzaya();
                int n4 = n2;
                zzccu zzccu3 = zzccu2;
                ((zzcdr)zzccu3.zzauj()).zzug();
                if (n4 > n3) {
                    zzccu3.zzauk().zzayc().zze("Panic: can't downgrade version. Previous, current version", n4, n3);
                } else if (n4 < n3) {
                    if (zzccu3.zza(n3, zzccu3.zzitj)) {
                        zzccu3.zzauk().zzayi().zze("Storage version upgraded. Previous, current version", n4, n3);
                    } else {
                        zzccu3.zzauk().zzayc().zze("Storage version upgrade failed. Previous, current version", n4, n3);
                    }
                }
            }
            this.zzitf = true;
            this.zzazh();
        }
    }

    @WorkerThread
    private final boolean zzazk() {
        ((zzcdr)this.zzauj()).zzug();
        this.zzwh();
        return this.zzitf;
    }

    @WorkerThread
    final void zzi(Runnable runnable) {
        ((zzcdr)this.zzauj()).zzug();
        if (this.zzitl == null) {
            this.zzitl = new ArrayList<Runnable>();
        }
        this.zzitl.add(runnable);
    }

    @WorkerThread
    private final void zzazl() {
        ((zzcdr)this.zzauj()).zzug();
        if (this.zzitq || this.zzitr || this.zzits) {
            this.zzauk().zzayi().zzd("Not stopping services. fetch, network, upload", this.zzitq, this.zzitr, this.zzits);
            return;
        }
        this.zzauk().zzayi().log("Stopping uploading service(s)");
        if (this.zzitl == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzitl.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzitl.clear();
    }

    final class zza
    implements zzcay {
        zzcgi zzitv;
        List<Long> zzitw;
        List<zzcgf> zzaom;
        private long zzitx;
        private /* synthetic */ zzccu zzitu;

        private zza(zzccu zzccu2) {
            this.zzitu = zzccu2;
        }

        @Override
        public final void zzb(zzcgi zzcgi2) {
            zzbp.zzu((Object)((Object)zzcgi2));
            this.zzitv = zzcgi2;
        }

        @Override
        public final boolean zza(long l, zzcgf zzcgf2) {
            zzbp.zzu((Object)((Object)zzcgf2));
            if (this.zzaom == null) {
                this.zzaom = new ArrayList<zzcgf>();
            }
            if (this.zzitw == null) {
                this.zzitw = new ArrayList<Long>();
            }
            if (this.zzaom.size() > 0 && zza.zza(this.zzaom.get(0)) != zza.zza(zzcgf2)) {
                return false;
            }
            long l2 = this.zzitx + (long)zzcgf2.zzbjo();
            if (l2 >= (long)zzcav.zzawq()) {
                return false;
            }
            this.zzitx = l2;
            this.zzaom.add(zzcgf2);
            this.zzitw.add(l);
            return this.zzaom.size() < zzcav.zzawr();
        }

        private static long zza(zzcgf zzcgf2) {
            return zzcgf2.zziyt / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzccu zzccu2, zzccv zzccv2) {
            this(zzccu2);
        }
    }
}

