/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbcc;
import com.google.android.gms.internal.zzcat;
import com.google.android.gms.internal.zzcav;
import com.google.android.gms.internal.zzcba;
import com.google.android.gms.internal.zzcbi;
import com.google.android.gms.internal.zzcbm;
import com.google.android.gms.internal.zzccu;
import com.google.android.gms.internal.zzcdr;
import com.google.android.gms.internal.zzcds;
import com.google.android.gms.internal.zzcen;
import com.google.android.gms.internal.zzceo;
import com.google.android.gms.internal.zzcep;
import com.google.android.gms.internal.zzceq;
import com.google.android.gms.internal.zzcer;
import com.google.android.gms.internal.zzces;
import com.google.android.gms.internal.zzcet;
import com.google.android.gms.internal.zzceu;
import com.google.android.gms.internal.zzcev;
import com.google.android.gms.internal.zzcew;
import com.google.android.gms.internal.zzcex;
import com.google.android.gms.internal.zzcey;
import com.google.android.gms.internal.zzcez;
import com.google.android.gms.internal.zzcfo;
import com.google.android.gms.internal.zzcfr;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class zzcem
extends zzcds {
    private final zzcez zzivp;
    private zzcbm zzivq;
    private Boolean zzivr;
    private final zzcba zzivs;
    private final zzcfo zzivt;
    private final List<Runnable> zzivu = new ArrayList<Runnable>();
    private final zzcba zzivv;

    protected zzcem(zzccu zzccu2) {
        super(zzccu2);
        this.zzivt = new zzcfo(zzccu2.zzvu());
        this.zzivp = new zzcez(this);
        this.zzivs = new zzcen(this, zzccu2);
        this.zzivv = new zzcer(this, zzccu2);
    }

    @Override
    protected final void zzuh() {
    }

    @WorkerThread
    public final boolean isConnected() {
        ((zzcdr)this).zzug();
        this.zzwh();
        return this.zzivq != null;
    }

    @WorkerThread
    protected final void zzazo() {
        ((zzcdr)this).zzug();
        this.zzwh();
        this.zzj(new zzces(this));
    }

    @WorkerThread
    final void zza(zzcbm zzcbm2, zzbcc zzbcc2) {
        ((zzcdr)this).zzug();
        ((zzcdr)this).zzatu();
        this.zzwh();
        zzcav.zzawj();
        ArrayList<zzbcc> arrayList = new ArrayList<zzbcc>();
        int n = 100;
        zzcav.zzaws();
        for (int i = 0; i < 1001 && n == 100; ++i) {
            n = 0;
            List<zzbcc> list = ((zzcdr)this).zzaud().zzdv(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (zzbcc2 != null && n < 100) {
                arrayList.add(zzbcc2);
            }
            ArrayList<zzbcc> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                zzbcc zzbcc3 = (zzbcc)e;
                if (zzbcc3 instanceof zzcbi) {
                    try {
                        zzcbm2.zza((zzcbi)zzbcc3, ((zzcdr)this).zzatz().zzjb(((zzcdr)this).zzauk().zzayj()));
                    }
                    catch (RemoteException remoteException) {
                        ((zzcdr)this).zzauk().zzayc().zzj("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zzbcc3 instanceof zzcfr) {
                    try {
                        zzcbm2.zza((zzcfr)zzbcc3, ((zzcdr)this).zzatz().zzjb(((zzcdr)this).zzauk().zzayj()));
                    }
                    catch (RemoteException remoteException) {
                        ((zzcdr)this).zzauk().zzayc().zzj("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zzbcc3 instanceof zzcat) {
                    try {
                        zzcbm2.zza((zzcat)zzbcc3, ((zzcdr)this).zzatz().zzjb(((zzcdr)this).zzauk().zzayj()));
                    }
                    catch (RemoteException remoteException) {
                        ((zzcdr)this).zzauk().zzayc().zzj("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzcdr)this).zzauk().zzayc().log("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zzc(zzcbi zzcbi2, String string) {
        zzbp.zzu((Object)((Object)zzcbi2));
        ((zzcdr)this).zzug();
        this.zzwh();
        zzcav.zzawj();
        boolean bl = ((zzcdr)this).zzaud().zza(zzcbi2);
        this.zzj(new zzcet(this, true, bl, zzcbi2, string));
    }

    @WorkerThread
    protected final void zzf(zzcat zzcat2) {
        zzbp.zzu((Object)((Object)zzcat2));
        ((zzcdr)this).zzug();
        this.zzwh();
        zzcav.zzawj();
        boolean bl = ((zzcdr)this).zzaud().zzc(zzcat2);
        zzcat zzcat3 = new zzcat(zzcat2);
        this.zzj(new zzceu(this, true, bl, zzcat3, zzcat2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcat>> atomicReference, String string, String string2, String string3) {
        ((zzcdr)this).zzug();
        this.zzwh();
        this.zzj(new zzcev(this, atomicReference, string, string2, string3));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcfr>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzcdr)this).zzug();
        this.zzwh();
        this.zzj(new zzcew(this, atomicReference, string, string2, string3, bl));
    }

    @WorkerThread
    protected final void zzb(zzcfr zzcfr2) {
        ((zzcdr)this).zzug();
        this.zzwh();
        zzcav.zzawj();
        boolean bl = ((zzcdr)this).zzaud().zza(zzcfr2);
        this.zzj(new zzcex(this, bl, zzcfr2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcfr>> atomicReference, boolean bl) {
        ((zzcdr)this).zzug();
        this.zzwh();
        this.zzj(new zzcey(this, atomicReference, bl));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzcdr)this).zzug();
        this.zzwh();
        this.zzj(new zzceo(this, atomicReference));
    }

    @WorkerThread
    protected final void zzazp() {
        ((zzcdr)this).zzug();
        this.zzwh();
        this.zzj(new zzcep(this));
    }

    @WorkerThread
    protected final void zza(AppMeasurement.zzb zzb2) {
        ((zzcdr)this).zzug();
        this.zzwh();
        this.zzj(new zzceq(this, zzb2));
    }

    @WorkerThread
    private final void zzwt() {
        ((zzcdr)this).zzug();
        this.zzivt.start();
        this.zzivs.zzs(zzcav.zzawg());
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzxe() {
        zzcem zzcem2;
        block11: {
            boolean bl;
            block12: {
                ((zzcdr)this).zzug();
                this.zzwh();
                if (this.isConnected()) {
                    return;
                }
                if (this.zzivr != null) break block11;
                this.zzivr = ((zzcdr)this).zzaul().zzayn();
                if (this.zzivr != null) break block11;
                ((zzcdr)this).zzauk().zzayi().log("State of service unknown");
                zzcem2 = this;
                ((zzcdr)zzcem2).zzug();
                zzcem2.zzwh();
                zzcav.zzawj();
                ((zzcdr)zzcem2).zzauk().zzayi().log("Checking service availability");
                switch (zze.zzaew().isGooglePlayServicesAvailable(((zzcdr)zzcem2).getContext())) {
                    case 0: {
                        ((zzcdr)zzcem2).zzauk().zzayi().log("Service available");
                        bl = true;
                        break block12;
                    }
                    case 1: {
                        ((zzcdr)zzcem2).zzauk().zzayi().log("Service missing");
                        break;
                    }
                    case 18: {
                        ((zzcdr)zzcem2).zzauk().zzaye().log("Service updating");
                        bl = true;
                        break block12;
                    }
                    case 2: {
                        ((zzcdr)zzcem2).zzauk().zzayh().log("Service container out of date");
                        bl = true;
                        break block12;
                    }
                    case 3: {
                        ((zzcdr)zzcem2).zzauk().zzaye().log("Service disabled");
                        break;
                    }
                    case 9: {
                        ((zzcdr)zzcem2).zzauk().zzaye().log("Service invalid");
                    }
                }
                bl = false;
            }
            this.zzivr = bl;
            ((zzcdr)this).zzaul().zzbm(this.zzivr);
        }
        if (this.zzivr.booleanValue()) {
            ((zzcdr)this).zzauk().zzayi().log("Using measurement service");
            this.zzivp.zzazr();
            return;
        }
        zzcem2 = this;
        zzcav.zzawj();
        PackageManager packageManager = ((zzcdr)zzcem2).getContext().getPackageManager();
        Intent intent = new Intent().setClassName(((zzcdr)zzcem2).getContext(), "com.google.android.gms.measurement.AppMeasurementService");
        List list = packageManager.queryIntentServices(intent, 65536);
        if (list != null && list.size() > 0) {
            ((zzcdr)this).zzauk().zzayi().log("Using local app measurement service");
            Intent intent2 = new Intent("com.google.android.gms.measurement.START");
            Context context = ((zzcdr)this).getContext();
            zzcav.zzawj();
            intent2.setComponent(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementService"));
            this.zzivp.zzk(intent2);
            return;
        }
        ((zzcdr)this).zzauk().zzayc().log("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
    }

    @WorkerThread
    protected final void zza(zzcbm zzcbm2) {
        ((zzcdr)this).zzug();
        zzbp.zzu((Object)zzcbm2);
        this.zzivq = zzcbm2;
        this.zzwt();
        this.zzazq();
    }

    @WorkerThread
    public final void disconnect() {
        ((zzcdr)this).zzug();
        this.zzwh();
        try {
            zza.zzaky();
            zzcez zzcez2 = this.zzivp;
            Context context = ((zzcdr)this).getContext();
            context.unbindService((ServiceConnection)zzcez2);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzivq = null;
    }

    @WorkerThread
    private final void onServiceDisconnected(ComponentName componentName) {
        ((zzcdr)this).zzug();
        if (this.zzivq != null) {
            this.zzivq = null;
            ((zzcdr)this).zzauk().zzayi().zzj("Disconnected from device MeasurementService", componentName);
            zzcem zzcem2 = this;
            ((zzcdr)zzcem2).zzug();
            zzcem2.zzxe();
        }
    }

    @WorkerThread
    private final void zzwu() {
        ((zzcdr)this).zzug();
        if (!this.isConnected()) {
            return;
        }
        ((zzcdr)this).zzauk().zzayi().log("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private final void zzj(Runnable runnable) throws IllegalStateException {
        ((zzcdr)this).zzug();
        if (this.isConnected()) {
            runnable.run();
            return;
        }
        if ((long)this.zzivu.size() >= zzcav.zzawo()) {
            ((zzcdr)this).zzauk().zzayc().log("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzivu.add(runnable);
        this.zzivv.zzs(60000L);
        this.zzxe();
    }

    @WorkerThread
    private final void zzazq() {
        ((zzcdr)this).zzug();
        ((zzcdr)this).zzauk().zzayi().zzj("Processing queued up service tasks", this.zzivu.size());
        for (Runnable runnable : this.zzivu) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                ((zzcdr)this).zzauk().zzayc().zzj("Task exception while flushing queue", throwable);
            }
        }
        this.zzivu.clear();
        this.zzivv.cancel();
    }

    static /* synthetic */ zzcez zza(zzcem zzcem2) {
        return zzcem2.zzivp;
    }

    static /* synthetic */ void zza(zzcem zzcem2, ComponentName componentName) {
        zzcem2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ zzcbm zza(zzcem zzcem2, zzcbm zzcbm2) {
        zzcem2.zzivq = null;
        return null;
    }

    static /* synthetic */ void zzb(zzcem zzcem2) {
        zzcem2.zzazq();
    }

    static /* synthetic */ void zzc(zzcem zzcem2) {
        zzcem2.zzwu();
    }

    static /* synthetic */ zzcbm zzd(zzcem zzcem2) {
        return zzcem2.zzivq;
    }

    static /* synthetic */ void zze(zzcem zzcem2) {
        zzcem2.zzwt();
    }
}

