/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.zzcax;
import com.google.android.gms.internal.zzcbm;
import com.google.android.gms.internal.zzccj;
import com.google.android.gms.internal.zzcck;
import com.google.android.gms.internal.zzccl;
import com.google.android.gms.internal.zzccm;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcdu;
import com.google.android.gms.internal.zzcfw;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzcch
extends zzcdu {
    static final Pair<String, Long> zziqm = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzdtp;
    public final zzccl zziqn = new zzccl(this, "health_monitor", zzcax.zzawr(), null);
    public final zzcck zziqo = new zzcck(this, "last_upload", 0L);
    public final zzcck zziqp = new zzcck(this, "last_upload_attempt", 0L);
    public final zzcck zziqq = new zzcck(this, "backoff", 0L);
    public final zzcck zziqr = new zzcck(this, "last_delete_stale", 0L);
    public final zzcck zziqs;
    public final zzcck zziqt;
    public final zzccm zziqu;
    private String zziqv;
    private boolean zziqw;
    private long zziqx;
    private String zziqy;
    private long zziqz;
    private final Object zzira;
    public final zzcck zzirb = new zzcck(this, "time_before_start", 10000L);
    public final zzcck zzirc = new zzcck(this, "session_timeout", 1800000L);
    public final zzccj zzird = new zzccj(this, "start_new_session", true);
    public final zzcck zzire = new zzcck(this, "last_pause_time", 0L);
    public final zzcck zzirf = new zzcck(this, "time_active", 0L);
    public boolean zzirg;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zzjh(String string) {
        this.zzuj();
        long l = this.zzvx().elapsedRealtime();
        if (this.zziqv != null && l < this.zziqx) {
            return new Pair((Object)this.zziqv, (Object)this.zziqw);
        }
        String string2 = string;
        this.zziqx = l + this.zzauo().zza(string2, zzcbm.zziob);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            if (info != null) {
                this.zziqv = info.getId();
                this.zziqw = info.isLimitAdTrackingEnabled();
            }
            if (this.zziqv == null) {
                this.zziqv = "";
            }
        }
        catch (Throwable throwable) {
            this.zzaum().zzayj().zzj("Unable to get advertising id", throwable);
            this.zziqv = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zziqv, (Object)this.zziqw);
    }

    @WorkerThread
    final String zzji(String string) {
        this.zzuj();
        String string2 = (String)this.zzjh((String)string).first;
        MessageDigest messageDigest = zzcfw.zzec("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzcch(zzccw zzccw2) {
        super(zzccw2);
        this.zziqs = new zzcck(this, "midnight_offset", 0L);
        this.zziqt = new zzcck(this, "first_open_time", 0L);
        this.zziqu = new zzccm(this, "app_instance_id", null);
        this.zzira = new Object();
    }

    @Override
    protected final void zzuk() {
        this.zzdtp = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzirg = this.zzdtp.getBoolean("has_been_opened", false);
        if (!this.zzirg) {
            SharedPreferences.Editor editor = this.zzdtp.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
    }

    @WorkerThread
    private final SharedPreferences zzaym() {
        this.zzuj();
        this.zzwk();
        return this.zzdtp;
    }

    @WorkerThread
    final void zzjj(String string) {
        this.zzuj();
        SharedPreferences.Editor editor = this.zzaym().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzayn() {
        this.zzuj();
        return this.zzaym().getString("gmp_app_id", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzjk(String string) {
        Object object = this.zzira;
        synchronized (object) {
            this.zziqy = string;
            this.zziqz = this.zzvx().elapsedRealtime();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzayo() {
        Object object = this.zzira;
        synchronized (object) {
            if (Math.abs(this.zzvx().elapsedRealtime() - this.zziqz) < 1000L) {
                return this.zziqy;
            }
            return null;
        }
    }

    @WorkerThread
    final Boolean zzayp() {
        this.zzuj();
        if (!this.zzaym().contains("use_service")) {
            return null;
        }
        return this.zzaym().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zzbm(boolean bl) {
        this.zzuj();
        this.zzaum().zzayk().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzaym().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzayq() {
        this.zzuj();
        this.zzaum().zzayk().log("Clearing collection preferences.");
        boolean bl = this.zzaym().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzbn(true);
        }
        SharedPreferences.Editor editor = this.zzaym().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    final void setMeasurementEnabled(boolean bl) {
        this.zzuj();
        this.zzaum().zzayk().zzj("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzaym().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzbn(boolean bl) {
        this.zzuj();
        return this.zzaym().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected final String zzayr() {
        this.zzuj();
        String string = this.zzaym().getString("previous_os_version", null);
        this.zzauc().zzwk();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzaym().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    static /* synthetic */ SharedPreferences zza(zzcch zzcch2) {
        return zzcch2.zzdtp;
    }

    static /* synthetic */ SharedPreferences zzb(zzcch zzcch2) {
        return zzcch2.zzaym();
    }
}

