/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzd;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbed;
import com.google.android.gms.internal.zzcan;
import com.google.android.gms.internal.zzcar;
import com.google.android.gms.internal.zzcas;
import com.google.android.gms.internal.zzcau;
import com.google.android.gms.internal.zzcav;
import com.google.android.gms.internal.zzcax;
import com.google.android.gms.internal.zzcay;
import com.google.android.gms.internal.zzcaz;
import com.google.android.gms.internal.zzcba;
import com.google.android.gms.internal.zzcbe;
import com.google.android.gms.internal.zzcbf;
import com.google.android.gms.internal.zzcbg;
import com.google.android.gms.internal.zzcbh;
import com.google.android.gms.internal.zzcbk;
import com.google.android.gms.internal.zzcbm;
import com.google.android.gms.internal.zzcbr;
import com.google.android.gms.internal.zzcbs;
import com.google.android.gms.internal.zzcbu;
import com.google.android.gms.internal.zzcbw;
import com.google.android.gms.internal.zzcby;
import com.google.android.gms.internal.zzcca;
import com.google.android.gms.internal.zzcce;
import com.google.android.gms.internal.zzccf;
import com.google.android.gms.internal.zzcch;
import com.google.android.gms.internal.zzccn;
import com.google.android.gms.internal.zzccq;
import com.google.android.gms.internal.zzccr;
import com.google.android.gms.internal.zzccx;
import com.google.android.gms.internal.zzccy;
import com.google.android.gms.internal.zzccz;
import com.google.android.gms.internal.zzcda;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzcdu;
import com.google.android.gms.internal.zzcdv;
import com.google.android.gms.internal.zzcdw;
import com.google.android.gms.internal.zzcej;
import com.google.android.gms.internal.zzcek;
import com.google.android.gms.internal.zzceo;
import com.google.android.gms.internal.zzcfh;
import com.google.android.gms.internal.zzcfl;
import com.google.android.gms.internal.zzcfr;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.internal.zzcfv;
import com.google.android.gms.internal.zzcfw;
import com.google.android.gms.internal.zzcge;
import com.google.android.gms.internal.zzcgg;
import com.google.android.gms.internal.zzcgh;
import com.google.android.gms.internal.zzcgi;
import com.google.android.gms.internal.zzcgj;
import com.google.android.gms.internal.zzcgk;
import com.google.android.gms.internal.zzcgm;
import com.google.android.gms.internal.zzegx;
import com.google.android.gms.internal.zzegy;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.analytics.FirebaseAnalytics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class zzccw {
    private static volatile zzccw zzisq;
    private final Context mContext;
    private final zzcax zzisr;
    private final zzcch zziss;
    private final zzcbw zzist;
    private final zzccr zzisu;
    private final zzcfl zzisv;
    private final zzccq zzisw;
    private final AppMeasurement zzisx;
    private final FirebaseAnalytics zzisy;
    private final zzcfw zzisz;
    private final zzcbu zzita;
    private final zzcay zzitb;
    private final zzcbs zzitc;
    private final zzcca zzitd;
    private final zzd zzasb;
    private final zzcek zzite;
    private final zzceo zzitf;
    private final zzcbe zzitg;
    private final zzcdw zzith;
    private final zzcbr zziti;
    private final zzccf zzitj;
    private final zzcfr zzitk;
    private final zzcau zzitl;
    private final zzcan zzitm;
    private final boolean zzdod;
    private boolean zzitn;
    private Boolean zzito;
    private long zzitp;
    private FileLock zzitq;
    private FileChannel zzitr;
    private List<Long> zzits;
    private List<Runnable> zzitt;
    private int zzitu;
    private int zzitv;
    private long zzitw;
    private long zzitx;
    private boolean zzity;
    private boolean zzitz;
    private boolean zziua;
    private final long zziub;

    private zzccw(zzcdv zzcdv2) {
        zzcan zzcan2;
        String string;
        zzcby zzcby2;
        zzbp.zzu((Object)zzcdv2);
        this.mContext = zzcdv2.mContext;
        this.zzitw = -1L;
        this.zzasb = zzh.zzald();
        this.zziub = this.zzasb.currentTimeMillis();
        Object object = this;
        this.zzisr = new zzcax((zzccw)object);
        object = this;
        zzcch zzcch2 = new zzcch((zzccw)object);
        zzcch2.initialize();
        this.zziss = zzcch2;
        object = this;
        zzcbw zzcbw2 = new zzcbw((zzccw)object);
        zzcbw2.initialize();
        this.zzist = zzcbw2;
        this.zzaum().zzayi().zzj("App measurement is starting up, version", zzcax.zzauw());
        zzcax.zzawl();
        this.zzaum().zzayi().log("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        object = this;
        zzcfw zzcfw2 = new zzcfw((zzccw)object);
        zzcfw2.initialize();
        this.zzisz = zzcfw2;
        object = this;
        zzcbu zzcbu2 = new zzcbu((zzccw)object);
        zzcbu2.initialize();
        this.zzita = zzcbu2;
        object = this;
        zzcbe zzcbe2 = new zzcbe((zzccw)object);
        zzcbe2.initialize();
        this.zzitg = zzcbe2;
        object = this;
        zzcbr zzcbr2 = new zzcbr((zzccw)object);
        zzcbr2.initialize();
        this.zziti = zzcbr2;
        zzcax.zzawl();
        Object object2 = zzcbr2.getAppId();
        if (this.zzaui().zzke((String)object2)) {
            zzcby2 = this.zzaum().zzayi();
            string = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
        } else {
            zzcby2 = this.zzaum().zzayi();
            String string2 = String.valueOf(object2);
            string = string2.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string2) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
        }
        zzcby2.log(string);
        this.zzaum().zzayj().log("Debug-level message logging enabled");
        object = this;
        object2 = new zzcay((zzccw)object);
        ((zzcdu)object2).initialize();
        this.zzitb = object2;
        object = this;
        zzcbs zzcbs2 = new zzcbs((zzccw)object);
        zzcbs2.initialize();
        this.zzitc = zzcbs2;
        object = this;
        zzcau zzcau2 = new zzcau((zzccw)object);
        zzcau2.initialize();
        this.zzitl = zzcau2;
        object = this;
        this.zzitm = zzcan2 = new zzcan((zzccw)object);
        object = this;
        zzcca zzcca2 = new zzcca((zzccw)object);
        zzcca2.initialize();
        this.zzitd = zzcca2;
        object = this;
        zzcek zzcek2 = new zzcek((zzccw)object);
        zzcek2.initialize();
        this.zzite = zzcek2;
        object = this;
        zzceo zzceo2 = new zzceo((zzccw)object);
        zzceo2.initialize();
        this.zzitf = zzceo2;
        object = this;
        zzcdw zzcdw2 = new zzcdw((zzccw)object);
        zzcdw2.initialize();
        this.zzith = zzcdw2;
        object = this;
        zzcfr zzcfr2 = new zzcfr((zzccw)object);
        zzcfr2.initialize();
        this.zzitk = zzcfr2;
        object = this;
        this.zzitj = new zzccf((zzccw)object);
        object = this;
        this.zzisx = new AppMeasurement((zzccw)object);
        object = this;
        this.zzisy = new FirebaseAnalytics((zzccw)object);
        object = this;
        zzcfl zzcfl2 = new zzcfl((zzccw)object);
        zzcfl2.initialize();
        this.zzisv = zzcfl2;
        object = this;
        zzccq zzccq2 = new zzccq((zzccw)object);
        zzccq2.initialize();
        this.zzisw = zzccq2;
        object = this;
        zzccr zzccr2 = new zzccr((zzccw)object);
        zzccr2.initialize();
        this.zzisu = zzccr2;
        if (this.zzitu != this.zzitv) {
            this.zzaum().zzaye().zze("Not all components initialized", this.zzitu, this.zzitv);
        }
        this.zzdod = true;
        zzcax.zzawl();
        if (this.mContext.getApplicationContext() instanceof Application) {
            object = this.zzaua();
            if (((zzcdt)object).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzcdt)object).getContext().getApplicationContext();
                if (((zzcdw)object).zzius == null) {
                    ((zzcdw)object).zzius = new zzcej((zzcdw)object, null);
                }
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzcdw)object).zzius);
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzcdw)object).zzius);
                ((zzcdt)object).zzaum().zzayk().log("Registered activity lifecycle callback");
            }
        } else {
            this.zzaum().zzayg().log("Application context is not an Application");
        }
        this.zzisu.zzg(new zzccx(this));
    }

    final void zzwk() {
        if (!this.zzdod) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    @WorkerThread
    protected final boolean zzayw() {
        this.zzwk();
        ((zzcdt)this.zzaul()).zzuj();
        if (this.zzito == null || this.zzitp == 0L || this.zzito != null && !this.zzito.booleanValue() && Math.abs(this.zzasb.elapsedRealtime() - this.zzitp) > 1000L) {
            this.zzitp = this.zzasb.elapsedRealtime();
            zzcax.zzawl();
            this.zzito = this.zzaui().zzdt("android.permission.INTERNET") && this.zzaui().zzdt("android.permission.ACCESS_NETWORK_STATE") && (zzbed.zzcr((Context)this.mContext).zzalr() || zzccn.zzj(this.mContext, false) && zzcfh.zzk(this.mContext, false));
            if (this.zzito.booleanValue()) {
                this.zzito = this.zzaui().zzkb(this.zzaub().getGmpAppId());
            }
        }
        return this.zzito;
    }

    @WorkerThread
    protected final void start() {
        ((zzcdt)this.zzaul()).zzuj();
        this.zzaug().zzaxl();
        if (this.zzaun().zziqo.get() == 0L) {
            this.zzaun().zziqo.set(this.zzasb.currentTimeMillis());
        }
        if (Long.valueOf(this.zzaun().zziqt.get()) == 0L) {
            this.zzaum().zzayk().zzj("Persisting first open", this.zziub);
            this.zzaun().zziqt.set(this.zziub);
        }
        if (!this.zzayw()) {
            if (this.isEnabled()) {
                if (!this.zzaui().zzdt("android.permission.INTERNET")) {
                    this.zzaum().zzaye().log("App is missing INTERNET permission");
                }
                if (!this.zzaui().zzdt("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzaum().zzaye().log("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzcax.zzawl();
                if (!zzbed.zzcr((Context)this.mContext).zzalr()) {
                    if (!zzccn.zzj(this.mContext, false)) {
                        this.zzaum().zzaye().log("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzcfh.zzk(this.mContext, false)) {
                        this.zzaum().zzaye().log("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzaum().zzaye().log("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzcax.zzawl();
            if (!TextUtils.isEmpty((CharSequence)this.zzaub().getGmpAppId())) {
                String string = this.zzaun().zzayn();
                if (string == null) {
                    this.zzaun().zzjj(this.zzaub().getGmpAppId());
                } else if (!string.equals(this.zzaub().getGmpAppId())) {
                    this.zzaum().zzayi().log("Rechecking which service to use due to a GMP App Id change");
                    this.zzaun().zzayq();
                    this.zzitf.disconnect();
                    this.zzitf.zzxh();
                    this.zzaun().zzjj(this.zzaub().getGmpAppId());
                    this.zzaun().zziqt.set(this.zziub);
                    this.zzaun().zziqu.zzjl(null);
                }
            }
            this.zzaua().zzjk(this.zzaun().zziqu.zzays());
            zzcax.zzawl();
            if (!TextUtils.isEmpty((CharSequence)this.zzaub().getGmpAppId())) {
                zzcdw zzcdw2 = this.zzaua();
                ((zzcdt)zzcdw2).zzuj();
                ((zzcdt)zzcdw2).zzatw();
                zzcdw2.zzwk();
                if (zzcdw2.zzikh.zzayw()) {
                    ((zzcdt)zzcdw2).zzaud().zzazr();
                    String string = ((zzcdt)zzcdw2).zzaun().zzayr();
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        ((zzcdt)zzcdw2).zzauc().zzwk();
                        if (!string.equals(Build.VERSION.RELEASE)) {
                            Bundle bundle = new Bundle();
                            bundle.putString("_po", string);
                            zzcdw2.zzc("auto", "_ou", bundle);
                        }
                    }
                }
                this.zzaud().zza(new AtomicReference<String>());
            }
        }
        this.zzazj();
    }

    public final zzcax zzauo() {
        return this.zzisr;
    }

    public final zzcch zzaun() {
        zzccw.zza((zzcdt)this.zziss);
        return this.zziss;
    }

    public final zzcbw zzaum() {
        zzccw.zza(this.zzist);
        return this.zzist;
    }

    public final zzcbw zzayx() {
        if (this.zzist != null && this.zzist.isInitialized()) {
            return this.zzist;
        }
        return null;
    }

    public final zzccr zzaul() {
        zzccw.zza(this.zzisu);
        return this.zzisu;
    }

    public final zzcfl zzauk() {
        zzccw.zza(this.zzisv);
        return this.zzisv;
    }

    public final zzccq zzauj() {
        zzccw.zza(this.zzisw);
        return this.zzisw;
    }

    final zzccr zzayy() {
        return this.zzisu;
    }

    public final zzcdw zzaua() {
        zzccw.zza(this.zzith);
        return this.zzith;
    }

    public final AppMeasurement zzayz() {
        return this.zzisx;
    }

    public final FirebaseAnalytics zzaza() {
        return this.zzisy;
    }

    public final zzcfw zzaui() {
        zzccw.zza((zzcdt)this.zzisz);
        return this.zzisz;
    }

    public final zzcbu zzauh() {
        zzccw.zza((zzcdt)this.zzita);
        return this.zzita;
    }

    public final zzcay zzaug() {
        zzccw.zza(this.zzitb);
        return this.zzitb;
    }

    public final zzcbs zzauf() {
        zzccw.zza(this.zzitc);
        return this.zzitc;
    }

    public final zzcca zzazb() {
        zzccw.zza(this.zzitd);
        return this.zzitd;
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final zzd zzvx() {
        return this.zzasb;
    }

    public final zzcek zzaue() {
        zzccw.zza(this.zzite);
        return this.zzite;
    }

    public final zzceo zzaud() {
        zzccw.zza(this.zzitf);
        return this.zzitf;
    }

    public final zzcbe zzauc() {
        zzccw.zza(this.zzitg);
        return this.zzitg;
    }

    public final zzcbr zzaub() {
        zzccw.zza(this.zziti);
        return this.zziti;
    }

    private final zzccf zzazc() {
        if (this.zzitj == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzitj;
    }

    private final zzcfr zzazd() {
        zzccw.zza(this.zzitk);
        return this.zzitk;
    }

    public final zzcau zzatz() {
        zzccw.zza(this.zzitl);
        return this.zzitl;
    }

    public final zzcan zzaty() {
        zzccw.zza(this.zzitm);
        return this.zzitm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzccw zzdn(Context context) {
        zzbp.zzu((Object)context);
        zzbp.zzu((Object)context.getApplicationContext());
        if (zzisq != null) return zzisq;
        Class<zzccw> clazz = zzccw.class;
        synchronized (zzccw.class) {
            if (zzisq != null) return zzisq;
            zzcdv zzcdv2 = new zzcdv(context);
            zzisq = new zzccw(zzcdv2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzisq;
        }
    }

    private static void zza(zzcdu zzcdu2) {
        if (zzcdu2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzcdu2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private static void zza(zzcdt zzcdt2) {
        if (zzcdt2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    private final boolean zzaze() {
        ((zzcdt)this.zzaul()).zzuj();
        String string = zzcax.zzawj();
        File file = this.mContext.getFilesDir();
        File file2 = new File(file, string);
        try {
            this.zzitr = new RandomAccessFile(file2, "rw").getChannel();
            this.zzitq = this.zzitr.tryLock();
            if (this.zzitq != null) {
                this.zzaum().zzayk().log("Storage concurrent access okay");
                return true;
            }
            this.zzaum().zzaye().log("Storage concurrent data access panic");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.zzaum().zzaye().zzj("Failed to acquire storage lock", fileNotFoundException);
        }
        catch (IOException iOException) {
            this.zzaum().zzaye().zzj("Failed to access storage lock file", iOException);
        }
        return false;
    }

    @WorkerThread
    private final int zza(FileChannel fileChannel) {
        ((zzcdt)this.zzaul()).zzuj();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzaum().zzaye().log("Bad chanel to read from");
            return 0;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        try {
            fileChannel.position(0L);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != 4) {
                if (n2 != -1) {
                    this.zzaum().zzayg().zzj("Unexpected data length. Bytes read", n2);
                }
                return 0;
            }
            byteBuffer.flip();
            n = byteBuffer.getInt();
        }
        catch (IOException iOException) {
            this.zzaum().zzaye().zzj("Failed to read from channel", iOException);
        }
        return n;
    }

    @WorkerThread
    private final boolean zza(int n, FileChannel fileChannel) {
        ((zzcdt)this.zzaul()).zzuj();
        if (fileChannel == null || !fileChannel.isOpen()) {
            this.zzaum().zzaye().log("Bad chanel to read from");
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer.flip();
        try {
            fileChannel.truncate(0L);
            fileChannel.write(byteBuffer);
            fileChannel.force(true);
            if (fileChannel.size() != 4L) {
                this.zzaum().zzaye().zzj("Error writing to channel. Bytes written", fileChannel.size());
            }
            return true;
        }
        catch (IOException iOException) {
            this.zzaum().zzaye().zzj("Failed to write to channel", iOException);
            return false;
        }
    }

    @WorkerThread
    public final boolean isEnabled() {
        ((zzcdt)this.zzaul()).zzuj();
        this.zzwk();
        if (this.zzisr.zzawm()) {
            return false;
        }
        Boolean bl = this.zzisr.zzit("firebase_analytics_collection_enabled");
        boolean bl2 = bl != null ? bl : !zzcax.zzaif();
        return this.zzaun().zzbn(bl2);
    }

    final void zzd(zzcas zzcas2) {
        ((zzcdt)this.zzaul()).zzuj();
        this.zzwk();
        zzbp.zzgg((String)zzcas2.packageName);
        this.zzf(zzcas2);
    }

    final long zzazf() {
        Long l = this.zzaun().zziqt.get();
        if (l == 0L) {
            return this.zziub;
        }
        return Math.min(this.zziub, l);
    }

    private final long zzazg() {
        long l = this.zzasb.currentTimeMillis();
        zzcch zzcch2 = this.zzaun();
        zzcch2.zzwk();
        zzcch2.zzuj();
        long l2 = zzcch2.zziqs.get();
        if (l2 == 0L) {
            l2 = 1 + zzcch2.zzaui().zzazz().nextInt(86400000);
            zzcch2.zziqs.set(l2);
        }
        return (l + l2) / 1000L / 60L / 60L / 24L;
    }

    @WorkerThread
    private final zzcas zzjr(String string) {
        zzcar zzcar2 = this.zzaug().zziw(string);
        if (zzcar2 == null || TextUtils.isEmpty((CharSequence)zzcar2.zzuo())) {
            this.zzaum().zzayj().zzj("No app data available; dropping", string);
            return null;
        }
        try {
            String string2 = zzbed.zzcr((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
            if (zzcar2.zzuo() != null && !zzcar2.zzuo().equals(string2)) {
                this.zzaum().zzayg().zzj("App version does not match; dropping. appId", zzcbw.zzjf(string));
                return null;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return new zzcas(string, zzcar2.getGmpAppId(), zzcar2.zzuo(), zzcar2.zzauu(), zzcar2.zzauv(), zzcar2.zzauw(), zzcar2.zzaux(), null, zzcar2.zzauy(), false, zzcar2.zzaur(), zzcar2.zzavl(), 0L, 0);
    }

    @WorkerThread
    final void zzb(zzcbk zzcbk2, String string) {
        Object object;
        zzcar zzcar2;
        block4: {
            zzcar2 = this.zzaug().zziw(string);
            if (zzcar2 == null || TextUtils.isEmpty((CharSequence)zzcar2.zzuo())) {
                this.zzaum().zzayj().zzj("No app data available; dropping event", string);
                return;
            }
            try {
                object = zzbed.zzcr((Context)this.mContext).getPackageInfo((String)string, (int)0).versionName;
                if (zzcar2.zzuo() != null && !zzcar2.zzuo().equals(object)) {
                    this.zzaum().zzayg().zzj("App version does not match; dropping event. appId", zzcbw.zzjf(string));
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                if ("_ui".equals(zzcbk2.name)) break block4;
                this.zzaum().zzayg().zzj("Could not find package. appId", zzcbw.zzjf(string));
            }
        }
        object = new zzcas(string, zzcar2.getGmpAppId(), zzcar2.zzuo(), zzcar2.zzauu(), zzcar2.zzauv(), zzcar2.zzauw(), zzcar2.zzaux(), null, zzcar2.zzauy(), false, zzcar2.zzaur(), zzcar2.zzavl(), 0L, 0);
        this.zzb(zzcbk2, (zzcas)((Object)object));
    }

    @WorkerThread
    final void zzb(zzcbk zzcbk2, zzcas zzcas2) {
        zzbp.zzu((Object)((Object)zzcas2));
        zzbp.zzgg((String)zzcas2.packageName);
        ((zzcdt)this.zzaul()).zzuj();
        this.zzwk();
        String string = zzcas2.packageName;
        long l = zzcbk2.zzinr;
        this.zzaui();
        if (!zzcfw.zzd(zzcbk2, zzcas2)) {
            return;
        }
        if (!zzcas2.zzily) {
            this.zzf(zzcas2);
            return;
        }
        this.zzaug().beginTransaction();
        try {
            zzbck zzbck2;
            List<Object> list;
            Object object;
            List<Object> list2;
            Object object22;
            Object object3;
            String string2;
            List list3;
            long l2 = l;
            String string3 = string;
            zzcay zzcay2 = this.zzaug();
            zzbp.zzgg((String)string3);
            zzcay2.zzuj();
            zzcay2.zzwk();
            if (l2 < 0L) {
                zzcay2.zzaum().zzayg().zze("Invalid time querying timed out conditional properties", zzcbw.zzjf(string3), l2);
                list3 = Collections.emptyList();
            } else {
                string2 = "active=0 and app_id=? and abs(? - creation_timestamp) > trigger_timeout";
                object3 = new String[]{string3, String.valueOf(l2)};
                list3 = zzcay2.zzc(string2, (String[])object3);
            }
            for (Object object22 : list3) {
                if (object22 == null) continue;
                this.zzaum().zzayj().zzd("User property timed out", object22.packageName, this.zzauh().zzje(object22.zzimg.name), object22.zzimg.getValue());
                if (object22.zzimk != null) {
                    this.zzc(new zzcbk(object22.zzimk, l), zzcas2);
                }
                this.zzaug().zzaj(string, object22.zzimg.name);
            }
            l2 = l;
            string3 = string;
            zzcay2 = this.zzaug();
            zzbp.zzgg((String)string3);
            zzcay2.zzuj();
            zzcay2.zzwk();
            if (l2 < 0L) {
                zzcay2.zzaum().zzayg().zze("Invalid time querying expired conditional properties", zzcbw.zzjf(string3), l2);
                list2 = Collections.emptyList();
            } else {
                string2 = "active<>0 and app_id=? and abs(? - triggered_timestamp) > time_to_live";
                object3 = new String[]{string3, String.valueOf(l2)};
                list2 = zzcay2.zzc(string2, (String[])object3);
            }
            List list4 = list2;
            object22 = new ArrayList(list4.size());
            Object object4 = list4.iterator();
            while (object4.hasNext()) {
                object = (zzcav)((Object)object4.next());
                if (object == null) continue;
                this.zzaum().zzayj().zzd("User property expired", object.packageName, this.zzauh().zzje(object.zzimg.name), object.zzimg.getValue());
                this.zzaug().zzag(string, object.zzimg.name);
                if (object.zzimo != null) {
                    object22.add(object.zzimo);
                }
                this.zzaug().zzaj(string, object.zzimg.name);
            }
            ArrayList arrayList = (ArrayList)object22;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                object = (zzcbk)((Object)e);
                this.zzc(new zzcbk((zzcbk)((Object)object), l), zzcas2);
            }
            long l3 = l;
            String string4 = zzcbk2.name;
            string3 = string;
            zzcay2 = this.zzaug();
            zzbp.zzgg((String)string3);
            zzbp.zzgg((String)string4);
            zzcay2.zzuj();
            zzcay2.zzwk();
            if (l3 < 0L) {
                zzcay2.zzaum().zzayg().zzd("Invalid time querying triggered conditional properties", zzcbw.zzjf(string3), zzcay2.zzauh().zzjc(string4), l3);
                list = Collections.emptyList();
            } else {
                object3 = "active=0 and app_id=? and trigger_event_name=? and abs(? - creation_timestamp) <= trigger_timeout";
                String[] stringArray = new String[]{string3, string4, String.valueOf(l3)};
                list = zzcay2.zzc((String)object3, stringArray);
            }
            object4 = list;
            object = new ArrayList(object4.size());
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                zzbck2 = (zzcav)((Object)iterator.next());
                if (zzbck2 == null) continue;
                zzcft zzcft2 = zzbck2.zzimg;
                zzcfv zzcfv2 = new zzcfv(zzbck2.packageName, zzbck2.zzimf, zzcft2.name, l, zzcft2.getValue());
                if (this.zzaug().zza(zzcfv2)) {
                    this.zzaum().zzayj().zzd("User property triggered", zzbck2.packageName, this.zzauh().zzje(zzcfv2.mName), zzcfv2.mValue);
                } else {
                    this.zzaum().zzaye().zzd("Too many active user properties, ignoring", zzcbw.zzjf(zzbck2.packageName), this.zzauh().zzje(zzcfv2.mName), zzcfv2.mValue);
                }
                if (zzbck2.zzimm != null) {
                    object.add(zzbck2.zzimm);
                }
                zzbck2.zzimg = new zzcft(zzcfv2);
                zzbck2.zzimi = true;
                this.zzaug().zza((zzcav)zzbck2);
            }
            this.zzc(zzcbk2, zzcas2);
            ArrayList arrayList2 = (ArrayList)object;
            int n2 = arrayList2.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList2.get(i);
                zzbck2 = (zzcbk)((Object)e);
                this.zzc(new zzcbk((zzcbk)zzbck2, l), zzcas2);
            }
            this.zzaug().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzaug().endTransaction();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final void zzc(zzcbk zzcbk2, zzcas zzcas2) {
        zzbp.zzu((Object)((Object)zzcas2));
        zzbp.zzgg((String)zzcas2.packageName);
        long l = System.nanoTime();
        ((zzcdt)this.zzaul()).zzuj();
        this.zzwk();
        String string = zzcas2.packageName;
        this.zzaui();
        if (!zzcfw.zzd(zzcbk2, zzcas2)) {
            return;
        }
        if (!zzcas2.zzily) {
            this.zzf(zzcas2);
            return;
        }
        if (this.zzauj().zzao(string, zzcbk2.name)) {
            this.zzaum().zzayg().zze("Dropping blacklisted event. appId", zzcbw.zzjf(string), this.zzauh().zzjc(zzcbk2.name));
            boolean bl = this.zzaui().zzkg(string) || this.zzaui().zzkh(string);
            if (!bl && !"_err".equals(zzcbk2.name)) {
                this.zzaui().zza(string, 11, "_ev", zzcbk2.name, 0);
            }
            if (!bl) return;
            zzcar zzcar2 = this.zzaug().zziw(string);
            if (zzcar2 == null) return;
            long l2 = Math.max(zzcar2.zzavb(), zzcar2.zzava());
            if (Math.abs(this.zzasb.currentTimeMillis() - l2) <= zzcax.zzawp()) return;
            this.zzaum().zzayj().log("Fetching config for blacklisted app");
            this.zzb(zzcar2);
            return;
        }
        if (this.zzaum().zzad(2)) {
            this.zzaum().zzayk().zzj("Logging event", this.zzauh().zzb(zzcbk2));
        }
        this.zzaug().beginTransaction();
        try {
            zzcbg zzcbg2;
            long l3;
            int n;
            String string2;
            Bundle bundle = zzcbk2.zzinq.zzaya();
            this.zzf(zzcas2);
            if ("_iap".equals(zzcbk2.name) || "ecommerce_purchase".equals(zzcbk2.name)) {
                long l4;
                String string3;
                block37: {
                    string3 = bundle.getString("currency");
                    if ("ecommerce_purchase".equals(zzcbk2.name)) {
                        double d = bundle.getDouble("value") * 1000000.0;
                        if (d == 0.0) {
                            d = (double)bundle.getLong("value") * 1000000.0;
                        }
                        if (d <= 9.223372036854776E18 && d >= -9.223372036854776E18) {
                            l4 = Math.round(d);
                            break block37;
                        } else {
                            this.zzaum().zzayg().zze("Data lost. Currency value is too big. appId", zzcbw.zzjf(string), d);
                            this.zzaug().setTransactionSuccessful();
                            return;
                        }
                    }
                    l4 = bundle.getLong("value");
                }
                if (!TextUtils.isEmpty((CharSequence)string3) && (string3 = string3.toUpperCase(Locale.US)).matches("[A-Z]{3}")) {
                    String string4 = String.valueOf("_ltv_");
                    String string5 = String.valueOf(string3);
                    String string6 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
                    zzcfv zzcfv2 = this.zzaug().zzah(string, string6);
                    if (zzcfv2 == null || !(zzcfv2.mValue instanceof Long)) {
                        string2 = string;
                        n = this.zzisr.zzb(string2, zzcbm.zzipe) - 1;
                        string2 = string;
                        zzcay zzcay2 = this.zzaug();
                        zzbp.zzgg((String)string2);
                        zzcay2.zzuj();
                        zzcay2.zzwk();
                        try {
                            zzcay2.getWritableDatabase().execSQL("delete from user_attributes where app_id=? and name in (select name from user_attributes where app_id=? and name like '_ltv_%' order by set_timestamp desc limit ?,10);", (Object[])new String[]{string2, string2, String.valueOf(n)});
                        }
                        catch (SQLiteException sQLiteException) {
                            zzcay2.zzaum().zzaye().zze("Error pruning currencies. appId", zzcbw.zzjf(string2), (Object)sQLiteException);
                        }
                        zzcfv2 = new zzcfv(string, zzcbk2.zzimf, string6, this.zzasb.currentTimeMillis(), l4);
                    } else {
                        l3 = (Long)zzcfv2.mValue;
                        zzcfv2 = new zzcfv(string, zzcbk2.zzimf, string6, this.zzasb.currentTimeMillis(), l3 + l4);
                    }
                    if (!this.zzaug().zza(zzcfv2)) {
                        this.zzaum().zzaye().zzd("Too many unique user properties are set. Ignoring user property. appId", zzcbw.zzjf(string), this.zzauh().zzje(zzcfv2.mName), zzcfv2.mValue);
                        this.zzaui().zza(string, 9, null, null, 0);
                    }
                }
            }
            boolean bl = zzcfw.zzju(zzcbk2.name);
            boolean bl2 = "_err".equals(zzcbk2.name);
            zzcaz zzcaz2 = this.zzaug().zza(this.zzazg(), string, true, bl, false, bl2, false);
            long l5 = zzcaz2.zzimy - zzcax.zzavx();
            if (l5 > 0L) {
                if (l5 % 1000L == 1L) {
                    this.zzaum().zzaye().zze("Data loss. Too many events logged. appId, count", zzcbw.zzjf(string), zzcaz2.zzimy);
                }
                this.zzaug().setTransactionSuccessful();
                return;
            }
            if (bl && (l5 = zzcaz2.zzimx - zzcax.zzavy()) > 0L) {
                if (l5 % 1000L == 1L) {
                    this.zzaum().zzaye().zze("Data loss. Too many public events logged. appId, count", zzcbw.zzjf(string), zzcaz2.zzimx);
                }
                this.zzaui().zza(string, 16, "_ev", zzcbk2.name, 0);
                this.zzaug().setTransactionSuccessful();
                return;
            }
            if (bl2) {
                string2 = zzcas2.packageName;
                n = this.zzisr.zzb(string2, zzcbm.zziol);
                l5 = zzcaz2.zzina - (long)Math.max(0, n = Math.min(1000000, n));
                if (l5 > 0L) {
                    if (l5 == 1L) {
                        this.zzaum().zzaye().zze("Too many error events logged. appId, count", zzcbw.zzjf(string), zzcaz2.zzina);
                    }
                    this.zzaug().setTransactionSuccessful();
                    return;
                }
            }
            this.zzaui().zza(bundle, "_o", (Object)zzcbk2.zzimf);
            if (this.zzaui().zzke(string)) {
                this.zzaui().zza(bundle, "_dbg", 1L);
                this.zzaui().zza(bundle, "_r", 1L);
            }
            if ((l3 = this.zzaug().zzix(string)) > 0L) {
                this.zzaum().zzayg().zze("Data lost. Too many events stored on disk, deleted. appId", zzcbw.zzjf(string), l3);
            }
            zzcbf zzcbf2 = new zzcbf(this, zzcbk2.zzimf, string, zzcbk2.name, zzcbk2.zzinr, 0L, bundle);
            zzcbg zzcbg3 = this.zzaug().zzaf(string, zzcbf2.mName);
            if (zzcbg3 == null) {
                long l6 = this.zzaug().zzja(string);
                zzcax.zzavw();
                if (l6 >= 500L) {
                    this.zzaum().zzaye().zzd("Too many event names used, ignoring event. appId, name, supported count", zzcbw.zzjf(string), this.zzauh().zzjc(zzcbf2.mName), zzcax.zzavw());
                    this.zzaui().zza(string, 8, null, null, 0);
                    return;
                }
                zzcbg2 = new zzcbg(string, zzcbf2.mName, 0L, 0L, zzcbf2.zzfdb);
            } else {
                zzcbf2 = zzcbf2.zza(this, zzcbg3.zzinm);
                zzcbg2 = zzcbg3.zzbb(zzcbf2.zzfdb);
            }
            this.zzaug().zza(zzcbg2);
            this.zza(zzcbf2, zzcas2);
            this.zzaug().setTransactionSuccessful();
            if (this.zzaum().zzad(2)) {
                this.zzaum().zzayk().zzj("Event recorded", this.zzauh().zza(zzcbf2));
            }
        }
        finally {
            this.zzaug().endTransaction();
        }
        this.zzazj();
        this.zzaum().zzayk().zzj("Background event processing time, ms", (System.nanoTime() - l + 500000L) / 1000000L);
    }

    @WorkerThread
    final void zzd(zzcav zzcav2) {
        zzcas zzcas2 = this.zzjr(zzcav2.packageName);
        if (zzcas2 != null) {
            this.zzb(zzcav2, zzcas2);
        }
    }

    @WorkerThread
    final void zzb(zzcav zzcav2, zzcas zzcas2) {
        zzbp.zzu((Object)((Object)zzcav2));
        zzbp.zzgg((String)zzcav2.packageName);
        zzbp.zzu((Object)zzcav2.zzimf);
        zzbp.zzu((Object)((Object)zzcav2.zzimg));
        zzbp.zzgg((String)zzcav2.zzimg.name);
        ((zzcdt)this.zzaul()).zzuj();
        this.zzwk();
        if (TextUtils.isEmpty((CharSequence)zzcas2.zzilt)) {
            return;
        }
        if (!zzcas2.zzily) {
            this.zzf(zzcas2);
            return;
        }
        zzcav zzcav3 = new zzcav(zzcav2);
        new zzcav(zzcav2).zzimi = false;
        this.zzaug().beginTransaction();
        try {
            boolean bl = false;
            zzcav zzcav4 = this.zzaug().zzai(zzcav3.packageName, zzcav3.zzimg.name);
            if (zzcav4 != null && !zzcav4.zzimf.equals(zzcav3.zzimf)) {
                this.zzaum().zzayg().zzd("Updating a conditional user property with different origin. name, origin, origin (from DB)", this.zzauh().zzje(zzcav3.zzimg.name), zzcav3.zzimf, zzcav4.zzimf);
            }
            if (zzcav4 != null && zzcav4.zzimi) {
                zzcav3.zzimf = zzcav4.zzimf;
                zzcav3.zzimh = zzcav4.zzimh;
                zzcav3.zziml = zzcav4.zziml;
                zzcav3.zzimj = zzcav4.zzimj;
                zzcav3.zzimm = zzcav4.zzimm;
                zzcav3.zzimi = zzcav4.zzimi;
                zzcav3.zzimg = new zzcft(zzcav3.zzimg.name, zzcav4.zzimg.zziwy, zzcav3.zzimg.getValue(), zzcav4.zzimg.zzimf);
            } else if (TextUtils.isEmpty((CharSequence)zzcav3.zzimj)) {
                zzcav3.zzimg = new zzcft(zzcav3.zzimg.name, zzcav3.zzimh, zzcav3.zzimg.getValue(), zzcav3.zzimg.zzimf);
                zzcav3.zzimi = true;
                bl = true;
            }
            if (zzcav3.zzimi) {
                zzcft zzcft2 = zzcav3.zzimg;
                zzcfv zzcfv2 = new zzcfv(zzcav3.packageName, zzcav3.zzimf, zzcft2.name, zzcft2.zziwy, zzcft2.getValue());
                if (this.zzaug().zza(zzcfv2)) {
                    this.zzaum().zzayj().zzd("User property updated immediately", zzcav3.packageName, this.zzauh().zzje(zzcfv2.mName), zzcfv2.mValue);
                } else {
                    this.zzaum().zzaye().zzd("(2)Too many active user properties, ignoring", zzcbw.zzjf(zzcav3.packageName), this.zzauh().zzje(zzcfv2.mName), zzcfv2.mValue);
                }
                if (bl && zzcav3.zzimm != null) {
                    zzcbk zzcbk2 = new zzcbk(zzcav3.zzimm, zzcav3.zzimh);
                    this.zzc(zzcbk2, zzcas2);
                }
            }
            if (this.zzaug().zza(zzcav3)) {
                this.zzaum().zzayj().zzd("Conditional property added", zzcav3.packageName, this.zzauh().zzje(zzcav3.zzimg.name), zzcav3.zzimg.getValue());
            } else {
                this.zzaum().zzaye().zzd("Too many conditional properties, ignoring", zzcbw.zzjf(zzcav3.packageName), this.zzauh().zzje(zzcav3.zzimg.name), zzcav3.zzimg.getValue());
            }
            this.zzaug().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzaug().endTransaction();
        }
    }

    @WorkerThread
    final void zze(zzcav zzcav2) {
        zzcas zzcas2 = this.zzjr(zzcav2.packageName);
        if (zzcas2 != null) {
            this.zzc(zzcav2, zzcas2);
        }
    }

    @WorkerThread
    final void zzc(zzcav zzcav2, zzcas zzcas2) {
        zzbp.zzu((Object)((Object)zzcav2));
        zzbp.zzgg((String)zzcav2.packageName);
        zzbp.zzu((Object)((Object)zzcav2.zzimg));
        zzbp.zzgg((String)zzcav2.zzimg.name);
        ((zzcdt)this.zzaul()).zzuj();
        this.zzwk();
        if (TextUtils.isEmpty((CharSequence)zzcas2.zzilt)) {
            return;
        }
        if (!zzcas2.zzily) {
            this.zzf(zzcas2);
            return;
        }
        this.zzaug().beginTransaction();
        try {
            this.zzf(zzcas2);
            zzcav zzcav3 = this.zzaug().zzai(zzcav2.packageName, zzcav2.zzimg.name);
            if (zzcav3 != null) {
                this.zzaum().zzayj().zze("Removing conditional user property", zzcav2.packageName, this.zzauh().zzje(zzcav2.zzimg.name));
                this.zzaug().zzaj(zzcav2.packageName, zzcav2.zzimg.name);
                if (zzcav3.zzimi) {
                    this.zzaug().zzag(zzcav2.packageName, zzcav2.zzimg.name);
                }
                if (zzcav2.zzimo != null) {
                    Bundle bundle = null;
                    if (zzcav2.zzimo.zzinq != null) {
                        bundle = zzcav2.zzimo.zzinq.zzaya();
                    }
                    zzcbk zzcbk2 = this.zzaui().zza(zzcav2.zzimo.name, bundle, zzcav3.zzimf, zzcav2.zzimo.zzinr, true, false);
                    this.zzc(zzcbk2, zzcas2);
                }
            } else {
                this.zzaum().zzayg().zze("Conditional user property doesn't exist", zzcbw.zzjf(zzcav2.packageName), this.zzauh().zzje(zzcav2.zzimg.name));
            }
            this.zzaug().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzaug().endTransaction();
        }
    }

    @WorkerThread
    public final byte[] zza(@NonNull zzcbk zzcbk2, @Size(min=1L) String string) {
        Object object;
        this.zzwk();
        ((zzcdt)this.zzaul()).zzuj();
        zzccw.zzatv();
        zzbp.zzu((Object)((Object)zzcbk2));
        zzbp.zzgg((String)string);
        zzcgj zzcgj2 = new zzcgj();
        this.zzaug().beginTransaction();
        try {
            zzcbg zzcbg2;
            long l;
            Object object2;
            Pair<String, Boolean> pair;
            zzcar zzcar2 = this.zzaug().zziw(string);
            if (zzcar2 == null) {
                this.zzaum().zzayj().zzj("Log and bundle not available. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            if (!zzcar2.zzauy()) {
                this.zzaum().zzayj().zzj("Log and bundle disabled. package_name", string);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            object = new zzcgk();
            zzcgj2.zzizb = new zzcgk[]{object};
            object.zzizd = 1;
            object.zzizl = "android";
            object.zzch = zzcar2.getAppId();
            object.zzilu = zzcar2.zzauv();
            object.zzhts = zzcar2.zzuo();
            long l2 = zzcar2.zzauu();
            object.zzizy = l2 == Integer.MIN_VALUE ? null : Integer.valueOf((int)l2);
            object.zzizp = zzcar2.zzauw();
            object.zzilt = zzcar2.getGmpAppId();
            object.zzizu = zzcar2.zzaux();
            if (this.isEnabled() && zzcax.zzaxi() && this.zzisr.zziu(object.zzch)) {
                this.zzaub();
                object.zzjae = null;
            }
            if ((pair = this.zzaun().zzjh(zzcar2.getAppId())) != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
                object.zzizr = (String)pair.first;
                object.zzizs = (Boolean)pair.second;
            }
            this.zzauc().zzwk();
            object.zzizm = Build.MODEL;
            this.zzauc().zzwk();
            object.zzcv = Build.VERSION.RELEASE;
            object.zzizo = (int)this.zzauc().zzaxx();
            object.zzizn = this.zzauc().zzaxy();
            object.zzizt = zzcar2.getAppInstanceId();
            object.zzimb = zzcar2.zzaur();
            List<zzcfv> list = this.zzaug().zziv(zzcar2.getAppId());
            object.zzizf = new zzcgm[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                object2 = new zzcgm();
                object.zzizf[i] = object2;
                ((zzcgm)((Object)object2)).name = list.get((int)i).mName;
                ((zzcgm)((Object)object2)).zzjai = list.get((int)i).zzixc;
                this.zzaui().zza((zzcgm)((Object)object2), list.get((int)i).mValue);
            }
            Bundle bundle = zzcbk2.zzinq.zzaya();
            if ("_iap".equals(zzcbk2.name)) {
                bundle.putLong("_c", 1L);
                this.zzaum().zzayj().log("Marking in-app purchase as real-time");
                bundle.putLong("_r", 1L);
            }
            bundle.putString("_o", zzcbk2.zzimf);
            if (this.zzaui().zzke(object.zzch)) {
                this.zzaui().zza(bundle, "_dbg", 1L);
                this.zzaui().zza(bundle, "_r", 1L);
            }
            if ((object2 = this.zzaug().zzaf(string, zzcbk2.name)) == null) {
                l = 0L;
                zzcbg2 = new zzcbg(string, zzcbk2.name, 1L, 0L, zzcbk2.zzinr);
                this.zzaug().zza(zzcbg2);
            } else {
                l = ((zzcbg)object2).zzinm;
                zzcbg2 = ((zzcbg)object2).zzbb(zzcbk2.zzinr).zzaxz();
                this.zzaug().zza(zzcbg2);
            }
            zzcbf zzcbf2 = new zzcbf(this, zzcbk2.zzimf, string, zzcbk2.name, zzcbk2.zzinr, l, bundle);
            zzcgh zzcgh2 = new zzcgh();
            object.zzize = new zzcgh[]{zzcgh2};
            zzcgh2.zziyx = zzcbf2.zzfdb;
            zzcgh2.name = zzcbf2.mName;
            zzcgh2.zziyy = zzcbf2.zzini;
            zzcgh2.zziyw = new zzcgi[zzcbf2.zzinj.size()];
            int n = 0;
            for (String string2 : zzcbf2.zzinj) {
                zzcgi zzcgi2 = new zzcgi();
                zzcgh2.zziyw[n++] = zzcgi2;
                zzcgi2.name = string2;
                Object object3 = zzcbf2.zzinj.get(string2);
                this.zzaui().zza(zzcgi2, object3);
            }
            object.zzizx = this.zza(zzcar2.getAppId(), object.zzizf, object.zzize);
            object.zzizh = zzcgh2.zziyx;
            object.zzizi = zzcgh2.zziyx;
            long l3 = zzcar2.zzaut();
            object.zzizk = l3 != 0L ? Long.valueOf(l3) : null;
            long l4 = zzcar2.zzaus();
            if (l4 == 0L) {
                l4 = l3;
            }
            object.zzizj = l4 != 0L ? Long.valueOf(l4) : null;
            zzcar2.zzavc();
            object.zzizv = (int)zzcar2.zzauz();
            object.zzizq = zzcax.zzauw();
            object.zzizg = this.zzasb.currentTimeMillis();
            object.zzizw = Boolean.TRUE;
            zzcar2.zzal(object.zzizh);
            zzcar2.zzam(object.zzizi);
            this.zzaug().zza(zzcar2);
            this.zzaug().setTransactionSuccessful();
        }
        finally {
            this.zzaug().endTransaction();
        }
        try {
            byte[] byArray = new byte[zzcgj2.zzhi()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzegy zzegy2 = zzegy.zzi((byte[])byArray, (int)0, (int)byArray2.length);
            zzcgj2.zza(zzegy2);
            zzegy2.zzccm();
            return this.zzaui().zzo((byte[])object);
        }
        catch (IOException iOException) {
            this.zzaum().zzaye().zze("Data loss. Failed to bundle and serialize. appId", zzcbw.zzjf(string), iOException);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void zza(zzcbf var1_1, zzcas var2_2) {
        block15: {
            this.zzaul().zzuj();
            this.zzwk();
            zzbp.zzu((Object)var1_1);
            zzbp.zzu((Object)var2_2);
            zzbp.zzgg((String)var1_1.mAppId);
            zzbp.zzbh((boolean)var1_1.mAppId.equals(var2_2.packageName));
            var3_3 = new zzcgk();
            new zzcgk().zzizd = 1;
            var3_3.zzizl = "android";
            var3_3.zzch = var2_2.packageName;
            var3_3.zzilu = var2_2.zzilu;
            var3_3.zzhts = var2_2.zzhts;
            var3_3.zzizy = var2_2.zzima == -2147483648L ? null : Integer.valueOf((int)var2_2.zzima);
            var3_3.zzizp = var2_2.zzilv;
            var3_3.zzilt = var2_2.zzilt;
            var3_3.zzizu = var2_2.zzilw == 0L ? null : Long.valueOf(var2_2.zzilw);
            var4_4 = this.zzaun().zzjh(var2_2.packageName);
            if (var4_4 != null && !TextUtils.isEmpty((CharSequence)((CharSequence)var4_4.first))) {
                var3_3.zzizr = (String)var4_4.first;
                var3_3.zzizs = (Boolean)var4_4.second;
            } else if (!this.zzauc().zzdm(this.mContext)) {
                var5_5 = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
                if (var5_5 == null) {
                    this.zzaum().zzayg().zzj("null secure ID. appId", zzcbw.zzjf(var3_3.zzch));
                    var5_5 = "null";
                } else if (var5_5.isEmpty()) {
                    this.zzaum().zzayg().zzj("empty secure ID. appId", zzcbw.zzjf(var3_3.zzch));
                }
                var3_3.zzjab = var5_5;
            }
            this.zzauc().zzwk();
            var3_3.zzizm = Build.MODEL;
            this.zzauc().zzwk();
            var3_3.zzcv = Build.VERSION.RELEASE;
            var3_3.zzizo = (int)this.zzauc().zzaxx();
            var3_3.zzizn = this.zzauc().zzaxy();
            var3_3.zzizq = null;
            var3_3.zzizg = null;
            var3_3.zzizh = null;
            var3_3.zzizi = null;
            var3_3.zzjad = var2_2.zzimc;
            if (this.isEnabled() && zzcax.zzaxi()) {
                this.zzaub();
                var3_3.zzjae = null;
            }
            if ((var5_5 = this.zzaug().zziw(var2_2.packageName)) == null) {
                var5_5 = new zzcar(this, var2_2.packageName);
                var5_5.zzim(this.zzaub().zzayb());
                var5_5.zzip(var2_2.zzimb);
                var5_5.zzin(var2_2.zzilt);
                var5_5.zzio(this.zzaun().zzji(var2_2.packageName));
                var5_5.zzaq(0L);
                var5_5.zzal(0L);
                var5_5.zzam(0L);
                var5_5.setAppVersion(var2_2.zzhts);
                var5_5.zzan(var2_2.zzima);
                var5_5.zziq(var2_2.zzilu);
                var5_5.zzao(var2_2.zzilv);
                var5_5.zzap(var2_2.zzilw);
                var5_5.setMeasurementEnabled(var2_2.zzily);
                var5_5.zzaz(var2_2.zzimc);
                this.zzaug().zza((zzcar)var5_5);
            }
            var3_3.zzizt = var5_5.getAppInstanceId();
            var3_3.zzimb = var5_5.zzaur();
            var6_6 = this.zzaug().zziv(var2_2.packageName);
            var3_3.zzizf = new zzcgm[var6_6.size()];
            for (var7_7 = 0; var7_7 < var6_6.size(); ++var7_7) {
                var3_3.zzizf[var7_7] = var8_9 = new zzcgm();
                var8_9.name = var6_6.get((int)var7_7).mName;
                var8_9.zzjai = var6_6.get((int)var7_7).zzixc;
                this.zzaui().zza(var8_9, var6_6.get((int)var7_7).mValue);
            }
            try {
                var7_8 = this.zzaug().zza(var3_3);
            }
            catch (IOException var9_10) {
                this.zzaum().zzaye().zze("Data loss. Failed to insert raw event metadata. appId", zzcbw.zzjf(var3_3.zzch), var9_10);
                return;
            }
            v0 = this.zzaug();
            var11_11 = var1_1;
            var10_12 = this;
            if (var11_11.zzinj == null) ** GOTO lbl-1000
            for (Object var13_15 : var11_11.zzinj) {
                if (!"_r".equals(var13_15)) continue;
                v1 = true;
                break block15;
            }
            var12_14 = var10_12.zzauj().zzap(var11_11.mAppId, var11_11.mName);
            var13_15 = var10_12.zzaug().zza(var10_12.zzazg(), var11_11.mAppId, false, false, false, false, false);
            if (var12_14 && var13_15.zzinb < (long)var10_12.zzisr.zzis(var11_11.mAppId)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
        }
        if (v0.zza(var1_1, var7_8, v1)) {
            this.zzitx = 0L;
        }
    }

    public final String zzjs(String string) {
        Future<String> future = this.zzaul().zzd(new zzccy(this, string));
        try {
            return future.get(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zzaum().zzaye().zze("Failed to get app instance id. appId", zzcbw.zzjf(string), exception);
            return null;
        }
    }

    static void zzatv() {
        zzcax.zzawl();
        throw new IllegalStateException("Unexpected call on client side");
    }

    @WorkerThread
    final void zzb(zzcft zzcft2, zzcas zzcas2) {
        ((zzcdt)this.zzaul()).zzuj();
        this.zzwk();
        if (TextUtils.isEmpty((CharSequence)zzcas2.zzilt)) {
            return;
        }
        if (!zzcas2.zzily) {
            this.zzf(zzcas2);
            return;
        }
        int n = this.zzaui().zzjy(zzcft2.name);
        if (n != 0) {
            this.zzaui();
            String string = zzcfw.zza(zzcft2.name, zzcax.zzavp(), true);
            int n2 = zzcft2.name != null ? zzcft2.name.length() : 0;
            this.zzaui().zza(zzcas2.packageName, n, "_ev", string, n2);
            return;
        }
        n = this.zzaui().zzl(zzcft2.name, zzcft2.getValue());
        if (n != 0) {
            this.zzaui();
            String string = zzcfw.zza(zzcft2.name, zzcax.zzavp(), true);
            Object object = zzcft2.getValue();
            int n3 = 0;
            if (object != null && (object instanceof String || object instanceof CharSequence)) {
                n3 = String.valueOf(object).length();
            }
            this.zzaui().zza(zzcas2.packageName, n, "_ev", string, n3);
            return;
        }
        Object object = this.zzaui().zzm(zzcft2.name, zzcft2.getValue());
        if (object == null) {
            return;
        }
        zzcfv zzcfv2 = new zzcfv(zzcas2.packageName, zzcft2.zzimf, zzcft2.name, zzcft2.zziwy, object);
        this.zzaum().zzayj().zze("Setting user property", this.zzauh().zzje(zzcfv2.mName), object);
        this.zzaug().beginTransaction();
        try {
            this.zzf(zzcas2);
            boolean bl = this.zzaug().zza(zzcfv2);
            this.zzaug().setTransactionSuccessful();
            if (bl) {
                this.zzaum().zzayj().zze("User property set", this.zzauh().zzje(zzcfv2.mName), zzcfv2.mValue);
            } else {
                this.zzaum().zzaye().zze("Too many unique user properties are set. Ignoring user property", this.zzauh().zzje(zzcfv2.mName), zzcfv2.mValue);
                this.zzaui().zza(zzcas2.packageName, 9, null, null, 0);
            }
            return;
        }
        finally {
            this.zzaug().endTransaction();
        }
    }

    @WorkerThread
    final void zzc(zzcft zzcft2, zzcas zzcas2) {
        ((zzcdt)this.zzaul()).zzuj();
        this.zzwk();
        if (TextUtils.isEmpty((CharSequence)zzcas2.zzilt)) {
            return;
        }
        if (!zzcas2.zzily) {
            this.zzf(zzcas2);
            return;
        }
        this.zzaum().zzayj().zzj("Removing user property", this.zzauh().zzje(zzcft2.name));
        this.zzaug().beginTransaction();
        try {
            this.zzf(zzcas2);
            this.zzaug().zzag(zzcas2.packageName, zzcft2.name);
            this.zzaug().setTransactionSuccessful();
            this.zzaum().zzayj().zzj("User property removed", this.zzauh().zzje(zzcft2.name));
            return;
        }
        finally {
            this.zzaug().endTransaction();
        }
    }

    @WorkerThread
    public final void zzazh() {
        ((zzcdt)this.zzaul()).zzuj();
        this.zzwk();
        this.zziua = true;
        try {
            String string;
            zzcax.zzawl();
            Boolean bl = this.zzaun().zzayp();
            if (bl == null) {
                this.zzaum().zzayg().log("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzaum().zzaye().log("Upload called in the client side when service should be used");
                return;
            }
            if (this.zzitx > 0L) {
                this.zzazj();
                return;
            }
            Object object = this;
            ((zzcdt)((zzccw)object).zzaul()).zzuj();
            if (((zzccw)object).zzits != null) {
                this.zzaum().zzayk().log("Uploading requested multiple times");
                return;
            }
            if (!this.zzazb().zzyx()) {
                this.zzaum().zzayk().log("Network not connected, ignoring upload request");
                this.zzazj();
                return;
            }
            long l = this.zzasb.currentTimeMillis();
            long l2 = l - zzcax.zzaww();
            this.zzg(null, l2);
            long l3 = this.zzaun().zziqo.get();
            if (l3 != 0L) {
                this.zzaum().zzayj().zzj("Uploading events. Elapsed time since last upload attempt (ms)", Math.abs(l - l3));
            }
            if (!TextUtils.isEmpty((CharSequence)(string = this.zzaug().zzaxj()))) {
                if (this.zzitw == -1L) {
                    this.zzitw = this.zzaug().zzaxq();
                }
                Object object2 = string;
                int n = this.zzisr.zzb((String)object2, zzcbm.zziog);
                object2 = string;
                object = this.zzisr;
                int n2 = Math.max(0, ((zzcax)object).zzb((String)object2, zzcbm.zzioh));
                List<Pair<zzcgk, Long>> list = this.zzaug().zzl(string, n, n2);
                if (!list.isEmpty()) {
                    Object object3;
                    String string2 = null;
                    Object object4 = list.iterator();
                    while (object4.hasNext()) {
                        zzcgk zzcgk2 = (zzcgk)((Object)object4.next().first);
                        if (TextUtils.isEmpty((CharSequence)zzcgk2.zzizr)) continue;
                        string2 = zzcgk2.zzizr;
                        break;
                    }
                    if (string2 != null) {
                        for (int i = 0; i < list.size(); ++i) {
                            object3 = (zzcgk)((Object)list.get((int)i).first);
                            if (TextUtils.isEmpty((CharSequence)((zzcgk)((Object)object3)).zzizr) || ((zzcgk)((Object)object3)).zzizr.equals(string2)) continue;
                            list = list.subList(0, i);
                            break;
                        }
                    }
                    object4 = new zzcgj();
                    new zzcgj().zzizb = new zzcgk[list.size()];
                    object3 = new ArrayList(list.size());
                    boolean bl2 = zzcax.zzaxi() && this.zzisr.zziu(string);
                    for (int i = 0; i < ((zzcgj)((Object)object4)).zzizb.length; ++i) {
                        ((zzcgj)((Object)object4)).zzizb[i] = (zzcgk)((Object)list.get((int)i).first);
                        object3.add((Long)list.get((int)i).second);
                        ((zzcgj)((Object)object4)).zzizb[i].zzizq = zzcax.zzauw();
                        ((zzcgj)((Object)object4)).zzizb[i].zzizg = l;
                        ((zzcgj)((Object)object4)).zzizb[i].zzizw = zzcax.zzawl();
                        if (bl2) continue;
                        ((zzcgj)((Object)object4)).zzizb[i].zzjae = null;
                    }
                    String string3 = null;
                    if (this.zzaum().zzad(2)) {
                        string3 = this.zzauh().zza((zzcgj)((Object)object4));
                    }
                    byte[] byArray = this.zzaui().zzb((zzcgj)((Object)object4));
                    String string4 = zzcax.zzawv();
                    try {
                        URL uRL = new URL(string4);
                        object2 = object3;
                        object = this;
                        zzbp.zzbh((!object2.isEmpty() ? 1 : 0) != 0);
                        if (((zzccw)object).zzits != null) {
                            ((zzccw)object).zzaum().zzaye().log("Set uploading progress before finishing the previous upload");
                        } else {
                            ((zzccw)object).zzits = new ArrayList<Long>((Collection<Long>)object2);
                        }
                        this.zzaun().zziqp.set(l);
                        String string5 = "?";
                        if (((zzcgj)((Object)object4)).zzizb.length > 0) {
                            string5 = ((zzcgj)((Object)object4)).zzizb[0].zzch;
                        }
                        this.zzaum().zzayk().zzd("Uploading data. app, uncompressed size, data", string5, byArray.length, string3);
                        this.zzitz = true;
                        zzccz zzccz2 = new zzccz(this);
                        byte[] byArray2 = byArray;
                        URL uRL2 = uRL;
                        object2 = string;
                        object = this.zzazb();
                        ((zzcdt)object).zzuj();
                        ((zzcdu)object).zzwk();
                        zzbp.zzu((Object)uRL2);
                        zzbp.zzu((Object)byArray2);
                        zzbp.zzu((Object)zzccz2);
                        ((zzcdt)object).zzaul().zzh(new zzcce((zzcca)object, (String)object2, uRL2, byArray2, null, zzccz2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.zzaum().zzaye().zze("Failed to parse upload URL. Not uploading. appId", zzcbw.zzjf(string), string4);
                    }
                }
            } else {
                zzcar zzcar2;
                this.zzitw = -1L;
                String string6 = this.zzaug().zzba(l - zzcax.zzaww());
                if (!TextUtils.isEmpty((CharSequence)string6) && (zzcar2 = this.zzaug().zziw(string6)) != null) {
                    this.zzb(zzcar2);
                }
            }
            return;
        }
        finally {
            this.zziua = false;
            this.zzazn();
        }
    }

    @WorkerThread
    private final void zzb(zzcar zzcar2) {
        ((zzcdt)this.zzaul()).zzuj();
        if (TextUtils.isEmpty((CharSequence)zzcar2.getGmpAppId())) {
            this.zzb(zzcar2.getAppId(), 204, null, null, null);
            return;
        }
        Object object = zzcar2.getAppInstanceId();
        String string = zzcar2.getGmpAppId();
        Uri.Builder builder = new Uri.Builder();
        String string2 = String.valueOf(string);
        builder.scheme(zzcbm.zzioe.get()).encodedAuthority(zzcbm.zziof.get()).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", (String)object).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "11400");
        String string3 = builder.build().toString();
        try {
            URL uRL = new URL(string3);
            this.zzaum().zzayk().zzj("Fetching remote configuration", zzcar2.getAppId());
            zzcge zzcge2 = this.zzauj().zzjn(zzcar2.getAppId());
            ArrayMap arrayMap = null;
            String string4 = this.zzauj().zzjo(zzcar2.getAppId());
            if (zzcge2 != null && !TextUtils.isEmpty((CharSequence)string4)) {
                arrayMap = new ArrayMap();
                arrayMap.put("If-Modified-Since", string4);
            }
            this.zzity = true;
            zzcda zzcda2 = new zzcda(this);
            builder = arrayMap;
            object = uRL;
            string = zzcar2.getAppId();
            zzcca zzcca2 = this.zzazb();
            ((zzcdt)zzcca2).zzuj();
            zzcca2.zzwk();
            zzbp.zzu((Object)object);
            zzbp.zzu((Object)zzcda2);
            ((zzcdt)zzcca2).zzaul().zzh(new zzcce(zzcca2, string, (URL)object, null, (Map)builder, zzcda2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            this.zzaum().zzaye().zze("Failed to parse config URL. Not fetching. appId", zzcbw.zzjf(zzcar2.getAppId()), string3);
            return;
        }
    }

    private final boolean zzg(String string, long l) {
        this.zzaug().beginTransaction();
        try {
            block69: {
                int n;
                Object object;
                String string2;
                zza zza2;
                block68: {
                    zza zza3 = zza2 = new zza(this, null);
                    long l2 = this.zzitw;
                    long l3 = l;
                    string2 = null;
                    object = this.zzaug();
                    zzbp.zzu((Object)zza3);
                    ((zzcdt)object).zzuj();
                    ((zzcdu)object).zzwk();
                    try (Cursor cursor = null;){
                        String[] stringArray;
                        String string3;
                        String string4;
                        String string5;
                        String[] stringArray2;
                        SQLiteDatabase sQLiteDatabase = ((zzcay)object).getWritableDatabase();
                        if (TextUtils.isEmpty(null)) {
                            stringArray2 = l2 != -1L ? new String[]{String.valueOf(l2), String.valueOf(l3)} : new String[]{String.valueOf(l3)};
                            string5 = l2 != -1L ? "rowid <= ? and " : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(148 + String.valueOf(string5).length()).append("select app_id, metadata_fingerprint from raw_events where ").append(string5).append("app_id in (select app_id from apps where config_fetched_time >= ?) order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block68;
                            string2 = cursor.getString(0);
                            string4 = cursor.getString(1);
                            cursor.close();
                        } else {
                            stringArray2 = l2 != -1L ? new String[]{null, String.valueOf(l2)} : new String[]{null};
                            string5 = l2 != -1L ? " and rowid <= ?" : "";
                            cursor = sQLiteDatabase.rawQuery(new StringBuilder(84 + String.valueOf(string5).length()).append("select metadata_fingerprint from raw_events where app_id = ?").append(string5).append(" order by rowid limit 1;").toString(), stringArray2);
                            if (!cursor.moveToFirst()) break block68;
                            string4 = cursor.getString(0);
                            cursor.close();
                        }
                        cursor = sQLiteDatabase.query("raw_events_metadata", new String[]{"metadata"}, "app_id = ? and metadata_fingerprint = ?", new String[]{string2, string4}, null, null, "rowid", "2");
                        if (!cursor.moveToFirst()) {
                            ((zzcdt)object).zzaum().zzaye().zzj("Raw event metadata record is missing. appId", zzcbw.zzjf(string2));
                            break block68;
                        }
                        byte[] byArray = cursor.getBlob(0);
                        string5 = zzegx.zzh((byte[])byArray, (int)0, (int)byArray.length);
                        zzcgk zzcgk2 = new zzcgk();
                        try {
                            zzcgk2.zza((zzegx)string5);
                        }
                        catch (IOException iOException) {
                            ((zzcdt)object).zzaum().zzaye().zze("Data loss. Failed to merge raw event metadata. appId", zzcbw.zzjf(string2), iOException);
                            if (cursor != null) {
                                cursor.close();
                            }
                            break block68;
                        }
                        if (cursor.moveToNext()) {
                            ((zzcdt)object).zzaum().zzayg().zzj("Get multiple raw event metadata records, expected one. appId", zzcbw.zzjf(string2));
                        }
                        cursor.close();
                        zza3.zzb(zzcgk2);
                        if (l2 != -1L) {
                            string3 = "app_id = ? and metadata_fingerprint = ? and rowid <= ?";
                            stringArray = new String[]{string2, string4, String.valueOf(l2)};
                        } else {
                            string3 = "app_id = ? and metadata_fingerprint = ?";
                            stringArray = new String[]{string2, string4};
                        }
                        cursor = sQLiteDatabase.query("raw_events", new String[]{"rowid", "name", "timestamp", "data"}, string3, stringArray, null, null, "rowid", null);
                        if (!cursor.moveToFirst()) {
                            ((zzcdt)object).zzaum().zzayg().zzj("Raw event data disappeared while in transaction. appId", zzcbw.zzjf(string2));
                            break block68;
                        }
                        do {
                            long l4 = cursor.getLong(0);
                            byArray = cursor.getBlob(3);
                            string5 = zzegx.zzh((byte[])byArray, (int)0, (int)byArray.length);
                            zzcgh zzcgh2 = new zzcgh();
                            try {
                                zzcgh2.zza((zzegx)string5);
                            }
                            catch (IOException iOException) {
                                ((zzcdt)object).zzaum().zzaye().zze("Data loss. Failed to merge raw event. appId", zzcbw.zzjf(string2), iOException);
                                continue;
                            }
                            zzcgh2.name = cursor.getString(1);
                            zzcgh2.zziyx = cursor.getLong(2);
                            if (!zza3.zza(l4, zzcgh2)) break;
                        } while (cursor.moveToNext());
                    }
                }
                object = zza2;
                if (((zza)object).zzaob == null || ((zza)object).zzaob.isEmpty()) break block69;
                boolean bl = false;
                zzcgk zzcgk3 = zza2.zziud;
                zza2.zziud.zzize = new zzcgh[zza2.zzaob.size()];
                int n2 = 0;
                for (n = 0; n < zza2.zzaob.size(); ++n) {
                    block71: {
                        zzcgi[] zzcgiArray;
                        int n3;
                        boolean bl2;
                        boolean bl3;
                        block70: {
                            bl3 = bl;
                            if (this.zzauj().zzao(zza2.zziud.zzch, zza2.zzaob.get((int)n).name)) {
                                this.zzaum().zzayg().zze("Dropping blacklisted raw event. appId", zzcbw.zzjf(zza2.zziud.zzch), this.zzauh().zzjc(zza2.zzaob.get((int)n).name));
                                if (this.zzaui().zzkg(zza2.zziud.zzch) || this.zzaui().zzkh(zza2.zziud.zzch) || "_err".equals(zza2.zzaob.get((int)n).name)) continue;
                                this.zzaui().zza(zza2.zziud.zzch, 11, "_ev", zza2.zzaob.get((int)n).name, 0);
                                continue;
                            }
                            bl2 = this.zzauj().zzap(zza2.zziud.zzch, zza2.zzaob.get((int)n).name);
                            if (bl2) break block70;
                            this.zzaui();
                            if (!zzcfw.zzki(zza2.zzaob.get((int)n).name)) break block71;
                        }
                        boolean bl4 = false;
                        boolean bl5 = false;
                        if (zza2.zzaob.get((int)n).zziyw == null) {
                            zza2.zzaob.get((int)n).zziyw = new zzcgi[0];
                        }
                        zzcgi[] zzcgiArray2 = zza2.zzaob.get((int)n).zziyw;
                        int n4 = zza2.zzaob.get((int)n).zziyw.length;
                        for (n3 = 0; n3 < n4; ++n3) {
                            zzcgiArray = zzcgiArray2[n3];
                            if ("_c".equals(zzcgiArray.name)) {
                                zzcgiArray.zziza = 1L;
                                bl4 = true;
                                continue;
                            }
                            if (!"_r".equals(zzcgiArray.name)) continue;
                            zzcgiArray.zziza = 1L;
                            bl5 = true;
                        }
                        if (!bl4 && bl2) {
                            this.zzaum().zzayk().zzj("Marking event as conversion", this.zzauh().zzjc(zza2.zzaob.get((int)n).name));
                            zzcgiArray2 = Arrays.copyOf(zza2.zzaob.get((int)n).zziyw, zza2.zzaob.get((int)n).zziyw.length + 1);
                            zzcgi zzcgi2 = new zzcgi();
                            new zzcgi().name = "_c";
                            zzcgi2.zziza = 1L;
                            zzcgiArray2[zzcgiArray2.length - 1] = zzcgi2;
                            zza2.zzaob.get((int)n).zziyw = zzcgiArray2;
                        }
                        if (!bl5) {
                            this.zzaum().zzayk().zzj("Marking event as real-time", this.zzauh().zzjc(zza2.zzaob.get((int)n).name));
                            zzcgiArray2 = Arrays.copyOf(zza2.zzaob.get((int)n).zziyw, zza2.zzaob.get((int)n).zziyw.length + 1);
                            zzcgi zzcgi3 = new zzcgi();
                            new zzcgi().name = "_r";
                            zzcgi3.zziza = 1L;
                            zzcgiArray2[zzcgiArray2.length - 1] = zzcgi3;
                            zza2.zzaob.get((int)n).zziyw = zzcgiArray2;
                        }
                        bl = true;
                        if (this.zzaug().zza((long)this.zzazg(), (String)zza2.zziud.zzch, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true).zzinb > (long)this.zzisr.zzis(zza2.zziud.zzch)) {
                            zzcgh zzcgh3 = zza2.zzaob.get(n);
                            for (n3 = 0; n3 < zzcgh3.zziyw.length; ++n3) {
                                if (!"_r".equals(zzcgh3.zziyw[n3].name)) continue;
                                zzcgiArray = new zzcgi[zzcgh3.zziyw.length - 1];
                                if (n3 > 0) {
                                    System.arraycopy(zzcgh3.zziyw, 0, zzcgiArray, 0, n3);
                                }
                                if (n3 < zzcgiArray.length) {
                                    System.arraycopy(zzcgh3.zziyw, n3 + 1, zzcgiArray, n3, zzcgiArray.length - n3);
                                }
                                zzcgh3.zziyw = zzcgiArray;
                                break;
                            }
                            bl = bl3;
                        }
                        if (zzcfw.zzju(zza2.zzaob.get((int)n).name) && bl2 && this.zzaug().zza((long)this.zzazg(), (String)zza2.zziud.zzch, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false).zzimz > (long)this.zzisr.zzb(string2 = zza2.zziud.zzch, zzcbm.zzion)) {
                            this.zzaum().zzayg().zzj("Too many conversions. Not logging as conversion. appId", zzcbw.zzjf(zza2.zziud.zzch));
                            zzcgh zzcgh4 = zza2.zzaob.get(n);
                            boolean bl6 = false;
                            zzcgi zzcgi4 = null;
                            zzcgi[] zzcgiArray3 = zzcgh4.zziyw;
                            int n5 = zzcgh4.zziyw.length;
                            for (int i = 0; i < n5; ++i) {
                                zzcgi zzcgi5 = zzcgiArray3[i];
                                if ("_c".equals(zzcgi5.name)) {
                                    zzcgi4 = zzcgi5;
                                    continue;
                                }
                                if (!"_err".equals(zzcgi5.name)) continue;
                                bl6 = true;
                            }
                            if (bl6 && zzcgi4 != null) {
                                zzcgiArray3 = new zzcgi[zzcgh4.zziyw.length - 1];
                                n5 = 0;
                                zzcgi[] zzcgiArray4 = zzcgh4.zziyw;
                                int n6 = zzcgh4.zziyw.length;
                                for (int i = 0; i < n6; ++i) {
                                    zzcgi zzcgi6 = zzcgiArray4[i];
                                    if (zzcgi6 == zzcgi4) continue;
                                    zzcgiArray3[n5++] = zzcgi6;
                                }
                                zzcgh4.zziyw = zzcgiArray3;
                            } else if (zzcgi4 != null) {
                                zzcgi4.name = "_err";
                                zzcgi4.zziza = 10L;
                            } else {
                                this.zzaum().zzaye().zzj("Did not find conversion parameter. appId", zzcbw.zzjf(zza2.zziud.zzch));
                            }
                        }
                    }
                    zzcgk3.zzize[n2++] = zza2.zzaob.get(n);
                }
                if (n2 < zza2.zzaob.size()) {
                    zzcgk3.zzize = Arrays.copyOf(zzcgk3.zzize, n2);
                }
                zzcgk3.zzizx = this.zza(zza2.zziud.zzch, zza2.zziud.zzizf, zzcgk3.zzize);
                zzcgk3.zzizh = Long.MAX_VALUE;
                zzcgk3.zzizi = Long.MIN_VALUE;
                for (n = 0; n < zzcgk3.zzize.length; ++n) {
                    zzcgh zzcgh5 = zzcgk3.zzize[n];
                    if (zzcgh5.zziyx < zzcgk3.zzizh) {
                        zzcgk3.zzizh = zzcgh5.zziyx;
                    }
                    if (zzcgh5.zziyx <= zzcgk3.zzizi) continue;
                    zzcgk3.zzizi = zzcgh5.zziyx;
                }
                String string6 = zza2.zziud.zzch;
                zzcar zzcar2 = this.zzaug().zziw(string6);
                if (zzcar2 == null) {
                    this.zzaum().zzaye().zzj("Bundling raw events w/o app info. appId", zzcbw.zzjf(zza2.zziud.zzch));
                } else if (zzcgk3.zzize.length > 0) {
                    long l5 = zzcar2.zzaut();
                    zzcgk3.zzizk = l5 != 0L ? Long.valueOf(l5) : null;
                    long l6 = zzcar2.zzaus();
                    if (l6 == 0L) {
                        l6 = l5;
                    }
                    zzcgk3.zzizj = l6 != 0L ? Long.valueOf(l6) : null;
                    zzcar2.zzavc();
                    zzcgk3.zzizv = (int)zzcar2.zzauz();
                    zzcar2.zzal(zzcgk3.zzizh);
                    zzcar2.zzam(zzcgk3.zzizi);
                    zzcgk3.zzilx = zzcar2.zzavk();
                    this.zzaug().zza(zzcar2);
                }
                if (zzcgk3.zzize.length > 0) {
                    zzcax.zzawl();
                    zzcge zzcge2 = this.zzauj().zzjn(zza2.zziud.zzch);
                    if (zzcge2 == null || zzcge2.zziyl == null) {
                        if (TextUtils.isEmpty((CharSequence)zza2.zziud.zzilt)) {
                            zzcgk3.zzjac = -1L;
                        } else {
                            this.zzaum().zzayg().zzj("Did not find measurement config or missing version info. appId", zzcbw.zzjf(zza2.zziud.zzch));
                        }
                    } else {
                        zzcgk3.zzjac = zzcge2.zziyl;
                    }
                    this.zzaug().zza(zzcgk3, bl);
                }
                this.zzaug().zzae(zza2.zziue);
                string2 = string6;
                object = this.zzaug();
                SQLiteDatabase sQLiteDatabase = ((zzcay)object).getWritableDatabase();
                try {
                    sQLiteDatabase.execSQL("delete from raw_events_metadata where app_id=? and metadata_fingerprint not in (select distinct metadata_fingerprint from raw_events where app_id=?)", (Object[])new String[]{string2, string2});
                }
                catch (SQLiteException sQLiteException) {
                    ((zzcdt)object).zzaum().zzaye().zze("Failed to remove unused event metadata. appId", zzcbw.zzjf(string2), (Object)sQLiteException);
                }
                this.zzaug().setTransactionSuccessful();
                boolean bl7 = zzcgk3.zzize.length > 0;
                return bl7;
            }
            this.zzaug().setTransactionSuccessful();
            return false;
        }
        finally {
            this.zzaug().endTransaction();
        }
    }

    private final zzcgg[] zza(String string, zzcgm[] zzcgmArray, zzcgh[] zzcghArray) {
        zzbp.zzgg((String)string);
        return this.zzatz().zza(string, zzcghArray, zzcgmArray);
    }

    @WorkerThread
    final void zzb(String string, int n, Throwable throwable, byte[] byArray, Map<String, List<String>> map) {
        ((zzcdt)this.zzaul()).zzuj();
        this.zzwk();
        zzbp.zzgg((String)string);
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            this.zzaum().zzayk().zzj("onConfigFetched. Response size", byArray.length);
            this.zzaug().beginTransaction();
            try {
                boolean bl;
                zzcar zzcar2 = this.zzaug().zziw(string);
                boolean bl2 = bl = (n == 200 || n == 204 || n == 304) && throwable == null;
                if (zzcar2 == null) {
                    this.zzaum().zzayg().zzj("App does not exist in onConfigFetched. appId", zzcbw.zzjf(string));
                } else if (bl || n == 404) {
                    String string2;
                    List<String> list = map != null ? map.get("Last-Modified") : null;
                    String string3 = string2 = list != null && list.size() > 0 ? list.get(0) : null;
                    if (n == 404 || n == 304 ? this.zzauj().zzjn(string) == null && !this.zzauj().zzb(string, null, null) : !this.zzauj().zzb(string, byArray, string2)) {
                        return;
                    }
                    zzcar2.zzar(this.zzasb.currentTimeMillis());
                    this.zzaug().zza(zzcar2);
                    if (n == 404) {
                        this.zzaum().zzayh().zzj("Config not found. Using empty config. appId", string);
                    } else {
                        this.zzaum().zzayk().zze("Successfully fetched config. Got network response. code, size", n, byArray.length);
                    }
                    if (this.zzazb().zzyx() && this.zzazi()) {
                        this.zzazh();
                    } else {
                        this.zzazj();
                    }
                } else {
                    zzcar2.zzas(this.zzasb.currentTimeMillis());
                    this.zzaug().zza(zzcar2);
                    this.zzaum().zzayk().zze("Fetching config failed. code, error", n, throwable);
                    this.zzauj().zzjp(string);
                    this.zzaun().zziqp.set(this.zzasb.currentTimeMillis());
                    if (n == 503 || n == 429) {
                        this.zzaun().zziqq.set(this.zzasb.currentTimeMillis());
                    }
                    this.zzazj();
                }
                this.zzaug().setTransactionSuccessful();
            }
            finally {
                this.zzaug().endTransaction();
            }
            return;
        }
        finally {
            this.zzity = false;
            this.zzazn();
        }
    }

    @WorkerThread
    protected final void zza(int n, Throwable throwable, byte[] byArray) {
        ((zzcdt)this.zzaul()).zzuj();
        this.zzwk();
        try {
            if (byArray == null) {
                byArray = new byte[]{};
            }
            List<Long> list = this.zzits;
            this.zzits = null;
            if ((n == 200 || n == 204) && throwable == null) {
                try {
                    this.zzaun().zziqo.set(this.zzasb.currentTimeMillis());
                    this.zzaun().zziqp.set(0L);
                    this.zzazj();
                    this.zzaum().zzayk().zze("Successful upload. Got network response. code, size", n, byArray.length);
                    this.zzaug().beginTransaction();
                    try {
                        for (Long l : list) {
                            long l2 = l;
                            zzcay zzcay2 = this.zzaug();
                            zzcay2.zzuj();
                            zzcay2.zzwk();
                            SQLiteDatabase sQLiteDatabase = zzcay2.getWritableDatabase();
                            String[] stringArray = new String[]{String.valueOf(l2)};
                            try {
                                if (sQLiteDatabase.delete("queue", "rowid=?", stringArray) == 1) continue;
                                throw new SQLiteException("Deleted fewer rows from queue than expected");
                            }
                            catch (SQLiteException sQLiteException) {
                                zzcay2.zzaum().zzaye().zzj("Failed to delete a bundle in a queue table", (Object)sQLiteException);
                                throw sQLiteException;
                            }
                        }
                        this.zzaug().setTransactionSuccessful();
                    }
                    finally {
                        this.zzaug().endTransaction();
                    }
                    if (this.zzazb().zzyx() && this.zzazi()) {
                        this.zzazh();
                    } else {
                        this.zzitw = -1L;
                        this.zzazj();
                    }
                    this.zzitx = 0L;
                }
                catch (SQLiteException sQLiteException) {
                    this.zzaum().zzaye().zzj("Database error while trying to delete uploaded bundles", (Object)sQLiteException);
                    this.zzitx = this.zzasb.elapsedRealtime();
                    this.zzaum().zzayk().zzj("Disable upload, time", this.zzitx);
                }
            } else {
                this.zzaum().zzayk().zze("Network upload failed. Will retry later. code, error", n, throwable);
                this.zzaun().zziqp.set(this.zzasb.currentTimeMillis());
                if (n == 503 || n == 429) {
                    this.zzaun().zziqq.set(this.zzasb.currentTimeMillis());
                }
                this.zzazj();
            }
            return;
        }
        finally {
            this.zzitz = false;
            this.zzazn();
        }
    }

    private final boolean zzazi() {
        ((zzcdt)this.zzaul()).zzuj();
        this.zzwk();
        return this.zzaug().zzaxo() || !TextUtils.isEmpty((CharSequence)this.zzaug().zzaxj());
    }

    @WorkerThread
    private final void zzazj() {
        long l;
        long l2;
        long l3;
        block15: {
            String string;
            ((zzcdt)this.zzaul()).zzuj();
            this.zzwk();
            if (!this.zzazm()) {
                return;
            }
            if (this.zzitx > 0L) {
                l3 = this.zzasb.elapsedRealtime();
                l2 = 3600000L - Math.abs(l3 - this.zzitx);
                if (l2 > 0L) {
                    this.zzaum().zzayk().zzj("Upload has been suspended. Will update scheduling later in approximately ms", l2);
                    this.zzazc().unregister();
                    this.zzazd().cancel();
                    return;
                }
                this.zzitx = 0L;
            }
            if (!this.zzayw() || !this.zzazi()) {
                this.zzaum().zzayk().log("Nothing to upload or uploading impossible");
                this.zzazc().unregister();
                this.zzazd().cancel();
                return;
            }
            zzccw zzccw2 = this;
            long l4 = zzccw2.zzasb.currentTimeMillis();
            long l5 = zzcax.zzaxe();
            boolean bl = zzccw2.zzaug().zzaxp() || zzccw2.zzaug().zzaxk();
            long l6 = bl ? (!TextUtils.isEmpty((CharSequence)(string = zzccw2.zzisr.zzaxh())) && !".none.".equals(string) ? zzcax.zzaxa() : zzcax.zzawz()) : zzcax.zzawy();
            long l7 = zzccw2.zzaun().zziqo.get();
            long l8 = zzccw2.zzaun().zziqp.get();
            long l9 = zzccw2.zzaug().zzaxm();
            long l10 = zzccw2.zzaug().zzaxn();
            long l11 = Math.max(l9, l10);
            if (l11 == 0L) {
                l = 0L;
            } else {
                l11 = l4 - Math.abs(l11 - l4);
                l7 = l4 - Math.abs(l7 - l4);
                l8 = l4 - Math.abs(l8 - l4);
                long l12 = Math.max(l7, l8);
                long l13 = l11 + l5;
                if (bl && l12 > 0L) {
                    l13 = Math.min(l11, l12) + l6;
                }
                if (!zzccw2.zzaui().zzf(l12, l6)) {
                    l13 = l12 + l6;
                }
                if (l8 != 0L && l8 >= l11) {
                    long l14 = l13;
                    for (int i = 0; i < zzcax.zzaxg(); ++i) {
                        long l15 = 1 << i;
                        if ((l14 += zzcax.zzaxf() * l15) <= l8) continue;
                        l = l14;
                        break block15;
                    }
                    l = 0L;
                } else {
                    l = l3 = l13;
                }
            }
        }
        if (l == 0L) {
            this.zzaum().zzayk().log("Next upload time is 0");
            this.zzazc().unregister();
            this.zzazd().cancel();
            return;
        }
        if (!this.zzazb().zzyx()) {
            this.zzaum().zzayk().log("No network");
            this.zzazc().zzyu();
            this.zzazd().cancel();
            return;
        }
        l2 = this.zzaun().zziqq.get();
        long l16 = zzcax.zzawx();
        if (!this.zzaui().zzf(l2, l16)) {
            l3 = Math.max(l3, l2 + l16);
        }
        this.zzazc().unregister();
        long l17 = l3 - this.zzasb.currentTimeMillis();
        if (l17 <= 0L) {
            l17 = zzcax.zzaxb();
            this.zzaun().zziqo.set(this.zzasb.currentTimeMillis());
        }
        this.zzaum().zzayk().zzj("Upload scheduled in approximately ms", l17);
        this.zzazd().zzs(l17);
    }

    public final void zzbo(boolean bl) {
        this.zzazj();
    }

    final void zzb(zzcdu zzcdu2) {
        ++this.zzitu;
    }

    final void zzazk() {
        ++this.zzitv;
    }

    @WorkerThread
    public final void zze(zzcas zzcas2) {
        int n;
        ((zzcdt)this.zzaul()).zzuj();
        this.zzwk();
        zzbp.zzu((Object)((Object)zzcas2));
        zzbp.zzgg((String)zzcas2.packageName);
        if (TextUtils.isEmpty((CharSequence)zzcas2.zzilt)) {
            return;
        }
        zzcar zzcar2 = this.zzaug().zziw(zzcas2.packageName);
        if (zzcar2 != null && TextUtils.isEmpty((CharSequence)zzcar2.getGmpAppId()) && !TextUtils.isEmpty((CharSequence)zzcas2.zzilt)) {
            zzcar2.zzar(0L);
            this.zzaug().zza(zzcar2);
            this.zzauj().zzjq(zzcas2.packageName);
        }
        if (!zzcas2.zzily) {
            this.zzf(zzcas2);
            return;
        }
        long l = zzcas2.zzimd;
        if (l == 0L) {
            l = this.zzasb.currentTimeMillis();
        }
        if ((n = zzcas2.zzime) != 0 && n != 1) {
            this.zzaum().zzayg().zze("Incorrect app type, assuming installed app. appId, appType", zzcbw.zzjf(zzcas2.packageName), n);
            n = 0;
        }
        this.zzaug().beginTransaction();
        try {
            zzcbk zzcbk2;
            Object object;
            long l2 = l;
            zzcas zzcas3 = zzcas2;
            zzccw zzccw2 = this;
            zzcar zzcar3 = zzccw2.zzaug().zziw(zzcas3.packageName);
            if (zzcar3 != null && zzcar3.getGmpAppId() != null && !zzcar3.getGmpAppId().equals(zzcas3.zzilt)) {
                zzccw2.zzaum().zzayg().zzj("New GMP App Id passed in. Removing cached database data. appId", zzcbw.zzjf(zzcar3.getAppId()));
                String string = zzcar3.getAppId();
                zzcay zzcay2 = zzccw2.zzaug();
                zzcay2.zzwk();
                zzcay2.zzuj();
                zzbp.zzgg((String)string);
                try {
                    SQLiteDatabase sQLiteDatabase = zzcay2.getWritableDatabase();
                    String[] stringArray = new String[]{string};
                    int n2 = 0 + sQLiteDatabase.delete("events", "app_id=?", stringArray) + sQLiteDatabase.delete("user_attributes", "app_id=?", stringArray) + sQLiteDatabase.delete("conditional_properties", "app_id=?", stringArray) + sQLiteDatabase.delete("apps", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events", "app_id=?", stringArray) + sQLiteDatabase.delete("raw_events_metadata", "app_id=?", stringArray) + sQLiteDatabase.delete("event_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("property_filters", "app_id=?", stringArray) + sQLiteDatabase.delete("audience_filter_values", "app_id=?", stringArray);
                    if (n2 > 0) {
                        zzcay2.zzaum().zzayk().zze("Deleted application data. app, records", string, n2);
                    }
                }
                catch (SQLiteException sQLiteException) {
                    zzcay2.zzaum().zzaye().zze("Error deleting application data. appId, error", zzcbw.zzjf(string), (Object)sQLiteException);
                }
                zzcar3 = null;
            }
            if (zzcar3 != null && zzcar3.zzuo() != null && !zzcar3.zzuo().equals(zzcas3.zzhts)) {
                object = new Bundle();
                object.putString("_pv", zzcar3.zzuo());
                zzcbk2 = new zzcbk("_au", new zzcbh((Bundle)object), "auto", l2);
                zzccw2.zzb(zzcbk2, zzcas3);
            }
            this.zzf(zzcas2);
            zzcbg zzcbg2 = null;
            if (n == 0) {
                zzcbg2 = this.zzaug().zzaf(zzcas2.packageName, "_f");
            } else if (n == 1) {
                zzcbg2 = this.zzaug().zzaf(zzcas2.packageName, "_v");
            }
            if (zzcbg2 == null) {
                long l3 = (1L + l / 3600000L) * 3600000L;
                if (n == 0) {
                    zzbck zzbck2;
                    zzcft zzcft2 = new zzcft("_fot", l, l3, "auto");
                    this.zzb(zzcft2, zzcas2);
                    l2 = l;
                    zzcas3 = zzcas2;
                    zzccw2 = this;
                    ((zzcdt)zzccw2.zzaul()).zzuj();
                    zzccw2.zzwk();
                    zzcar3 = new Bundle();
                    zzcar3.putLong("_c", 1L);
                    zzcar3.putLong("_r", 1L);
                    zzcar3.putLong("_uwa", 0L);
                    zzcar3.putLong("_pfo", 0L);
                    zzcar3.putLong("_sys", 0L);
                    zzcar3.putLong("_sysu", 0L);
                    if (zzccw2.mContext.getPackageManager() == null) {
                        zzccw2.zzaum().zzaye().zzj("PackageManager is null, first open report might be inaccurate. appId", zzcbw.zzjf(zzcas3.packageName));
                    } else {
                        zzcbk2 = null;
                        try {
                            zzcbk2 = zzbed.zzcr((Context)zzccw2.mContext).getPackageInfo(zzcas3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzccw2.zzaum().zzaye().zze("Package info is null, first open report might be inaccurate. appId", zzcbw.zzjf(zzcas3.packageName), (Object)nameNotFoundException);
                        }
                        if (zzcbk2 != null && ((PackageInfo)zzcbk2).firstInstallTime != 0L) {
                            boolean bl = false;
                            if (((PackageInfo)zzcbk2).firstInstallTime != ((PackageInfo)zzcbk2).lastUpdateTime) {
                                zzcar3.putLong("_uwa", 1L);
                            } else {
                                bl = true;
                            }
                            zzbck2 = new zzcft("_fi", l2, bl ? 1L : 0L, "auto");
                            zzccw2.zzb((zzcft)zzbck2, zzcas3);
                        }
                        ApplicationInfo applicationInfo = null;
                        try {
                            applicationInfo = zzbed.zzcr((Context)zzccw2.mContext).getApplicationInfo(zzcas3.packageName, 0);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            zzccw2.zzaum().zzaye().zze("Application info is null, first open report might be inaccurate. appId", zzcbw.zzjf(zzcas3.packageName), (Object)nameNotFoundException);
                        }
                        if (applicationInfo != null) {
                            if ((applicationInfo.flags & 1) != 0) {
                                zzcar3.putLong("_sys", 1L);
                            }
                            if ((applicationInfo.flags & 0x80) != 0) {
                                zzcar3.putLong("_sysu", 1L);
                            }
                        }
                    }
                    String string = zzcas3.packageName;
                    zzcay zzcay3 = zzccw2.zzaug();
                    zzbp.zzgg((String)string);
                    zzcay3.zzuj();
                    zzcay3.zzwk();
                    long l4 = zzcay3.zzam(string, "first_open_count");
                    if (l4 >= 0L) {
                        zzcar3.putLong("_pfo", l4);
                    }
                    zzbck2 = new zzcbk("_f", new zzcbh((Bundle)zzcar3), "auto", l2);
                    zzccw2.zzb((zzcbk)zzbck2, zzcas3);
                } else if (n == 1) {
                    zzcft zzcft3 = new zzcft("_fvt", l, l3, "auto");
                    this.zzb(zzcft3, zzcas2);
                    l2 = l;
                    zzcas3 = zzcas2;
                    zzccw2 = this;
                    ((zzcdt)zzccw2.zzaul()).zzuj();
                    zzccw2.zzwk();
                    zzcar3 = new Bundle();
                    zzcar3.putLong("_c", 1L);
                    zzcar3.putLong("_r", 1L);
                    object = new zzcbk("_v", new zzcbh((Bundle)zzcar3), "auto", l2);
                    zzccw2.zzb((zzcbk)((Object)object), zzcas3);
                }
                l2 = l;
                zzcas3 = zzcas2;
                zzccw2 = this;
                zzcar3 = new Bundle();
                zzcar3.putLong("_et", 1L);
                object = new zzcbk("_e", new zzcbh((Bundle)zzcar3), "auto", l2);
                zzccw2.zzb((zzcbk)((Object)object), zzcas3);
            } else if (zzcas2.zzilz) {
                l2 = l;
                zzcas3 = zzcas2;
                zzccw2 = this;
                zzcar3 = new Bundle();
                object = new zzcbk("_cd", new zzcbh((Bundle)zzcar3), "auto", l2);
                zzccw2.zzb((zzcbk)((Object)object), zzcas3);
            }
            this.zzaug().setTransactionSuccessful();
            return;
        }
        finally {
            this.zzaug().endTransaction();
        }
    }

    @WorkerThread
    private final void zzf(zzcas zzcas2) {
        ((zzcdt)this.zzaul()).zzuj();
        this.zzwk();
        zzbp.zzu((Object)((Object)zzcas2));
        zzbp.zzgg((String)zzcas2.packageName);
        zzcar zzcar2 = this.zzaug().zziw(zzcas2.packageName);
        String string = this.zzaun().zzji(zzcas2.packageName);
        boolean bl = false;
        if (zzcar2 == null) {
            zzcar2 = new zzcar(this, zzcas2.packageName);
            zzcar2.zzim(this.zzaub().zzayb());
            zzcar2.zzio(string);
            bl = true;
        } else if (!string.equals(zzcar2.zzauq())) {
            zzcar2.zzio(string);
            zzcar2.zzim(this.zzaub().zzayb());
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcas2.zzilt) && !zzcas2.zzilt.equals(zzcar2.getGmpAppId())) {
            zzcar2.zzin(zzcas2.zzilt);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcas2.zzimb) && !zzcas2.zzimb.equals(zzcar2.zzaur())) {
            zzcar2.zzip(zzcas2.zzimb);
            bl = true;
        }
        if (zzcas2.zzilv != 0L && zzcas2.zzilv != zzcar2.zzauw()) {
            zzcar2.zzao(zzcas2.zzilv);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcas2.zzhts) && !zzcas2.zzhts.equals(zzcar2.zzuo())) {
            zzcar2.setAppVersion(zzcas2.zzhts);
            bl = true;
        }
        if (zzcas2.zzima != zzcar2.zzauu()) {
            zzcar2.zzan(zzcas2.zzima);
            bl = true;
        }
        if (zzcas2.zzilu != null && !zzcas2.zzilu.equals(zzcar2.zzauv())) {
            zzcar2.zziq(zzcas2.zzilu);
            bl = true;
        }
        if (zzcas2.zzilw != zzcar2.zzaux()) {
            zzcar2.zzap(zzcas2.zzilw);
            bl = true;
        }
        if (zzcas2.zzily != zzcar2.zzauy()) {
            zzcar2.setMeasurementEnabled(zzcas2.zzily);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)zzcas2.zzilx) && !zzcas2.zzilx.equals(zzcar2.zzavj())) {
            zzcar2.zzir(zzcas2.zzilx);
            bl = true;
        }
        if (zzcas2.zzimc != zzcar2.zzavl()) {
            zzcar2.zzaz(zzcas2.zzimc);
            bl = true;
        }
        if (bl) {
            this.zzaug().zza(zzcar2);
        }
    }

    @WorkerThread
    final void zzazl() {
        ((zzcdt)this.zzaul()).zzuj();
        this.zzwk();
        if (!this.zzitn) {
            this.zzaum().zzayi().log("This instance being marked as an uploader");
            zzccw zzccw2 = this;
            ((zzcdt)zzccw2.zzaul()).zzuj();
            zzccw2.zzwk();
            if (zzccw2.zzazm() && zzccw2.zzaze()) {
                int n;
                int n2 = zzccw2.zza(zzccw2.zzitr);
                int n3 = n = zzccw2.zzaub().zzayc();
                int n4 = n2;
                zzccw zzccw3 = zzccw2;
                ((zzcdt)zzccw3.zzaul()).zzuj();
                if (n4 > n3) {
                    zzccw3.zzaum().zzaye().zze("Panic: can't downgrade version. Previous, current version", n4, n3);
                } else if (n4 < n3) {
                    if (zzccw3.zza(n3, zzccw3.zzitr)) {
                        zzccw3.zzaum().zzayk().zze("Storage version upgraded. Previous, current version", n4, n3);
                    } else {
                        zzccw3.zzaum().zzaye().zze("Storage version upgrade failed. Previous, current version", n4, n3);
                    }
                }
            }
            this.zzitn = true;
            this.zzazj();
        }
    }

    @WorkerThread
    private final boolean zzazm() {
        ((zzcdt)this.zzaul()).zzuj();
        this.zzwk();
        return this.zzitn;
    }

    @WorkerThread
    final void zzi(Runnable runnable) {
        ((zzcdt)this.zzaul()).zzuj();
        if (this.zzitt == null) {
            this.zzitt = new ArrayList<Runnable>();
        }
        this.zzitt.add(runnable);
    }

    @WorkerThread
    private final void zzazn() {
        ((zzcdt)this.zzaul()).zzuj();
        if (this.zzity || this.zzitz || this.zziua) {
            this.zzaum().zzayk().zzd("Not stopping services. fetch, network, upload", this.zzity, this.zzitz, this.zziua);
            return;
        }
        this.zzaum().zzayk().log("Stopping uploading service(s)");
        if (this.zzitt == null) {
            return;
        }
        Iterator<Runnable> iterator = this.zzitt.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
        this.zzitt.clear();
    }

    final class zza
    implements zzcba {
        zzcgk zziud;
        List<Long> zziue;
        List<zzcgh> zzaob;
        private long zziuf;
        private /* synthetic */ zzccw zziuc;

        private zza(zzccw zzccw2) {
            this.zziuc = zzccw2;
        }

        @Override
        public final void zzb(zzcgk zzcgk2) {
            zzbp.zzu((Object)((Object)zzcgk2));
            this.zziud = zzcgk2;
        }

        @Override
        public final boolean zza(long l, zzcgh zzcgh2) {
            zzbp.zzu((Object)((Object)zzcgh2));
            if (this.zzaob == null) {
                this.zzaob = new ArrayList<zzcgh>();
            }
            if (this.zziue == null) {
                this.zziue = new ArrayList<Long>();
            }
            if (this.zzaob.size() > 0 && zza.zza(this.zzaob.get(0)) != zza.zza(zzcgh2)) {
                return false;
            }
            long l2 = this.zziuf + (long)zzcgh2.zzhi();
            if (l2 >= (long)zzcax.zzaws()) {
                return false;
            }
            this.zziuf = l2;
            this.zzaob.add(zzcgh2);
            this.zziue.add(l);
            return this.zzaob.size() < zzcax.zzawt();
        }

        private static long zza(zzcgh zzcgh2) {
            return zzcgh2.zziyx / 1000L / 60L / 60L;
        }

        /* synthetic */ zza(zzccw zzccw2, zzccx zzccx2) {
            this(zzccw2);
        }
    }
}

