/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Binder;
import android.support.annotation.BinderThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.util.zzv;
import com.google.android.gms.common.zzo;
import com.google.android.gms.common.zzp;
import com.google.android.gms.internal.zzcas;
import com.google.android.gms.internal.zzcav;
import com.google.android.gms.internal.zzcbk;
import com.google.android.gms.internal.zzcbp;
import com.google.android.gms.internal.zzcbw;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcdc;
import com.google.android.gms.internal.zzcdd;
import com.google.android.gms.internal.zzcde;
import com.google.android.gms.internal.zzcdf;
import com.google.android.gms.internal.zzcdg;
import com.google.android.gms.internal.zzcdh;
import com.google.android.gms.internal.zzcdi;
import com.google.android.gms.internal.zzcdj;
import com.google.android.gms.internal.zzcdk;
import com.google.android.gms.internal.zzcdl;
import com.google.android.gms.internal.zzcdm;
import com.google.android.gms.internal.zzcdn;
import com.google.android.gms.internal.zzcdo;
import com.google.android.gms.internal.zzcdp;
import com.google.android.gms.internal.zzcdq;
import com.google.android.gms.internal.zzcdr;
import com.google.android.gms.internal.zzcds;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.internal.zzcfv;
import com.google.android.gms.internal.zzcfw;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class zzcdb
extends zzcbp {
    private final zzccw zzikh;
    private Boolean zziug;
    @Nullable
    private String zziuh;

    public zzcdb(zzccw zzccw2) {
        this(zzccw2, null);
    }

    private zzcdb(zzccw zzccw2, @Nullable String string) {
        zzbp.zzu((Object)zzccw2);
        this.zzikh = zzccw2;
        this.zziuh = null;
    }

    @Override
    @BinderThread
    public final void zzb(zzcas zzcas2) {
        this.zzb(zzcas2, false);
        this.zzikh.zzaul().zzg(new zzcdc(this, zzcas2));
    }

    @Override
    @BinderThread
    public final void zza(zzcbk zzcbk2, zzcas zzcas2) {
        zzbp.zzu((Object)((Object)zzcbk2));
        this.zzb(zzcas2, false);
        this.zzikh.zzaul().zzg(new zzcdl(this, zzcbk2, zzcas2));
    }

    @Override
    @BinderThread
    public final void zza(zzcbk zzcbk2, String string, String string2) {
        zzbp.zzu((Object)((Object)zzcbk2));
        zzbp.zzgg((String)string);
        this.zzf(string, true);
        this.zzikh.zzaul().zzg(new zzcdm(this, zzcbk2, string));
    }

    @Override
    @BinderThread
    public final byte[] zza(zzcbk zzcbk2, String string) {
        zzbp.zzgg((String)string);
        zzbp.zzu((Object)((Object)zzcbk2));
        this.zzf(string, true);
        this.zzikh.zzaum().zzayj().zzj("Log and bundle. event", this.zzikh.zzauh().zzjc(zzcbk2.name));
        long l = this.zzikh.zzvx().nanoTime() / 1000000L;
        Future<byte[]> future = this.zzikh.zzaul().zze(new zzcdn(this, zzcbk2, string));
        try {
            byte[] byArray = future.get();
            if (byArray == null) {
                this.zzikh.zzaum().zzaye().zzj("Log and bundle returned null. appId", zzcbw.zzjf(string));
                byArray = new byte[]{};
            }
            long l2 = this.zzikh.zzvx().nanoTime() / 1000000L;
            this.zzikh.zzaum().zzayj().zzd("Log and bundle processed. event, size, time_ms", this.zzikh.zzauh().zzjc(zzcbk2.name), byArray.length, l2 - l);
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzikh.zzaum().zzaye().zzd("Failed to log and bundle. appId, event, error", zzcbw.zzjf(string), this.zzikh.zzauh().zzjc(zzcbk2.name), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzcft zzcft2, zzcas zzcas2) {
        zzbp.zzu((Object)((Object)zzcft2));
        this.zzb(zzcas2, false);
        if (zzcft2.getValue() == null) {
            this.zzikh.zzaul().zzg(new zzcdo(this, zzcft2, zzcas2));
            return;
        }
        this.zzikh.zzaul().zzg(new zzcdp(this, zzcft2, zzcas2));
    }

    @Override
    @BinderThread
    public final List<zzcft> zza(zzcas zzcas2, boolean bl) {
        this.zzb(zzcas2, false);
        Future<List<zzcfv>> future = this.zzikh.zzaul().zzd(new zzcdq(this, zzcas2));
        try {
            List<zzcfv> list = future.get();
            ArrayList<zzcft> arrayList = new ArrayList<zzcft>(list.size());
            for (zzcfv zzcfv2 : list) {
                if (!bl && zzcfw.zzkd(zzcfv2.mName)) continue;
                arrayList.add(new zzcft(zzcfv2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzikh.zzaum().zzaye().zze("Failed to get user attributes. appId", zzcbw.zzjf(zzcas2.packageName), exception);
            return null;
        }
    }

    @Override
    @BinderThread
    public final void zza(zzcas zzcas2) {
        this.zzb(zzcas2, false);
        zzcdr zzcdr2 = new zzcdr(this, zzcas2);
        if (this.zzikh.zzaul().zzayt()) {
            zzcdr2.run();
            return;
        }
        this.zzikh.zzaul().zzg(zzcdr2);
    }

    @BinderThread
    private final void zzb(zzcas zzcas2, boolean bl) {
        zzbp.zzu((Object)((Object)zzcas2));
        this.zzf(zzcas2.packageName, false);
        this.zzikh.zzaui().zzkb(zzcas2.zzilt);
    }

    @BinderThread
    private final void zzf(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zzikh.zzaum().zzaye().log("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzcdb zzcdb2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzcdb2 = this;
                    if (!bl2) break block9;
                    if (zzcdb2.zziug == null) {
                        zzcdb2.zziug = "com.google.android.gms".equals(zzcdb2.zziuh) || zzv.zzf((Context)zzcdb2.zzikh.getContext(), (int)Binder.getCallingUid()) || zzp.zzbz((Context)zzcdb2.zzikh.getContext()).zzbo(Binder.getCallingUid());
                    }
                    if (zzcdb2.zziug.booleanValue()) break block10;
                }
                if (zzcdb2.zziuh == null && zzo.zzb((Context)zzcdb2.zzikh.getContext(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzcdb2.zziuh = string2;
                }
                if (!string2.equals(zzcdb2.zziuh)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zzikh.zzaum().zzaye().zzj("Measurement Service called with invalid calling package. appId", zzcbw.zzjf(string));
            throw securityException;
        }
    }

    @Override
    @BinderThread
    public final void zza(long l, String string, String string2, String string3) {
        this.zzikh.zzaul().zzg(new zzcds(this, string2, string3, string, l));
    }

    @Override
    @BinderThread
    public final String zzc(zzcas zzcas2) {
        this.zzb(zzcas2, false);
        return this.zzikh.zzjs(zzcas2.packageName);
    }

    @Override
    @BinderThread
    public final void zza(zzcav zzcav2, zzcas zzcas2) {
        zzbp.zzu((Object)((Object)zzcav2));
        zzbp.zzu((Object)((Object)zzcav2.zzimg));
        this.zzb(zzcas2, false);
        zzcav zzcav3 = new zzcav(zzcav2);
        new zzcav(zzcav2).packageName = zzcas2.packageName;
        if (zzcav2.zzimg.getValue() == null) {
            this.zzikh.zzaul().zzg(new zzcdd(this, zzcav3, zzcas2));
            return;
        }
        this.zzikh.zzaul().zzg(new zzcde(this, zzcav3, zzcas2));
    }

    @Override
    @BinderThread
    public final void zzb(zzcav zzcav2) {
        zzbp.zzu((Object)((Object)zzcav2));
        zzbp.zzu((Object)((Object)zzcav2.zzimg));
        this.zzf(zzcav2.packageName, true);
        zzcav zzcav3 = new zzcav(zzcav2);
        if (zzcav2.zzimg.getValue() == null) {
            this.zzikh.zzaul().zzg(new zzcdf(this, zzcav3));
            return;
        }
        this.zzikh.zzaul().zzg(new zzcdg(this, zzcav3));
    }

    @Override
    @BinderThread
    public final List<zzcft> zza(String string, String string2, boolean bl, zzcas zzcas2) {
        this.zzb(zzcas2, false);
        Future<List<zzcfv>> future = this.zzikh.zzaul().zzd(new zzcdh(this, zzcas2, string, string2));
        try {
            List<zzcfv> list = future.get();
            ArrayList<zzcft> arrayList = new ArrayList<zzcft>(list.size());
            for (zzcfv zzcfv2 : list) {
                if (!bl && zzcfw.zzkd(zzcfv2.mName)) continue;
                arrayList.add(new zzcft(zzcfv2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzikh.zzaum().zzaye().zze("Failed to get user attributes. appId", zzcbw.zzjf(zzcas2.packageName), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcft> zza(String string, String string2, String string3, boolean bl) {
        this.zzf(string, true);
        Future<List<zzcfv>> future = this.zzikh.zzaul().zzd(new zzcdi(this, string, string2, string3));
        try {
            List<zzcfv> list = future.get();
            ArrayList<zzcft> arrayList = new ArrayList<zzcft>(list.size());
            for (zzcfv zzcfv2 : list) {
                if (!bl && zzcfw.zzkd(zzcfv2.mName)) continue;
                arrayList.add(new zzcft(zzcfv2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzikh.zzaum().zzaye().zze("Failed to get user attributes. appId", zzcbw.zzjf(string), exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcav> zza(String string, String string2, zzcas zzcas2) {
        this.zzb(zzcas2, false);
        Future<List<zzcav>> future = this.zzikh.zzaul().zzd(new zzcdj(this, zzcas2, string, string2));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzikh.zzaum().zzaye().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    @Override
    @BinderThread
    public final List<zzcav> zzj(String string, String string2, String string3) {
        this.zzf(string, true);
        Future<List<zzcav>> future = this.zzikh.zzaul().zzd(new zzcdk(this, string, string2, string3));
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zzikh.zzaum().zzaye().zzj("Failed to get conditional user properties", exception);
            return Collections.emptyList();
        }
    }

    static /* synthetic */ zzccw zza(zzcdb zzcdb2) {
        return zzcdb2.zzikh;
    }
}

