/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzcar;
import com.google.android.gms.internal.zzcav;
import com.google.android.gms.internal.zzcax;
import com.google.android.gms.internal.zzcaz;
import com.google.android.gms.internal.zzcbb;
import com.google.android.gms.internal.zzcbf;
import com.google.android.gms.internal.zzcbg;
import com.google.android.gms.internal.zzcbk;
import com.google.android.gms.internal.zzcbm;
import com.google.android.gms.internal.zzcbw;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzcdu;
import com.google.android.gms.internal.zzcfq;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.internal.zzcfv;
import com.google.android.gms.internal.zzcfw;
import com.google.android.gms.internal.zzcfx;
import com.google.android.gms.internal.zzcfy;
import com.google.android.gms.internal.zzcgb;
import com.google.android.gms.internal.zzcgh;
import com.google.android.gms.internal.zzcgi;
import com.google.android.gms.internal.zzcgk;
import com.google.android.gms.internal.zzcgl;
import com.google.android.gms.internal.zzeye;
import com.google.android.gms.internal.zzeyf;
import com.google.android.gms.internal.zzeyh;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class zzcay
extends zzcdu {
    private static final Map<String, String> zzimr = new ArrayMap(1);
    private static final Map<String, String> zzims;
    private static final Map<String, String> zzimt;
    private static final Map<String, String> zzimu;
    private static final Map<String, String> zzimv;
    private final zzcbb zzimw;
    private final zzcfq zzimx = new zzcfq(this.zzvx());

    zzcay(zzccw zzccw2) {
        super(zzccw2);
        String string = zzcax.zzawi();
        this.zzimw = new zzcbb(this, this.getContext(), string);
    }

    @Override
    protected final void zzuk() {
    }

    @WorkerThread
    public final void beginTransaction() {
        this.zzwk();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public final void setTransactionSuccessful() {
        this.zzwk();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public final void endTransaction() {
        this.zzwk();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private final long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzaul().zzayd().zze("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @WorkerThread
    final SQLiteDatabase getWritableDatabase() {
        this.zzuj();
        try {
            return this.zzimw.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzaul().zzayf().zzj("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzcbg zzaf(String string, String string2) {
        zzbp.zzgg((String)string);
        zzbp.zzgg((String)string2);
        this.zzuj();
        this.zzwk();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            zzcbg zzcbg2 = new zzcbg(string, string2, l, l2, l3);
            if (cursor.moveToNext()) {
                this.zzaul().zzayd().zzj("Got multiple records for event aggregates, expected one. appId", zzcbw.zzjf(string));
            }
            zzcbg zzcbg3 = zzcbg2;
            return zzcbg3;
        }
    }

    @WorkerThread
    public final void zza(zzcbg zzcbg2) {
        zzbp.zzu((Object)zzcbg2);
        this.zzuj();
        this.zzwk();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcbg2.mAppId);
        contentValues.put("name", zzcbg2.mName);
        contentValues.put("lifetime_count", Long.valueOf(zzcbg2.zzinl));
        contentValues.put("current_bundle_count", Long.valueOf(zzcbg2.zzinm));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzcbg2.zzinn));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzaul().zzayd().zzj("Failed to insert/update event aggregates (got -1). appId", zzcbw.zzjf(zzcbg2.mAppId));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzaul().zzayd().zze("Error storing event aggregates. appId", zzcbw.zzjf(zzcbg2.mAppId), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzag(String string, String string2) {
        zzbp.zzgg((String)string);
        zzbp.zzgg((String)string2);
        this.zzuj();
        this.zzwk();
        try {
            int n = this.getWritableDatabase().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzaul().zzayj().zzj("Deleted user attribute rows", n);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzaul().zzayd().zzd("Error deleting user attribute. appId", zzcbw.zzjf(string), this.zzaug().zzje(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzcfv zzcfv2) {
        zzbp.zzu((Object)zzcfv2);
        this.zzuj();
        this.zzwk();
        if (this.zzah(zzcfv2.mAppId, zzcfv2.mName) == null) {
            if (zzcfw.zzju(zzcfv2.mName)) {
                long l = this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzcfv2.mAppId});
                zzcax.zzavy();
                if (l >= 25L) {
                    return false;
                }
            } else {
                long l = this.zzb("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzcfv2.mAppId, zzcfv2.mOrigin});
                zzcax.zzawa();
                if (l >= 25L) {
                    return false;
                }
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcfv2.mAppId);
        contentValues.put("origin", zzcfv2.mOrigin);
        contentValues.put("name", zzcfv2.mName);
        contentValues.put("set_timestamp", Long.valueOf(zzcfv2.zzixd));
        zzcay.zza(contentValues, "value", zzcfv2.mValue);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzaul().zzayd().zzj("Failed to insert/update user property (got -1). appId", zzcbw.zzjf(zzcfv2.mAppId));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzaul().zzayd().zze("Error storing user property. appId", zzcbw.zzjf(zzcfv2.mAppId), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzcfv zzah(String string, String string2) {
        zzbp.zzgg((String)string);
        zzbp.zzgg((String)string2);
        this.zzuj();
        this.zzwk();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzcfv zzcfv2 = new zzcfv(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzaul().zzayd().zzj("Got multiple records for user property, expected one. appId", zzcbw.zzjf(string));
            }
            zzcfv zzcfv3 = zzcfv2;
            return zzcfv3;
        }
    }

    @WorkerThread
    public final List<zzcfv> zziv(String string) {
        zzbp.zzgg((String)string);
        this.zzuj();
        this.zzwk();
        ArrayList<zzcfv> arrayList = new ArrayList<zzcfv>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(zzcax.zzavz()));
            if (!cursor.moveToFirst()) {
                ArrayList<zzcfv> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzaul().zzayd().zzj("Read invalid user property value, ignoring it. appId", zzcbw.zzjf(string));
                    continue;
                }
                zzcfv zzcfv2 = new zzcfv(string, string2, (String)object, l, object2);
                arrayList.add(zzcfv2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzcfv> zzg(String string, String string2, String string3) {
        zzbp.zzgg((String)string);
        this.zzuj();
        this.zzwk();
        ArrayList<zzcfv> arrayList = new ArrayList<zzcfv>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String[] stringArray2 = new String[]{"name", "set_timestamp", "value", "origin"};
            String string4 = stringBuilder.toString();
            zzcax.zzavz();
            cursor = sQLiteDatabase.query("user_attributes", stringArray2, string4, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzcfv> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= zzcax.zzavz()) {
                    this.zzaul().zzayd().zzj("Read more than the max allowed user properties, ignoring excess", zzcax.zzavz());
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzaul().zzayd().zzd("(2)Read invalid user property value, ignoring it", zzcbw.zzjf(string), string2, string3);
                    continue;
                }
                zzcfv zzcfv2 = new zzcfv(string, string2, (String)object, l, object2);
                arrayList.add(zzcfv2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzcav zzcav2) {
        zzbp.zzu((Object)((Object)zzcav2));
        this.zzuj();
        this.zzwk();
        if (this.zzah(zzcav2.packageName, zzcav2.zzimh.name) == null) {
            long l = this.zzb("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzcav2.packageName});
            zzcax.zzawb();
            if (l >= 1000L) {
                return false;
            }
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcav2.packageName);
        contentValues.put("origin", zzcav2.zzimg);
        contentValues.put("name", zzcav2.zzimh.name);
        zzcay.zza(contentValues, "value", zzcav2.zzimh.getValue());
        contentValues.put("active", Boolean.valueOf(zzcav2.zzimj));
        contentValues.put("trigger_event_name", zzcav2.zzimk);
        contentValues.put("trigger_timeout", Long.valueOf(zzcav2.zzimm));
        this.zzauh();
        contentValues.put("timed_out_event", zzcfw.zza((Parcelable)zzcav2.zziml));
        contentValues.put("creation_timestamp", Long.valueOf(zzcav2.zzimi));
        this.zzauh();
        contentValues.put("triggered_event", zzcfw.zza((Parcelable)zzcav2.zzimn));
        contentValues.put("triggered_timestamp", Long.valueOf(zzcav2.zzimh.zziwz));
        contentValues.put("time_to_live", Long.valueOf(zzcav2.zzimo));
        this.zzauh();
        contentValues.put("expired_event", zzcfw.zza((Parcelable)zzcav2.zzimp));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzaul().zzayd().zzj("Failed to insert/update conditional user property (got -1)", zzcbw.zzjf(zzcav2.packageName));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzaul().zzayd().zze("Error storing conditional user property", zzcbw.zzjf(zzcav2.packageName), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzcav zzai(String string, String string2) {
        zzbp.zzgg((String)string);
        zzbp.zzgg((String)string2);
        this.zzuj();
        this.zzwk();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzcbk zzcbk2 = this.zzauh().zzb(cursor.getBlob(5), zzcbk.CREATOR);
            long l2 = cursor.getLong(6);
            zzcbk zzcbk3 = this.zzauh().zzb(cursor.getBlob(7), zzcbk.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzcbk zzcbk4 = this.zzauh().zzb(cursor.getBlob(10), zzcbk.CREATOR);
            zzcft zzcft2 = new zzcft(string2, l3, object, string3);
            zzcav zzcav2 = new zzcav(string, string3, zzcft2, l2, bl, string4, zzcbk2, l, zzcbk3, l4, zzcbk4);
            if (cursor.moveToNext()) {
                this.zzaul().zzayd().zze("Got multiple records for conditional property, expected one", zzcbw.zzjf(string), this.zzaug().zzje(string2));
            }
            zzcav zzcav3 = zzcav2;
            return zzcav3;
        }
    }

    @WorkerThread
    public final int zzaj(String string, String string2) {
        zzbp.zzgg((String)string);
        zzbp.zzgg((String)string2);
        this.zzuj();
        this.zzwk();
        try {
            return this.getWritableDatabase().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzaul().zzayd().zzd("Error deleting conditional property", zzcbw.zzjf(string), this.zzaug().zzje(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzcav> zzh(String string, String string2, String string3) {
        zzbp.zzgg((String)string);
        this.zzuj();
        this.zzwk();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zzc(stringBuilder.toString(), stringArray);
    }

    public final List<zzcav> zzc(String string, String[] stringArray) {
        this.zzuj();
        this.zzwk();
        ArrayList<zzcav> arrayList = new ArrayList<zzcav>();
        try (Cursor cursor = null;){
            Object object;
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String[] stringArray2 = new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"};
            zzcax.zzawb();
            cursor = sQLiteDatabase.query("conditional_properties", stringArray2, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzcav> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= zzcax.zzawb()) {
                    this.zzaul().zzayd().zzj("Read more than the max allowed conditional properties, ignoring extra", zzcax.zzawb());
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzcbk zzcbk2 = this.zzauh().zzb(cursor.getBlob(7), zzcbk.CREATOR);
                long l2 = cursor.getLong(8);
                zzcbk zzcbk3 = this.zzauh().zzb(cursor.getBlob(9), zzcbk.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzcbk zzcbk4 = this.zzauh().zzb(cursor.getBlob(12), zzcbk.CREATOR);
                zzcft zzcft2 = new zzcft(string3, l3, object2, string2);
                zzcav zzcav2 = new zzcav((String)object, string2, zzcft2, l2, bl, string4, zzcbk2, l, zzcbk3, l4, zzcbk4);
                arrayList.add(zzcav2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzcar zziw(String string) {
        zzbp.zzgg((String)string);
        this.zzuj();
        this.zzwk();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzcar zzcar2 = new zzcar(this.zziki, string);
            zzcar2.zzim(cursor.getString(0));
            zzcar2.zzin(cursor.getString(1));
            zzcar2.zzio(cursor.getString(2));
            zzcar2.zzaq(cursor.getLong(3));
            zzcar2.zzal(cursor.getLong(4));
            zzcar2.zzam(cursor.getLong(5));
            zzcar2.setAppVersion(cursor.getString(6));
            zzcar2.zziq(cursor.getString(7));
            zzcar2.zzao(cursor.getLong(8));
            zzcar2.zzap(cursor.getLong(9));
            zzcar2.setMeasurementEnabled((cursor.isNull(10) ? 1 : cursor.getInt(10)) != 0);
            zzcar2.zzat(cursor.getLong(11));
            zzcar2.zzau(cursor.getLong(12));
            zzcar2.zzav(cursor.getLong(13));
            zzcar2.zzaw(cursor.getLong(14));
            zzcar2.zzar(cursor.getLong(15));
            zzcar2.zzas(cursor.getLong(16));
            zzcar2.zzan(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzcar2.zzip(cursor.getString(18));
            zzcar2.zzay(cursor.getLong(19));
            zzcar2.zzax(cursor.getLong(20));
            zzcar2.zzir(cursor.getString(21));
            zzcar2.zzaz(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzcar2.zzauo();
            if (cursor.moveToNext()) {
                this.zzaul().zzayd().zzj("Got multiple records for app, expected one. appId", zzcbw.zzjf(string));
            }
            zzcar zzcar3 = zzcar2;
            return zzcar3;
        }
    }

    @WorkerThread
    public final void zza(zzcar zzcar2) {
        zzbp.zzu((Object)zzcar2);
        this.zzuj();
        this.zzwk();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcar2.getAppId());
        contentValues.put("app_instance_id", zzcar2.getAppInstanceId());
        contentValues.put("gmp_app_id", zzcar2.getGmpAppId());
        contentValues.put("resettable_device_id_hash", zzcar2.zzaup());
        contentValues.put("last_bundle_index", Long.valueOf(zzcar2.zzauy()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzcar2.zzaur()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzcar2.zzaus()));
        contentValues.put("app_version", zzcar2.zzuo());
        contentValues.put("app_store", zzcar2.zzauu());
        contentValues.put("gmp_version", Long.valueOf(zzcar2.zzauv()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzcar2.zzauw()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzcar2.zzaux()));
        contentValues.put("day", Long.valueOf(zzcar2.zzavc()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzcar2.zzavd()));
        contentValues.put("daily_events_count", Long.valueOf(zzcar2.zzave()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzcar2.zzavf()));
        contentValues.put("config_fetched_time", Long.valueOf(zzcar2.zzauz()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzcar2.zzava()));
        contentValues.put("app_version_int", Long.valueOf(zzcar2.zzaut()));
        contentValues.put("firebase_instance_id", zzcar2.zzauq());
        contentValues.put("daily_error_events_count", Long.valueOf(zzcar2.zzavh()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzcar2.zzavg()));
        contentValues.put("health_monitor_sample", zzcar2.zzavi());
        contentValues.put("android_id", Long.valueOf(zzcar2.zzavk()));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzcar2.getAppId()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzaul().zzayd().zzj("Failed to insert/update app (got -1). appId", zzcbw.zzjf(zzcar2.getAppId()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzaul().zzayd().zze("Error storing app. appId", zzcbw.zzjf(zzcar2.getAppId()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzix(String string) {
        zzbp.zzgg((String)string);
        this.zzuj();
        this.zzwk();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = string;
            int n = this.zzaun().zzb(string2, zzcbm.zzioq);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzaul().zzayd().zze("Error deleting over the limit events. appId", zzcbw.zzjf(string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzcaz zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        zzbp.zzgg((String)string);
        this.zzuj();
        this.zzwk();
        String[] stringArray = new String[]{string};
        zzcaz zzcaz2 = new zzcaz();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzaul().zzayf().zzj("Not updating daily counts, app is not known. appId", zzcbw.zzjf(string));
                zzcaz zzcaz3 = zzcaz2;
                return zzcaz3;
            }
            if (cursor.getLong(0) == l) {
                zzcaz2.zzimz = cursor.getLong(1);
                zzcaz2.zzimy = cursor.getLong(2);
                zzcaz2.zzina = cursor.getLong(3);
                zzcaz2.zzinb = cursor.getLong(4);
                zzcaz2.zzinc = cursor.getLong(5);
            }
            if (bl) {
                ++zzcaz2.zzimz;
            }
            if (bl2) {
                ++zzcaz2.zzimy;
            }
            if (bl3) {
                ++zzcaz2.zzina;
            }
            if (bl4) {
                ++zzcaz2.zzinb;
            }
            if (bl5) {
                ++zzcaz2.zzinc;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzcaz2.zzimy));
            contentValues.put("daily_events_count", Long.valueOf(zzcaz2.zzimz));
            contentValues.put("daily_conversions_count", Long.valueOf(zzcaz2.zzina));
            contentValues.put("daily_error_events_count", Long.valueOf(zzcaz2.zzinb));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzcaz2.zzinc));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzcaz zzcaz4 = zzcaz2;
            return zzcaz4;
        }
    }

    @WorkerThread
    public final byte[] zziy(String string) {
        zzbp.zzgg((String)string);
        this.zzuj();
        this.zzwk();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzaul().zzayd().zzj("Got multiple records for app config, expected one. appId", zzcbw.zzjf(string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(zzcgk zzcgk2, boolean bl) {
        byte[] byArray;
        this.zzuj();
        this.zzwk();
        zzbp.zzu((Object)((Object)zzcgk2));
        zzbp.zzgg((String)zzcgk2.zzci);
        zzbp.zzu((Object)zzcgk2.zzizj);
        this.zzaxk();
        long l = this.zzvx().currentTimeMillis();
        if (zzcgk2.zzizj < l - zzcax.zzawm() || zzcgk2.zzizj > l + zzcax.zzawm()) {
            this.zzaul().zzayf().zzd("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzcbw.zzjf(zzcgk2.zzci), l, zzcgk2.zzizj);
        }
        try {
            byte[] byArray2;
            byte[] byArray3 = byArray2 = new byte[zzcgk2.zzhi()];
            zzeyf zzeyf2 = zzeyf.zzn((byte[])byArray2, (int)0, (int)byArray3.length);
            zzcgk2.zza(zzeyf2);
            zzeyf2.zzctn();
            byArray = this.zzauh().zzp(byArray2);
        }
        catch (IOException iOException) {
            this.zzaul().zzayd().zze("Data loss. Failed to serialize bundle. appId", zzcbw.zzjf(zzcgk2.zzci), iOException);
            return false;
        }
        this.zzaul().zzayj().zzj("Saving bundle, size", byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcgk2.zzci);
        contentValues.put("bundle_end_timestamp", zzcgk2.zzizj);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("queue", null, contentValues) == -1L) {
                this.zzaul().zzayd().zzj("Failed to insert bundle (got -1). appId", zzcbw.zzjf(zzcgk2.zzci));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzaul().zzayd().zze("Error storing bundle. appId", zzcbw.zzjf(zzcgk2.zzci), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    public final String zzaxi() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
            return null;
        }
    }

    public final boolean zzaxj() {
        return this.zzb("select count(1) > 0 from queue where has_realtime = 1", null) != 0L;
    }

    @WorkerThread
    public final List<Pair<zzcgk, Long>> zzl(String string, int n, int n2) {
        this.zzuj();
        this.zzwk();
        zzbp.zzbh((n > 0 ? 1 : 0) != 0);
        zzbp.zzbh((n2 > 0 ? 1 : 0) != 0);
        zzbp.zzgg((String)string);
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("queue", new String[]{"rowid", "data"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzcgk, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzcgk, Long>> arrayList = new ArrayList<Pair<zzcgk, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzauh().zzq((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzaul().zzayd().zze("Failed to unzip queued bundle. appId", zzcbw.zzjf(string), iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                byte[] byArray2 = byArray;
                object = zzeye.zzm((byte[])byArray, (int)0, (int)byArray2.length);
                zzcgk zzcgk2 = new zzcgk();
                try {
                    zzcgk2.zza((zzeye)object);
                }
                catch (IOException iOException) {
                    this.zzaul().zzayd().zze("Failed to merge queued bundle. appId", zzcbw.zzjf(string), iOException);
                    continue;
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzcgk, Long>)Pair.create((Object)((Object)zzcgk2), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzcgk, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzaxk() {
        this.zzuj();
        this.zzwk();
        if (!this.zzaxq()) {
            return;
        }
        long l = this.zzaum().zziqs.get();
        long l2 = this.zzvx().elapsedRealtime();
        if (Math.abs(l2 - l) > zzcax.zzawn()) {
            this.zzaum().zziqs.set(l2);
            zzcay zzcay2 = this;
            zzcay2.zzuj();
            zzcay2.zzwk();
            if (zzcay2.zzaxq()) {
                SQLiteDatabase sQLiteDatabase = zzcay2.getWritableDatabase();
                String[] stringArray = new String[]{String.valueOf(zzcay2.zzvx().currentTimeMillis()), String.valueOf(zzcax.zzawm())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzcay2.zzaul().zzayj().zzj("Deleted stale rows. rowsDeleted", n);
                }
            }
        }
    }

    @WorkerThread
    final void zza(String string, zzcfx[] zzcfxArray) {
        this.zzwk();
        this.zzuj();
        zzbp.zzgg((String)string);
        zzbp.zzu((Object)zzcfxArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            int n;
            String string2 = string;
            zzcay zzcay2 = this;
            zzcay2.zzwk();
            zzcay2.zzuj();
            zzbp.zzgg((String)string2);
            Object object = zzcay2.getWritableDatabase();
            object.delete("property_filters", "app_id=?", new String[]{string2});
            object.delete("event_filters", "app_id=?", new String[]{string2});
            Object object2 = zzcfxArray;
            int n2 = zzcfxArray.length;
            block3: for (n = 0; n < n2; ++n) {
                zzcfy zzcfy2;
                int n3;
                int n4;
                zzcfx zzcfx2 = object2[n];
                object = zzcfx2;
                string2 = string;
                zzcay2 = this;
                zzcay2.zzwk();
                zzcay2.zzuj();
                zzbp.zzgg((String)string2);
                zzbp.zzu((Object)object);
                zzbp.zzu((Object)object.zzixl);
                zzbp.zzu((Object)object.zzixk);
                if (object.zzixj == null) {
                    zzcay2.zzaul().zzayf().zzj("Audience with no ID. appId", zzcbw.zzjf(string2));
                    continue;
                }
                int n5 = object.zzixj;
                zzeyh[] zzeyhArray = object.zzixl;
                int n6 = object.zzixl.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzeyhArray[n4].zzixn != null) continue;
                    zzcay2.zzaul().zzayf().zze("Event filter with no ID. Audience definition ignored. appId, audienceId", zzcbw.zzjf(string2), object.zzixj);
                    continue block3;
                }
                zzeyhArray = object.zzixk;
                n6 = object.zzixk.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzeyhArray[n4].zzixn != null) continue;
                    zzcay2.zzaul().zzayf().zze("Property filter with no ID. Audience definition ignored. appId, audienceId", zzcbw.zzjf(string2), object.zzixj);
                    continue block3;
                }
                boolean bl = true;
                zzeyh[] zzeyhArray2 = object.zzixl;
                n4 = object.zzixl.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    zzcfy2 = zzeyhArray2[n3];
                    if (zzcay2.zza(string2, n5, zzcfy2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    zzeyhArray2 = object.zzixk;
                    n4 = object.zzixk.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        zzcfy2 = zzeyhArray2[n3];
                        if (zzcay2.zza(string2, n5, (zzcgb)((Object)zzcfy2))) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n7 = n5;
                String string3 = string2;
                zzcay zzcay3 = zzcay2;
                zzcay3.zzwk();
                zzcay3.zzuj();
                zzbp.zzgg((String)string3);
                SQLiteDatabase sQLiteDatabase2 = zzcay3.getWritableDatabase();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
            }
            object2 = new ArrayList();
            zzcfx[] zzcfxArray2 = zzcfxArray;
            n = zzcfxArray.length;
            for (int i = 0; i < n; ++i) {
                zzcfx zzcfx3 = zzcfxArray2[i];
                object2.add(zzcfx3.zzixj);
            }
            this.zzc(string, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzcfy zzcfy2) {
        byte[] byArray;
        this.zzwk();
        this.zzuj();
        zzbp.zzgg((String)string);
        zzbp.zzu((Object)((Object)zzcfy2));
        if (TextUtils.isEmpty((CharSequence)zzcfy2.zzixo)) {
            this.zzaul().zzayf().zzd("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzcbw.zzjf(string), n, String.valueOf(zzcfy2.zzixn));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzcfy2.zzhi()];
            zzeyf zzeyf2 = zzeyf.zzn((byte[])byArray, (int)0, (int)byArray2.length);
            zzcfy2.zza(zzeyf2);
            zzeyf2.zzctn();
        }
        catch (IOException iOException) {
            this.zzaul().zzayd().zze("Configuration loss. Failed to serialize event filter. appId", zzcbw.zzjf(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzcfy2.zzixn);
        contentValues.put("event_name", zzcfy2.zzixo);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzaul().zzayd().zzj("Failed to insert event filter (got -1). appId", zzcbw.zzjf(string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzaul().zzayd().zze("Error storing event filter. appId", zzcbw.zzjf(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzcgb zzcgb2) {
        byte[] byArray;
        this.zzwk();
        this.zzuj();
        zzbp.zzgg((String)string);
        zzbp.zzu((Object)((Object)zzcgb2));
        if (TextUtils.isEmpty((CharSequence)zzcgb2.zziyd)) {
            this.zzaul().zzayf().zzd("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzcbw.zzjf(string), n, String.valueOf(zzcgb2.zzixn));
            return false;
        }
        try {
            byte[] byArray2 = byArray = new byte[zzcgb2.zzhi()];
            zzeyf zzeyf2 = zzeyf.zzn((byte[])byArray, (int)0, (int)byArray2.length);
            zzcgb2.zza(zzeyf2);
            zzeyf2.zzctn();
        }
        catch (IOException iOException) {
            this.zzaul().zzayd().zze("Configuration loss. Failed to serialize property filter. appId", zzcbw.zzjf(string), iOException);
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzcgb2.zzixn);
        contentValues.put("property_name", zzcgb2.zziyd);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzaul().zzayd().zzj("Failed to insert property filter (got -1). appId", zzcbw.zzjf(string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzaul().zzayd().zze("Error storing property filter. appId", zzcbw.zzjf(string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzcfy>> zzak(String string, String string2) {
        this.zzwk();
        this.zzuj();
        zzbp.zzgg((String)string);
        zzbp.zzgg((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzcfy>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzeye zzeye2 = zzeye.zzm((byte[])byArray, (int)0, (int)byArray.length);
                zzcfy zzcfy2 = new zzcfy();
                try {
                    zzcfy2.zza(zzeye2);
                }
                catch (IOException iOException) {
                    this.zzaul().zzayd().zze("Failed to merge filter. appId", zzcbw.zzjf(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzcfy> arrayList = (ArrayList<zzcfy>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzcfy>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzcfy2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzcgb>> zzal(String string, String string2) {
        this.zzwk();
        this.zzuj();
        zzbp.zzgg((String)string);
        zzbp.zzgg((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzcgb>> map = Collections.emptyMap();
                return map;
            }
            do {
                byte[] byArray = cursor.getBlob(1);
                zzeye zzeye2 = zzeye.zzm((byte[])byArray, (int)0, (int)byArray.length);
                zzcgb zzcgb2 = new zzcgb();
                try {
                    zzcgb2.zza(zzeye2);
                }
                catch (IOException iOException) {
                    this.zzaul().zzayd().zze("Failed to merge filter", zzcbw.zzjf(string), iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzcgb> arrayList = (ArrayList<zzcgb>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzcgb>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzcgb2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zzc(String string, List<Integer> list) {
        Object object;
        long l;
        zzbp.zzgg((String)string);
        this.zzwk();
        this.zzuj();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zzb("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzaul().zzayd().zze("Database error querying filters. appId", zzcbw.zzjf(string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzaun().zzb(string2, zzcbm.zzipg);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = TextUtils.join((CharSequence)",", arrayList);
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, zzcgl> zziz(String string) {
        this.zzwk();
        this.zzuj();
        zzbp.zzgg((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                zzeye zzeye2 = zzeye.zzm((byte[])byArray, (int)0, (int)byArray.length);
                zzcgl zzcgl2 = new zzcgl();
                try {
                    zzcgl2.zza(zzeye2);
                }
                catch (IOException iOException) {
                    this.zzaul().zzayd().zzd("Failed to merge filter results. appId, audienceId, error", zzcbw.zzjf(string), n, iOException);
                    continue;
                }
                arrayMap.put(n, zzcgl2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        zzbp.zzgg((String)string);
        zzbp.zzu((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzaul().zzayd().log("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzaul().zzayd().log("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzaul().zzayd().zzj("Loaded invalid unknown value type, ignoring it", n3);
        return null;
    }

    @WorkerThread
    public final long zzaxl() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    protected final long zzam(String string, String string2) {
        zzbp.zzgg((String)string);
        zzbp.zzgg((String)string2);
        this.zzuj();
        this.zzwk();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzaul().zzayd().zze("Failed to insert column (got -1). appId", zzcbw.zzjf(string), string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzaul().zzayd().zze("Failed to update column (got 0). appId", zzcbw.zzjf(string), string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzaul().zzayd().zzd("Error inserting column. appId", zzcbw.zzjf(string), string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzaxm() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(zzcgk zzcgk2) throws IOException {
        long l;
        Object object;
        byte[] byArray;
        this.zzuj();
        this.zzwk();
        zzbp.zzu((Object)((Object)zzcgk2));
        zzbp.zzgg((String)zzcgk2.zzci);
        try {
            byArray = new byte[zzcgk2.zzhi()];
            object = byArray;
            zzeyf zzeyf2 = zzeyf.zzn((byte[])byArray, (int)0, (int)((byte[])object).length);
            zzcgk2.zza(zzeyf2);
            zzeyf2.zzctn();
        }
        catch (IOException iOException) {
            this.zzaul().zzayd().zze("Data loss. Failed to serialize event metadata. appId", zzcbw.zzjf(zzcgk2.zzci), iOException);
            throw iOException;
        }
        byte[] byArray2 = byArray;
        object = this.zzauh();
        zzbp.zzu((Object)byArray2);
        ((zzcdt)object).zzuj();
        MessageDigest messageDigest = zzcfw.zzec("MD5");
        if (messageDigest == null) {
            ((zzcdt)object).zzaul().zzayd().log("Failed to get MD5");
            l = 0L;
        } else {
            l = zzcfw.zzr(messageDigest.digest(byArray2));
        }
        long l2 = l;
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzcgk2.zzci);
        contentValues.put("metadata_fingerprint", Long.valueOf(l2));
        contentValues.put("metadata", byArray);
        try {
            this.getWritableDatabase().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzaul().zzayd().zze("Error storing raw event metadata. appId", zzcbw.zzjf(zzcgk2.zzci), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l2;
    }

    public final boolean zzaxn() {
        return this.zzb("select count(1) > 0 from raw_events", null) != 0L;
    }

    public final boolean zzaxo() {
        return this.zzb("select count(1) > 0 from raw_events where realtime = 1", null) != 0L;
    }

    public final void zzae(List<Long> list) {
        zzbp.zzu(list);
        this.zzuj();
        this.zzwk();
        StringBuilder stringBuilder = new StringBuilder("rowid in (");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(list.get(i));
        }
        stringBuilder.append(")");
        int n = this.getWritableDatabase().delete("raw_events", stringBuilder.toString(), null);
        if (n != list.size()) {
            this.zzaul().zzayd().zze("Deleted fewer rows from raw events table than expected", n, list.size());
        }
    }

    public final long zzja(String string) {
        zzbp.zzgg((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zzba(long l) {
        this.zzuj();
        this.zzwk();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzaul().zzayj().log("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzaxp() {
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final boolean zza(zzcbf zzcbf2, long l, boolean bl) {
        Object object;
        zzcgi zzcgi2;
        String string2;
        this.zzuj();
        this.zzwk();
        zzbp.zzu((Object)zzcbf2);
        zzbp.zzgg((String)zzcbf2.mAppId);
        zzcgh zzcgh2 = new zzcgh();
        new zzcgh().zziyz = zzcbf2.zzinj;
        zzcgh2.zziyx = new zzcgi[zzcbf2.zzink.size()];
        int n = 0;
        for (String string2 : zzcbf2.zzink) {
            zzcgi2 = new zzcgi();
            zzcgh2.zziyx[n++] = zzcgi2;
            zzcgi2.name = string2;
            Object object2 = zzcbf2.zzink.get(string2);
            this.zzauh().zza(zzcgi2, object2);
        }
        try {
            byte[] byArray = new byte[zzcgh2.zzhi()];
            object = byArray;
            byte[] byArray2 = byArray;
            zzcgi2 = zzeyf.zzn((byte[])byArray, (int)0, (int)byArray2.length);
            zzcgh2.zza((zzeyf)zzcgi2);
            zzcgi2.zzctn();
        }
        catch (IOException iOException) {
            this.zzaul().zzayd().zze("Data loss. Failed to serialize event params/data. appId", zzcbw.zzjf(zzcbf2.mAppId), iOException);
            return false;
        }
        this.zzaul().zzayj().zze("Saving event, name, data size", this.zzaug().zzjc(zzcbf2.mName), ((Object)object).length);
        string2 = new ContentValues();
        string2.put("app_id", zzcbf2.mAppId);
        string2.put("name", zzcbf2.mName);
        string2.put("timestamp", Long.valueOf(zzcbf2.zzfdc));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzaul().zzayd().zzj("Failed to insert raw event (got -1). appId", zzcbw.zzjf(zzcbf2.mAppId));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzaul().zzayd().zze("Error storing raw event. appId", zzcbw.zzjf(zzcbf2.mAppId), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zzaxq() {
        return this.getContext().getDatabasePath(zzcax.zzawi()).exists();
    }

    @WorkerThread
    private static boolean zza(zzcbw zzcbw2, SQLiteDatabase sQLiteDatabase, String string) {
        if (zzcbw2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
            boolean bl = cursor.moveToFirst();
            return bl;
        }
    }

    @WorkerThread
    private static Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = new StringBuilder(22 + String.valueOf(string).length()).append("SELECT * FROM ").append(string).append(" LIMIT 0").toString();
        try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
            Collections.addAll(hashSet, cursor.getColumnNames());
        }
        return hashSet;
    }

    @WorkerThread
    private static void zza(zzcbw zzcbw2, SQLiteDatabase sQLiteDatabase, String string, String string2, Map<String, String> map) throws SQLiteException {
        if (zzcbw2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        Set<String> set = zzcay.zzb(sQLiteDatabase, string);
        for (String string3 : string2.split(",")) {
            if (set.remove(string3)) continue;
            throw new SQLiteException(new StringBuilder(35 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Table ").append(string).append(" is missing required column: ").append(string3).toString());
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (set.remove(entry.getKey())) continue;
                sQLiteDatabase.execSQL((String)entry.getValue());
            }
        }
        if (!set.isEmpty()) {
            zzcbw2.zzayf().zze("Table has extra columns. table, columns", string, TextUtils.join((CharSequence)", ", set));
        }
    }

    @WorkerThread
    static void zza(zzcbw zzcbw2, SQLiteDatabase sQLiteDatabase, String string, String string2, String string3, Map<String, String> map) throws SQLiteException {
        if (zzcbw2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        if (!zzcay.zza(zzcbw2, sQLiteDatabase, string)) {
            sQLiteDatabase.execSQL(string2);
        }
        try {
            zzcay.zza(zzcbw2, sQLiteDatabase, string, string3, map);
            return;
        }
        catch (SQLiteException sQLiteException) {
            zzcbw2.zzayd().zzj("Failed to verify columns on table that was just created", string);
            throw sQLiteException;
        }
    }

    static void zza(zzcbw zzcbw2, SQLiteDatabase sQLiteDatabase) {
        if (zzcbw2 == null) {
            throw new IllegalArgumentException("Monitor must not be null");
        }
        File file = new File(sQLiteDatabase.getPath());
        if (!file.setReadable(false, false)) {
            zzcbw2.zzayf().log("Failed to turn off database read permission");
        }
        if (!file.setWritable(false, false)) {
            zzcbw2.zzayf().log("Failed to turn off database write permission");
        }
        if (!file.setReadable(true, true)) {
            zzcbw2.zzayf().log("Failed to turn on database read permission for owner");
        }
        if (!file.setWritable(true, true)) {
            zzcbw2.zzayf().log("Failed to turn on database write permission for owner");
        }
    }

    static /* synthetic */ zzcfq zza(zzcay zzcay2) {
        return zzcay2.zzimx;
    }

    static /* synthetic */ Map zzaxr() {
        return zzimr;
    }

    static /* synthetic */ Map zzaxs() {
        return zzims;
    }

    static /* synthetic */ Map zzaxt() {
        return zzimu;
    }

    static /* synthetic */ Map zzaxu() {
        return zzimt;
    }

    static /* synthetic */ Map zzaxv() {
        return zzimv;
    }

    static {
        zzimr.put("origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;");
        zzims = new ArrayMap(18);
        zzims.put("app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;");
        zzims.put("app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;");
        zzims.put("gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;");
        zzims.put("dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;");
        zzims.put("measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;");
        zzims.put("last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;");
        zzims.put("day", "ALTER TABLE apps ADD COLUMN day INTEGER;");
        zzims.put("daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;");
        zzims.put("daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;");
        zzims.put("daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;");
        zzims.put("remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;");
        zzims.put("config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;");
        zzims.put("failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;");
        zzims.put("app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;");
        zzims.put("firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;");
        zzims.put("daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;");
        zzims.put("daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;");
        zzims.put("health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;");
        zzims.put("android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;");
        zzimt = new ArrayMap(1);
        zzimt.put("realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;");
        zzimu = new ArrayMap(1);
        zzimu.put("has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;");
        zzimv = new ArrayMap(1);
        zzimv.put("previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;");
    }
}

