/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Looper;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzcct;
import com.google.android.gms.internal.zzccu;
import com.google.android.gms.internal.zzccv;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzcdu;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class zzccr
extends zzcdu {
    private ExecutorService zzisa;
    private zzccv zzisb;
    private zzccv zzisc;
    private final PriorityBlockingQueue<FutureTask<?>> zzisd;
    private final BlockingQueue<FutureTask<?>> zzise;
    private final Thread.UncaughtExceptionHandler zzisf;
    private final Thread.UncaughtExceptionHandler zzisg;
    private final Object zzish = new Object();
    private final Semaphore zzisi = new Semaphore(2);
    private volatile boolean zzisj;
    private static final AtomicLong zzisk = new AtomicLong(Long.MIN_VALUE);

    zzccr(zzccw zzccw2) {
        super(zzccw2);
        this.zzisd = new PriorityBlockingQueue();
        this.zzise = new LinkedBlockingQueue();
        this.zzisf = new zzcct(this, "Thread death: Uncaught exception on worker thread");
        this.zzisg = new zzcct(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final void zzuk() {
    }

    @Override
    public final void zzuj() {
        if (Thread.currentThread() != this.zzisb) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzatw() {
        if (Thread.currentThread() != this.zzisc) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public static boolean zzaq() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public final boolean zzays() {
        return Thread.currentThread() == this.zzisb;
    }

    public final <V> Future<V> zzd(Callable<V> callable) throws IllegalStateException {
        this.zzwk();
        zzbp.zzu(callable);
        zzccu zzccu2 = new zzccu(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzisb) {
            if (!this.zzisd.isEmpty()) {
                ((zzcdt)this).zzaul().zzayf().log("Callable skipped the worker queue.");
            }
            zzccu2.run();
        } else {
            this.zza(zzccu2);
        }
        return zzccu2;
    }

    public final <V> Future<V> zze(Callable<V> callable) throws IllegalStateException {
        this.zzwk();
        zzbp.zzu(callable);
        zzccu zzccu2 = new zzccu(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzisb) {
            zzccu2.run();
        } else {
            this.zza(zzccu2);
        }
        return zzccu2;
    }

    public final void zzg(Runnable runnable) throws IllegalStateException {
        this.zzwk();
        zzbp.zzu((Object)runnable);
        this.zza(new zzccu(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzccu<?> zzccu2) {
        Object object = this.zzish;
        synchronized (object) {
            this.zzisd.add(zzccu2);
            if (this.zzisb == null) {
                this.zzisb = new zzccv(this, "Measurement Worker", this.zzisd);
                this.zzisb.setUncaughtExceptionHandler(this.zzisf);
                this.zzisb.start();
            } else {
                this.zzisb.zzml();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzh(Runnable runnable) throws IllegalStateException {
        this.zzwk();
        zzbp.zzu((Object)runnable);
        zzccu zzccu2 = new zzccu(this, runnable, false, "Task exception on network thread");
        zzccr zzccr2 = this;
        Object object = zzccr2.zzish;
        synchronized (object) {
            zzccr2.zzise.add(zzccu2);
            if (zzccr2.zzisc == null) {
                zzccr2.zzisc = new zzccv(zzccr2, "Measurement Network", zzccr2.zzise);
                zzccr2.zzisc.setUncaughtExceptionHandler(zzccr2.zzisg);
                zzccr2.zzisc.start();
            } else {
                zzccr2.zzisc.zzml();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ExecutorService zzayt() {
        Object object = this.zzish;
        synchronized (object) {
            if (this.zzisa == null) {
                this.zzisa = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzisa;
        }
    }

    static /* synthetic */ Semaphore zza(zzccr zzccr2) {
        return zzccr2.zzisi;
    }

    static /* synthetic */ boolean zzb(zzccr zzccr2) {
        return zzccr2.zzisj;
    }

    static /* synthetic */ Object zzc(zzccr zzccr2) {
        return zzccr2.zzish;
    }

    static /* synthetic */ zzccv zzd(zzccr zzccr2) {
        return zzccr2.zzisb;
    }

    static /* synthetic */ zzccv zza(zzccr zzccr2, zzccv zzccv2) {
        zzccr2.zzisb = null;
        return null;
    }

    static /* synthetic */ zzccv zze(zzccr zzccr2) {
        return zzccr2.zzisc;
    }

    static /* synthetic */ zzccv zzb(zzccr zzccr2, zzccv zzccv2) {
        zzccr2.zzisc = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzayu() {
        return zzisk;
    }
}

