/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzcav;
import com.google.android.gms.internal.zzcax;
import com.google.android.gms.internal.zzcbh;
import com.google.android.gms.internal.zzcbk;
import com.google.android.gms.internal.zzccr;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzcdu;
import com.google.android.gms.internal.zzcdx;
import com.google.android.gms.internal.zzcdy;
import com.google.android.gms.internal.zzcdz;
import com.google.android.gms.internal.zzcea;
import com.google.android.gms.internal.zzceb;
import com.google.android.gms.internal.zzcec;
import com.google.android.gms.internal.zzced;
import com.google.android.gms.internal.zzcee;
import com.google.android.gms.internal.zzcef;
import com.google.android.gms.internal.zzceg;
import com.google.android.gms.internal.zzceh;
import com.google.android.gms.internal.zzcei;
import com.google.android.gms.internal.zzcej;
import com.google.android.gms.internal.zzcek;
import com.google.android.gms.internal.zzcen;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.internal.zzcfw;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class zzcdw
extends zzcdu {
    protected zzcej zziut;
    private AppMeasurement.EventInterceptor zziuu;
    private final Set<AppMeasurement.OnEventListener> zziuv = new CopyOnWriteArraySet<AppMeasurement.OnEventListener>();
    private boolean zziuw;
    private final AtomicReference<String> zziux = new AtomicReference();

    protected zzcdw(zzccw zzccw2) {
        super(zzccw2);
    }

    @Override
    protected final void zzuk() {
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zzwk();
        ((zzcdt)this).zzatv();
        ((zzcdt)this).zzauk().zzg(new zzcdx(this, bl));
    }

    @WorkerThread
    private final void zzbp(boolean bl) {
        ((zzcdt)this).zzuj();
        ((zzcdt)this).zzatv();
        this.zzwk();
        ((zzcdt)this).zzaul().zzayi().zzj("Setting app measurement enabled (FE)", bl);
        ((zzcdt)this).zzaum().setMeasurementEnabled(bl);
        ((zzcdt)this).zzauc().zzazp();
    }

    public final void setMinimumSessionDuration(long l) {
        ((zzcdt)this).zzatv();
        ((zzcdt)this).zzauk().zzg(new zzcec(this, l));
    }

    public final void setSessionTimeoutDuration(long l) {
        ((zzcdt)this).zzatv();
        ((zzcdt)this).zzauk().zzg(new zzced(this, l));
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl) {
        ((zzcdt)this).zzatv();
        boolean bl2 = this.zziuu == null || zzcfw.zzkd(string2);
        this.zza(string, string2, bundle, true, bl2, true, null);
    }

    public final void zzc(String string, String string2, Bundle bundle) {
        ((zzcdt)this).zzatv();
        boolean bl = this.zziuu == null || zzcfw.zzkd(string2);
        this.zza(string, string2, bundle, true, bl, false, null);
    }

    public final void zza(String string, String string2, Bundle bundle, long l) {
        ((zzcdt)this).zzatv();
        this.zza(string, string2, l, bundle, false, true, true, null);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.zza(string, string2, ((zzcdt)this).zzvx().currentTimeMillis(), bundle, true, bl2, bl3, null);
    }

    private final void zza(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Bundle bundle3 = bundle;
        if (bundle3 == null) {
            bundle2 = new Bundle();
        } else {
            Bundle bundle4 = new Bundle(bundle3);
            for (String string4 : bundle4.keySet()) {
                int n;
                Object object;
                Object object2 = bundle4.get(string4);
                if (object2 instanceof Bundle) {
                    bundle4.putBundle(string4, new Bundle((Bundle)object2));
                    continue;
                }
                if (object2 instanceof Parcelable[]) {
                    object = (Parcelable[])object2;
                    for (n = 0; n < ((Parcelable[])object).length; ++n) {
                        if (!(object[n] instanceof Bundle)) continue;
                        object[n] = new Bundle((Bundle)object[n]);
                    }
                    continue;
                }
                if (!(object2 instanceof ArrayList)) continue;
                object = (ArrayList)object2;
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    Object e = ((ArrayList)object).get(n);
                    if (!(e instanceof Bundle)) continue;
                    ((ArrayList)object).set(n, new Bundle((Bundle)e));
                }
            }
            bundle2 = bundle4;
        }
        Bundle bundle5 = bundle2;
        ((zzcdt)this).zzauk().zzg(new zzcee(this, string, string2, l, bundle5, bl, bl2, bl3, string3));
    }

    @WorkerThread
    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Object object;
        zzbp.zzgg((String)string);
        zzbp.zzgg((String)string2);
        zzbp.zzu((Object)bundle);
        ((zzcdt)this).zzuj();
        this.zzwk();
        if (!this.zziki.isEnabled()) {
            ((zzcdt)this).zzaul().zzayi().log("Event not sent since app measurement is disabled");
            return;
        }
        if (!this.zziuw) {
            this.zziuw = true;
            zzcdw zzcdw2 = this;
            try {
                Class<?> clazz;
                Class<?> clazz2 = clazz = Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                zzcdw zzcdw3 = zzcdw2;
                try {
                    clazz2.getDeclaredMethod("initialize", Context.class).invoke(null, ((zzcdt)zzcdw3).getContext());
                }
                catch (Exception exception) {
                    ((zzcdt)zzcdw3).zzaul().zzayf().zzj("Failed to invoke Tag Manager's initialize() method", exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                ((zzcdt)zzcdw2).zzaul().zzayh().log("Tag Manager is not found and thus will not be used");
            }
        }
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzcfw.zzkd(string2);
        if (bl && this.zziuu != null && !bl5 && !bl4) {
            ((zzcdt)this).zzaul().zzayi().zze("Passing event to registered event handler (FE)", ((zzcdt)this).zzaug().zzjc(string2), ((zzcdt)this).zzaug().zzx(bundle));
            this.zziuu.interceptEvent(string, string2, bundle, l);
            return;
        }
        if (!this.zziki.zzayv()) {
            return;
        }
        int n = ((zzcdt)this).zzauh().zzjw(string2);
        if (n != 0) {
            ((zzcdt)this).zzauh();
            String string4 = zzcfw.zza(string2, zzcax.zzavn(), true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zziki.zzauh().zza(string3, n, "_ev", string4, n2);
            return;
        }
        List<String> list = Collections.singletonList("_o");
        Bundle bundle3 = ((zzcdt)this).zzauh().zza(string2, bundle, list, bl3, true);
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(bundle3);
        long l2 = ((zzcdt)this).zzauh().zzazy().nextLong();
        int n3 = 0;
        Object[] objectArray = bundle3.keySet().toArray(new String[bundle.size()]);
        Arrays.sort(objectArray);
        Object object2 = objectArray;
        int n4 = objectArray.length;
        for (int i = 0; i < n4; ++i) {
            Object object3 = object2[i];
            object = bundle3.get((String)object3);
            ((zzcdt)this).zzauh();
            bundle2 = zzcfw.zzac(object);
            if (bundle2 == null) continue;
            bundle3.putInt((String)object3, ((Bundle[])bundle2).length);
            for (int j = 0; j < ((Bundle[])bundle2).length; ++j) {
                Bundle bundle4 = bundle2[j];
                Bundle object4 = ((zzcdt)this).zzauh().zza("_ep", bundle4, list, bl3, false);
                object4.putString("_en", string2);
                object4.putLong("_eid", l2);
                object4.putString("_gn", (String)object3);
                object4.putInt("_ll", ((Bundle)bundle2).length);
                object4.putInt("_i", j);
                arrayList.add(object4);
            }
            n3 += ((Bundle[])bundle2).length;
        }
        if (n3 != 0) {
            bundle3.putLong("_eid", l2);
            bundle3.putInt("_epc", n3);
        }
        zzcax.zzawk();
        zzcen zzcen2 = ((zzcdt)this).zzaud().zzazn();
        if (zzcen2 != null && !bundle3.containsKey("_sc")) {
            zzcen2.zzivx = true;
        }
        object2 = zzcen2;
        for (int i = 0; i < arrayList.size(); ++i) {
            Bundle bundle5 = (Bundle)arrayList.get(i);
            object = i != 0 ? "_ep" : string2;
            bundle5.putString("_o", string);
            if (!bundle5.containsKey("_sc")) {
                zzcek.zza((AppMeasurement.zzb)object2, bundle5);
            }
            bundle2 = bl2 ? ((zzcdt)this).zzauh().zzy(bundle5) : bundle5;
            ((zzcdt)this).zzaul().zzayi().zze("Logging event (FE)", ((zzcdt)this).zzaug().zzjc(string2), ((zzcdt)this).zzaug().zzx(bundle2));
            zzcbk zzcbk2 = new zzcbk((String)object, new zzcbh(bundle2), string, l);
            ((zzcdt)this).zzauc().zzc(zzcbk2, string3);
            if (bl4) continue;
            for (AppMeasurement.OnEventListener onEventListener : this.zziuv) {
                Bundle bundle4 = new Bundle(bundle2);
                onEventListener.onEvent(string, string2, bundle4, l);
            }
        }
        zzcax.zzawk();
        if (((zzcdt)this).zzaud().zzazn() != null && "_ae".equals(string2)) {
            ((zzcdt)this).zzauj().zzbs(true);
        }
    }

    public final void zzb(String string, String string2, Object object) {
        zzbp.zzgg((String)string);
        long l = ((zzcdt)this).zzvx().currentTimeMillis();
        int n = ((zzcdt)this).zzauh().zzjy(string2);
        if (n != 0) {
            ((zzcdt)this).zzauh();
            String string3 = zzcfw.zza(string2, zzcax.zzavo(), true);
            int n2 = string2 != null ? string2.length() : 0;
            this.zziki.zzauh().zza(n, "_ev", string3, n2);
            return;
        }
        if (object != null) {
            n = ((zzcdt)this).zzauh().zzl(string2, object);
            if (n != 0) {
                ((zzcdt)this).zzauh();
                String string4 = zzcfw.zza(string2, zzcax.zzavo(), true);
                int n3 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n3 = String.valueOf(object).length();
                }
                this.zziki.zzauh().zza(n, "_ev", string4, n3);
                return;
            }
            Object object2 = ((zzcdt)this).zzauh().zzm(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        ((zzcdt)this).zzauk().zzg(new zzcef(this, string, string2, object, l));
    }

    @WorkerThread
    private final void zza(String string, String string2, Object object, long l) {
        zzbp.zzgg((String)string);
        zzbp.zzgg((String)string2);
        ((zzcdt)this).zzuj();
        ((zzcdt)this).zzatv();
        this.zzwk();
        if (!this.zziki.isEnabled()) {
            ((zzcdt)this).zzaul().zzayi().log("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zziki.zzayv()) {
            return;
        }
        ((zzcdt)this).zzaul().zzayi().zze("Setting user property (FE)", ((zzcdt)this).zzaug().zzjc(string2), object);
        zzcft zzcft2 = new zzcft(string2, l, object, string);
        ((zzcdt)this).zzauc().zzb(zzcft2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<zzcft> zzbq(boolean bl) {
        ((zzcdt)this).zzatv();
        this.zzwk();
        ((zzcdt)this).zzaul().zzayi().log("Fetching user attributes (FE)");
        if (((zzcdt)this).zzauk().zzays()) {
            ((zzcdt)this).zzaul().zzayd().log("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        ((zzcdt)this).zzauk();
        if (zzccr.zzaq()) {
            ((zzcdt)this).zzaul().zzayd().log("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zziki.zzauk().zzg(new zzceg(this, atomicReference, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcdt)this).zzaul().zzayf().zzj("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcdt)this).zzaul().zzayf().log("Timed out waiting for get user properties");
                return Collections.emptyList();
            }
            return object;
        }
    }

    public final Task<String> getAppInstanceId() {
        try {
            String string = ((zzcdt)this).zzaum().zzayn();
            if (string != null) {
                return Tasks.forResult((Object)string);
            }
            return Tasks.call((Executor)((zzcdt)this).zzauk().zzayt(), (Callable)new zzceh(this));
        }
        catch (Exception exception) {
            ((zzcdt)this).zzaul().zzayf().log("Failed to schedule task for getAppInstanceId");
            return Tasks.forException((Exception)exception);
        }
    }

    @Nullable
    public final String zzayn() {
        ((zzcdt)this).zzatv();
        return this.zziux.get();
    }

    final void zzjk(@Nullable String string) {
        this.zziux.set(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    final String zzbc(long l) {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzcdt)this).zzauk().zzg(new zzcei(this, atomicReference));
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                ((zzcdt)this).zzaul().zzayf().log("Interrupted waiting for app instance id");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
            return (String)atomicReference.get();
        }
    }

    @WorkerThread
    public final void setEventInterceptor(AppMeasurement.EventInterceptor eventInterceptor) {
        ((zzcdt)this).zzuj();
        ((zzcdt)this).zzatv();
        this.zzwk();
        if (eventInterceptor != null && eventInterceptor != this.zziuu) {
            zzbp.zza((this.zziuu == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zziuu = eventInterceptor;
    }

    public final void registerOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        ((zzcdt)this).zzatv();
        this.zzwk();
        zzbp.zzu((Object)onEventListener);
        if (!this.zziuv.add(onEventListener)) {
            ((zzcdt)this).zzaul().zzayf().log("OnEventListener already registered");
        }
    }

    public final void unregisterOnMeasurementEventListener(AppMeasurement.OnEventListener onEventListener) {
        ((zzcdt)this).zzatv();
        this.zzwk();
        zzbp.zzu((Object)onEventListener);
        if (!this.zziuv.remove(onEventListener)) {
            ((zzcdt)this).zzaul().zzayf().log("OnEventListener had not been registered");
        }
    }

    public static int getMaxUserProperties(String string) {
        zzbp.zzgg((String)string);
        return zzcax.zzawa();
    }

    public final void setConditionalUserProperty(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzbp.zzu((Object)conditionalUserProperty);
        ((zzcdt)this).zzatv();
        AppMeasurement.ConditionalUserProperty conditionalUserProperty2 = new AppMeasurement.ConditionalUserProperty(conditionalUserProperty);
        if (!TextUtils.isEmpty((CharSequence)conditionalUserProperty2.mAppId)) {
            ((zzcdt)this).zzaul().zzayf().log("Package name should be null when calling setConditionalUserProperty");
        }
        conditionalUserProperty2.mAppId = null;
        this.zza(conditionalUserProperty2);
    }

    public final void setConditionalUserPropertyAs(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzbp.zzu((Object)conditionalUserProperty);
        zzbp.zzgg((String)conditionalUserProperty.mAppId);
        ((zzcdt)this).zzatu();
        this.zza(new AppMeasurement.ConditionalUserProperty(conditionalUserProperty));
    }

    private final void zza(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        long l = ((zzcdt)this).zzvx().currentTimeMillis();
        zzbp.zzu((Object)conditionalUserProperty);
        zzbp.zzgg((String)conditionalUserProperty.mName);
        zzbp.zzgg((String)conditionalUserProperty.mOrigin);
        zzbp.zzu((Object)conditionalUserProperty.mValue);
        conditionalUserProperty.mCreationTimestamp = l;
        String string = conditionalUserProperty.mName;
        Object object = conditionalUserProperty.mValue;
        if (((zzcdt)this).zzauh().zzjy(string) != 0) {
            ((zzcdt)this).zzaul().zzayd().zzj("Invalid conditional user property name", ((zzcdt)this).zzaug().zzje(string));
            return;
        }
        if (((zzcdt)this).zzauh().zzl(string, object) != 0) {
            ((zzcdt)this).zzaul().zzayd().zze("Invalid conditional user property value", ((zzcdt)this).zzaug().zzje(string), object);
            return;
        }
        Object object2 = ((zzcdt)this).zzauh().zzm(string, object);
        if (object2 == null) {
            ((zzcdt)this).zzaul().zzayd().zze("Unable to normalize conditional user property value", ((zzcdt)this).zzaug().zzje(string), object);
            return;
        }
        conditionalUserProperty.mValue = object2;
        long l2 = conditionalUserProperty.mTriggerTimeout;
        if (!(TextUtils.isEmpty((CharSequence)conditionalUserProperty.mTriggerEventName) || l2 <= zzcax.zzawc() && l2 >= 1L)) {
            ((zzcdt)this).zzaul().zzayd().zze("Invalid conditional user property timeout", ((zzcdt)this).zzaug().zzje(string), l2);
            return;
        }
        long l3 = conditionalUserProperty.mTimeToLive;
        if (l3 > zzcax.zzawd() || l3 < 1L) {
            ((zzcdt)this).zzaul().zzayd().zze("Invalid conditional user property time to live", ((zzcdt)this).zzaug().zzje(string), l3);
            return;
        }
        ((zzcdt)this).zzauk().zzg(new zzcdy(this, conditionalUserProperty));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        ((zzcdt)this).zzatv();
        this.zza(null, string, string2, bundle);
    }

    public final void clearConditionalUserPropertyAs(String string, String string2, String string3, Bundle bundle) {
        zzbp.zzgg((String)string);
        ((zzcdt)this).zzatu();
        this.zza(string, string2, string3, bundle);
    }

    private final void zza(String string, String string2, String string3, Bundle bundle) {
        long l = ((zzcdt)this).zzvx().currentTimeMillis();
        zzbp.zzgg((String)string2);
        AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
        new AppMeasurement.ConditionalUserProperty().mAppId = string;
        conditionalUserProperty.mName = string2;
        conditionalUserProperty.mCreationTimestamp = l;
        if (string3 != null) {
            conditionalUserProperty.mExpiredEventName = string3;
            conditionalUserProperty.mExpiredEventParams = bundle;
        }
        ((zzcdt)this).zzauk().zzg(new zzcdz(this, conditionalUserProperty));
    }

    @WorkerThread
    private final void zzb(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcbk zzcbk2;
        zzcbk zzcbk3;
        zzcbk zzcbk4;
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzbp.zzu((Object)conditionalUserProperty);
        zzbp.zzgg((String)conditionalUserProperty.mName);
        zzbp.zzgg((String)conditionalUserProperty.mOrigin);
        zzbp.zzu((Object)conditionalUserProperty.mValue);
        if (!this.zziki.isEnabled()) {
            ((zzcdt)this).zzaul().zzayi().log("Conditional property not sent since Firebase Analytics is disabled");
            return;
        }
        zzcft zzcft2 = new zzcft(conditionalUserProperty.mName, conditionalUserProperty.mTriggeredTimestamp, conditionalUserProperty.mValue, conditionalUserProperty.mOrigin);
        try {
            zzcbk4 = ((zzcdt)this).zzauh().zza(conditionalUserProperty.mTriggeredEventName, conditionalUserProperty.mTriggeredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzcbk3 = ((zzcdt)this).zzauh().zza(conditionalUserProperty.mTimedOutEventName, conditionalUserProperty.mTimedOutEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
            zzcbk2 = ((zzcdt)this).zzauh().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzcav zzcav2 = new zzcav(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzcft2, conditionalUserProperty.mCreationTimestamp, false, conditionalUserProperty.mTriggerEventName, zzcbk3, conditionalUserProperty.mTriggerTimeout, zzcbk4, conditionalUserProperty.mTimeToLive, zzcbk2);
        ((zzcdt)this).zzauc().zzf(zzcav2);
    }

    @WorkerThread
    private final void zzc(AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcbk zzcbk2;
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzbp.zzu((Object)conditionalUserProperty);
        zzbp.zzgg((String)conditionalUserProperty.mName);
        if (!this.zziki.isEnabled()) {
            ((zzcdt)this).zzaul().zzayi().log("Conditional property not cleared since Firebase Analytics is disabled");
            return;
        }
        zzcft zzcft2 = new zzcft(conditionalUserProperty.mName, 0L, null, null);
        try {
            zzcbk2 = ((zzcdt)this).zzauh().zza(conditionalUserProperty.mExpiredEventName, conditionalUserProperty.mExpiredEventParams, conditionalUserProperty.mOrigin, conditionalUserProperty.mCreationTimestamp, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzcav zzcav2 = new zzcav(conditionalUserProperty.mAppId, conditionalUserProperty.mOrigin, zzcft2, conditionalUserProperty.mCreationTimestamp, conditionalUserProperty.mActive, conditionalUserProperty.mTriggerEventName, null, conditionalUserProperty.mTriggerTimeout, null, conditionalUserProperty.mTimeToLive, zzcbk2);
        ((zzcdt)this).zzauc().zzf(zzcav2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserProperties(String string, String string2) {
        ((zzcdt)this).zzatv();
        return this.zzk(null, string, string2);
    }

    public final List<AppMeasurement.ConditionalUserProperty> getConditionalUserPropertiesAs(String string, String string2, String string3) {
        zzbp.zzgg((String)string);
        ((zzcdt)this).zzatu();
        return this.zzk(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AppMeasurement.ConditionalUserProperty> zzk(String string, String string2, String string3) {
        if (((zzcdt)this).zzauk().zzays()) {
            ((zzcdt)this).zzaul().zzayd().log("Cannot get conditional user properties from analytics worker thread");
            return Collections.emptyList();
        }
        ((zzcdt)this).zzauk();
        if (zzccr.zzaq()) {
            ((zzcdt)this).zzaul().zzayd().log("Cannot get conditional user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zziki.zzauk().zzg(new zzcea(this, atomicReference, string, string2, string3));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcdt)this).zzaul().zzayf().zze("Interrupted waiting for get conditional user properties", string, interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcdt)this).zzaul().zzayf().zzj("Timed out waiting for get conditional user properties", string);
                return Collections.emptyList();
            }
            ArrayList<AppMeasurement.ConditionalUserProperty> arrayList = new ArrayList<AppMeasurement.ConditionalUserProperty>(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzcav zzcav2 = (zzcav)((Object)iterator.next());
                AppMeasurement.ConditionalUserProperty conditionalUserProperty = new AppMeasurement.ConditionalUserProperty();
                new AppMeasurement.ConditionalUserProperty().mAppId = string;
                conditionalUserProperty.mOrigin = string2;
                conditionalUserProperty.mCreationTimestamp = zzcav2.zzimi;
                conditionalUserProperty.mName = zzcav2.zzimh.name;
                conditionalUserProperty.mValue = zzcav2.zzimh.getValue();
                conditionalUserProperty.mActive = zzcav2.zzimj;
                conditionalUserProperty.mTriggerEventName = zzcav2.zzimk;
                if (zzcav2.zziml != null) {
                    conditionalUserProperty.mTimedOutEventName = zzcav2.zziml.name;
                    if (zzcav2.zziml.zzinr != null) {
                        conditionalUserProperty.mTimedOutEventParams = zzcav2.zziml.zzinr.zzaxz();
                    }
                }
                conditionalUserProperty.mTriggerTimeout = zzcav2.zzimm;
                if (zzcav2.zzimn != null) {
                    conditionalUserProperty.mTriggeredEventName = zzcav2.zzimn.name;
                    if (zzcav2.zzimn.zzinr != null) {
                        conditionalUserProperty.mTriggeredEventParams = zzcav2.zzimn.zzinr.zzaxz();
                    }
                }
                conditionalUserProperty.mTriggeredTimestamp = zzcav2.zzimh.zziwz;
                conditionalUserProperty.mTimeToLive = zzcav2.zzimo;
                if (zzcav2.zzimp != null) {
                    conditionalUserProperty.mExpiredEventName = zzcav2.zzimp.name;
                    if (zzcav2.zzimp.zzinr != null) {
                        conditionalUserProperty.mExpiredEventParams = zzcav2.zzimp.zzinr.zzaxz();
                    }
                }
                arrayList.add(conditionalUserProperty);
            }
            return arrayList;
        }
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        ((zzcdt)this).zzatv();
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> getUserPropertiesAs(String string, String string2, String string3, boolean bl) {
        zzbp.zzgg((String)string);
        ((zzcdt)this).zzatu();
        return this.zzb(string, string2, string3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (((zzcdt)this).zzauk().zzays()) {
            ((zzcdt)this).zzaul().zzayd().log("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        ((zzcdt)this).zzauk();
        if (zzccr.zzaq()) {
            ((zzcdt)this).zzaul().zzayd().log("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        Object object = atomicReference;
        synchronized (atomicReference) {
            this.zziki.zzauk().zzg(new zzceb(this, atomicReference, string, string2, string3, bl));
            try {
                atomicReference.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                ((zzcdt)this).zzaul().zzayf().zzj("Interrupted waiting for get user properties", interruptedException);
            }
            object = (List)atomicReference.get();
            if (object == null) {
                ((zzcdt)this).zzaul().zzayf().log("Timed out waiting for get user properties");
                return Collections.emptyMap();
            }
            ArrayMap arrayMap = new ArrayMap(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                zzcft zzcft2 = (zzcft)((Object)iterator.next());
                arrayMap.put(zzcft2.name, zzcft2.getValue());
            }
            return arrayMap;
        }
    }

    static /* synthetic */ void zza(zzcdw zzcdw2, boolean bl) {
        zzcdw2.zzbp(bl);
    }

    static /* synthetic */ void zza(zzcdw zzcdw2, String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        zzcdw2.zzb(string, string2, l, bundle, bl, bl2, bl3, string3);
    }

    static /* synthetic */ void zza(zzcdw zzcdw2, String string, String string2, Object object, long l) {
        zzcdw2.zza(string, string2, object, l);
    }

    static /* synthetic */ void zza(zzcdw zzcdw2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcdw2.zzb(conditionalUserProperty);
    }

    static /* synthetic */ void zzb(zzcdw zzcdw2, AppMeasurement.ConditionalUserProperty conditionalUserProperty) {
        zzcdw2.zzc(conditionalUserProperty);
    }
}

