/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzcas;
import com.google.android.gms.internal.zzcav;
import com.google.android.gms.internal.zzcax;
import com.google.android.gms.internal.zzcbc;
import com.google.android.gms.internal.zzcbk;
import com.google.android.gms.internal.zzcbo;
import com.google.android.gms.internal.zzccw;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzcdu;
import com.google.android.gms.internal.zzcep;
import com.google.android.gms.internal.zzceq;
import com.google.android.gms.internal.zzcer;
import com.google.android.gms.internal.zzces;
import com.google.android.gms.internal.zzcet;
import com.google.android.gms.internal.zzceu;
import com.google.android.gms.internal.zzcev;
import com.google.android.gms.internal.zzcew;
import com.google.android.gms.internal.zzcex;
import com.google.android.gms.internal.zzcey;
import com.google.android.gms.internal.zzcez;
import com.google.android.gms.internal.zzcfa;
import com.google.android.gms.internal.zzcfb;
import com.google.android.gms.internal.zzcfq;
import com.google.android.gms.internal.zzcft;
import com.google.android.gms.measurement.AppMeasurement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class zzceo
extends zzcdu {
    private final zzcfb zzivy;
    private zzcbo zzivz;
    private Boolean zziwa;
    private final zzcbc zziwb;
    private final zzcfq zziwc;
    private final List<Runnable> zziwd = new ArrayList<Runnable>();
    private final zzcbc zziwe;

    protected zzceo(zzccw zzccw2) {
        super(zzccw2);
        this.zziwc = new zzcfq(zzccw2.zzvx());
        this.zzivy = new zzcfb(this);
        this.zziwb = new zzcep(this, zzccw2);
        this.zziwe = new zzcet(this, zzccw2);
    }

    @Override
    protected final void zzuk() {
    }

    @WorkerThread
    public final boolean isConnected() {
        ((zzcdt)this).zzuj();
        this.zzwk();
        return this.zzivz != null;
    }

    @WorkerThread
    protected final void zzazp() {
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzcas zzcas2 = this.zzbr(true);
        this.zzj(new zzceu(this, zzcas2));
    }

    @WorkerThread
    final void zza(zzcbo zzcbo2, zzbck zzbck2, zzcas zzcas2) {
        ((zzcdt)this).zzuj();
        ((zzcdt)this).zzatv();
        this.zzwk();
        zzcax.zzawk();
        ArrayList<zzbck> arrayList = new ArrayList<zzbck>();
        int n = 100;
        zzcax.zzawt();
        for (int i = 0; i < 1001 && n == 100; ++i) {
            n = 0;
            List<zzbck> list = ((zzcdt)this).zzaue().zzdw(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (zzbck2 != null && n < 100) {
                arrayList.add(zzbck2);
            }
            ArrayList<zzbck> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                zzbck zzbck3 = (zzbck)e;
                if (zzbck3 instanceof zzcbk) {
                    try {
                        zzcbo2.zza((zzcbk)zzbck3, zzcas2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzcdt)this).zzaul().zzayd().zzj("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zzbck3 instanceof zzcft) {
                    try {
                        zzcbo2.zza((zzcft)zzbck3, zzcas2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzcdt)this).zzaul().zzayd().zzj("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zzbck3 instanceof zzcav) {
                    try {
                        zzcbo2.zza((zzcav)zzbck3, zzcas2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzcdt)this).zzaul().zzayd().zzj("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzcdt)this).zzaul().zzayd().log("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zzc(zzcbk zzcbk2, String string) {
        zzbp.zzu((Object)((Object)zzcbk2));
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzcax.zzawk();
        boolean bl = ((zzcdt)this).zzaue().zza(zzcbk2);
        zzcas zzcas2 = this.zzbr(true);
        this.zzj(new zzcev(this, true, bl, zzcbk2, zzcas2, string));
    }

    @WorkerThread
    protected final void zzf(zzcav zzcav2) {
        zzbp.zzu((Object)((Object)zzcav2));
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzcax.zzawk();
        boolean bl = ((zzcdt)this).zzaue().zzc(zzcav2);
        zzcav zzcav3 = new zzcav(zzcav2);
        zzcas zzcas2 = this.zzbr(true);
        this.zzj(new zzcew(this, true, bl, zzcav3, zzcas2, zzcav2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcav>> atomicReference, String string, String string2, String string3) {
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzcas zzcas2 = this.zzbr(false);
        this.zzj(new zzcex(this, atomicReference, string, string2, string3, zzcas2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcft>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzcas zzcas2 = this.zzbr(false);
        this.zzj(new zzcey(this, atomicReference, string, string2, string3, bl, zzcas2));
    }

    @WorkerThread
    protected final void zzb(zzcft zzcft2) {
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzcax.zzawk();
        boolean bl = ((zzcdt)this).zzaue().zza(zzcft2);
        zzcas zzcas2 = this.zzbr(true);
        this.zzj(new zzcez(this, bl, zzcft2, zzcas2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcft>> atomicReference, boolean bl) {
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzcas zzcas2 = this.zzbr(false);
        this.zzj(new zzcfa(this, atomicReference, zzcas2, bl));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzcas zzcas2 = this.zzbr(false);
        this.zzj(new zzceq(this, atomicReference, zzcas2));
    }

    @WorkerThread
    protected final void zzazq() {
        ((zzcdt)this).zzuj();
        this.zzwk();
        zzcas zzcas2 = this.zzbr(true);
        this.zzj(new zzcer(this, zzcas2));
    }

    @WorkerThread
    protected final void zza(AppMeasurement.zzb zzb2) {
        ((zzcdt)this).zzuj();
        this.zzwk();
        this.zzj(new zzces(this, zzb2));
    }

    @WorkerThread
    private final void zzww() {
        ((zzcdt)this).zzuj();
        this.zziwc.start();
        this.zziwb.zzs(zzcax.zzawh());
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzxh() {
        zzceo zzceo2;
        block11: {
            boolean bl;
            block12: {
                ((zzcdt)this).zzuj();
                this.zzwk();
                if (this.isConnected()) {
                    return;
                }
                if (this.zziwa != null) break block11;
                this.zziwa = ((zzcdt)this).zzaum().zzayo();
                if (this.zziwa != null) break block11;
                ((zzcdt)this).zzaul().zzayj().log("State of service unknown");
                zzceo2 = this;
                ((zzcdt)zzceo2).zzuj();
                zzceo2.zzwk();
                zzcax.zzawk();
                ((zzcdt)zzceo2).zzaul().zzayj().log("Checking service availability");
                switch (zze.zzaex().isGooglePlayServicesAvailable(((zzcdt)zzceo2).getContext())) {
                    case 0: {
                        ((zzcdt)zzceo2).zzaul().zzayj().log("Service available");
                        bl = true;
                        break block12;
                    }
                    case 1: {
                        ((zzcdt)zzceo2).zzaul().zzayj().log("Service missing");
                        break;
                    }
                    case 18: {
                        ((zzcdt)zzceo2).zzaul().zzayf().log("Service updating");
                        bl = true;
                        break block12;
                    }
                    case 2: {
                        ((zzcdt)zzceo2).zzaul().zzayi().log("Service container out of date");
                        bl = true;
                        break block12;
                    }
                    case 3: {
                        ((zzcdt)zzceo2).zzaul().zzayf().log("Service disabled");
                        break;
                    }
                    case 9: {
                        ((zzcdt)zzceo2).zzaul().zzayf().log("Service invalid");
                    }
                }
                bl = false;
            }
            this.zziwa = bl;
            ((zzcdt)this).zzaum().zzbm(this.zziwa);
        }
        if (this.zziwa.booleanValue()) {
            ((zzcdt)this).zzaul().zzayj().log("Using measurement service");
            this.zzivy.zzazs();
            return;
        }
        zzceo2 = this;
        zzcax.zzawk();
        PackageManager packageManager = ((zzcdt)zzceo2).getContext().getPackageManager();
        Intent intent = new Intent().setClassName(((zzcdt)zzceo2).getContext(), "com.google.android.gms.measurement.AppMeasurementService");
        List list = packageManager.queryIntentServices(intent, 65536);
        if (list != null && list.size() > 0) {
            ((zzcdt)this).zzaul().zzayj().log("Using local app measurement service");
            Intent intent2 = new Intent("com.google.android.gms.measurement.START");
            Context context = ((zzcdt)this).getContext();
            zzcax.zzawk();
            intent2.setComponent(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementService"));
            this.zzivy.zzk(intent2);
            return;
        }
        ((zzcdt)this).zzaul().zzayd().log("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
    }

    @WorkerThread
    protected final void zza(zzcbo zzcbo2) {
        ((zzcdt)this).zzuj();
        zzbp.zzu((Object)zzcbo2);
        this.zzivz = zzcbo2;
        this.zzww();
        this.zzazr();
    }

    @WorkerThread
    public final void disconnect() {
        ((zzcdt)this).zzuj();
        this.zzwk();
        try {
            zza.zzaky();
            zzcfb zzcfb2 = this.zzivy;
            Context context = ((zzcdt)this).getContext();
            context.unbindService((ServiceConnection)zzcfb2);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzivz = null;
    }

    @WorkerThread
    private final void onServiceDisconnected(ComponentName componentName) {
        ((zzcdt)this).zzuj();
        if (this.zzivz != null) {
            this.zzivz = null;
            ((zzcdt)this).zzaul().zzayj().zzj("Disconnected from device MeasurementService", componentName);
            zzceo zzceo2 = this;
            ((zzcdt)zzceo2).zzuj();
            zzceo2.zzxh();
        }
    }

    @WorkerThread
    private final void zzwx() {
        ((zzcdt)this).zzuj();
        if (!this.isConnected()) {
            return;
        }
        ((zzcdt)this).zzaul().zzayj().log("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private final void zzj(Runnable runnable) throws IllegalStateException {
        ((zzcdt)this).zzuj();
        if (this.isConnected()) {
            runnable.run();
            return;
        }
        if ((long)this.zziwd.size() >= zzcax.zzawp()) {
            ((zzcdt)this).zzaul().zzayd().log("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zziwd.add(runnable);
        this.zziwe.zzs(60000L);
        this.zzxh();
    }

    @WorkerThread
    private final void zzazr() {
        ((zzcdt)this).zzuj();
        ((zzcdt)this).zzaul().zzayj().zzj("Processing queued up service tasks", this.zziwd.size());
        for (Runnable runnable : this.zziwd) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                ((zzcdt)this).zzaul().zzayd().zzj("Task exception while flushing queue", throwable);
            }
        }
        this.zziwd.clear();
        this.zziwe.cancel();
    }

    @WorkerThread
    @Nullable
    private final zzcas zzbr(boolean bl) {
        zzcax.zzawk();
        return ((zzcdt)this).zzaua().zzjb(bl ? ((zzcdt)this).zzaul().zzayk() : null);
    }

    static /* synthetic */ zzcfb zza(zzceo zzceo2) {
        return zzceo2.zzivy;
    }

    static /* synthetic */ void zza(zzceo zzceo2, ComponentName componentName) {
        zzceo2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ zzcbo zza(zzceo zzceo2, zzcbo zzcbo2) {
        zzceo2.zzivz = null;
        return null;
    }

    static /* synthetic */ void zzb(zzceo zzceo2) {
        zzceo2.zzazr();
    }

    static /* synthetic */ void zzc(zzceo zzceo2) {
        zzceo2.zzwx();
    }

    static /* synthetic */ zzcbo zzd(zzceo zzceo2) {
        return zzceo2.zzivz;
    }

    static /* synthetic */ void zze(zzceo zzceo2) {
        zzceo2.zzww();
    }
}

