/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzg;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.internal.zzcbo;
import com.google.android.gms.internal.zzcbq;
import com.google.android.gms.internal.zzcbv;
import com.google.android.gms.internal.zzcbw;
import com.google.android.gms.internal.zzcdt;
import com.google.android.gms.internal.zzceo;
import com.google.android.gms.internal.zzcfc;
import com.google.android.gms.internal.zzcfd;
import com.google.android.gms.internal.zzcfe;
import com.google.android.gms.internal.zzcff;
import com.google.android.gms.internal.zzcfg;

public final class zzcfb
implements ServiceConnection,
zzf,
zzg {
    private volatile boolean zziwm;
    private volatile zzcbv zziwn;
    final /* synthetic */ zzceo zziwf;

    protected zzcfb(zzceo zzceo2) {
        this.zziwf = zzceo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzk(Intent intent) {
        ((zzcdt)this.zziwf).zzuj();
        Context context = ((zzcdt)this.zziwf).getContext();
        zza zza2 = zza.zzaky();
        zzcfb zzcfb2 = this;
        synchronized (zzcfb2) {
            if (this.zziwm) {
                ((zzcdt)this.zziwf).zzaul().zzayj().log("Connection attempt already in progress");
                return;
            }
            this.zziwm = true;
            zza2.zza(context, intent, (ServiceConnection)zzceo.zza(this.zziwf), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        zzbp.zzfy((String)"MeasurementServiceConnection.onServiceConnected");
        zzcfb zzcfb2 = this;
        synchronized (zzcfb2) {
            IInterface iInterface;
            String string;
            if (iBinder == null) {
                this.zziwm = false;
                ((zzcdt)this.zziwf).zzaul().zzayd().log("Service connected with null binder");
                return;
            }
            zzcbo zzcbo2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IBinder iBinder2 = iBinder;
                    zzcbo2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzcbo ? (zzcbo)iInterface : new zzcbq(iBinder2));
                    ((zzcdt)this.zziwf).zzaul().zzayj().log("Bound to IMeasurementService interface");
                } else {
                    ((zzcdt)this.zziwf).zzaul().zzayd().zzj("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzcdt)this.zziwf).zzaul().zzayd().log("Service connect failed to get IMeasurementService");
            }
            if (zzcbo2 == null) {
                this.zziwm = false;
                try {
                    zza.zzaky();
                    zzcfb zzcfb3 = zzceo.zza(this.zziwf);
                    iInterface = ((zzcdt)this.zziwf).getContext();
                    iInterface.unbindService((ServiceConnection)zzcfb3);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzcbo2;
                ((zzcdt)this.zziwf).zzauk().zzg(new zzcfc(this, (zzcbo)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        zzbp.zzfy((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzcdt)this.zziwf).zzaul().zzayi().log("Service disconnected");
        ((zzcdt)this.zziwf).zzauk().zzg(new zzcfd(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzazs() {
        ((zzcdt)this.zziwf).zzuj();
        Context context = ((zzcdt)this.zziwf).getContext();
        zzcfb zzcfb2 = this;
        synchronized (zzcfb2) {
            if (this.zziwm) {
                ((zzcdt)this.zziwf).zzaul().zzayj().log("Connection attempt already in progress");
                return;
            }
            if (this.zziwn != null) {
                ((zzcdt)this.zziwf).zzaul().zzayj().log("Already awaiting connection attempt");
                return;
            }
            this.zziwn = new zzcbv(context, Looper.getMainLooper(), this, this);
            ((zzcdt)this.zziwf).zzaul().zzayj().log("Connecting to remote service");
            this.zziwm = true;
            this.zziwn.zzajf();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        zzbp.zzfy((String)"MeasurementServiceConnection.onConnected");
        zzcfb zzcfb2 = this;
        synchronized (zzcfb2) {
            try {
                zzcbo zzcbo2 = (zzcbo)this.zziwn.zzajj();
                this.zziwn = null;
                ((zzcdt)this.zziwf).zzauk().zzg(new zzcfe(this, zzcbo2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zziwn = null;
                this.zziwm = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        zzbp.zzfy((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzcdt)this.zziwf).zzaul().zzayi().log("Service connection suspended");
        ((zzcdt)this.zziwf).zzauk().zzg(new zzcff(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        zzbp.zzfy((String)"MeasurementServiceConnection.onConnectionFailed");
        zzcbw zzcbw2 = this.zziwf.zziki.zzayw();
        if (zzcbw2 != null) {
            zzcbw2.zzayf().zzj("Service connection failed", connectionResult);
        }
        zzcfb zzcfb2 = this;
        synchronized (zzcfb2) {
            this.zziwm = false;
            this.zziwn = null;
        }
        ((zzcdt)this.zziwf).zzauk().zzg(new zzcfg(this));
    }

    static /* synthetic */ boolean zza(zzcfb zzcfb2, boolean bl) {
        zzcfb2.zziwm = false;
        return false;
    }
}

