/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteFullException;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.WorkerThread;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbel;
import com.google.android.gms.internal.zzcfi;
import com.google.android.gms.internal.zzcfx;
import com.google.android.gms.internal.zzcgg;
import com.google.android.gms.internal.zzchj;
import com.google.android.gms.internal.zzcih;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzckk;
import com.google.android.gms.internal.zzckn;
import java.util.ArrayList;
import java.util.List;

public final class zzcgf
extends zzcii {
    private final zzcgg zziys = new zzcgg(this, ((zzcih)this).getContext(), "google_app_measurement_local.db");
    private boolean zziyt;

    zzcgf(zzchj zzchj2) {
        super(zzchj2);
    }

    @Override
    protected final boolean zzaxn() {
        return false;
    }

    @WorkerThread
    public final void resetAnalyticsData() {
        ((zzcih)this).zzut();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            int n = 0 + sQLiteDatabase.delete("messages", null, null);
            if (n > 0) {
                ((zzcih)this).zzawm().zzayx().zzj("Reset local analytics data. records", n);
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            ((zzcih)this).zzawm().zzayr().zzj("Error resetting local analytics data. error", (Object)sQLiteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=11)
    @WorkerThread
    private final boolean zzb(int n, byte[] byArray) {
        ((zzcih)this).zzut();
        if (this.zziyt) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("type", Integer.valueOf(n));
        contentValues.put("entry", byArray);
        int n2 = 5;
        int n3 = 0;
        while (true) {
            block20: {
                if (n3 >= 5) {
                    ((zzcih)this).zzawm().zzayt().log("Failed to write entry to local database");
                    return false;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.getWritableDatabase();
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.beginTransaction();
                        long l = 0L;
                        cursor = sQLiteDatabase.rawQuery("select count(1) from messages", null);
                        if (cursor != null && cursor.moveToFirst()) {
                            l = cursor.getLong(0);
                        }
                        if (l >= 100000L) {
                            ((zzcih)this).zzawm().zzayr().log("Data loss, local db full");
                            long l2 = 100000L - l + 1L;
                            long l3 = sQLiteDatabase.delete("messages", "rowid in (select rowid from messages order by rowid asc limit ?)", new String[]{Long.toString(l2)});
                            if (l3 != l2) {
                                ((zzcih)this).zzawm().zzayr().zzd("Different delete count than expected in local db. expected, received, difference", l2, l3, l2 - l3);
                            }
                        }
                        sQLiteDatabase.insertOrThrow("messages", null, contentValues);
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        return true;
                    }
                    this.zziyt = true;
                    if (sQLiteDatabase == null) return false;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzcih)this).zzawm().zzayr().zzj("Error writing entry to local database", (Object)sQLiteFullException);
                    this.zziyt = true;
                    break block20;
                }
                catch (SQLiteException sQLiteException) {
                    if (Build.VERSION.SDK_INT >= 11 && sQLiteException instanceof SQLiteDatabaseLockedException) {
                        SystemClock.sleep((long)n2);
                        n2 += 20;
                        break block20;
                    } else {
                        if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                            sQLiteDatabase.endTransaction();
                        }
                        ((zzcih)this).zzawm().zzayr().zzj("Error writing entry to local database", (Object)sQLiteException);
                        this.zziyt = true;
                    }
                    break block20;
                }
                sQLiteDatabase.close();
                return false;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    public final boolean zza(zzcfx zzcfx2) {
        Parcel parcel = Parcel.obtain();
        zzcfx2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzcih)this).zzawm().zzayt().log("Event is too long for local database. Sending event directly to service");
            return false;
        }
        return this.zzb(0, byArray);
    }

    public final boolean zza(zzckk zzckk2) {
        Parcel parcel = Parcel.obtain();
        zzckk2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzcih)this).zzawm().zzayt().log("User property too long for local database. Sending directly to service");
            return false;
        }
        return this.zzb(1, byArray);
    }

    public final boolean zzc(zzcfi zzcfi2) {
        ((zzcih)this).zzawi();
        byte[] byArray = zzckn.zza((Parcelable)zzcfi2);
        if (byArray.length > 131072) {
            ((zzcih)this).zzawm().zzayt().log("Conditional user property too long for local database. Sending directly to service");
            return false;
        }
        return this.zzb(2, byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=11)
    public final List<zzbej> zzeb(int n) {
        ((zzcih)this).zzut();
        if (this.zziyt) {
            return null;
        }
        ArrayList<zzbej> arrayList = new ArrayList<zzbej>();
        if (!((zzcih)this).getContext().getDatabasePath("google_app_measurement_local.db").exists()) {
            return arrayList;
        }
        int n2 = 5;
        int n3 = 0;
        while (true) {
            block41: {
                if (n3 >= 5) {
                    ((zzcih)this).zzawm().zzayt().log("Failed to read events from database in reasonable time");
                    return null;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.getWritableDatabase();
                    if (sQLiteDatabase != null) {
                        Object object;
                        sQLiteDatabase.beginTransaction();
                        cursor = sQLiteDatabase.query("messages", new String[]{"rowid", "type", "entry"}, null, null, null, null, "rowid asc", Integer.toString(100));
                        long l = -1L;
                        while (cursor.moveToNext()) {
                            zzbej zzbej2;
                            Parcel parcel;
                            l = cursor.getLong(0);
                            int n4 = cursor.getInt(1);
                            object = cursor.getBlob(2);
                            if (n4 == 0) {
                                parcel = Parcel.obtain();
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    zzbej2 = (zzcfx)((Object)zzcfx.CREATOR.createFromParcel(parcel));
                                }
                                catch (zzbel zzbel2) {
                                    ((zzcih)this).zzawm().zzayr().log("Failed to load event from local database");
                                    continue;
                                }
                                finally {
                                    parcel.recycle();
                                    continue;
                                }
                                if (zzbej2 == null) continue;
                                arrayList.add(zzbej2);
                                continue;
                            }
                            if (n4 == 1) {
                                parcel = Parcel.obtain();
                                zzbej2 = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    zzbej2 = (zzckk)((Object)zzckk.CREATOR.createFromParcel(parcel));
                                }
                                catch (zzbel zzbel3) {
                                    ((zzcih)this).zzawm().zzayr().log("Failed to load user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (zzbej2 == null) continue;
                                arrayList.add(zzbej2);
                                continue;
                            }
                            if (n4 == 2) {
                                parcel = Parcel.obtain();
                                zzbej2 = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    zzbej2 = (zzcfi)((Object)zzcfi.CREATOR.createFromParcel(parcel));
                                }
                                catch (zzbel zzbel4) {
                                    ((zzcih)this).zzawm().zzayr().log("Failed to load user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (zzbej2 == null) continue;
                                arrayList.add(zzbej2);
                                continue;
                            }
                            ((zzcih)this).zzawm().zzayr().log("Unknown record type in local database");
                        }
                        if (sQLiteDatabase.delete("messages", "rowid <= ?", new String[]{Long.toString(l)}) < arrayList.size()) {
                            ((zzcih)this).zzawm().zzayr().log("Fewer entries removed from local database than expected");
                        }
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        object = arrayList;
                        return object;
                    }
                    this.zziyt = true;
                    if (sQLiteDatabase == null) return null;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzcih)this).zzawm().zzayr().zzj("Error reading entries from local database", (Object)sQLiteFullException);
                    this.zziyt = true;
                    break block41;
                }
                catch (SQLiteException sQLiteException) {
                    if (Build.VERSION.SDK_INT >= 11 && sQLiteException instanceof SQLiteDatabaseLockedException) {
                        SystemClock.sleep((long)n2);
                        n2 += 20;
                        break block41;
                    } else {
                        if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                            sQLiteDatabase.endTransaction();
                        }
                        ((zzcih)this).zzawm().zzayr().zzj("Error reading entries from local database", (Object)sQLiteException);
                        this.zziyt = true;
                    }
                    break block41;
                }
                sQLiteDatabase.close();
                return null;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    @WorkerThread
    private final SQLiteDatabase getWritableDatabase() {
        if (this.zziyt) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.zziys.getWritableDatabase();
        if (sQLiteDatabase == null) {
            this.zziyt = true;
            return null;
        }
        return sQLiteDatabase;
    }
}

