/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzcgj;
import com.google.android.gms.internal.zzchb;
import com.google.android.gms.internal.zzchc;
import com.google.android.gms.internal.zzchj;

public final class zzcha {
    private final zzchc zzjax;

    public zzcha(zzchc zzchc2) {
        zzbq.checkNotNull((Object)zzchc2);
        this.zzjax = zzchc2;
    }

    public static boolean zzbi(Context context) {
        zzbq.checkNotNull((Object)context);
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 2);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @MainThread
    public final void onReceive(Context context, Intent intent) {
        zzchj zzchj2 = zzchj.zzdu(context);
        zzcgj zzcgj2 = zzchj2.zzawm();
        if (intent == null) {
            zzcgj2.zzayt().log("Receiver called with null intent");
            return;
        }
        String string = intent.getAction();
        zzcgj2.zzayx().zzj("Local receiver got", string);
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            Intent intent2 = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            zzcgj2.zzayx().log("Starting wakeful intent.");
            this.zzjax.doStartService(context, intent2);
            return;
        }
        if ("com.android.vending.INSTALL_REFERRER".equals(string)) {
            BroadcastReceiver.PendingResult pendingResult = this.zzjax.doGoAsync();
            String string2 = intent.getStringExtra("referrer");
            if (string2 == null) {
                zzcgj2.zzayx().log("Install referrer extras are null");
                if (pendingResult != null) {
                    pendingResult.finish();
                }
                return;
            }
            zzcgj2.zzayv().zzj("Install referrer extras are", string2);
            if (!string2.contains("?")) {
                String string3 = String.valueOf(string2);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            Uri uri = Uri.parse((String)string2);
            Bundle bundle = zzchj2.zzawi().zzp(uri);
            if (bundle == null) {
                zzcgj2.zzayx().log("No campaign defined in install referrer broadcast");
                if (pendingResult != null) {
                    pendingResult.finish();
                    return;
                }
            } else {
                long l = intent.getLongExtra("referrer_timestamp_seconds", 0L) * 1000L;
                if (l == 0L) {
                    zzcgj2.zzayt().log("Install referrer is missing timestamp");
                }
                zzchj2.zzawl().zzg(new zzchb(this, zzchj2, l, bundle, context, zzcgj2, pendingResult));
            }
        }
    }
}

